#version 330

uniform float my_time;
uniform sampler2D my_texture;

in vec2 texCoord;
out vec4 my_out;

float resX = 1920;
float resY = 1080;

float v=.002*my_time, 
	mat; //material identifier

uniform float rotateStart;// = 10000/*4KS:RotateStart*/;
uniform float rotateDuration;// = 4000/*4KS:RotateDuration*/;
float rotate = smoothstep( rotateStart, rotateStart + rotateDuration, my_time); // 0 = landscape, 1 = portrait

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(.0,max(d.x,max(d.y,d.z))) + length(max(d,0.0));
}

void rot(inout vec2 w,float h)
{
  w=w*cos(h)+sin(h)*vec2(w.y,-w.x);
}


 float rand(float v)
 {
	return fract(v*6.97/*4KS:Rand_Seed1:5*/*fract(v*123.47/*4KS:Rand_Seed2:5*/));
}

// between -.5 and .5
float noise(vec3 x) 
{ 
	vec3 v=floor(x);
	x-=v;
	x*=x*(3-2*x); 
	float m=v.x// scale factor 1 is fixed here 
		  +v.y*19+38*v.z; 
	
	return mix(mix(mix(rand(m+18),
					   rand(m+19),x.x),
				   mix(rand(m+37),
				       rand(m+38),x.x),x.y),
			   (x.z > 0.0)?mix(mix(rand(m+56),
						   rand(m+57),x.x),
					   mix(rand(m+75),
					       rand(m+76),x.x),x.y):0,x.z)-.5;
} 

float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float sdSquareTorus( vec3 p, vec3 t )
{
  vec2 q = vec2(length(max(abs(p.xz)-t.x,0))-t.z, p.y);
  return length(q)-t.y;
}

float scene(vec3 r) // distance
{
	rot(r.yz, -3.1416/2);

	rot(r.xz, rotate * 3.1416/2);

	rot(r.yx, (1-rotate)*.3/*4KS:WobbleAmpl*/*sin(v*1.2/*4KS:WobbleFreq*/)); // landscape rotate
	rot(r.yz, rotate*.6/*4KS:WobbleAmpl*/*sin(v*.7/*4KS:WobbleFreq2*/)); // portrait rotate
	

	float d=999999;	
	mat = 0;

	vec2 spacing = vec2(.29/*4KS:PinSpacingX*/, .35/*4KS:PinSpacingZ*/);


	
	float d2 = sdBox( r, vec3(10/*4KS:BoxWidth*/ + .31/*4KS:BoxEdgeThickness*/, .5/*4KS:PinMinHeight*/+ .31/*4KS:BoxEdgeThickness*/, 6/*4KS:BoxHeight*/+.31/*4KS:BoxEdgeThickness*/) );
	d2 = max(d2, -sdBox( r+vec3(0,3,0), vec3(10/*4KS:BoxWidth*/, 4, 6/*4KS:BoxHeight*/) ) );
	if ( d2<d)
		mat=2, d=d2;

	float bbox =  sdBox( r, vec3(10/*4KS:BoxWidth*/, .5/*4KS:PinMinHeight*/+ 1.4/*4KS:PinExtraHeight*/, 6/*4KS:BoxHeight*/) );
	if ( bbox < 1/*4KS:BBoxLimit*/)
	{
		vec3 r2 = r;
		float d2 = .5/*4KS:MaxStep*/; // Still needed? or use cell guards?
		
		r.xz+=.5*spacing;
		vec2 cell = floor (r.xz/spacing);
		bool even = mod(cell.x,2) < .1;
		if ( ! even )
		{		
			r.z +=.5*spacing.y;
			cell = floor (r.xz/spacing);
			cell.y -= .5*spacing.y;
		}

		cell *= spacing;	
		r.xz = mod(r.xz, spacing) - .5*spacing;
	
		for (int x = -1; x < 2; x++)
			for (int y = -1; y < 2; y++)
			{
				// check only center plus 6 surrounding locations, not all 9 from the shifted grid
				if (even && x != 0 && y == -1)
					continue;

				float shift = x != 0? .5:0; // doesn't depend on even or odd, strange enough.

				float height = 1.4/*4KS:PinExtraHeight*/*
							texture2D(my_texture,vec2(0,1)+ vec2(1,-1)*(cell+ spacing * vec2( -x,-y+shift))/ vec2(10/*4KS:BoxWidth*/, 6/*4KS:BoxHeight*/)*.5 +.5).x;

				// parabolic motion

				height = .5/*4KS:PinMinHeight*/+ height * max(0,1- max(0,abs(fract(v*.2/*4KS:AppearFreq*/)-.5)-.15/*4KS:AppearDelay*/)*4/*4KS:AppearAmpl*/);


				vec3 r2 = r + spacing.xxy * vec3(x,0,y-shift);

				d2 = min(d2, max(-r2.y,max(r2.y - height,length(r2.xz)-.05/*4KS:PinRadius*/)));
				r2.y = abs(r2.y-height)+ .12/*4KS:PinTopVisiblePart*/;
				d2 = min(d2, length(r2)-.19/*4KS:PinTopRadius*/);
			
			}

		d2 = max(d2, sdBox( r2+vec3(0,3,0), vec3(10/*4KS:BoxWidth*/, 10, 6/*4KS:BoxHeight*/) ) );
		if ( d2 < d)
			mat=1,d=d2;	
	}
	else d = min(d,bbox);

	return d;
}



//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// x= specular brightness? Range .1 to .3
// matParam.y = F0 fresnel 
// matParam.z = Roughness (Alpha) in Trowbridge-Reitz NDF (Normal Distribution function)
vec3 brdf2(vec3 lightdir, vec3 eyedir,vec3 norm,vec3 color1,vec3 matParam)
{
  vec3 halfvec=normalize(eyedir+lightdir); // if both 1, div by 2?
  float roughSq=matParam.z*matParam.z,			// Precalc FFS!
	    lightContrib=max(0,dot(norm,lightdir)),
		rimContrib=max(0,dot(norm,halfvec)),
		k=rimContrib*rimContrib*(roughSq*roughSq-1)+1,
		hRoughSq=roughSq*.5;
  return lightContrib*( color1*(1-matParam.y)+ // diffuse
	                    matParam.x*
						roughSq*roughSq / (3.14*k*k) * // Trowbridge-Reitz NDF
						  (matParam.y + (1-matParam.y)*pow(1-max(0,dot(lightdir,halfvec)),5)) / // Schlick approx Fresnel
						    ((lightContrib*(1-hRoughSq)+hRoughSq)*(max(0,dot(norm,eyedir))*(1-hRoughSq)+hRoughSq)));
}

void GetMaterial(vec3 p, float tmat, inout vec3 t, out vec3 matcol, out vec3 matprop, out vec3 emissive) //
{	
	if( tmat==0) // ground	
	{			
		// generic wavy pattern
		p.x += 1.8/*4KS:MaterWoodWave1Ampl*/*sin(p.z*9.3/*4KS:MaterWoodWave1Freq*/);

		p.z += .1/*4KS:MaterWoodWaveNoiseAmpl*/*noise(p*.75/*4KS:MaterWoodWaveNoiseScale*/);

		p.x += 60/*4KS:MaterWoodWave2Ampl*/*sin(p.z*1/*4KS:MaterWoodWave2Freq*/);

		// nerves
		float intensity = pow(max(0,.36/*4KS:MaterWoodNerveOffset*/+.66/*4KS:MaterWoodNerveAmpl*/*sin(p.x*1.13/*4KS:MaterWoodNerveFreq*/)),11/*4KS:MaterWoodNervePow*/);
		// micro grain
		intensity += .7/*4KS:MaterWoodGrainAmpl*/*noise(p*17/*4KS:MaterWoodGrainScale*/);
		// darkening
		intensity += 2.5/*4KS:MaterWoodStainAmpl*/*noise(p*.2/*4KS:MaterWoodStainScale*/);
		
		matcol = 0.01*mix(vec3(.83/*4KS:MaterWood0ColR*/,.48/*4KS:MaterWood0ColG*/,.16/*4KS:MaterWood0ColB*/),
						  vec3(.45/*4KS:MaterWood1ColR*/,.15/*4KS:MaterWood1ColG*/,.09/*4KS:MaterWood1ColB*/),
						  max(0, min(1,intensity)));


		matprop = vec3(.016/*4KS:MaterWood0Spec:3*/,.261/*4KS:MaterWood0Fresnel:3*/,.656/*4KS:MaterWood0Rough:3*/);	


	}
	if( tmat==1) // chrome
	{		
		matcol = 0.01*vec3(.21/*4KS:MaterChromeColR*/,.21/*4KS:MaterChromeColG*/,.21/*4KS:MaterChromeColB*/);
		matprop = vec3(.008/*4KS:MaterChromeSpec:3*/,.153/*4KS:MaterChromeFresnel:3*/,.18/*4KS:MaterChromeRough:3*/);	
	}	

	if( tmat==2) // pedestal. TODO: marble?
	{		
		matcol = 0.01*vec3(.09/*4KS:MaterPedestalColR*/,.08/*4KS:MaterPedestalColG*/,.09/*4KS:MaterPedestalColB*/);
		matprop = vec3(.001/*4KS:MaterPedestalSpec:3*/,.002/*4KS:MaterPedestalFresnel:3*/,.233/*4KS:MaterPedestalRough:3*/);	
	}	
	
}

float soft;
float FindDistance( vec3 m, vec3 g, float nrSteps, float maxDist, float pixelRadius, out float skyHit, out vec3 p)
{
	soft=4/*4KS:ShadowSoftness*/;
	
	skyHit = 0; // reuse skyhit as distance travelled
	float candidate_error = 1000;
	float candidate_t = .01/*4KS:HitDist*/; // TODO: does this make sense, or set to 0?
	float candidate_z = maxDist;
	
	for (float i = 0; i < nrSteps; ++i)
	{
		float signedRadius = scene(m*skyHit + g);
	
		float error = abs(signedRadius) / skyHit;
		if ( error < candidate_error) 
		{
			candidate_t = skyHit;
			candidate_error = error;
			candidate_z = signedRadius;
		}
		if (error < pixelRadius || skyHit > maxDist)
			break;

		soft = min( soft, (13/*4KS:ShadowSharpness*/*signedRadius)*(1./skyHit));

		skyHit += signedRadius;
	}

	
	 if (skyHit > maxDist || candidate_error > pixelRadius*4/*4KS:RMM_PixelsCorrection*/ )
	 {
		 p=m*skyHit+g; // SkyHit
		 skyHit = 1;
	 }
	 else
	 {
		soft=0;
		p = m*candidate_t + g;
		skyHit = 0;
	 }

	 return candidate_z;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void main()
{
	vec2 m2=(2*gl_FragCoord.xy/vec2(resX,resY)-1)*vec2(resX/resY,1);

	float z;
	float e=0;
	
	vec3 m=normalize(vec3(m2, 4/*4KS:CamFOV*/)),	

		//todo: move light
	sunL=normalize(vec3(+1.09/*4KS:SunX*/,.56/*4KS:SunY*/,-2.15/*4KS:SunZ*/));
		
	// camera
	vec3 g= mix( vec3(-0/*4KS:CamLandscapeX*/,.3/*4KS:CamLandscapeY*/,-35.7/*4KS:CamLandscapeZ*/),
				 vec3(-5.7/*4KS:CamPortaitX*/,-.03/*4KS:CamPortraitY*/,-50/*4KS:CamPortraitZ*/), rotate );

	rot(m.zy,+0/*4KS:CamLookdown*/ );
	rot(m.xz,+0/*4KS:CamLookLeft*/);
	
	
	g+=.03/*4KS:CamMotionNoiseAmpl*/*vec3(noise(vec3(g.xy,3*v*1.5/*4KS:CamMotionNoiseFreq*/)),
										 noise(vec3(g.x,2*v*1.5/*4KS:CamMotionNoiseFreq*/,g.z)),
										 noise(vec3(v*1.5/*4KS:CamMotionNoiseFreq*/,g.yz)));

	
	vec3 i, // color current ray
		p, // endpoint ray 1
	
		start = g,
		dir = m,
		pt = g;
	
	vec3 reflectInt=vec3(0);
	for (float ray = 0; ray <1; ray++)
	{
		vec3 matcol, matprop, tempcol;
	
		float skyHit;
			z=FindDistance(dir, start, 140./*4KS:RayMarchSteps1:f*/, 1300./*4KS:Horizon:f*/, (.11/*4KS:RMM_PixelRad:3*/+ray*4/*4KS:RMM_PixelRadRefl:3*/) / (.5*resY), skyHit, pt);
	 
		float tmat = mat;
		
		vec3 t,a=vec3(0/*4KS:SkyColR*/,0/*4KS:SkyColG*/,0/*4KS:SkyColB*/)+// blue sky
			(ray==0?
			25/*4KS:SunIntensity*/*vec3(1/*4KS:SunColR*/,.96/*4KS:SunColG*/,.92/*4KS:SunColB*/)*pow(max(dot(dir,sunL),.0),200/*4KS:SunSize:0*/):vec3(0)); // yellow sun

		float occ=1;
		
		t=normalize(vec3(scene(pt+vec3(.0001/*4KS:RM_Epsilon:5*/,0,0)),
							  scene(pt+vec3(0,.0001/*4KS:RM_Epsilon:5*/,0)),
							  scene(pt+vec3(0,0,.0001/*4KS:RM_Epsilon:5*/)))-z); //normal

		vec3 emissive = vec3(0);

		// inline?
		GetMaterial(pt, tmat, t, matcol, matprop, emissive);
			
		for(e=1;e<6;e++)
			occ-=(e*.3/*4KS:AO_Intense*/-scene(pt+t*e*.3/*4KS:AO_Distance*/))/pow(2/*4KS:AO_Falloff*/,e);
	
		float temp1;
		vec3 temp2;
		FindDistance( sunL, pt+t*.01/*4KS:HitDist*/*3/*4KS:ShadowJumpstart*/, 68.2/*4KS:ShadowSteps:f*/, 50./*4KS:ShadowMaxDist:f*/, (4/*4KS:RMM_PixelRadShad:3*/+ray*4/*4KS:RMM_PixelRadRefl:3*/) /(resY*.5) / (resY*.5) , temp1, temp2);

		tempcol =max( // sun Intensity
					brdf2(sunL, -dir, t, matcol, matprop ) * 25/*4KS:SunIntensity*/*pow(vec3(1/*4KS:SunColR*/,.96/*4KS:SunColG*/,.92/*4KS:SunColB*/)
					  									   * vec3(clamp( soft, 0,1) ),
																 vec3(1/*4KS:SunShadowR*/,.9/*4KS:SunShadowG*/,.8/*4KS:SunShadowB*/))
					// Sky Intensity: don't use brdf or you get extra specular highlight. Just use normal.y!
				  + occ * (t.y+1) * matcol * 10.14/*4KS:SkyIntensity*/*vec3(0/*4KS:SkyColR*/,0/*4KS:SkyColG*/,0/*4KS:SkyColB*/)

				 // emmisive
				  + emissive,
				  0.);
			
		if(skyHit > 0.0) // pure sky
			tempcol=a;

		vec3 fog=mix(a,// sky sun horizonfog
				25/*4KS:SunIntensity*/*vec3(1/*4KS:SunColR*/,.96/*4KS:SunColG*/,.92/*4KS:SunColB*/),// yellowish
				pow(max(dot(dir,sunL),.0),200/*4KS:SunSize:0*/));

		tempcol=mix(tempcol,fog,1.-exp(-length(pt.xz-start.xz)*.002/*4KS:FogPower:4*/));
			
		
		i = tempcol; // reflection to be added later			
		p = pt;
			
	}	

	// debug: show the texture overlayed on the screen
	//i+= texture2D(my_texture,gl_FragCoord.xy/vec2(resX,resY)).xyz;
			
		float rf2_1=dot(m2,m2)*.1/*4KS:PostVignettingAmount*/+1/*4KS:PostVignettingFade*/;
	my_out = smoothstep(83,78,v)*vec4(pow(i*(1-.2/*4KS:PostGrainAmount*/+.2/*4KS:PostGrainAmount*/*rand(dot(m2,m2)*1000/*4KS:PostGrainScaling*/+v)),
						 vec3(.45/*4KS:PostLightToneMapping*/))/(rf2_1*rf2_1), 1.0);
}