#version 330

uniform float my_time;
uniform sampler2D my_texture;

in vec2 texCoord;
out vec4 my_out;

float resX = 1920;
float resY = 1080;

const vec3 color1 = vec3(0, 0, 0);
const vec3 color2 = vec3(150./255., 13./255., 202./255.);
const vec3 color3 = vec3(0, 126./255., 1);
const vec3 color4 = vec3(0, 239./255., 1);
const vec3 color5 = vec3(0, 245./255., 32./255.);
const vec3 color6 = vec3(1, 0, 0);

vec3 phoenix(vec2 coord) {
    float y = sin( my_time/1003);
    float yi = cos(my_time/1867);
    float xi = coord.x;
    float x = coord.y;
    float color = 0.0;
    
    float p = 0.56667; // + 0.01 * sin(iTime/1.3);
    float q = -0.5; // + 0.01 * cos(iTime/1.7);
    
    float xs, xis, xtemp, xitemp;
    for(int i = 0; i < 255; i++) {
        xs = x*x;
        xis = xi * xi;
        xtemp = xs - xis + (p + q*y);
        xitemp = (2.0*x*xi) + (q*yi);
        y = x;
        yi = xi;
        x = xtemp;
        xi = xitemp;
        color += 1.0/255.0;
        if(xs + xis > 400.0) {
            break;
        }
    }

	float power;
	vec3 c = color1;
    if(color < 32.0/255.0) {
    } else if(color <= 64./255.0) {
		c = mix(color1, color2, (color/(64./255.)));
    } else if(color <= 96./255.0) {
		c = mix(color2, color3, ((color-64./255.) / (32./255.)));
    } else if(color <= 128./255.0) {
		c = mix(color3, color4, ((color-96./255.) / (32./255.)));
	} else if(color <= 192./255.0) {
		c = mix(color4, color5, ((color-128./255.) / (64./255.)));
	} else if(color <= 224./255.0) {
		c = mix(color5, color6, ((color-192./255.) / (32./255.)));
	} else {
		c = mix(color6, vec3(0), ((color-224./255.) / (32./255.)));
	}
	return c;
}

vec3 julia(vec2 coord) {
	vec2 C = vec2(sin((my_time+2400.)/1743.)/2, cos((my_time+2400.)*0.75/2374.)/2);
	vec2 z = vec2(coord);
    float color = 0.0;
        
    for(int i = 0; i < 255; i++) {
		vec2 z2 = vec2(z.x*z.x - z.y*z.y,
		         2.0 * z.x * z.y) + C;
				 z = z2;
        if(dot(z,z) > 4.0) {
            break;
        }
        color += 1.0/255.0;
    }

	return vec3(1-color);
}

void main()
{
    vec2 phnx = vec2(( texCoord.x-0.5)*3.5*log((my_time/2000.0)),
					 (-texCoord.y+0.5)*2.5*log((my_time/2000.0)));
	vec2 jc = vec2((texCoord.x-0.5) * .7 * log(log((my_time-2000.0))),
	               (texCoord.y-0.5) * .7 * log(log((my_time-2000.0))));

	vec3 c = vec3(0,0,0);
	if (my_time < 2000.00) {
	    c = phoenix(phnx);
	} else {
		c = julia(jc);
		if (length(c) < 0.2) {
		    c = phoenix(phnx);		
		}
	}

	my_out = vec4(c, 1.0);
}