#version 330

uniform float my_time;

in vec2 texCoord;
out vec4 my_out;

float resX = 1920;
float resY = 1080;

float v=.0001*my_time;

float hash(float n)
{
    return fract(sin(n)*43758.5453);
}

void rot(inout vec2 s,float v)
{
	s=vec2(cos(v)*s.x+sin(v)*s.y,-sin(v)*s.x+cos(v)*s.y);
}

float noise(vec2 p)
{
    return hash(p.x + p.y*57.0);
}

float valnoise(vec2 p)
{
    vec2 c=floor(p);
    vec2 f=smoothstep(0.,1.,fract(p));
    return mix (mix(noise(c+vec2(0,0)), noise(c+vec2(1,0)), f.x),
                mix(noise(c+vec2(0,1)), noise(c+vec2(1,1)), f.x), f.y);
}

float FBM(vec2 p)
{
	return .5 * valnoise(p) + .25*valnoise(p*2) + .125*valnoise(p*4) + .063*valnoise(p*8);
}

float seed;
float rand() { return fract(sin(seed++)*43758.545); }

uniform sampler2D tex;

void main()
{
    vec2 uv = (gl_FragCoord.xy/vec2(resX,resY));
	vec2 uv1 = uv;

	uv1 += ( - .03/*4KS:EdgeWaveAmpl:3*/*.5 +.03/*4KS:EdgeWaveAmpl:3*/*vec2( 
				FBM(uv*62.34/*4KS:EdgeWaveFreqX*/ + 11/*4KS:EdgeDetailAmplX*/*FBM(uv+v*70/*4KS:EdgeWaveFreqTimeX*/)),
				FBM(uv.yx*68.01/*4KS:EdgeWaveFreqY*/+ 11/*4KS:EdgeDetailAmplY*/*FBM(uv+v*67/*4KS:EdgeWaveFreqTimeY*/))) );


    vec3 origCol = min(texture(tex, uv1).rgb,vec3(1));
	float MaxDelta = 0;
	for (int x = 1; x < 20/*4KS:EdgeSamples*/; x++)
	{
		for (int i = 0; i < 8; i++)
		{
			vec2 offset = vec2(x, 0);
			rot(offset, i*3.14159/4.);
			offset.x /= resX/resY;
		
			vec3 newCol = min(vec3(1),texture(tex, uv1+offset*.0032/*4KS:EdgeThickness:4*/).rgb);
			float delta = dot(abs(origCol-newCol), vec3(1));
			if ( delta > .2/*4KS:EdgeLimitLow:3*/)
				MaxDelta = max(MaxDelta, pow(1./x, 1.2/*4KS:LightningPow*/));
		}		
	}


	vec3 Col1 =vec3(.65/*4KS:LightningColR*/,.14/*4KS:LightningColG*/,.92/*4KS:LightningColB*/) *
					MaxDelta;


	uv1 = uv + ( - .015/*4KS:Edge2WaveAmpl:3*/*.5 + .015/*4KS:Edge2WaveAmpl:3*/*vec2( 
				FBM(uv*30/*4KS:Edge2WaveFreqX*/ + 8/*4KS:Edge2DetailAmplX*/*FBM(uv+v*200/*4KS:Edge2WaveFreqTimeX*/)),
				FBM(uv.yx*46/*4KS:Edge2WaveFreqY*/+ 8/*4KS:Edge2DetailAmplY*/*FBM(uv+v*170/*4KS:Edge2WaveFreqTimeY*/))) );


    origCol = min(texture(tex, uv1).rgb,vec3(1));
	MaxDelta = 0;
	for (int x = 1; x < 16/*4KS:Edge2Samples*/; x++)
	{
		for (int i = 0; i < 8; i++)
		{
			vec2 offset = vec2(x, 0);
			rot(offset, i*3.14159/4.);
			offset.x /= resX/resY;
		
			vec3 newCol = min(vec3(1),texture(tex, uv1+offset*.0024/*4KS:Edge2Thickness:4*/).rgb);
		
			float delta = dot(abs(origCol-newCol), vec3(1));
			if ( delta > .2/*4KS:Edge2LimitLow:3*/)
				MaxDelta = max(MaxDelta, pow(1./x, 1.5/*4KS:Lightning2Pow*/));
		}	
	}

	
	vec3 Col2 =vec3(1/*4KS:Lightning2ColR*/,.62/*4KS:Lightning2ColG*/,1/*4KS:Lightning2ColB*/) *
					MaxDelta;

	gl_FragColor.rgb =( Col1+Col2);
}