#version 330

uniform float my_time;
uniform sampler2D my_texture;

in vec2 texCoord;
out vec4 my_out;

vec4 noise(vec2 p) {
  float x = fract(p.x * my_time * .697 * fract(p.y * my_time * .147));
//  float x = fract(p.x * p.y * my_time * 5.0987);
//  float y = fract(dot(p, p) * my_time * 8.987);

  if (x >= 0.9995) {
  	  return vec4(1.0, 1.0, 1.0, 1.0);
  } else {
  	  return vec4(0.0, 0.0, 0.0, 1.0);
  }
}

void main()
{
    vec4 color = vec4(0.0, 0.0, 0.0, 1.0);
	float w = 0;
	vec4 flare = vec4(0., 0., 0., 1.0);
	
	float power = 4*pow(1-fract(my_time*0.25*13./6000.), 5);
	power = max(power, 4*pow(1-fract( (my_time*0.25*13./6000.) + (0.30 * 13./6.)), 5));

	float r = log(log((12.0*4.0*6000.0/13.0)-my_time)) * power;
	if (r < 1) {
		r = 1;
	}
	float r2 = r*r;
	for (float x = -r; x <= r; x += 1.0) {
	  for (float y = -r; y <= r; y += 1.0) {
	    if (x*x + y*y <= r2) {
          vec2 c = texCoord + vec2(x/700.0, y/700.0);
		  if(c.x < 0.0 || c.y < 0.0) {
		  	  continue;
		  }
	      vec4 tex = texture2D(my_texture, vec2(0,1)+vec2(1,-1)*c );
		  float w2 = length(tex.xyz) + 0.0001;
		  w += w2;
		  color += tex * w2;

		  if (length(noise(c).xyz) > 0.5) {
			flare /= 2;
			flare += vec4(0.5, 0.5, 0.5, 0.5);
		  }
		}
	  }
	}

	my_out = mix(color / w, flare, length(flare.xyz));
}