#version 330

uniform float my_time;

in vec2 texCoord;
out vec4 my_out;

float resX = 1920;
float resY = 1080;

float v=.0001*my_time;

 vec3 i,r; // i = color, r = hitstate. r.x = min hitstate, r.y = max distance TODO: vec2? samen met iets anders?

void rot(inout vec2 s,float v)
{
	s=vec2(cos(v)*s.x+sin(v)*s.y,-sin(v)*s.x+cos(v)*s.y);
}

float hash(float n)
{
	return fract(sin(n)*43758.5453);
}

float noise(vec2 p)
{
	return hash(p.x + p.y*57.0);
}

float valnoise(vec2 p)
{
	vec2 c = floor(p);
	vec2 f = smoothstep(0., 1., fract(p));
	return mix(mix(noise(c + vec2(0, 0)), noise(c + vec2(1, 0)), f.x),
		mix(noise(c + vec2(0, 1)), noise(c + vec2(1, 1)), f.x), f.y);
}

float s=1,f=9; // conePower, timer, orbit trap

float sd_Rect(vec3 p, vec3 r)
{
	return length(max(abs(p)-r,0));
}


float scene(vec3 r3)// distance
{
	vec3 r = r3;
	float y=2,z=2,x=6+r.y;

	i=vec3(0);

	if(fract(r.z/6/*4KS:CheckboardSize:0*/+v*30/*4KS:CheckboardSpeed:0*/)>.5)	
			i=vec3(1);

	if (abs(r.x) - 5.2/*4KS:RoadWidth*/ < 0)
		i = vec3(.5);

	if (max(abs(r.x) - .24/*4KS:StripWidth*/,
		mod(r.z/6 + v * 30/*4KS:CheckboardSpeed:0*/, 3.75/*4KS:StripFreq*/) - .5*3.75/*4KS:StripFreq*/ + .86/*4KS:StripLength*/) < 0)
		i = vec3(0);

	vec3 r2 = r;
	r2.x = abs(r2.x) - 13.1/*4KS:BuildDist*/;
	r2.z = mod(r2.z + 6*v * 30/*4KS:CheckboardSpeed:0*/, 12.4/*4KS:BuildGrid*/)- .5 * 12.4/*4KS:BuildGrid*/;
	float g = sd_Rect(r2, vec3(2.7/*4KS:BuildWidth*/, 8.3/*4KS:BuildHeight*/, 2.7/*4KS:BuildWidth*/));
		
	if (g < x)
	{
		x = g, i = vec3(.5);

		r2 = mod(r2, 2.08/*4KS:WindowGrid*/) - .5* 2.08/*4KS:WindowGrid*/;
		r2.t += .14/*4KS:WindowHeight*/;
		g = sd_Rect(r2, vec3(.47/*4KS:WindowSize*/));
		if (g < x)
			i = vec3(.0);
	}

	r2 = r - vec3(0, +69.67/*4KS:SunY*/-v*40/*4KS:SunSpeed*/, 191.67/*4KS:SunZ*/);
	 g = max(abs(r2.z)-.1,length(r2)-52.08/*4KS:SunRadius*/);		
	if ( g < x)
		x=g, i = vec3(.2);


	r+= vec3(0, -44.1/*4KS:LogoY*/, -41/*4KS:LogoZ*/);

	rot(r.xz, v * 7.56/*4KS:RotSpeed*/);
	r.x += 45.94/*4KS:LogoX*/;
	
	g = 999;
	float LogoDrop = .1;

	// S
	r.x -= 14.26/*4KS:LogoOffsetS*/;
	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+.7, LogoDrop+.9, v)) * 80/*4KS:LogoStartY*/;

	g = min(g, sd_Rect(r2 - vec3(.5*1.33/*4KS:LogoSBarLength*/ - .5*1.3/*4KS:LogoThickness*/, 0, 0),
		vec3(1.33/*4KS:LogoSBarLength*/, 1.3/*4KS:LogoThickness*/, 1)));

	g = min(g, max(sd_Rect(r2 - vec3(-.5*1.33/*4KS:LogoSBarLength*/ + 3.54/*4KS:LogoSHeadLength*/ - .5*1.3/*4KS:LogoThickness*/, 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(3.54/*4KS:LogoSHeadLength*/, 1.3/*4KS:LogoThickness*/, 1)),
		r2.x - 3.54/*4KS:LogoSHeadLength*/ * 2 + .5*1.33/*4KS:LogoSBarLength*/ + .5*1.3/*4KS:LogoThickness*/ - .5*(r2.y - 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/)
	));

	g = min(g, sd_Rect(r2 - vec3(.5*1.33/*4KS:LogoSBarLength*/ - 3.35/*4KS:LogoSFootLength*/ + .5*1.3/*4KS:LogoThickness*/, -5.03/*4KS:LogoHeight*/ + .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(3.35/*4KS:LogoSFootLength*/, 1.3/*4KS:LogoThickness*/, 1))
	);

	r2.x += .5*1.3/*4KS:LogoThickness*/ + .5*1.33/*4KS:LogoSBarLength*/;
	r2.y -= .5*5.03/*4KS:LogoHeight*/ - .25*1.3/*4KS:LogoThickness*/;
	g = min(g, max(r2.x, max(length(r2.xy) - (.5*5.03/*4KS:LogoHeight*/ + .75*1.3/*4KS:LogoThickness*/),
		-length(r2.xy) + (.5*5.03/*4KS:LogoHeight*/ - 1.25*1.3/*4KS:LogoThickness*/))));

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+.7, LogoDrop+.9, v)) * 80/*4KS:LogoStartY*/;
	r2.x -= .5*1.3/*4KS:LogoThickness*/ + .5*1.33/*4KS:LogoSBarLength*/;
	r2.y += .5*5.03/*4KS:LogoHeight*/ - .25*1.3/*4KS:LogoThickness*/;
	g = min(g, max(-r2.x, max(length(r2.xy) - (.5*5.03/*4KS:LogoHeight*/ + .75*1.3/*4KS:LogoThickness*/),
		-length(r2.xy) + (.5*5.03/*4KS:LogoHeight*/ - 1.25*1.3/*4KS:LogoThickness*/))));

	// P

	r.x -= 7.76/*4KS:LogoOffsetP*/;

	// Loop of P
	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+.8, LogoDrop+1., v)) * 80/*4KS:LogoStartY*/;

	r2.y -= .5*5.03/*4KS:LogoHeight*/ - .25*1.3/*4KS:LogoThickness*/;
	r2.y = abs(r2.y);
	r2.y += .5*5.03/*4KS:LogoHeight*/ - .25*1.3/*4KS:LogoThickness*/;

	g = min(g, sd_Rect(r2 - vec3(1.5*1.3/*4KS:LogoThickness*/, 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(1.5*1.3/*4KS:LogoThickness*/, 1.3/*4KS:LogoThickness*/, 1)));

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+.8, LogoDrop+1., v)) * 80/*4KS:LogoStartY*/;
	r2.x -= 2.5*1.3/*4KS:LogoThickness*/;
	r2.y -= .5*5.03/*4KS:LogoHeight*/ - .25*1.3/*4KS:LogoThickness*/;
	g = min(g, max(-r2.x, max(length(r2.xy) - (.5*5.03/*4KS:LogoHeight*/ + .75*1.3/*4KS:LogoThickness*/),
		-length(r2.xy) + (.5*5.03/*4KS:LogoHeight*/ - 1.25*1.3/*4KS:LogoThickness*/))));

	// diagonal bar of R + spacecut

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+.8, LogoDrop+1., v)) * 80/*4KS:LogoStartY*/;
	g = min(g, sd_Rect(r2, vec3(1.3/*4KS:LogoThickness*/, 5.03/*4KS:LogoHeight*/ + .5*1.3/*4KS:LogoThickness*/, 1)));

	r2.x -= 2.5*1.3/*4KS:LogoThickness*/;
	rot(r2.xy, -1.12/*4KS:LogoPBarAngle*/);

	g = max(g, min(r.x, -r2.y - .9*1.3/*4KS:LogoThickness*/)); // spacecut

	


	// E
	r.x -= 8.63/*4KS:LogoOffsetE*/;
	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+.9, LogoDrop+1.1, v)) * 80/*4KS:LogoStartY*/;

	g = min(g, sd_Rect(r2, vec3(1.3/*4KS:LogoThickness*/, 5.03/*4KS:LogoHeight*/ + .5*1.3/*4KS:LogoThickness*/, 1)));

	g = min(g, sd_Rect(r2 - vec3(2.9/*4KS:LogoEBarLength*/ - .5*1.3/*4KS:LogoThickness*/, 0, 0),
		vec3(2.9/*4KS:LogoEBarLength*/, 1.3/*4KS:LogoThickness*/, 1)));

	g = min(g, max(sd_Rect(r2 - vec3(3.54/*4KS:LogoEHeadLength*/ - .5*1.3/*4KS:LogoThickness*/, 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(3.54/*4KS:LogoEHeadLength*/, 1.3/*4KS:LogoThickness*/, 1)),
		r2.x - 3.54/*4KS:LogoFHeadLength*/ * 2 + .5*1.3/*4KS:LogoThickness*/ - .5*(r2.y - 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/)
	));

	g = min(g, sd_Rect(r2 - vec3(3.35/*4KS:LogoEFootLength*/ - .5*1.3/*4KS:LogoThickness*/, -5.03/*4KS:LogoHeight*/ + .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(3.35/*4KS:LogoEFootLength*/, 1.3/*4KS:LogoThickness*/, 1))
	);

	// N
	r.x-=11.85/*4KS:LogoOffsetN*/;

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.0, LogoDrop+1.2, v)) * 80/*4KS:LogoStartY*/;
	r2.x += 2*1.3/*4KS:LogoThickness*/;
	r2.y -= 5.03/*4KS:LogoHeight*/;
	rot(r2.xy, -1.05/*4KS:LogoNBarAngle*/);
	g = min(g, max(-r.y - 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/,
			sd_Rect(r2 - vec3(6.57/*4KS:LogoNBarLength*/ - .5*1.3/*4KS:LogoThickness*/, 0, 0),
					vec3(6.57/*4KS:LogoNBarLength*/, .9*1.3/*4KS:LogoThickness*/, 1))));
	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.0, LogoDrop+1.2, v)) * 80/*4KS:LogoStartY*/;
	r2.x = abs(r2.x);
	r2.x-=.66/*4KS:LogoNWidth*/*5.03/*4KS:LogoHeight*/;
	g=min(g, sd_Rect(r2,vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1)));	

	// C
	r.x-=11.01/*4KS:LogoOffsetC*/;

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.1, LogoDrop+1.3, v)) * 80/*4KS:LogoStartY*/;
	g=min(g, max(r2.x,max(length(r2.xy)-(5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/),
					-length(r2.xy)+(5.03/*4KS:LogoHeight*/-1.5*1.3/*4KS:LogoThickness*/) ) )
		);
	r2.y=abs(r2.y);
	g=min(g, sd_Rect(r2-vec3(1.5/*4KS:LogoCBarLength*/-.5*1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,0), 
						vec3(1.5/*4KS:LogoCBarLength*/,1.3/*4KS:LogoThickness*/,1)));

	// E
	r.x -= 4.41/*4KS:LogoOffsetE2*/;
	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.2, LogoDrop+1.4, v)) * 80/*4KS:LogoStartY*/;
	g = min(g, sd_Rect(r2, vec3(1.3/*4KS:LogoThickness*/, 5.03/*4KS:LogoHeight*/ + .5*1.3/*4KS:LogoThickness*/, 1)));

	g = min(g, sd_Rect(r2 - vec3(2.9/*4KS:LogoEBarLength*/ - .5*1.3/*4KS:LogoThickness*/, 0, 0),
		vec3(2.9/*4KS:LogoEBarLength*/, 1.3/*4KS:LogoThickness*/, 1)));

	g = min(g, max(sd_Rect(r2 - vec3(3.54/*4KS:LogoEHeadLength*/ - .5*1.3/*4KS:LogoThickness*/, 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(3.54/*4KS:LogoEHeadLength*/, 1.3/*4KS:LogoThickness*/, 1)),
		r2.x - 3.54/*4KS:LogoFHeadLength*/ * 2 + .5*1.3/*4KS:LogoThickness*/ - .5*(r2.y - 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/)
	));

	g = min(g, sd_Rect(r2 - vec3(3.35/*4KS:LogoEFootLength*/ - .5*1.3/*4KS:LogoThickness*/, -5.03/*4KS:LogoHeight*/ + .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(3.35/*4KS:LogoEFootLength*/, 1.3/*4KS:LogoThickness*/, 1))
	);

	// R 

	r.x-=8.62/*4KS:LogoOffsetR*/;

	// Loop of R
	r2=r;
	r2.y -= (1 - smoothstep(LogoDrop+1.3, LogoDrop+1.5, v)) * 80/*4KS:LogoStartY*/;
	r2.y-=.5*5.03/*4KS:LogoHeight*/-.25*1.3/*4KS:LogoThickness*/;
	r2.y=abs(r2.y);
	r2.y+=.5*5.03/*4KS:LogoHeight*/-.25*1.3/*4KS:LogoThickness*/;

	g=min(g, sd_Rect(r2-vec3(1.5*1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,0), 
						vec3(1.5*1.3/*4KS:LogoThickness*/,1.3/*4KS:LogoThickness*/,1)));

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.3, LogoDrop+1.5, v)) * 80/*4KS:LogoStartY*/;
	r2.x-=2.5*1.3/*4KS:LogoThickness*/;
	r2.y-=.5*5.03/*4KS:LogoHeight*/-.25*1.3/*4KS:LogoThickness*/;
	g=min(g, max(-r2.x,max(length(r2.xy)-(.5*5.03/*4KS:LogoHeight*/+.75*1.3/*4KS:LogoThickness*/),
				-length(r2.xy)+(.5*5.03/*4KS:LogoHeight*/-1.25*1.3/*4KS:LogoThickness*/) ) ) );

	// diagonal bar of R + spacecut
	
	r2=r;
	r2.y -= (1 - smoothstep(LogoDrop+1.3, LogoDrop+1.5, v)) * 80/*4KS:LogoStartY*/;
	r2.x-=2.5*1.3/*4KS:LogoThickness*/;
	rot(r2.xy,-1.12/*4KS:LogoRBarAngle*/);
	g=min(g, sd_Rect(r2-vec3(3.68/*4KS:LogoRBarLength*/-.5*1.3/*4KS:LogoThickness*/,0,0), vec3(3.68/*4KS:LogoRBarLength*/,.9*1.3/*4KS:LogoThickness*/,1)));

	g=max(g,min(r.x,-r2.y-.9*1.3/*4KS:LogoThickness*/)); // spacecut

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.3, LogoDrop+1.5, v)) * 80/*4KS:LogoStartY*/;
	g=min(g, sd_Rect(r2,vec3(1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/+.5*1.3/*4KS:LogoThickness*/,1)));

	// '
	r.x -= 8.24/*4KS:LogoOffsetTick*/;
	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.4, LogoDrop+1.5, v)) * 80/*4KS:LogoStartY*/;
	g=min(g, max(sd_Rect(r2-vec3(1/*4KS:LogoTickHeadLength*/-.5*1.3/*4KS:LogoThickness*/,5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/,0),
						vec3(1/*4KS:LogoTickHeadLength*/,1.3/*4KS:LogoThickness*/,1)),
				  r2.x-1/*4KS:LogoTickHeadLength*/*2+.5*1.3/*4KS:LogoThickness*/ - .5*(r2.y- 5.03/*4KS:LogoHeight*/-.5*1.3/*4KS:LogoThickness*/ )
						));


	// S
	r.x -= 5.86/*4KS:LogoOffsetS2*/;

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.5, LogoDrop+1.6, v)) * 80/*4KS:LogoStartY*/;

	g = min(g, sd_Rect(r2 - vec3(.5*1.33/*4KS:LogoSBarLength*/ - .5*1.3/*4KS:LogoThickness*/, 0, 0),
		vec3(1.33/*4KS:LogoSBarLength*/, 1.3/*4KS:LogoThickness*/, 1)));

	g = min(g, max(sd_Rect(r2 - vec3(-.5*1.33/*4KS:LogoSBarLength*/ + 3.54/*4KS:LogoSHeadLength*/ - .5*1.3/*4KS:LogoThickness*/, 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(3.54/*4KS:LogoSHeadLength*/, 1.3/*4KS:LogoThickness*/, 1)),
		r2.x - 3.54/*4KS:LogoSHeadLength*/ * 2 + .5*1.33/*4KS:LogoSBarLength*/ + .5*1.3/*4KS:LogoThickness*/ - .5*(r2.y - 5.03/*4KS:LogoHeight*/ - .5*1.3/*4KS:LogoThickness*/)
	));

	g = min(g, sd_Rect(r2 - vec3(.5*1.33/*4KS:LogoSBarLength*/ - 3.35/*4KS:LogoSFootLength*/ + .5*1.3/*4KS:LogoThickness*/, -5.03/*4KS:LogoHeight*/ + .5*1.3/*4KS:LogoThickness*/, 0),
		vec3(3.35/*4KS:LogoSFootLength*/, 1.3/*4KS:LogoThickness*/, 1))
	);

	r2.x += .5*1.3/*4KS:LogoThickness*/ + .5*1.33/*4KS:LogoSBarLength*/;
	r2.y -= .5*5.03/*4KS:LogoHeight*/ - .25*1.3/*4KS:LogoThickness*/;
	g = min(g, max(r2.x, max(length(r2.xy) - (.5*5.03/*4KS:LogoHeight*/ + .75*1.3/*4KS:LogoThickness*/),
		-length(r2.xy) + (.5*5.03/*4KS:LogoHeight*/ - 1.25*1.3/*4KS:LogoThickness*/))));

	r2 = r;
	r2.y -= (1 - smoothstep(LogoDrop+1.5, LogoDrop+1.6, v)) * 80/*4KS:LogoStartY*/;
	r2.x -= .5*1.3/*4KS:LogoThickness*/ + .5*1.33/*4KS:LogoSBarLength*/;
	r2.y += .5*5.03/*4KS:LogoHeight*/ - .25*1.3/*4KS:LogoThickness*/;
	g = min(g, max(-r2.x, max(length(r2.xy) - (.5*5.03/*4KS:LogoHeight*/ + .75*1.3/*4KS:LogoThickness*/),
		-length(r2.xy) + (.5*5.03/*4KS:LogoHeight*/ - 1.25*1.3/*4KS:LogoThickness*/))));

	// limit everything in depth
	g = max(g, abs(r.z)- 1/*4KS:LogoDepth*/);
	if (g < x && (v < LogoDrop+1.7 || mod(v, .1) > .025) )
		x = g, i = vec3(.5);

	return x;
}

void main()
{	
	float z;
	int e=0;

   vec3 m=normalize(vec3(gl_FragCoord.xy/(resY*.5)-vec2(resX/resY,1),2)), //dir
		w=vec3(0,.41,.91);
	rot(w.xz,-5.02/*4KS:SunPos*/);
  

    r=vec3(.01/*4KS:RM_HitDist:3*/,400/*4KS:RM_MaxDist:0*/,.5/*4KS:AO*/); // hitstate

	 // camera
   vec3 g=vec3(1.7/*4KS:CamX*/ + 1/*4KS:CarDriftAmpl*/ * valnoise(vec2(v) * 10/*4KS:CarDriftFreq*/),-5.61/*4KS:CamY*/,-44.6/*4KS:CamZ*/);
   rot(m.zy,-.32/*4KS:CamLookDown*/);      
   rot(m.xz,+0/*4KS:CamLookRight*/);            
   
   vec3 p=g;
   z=scene(p);

   for(;e<150/*4KS:RM_MaxSteps:3*/&&abs(z)>r.x&&length(p-g)<r.y;e++) // march TODO: remove steps or horizon?
     p+=z*m,z=scene(p);

	// Mercury trick: take tiny step back to avoid stepping in the object and messing up the normals
	z=scene(p+=m*(scene(p)-.01));

    i += normalize(vec3(scene(p+vec3(.0001,0,0)),scene(p+vec3(0,.0001,0)),scene(p+vec3(0,0,.0001)))-z); //normal
	
    if(z>.3/*4KS:RM_NoHitDist*/) // pure sky
      i=vec3(.5/*4KS:SkyColR*/,.5/*4KS:SkyColG*/,.9/*4KS:SkyColB*/);
     
	my_out = vec4(i, 1.0);
}