import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import java.util.Arrays; 
import moonlander.library.*; 
import ddf.minim.*; 
import ch.bildspur.postfx.builder.*; 
import ch.bildspur.postfx.pass.*; 
import ch.bildspur.postfx.*; 
import ddf.minim.analysis.*; 
import java.io.BufferedWriter; 
import java.io.FileWriter; 

import moonlander.library.*; 
import org.hamcrest.*; 
import org.hamcrest.core.*; 
import org.hamcrest.internal.*; 
import junit.extensions.*; 
import junit.framework.*; 
import junit.runner.*; 
import junit.textui.*; 
import org.junit.*; 
import org.junit.experimental.*; 
import org.junit.experimental.categories.*; 
import org.junit.experimental.max.*; 
import org.junit.experimental.results.*; 
import org.junit.experimental.runners.*; 
import org.junit.experimental.theories.*; 
import org.junit.experimental.theories.internal.*; 
import org.junit.experimental.theories.suppliers.*; 
import org.junit.internal.*; 
import org.junit.internal.builders.*; 
import org.junit.internal.matchers.*; 
import org.junit.internal.requests.*; 
import org.junit.internal.runners.*; 
import org.junit.internal.runners.model.*; 
import org.junit.internal.runners.rules.*; 
import org.junit.internal.runners.statements.*; 
import org.junit.matchers.*; 
import org.junit.rules.*; 
import org.junit.runner.*; 
import org.junit.runner.manipulation.*; 
import org.junit.runner.notification.*; 
import org.junit.runners.*; 
import org.junit.runners.model.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class trbl_processing extends PApplet {

int[] blendmodes = {BLEND, ADD, SUBTRACT, DARKEST, LIGHTEST, BLEND, EXCLUSION, MULTIPLY, SCREEN, REPLACE}; //<>//





Moonlander _moon;




PostFX fx;
CAPass caPass;
InvertPass invertPass;


BeatDetect beat;

//================================
float SCALE = 1;
//================================
boolean SAVE_VIDEO = false;
//--------------------------------
int FPS = 60;
int MAX_LENGTH = FPS * 69;
String tune = "trbl_deux_soundtrack.mp3";
float BPM = 107;
int ROWS_PER_BEAT = 8;
//--------------------------------
int LAYERS = 7;
//================================

int W = 1920;
int H = 1080;

String[] sceneList;
PGraphics layerList[] = new PGraphics[LAYERS];

//assets
PImage[] _spriteList;

PShape[] trbl = new PShape[4];
PShape[] letters = new PShape[4];
PShape[] objects = new PShape[3];
ArrayList<Particle> particles = new ArrayList<Particle>();

// to be removed
float tickTime = 0;

public void settings() {
    //fullScreen(2);
    size((int)(W/SCALE), (int)(H/SCALE), P3D);
}

public void setup() {
    //size(1920, 1080, P3D);
    //fullScreen();
    frameRate(FPS);
    noiseDetail(2);
    //smooth(2);
    
    //noCursor();
    //surface.setAlwaysOnTop(true);
    hint(ENABLE_OPTIMIZED_STROKE);

    _moon = Moonlander.initWithSoundtrack(this, tune, (int)BPM, ROWS_PER_BEAT);

    //used in SeedManager
    initSeedManager();

    //used in Utils.pde
    initUtils();
    palette = getPalette(20);
    for (int i = 0; i < paletteList.length; i++) {
        paletteList[i] = Arrays.copyOf(palette, palette.length);
    }

    // layer
    for (int i = 0; i < layerList.length; i++) {
        layerList[i] = createGraphics(width, height, P3D);
    }

    _uiLayer = createGraphics(width, height, P2D);

    fx = new PostFX(this);
    caPass = new CAPass();
    invertPass = new InvertPass();

    loadAssets();

    initBeatDetection();

    //_moon.song.setVolume(.1);
}

public void loadAssets() {

    // start trbl
    for (int c = 0; c < 4; c++) {
        trbl[c] = loadShape("trbl.obj");
        trbl[c].rotateX(radians(90));
        trbl[c].rotateZ(radians(180));
        trbl[c].scale(70.0f/640.0f*width);
    }

    // start menger sponge
    initSponge();
    for (int i = 0; i <3; i++) {
        menger();
    }

    // start demoname
    String[] letterObj = {"d", "e", "u", "x"};
    for (int i = 0; i < letterObj.length; i++) {
        letters[i] = loadShape(letterObj[i]+".obj");
        letters[i].scale(100.0f/640.0f*(float)width);
        letters[i].rotateX(radians(90));
    }
}

public void prerender() {
    if (!ready) {
        PGraphics offscreen = createGraphics(width, height, P3D);
        offscreen.beginDraw();
        //there seems to be a bug, that sprites and 3d objects have to be rendered once - so they don't pop in
        for (int i = 0; i < letters.length; i++) {
            offscreen.shape(letters[i]);
        }

        for (int i = 0; i < _spriteList.length; i++) {
            offscreen.image(_spriteList[i], 0, 0);
        }
        offscreen.endDraw();
        
        _moon.start();
        
        ready = true;
    }
}

boolean ready = false;
public void draw() {
    prerender();
    
    _moon.update();
    updateBeatdetection();

    lights();

    lerpPalette();

    clear();
    background(palette[0]);

    //layers
    for (int i = 0; i < layerList.length - 1; i++) {
        int layerIndex = i+1;
        int sceneIndex = (int)_moon.getValue("layer"+ layerIndex +":sceneIndex");
        setPalette(layerIndex);
        if (sceneIndex > 0) {

            setCam(layerList[i], layerIndex);
            renderScene(layerList[i], layerIndex, sceneIndex);
            composeScene(layerList[i], layerIndex);
        }
    }

    //postFX
    float brightness = (float)_moon.getValue("postfx:brightness");// + _kick/2.0;
    caPass.amount = (float)_moon.getValue("postfx:ca");
    invertPass.amount = (float)_moon.getValue("postfx:invert");
    fx.render()
        .bloom((float)_moon.getValue("postfx:bloom.threshold"), (int)_moon.getValue("postfx:bloom.blurSize"), (float)_moon.getValue("postfx:bloom.sigma")*(1+getKick()))
        .custom(invertPass)
        .custom(caPass)
        .brightnessContrast(brightness, 1 + (float)_moon.getValue("postfx:contrast"))
        .saturationVibrance((float)_moon.getValue("postfx:saturation"), (float)_moon.getValue("postfx:vibrance"))
        .vignette(.3f, .3f)
        .compose(); 

    //last layer is on top of everything - even ca
    int sceneIndex = (int)_moon.getValue("layer"+ layerList.length +":sceneIndex");
    setPalette(layerList.length);
    if (sceneIndex > 0) {
        setCam(layerList[layerList.length-1], layerList.length);
        renderScene(layerList[layerList.length-1], layerList.length, sceneIndex);
        composeScene(layerList[layerList.length-1], layerList.length);
    }

    saveFrames();

    drawUI();
    
    closeOnDemoEnd();
}

public void closeOnDemoEnd(){
    if((float)_moon.getCurrentRow() > 817){
        exit();
    }
}

public void renderScene(PGraphics layer, int layerIndex, int sceneIndex) {

    layer.beginDraw();
    layer.clear();
    layer.endDraw(); 

    sceneList = new String[23];
    for (int i = 0; i < sceneList.length; i++) {
        sceneList[i] = "INVALID!";
    }

    sceneList[0] = "Nothing";
    sceneList[1] = "Sprite";    
    sceneList[5] = "TRBL-Logo";
    sceneList[6] = "deux-Logo";
    sceneList[10] = "TorusTunnel";
    sceneList[11] = "Menger";
    sceneList[12] = "BallonIntro";    
    sceneList[13] = "TorusTunnel (side)"; 
    sceneList[14] = "3D Gundam";   
    sceneList[15] = "Stars";   
    sceneList[16] = "Cube";
    sceneList[17] = "Palette";
    sceneList[18] = "BackgroundCircle";
    sceneList[19] = "ObjectTunnel";
    sceneList[20] = "Sphere";
    sceneList[21] = "Pyramid";
    sceneList[22] = "TextureCube";

    switch(sceneIndex) {

    case 0 :
        //show nothing;
        break;

    case 1 :
        scene_drawSprite(layer, (int)_moon.getValue("layer"+ layerIndex +":sprite.index"));
        break;

    case 5 :
        scene_trbl(layer);
        break;

    case 6 :
        scene_deux(layer, paletteList[layerIndex-1]);
        break;

    case 10:
        torusTunnel(layer, paletteList[layerIndex-1]);
        break; 

    case 11 : 
        menger_invert(layer, paletteList[layerIndex-1]);
        break; 

    case 12 : 
        ballonIntro(layer, paletteList[layerIndex-1]);        
        break; 

    case 13 : 
        scene_torus_tunnel_side(layer); 
        break; 

    case 14 : 
        scene_3D_gundamface(layer, paletteList[layerIndex-1]);
        break;

    case 15:
        scene_stars(layer);    
        break;

    case 16:
        scene_cube(layer, paletteList[layerIndex-1]);
        break;

    case 17:
        scene_palette(layer);        
        break;

    case 18:
        scene_background_circle(layer, paletteList[layerIndex-1]);
        break;

    case 19:
        scene_objectTunnel(layer, paletteList[layerIndex-1]);
        break;
        
    case 20:
        scene_sphere(layer, paletteList[layerIndex-1]);
        break;
    
    case 21:
        scene_pyramid(layer, paletteList[layerIndex-1]);
        break;
    
    case 22:
        scene_textureCube(layer, paletteList[layerIndex-1], (int)_moon.getValue("layer"+ layerIndex +":sprite.index"));
        break;
    }
}

public void composeScene(PGraphics layer, int layerIndex) {
        
    tint(255, round(255 * (1 - (float)_moon.getValue("layer"+ layerIndex +":opacity"))));
    blendMode(blendmodes[abs((int)_moon.getValue("layer"+ layerIndex +":blendmode")) % blendmodes.length]);

    if ((float)_moon.getValue("layer"+ layerIndex +":fx.blurSize") != 0) {
        fx.render(layer)
            .blur((int)_moon.getValue("layer"+ layerIndex +":fx.blurSize"), (float)_moon.getValue("layer"+ layerIndex +":fx.blurSigma"))
            .compose();
    }else {
        image(layer, 0, 0);
    }

    tint(255);
    blendMode(BLEND);
}

public void refresh(Boolean keepSeed) {
    if (!keepSeed) {
        int[] newSeed = getNextSeed();
        NOISE_SEED = newSeed[0];
        RANDOM_SEED = newSeed[1];
        noiseSeed(NOISE_SEED);
        randomSeed(RANDOM_SEED);
    }
    palette = getPalette(20);
}
BeatListener bl;

float kickSize, snareSize, hatSize;
float _kick;

public void initBeatDetection() {
    beat = new BeatDetect(_moon.song.bufferSize(), _moon.song.sampleRate());
    //will wait n milliseconds for detecting next "beat" - default is 10ms
    //beat.setSensitivity(150);
    //beat.detectMode(BeatDetect.FREQ_ENERGY);//SOUND_ENERGY is default
    kickSize = snareSize = hatSize = 16;
    bl = new BeatListener(beat, _moon.song);  
}

class BeatListener implements AudioListener
{
    private BeatDetect beat;
    private AudioPlayer source;

    BeatListener(BeatDetect beat, AudioPlayer source)
    {
        this.source = source;
        this.source.addListener(this);
        this.beat = beat;
    }

    public void samples(float[] samps)
    {
        beat.detect(source.mix);
    }

    public void samples(float[] sampsL, float[] sampsR)
    {
        beat.detect(source.mix);
    }
}

public float getKick(){
    return _kick * (float)_moon.getValue("postfx:kickIntensity");
}

public void updateBeatdetection(){
    float fallOff = .95f;
    
    //there's 27 bands in total
    int lowBand = 0;
    int highBand = 7;
    int numberOfOnsetsThreshold = 4;
    if ( beat.isRange(lowBand, highBand, numberOfOnsetsThreshold) )
    {
        _kick = 1;
    }

    _kick = constrain(_kick * fallOff, 0.0f, 1);
}

public void drawEQ() {
    _uiLayer.beginDraw();
    // draw a green rectangle for every detect band
    // that had an onset this frame
    float rectW = width / beat.detectSize();
    for (int i = 0; i < beat.detectSize(); ++i)
    {
        // test one frequency band for an onset
        if ( beat.isOnset(i) )
        {
            _uiLayer.fill(255);
            _uiLayer.rect( i*rectW, height - 100, rectW, 100);
        }
    }

    //there's 27 bands in total
    int lowBand = 0;
    int highBand = 7;
    int numberOfOnsetsThreshold = 4;
    if ( beat.isRange(lowBand, highBand, numberOfOnsetsThreshold) )
    {
        _uiLayer.fill(255,0,0);
        _uiLayer.rect(rectW*lowBand, height - 150, (highBand-lowBand)*rectW, 100);
    }

    if ( beat.isKick() )kickSize = 32;
    if ( beat.isSnare() ) snareSize = 32;
    if ( beat.isHat() ) hatSize = 32;

    _uiLayer.fill(255);

    _uiLayer.textAlign(CENTER);

    _uiLayer.textSize(kickSize);
    text(_uiLayer,"KICK", width/4, height/2);

    _uiLayer.textSize(snareSize);
    text(_uiLayer,"SNARE", width/2, height/2);

    _uiLayer.textSize(hatSize);
    text(_uiLayer,"HAT", 3*width/4, height/2);

    float fallOff = 0.95f; 
    
    kickSize = constrain(kickSize * fallOff, 16, 32);
    snareSize = constrain(snareSize * fallOff, 16, 32);
    hatSize = constrain(hatSize * fallOff, 16, 32);
    
    _uiLayer.endDraw();
}
class Box {
    PVector pos;
    float r;
    int detail;

    Box(float x, float y, float z, float r_) {
        pos = new PVector(x, y, z);
        r = r_;
        detail = 3 + (int)random(3);
    }

    public ArrayList<Box> generate() {
        int boxCount = 3;
        ArrayList<Box> boxes = new ArrayList<Box>();
        for (int x = -2; x < 4; x++) {
            for (int y = -2; y < 3; y++) {
                for (int z = -2; z < 3; z++) {
                    int sum = abs(x) + abs(y) + abs(z);
                    float newR = r/3;
                    if (sum < 2) {
                        Box b = new Box(pos.x+x*newR, pos.y+ y*newR, pos.z+z*newR, newR);
                        boxes.add(b);
                    }
                }
            }
        }
        return boxes;
    }

    public void show(PGraphics layer, int[] palette) {
        noiseSeed(0);
        float speed = (float)_moon.getCurrentRow() / 50.0f;
        layer.pushMatrix();

        float n = noise(pos.x + 0, pos.y + 0, pos.z + speed);
        float dia = n * r;
        layer.translate(pos.x + n*50.0f, pos.y+n*50.0f, pos.z+n*50.0f);
        layer.fill(lerpColor(palette[1], palette[2], n));
        layer.rotateX(n*360 / 80.0f);
        layer.rotateY(-n*360 / 80.0f);
        layer.rotateZ(n*360 / 80.0f);
        layer.sphereDetail(detail);
        layer.sphere(dia + ((sin((float)_moon.getCurrentRow()/70.0f)+1) * 3.0f));
        layer.popMatrix();
        noiseSeed(NOISE_SEED);
    }
}
public void keyPressed() {
    println(key+":"+keyCode);
    if (key == '+') {
        _appendTextToFile(_seedFileName, NOISE_SEED+":"+RANDOM_SEED);
        println("saved seed "+NOISE_SEED+" and "+RANDOM_SEED);
    } else if (key == '-') {
        if (!_useRandomSeed) {
            _removeSeedFromFile(NOISE_SEED+":"+RANDOM_SEED);
            _loadSeedsFromFile();
            println("removed seed "+NOISE_SEED+" and "+RANDOM_SEED);
        }
    } else if (keyCode == 23) {
        //SCROLL_LOCK toggles seed mode
        _useRandomSeed = !_useRandomSeed;
        _setSeedsFromFile();
        println("set useRandomSeed to "+_useRandomSeed);
    } else if (keyCode == 101) {
        // F5
        reloadSeedManager();
        reloadUtils();
        println("reloaded config");
    } else if (key == 'f') {
        SHOW_FPS = !SHOW_FPS;
        println("show FPS:", SHOW_FPS);
    } else if (key == 'g') {
        SHOW_GRID = !SHOW_GRID;
        println("show Grid:", SHOW_GRID);
    }
}

public void mouseWheel(MouseEvent event) {
    float e = event.getCount();

    if (_useRandomSeed) {
        int[] newSeed;
        if (e > 0) {
            newSeed = getPreviousSeed();
        } else {
            newSeed = getNextSeed();
        }

        NOISE_SEED = newSeed[0];
        RANDOM_SEED = newSeed[1];
        noiseSeed(NOISE_SEED);
        randomSeed(RANDOM_SEED);

        refresh(true);
    }
}
ArrayList<Box> sponge;

public void initSponge() {

    sponge = new ArrayList<Box>();

    // Star with one
    Box b = new Box(0, 0, 0, width/1.2f);
    sponge.add(b);
}

public void menger() {
    ArrayList<Box> next = new ArrayList<Box>();
    for (Box b : sponge) {
        ArrayList<Box> newBoxes = b.generate();
        next.addAll(newBoxes);
    }
    sponge = next;
}
PImage _paletteImage;

//main palette used by layerPalettes
int[] palette;
int[] currentPalette = {};
int[] nextPalette = {};
int[][] paletteList = new int[LAYERS][20];

public void initPalette(){

}

public int randomColorFromImage() {
    int c;
    if (_paletteImage != null) {
        c = _paletteImage.get(round(random(_paletteImage.width)), round(random(_paletteImage.height)));
    } else {
        c = color(random(255), random(255), random(255));
    }

    return c;
}

public int[] getPalette(int amount) {
    int[] pal= {};
    //randomSeed(round(frameCount/100.0));
    for (int i = 0; i < amount; i++) {
        pal = append(pal, randomColorFromImage());
    }

    return pal;
}

public int[] getLayerPalette(int layerIndex, int indexDelta) {

    // double the array
    int[] paletteDouble = new int[palette.length*2];
    for (int i = 0; i < paletteDouble.length; i++) {
        paletteDouble[i] = palette[i % palette.length];
    }

    int startIndex = 0;
    indexDelta = indexDelta % palette.length;
    if (indexDelta < 0) {
        startIndex = palette.length;
    }

    for (int i = 0; i < palette.length; i++) {
        paletteList[layerIndex-1][i] = paletteDouble[(startIndex + i) + indexDelta];
    }

    return paletteList[layerIndex-1];
}

public void setPalette(int layerIndex) {
    getLayerPalette(layerIndex, (int)_moon.getValue("layer"+ layerIndex +":palette.delta"));
}

public int darken(int p) {
    //color out = p;//color(red(p) - 10, green(p) - 10, blue(p) - 10);
    colorMode(HSB, 360, 100, 100); 
    int out = color(hue(p), saturation(p)+15, brightness(p)-10);
    colorMode(RGB, 255, 255, 255);

    return out;
}

public void lerpPalette() {
    int seedIndexNext;

    if (!_useRandomSeed) {
        _seedIndex = (int)_moon.getValue("seed:current");
        seedIndexNext = (int)_moon.getValue("seed:next");

        //get next seed
        int[] newSeed = getSeedAt(seedIndexNext);
        NOISE_SEED = newSeed[0];
        RANDOM_SEED = newSeed[1];
        noiseSeed(NOISE_SEED);
        randomSeed(RANDOM_SEED);
        nextPalette = getPalette(20);

        newSeed = getSeedAt(_seedIndex);
        NOISE_SEED = newSeed[0];
        RANDOM_SEED = newSeed[1];
        noiseSeed(NOISE_SEED);
        randomSeed(RANDOM_SEED);
        currentPalette = getPalette(20);

        palette = lerpPalette(currentPalette, nextPalette, (float)_moon.getValue("seed:lerp") + getKick());
    }
}

public int[] lerpPalette(int[] pal1, int[] pal2, float time) {

    int[] col = new int[pal1.length];
    for (int i = 0; i < pal1.length; i++) {
        col[i] = lerpColor(color(pal1[i]), color(pal2[i]), time);
    }

    return col;
}
class Particle {
    PVector pos;
    float diameter;
    int col;
    PShape obj;

    Particle(PVector pos, PShape obj, float diameter, int col) {
        this.pos = pos;
        this.obj = obj;
        this.diameter = diameter;
        this.col = col;
    }
}

public void torus(PGraphics layer, float radius, float tube_radius, int cp, int ts) {

    if (tube_radius == 0)
        tube_radius = radius/2;

    int circle_parts = cp;//12;
    float circle_angle = radians(360.0f / circle_parts);

    int tube_segments = ts;//12;
    float tube_angle = radians(360.0f / tube_segments);

    for (int seg = 0; seg < tube_segments; seg += 1) {

        layer.beginShape(QUAD_STRIP);

        for (int idx = 0; idx < circle_parts + 1; idx += 2) {

            float x1 = (radius + (tube_radius * cos(idx * circle_angle+ radians(45)))) * cos(seg * tube_angle + radians(45));
            float y1 = (radius + (tube_radius * cos(idx * circle_angle+ radians(45)))) * sin(seg * tube_angle + radians(45));
            float z1 = tube_radius * sin(idx * circle_angle + radians(45));

            float x1Next = (radius + (tube_radius * cos(idx * circle_angle+ radians(45)))) * cos((seg+1+ radians(45)) * tube_angle);
            float y1Next = (radius + (tube_radius * cos(idx * circle_angle+ radians(45)))) * sin((seg+1+ radians(45)) * tube_angle);
            float z1Next = tube_radius * sin(idx * circle_angle + radians(45));

            float xOff = 0;
            float yOff = 0;
            float zOff = 0;

            layer.vertex(x1     + xOff, y1     + yOff, z1     + zOff);
            layer.vertex(x1Next + xOff, y1Next + yOff, z1Next + zOff);
        }

        layer.endShape();
    }
}

public void drawCylinder(PGraphics l, int sides, float r1, float r2, float h) {
    float angle = 360 / sides;
    float halfHeight = h / 2;

    // top
    l.beginShape();
    for (int i = 0; i < sides; i++) {
        float x = cos( radians( i * angle ) ) * r1;
        float y = sin( radians( i * angle ) ) * r1;
        l.vertex( x, y, -halfHeight);
    }
    l.endShape(CLOSE);

    // bottom
    l.beginShape();
    for (int i = 0; i < sides; i++) {
        float x = cos( radians( i * angle ) ) * r2;
        float y = sin( radians( i * angle ) ) * r2;
        l.vertex( x, y, halfHeight);
    }
    l.endShape(CLOSE);

    // draw body
    l.beginShape(TRIANGLE_STRIP);
    for (int i = 0; i < sides + 1; i++) {
        float x1 = cos( radians( i * angle ) ) * r1;
        float y1 = sin( radians( i * angle ) ) * r1;
        float x2 = cos( radians( i * angle ) ) * r2;
        float y2 = sin( radians( i * angle ) ) * r2;
        l.vertex( x1, y1, -halfHeight);
        l.vertex( x2, y2, halfHeight);
    }
    l.endShape(CLOSE);
}

public void cylinder( int sides, float r1, float r2, float h, PGraphics l) {
    float angle = 360 / sides;
    float halfHeight = h / 2;
    // top
    l.beginShape();
    for (int i = 0; i < sides; i++) {
        float x = cos( radians( i * angle ) ) * r1;
        float y = sin( radians( i * angle ) ) * r1;
        l.vertex( x, y, -halfHeight);
    }
    l.endShape(CLOSE);
    // bottom
    l.beginShape();
    for (int i = 0; i < sides; i++) {
        float x = cos( radians( i * angle ) ) * r2;
        float y = sin( radians( i * angle ) ) * r2;
        l.vertex( x, y, halfHeight);
    }
    l.endShape(CLOSE);
    // draw body
    l.beginShape(TRIANGLE_STRIP);
    for (int i = 0; i < sides + 1; i++) {
        float x1 = cos( radians( i * angle ) ) * r1;
        float y1 = sin( radians( i * angle ) ) * r1;
        float x2 = cos( radians( i * angle ) ) * r2;
        float y2 = sin( radians( i * angle ) ) * r2;
        l.vertex( x1, y1, -halfHeight);
        l.vertex( x2, y2, halfHeight);
    }
    l.endShape(CLOSE);
} 

public void drawCylinderElipse( float r1, float h)
{
    float r2 = r1;
    int sides = 6;
    float angle = 360 / sides;
    float halfHeight = h / 2;

    float rHeight = r1 * 3;

    float offsetRot = radians(30);

    // top
    beginShape();
    for (int i = 0; i < sides; i++) {
        float x = cos(offsetRot + radians( i * angle ) ) * r1;
        float y = sin(offsetRot + radians( i * angle ) ) * rHeight;
        vertex( x, y, -halfHeight);
    }
    endShape(CLOSE);
    // bottom
    beginShape();
    for (int i = 0; i < sides; i++) {
        float x = cos(offsetRot + radians( i * angle ) ) * r2;
        float y = sin(offsetRot + radians( i * angle ) ) * rHeight;
        vertex( x, y, halfHeight);
    }
    endShape(CLOSE);
    // draw body
    beginShape(TRIANGLE_STRIP);
    for (int i = 0; i < sides + 1; i++) {
        float x1 = cos(offsetRot + radians( i * angle ) ) * r1;
        float y1 = sin(offsetRot + radians( i * angle ) ) * rHeight;
        float x2 = cos(offsetRot + radians( i * angle ) ) * r2;
        float y2 = sin(offsetRot + radians( i * angle ) ) * rHeight;
        vertex( x1, y1, -halfHeight);
        vertex( x2, y2, halfHeight);
    }
    endShape(CLOSE);
}

public void torus(float radius, float tube_radius, PGraphics l, PImage texture) {

    if (tube_radius == 0)
        tube_radius = radius/2;

    int circle_parts = 12;
    float circle_angle = radians(360.0f / (float)circle_parts);

    int tube_segments = 21;
    float tube_angle = radians(360.0f / (float)tube_segments);

    for (int seg = 0; seg < tube_segments; seg += 1) {

        l.beginShape(QUAD_STRIP);
        if (texture != null) {
            l.textureMode(NORMAL);
            l.texture(texture);
        }
        for (int idx = 0; idx < circle_parts + 1; idx += 2) {

            float x1 = (radius + (tube_radius * cos(idx * circle_angle+ radians(45)))) * cos(seg * tube_angle + radians(45));
            float y1 = (radius + (tube_radius * cos(idx * circle_angle+ radians(45)))) * sin(seg * tube_angle + radians(45));
            float z1 = tube_radius * sin(idx * circle_angle + radians(45));

            float x1Next = (radius + (tube_radius * cos(idx * circle_angle+ radians(45)))) * cos((seg+1+ radians(45)) * tube_angle);
            float y1Next = (radius + (tube_radius * cos(idx * circle_angle+ radians(45)))) * sin((seg+1+ radians(45)) * tube_angle);
            float z1Next = tube_radius * sin(idx * circle_angle + radians(45));

            float off = radius;
            float xOff = 0;//noise(radius, 0) * off;
            float yOff = 0;//noise(radius, 0) * off;
            float zOff = 0;//noise(radius, 0) * off;

            l.vertex(x1     + xOff, y1     + yOff, z1     + zOff);
            l.vertex(x1Next + xOff, y1Next + yOff, z1Next + zOff);
        }

        l.endShape();
    }
}

public void icosahedron(float radius, PGraphics l) {
    float t = (1.0f + sqrt(radius)) / 2.0f;

    l.beginShape(QUAD_STRIP);
    l.beginShape(QUAD_STRIP);

    l.vertex(-1, t, 0);
    l.vertex( 1, t, 0);
    l.vertex(-1, -t, 0);
    l.vertex( 1, -t, 0);
    l.vertex( 0, -1, t);
    l.vertex( 0, 1, t);
    l.vertex( 0, -1, -t);
    l.vertex( 0, 1, -t);
    l.vertex( t, 0, -1);
    l.vertex( t, 0, 1);
    l.vertex(-t, 0, -1);
    l.vertex(-t, 0, 1);
    l.endShape();
}


public void TexturedCube(PGraphics layer, PImage texture) {
  
  layer.beginShape(QUADS);
  layer.texture(texture);
  
  // +Z "front" face
  layer.vertex(-1, -1,  1, 0, 0);
  layer.vertex( 1, -1,  1, 1, 0);
  layer.vertex( 1,  1,  1, 1, 1);
  layer.vertex(-1,  1,  1, 0, 1);

  // -Z "back" face
  layer.vertex( 1, -1, -1, 0, 0);
  layer.vertex(-1, -1, -1, 1, 0);
  layer.vertex(-1,  1, -1, 1, 1);
  layer.vertex( 1,  1, -1, 0, 1);

  // +Y "bottom" face
  layer.vertex(-1,  1,  1, 0, 0);
  layer.vertex( 1,  1,  1, 1, 0);
  layer.vertex( 1,  1, -1, 1, 1);
  layer.vertex(-1,  1, -1, 0, 1);

  // -Y "top" face
  layer.vertex(-1, -1, -1, 0, 0);
  layer.vertex( 1, -1, -1, 1, 0);
  layer.vertex( 1, -1,  1, 1, 1);
  layer.vertex(-1, -1,  1, 0, 1);

  // +X "right" face
  layer.vertex( 1, -1,  1, 0, 0);
  layer.vertex( 1, -1, -1, 1, 0);
  layer.vertex( 1,  1, -1, 1, 1);
  layer.vertex( 1,  1,  1, 0, 1);

  // -X "left" face
  layer.vertex(-1, -1, -1, 0, 0);
  layer.vertex(-1, -1,  1, 1, 0);
  layer.vertex(-1,  1,  1, 1, 1);
  layer.vertex(-1,  1, -1, 0, 1);

  layer.endShape();
}
public void setCam(PGraphics layer, int layerIndex) {
    // camera shake
    float scale = (float)_moon.getValue("cam:shake.scale");
    float intensity = (float)_moon.getValue("cam:shake.intensity") / 960.0f * width;
    float time = (float)_moon.getCurrentRow();

    float nX = (noise(time * scale) * 2.0f - 1) * intensity;
    float nY = (noise(0, 1, time * scale) * 2.0f - 1) * intensity;
    float nZ = (noise(0, 0, time * scale) * 2.0f - 1) * intensity;

    //no camshake for last layer
    if(layerIndex == layerList.length){
        nX = 0;
        nY = 0;
        nZ = 0;
    }

    // camera position
    float radius = (width/2.0f)*(1+((float)_moon.getValue("layer"+ layerIndex +":camRot.radius")));
    float x = (radians((float)_moon.getValue("layer"+ layerIndex +":camRot.x")));
    float y = (radians((float)_moon.getValue("layer"+ layerIndex +":camRot.y")));
    float z = (radians((float)_moon.getValue("layer"+ layerIndex +":camRot.z")));

    // FOV
    float FOV = 90 + (float)_moon.getValue("layer"+ layerIndex +":FOV");

    layer.beginCamera();
    layer.camera(
        0 + nX, 0 + nY, ((radius) + nZ), // / tan(PI*30.0 / FOV),
        (float)_moon.getValue("layer"+ layerIndex +":camOrient.x") / 960.0f * width, (float)_moon.getValue("layer"+ layerIndex +":camOrient.y") / 960.0f * width, 0, 
        0, 1, 0);

    float fov = radians(FOV);
    layer.perspective(fov, PApplet.parseFloat(width)/PApplet.parseFloat(height), 
        radius/10.0f, radius*10.0f);

    layer.rotateY(y);
    layer.rotateX(x);
    layer.rotateZ(z);

    layer.endCamera();
}

// winded torus tunnel
public void torusTunnel(PGraphics layer, int[] palette) {

    float camZ = -((float)_moon.getCurrentRow()) - (1000.0f/960*width);
    float endDiameter = 1.0f + (float)_moon.getValue("scene:torusTunnel.endDiameter"); 
    layer.beginDraw();

    layer.stroke(palette[0]);
    layer.strokeWeight(2.0f/720.0f*(float)width);

    int depth = 100;

    for (int z = 0; z < depth; z++) {

        int col;
        if ((z % 2) == 0) {
            col = color(red(palette[2]), green(palette[2]), blue(palette[2]), 100.0f - (100.0f / depth * z));
        } else {
            col = color(red(palette[3]), green(palette[3]), blue(palette[3]), 100.0f - (100.0f / depth * z));
        }
        layer.fill(col);

        layer.pushMatrix();

        layer.translate(0, 0, z * (10.00f/960.0f*width));
        layer.rotateZ(z* 10);

        layer.translate(0, 0, -z*(100.0f/960.0f*width) - camZ);
        float diameter = endDiameter / depth * z;
        torus(layer, 300.0f/960.0f*width, (150.0f/960.0f*width)*diameter, 12, 12);

        layer.popMatrix();
    }
    layer.endDraw();
}

public void scene_textureCube(PGraphics layer, int[] palette, int spriteIndex){
    
    layer.beginDraw();
    layer.textureMode(NORMAL);
    
    layer.fill(palette[0]);
    layer.stroke(palette[1]);
    layer.pushMatrix();
    layer.strokeWeight(0.025f/960.0f*width);
    //layer.strokeWeight(0.1/960.0 * width);
    layer.scale(50/960.0f*width);
    TexturedCube(layer, _spriteList[max(0, spriteIndex) % _spriteList.length]);
    layer.popMatrix();
      
    layer.endDraw();
}


// menger
public void menger_invert(PGraphics layer, int[] palette) {
    layer.beginDraw();

    layer.strokeWeight(1/960.0f*width);
    layer.strokeJoin(ROUND);
    layer.strokeCap(ROUND);

    layer.pushMatrix();
    layer.fill(palette[1]);

    float size = width;
    layer.translate(width/2 - size/2, height/2 - size/2, -500.0f/960.0f*width);

    layer.popMatrix();

    layer.pushMatrix();

    layer.stroke(darken(palette[1]), 150.0f/960*width);
    layer.strokeWeight(3);

    for (int i = 0; i < (sponge.size()-1); i++) {
        int c = i +1;
        float dist = dist(sponge.get(i).pos.x, sponge.get(i).pos.y, sponge.get(i).pos.z, sponge.get(c).pos.x, sponge.get(c).pos.y, sponge.get(c).pos.z);
        layer.strokeWeight(min(5, map(dist, 0, 100, 1, 5)));        
        layer.line(sponge.get(i).pos.x, sponge.get(i).pos.y, sponge.get(i).pos.z, sponge.get(c).pos.x, sponge.get(c).pos.y, sponge.get(c).pos.z);
    }

    layer.strokeWeight(1.0f/960.0f * width);
    layer.stroke(darken(palette[1]));
    for (Box b : sponge) {
        b.show(layer, palette);
    }
    layer.popMatrix();
    layer.endDraw();
}

public void ballonIntro(PGraphics layer, int[] palette) {
    layer.beginDraw();

    layer.fill(palette[2]);
    layer.stroke(palette[3], 150);
    layer.strokeWeight(3.0f/720.0f*width);

    layer.sphereDetail(6);
    int amount = 10;
    float dia = height/5.0f;
    float offsetX = -((amount * dia) / 2.0f + (dia/4.0f));
    float offsetY = -(amount * dia) / 2.0f;
    for (int x = 1; x < amount; x++) {
        for (int y = 1; y < amount; y++) {
            layer.pushMatrix();
            layer.translate(offsetX + (y % 2 == 0 ? 0 : dia/2.0f) + x*dia, offsetY + (y*dia));
            layer.rotateX((float)_moon.getCurrentRow()/5.0f);
            layer.rotateY((float)_moon.getCurrentRow()/15.0f);
            layer.rotateZ(-(float)_moon.getCurrentRow()/20.0f);
            layer.sphere(dia *.5f);
            layer.popMatrix();
        }
    }
    layer.endDraw();
}

//gundam face
public void scene_3D_gundamface(PGraphics layer, int[] palette) {
    layer.beginDraw();

    layer.strokeWeight(1.0f/720.0f*width);

    randomSeed((long)_moon.getValue("scene:gundamFace.seed"));

    layer.rotateZ(radians(7));

    for (int i = 0; i < 32; i++) {
        int colorIndex = PApplet.parseInt(random(palette.length));
        float rotX = random(1) > .5f ? -1 : 1;
        float rotY = random(1) > .5f ? -1 : 1;
        float rotZ = random(1) > .5f ? -1 : 1;
        int idx = PApplet.parseInt(random(7));
        float diameter = ((random(1) * width/5) + width/20) / 2.0f;
        layer.fill(palette[colorIndex]);
        layer.stroke(darken(palette[colorIndex]));

        layer.pushMatrix();
        //layer.translate(width/2 - offsetX, height/1.5 - offsetY, offsetZ);
        layer.rotateZ(radians(tickTime * 360.0f * rotZ + i/10) + radians((float)_moon.getValue("scene:gundamFace.rotZ")));
        layer.rotateY(radians(tickTime * 360.0f * rotY + i/10) + radians((float)_moon.getValue("scene:gundamFace.rotY")));
        layer.rotateX(radians(tickTime * 360.0f * rotX + i/10) + radians((float)_moon.getValue("scene:gundamFace.rotX")));

        switch(idx) {
        case 0:
            torus(diameter, diameter/3, layer, null);
            break;

        case 1:
            layer.box(diameter);
            break;

        case 2:
            cylinder(5, 0, diameter, diameter*2, layer); 
            break;

        case 3:
            layer.sphereDetail(8);
            layer.sphere(diameter/2); 
            break;

        case 4:
            layer.box(diameter, diameter/3, diameter*3);
            break;

        case 5:

            for (int c = 1; c < 8; c++) {
                float w = diameter/15;
                layer.translate(0, c * w);
                layer.box(w, w, diameter*3);
            }
            break;

        case 6:
            for (int x = 0; x < 10; x++) {
                for (int y = 0; y < 5; y++) {
                    layer.pushMatrix();
                    float w = width/50;
                    layer.translate(x * w, y * w);  
                    cylinder(6, w/2, w/2, w/4, layer); 
                    layer.popMatrix();
                }
            }
            break;
        }

        layer.popMatrix();
    }
    //copy to the right
    layer.copy(
        0, 0, width/2, height, 
        width, 0, -width/2, height);
    // back to the left - as we can't clear the right side (there's leftovers from the left side in the back)
    layer.copy(
        width/2, 0, width/2, height, 
        width/2, 0, -width/2, height);

    layer.endDraw();
}

//torus tunnel
public void scene_torus_tunnel_side(PGraphics layer) {
    layer.beginDraw();
    layer.fill(palette[palette.length - 1]);
    layer.stroke(palette[palette.length - 2]);

    float radius = 200 / 640.0f * width;
    float girth = radius/5;

    int amount_x = 12;
    int amount_z = 12;   

    float tOff = radians(tickTime * 360.0f);

    for (int z = 0; z < amount_z; z++) {
        for (int x = 0; x < amount_x; x++) {

            float offsetZ      = sin(TAU/amount_z * z) * girth;
            float offsetRadius = cos(TAU/amount_z * z) * girth;

            float rotX = sin(TAU/amount_x * x + tOff);
            float rotY = cos(TAU/amount_x * x + tOff);
            float offsetX = rotX * (radius + offsetRadius);
            float offsetY = rotY * (radius + offsetRadius);

            layer.pushMatrix();
            layer.translate(width/2, height/2, 0);

            layer.translate(offsetX, offsetY, offsetZ);

            torus(10/640.0f * width, 5/640.0f * width, layer, null);

            layer.popMatrix();
        }
    }

    layer.pushMatrix();
    layer.rotateX(tOff);
    layer.rotateY(tOff);
    layer.translate(width/2, height/2);
    layer.popMatrix();
    layer.endDraw();
}

//scene stars
public void scene_stars(PGraphics layer) {
    /*
    layer.beginDraw();
    layer.lights();

    for (int i = 0; i < particles.size(); i++) {
        layer.pushMatrix();
        particles.get(i).obj.rotateX(.001);
        particles.get(i).obj.setFill(5 + palette[particles.get(i).col]);
        layer.translate(particles.get(i).pos.x * width, particles.get(i).pos.y * height, particles.get(i).pos.z * height);
        layer.shape(particles.get(i).obj);

        layer.popMatrix();
    }
    layer.endDraw();
    */
}

public void scene_cube(PGraphics layer, int[] palette) {
    layer.beginDraw();
    layer.lights();
    layer.fill(palette[0]);
    layer.strokeWeight(1/960.0f*width);
    layer.stroke(darken(palette[0]));
    layer.pushMatrix();
    layer.box(50/640.0f*width);
    layer.popMatrix();
    layer.endDraw();
}

public void scene_sphere(PGraphics layer, int[] palette) {
    layer.beginDraw();
    //layer.lights();
    layer.fill(palette[0]);
    layer.strokeWeight(2/960.0f*width);
    layer.stroke(darken(palette[0]));
    layer.sphereDetail(8);
    layer.pushMatrix();
    layer.sphere(50/640.0f*width);
    layer.popMatrix();
    layer.endDraw();
}

public void scene_pyramid(PGraphics layer, int[] palette) {
    layer.beginDraw();
    //layer.lights();
    layer.fill(palette[0]);
    layer.strokeWeight(2/960.0f*width);
    layer.stroke(darken(palette[0]));
    layer.sphereDetail(2);
    layer.pushMatrix();
    //layer.sphere(50/640.0*width);
    float diameter = 50/640.0f*width;
    drawCylinder(layer, 4, diameter, 0, diameter*2);
    layer.popMatrix();
    layer.endDraw();
}

public void scene_background_circle(PGraphics layer, int[] palette) {

    layer.beginDraw();
    layer.strokeWeight(1/960.0f *width);

    int amount_x = 20;
    int amount_y = 20;
    float dist_x = width/amount_x;
    float dist_y = width/amount_y;
    float diameter;
    float size = dist_x/4;

    float offX = 0; 
    float offY = 0;

    layer.noFill();
    layer.pushMatrix();
    layer.translate(-width/2, -height/2);
    for (int x = 0; x <= amount_x; x++) {
        for (int y = 0; y <= amount_y; y++) {

            int min = 0;
            int max = palette.length-1;
            int colIndex = floor(noise(offX*x, offY*y) * (max - min + 1)) + min;
            layer.stroke(palette[colIndex]);

            diameter = lerp(noise(x + offX, y + offY), noise(x + offX, y + offY + 16), sin(((float)_moon.getCurrentRow() + frameOffset) *.01f )) * size;
            layer.pushMatrix();
            layer.translate(x * dist_x + (y % 2 == 0 ? dist_x/2 : 0), y * dist_y);
            layer.rotateY(((float)_moon.getCurrentRow()) *.05f );
            layer.rotateZ(((float)_moon.getCurrentRow()) *.05f );
            drawCylinder(layer, 3, diameter, 0, diameter);
            layer.popMatrix();
        }
    }
    layer.popMatrix();
    layer.endDraw();
}

public void scene_objectTunnel(PGraphics layer, int[] palette) {
    
    for (int i = 0; i < 8; i++) {
        layer.pushMatrix();
        scene_objectTunnel(layer, palette, i, -i*width/2);
        layer.popMatrix();
    }
}

public void scene_objectTunnel(PGraphics layer, int[] palette, int seedOffset, float zOffset) {

    int sides = 12;
    float angle = 360 / sides;

    int nX = (int)_moon.getValue("scene:objectTunnel.seed") + seedOffset;
    int nY = 1 + 0;

    int min = 0;
    int max = palette.length -1;

    float cube_radius= 50/960.0f*width;
    
    float speed = (float)_moon.getCurrentRow();
    
    layer.beginDraw();
    layer.pushMatrix();
    //layer.translate(-width/4, -height/4);
    for (int offsets = 0; offsets < 2; offsets++) {
        float offset_rot = 15 * offsets;
        int amount_elements = 6;

        switch(offsets) {
        case 0:
            amount_elements = 6;
            break;
        case 1:
            amount_elements = 2;
            break;
        }

        for (int elements = 0; elements < amount_elements; elements++) {

            for (int i = 0; i < sides; i++) {

                layer.strokeWeight(1/960.0f*width);

                float radius = (cube_radius/2) + noise(nX, nY + elements + offsets) * width/2;
                float x = cos( radians( i * angle ) + radians(offset_rot)) * radius;
                float y = sin( radians( i * angle ) + radians(offset_rot)) * radius;

                layer.pushMatrix();
                layer.translate(x, y, zOffset);
                layer.rotateX(radians(-75) + radians(offset_rot));
                layer.rotateY(radians( i * angle ) + radians(90) + radians(offset_rot));
                layer.rotateZ(radians( i * angle ) + radians((speed + frameOffset)));

                min = 0;
                max = 5;
                
                int ele = floor(noise(nX + elements*10.0f, nY + elements + offsets) * (max - min + 1)) + min;
                
                min = 0;
                max = palette.length-1;
                int colIndex = floor(noise(nX + elements*10.0f, nY + elements + offsets) * (max - min + 1)) + min;
                
                layer.fill(palette[colIndex]);
                layer.stroke(darken(palette[colIndex]));

                float diameter = (noise(nX + elements * 100, nY + elements + offsets)) * (30 / 640.0f * width);
                float len = (noise(nX + elements * 100, nY + elements + offsets)) * (190 / 640.0f * width);

                switch(ele) {
                case 0:
                    drawCylinder(layer, elements % 2 == 0 ? 1 : 3, diameter, diameter/3, len);
                    break;

                case 1:
                    drawCylinder(layer, elements % 2 == 0 ? 1 : 3, diameter/5, diameter, len);
                    break;

                case 2:
                    layer.sphereDetail(2);
                    layer.rotateX(radians(90) + (speed + frameOffset)*0.01f);
                    layer.sphere(diameter);
                    break;

                case 3:
                    layer.sphereDetail(4);
                    layer.rotateX(-radians(90) + (speed + frameOffset)*0.01f);
                    layer.sphere(diameter);
                    break;

                case 4:
                    layer.box(diameter);
                    break;

                case 5:
                    layer.box(diameter, diameter*3, diameter*3);
                    break;
                }
                layer.popMatrix();
            }
        }
    }
    layer.popMatrix();
    layer.endDraw();
}

public void scene_deux(PGraphics layer, int[] palette) {
    layer.beginDraw();
    layer.lights();

    layer.pushMatrix();
    //l.translate(width/2.35, height/3.0);
    //center everything around 0, 0
    layer.translate(-width/14.0f, -width/(6.3f*2));
    for (int i = 0; i < letters.length; i++) {
        layer.pushMatrix();
        if (i < 2) {
            layer.translate(width/7 * i, 0);
        } else {
            layer.translate(width/7 * (i-2), width/6.3f);
        }

        letters[i].setFill(palette[1]);
        letters[i].setStroke(true); 
        letters[i].setStrokeWeight(0.009f/640.0f * width); 
        letters[i].setStroke(darken(palette[1]));

        //letters[i].rotateY(radians(1));
        layer.shape(letters[i], 0, 0);
        layer.popMatrix();
    }
    // layer.shape(testScene);
    layer.popMatrix();
    layer.endDraw();
}

public void scene_trbl(PGraphics l) {
    l.beginDraw();
    l.lights();

    l.pushMatrix();

    String[] TRBL = {"top", "right", "bottom", "left"};
    for (int i = 0; i < trbl.length; i++) {
        l.pushMatrix();
        int fill = lerpColor(color(0xffffffff), color(0xffff3700), (float)_moon.getValue("trbl:"+TRBL[i]+".colorFade"));
        trbl[i].setFill(color(red(fill), green(fill), blue(fill), (float)_moon.getValue("trbl:"+ TRBL[i] +".opacity")));
        l.rotateZ(radians(90) * i);
        l.scale((float)_moon.getValue("trbl:"+ TRBL[i] +".scale"));
        l.shape(trbl[i]);
        l.popMatrix();
    }
    l.popMatrix();
    l.endDraw();
}  

// sprites
public void scene_drawSprite(PGraphics layer, int spriteIndex) {
    layer.beginDraw();
    layer.pushMatrix();
    //layer.camera(width/2.0, height/2.0, (height/2.0) / tan(PI*30.0 / 180.0), width/2.0, height/2.0, 0, 0, 1, 0);
    layer.translate(-width/2, -height/2);
    if (spriteIndex > -1) {
        layer.image(_spriteList[max(0, spriteIndex) % _spriteList.length], 0, 0, width, height);
    }
    layer.popMatrix();
    layer.endDraw();
}

public void scene_palette(PGraphics layer) {
    float w = width/(float)paletteList[0].length;
    float h = height/(float)paletteList.length;

    layer.beginDraw();
    layer.pushMatrix();
    layer.translate(-width/2, -height/2);

    for (int layerI = 0; layerI < layerList.length; layerI++) {
        for (int paletteI = 0; paletteI < paletteList[layerI].length; paletteI++) {
            layer.fill(paletteList[layerI][paletteI]);
            layer.rect(w*paletteI, h*layerI, w, h);
        }
    }
    layer.popMatrix();
    layer.endDraw();
}



String _seedFileName = "seed.txt";
int _seedIndex;
ArrayList<int[]> _seeds = new ArrayList<int[]>();

int _randomSeedIndex = 0;
ArrayList<int[]> _randomSeeds = new ArrayList<int[]>();

int NOISE_SEED = 18198460;
int RANDOM_SEED = 33330108;

Boolean _useRandomSeed = false; 

public void initSeedManager() {
    int[] rnd = {(int)(frameCount*random(0, 9001)), (int)(frameCount*random(0, 9001))};
    _randomSeeds.add(rnd);

    _seedIndex = 0;
    _setSeedsFromFile();
}

public void reloadSeedManager() {
    _seedIndex = 0;
    _setSeedsFromFile();
}

// current seed, don't change pointer
public int[] getSeed() {

    if (_useRandomSeed) {
        return _randomSeeds.get(_randomSeedIndex);
    } else {
        if (_seedIndex > _seeds.size()) {
            _seedIndex = 0;
        }
        return _seeds.get(_seedIndex);
    }
}

public int[] getSeedAt(int seedIndex) {
    int index = seedIndex;
    if (index < 0) {
        index = 0;
    }

    index = index % _seeds.size();
    return _seeds.get(index);
}

// previous seed, pointer stays the same
public int[] getLastSeed() {
    if (_useRandomSeed) {
        return _getRandomLastSeed();
    } else {
        return _getLastSeed();
    }
}

// next seed, pointer incremements
public int[] getNextSeed() {
    if (_useRandomSeed) {
        return _getRandomNextSeed();
    } else {
        return _getNextSeed();
    }
}

// next seed, pointer incremements
public int[] getPreviousSeed() {
    if (_useRandomSeed) {
        return _getRandomPreviousSeed();
    } else {
        return _getPreviousSeed();
    }
}

public int[] _getNextSeed() {

    _seedIndex++;

    if (_seedIndex >= _seeds.size()) {
        _seedIndex = 0;
    }

    println("getNextSeed - "+_seedIndex+"/"+_seeds.size());
    return _seeds.get(_seedIndex);
}

public int[] _getRandomNextSeed() {

    _randomSeedIndex++;
    if (_randomSeedIndex >= _randomSeeds.size()) {
        int[] rnd = {(int)(frameCount*random(0, 9001)), (int)(frameCount*random(0, 9001))};
        _randomSeeds.add(rnd);
    }

    println("getRandomNextSeed - "+_randomSeedIndex+"/"+_randomSeeds.size());

    return _randomSeeds.get(_randomSeedIndex);
}

public int[] _getLastSeed() {

    return _seeds.get(max(0, _seedIndex - 1));
}

public int[] _getRandomLastSeed() {

    int pntr = _randomSeedIndex - 1; 
    if (pntr < 0) {
        int[] rnd = {(int)(frameCount*random(0, 9001)), (int)(frameCount*random(0, 9001))};
        _randomSeeds.add(0, rnd);
        pntr = 0;
        _randomSeedIndex = 1;
    }

    return _randomSeeds.get(pntr);
}

public int[] _getPreviousSeed() {

    _seedIndex--;

    if (_seedIndex < 0) {
        _seedIndex = _seeds.size() - 1;
    } else if (_seedIndex > _seeds.size()) {
        _seedIndex = 0;
    }

    println("getPreviousSeed - "+_seedIndex+"/"+_seeds.size());

    return _seeds.get(_seedIndex);
}

public int[] _getRandomPreviousSeed() {

    _randomSeedIndex--;

    if (_randomSeedIndex < 0) {
        int[] rnd = {(int)(frameCount*random(0, 9001)), (int)(frameCount*random(0, 9001))};
        _randomSeeds.add(0, rnd);
        _randomSeedIndex = 0;
    }

    println("getRandomPreviousSeed - "+_randomSeedIndex+"/"+_randomSeeds.size());

    return _randomSeeds.get(_randomSeedIndex);
}

public void _loadSeedsFromFile() {

    String[] lines = loadStrings(_seedFileName);

    _seeds = new ArrayList<int[]>();

    println("reading seeds from "+_seedFileName);
    for (int i = 0; i < lines.length; i++) {
        String[] s = lines[i].split(":");
        int noise = Integer.parseInt(s[0]);
        int random = Integer.parseInt(s[1]);
        int[] rnd = {noise, random};

        _seeds.add(rnd);
    }
}

public void _setSeedsFromFile() {
    _loadSeedsFromFile();
    NOISE_SEED = getSeed()[0];
    RANDOM_SEED = getSeed()[1];
    randomSeed(NOISE_SEED);
    randomSeed(RANDOM_SEED);
    println("loaded "+ _seeds.size() +" seeds from file, setting "+NOISE_SEED+" and "+RANDOM_SEED);
}

public void _removeSeedFromFile(String text) {
    //read file
    String[] lines = loadStrings(_seedFileName);
    String[] newSeedFileContents = {};

    for (int i = 0; i < lines.length; i++) {
        if (!text.equals(lines[i])) {
            newSeedFileContents = append(newSeedFileContents, lines[i]);
        }
    }

    saveStrings("data/"+_seedFileName, newSeedFileContents);
}
PGraphics _uiLayer;

boolean SHOW_FPS = false;
boolean SHOW_GRID = false;

float _uiPaletteWidth;

public void drawUI() {
    if (SHOW_FPS || SHOW_GRID) {
        _uiLayer.beginDraw(); 
        _uiLayer.clear();

        if (SHOW_FPS) {
            showFPS();
        }

        if (SHOW_GRID) {
            showGrid();
        }

        image(_uiLayer, 0, 0);

        _uiLayer.endDraw();
    }
}

public void text(PGraphics layer, String text, float x, float y) {
    layer.blendMode(BLEND);
    layer.fill(0xff000000);
    float radius = 1.5f;
    int amount = 16;
    for (int i = 0; i < amount; i++) {
        float c = radians(360.0f / amount * i);
        layer.text(text, x + (sin(c)*radius), y + (cos(c)*radius));
    }
    layer.fill(0xffffffff);
    layer.text(text, x, y);
}

public void showLayerOverview() {
    _uiLayer.beginDraw();
    _uiLayer.textAlign(RIGHT, TOP);
    String text = "";
    String sceneName = "";
    int spriteIndex;

    for (int i = 0; i < LAYERS; i++) {
        String[] bmodes = {"BLEND", "ADD", "SUBTRACT", "DARKEST", "LIGHTEST", "BLEND", "EXCLUSION", "MULTIPLY", "SCREEN", "REPLACE"};
        String blendmode = bmodes[max(0, (int)_moon.getValue("layer"+ (i+1) +":blendmode") % bmodes.length)];
        int index = (int)_moon.getValue("layer"+ (i+1) +":sceneIndex");
        boolean inBounds = (index >= 0) && (index < sceneList.length);
        if (inBounds) {
            sceneName = sceneList[index];
            if (index == 1) {
                spriteIndex = (int)_moon.getValue("layer"+ (i+1) +":sprite.index");
                sceneName = sceneName + "(" + spriteIndex + ")";
            }
        } else sceneName = "INVALID!";
        text += sceneName + "|"+blendmode+"|layer"+(i+1)+"\n";
    }
    text(_uiLayer, text, width - 15 - _uiPaletteWidth, 10); 
    _uiLayer.endDraw();
}

public void showPalette() {
    //needs to be calculated at runtime because width is 0 on initialisation outside of the function
    _uiPaletteWidth = (200.0f/960.0f*width);

    float w = _uiPaletteWidth/(float)paletteList[0].length;
    float h = (118.0f/960.0f*width)/(float)paletteList.length;

    _uiLayer.beginDraw();
    float startX = width - (w*paletteList[0].length) - 10;
    float startY = 10;
    for (int layerI = 0; layerI < layerList.length; layerI++) {
        for (int paletteI = 0; paletteI < paletteList[layerI].length; paletteI++) {
            _uiLayer.fill(paletteList[layerI][paletteI]);
            _uiLayer.rect(startX + w*paletteI, startY + h*layerI, w, h);
        }
    }
    _uiLayer.endDraw();
}

public void showGrid() {
    _uiLayer.beginDraw();
    _uiLayer.blendMode(EXCLUSION);
    _uiLayer.stroke(0xffffffff);
    _uiLayer.strokeWeight(1);
    _uiLayer.line(width/3.0f, (float)0, width/3.0f, (float)height);
    _uiLayer.line(width/3.0f * 2, (float)0, width/3.0f * 2, (float)height);
    _uiLayer.line(0, height/3.0f, width, height/3.0f);
    _uiLayer.line(0, height/3.0f * 2, width, height/3.0f * 2);
    _uiLayer.blendMode(BLEND);
    _uiLayer.endDraw();
}

public void showFPS() {
    _uiLayer.textSize(11/960.0f*width);
    showLayerOverview();
    showPalette();

    _uiLayer.beginDraw();
    _uiLayer.fill(0xffffffff);
    _uiLayer.textAlign(LEFT, TOP);
    text(_uiLayer, ""+round(frameRate), 10, 10);
    _uiLayer.endDraw();
    
    drawEQ();
}
// save frames to disk variables
int frameCounter = 0;
float BPS = 60.0f / BPM;
int SWITCH_EVERY = ceil(BPS * FPS);
int lastFrameSuggestion = floor(MAX_LENGTH / SWITCH_EVERY) * SWITCH_EVERY;
int frameOffset = 0;
int frameDelta = 0;//FPS // FPS means every second one image
int LAST_FRAME = (lastFrameSuggestion + frameOffset) * max(1, frameDelta);

public void initUtils() {

    String path = sketchPath();
    String[] fileList = listFileNames(path+"/data");
    //fileList = sort(fileList);
    //println(fileList);



    //palette
    _paletteImage = loadImage(filterArray(fileList, "palette")[0]);

    //sprites
    String[] spriteFileList = filterArray(fileList, "sprite");
    //println(spriteFileList);
    println("after:");
    spriteFileList = sort(spriteFileList);
    //println(spriteFileList);
    _spriteList = new PImage[spriteFileList.length];
    for (int i = 0; i < spriteFileList.length; i++) {
        _spriteList[i] = loadImage(spriteFileList[i]);
    }



    //objects
    //println(filterArray(fileList, "object"));
}

public void reloadUtils() {
    _paletteImage = loadImage("palette.png");
}

public String[] filterArray(String[] array, String startsWith) {

    String filtered[] = {};

    for (int i=0; i < array.length; i++) {  
        if (array[i].startsWith(startsWith)) {  
            filtered = append(filtered, array[i]);
        }
    }

    return filtered;
}

public void saveFrames() {
    if (SAVE_VIDEO) {
        if ((frameCount > frameOffset) && 
            (frameCount <= LAST_FRAME) ) {
            saveFrame("frame/"+(frameCounter++)+".png");
        }

        if ((frameCount > frameOffset) && (frameCount) == LAST_FRAME) {
            print("done");
            exit();
        }
    }
}

public void _appendTextToFile(String fileName, String text) {
    File f = new File(dataPath(fileName));
    if (!f.exists()) {
        _createFile(f);
    }
    try {
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(f, true)));
        out.println(text);
        out.close();
    }
    catch (IOException e) {
        e.printStackTrace();
    }
}

public void _createFile(File f) {
    File parentDir = f.getParentFile();
    try {
        parentDir.mkdirs(); 
        f.createNewFile();
    }
    catch(Exception e) {
        e.printStackTrace();
    }
}

public String[] listFileNames(String dir) {

    File file = new File(dir);
    if (file.isDirectory()) {
        String names[] = file.list();
        return names;
    } else {
        // If it's not a directory
        return null;
    }
}

public PImage createGradientImage(int w, int h, int[] colors) {
    PImage img = createImage(w, h, RGB);
    int divideColors = colors.length - 1;
    int stepSize = img.height / divideColors;
    img.loadPixels();

    for (int y=0; y<img.height; y++) {  
        int cS = colors[y/stepSize];
        int cE = colors[min((y/stepSize)+1, divideColors)];
        float amt = (float) (y % stepSize) / stepSize;
        int cC = lerpColor(cS, cE, amt*1.3f);

        for (int x=0; x<img.width; x++) {

            int c1 = lerpColor(colors[0], colors[1], ((float)x/width)/2 + ((float)y/height)/2);

            int index = x + y * img.width;
            img.pixels[index] = c1;
        }
    }

    img.updatePixels();
    return img;
}
class CAPass implements Pass
{
    PShader shader;

    private float amount;

    public CAPass()
    {
        shader = loadShader("caFrag.glsl");
    }

    @Override
        public void prepare(Supervisor supervisor) {
        // set parameters of the shader if needed
        //shader.set("amount", .5);
    }

    @Override
        public void apply(Supervisor supervisor) {
        PGraphics pass = supervisor.getNextPass();
        supervisor.clearPass(pass);

        shader.set("amount", this.amount);

        pass.beginDraw();
        pass.shader(shader);

        pass.image(supervisor.getCurrentPass(), 0, 0);
        pass.endDraw();
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public float getAmount() {
        return this.amount;
    }
}
class InvertPass implements Pass
{
    PShader shader;

    private float amount;

    public InvertPass()
    {
        shader = loadShader("invertFrag.glsl");
    }

    @Override
        public void prepare(Supervisor supervisor) {
        // set parameters of the shader if needed
        //shader.set("amount", .5);
    }

    @Override
        public void apply(Supervisor supervisor) {
        PGraphics pass = supervisor.getNextPass();
        supervisor.clearPass(pass);

        shader.set("amount", this.amount);

        pass.beginDraw();
        pass.shader(shader);

        pass.image(supervisor.getCurrentPass(), 0, 0);
        pass.endDraw();
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }

    public float getAmount() {
        return this.amount;
    }
}
    static public void main(String[] passedArgs) {
        String[] appletArgs = new String[] { "--present", "--window-color=#080808", "--hide-stop", "trbl_processing" };
        if (passedArgs != null) {
          PApplet.main(concat(appletArgs, passedArgs));
        } else {
          PApplet.main(appletArgs);
        }
    }
}
