#version 330

${uniforms! }

layout(origin_upper_left) in vec4 gl_FragCoord;

uniform sampler2D image;
uniform vec4 fill;
uniform vec4 stroke;
uniform float strokeWeight;
uniform float[25] colorMatrix;

${varyingIn! }

out vec4 o_color;

vec4 colorTransform(vec4 color, float[25] matrix) {
    float r = color.r * matrix[0] + color.g * matrix[5] + color.b * matrix[10] + color.a * matrix[15] + matrix[20];
    float g = color.r * matrix[1] + color.g * matrix[6] + color.b * matrix[11] + color.a * matrix[16] + matrix[21];
    float b = color.r * matrix[2] + color.g * matrix[7] + color.b * matrix[12] + color.a * matrix[17] + matrix[22];
    float a = color.r * matrix[3] + color.g * matrix[8] + color.b * matrix[13] + color.a * matrix[18] + matrix[23];
    return vec4(r, g, b, a);
}

void main(void) {
    vec4 x_fill = texture(image, v_texCoord0);
    vec4 x_stroke = stroke;
    {
        ${fragmentTransform! }
    }

    x_fill = colorTransform(x_fill, colorMatrix);

    o_color = x_fill;
//    o_color.rgb *= o_color.a;

}