#version 330

${uniforms! }

layout(origin_upper_left) in vec4 gl_FragCoord;

uniform vec4 fill;
uniform vec4 stroke;
uniform float strokeWeight;

${varyingIn! }

out vec4 o_color;

void main(void) {
    vec4 x_fill = fill;
    vec4 x_stroke = stroke;
    {
        ${fragmentTransform! }
    }
    float wd = fwidth(length(v_texCoord0 - vec2(0.5)));
    float d = length(v_texCoord0 - vec2(0.5)) * 2;

    float f = smoothstep(0, wd * 2.5, 1.0 - d);
    float b = 0.1;
    float f2 = smoothstep(0, wd * 2.5, 1.0 - b - d) * f;

    o_color = vec4(x_fill.rgb*f2 + x_stroke.rgb*(1.0-f2), (x_fill.a*f) * f2 + (x_stroke.a*f) * (1.0-f2) );

//    o_color.a = 0.0;
    o_color.rgb*=o_color.a;

}