/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.typography;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.Drawer;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ShapeContour;
import studio.rndr.typography.CellContext;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\u001aJ\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\f\u001a8\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u001a\"\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u00052\b\b\u0002\u0010\u0014\u001a\u00020\u0005\u00a8\u0006\u0015"}, d2={"drawGrid", "", "drawer", "Lorg/openrndr/draw/Drawer;", "width", "", "height", "rows", "", "columns", "gutter", "cellFunction", "Lkotlin/Function1;", "Lstudio/rndr/typography/CellContext;", "lineGrid", "margin", "cross", "", "starGrid", "start", "end", "demo-paddock"})
public final class LineGridsKt {
    public static final void starGrid(@NotNull Drawer drawer, double start, double end2) {
        Drawer drawer2;
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Drawer $receiver = drawer2 = drawer;
        Vector2 c = new Vector2((double)$receiver.getWidth() / 2.0, (double)$receiver.getHeight() / 2.0);
        $receiver.contour(ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{new Vector2(0.0, (double)$receiver.getHeight() / 2.0), c}), false).sub(start, end2));
        $receiver.contour(ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{new Vector2((double)$receiver.getWidth() * 1.0, (double)$receiver.getHeight() / 2.0), c}), false).sub(start, end2));
        $receiver.contour(ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{new Vector2((double)$receiver.getWidth() / 2.0, 0.0), c}), false).sub(start, end2));
        $receiver.contour(ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{new Vector2((double)$receiver.getWidth() / 2.0, (double)$receiver.getHeight() * 1.0), c}), false).sub(start, end2));
        $receiver.contour(ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{new Vector2((double)($receiver.getWidth() - $receiver.getHeight()) / 2.0, (double)$receiver.getHeight() * 1.0), c}), false).sub(start, end2));
        $receiver.contour(ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{new Vector2((double)($receiver.getWidth() - $receiver.getHeight()) / 2.0, (double)$receiver.getHeight() * 0.0), c}), false).sub(start, end2));
        $receiver.contour(ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{new Vector2((double)$receiver.getWidth() - (double)($receiver.getWidth() - $receiver.getHeight()) / 2.0, (double)$receiver.getHeight() * 1.0), c}), false).sub(start, end2));
        $receiver.contour(ShapeContour.Companion.fromPoints(CollectionsKt.listOf(new Vector2[]{new Vector2((double)$receiver.getWidth() - (double)($receiver.getWidth() - $receiver.getHeight()) / 2.0, (double)$receiver.getHeight() * 0.0), c}), false).sub(start, end2));
    }

    public static /* bridge */ /* synthetic */ void starGrid$default(Drawer drawer, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d = 0.0;
        }
        if ((n & 4) != 0) {
            d2 = 1.0;
        }
        LineGridsKt.starGrid(drawer, d, d2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void drawGrid(@NotNull Drawer drawer, double width, double height, int rows, int columns, double gutter, @NotNull Function1<? super CellContext, Unit> cellFunction) {
        Drawer drawer2;
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(cellFunction, "cellFunction");
        Drawer $receiver = drawer2 = drawer;
        double effectiveWidth = width - (double)Math.max(0, columns - 1) * gutter;
        double effectiveHeight = height - (double)Math.max(0, rows - 1) * gutter;
        double cellWidth = effectiveWidth / (double)columns;
        double cellHeight = effectiveHeight / (double)rows;
        double y = 0.0;
        int n = 0;
        int n2 = rows;
        while (n < n2) {
            void j;
            double x = 0.0;
            int n3 = 0;
            int n4 = columns;
            while (n3 < n4) {
                void i;
                $receiver.pushView();
                $receiver.translate(x, y);
                cellFunction.invoke(new CellContext((int)i, (int)j, x, y, cellWidth, cellHeight));
                $receiver.popView();
                x += cellWidth;
                x += gutter;
                ++i;
            }
            y += cellHeight;
            y += gutter;
            ++j;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void lineGrid(@NotNull Drawer drawer, int rows, int columns, double margin, double gutter, boolean cross) {
        Drawer drawer2;
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        List segments = new ArrayList();
        Drawer $receiver = drawer2 = drawer;
        double effectiveWidth = (double)drawer.getWidth() - margin * 2.0 - (double)Math.max(0, columns - 1) * gutter;
        double effectiveHeight = (double)drawer.getHeight() - margin * 2.0 - (double)Math.max(0, rows - 1) * gutter;
        double cellWidth = effectiveWidth / (double)columns;
        double cellHeight = effectiveHeight / (double)rows;
        double y = margin;
        int n = 0;
        int n2 = rows;
        while (n < n2) {
            void j;
            double x = margin;
            int n3 = 0;
            int n4 = columns;
            while (n3 < n4) {
                void i;
                segments.add(new Vector2(x, y));
                segments.add(new Vector2(x + cellWidth, y));
                segments.add(new Vector2(x + cellWidth, y));
                segments.add(new Vector2(x + cellWidth, y + cellHeight));
                segments.add(new Vector2(x + cellWidth, y + cellHeight));
                segments.add(new Vector2(x, y + cellHeight));
                segments.add(new Vector2(x, y + cellHeight));
                segments.add(new Vector2(x, y));
                if (cross) {
                    segments.add(new Vector2(x, y));
                    segments.add(new Vector2(x + cellWidth, y + cellHeight));
                    segments.add(new Vector2(x + cellWidth, y));
                    segments.add(new Vector2(x, y + cellHeight));
                }
                x += cellWidth;
                x += gutter;
                ++i;
            }
            y += cellHeight;
            y += gutter;
            ++j;
        }
        drawer.lineSegments(segments);
    }

    public static /* bridge */ /* synthetic */ void lineGrid$default(Drawer drawer, int n, int n2, double d, double d2, boolean bl, int n3, Object object) {
        if ((n3 & 0x20) != 0) {
            bl = false;
        }
        LineGridsKt.lineGrid(drawer, n, n2, d, d2, bl);
    }
}

