/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.screens;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.math.Matrix44;
import org.openrndr.math.transforms.TransformBuilderKt;
import org.openrndr.shape.Composition;
import org.openrndr.shape.ShapeNode;
import org.openrndr.svg.SVGLoaderKt;
import studio.rndr.modeling.ModelingKt;
import studio.rndr.screens.Sign;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lstudio/rndr/screens/Sign;", "", "()V", "text", "Lorg/openrndr/draw/VertexBuffer;", "getText", "()Lorg/openrndr/draw/VertexBuffer;", "textVertices", "", "getTextVertices", "()I", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "gbuffer", "Lorg/openrndr/draw/RenderTarget;", "time", "", "previousViewMatrix", "Lorg/openrndr/math/Matrix44;", "demo-paddock"})
public final class Sign {
    @NotNull
    private final VertexBuffer text = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(text.1.INSTANCE), 154384);
    private final int textVertices;

    @NotNull
    public final VertexBuffer getText() {
        return this.text;
    }

    public final int getTextVertices() {
        return this.textVertices;
    }

    public final void draw(@NotNull Drawer drawer, @NotNull RenderTarget gbuffer2, double time, @NotNull Matrix44 previousViewMatrix) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(gbuffer2, "gbuffer");
        Intrinsics.checkParameterIsNotNull(previousViewMatrix, "previousViewMatrix");
        drawer.setFill(new ColorRGBa(10.0, 1.0, 1.0, 0.0, null, 24, null));
        Matrix44 positionTransform2 = TransformBuilderKt.transform(draw.positionTransform.1.INSTANCE);
        drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(time, gbuffer2, previousViewMatrix, positionTransform2){
            final /* synthetic */ double $time;
            final /* synthetic */ RenderTarget $gbuffer;
            final /* synthetic */ Matrix44 $previousViewMatrix;
            final /* synthetic */ Matrix44 $positionTransform;

            public final void invoke(@NotNull ShadeStyle $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.parameter("time", this.$time);
                $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                ");
                $receiver.setVertexTransform("\n                    vec3 oldPosition = x_position +  (0.5+0.5*cos(objectId +.1*p_time-0.1/30.0)) * up * 40.0 * 0.0;\n                    oldPosition += (0.5 + 0.5 * cos(objectId *0.4 + p_time)) * normal*10.0 * 0.0;\n                    x_position +=(cos(objectId + 0.1*p_time)*0.5+0.5) * up * 40.0 * 0.0;\n                    x_position +=  (0.5 + 0.5 * cos(objectId *0.4 + p_time)) * normal*10.0 * 0.0;\n                    previousView = (p_previousViewMatrix * vec4( oldPosition, 1.0));\n                    vec4 pclip = projectionMatrix * previousView;\n                    //pclip.xyz /= pclip.w;\n                    previousClip = pclip;\n                    //x_position += x_normal*(cos(x_position.x+x_position.y+p_time)*10.0+10.0);\n                    currentClip = projectionMatrix * viewMatrix * vec4(x_position, 1.0);\n                ");
                $receiver.setFragmentTransform("\n                    o_position.xyz = view.position;\n                    o_position.w = 1.0;\n                    o_normal.xyz = view.normal;\n                    o_normal.w = 1.0;\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.05;\n                    //x_fill.rgb += (object.normal.z) * vec3(1.0, 1.05, 1.1) * (0.5+0.5*cos(object.position.x*0.01+0.01*object.position.y));\n                    //x_fill.rgb *= (sin(object.position.z*4.0)*0.5+0.5);\n                    //x_fill.rgb *= cos(v_objectId+object.position.z*4.0)*0.5+0.5;\n                    x_fill.rgb /= max(1.0, -(view.position.z/10.0)-20.0);\n                    //x_fill.rgb += vec3(0.1);\n                    ");
                $receiver.output("position", this.$gbuffer.colorBufferIndex("position"));
                $receiver.output("normal", this.$gbuffer.colorBufferIndex("normal"));
                $receiver.output("velocity", this.$gbuffer.colorBufferIndex("velocity"));
                $receiver.parameter("previousViewMatrix", this.$previousViewMatrix.times(this.$positionTransform));
            }
            {
                this.$time = d;
                this.$gbuffer = renderTarget;
                this.$previousViewMatrix = matrix44;
                this.$positionTransform = matrix442;
                super(1);
            }
        }));
        drawer.pushView();
        Drawer drawer2 = drawer;
        drawer2.setView(drawer2.getView().times(positionTransform2));
        Drawer.vertexBuffer$default(drawer, this.text, DrawPrimitive.TRIANGLES, 0, 0, 12, null);
        drawer.popView();
    }

    public Sign() {
        final Composition svg = SVGLoaderKt.loadSVG(FilesKt.readText$default(new File("data/sign-2.svg"), null, 1, null));
        this.textVertices = this.text.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@NotNull BufferWriter $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Iterable $receiver$iv = svg.findShapes();
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void it;
                    int n = index$iv++;
                    ShapeNode shapeNode = (ShapeNode)item$iv;
                    int idx = n;
                    ModelingKt.extrudeContour$default(it.getShape().getOutline(), 10.0, (double)idx * 1.0, $receiver, true, false, 32, null);
                }
            }
        });
    }
}

