/*
 * Decompiled with CFR 0.152.
 */
package studio.rndr.screens;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.DrawerKt;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleKt;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.shape.ContourBuilder;
import org.openrndr.shape.ShapeBuilderKt;
import org.openrndr.shape.ShapeContour;
import studio.rndr.modeling.ModelingKt;
import studio.rndr.screens.City;
import studio.rndr.screens.CityStyle;
import studio.rndr.screens.MapDrawerKt;
import studio.rndr.screens.MapScene;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lstudio/rndr/screens/City;", "", "()V", "box", "Lorg/openrndr/draw/VertexBuffer;", "boxVertexCount", "", "floor", "floorVertexCount", "getFloorVertexCount", "()I", "mesh", "style", "Lstudio/rndr/screens/CityStyle;", "getStyle", "()Lstudio/rndr/screens/CityStyle;", "setStyle", "(Lstudio/rndr/screens/CityStyle;)V", "vertexCount", "draw", "", "drawer", "Lorg/openrndr/draw/Drawer;", "gbuffer", "Lorg/openrndr/draw/RenderTarget;", "time", "", "previousViewMatrix", "Lorg/openrndr/math/Matrix44;", "demo-paddock"})
public final class City {
    @NotNull
    private CityStyle style = new CityStyle(ColorRGBa.Companion.getWHITE().shade(0.25), 1.0, 0.0, 0.0, 0.0, null, 0.0, 120, null);
    private final VertexBuffer floor = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(floor.1.INSTANCE), 40);
    private final int floorVertexCount;
    private final VertexBuffer box = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(box.1.INSTANCE), 40);
    private final int boxVertexCount;
    private final VertexBuffer mesh = DrawerKt.vertexBuffer(DrawerKt.vertexFormat(mesh.1.INSTANCE), 600000);
    private final int vertexCount;

    @NotNull
    public final CityStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@NotNull CityStyle cityStyle) {
        Intrinsics.checkParameterIsNotNull(cityStyle, "<set-?>");
        this.style = cityStyle;
    }

    public final int getFloorVertexCount() {
        return this.floorVertexCount;
    }

    public final void draw(@NotNull Drawer drawer, @NotNull RenderTarget gbuffer2, double time, @NotNull Matrix44 previousViewMatrix) {
        Intrinsics.checkParameterIsNotNull(drawer, "drawer");
        Intrinsics.checkParameterIsNotNull(gbuffer2, "gbuffer");
        Intrinsics.checkParameterIsNotNull(previousViewMatrix, "previousViewMatrix");
        drawer.pushStyle();
        drawer.setShadeStyle(ShadeStyleKt.shadeStyle((Function1<? super ShadeStyle, Unit>)new Function1<ShadeStyle, Unit>(this, time, gbuffer2, previousViewMatrix){
            final /* synthetic */ City this$0;
            final /* synthetic */ double $time;
            final /* synthetic */ RenderTarget $gbuffer;
            final /* synthetic */ Matrix44 $previousViewMatrix;

            public final void invoke(@NotNull ShadeStyle $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                $receiver.parameter("time", this.$time);
                $receiver.setVertexPreamble("\n                    out vec4 previousView;\n                    out vec4 previousClip;\n                    out vec4 currentClip;\n                ");
                $receiver.setFragmentPreamble("\n                    in vec4 previousView;\n                    in vec4 previousClip;\n                    in vec4 currentClip;\n                ");
                $receiver.setVertexTransform("\n                    vec3 oldPosition = x_position +  (0.5+0.5*cos(objectId +.1*p_time-0.1/30.0)) * up * 40.0 * 0.0;\n                    oldPosition += (0.5 + 0.5 * cos(objectId *0.4 + p_time)) * normal*10.0 * p_explode;\n                    x_position +=(cos(objectId + 0.1*p_time)*0.5+0.5) * up * 40.0 * 0.0;\n                    x_position +=  (0.5 + 0.5 * cos(objectId *0.4 + p_time)) * normal*10.0 * p_explode;\n                    previousView = (p_previousViewMatrix * vec4( oldPosition, 1.0));\n                    vec4 pclip = projectionMatrix * previousView;\n                    previousClip = pclip;\n                    currentClip = projectionMatrix * viewMatrix * vec4(x_position, 1.0);\n                ");
                $receiver.setFragmentTransform("\n                    o_position.xyz = view.position;\n                    o_position.w = 1.0;\n                    o_normal.xyz = view.normal;\n                    o_normal.w = 1.0;\n                    o_velocity.xy = (currentClip/currentClip.w - previousClip/previousClip.w).xy*vec2(1280, 720)*0.05;\n                    x_fill.rgb +=  p_upIntensity *( (object.normal.z) * vec3(1.0, 1.05, 1.1) * (0.5+0.5*cos(object.position.x*0.01+0.01*object.position.y)));\n\n                    x_fill.rgb += vec3(smoothstep(4.0, 0.0, abs(v_objectId-p_selected)));\n\n                    //x_fill.rgb *= (sin(object.position.z*4.0)*0.5+0.5);\n                    x_fill.rgb *=  1.0 - p_patternIntensity * (cos(v_objectId+object.position.z*4.0)*0.5+0.5);\n                    x_fill.rgb /= max(1.0, -(view.position.z/10.0)-20.0);\n                    //x_fill.rgb += vec3(0.1);\n                    ");
                $receiver.output("position", this.$gbuffer.colorBufferIndex("position"));
                $receiver.output("normal", this.$gbuffer.colorBufferIndex("normal"));
                $receiver.output("velocity", this.$gbuffer.colorBufferIndex("velocity"));
                $receiver.parameter("previousViewMatrix", this.$previousViewMatrix);
                $receiver.parameter("patternIntensity", this.this$0.getStyle().getPatternIntensity());
                $receiver.parameter("upIntensity", this.this$0.getStyle().getUpIntensity());
                $receiver.parameter("explode", this.this$0.getStyle().getExplode());
                $receiver.parameter("selected", this.this$0.getStyle().getSelected());
            }
            {
                this.this$0 = city;
                this.$time = d;
                this.$gbuffer = renderTarget;
                this.$previousViewMatrix = matrix44;
                super(1);
            }
        }));
        drawer.setFill(new ColorRGBa(0.0, 0.0, 0.0, 0.0, null, 24, null));
        ShadeStyle shadeStyle = drawer.getShadeStyle();
        if (shadeStyle != null) {
            shadeStyle.parameter("upIntensity", 0.0);
        }
        ShadeStyle shadeStyle2 = drawer.getShadeStyle();
        if (shadeStyle2 != null) {
            shadeStyle2.parameter("patternIntensity", 0.0);
        }
        drawer.vertexBuffer(this.box, DrawPrimitive.TRIANGLES, 0, this.boxVertexCount);
        drawer.setFill(this.style.getFloorFill());
        ShadeStyle shadeStyle3 = drawer.getShadeStyle();
        if (shadeStyle3 != null) {
            shadeStyle3.parameter("upIntensity", this.style.getFloorUpIntensity());
        }
        drawer.vertexBuffer(this.floor, DrawPrimitive.TRIANGLES, 0, this.floorVertexCount);
        drawer.setFill(this.style.getFill());
        ShadeStyle shadeStyle4 = drawer.getShadeStyle();
        if (shadeStyle4 != null) {
            shadeStyle4.parameter("upIntensity", this.style.getUpIntensity());
        }
        ShadeStyle shadeStyle5 = drawer.getShadeStyle();
        if (shadeStyle5 != null) {
            shadeStyle5.parameter("patternIntensity", this.style.getPatternIntensity());
        }
        drawer.vertexBuffer(this.mesh, DrawPrimitive.TRIANGLES, 0, this.vertexCount);
        drawer.popStyle();
    }

    public City() {
        final MapScene map = MapDrawerKt.loadMapScene(new File("data/map.json.lzma"));
        this.boxVertexCount = this.box.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

            @Override
            public final void invoke(@NotNull BufferWriter $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                ModelingKt.extrudeContour(ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(){

                    @Override
                    public final void invoke(@NotNull ContourBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.moveTo(map.getBounds().getCorner().minus(new Vector2(200.0, 200.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(map.getBounds().getWidth() + 400.0, 0.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(0.0, map.getBounds().getHeight() + 400.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(-(map.getBounds().getWidth() + 400.0), 0.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(0.0, -(map.getBounds().getHeight() + 400.0))));
                    }
                }), 300.0, 0.0, $receiver, false, false);
            }
        });
        this.floorVertexCount = this.floor.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

            @Override
            public final void invoke(@NotNull BufferWriter $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                ModelingKt.extrudeContour(ShapeBuilderKt.contour((Function1<? super ContourBuilder, Unit>)new Function1<ContourBuilder, Unit>(){

                    @Override
                    public final void invoke(@NotNull ContourBuilder $receiver) {
                        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                        $receiver.moveTo(map.getBounds().getCorner().minus(new Vector2(200.0, 200.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(map.getBounds().getWidth() + 400.0, 0.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(0.0, map.getBounds().getHeight() + 400.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(-(map.getBounds().getWidth() + 400.0), 0.0)));
                        $receiver.lineTo($receiver.getCursor().plus(new Vector2(0.0, -(map.getBounds().getHeight() + 400.0))));
                    }
                }), 0.0, 0.0, $receiver, true, false);
            }
        });
        this.vertexCount = this.mesh.put((Function1<? super BufferWriter, Unit>)new Function1<BufferWriter, Unit>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void invoke(@NotNull BufferWriter $receiver) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                Random random = new Random(303808909L);
                Iterable iterable = $receiver$iv = (Iterable)map.getBuildings();
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                int index$iv$iv = 0;
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void idx;
                    void it;
                    int n = index$iv$iv++;
                    List list = (List)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    ModelingKt.extrudeContour$default(ShapeContour.Companion.fromPoints((List<Vector2>)it, true), 5.0 + random.nextDouble() * 50.0, (double)idx + 1.0, $receiver, true, false, 32, null);
                    Unit unit = Unit.INSTANCE;
                    collection.add(unit);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
            }
        });
    }
}

