/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.svg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Element;
import org.openrndr.color.ColorRGBa;
import org.openrndr.math.Vector2;
import org.openrndr.shape.Segment;
import org.openrndr.shape.Shape;
import org.openrndr.shape.ShapeContour;
import org.openrndr.svg.Command;
import org.openrndr.svg.SVGElement;
import org.openrndr.svg.SVGLoaderKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/openrndr/svg/SVGPath;", "Lorg/openrndr/svg/SVGElement;", "()V", "commands", "", "Lorg/openrndr/svg/Command;", "getCommands", "()Ljava/util/List;", "fill", "Lorg/openrndr/color/ColorRGBa;", "getFill", "()Lorg/openrndr/color/ColorRGBa;", "setFill", "(Lorg/openrndr/color/ColorRGBa;)V", "stroke", "getStroke", "setStroke", "strokeWeight", "", "getStrokeWeight", "()Ljava/lang/Double;", "setStrokeWeight", "(Ljava/lang/Double;)V", "Ljava/lang/Double;", "compounds", "", "parseDrawAttributes", "", "e", "Lorg/jsoup/nodes/Element;", "shape", "Lorg/openrndr/shape/Shape;", "Companion", "openrndr-svg"})
public final class SVGPath
extends SVGElement {
    @NotNull
    private final List<Command> commands;
    @Nullable
    private ColorRGBa fill;
    @Nullable
    private ColorRGBa stroke;
    @Nullable
    private Double strokeWeight;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Command> getCommands() {
        return this.commands;
    }

    @Nullable
    public final ColorRGBa getFill() {
        return this.fill;
    }

    public final void setFill(@Nullable ColorRGBa colorRGBa) {
        this.fill = colorRGBa;
    }

    @Nullable
    public final ColorRGBa getStroke() {
        return this.stroke;
    }

    public final void setStroke(@Nullable ColorRGBa colorRGBa) {
        this.stroke = colorRGBa;
    }

    @Nullable
    public final Double getStrokeWeight() {
        return this.strokeWeight;
    }

    public final void setStrokeWeight(@Nullable Double d) {
        this.strokeWeight = d;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SVGPath> compounds() {
        int index;
        List compounds = new ArrayList();
        List compoundIndices = new ArrayList();
        Iterable $receiver$iv = this.commands;
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void it;
            int n = index$iv++;
            Command command = (Command)item$iv;
            index = n;
            if (!Intrinsics.areEqual(it.getOp(), "M") && !Intrinsics.areEqual(it.getOp(), "m")) continue;
            compoundIndices.add(index);
        }
        $receiver$iv = compoundIndices;
        index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            int n = index$iv++;
            int it = ((Number)item$iv).intValue();
            index = n;
            int cs = ((Number)compoundIndices.get(index)).intValue();
            int ce = index + 1 < compoundIndices.size() ? ((Number)compoundIndices.get(index + 1)).intValue() : this.commands.size();
            SVGPath path = new SVGPath();
            path.commands.addAll((Collection<Command>)this.commands.subList(cs, ce));
            if (compoundIndices.size() > 1) {
                path.commands.add(new Command("Z", new double[0]));
            }
            compounds.add(path);
        }
        return compounds;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Shape shape() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Object cursor = new Vector2(0.0, 0.0);
        Vector2 anchor = Vector2.copy$default((Vector2)cursor, 0.0, 0.0, 3, null);
        Vector2 relativeControl = new Vector2(0.0, 0.0);
        Iterable iterable = $receiver$iv = (Iterable)this.compounds();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void compound;
            SVGPath sVGPath = (SVGPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            List segments = new ArrayList();
            boolean closed = false;
            Iterable $receiver$iv2 = compound.commands;
            block36: for (Object element$iv : $receiver$iv2) {
                Command command = (Command)element$iv;
                switch (command.getOp()) {
                    case "M": {
                        Object object;
                        Object object2;
                        Object point;
                        cursor = command.vector(0, 1);
                        anchor = cursor;
                        List<Vector2> allPoints = command.vectors();
                        int n = 1;
                        int n2 = allPoints.size();
                        while (n < n2) {
                            void i;
                            point = allPoints.get((int)i);
                            object2 = segments;
                            object = new Segment((Vector2)cursor, (Vector2)point);
                            object2.add(object);
                            cursor = point;
                            ++i;
                        }
                        continue block36;
                    }
                    case "m": {
                        Object object;
                        Object object2;
                        Object point;
                        List<Vector2> allPoints = command.vectors();
                        cursor = ((Vector2)cursor).plus(command.vector(0, 1));
                        anchor = cursor;
                        int n = allPoints.size();
                        for (int i = 1; i < n; ++i) {
                            point = allPoints.get(i);
                            object2 = segments;
                            object = new Segment((Vector2)cursor, ((Vector2)cursor).plus((Vector2)point));
                            object2.add(object);
                            cursor = ((Vector2)cursor).plus((Vector2)point);
                        }
                        continue block36;
                    }
                    case "L": {
                        Object object2;
                        Object point;
                        List<Vector2> allPoints = command.vectors();
                        for (Vector2 point2 : allPoints) {
                            point = segments;
                            object2 = new Segment((Vector2)cursor, point2);
                            point.add(object2);
                            cursor = point2;
                        }
                        continue block36;
                    }
                    case "l": {
                        Object target;
                        Object object;
                        Object object2;
                        List<Vector2> allPoints = command.vectors();
                        for (Vector2 point : allPoints) {
                            target = ((Vector2)cursor).plus(point);
                            object2 = segments;
                            object = new Segment((Vector2)cursor, (Vector2)target);
                            object2.add(object);
                            cursor = target;
                        }
                        continue block36;
                    }
                    case "h": {
                        Object target;
                        Object object;
                        Object object2;
                        int allPoints = 0;
                        int point = command.getOperands().length;
                        while (allPoints < point) {
                            void i;
                            Vector2 startCursor = cursor;
                            target = startCursor.plus(new Vector2(command.getOperands()[i], 0.0));
                            object2 = segments;
                            object = new Segment((Vector2)cursor, (Vector2)target);
                            object2.add(object);
                            cursor = target;
                            ++i;
                        }
                        continue block36;
                    }
                    case "H": {
                        Object target;
                        Object object2;
                        int point = command.getOperands().length;
                        for (int i = 0; i < point; ++i) {
                            Vector2 target2 = new Vector2(command.getOperands()[i], ((Vector2)cursor).getY());
                            target = segments;
                            object2 = new Segment((Vector2)cursor, target2);
                            target.add(object2);
                            cursor = target2;
                        }
                        continue block36;
                    }
                    case "v": {
                        Object target;
                        Object object2;
                        int point = command.getOperands().length;
                        for (int i = 0; i < point; ++i) {
                            Vector2 target3 = ((Vector2)cursor).plus(new Vector2(0.0, command.getOperands()[i]));
                            target = segments;
                            object2 = new Segment((Vector2)cursor, target3);
                            target.add(object2);
                            cursor = target3;
                        }
                        continue block36;
                    }
                    case "V": {
                        Object target;
                        Object object2;
                        int point = command.getOperands().length;
                        for (int i = 0; i < point; ++i) {
                            Vector2 target4 = new Vector2(((Vector2)cursor).getX(), command.getOperands()[i]);
                            target = segments;
                            object2 = new Segment((Vector2)cursor, target4);
                            target.add(object2);
                            cursor = target4;
                        }
                        continue block36;
                    }
                    case "C": {
                        List<Vector2> points = command.vectors();
                        Collection point = segments;
                        Segment target4 = new Segment((Vector2)cursor, points.get(0), points.get(1), points.get(2));
                        point.add(target4);
                        cursor = points.get(2);
                        relativeControl = points.get(1).minus(points.get(2));
                        break;
                    }
                    case "c": {
                        List<Vector2> points = command.vectors();
                        Collection point = segments;
                        Segment target4 = new Segment((Vector2)cursor, ((Vector2)cursor).plus(points.get(0)), ((Vector2)cursor).plus(points.get(1)), ((Vector2)cursor).plus(points.get(2)));
                        point.add(target4);
                        relativeControl = ((Vector2)cursor).plus(points.get(1)).minus(((Vector2)cursor).plus(points.get(2)));
                        cursor = ((Vector2)cursor).plus(points.get(2));
                        break;
                    }
                    case "Q": {
                        List<Vector2> points;
                        Object object;
                        Object object2;
                        List<Vector2> allPoints = command.vectors();
                        if (allPoints.size() % 2 != 0) {
                            throw (Throwable)new RuntimeException("invalid number of operands " + allPoints.size());
                        }
                        int point = 0;
                        int target4 = allPoints.size() / 2;
                        while (point < target4) {
                            void c;
                            points = allPoints.subList((int)(c * 2), (int)(c * 2 + 2));
                            object2 = segments;
                            object = new Segment((Vector2)cursor, points.get(0), points.get(1));
                            object2.add(object);
                            cursor = points.get(1);
                            relativeControl = points.get(0).minus(points.get(1));
                            ++c;
                        }
                        continue block36;
                    }
                    case "q": {
                        List<Vector2> points;
                        Object object;
                        List<Vector2> allPoints = command.vectors();
                        if (allPoints.size() % 2 != 0) {
                            throw (Throwable)new RuntimeException("invalid number of operands " + allPoints.size());
                        }
                        int target4 = allPoints.size() / 2;
                        for (int c = 0; c < target4; ++c) {
                            points = allPoints.subList(c * 2, c * 2 + 2);
                            Vector2 target = ((Vector2)cursor).plus(points.get(1));
                            object = segments;
                            Segment segment = new Segment((Vector2)cursor, ((Vector2)cursor).plus(points.get(0)), target);
                            object.add(segment);
                            relativeControl = ((Vector2)cursor).plus(points.get(0)).minus(((Vector2)cursor).plus(points.get(1)));
                            cursor = target;
                        }
                        continue block36;
                    }
                    case "s": {
                        Vector2 relected = relativeControl.times(-1.0);
                        Vector2 cp0 = ((Vector2)cursor).plus(relected);
                        Vector2 cp1 = ((Vector2)cursor).plus(command.vector(0, 1));
                        Object target = ((Vector2)cursor).plus(command.vector(2, 3));
                        Object object2 = segments;
                        Object object = new Segment((Vector2)cursor, cp0, cp1, (Vector2)target);
                        object2.add(object);
                        cursor = target;
                        relativeControl = cp1.minus((Vector2)target);
                        break;
                    }
                    case "S": {
                        Vector2 reflected = relativeControl.times(-1.0);
                        Vector2 cp0 = ((Vector2)cursor).plus(reflected);
                        Vector2 cp1 = ((Vector2)cursor).plus(command.vector(0, 1));
                        Object target = ((Vector2)cursor).plus(command.vector(2, 3));
                        Object object2 = segments;
                        Object object = new Segment((Vector2)cursor, cp0, cp1, (Vector2)target);
                        object2.add(object);
                        cursor = target;
                        relativeControl = cp1.minus((Vector2)target);
                        break;
                    }
                    case "Z": 
                    case "z": {
                        if (((Vector2)cursor).minus(anchor).getLength() >= 0.001) {
                            Collection collection2 = segments;
                            Segment segment = new Segment((Vector2)cursor, anchor);
                            collection2.add(segment);
                        }
                        closed = true;
                        break;
                    }
                    default: {
                        throw (Throwable)new RuntimeException("unsupport op: " + command.getOp());
                    }
                }
            }
            ShapeContour shapeContour = new ShapeContour(segments, closed);
            collection.add(shapeContour);
        }
        List contours = (List)destination$iv$iv;
        return new Shape(contours);
    }

    public final void parseDrawAttributes(@NotNull Element e) {
        Double d;
        Double d2;
        String it;
        Intrinsics.checkParameterIsNotNull(e, "e");
        String string = e.attr("fill");
        Intrinsics.checkExpressionValueIsNotNull(string, "e.attr(\"fill\")");
        this.fill = SVGLoaderKt.parseColor(string);
        String string2 = e.attr("stroke");
        Intrinsics.checkExpressionValueIsNotNull(string2, "e.attr(\"stroke\")");
        this.stroke = SVGLoaderKt.parseColor(string2);
        String string3 = e.attr("stroke-width");
        SVGPath sVGPath = this;
        String string4 = it = string3;
        Intrinsics.checkExpressionValueIsNotNull(string4, "it");
        CharSequence charSequence = string4;
        if (charSequence.length() == 0) {
            d2 = null;
        } else {
            charSequence = it;
            d2 = Double.parseDouble((String)charSequence);
        }
        sVGPath.strokeWeight = d = d2;
        String string5 = e.attr("style");
        Intrinsics.checkExpressionValueIsNotNull(string5, "e.attr(\"style\")");
        Iterable $receiver$iv = StringsKt.split$default((CharSequence)string5, new String[]{";"}, false, 0, 6, null);
        for (Object element$iv : $receiver$iv) {
            String string6;
            String string7;
            String it2 = (String)element$iv;
            List tokens = StringsKt.split$default((CharSequence)it2, new String[]{":"}, false, 0, 6, null);
            String string8 = string7 = (String)tokens.get(0);
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.String).toLowerCase()");
            String string10 = string7 = string9;
            if (string10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String attribute = ((Object)StringsKt.trim((CharSequence)string10)).toString();
            String string11 = string6 = (String)tokens.get(1);
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String value = ((Object)StringsKt.trim((CharSequence)string11)).toString();
            switch (attribute) {
                case "fill": {
                    this.fill = SVGLoaderKt.parseColor(value);
                    break;
                }
                case "stroke": {
                    this.stroke = SVGLoaderKt.parseColor(value);
                    break;
                }
                case "stroke-width": {
                    String string12 = value;
                    SVGPath sVGPath2 = this;
                    double d3 = Double.parseDouble(string12);
                    sVGPath2.strokeWeight = d3;
                }
            }
        }
    }

    public SVGPath() {
        super(null);
        List list;
        SVGPath sVGPath = this;
        sVGPath.commands = list = (List)new ArrayList();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/openrndr/svg/SVGPath$Companion;", "", "()V", "fromSVGPathString", "Lorg/openrndr/svg/SVGPath;", "svgPath", "", "openrndr-svg"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final SVGPath fromSVGPathString(@NotNull String svgPath) {
            List<String> list;
            CharSequence charSequence;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull(svgPath, "svgPath");
            SVGPath path = new SVGPath();
            Object object = svgPath;
            Object object2 = "(?=[MmZzLlHhVvCcSsQqTtAa])";
            object2 = new Regex((String)object2);
            int n = 0;
            object = ((Regex)object2).split((CharSequence)object, n);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, iterator$iv.nextIndex() + 1);
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List<String> rawCommands = list;
            Pattern numbers = Pattern.compile("[-+]?[0-9]*[.]?[0-9]+(?:[eE][-+]?[0-9]+)?");
            for (String rawCommand : rawCommands) {
                charSequence = rawCommand;
                if (!(charSequence.length() > 0)) continue;
                Matcher numberMatcher = numbers.matcher(rawCommand);
                List operands = new ArrayList();
                while (numberMatcher.find()) {
                    String string;
                    Intrinsics.checkExpressionValueIsNotNull(numberMatcher.group(), "numberMatcher.group()");
                    List list2 = operands;
                    double d = Double.parseDouble(string);
                    list2.add(d);
                }
                double[] dArray = CollectionsKt.toDoubleArray(operands);
                path.getCommands().add(new Command(String.valueOf(rawCommand.charAt(0)), Arrays.copyOf(dArray, dArray.length)));
            }
            return path;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

