/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal.gl3;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openrndr.color.ColorRGBa;
import org.openrndr.draw.BufferTexture;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ShadeStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.gl3.ShadeStructureGL3;
import org.openrndr.internal.gl3.ShadeStyleManagerGL3;
import org.openrndr.internal.gl3.ShadeStyleManagerGL3Kt;
import org.openrndr.internal.gl3.ShaderPreprocessorGL3;
import org.openrndr.math.Matrix44;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00070\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/openrndr/internal/gl3/ShadeStyleManagerGL3;", "Lorg/openrndr/draw/ShadeStyleManager;", "vertexShaderUrl", "", "fragmentShaderUrl", "(Ljava/lang/String;Ljava/lang/String;)V", "defaultShader", "Lorg/openrndr/draw/Shader;", "getDefaultShader", "()Lorg/openrndr/draw/Shader;", "setDefaultShader", "(Lorg/openrndr/draw/Shader;)V", "shaders", "", "Lorg/openrndr/internal/gl3/ShadeStructureGL3;", "getShaders", "()Ljava/util/Map;", "shader", "style", "Lorg/openrndr/draw/ShadeStyle;", "formats", "", "Lorg/openrndr/draw/VertexFormat;", "openrndr-gl3"})
public final class ShadeStyleManagerGL3
extends ShadeStyleManager {
    @Nullable
    private Shader defaultShader;
    @NotNull
    private final Map<ShadeStructureGL3, Shader> shaders;

    @Nullable
    public final Shader getDefaultShader() {
        return this.defaultShader;
    }

    public final void setDefaultShader(@Nullable Shader shader2) {
        this.defaultShader = shader2;
    }

    @NotNull
    public final Map<ShadeStructureGL3, Shader> getShaders() {
        return this.shaders;
    }

    @Override
    @NotNull
    public Shader shader(@Nullable ShadeStyle style, @NotNull List<VertexFormat> formats) {
        Shader shader2;
        Intrinsics.checkParameterIsNotNull(formats, "formats");
        if (style == null) {
            if (this.defaultShader == null) {
                ShadeStyleManagerGL3Kt.access$getLogger$p().debug(shader.1.INSTANCE);
                ShadeStructureGL3 structure = ShadeStructureGL3.Companion.fromShadeTyle(style, formats);
                this.defaultShader = new ShaderPreprocessorGL3().fromUrls(structure, this.getVertexShaderUrl(), this.getFragmentShaderUrl());
            }
            Shader shader3 = this.defaultShader;
            if (shader3 == null) {
                Intrinsics.throwNpe();
            }
            return shader3;
        }
        Map<ShadeStructureGL3, Shader> $receiver$iv = this.shaders;
        ShadeStructureGL3 structure = ShadeStructureGL3.Companion.fromShadeTyle(style, formats);
        Shader value$iv = $receiver$iv.get(structure);
        if (value$iv == null) {
            Object object;
            try {
                object = new ShaderPreprocessorGL3().fromUrls(structure, this.getVertexShaderUrl(), this.getFragmentShaderUrl());
            }
            catch (RuntimeException e) {
                object = this.shader(null, formats);
            }
            Shader answer$iv = object;
            $receiver$iv.put(structure, answer$iv);
            shader2 = answer$iv;
        } else {
            shader2 = value$iv;
        }
        Shader shader4 = shader2;
        shader4.begin();
        int textureIndex = 2;
        Iterable $receiver$iv2 = style.getParameterValues().entrySet();
        for (Object element$iv : $receiver$iv2) {
            int n;
            Map.Entry it = (Map.Entry)element$iv;
            Object value = it.getValue();
            Object v = value;
            if (v instanceof Integer) {
                shader4.uniform("p_" + (String)it.getKey(), ((Number)value).intValue());
                continue;
            }
            if (v instanceof Float) {
                shader4.uniform("p_" + (String)it.getKey(), ((Number)value).floatValue());
                continue;
            }
            if (v instanceof Double) {
                shader4.uniform("p_" + (String)it.getKey(), ((Number)value).doubleValue());
                continue;
            }
            if (v instanceof Matrix44) {
                shader4.uniform("p_" + (String)it.getKey(), (Matrix44)value);
                continue;
            }
            if (v instanceof Vector4) {
                shader4.uniform("p_" + (String)it.getKey(), (Vector4)value);
                continue;
            }
            if (v instanceof Vector3) {
                shader4.uniform("p_" + (String)it.getKey(), (Vector3)value);
                continue;
            }
            if (v instanceof Vector2) {
                shader4.uniform("p_" + (String)it.getKey(), (Vector2)value);
                continue;
            }
            if (v instanceof ColorRGBa) {
                shader4.uniform("p_" + (String)it.getKey(), (ColorRGBa)value);
                continue;
            }
            if (v instanceof ColorBuffer) {
                ((ColorBuffer)value).bind(textureIndex);
                shader4.uniform("p_" + (String)it.getKey(), textureIndex);
                n = textureIndex;
                textureIndex = n + 1;
                continue;
            }
            if (v instanceof BufferTexture) {
                ((BufferTexture)value).bind(textureIndex);
                shader4.uniform("p_" + (String)it.getKey(), textureIndex);
                n = textureIndex;
                textureIndex = n + 1;
                continue;
            }
            throw (Throwable)new RuntimeException("unsupported value type");
        }
        return shader4;
    }

    public ShadeStyleManagerGL3(@NotNull String vertexShaderUrl, @NotNull String fragmentShaderUrl) {
        Map map;
        Intrinsics.checkParameterIsNotNull(vertexShaderUrl, "vertexShaderUrl");
        Intrinsics.checkParameterIsNotNull(fragmentShaderUrl, "fragmentShaderUrl");
        super(vertexShaderUrl, fragmentShaderUrl);
        ShadeStyleManagerGL3 shadeStyleManagerGL3 = this;
        shadeStyleManagerGL3.shaders = map = (Map)new LinkedHashMap();
    }
}

