/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.ChannelMask;
import org.openrndr.draw.CullTestPass;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.StencilOperation;
import org.openrndr.draw.StencilStyle;
import org.openrndr.draw.StencilTest;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Command;
import org.openrndr.internal.Driver;
import org.openrndr.internal.Expansion;
import org.openrndr.internal.ExpansionType;
import org.openrndr.math.Vector4;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J,\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ$\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J$\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017J\u001e\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u001bJ$\u0010\"\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J$\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J$\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017J\u001e\u0010%\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'J\"\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0017R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0006\"\u0004\b\u000f\u0010\b\u00a8\u0006)"}, d2={"Lorg/openrndr/internal/ExpansionDrawer;", "", "()V", "quad", "Lorg/openrndr/draw/VertexBuffer;", "getQuad", "()Lorg/openrndr/draw/VertexBuffer;", "setQuad", "(Lorg/openrndr/draw/VertexBuffer;)V", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "getShaderManager", "()Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "getVertices", "setVertices", "renderConvexFillCommands", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "commands", "", "Lorg/openrndr/internal/Command;", "renderFill", "expansions", "Lorg/openrndr/internal/Expansion;", "convex", "", "renderFillCommands", "renderFills", "renderStroke", "expansion", "renderStrokeCommands", "renderStrokeCommandsInterleaved", "renderStrokes", "toCommand", "vertexOffset", "", "toCommands", "openrndr-core"})
public final class ExpansionDrawer {
    @NotNull
    private final ShadeStyleManager shaderManager;
    @NotNull
    private VertexBuffer vertices;
    @NotNull
    private VertexBuffer quad;

    @NotNull
    public final ShadeStyleManager getShaderManager() {
        return this.shaderManager;
    }

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    public final void setVertices(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "<set-?>");
        this.vertices = vertexBuffer;
    }

    @NotNull
    public final VertexBuffer getQuad() {
        return this.quad;
    }

    public final void setQuad(@NotNull VertexBuffer vertexBuffer) {
        Intrinsics.checkParameterIsNotNull(vertexBuffer, "<set-?>");
        this.quad = vertexBuffer;
    }

    public final void renderStrokeCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()));
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = drawStyle;
        shader2.uniform("strokeMult", drawStyle.getStrokeWeight() / 2.0 + 0.65);
        shader2.uniform("strokeFillFactor", 0.0);
        Iterable $receiver$iv = commands;
        for (Object element$iv : $receiver$iv) {
            Command command = (Command)element$iv;
            shader2.uniform("bounds", new Vector4(command.getMinX(), command.getMinY(), command.getMaxX() - command.getMinX(), command.getMaxY() - command.getMinY()));
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            shader2.uniform("strokeThr", 0.9980392f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            shader2.uniform("strokeThr", 0.0f);
            localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            localStyle.setChannelWriteMask(new ChannelMask(false, false, false, false));
            localStyle.getStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
            localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
            Driver.Companion.getInstance().setState(localStyle);
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
            localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
            localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
            Driver.Companion.getInstance().setState(localStyle);
        }
        shader2.end();
    }

    public final void renderStrokeCommandsInterleaved(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands) {
        Command command;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(this.vertices.getVertexFormat()));
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = drawStyle;
        Command it = command = CollectionsKt.last(commands);
        int vertexCount2 = it.getVertexOffset() + it.getVertexCount();
        shader2.uniform("strokeMult", drawStyle.getStrokeWeight() / 2.0 + 0.65);
        shader2.uniform("strokeFillFactor", 0.0);
        shader2.uniform("bounds", new Vector4(-1000.0, -1000.0, 2000.0, 2000.0));
        localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
        shader2.uniform("strokeThr", 0.9980392f);
        localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE);
        Driver.Companion.getInstance().setState(localStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
        shader2.uniform("strokeThr", 0.0f);
        localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
        Driver.Companion.getInstance().setState(localStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
        localStyle.setChannelWriteMask(new ChannelMask(false, false, false, false));
        localStyle.getStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
        Driver.Companion.getInstance().setState(localStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(commands.get(0).getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, commands.get(0).getVertexOffset(), vertexCount2);
        localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
        localStyle.setChannelWriteMask(new ChannelMask(true, true, true, true));
        Driver.Companion.getInstance().setState(localStyle);
    }

    public final void renderConvexFillCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands) {
        Command command;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        shader2.uniform("strokeThr", -1.0f);
        shader2.uniform("strokeMult", drawStyle.getStrokeWeight() / 2.0 + 0.65);
        shader2.uniform("strokeFillFactor", 1.0);
        Iterable $receiver$iv = commands;
        for (Object element$iv : $receiver$iv) {
            command = (Command)element$iv;
            if (!Intrinsics.areEqual((Object)command.getType(), (Object)ExpansionType.FILL)) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_FAN, command.getVertexOffset(), command.getVertexCount());
        }
        $receiver$iv = commands;
        for (Object element$iv : $receiver$iv) {
            command = (Command)element$iv;
            if (!Intrinsics.areEqual((Object)command.getType(), (Object)ExpansionType.FRINGE)) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
        }
    }

    public final void renderFillCommands(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Command> commands) {
        BufferWriter bufferWriter;
        Command command;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(commands, "commands");
        if (commands.size() == 0) {
            return;
        }
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), this.vertices.getVertexFormat());
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        DrawStyle localStyle = drawStyle;
        shader2.uniform("strokeThr", -1.0f);
        shader2.uniform("strokeMult", drawStyle.getStrokeWeight() / 2.0 + 0.65);
        shader2.uniform("strokeFillFactor", 1.0);
        Command command2 = commands.get(0);
        shader2.uniform("bounds", new Vector4(command2.getMinX(), command2.getMinY(), command2.getMaxX() - command2.getMinX(), command2.getMaxY() - command2.getMinY()));
        localStyle.setFrontStencil(new StencilStyle());
        localStyle.setBackStencil(new StencilStyle());
        localStyle.getFrontStencil().setStencilWriteMask(255);
        localStyle.getBackStencil().setStencilWriteMask(255);
        localStyle.getFrontStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.INCREASE_WRAP);
        localStyle.getBackStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.DECREASE_WRAP);
        localStyle.getFrontStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.getBackStencil().stencilFunc(StencilTest.ALWAYS, 0, 255);
        localStyle.setChannelWriteMask(ChannelMask.Companion.getNONE());
        localStyle.setCullTestPass(CullTestPass.ALWAYS);
        Driver.Companion.getInstance().setState(localStyle);
        Iterable $receiver$iv = commands;
        for (Object element$iv : $receiver$iv) {
            command = (Command)element$iv;
            if (!Intrinsics.areEqual((Object)command.getType(), (Object)ExpansionType.FILL)) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_FAN, command.getVertexOffset(), command.getVertexCount());
        }
        localStyle.setFrontStencil(localStyle.getStencil());
        localStyle.setBackStencil(localStyle.getStencil());
        localStyle.setChannelWriteMask(ChannelMask.Companion.getALL());
        shader2.uniform("strokeThr", 0.0f);
        localStyle.getStencil().stencilFunc(StencilTest.EQUAL, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.KEEP, StencilOperation.KEEP, StencilOperation.KEEP);
        Driver.Companion.getInstance().setState(localStyle);
        $receiver$iv = commands;
        for (Object element$iv : $receiver$iv) {
            command = (Command)element$iv;
            if (!Intrinsics.areEqual((Object)command.getType(), (Object)ExpansionType.FRINGE)) continue;
            Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(command.getVertexBuffer()), DrawPrimitive.TRIANGLE_STRIP, command.getVertexOffset(), command.getVertexCount());
        }
        shader2.uniform("strokeThr", -1.0f);
        Command fill = commands.get(0);
        localStyle.getStencil().stencilFunc(StencilTest.NOT_EQUAL, 0, 255);
        localStyle.getStencil().stencilOp(StencilOperation.ZERO, StencilOperation.ZERO, StencilOperation.ZERO);
        localStyle.setChannelWriteMask(ChannelMask.Companion.getALL());
        localStyle.setCullTestPass(CullTestPass.ALWAYS);
        int minX = -10000;
        int maxX = 10000;
        int minY = -10000;
        int maxY = 10000;
        BufferWriter $receiver = bufferWriter = this.quad.getShadow().writer();
        $receiver.rewind();
        $receiver.write(minX, minY);
        $receiver.write(0.5f, 1.0f, 0.0f);
        $receiver.write(minX, maxY);
        $receiver.write(0.5f, 1.0f, 0.0f);
        $receiver.write(maxX, maxY);
        $receiver.write(0.5f, 1.0f, 0.0f);
        $receiver.write(maxX, maxY);
        $receiver.write(0.5f, 1.0f, 0.0f);
        $receiver.write(maxX, minY);
        $receiver.write(0.5f, 1.0f, 0.0f);
        $receiver.write(minX, minY);
        $receiver.write(0.5f, 1.0f, 0.0f);
        VertexBufferShadow.DefaultImpls.upload$default(this.quad.getShadow(), 0, 0, 3, null);
        Driver.Companion.getInstance().setState(localStyle);
        Driver.Companion.getInstance().drawVertexBuffer(shader2, CollectionsKt.listOf(this.quad), DrawPrimitive.TRIANGLES, 0, 6);
        localStyle.getStencil().setStencilTest(StencilTest.DISABLED);
        shader2.end();
    }

    @NotNull
    public final Command toCommand(@NotNull VertexBuffer vertices, @NotNull Expansion expansion, int vertexOffset) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(vertices, "vertices");
        Intrinsics.checkParameterIsNotNull(expansion, "expansion");
        Command command = new Command(vertices, expansion.getType(), vertexOffset, expansion.getVertexCount() + 2, expansion.getMinx(), expansion.getMiny(), expansion.getMaxx(), expansion.getMaxy());
        BufferWriter $receiver = bufferWriter = vertices.getShadow().writer();
        $receiver.setPositionElements(vertexOffset);
        BufferWriter w = bufferWriter;
        int vertexSize = (expansion.getBufferPosition() - expansion.getBufferStart()) / expansion.getVertexCount();
        w.write(expansion.getFb(), expansion.getBufferStart(), vertexSize);
        w.write(expansion.getFb(), expansion.getBufferStart(), expansion.getBufferPosition() - expansion.getBufferStart());
        w.write(expansion.getFb(), expansion.getBufferStart() + vertexSize * (expansion.getVertexCount() - 1), vertexSize);
        return command;
    }

    @NotNull
    public final List<Command> toCommands(@NotNull VertexBuffer vertices, @NotNull List<Expansion> expansions) {
        Intrinsics.checkParameterIsNotNull(vertices, "vertices");
        Intrinsics.checkParameterIsNotNull(expansions, "expansions");
        int vertexOffset = 0;
        List commands = new ArrayList();
        Iterable $receiver$iv = expansions;
        for (Object element$iv : $receiver$iv) {
            Expansion it = (Expansion)element$iv;
            commands.add(this.toCommand(vertices, it, vertexOffset));
            vertexOffset += it.getVertexCount() + 2;
        }
        vertices.getShadow().uploadElements(0, vertexOffset);
        return commands;
    }

    public final void renderStroke(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull Expansion expansion) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(expansion, "expansion");
        this.renderStrokeCommands(drawContext, drawStyle, this.toCommands(this.vertices, CollectionsKt.listOf(expansion)));
    }

    public final void renderStrokes(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(expansions, "expansions");
        this.renderStrokeCommandsInterleaved(drawContext, drawStyle, this.toCommands(this.vertices, expansions));
    }

    public final void renderFill(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions, boolean convex) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(expansions, "expansions");
        if (convex) {
            this.renderConvexFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions));
        } else {
            this.renderFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions));
        }
    }

    public final void renderFills(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Expansion> expansions) {
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(expansions, "expansions");
        this.renderFillCommands(drawContext, drawStyle, this.toCommands(this.vertices, expansions));
    }

    public ExpansionDrawer() {
        String string = this.getClass().getResource("shaders/expansion.vert").toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull(string, "this.javaClass.getResour\u2026n.vert\").toExternalForm()");
        String string2 = this.getClass().getResource("shaders/expansion.frag").toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull(string2, "this.javaClass.getResour\u2026n.frag\").toExternalForm()");
        this.shaderManager = ShadeStyleManager.Companion.fromUrls(string, string2);
        this.vertices = VertexBuffer.Companion.createDynamic(new VertexFormat().position(2).textureCoordinate(2).attribute("vertexOffset", 1, VertexElementType.FLOAT32), 0x400000);
        this.quad = VertexBuffer.Companion.createDynamic(new VertexFormat().position(2).textureCoordinate(2).attribute("vertexOffset", 1, VertexElementType.FLOAT32), 6);
    }
}

