/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.internal;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.BufferWriter;
import org.openrndr.draw.DrawContext;
import org.openrndr.draw.DrawPrimitive;
import org.openrndr.draw.DrawStyle;
import org.openrndr.draw.ShadeStyleManager;
import org.openrndr.draw.Shader;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexBufferShadow;
import org.openrndr.draw.VertexElementType;
import org.openrndr.draw.VertexFormat;
import org.openrndr.internal.Driver;
import org.openrndr.math.Vector2;
import org.openrndr.math.Vector3;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014J \u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J,\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0016\u001a\u00020\u0014J2\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lorg/openrndr/internal/CircleDrawer;", "", "()V", "instanceAttributes", "Lorg/openrndr/draw/VertexBuffer;", "getInstanceAttributes", "()Lorg/openrndr/draw/VertexBuffer;", "shaderManager", "Lorg/openrndr/draw/ShadeStyleManager;", "getShaderManager", "()Lorg/openrndr/draw/ShadeStyleManager;", "vertices", "getVertices", "drawCircle", "", "drawContext", "Lorg/openrndr/draw/DrawContext;", "drawStyle", "Lorg/openrndr/draw/DrawStyle;", "x", "", "y", "radius", "drawCircles", "count", "", "positions", "", "Lorg/openrndr/math/Vector2;", "radii", "openrndr-core"})
public final class CircleDrawer {
    @NotNull
    private final VertexBuffer vertices;
    @NotNull
    private final VertexBuffer instanceAttributes;
    @NotNull
    private final ShadeStyleManager shaderManager;

    @NotNull
    public final VertexBuffer getVertices() {
        return this.vertices;
    }

    @NotNull
    public final VertexBuffer getInstanceAttributes() {
        return this.instanceAttributes;
    }

    @NotNull
    public final ShadeStyleManager getShaderManager() {
        return this.shaderManager;
    }

    /*
     * WARNING - void declaration
     */
    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, @NotNull List<Double> radii) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        Intrinsics.checkParameterIsNotNull(radii, "radii");
        BufferWriter $receiver = bufferWriter = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        int n = 0;
        int n2 = positions.size();
        while (n < n2) {
            void i;
            $receiver.write((float)((Number)radii.get((int)i)).doubleValue());
            $receiver.write(new Vector3(positions.get((int)i).getX(), positions.get((int)i).getY(), 0.0));
            ++i;
        }
        this.instanceAttributes.getShadow().uploadElements(0, positions.size());
        this.drawCircles(drawContext, drawStyle, positions.size());
    }

    public final void drawCircles(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, @NotNull List<Vector2> positions, double radius) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        Intrinsics.checkParameterIsNotNull(positions, "positions");
        BufferWriter $receiver = bufferWriter = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        Iterable $receiver$iv = positions;
        for (Object element$iv : $receiver$iv) {
            Vector2 it = (Vector2)element$iv;
            $receiver.write((float)radius);
            $receiver.write(new Vector3(it.getX(), it.getY(), 0.0));
        }
        this.instanceAttributes.getShadow().uploadElements(0, positions.size());
        this.drawCircles(drawContext, drawStyle, positions.size());
    }

    public final void drawCircle(@NotNull DrawContext drawContext, @NotNull DrawStyle drawStyle, double x, double y, double radius) {
        BufferWriter bufferWriter;
        Intrinsics.checkParameterIsNotNull(drawContext, "drawContext");
        Intrinsics.checkParameterIsNotNull(drawStyle, "drawStyle");
        BufferWriter $receiver = bufferWriter = this.instanceAttributes.getShadow().writer();
        $receiver.rewind();
        $receiver.write((float)radius);
        $receiver.write(new Vector3(x, y, 0.0));
        this.instanceAttributes.getShadow().uploadElements(0, 1);
        this.drawCircles(drawContext, drawStyle, 1);
    }

    private final void drawCircles(DrawContext drawContext, DrawStyle drawStyle, int count) {
        Shader shader2 = this.shaderManager.shader(drawStyle.getShadeStyle(), CollectionsKt.listOf(new VertexFormat[]{this.vertices.getVertexFormat(), this.instanceAttributes.getVertexFormat()}));
        shader2.begin();
        drawContext.applyToShader(shader2);
        drawStyle.applyToShader(shader2);
        Driver.Companion.getInstance().setState(drawStyle);
        Driver.Companion.getInstance().drawInstances(shader2, CollectionsKt.listOf(this.vertices), CollectionsKt.listOf(this.instanceAttributes), DrawPrimitive.TRIANGLES, 0, 6, count);
        shader2.end();
    }

    public CircleDrawer() {
        BufferWriter bufferWriter;
        VertexFormat vertexFormat = new VertexFormat();
        VertexBuffer.Companion companion = VertexBuffer.Companion;
        CircleDrawer circleDrawer = this;
        VertexFormat $receiver = vertexFormat;
        $receiver.position(3);
        $receiver.normal(3);
        $receiver.textureCoordinate(2);
        VertexFormat vertexFormat2 = vertexFormat;
        circleDrawer.vertices = companion.createDynamic(vertexFormat2, 6);
        vertexFormat = new VertexFormat();
        companion = VertexBuffer.Companion;
        circleDrawer = this;
        $receiver = vertexFormat;
        $receiver.attribute("radius", 1, VertexElementType.FLOAT32);
        $receiver.attribute("offset", 3, VertexElementType.FLOAT32);
        vertexFormat2 = vertexFormat;
        circleDrawer.instanceAttributes = companion.createDynamic(vertexFormat2, 10000);
        String string = this.getClass().getResource("shaders/circle.vert").toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull(string, "this.javaClass.getResour\u2026e.vert\").toExternalForm()");
        String string2 = this.getClass().getResource("shaders/circle.frag").toExternalForm();
        Intrinsics.checkExpressionValueIsNotNull(string2, "this.javaClass.getResour\u2026e.frag\").toExternalForm()");
        this.shaderManager = ShadeStyleManager.Companion.fromUrls(string, string2);
        BufferWriter w = this.vertices.getShadow().writer();
        w.rewind();
        double x = 0.0;
        double y = 0.0;
        double radius = 1.0;
        Vector3 pa = new Vector3(x - radius, y - radius, 0.0);
        Vector3 pb = new Vector3(x + radius, y - radius, 0.0);
        Vector3 pc = new Vector3(x + radius, y + radius, 0.0);
        Vector3 pd = new Vector3(x - radius, y + radius, 0.0);
        Vector2 ta = new Vector2(0.0, 0.0);
        Vector2 tb = new Vector2(1.0, 0.0);
        Vector2 tc = new Vector2(1.0, 1.0);
        Vector2 td = new Vector2(0.0, 1.0);
        Vector3 n = new Vector3(0.0, 0.0, -1.0);
        BufferWriter $receiver2 = bufferWriter = w;
        $receiver2.write(pa);
        $receiver2.write(n);
        $receiver2.write(ta);
        $receiver2.write(pd);
        $receiver2.write(n);
        $receiver2.write(td);
        $receiver2.write(pc);
        $receiver2.write(n);
        $receiver2.write(tc);
        $receiver2.write(pc);
        $receiver2.write(n);
        $receiver2.write(tc);
        $receiver2.write(pb);
        $receiver2.write(n);
        $receiver2.write(tb);
        $receiver2.write(pa);
        $receiver2.write(n);
        $receiver2.write(ta);
        VertexBufferShadow.DefaultImpls.upload$default(this.vertices.getShadow(), 0, 0, 3, null);
    }
}

