/*
 * Decompiled with CFR 0.152.
 */
package org.openrndr.draw;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.openrndr.draw.ColorBuffer;
import org.openrndr.draw.ColorFormat;
import org.openrndr.draw.ColorType;
import org.openrndr.draw.Drawer;
import org.openrndr.draw.RenderTarget;
import org.openrndr.draw.RenderTargetBuilder;
import org.openrndr.draw.VertexBuffer;
import org.openrndr.draw.VertexFormat;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a/\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016\u001a\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\n\u001a\u001f\u0010\u0019\u001a\u00020\u001a2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016\u001a#\u0010\u001c\u001a\u00020\u0015*\u00020\u001d2\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016\u001a+\u0010\u001f\u001a\u00020\u0015*\u00020\u001d2\u0006\u0010 \u001a\u00020\u00112\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016\u00a8\u0006!"}, d2={"codeFromStream", "", "stream", "Ljava/io/InputStream;", "codeFromURL", "url", "Ljava/net/URL;", "colorBuffer", "Lorg/openrndr/draw/ColorBuffer;", "width", "", "height", "format", "Lorg/openrndr/draw/ColorFormat;", "type", "Lorg/openrndr/draw/ColorType;", "renderTarget", "Lorg/openrndr/draw/RenderTarget;", "builder", "Lkotlin/Function1;", "Lorg/openrndr/draw/RenderTargetBuilder;", "", "Lkotlin/ExtensionFunctionType;", "vertexBuffer", "Lorg/openrndr/draw/VertexBuffer;", "vertexFormat", "Lorg/openrndr/draw/VertexFormat;", "vertexCount", "isolated", "Lorg/openrndr/draw/Drawer;", "function", "isolatedWithTarget", "target", "openrndr-core"})
public final class DrawerKt {
    @NotNull
    public static final VertexFormat vertexFormat(@NotNull Function1<? super VertexFormat, Unit> builder) {
        VertexFormat vertexFormat;
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        VertexFormat $receiver = vertexFormat = new VertexFormat();
        builder.invoke($receiver);
        return vertexFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String codeFromStream(@NotNull InputStream stream) {
        Intrinsics.checkParameterIsNotNull(stream, "stream");
        Closeable closeable = new BufferedReader(new InputStreamReader(stream));
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            String string = TextStreamsKt.readText(it);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String codeFromURL(@NotNull URL url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        Closeable closeable = url.openStream();
        Throwable throwable = null;
        try {
            InputStream it;
            InputStream inputStream = it = (InputStream)closeable;
            Intrinsics.checkExpressionValueIsNotNull(inputStream, "it");
            String string = DrawerKt.codeFromStream(inputStream);
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @NotNull
    public static final String codeFromURL(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull(url, "url");
        return DrawerKt.codeFromURL(new URL(url));
    }

    @NotNull
    public static final VertexBuffer vertexBuffer(@NotNull VertexFormat vertexFormat, int vertexCount2) {
        Intrinsics.checkParameterIsNotNull(vertexFormat, "vertexFormat");
        return VertexBuffer.Companion.createDynamic(vertexFormat, vertexCount2);
    }

    @NotNull
    public static final ColorBuffer colorBuffer(int width, int height, @NotNull ColorFormat format, @NotNull ColorType type) {
        Intrinsics.checkParameterIsNotNull((Object)format, "format");
        Intrinsics.checkParameterIsNotNull((Object)type, "type");
        return ColorBuffer.Companion.create(width, height, format, type);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ColorBuffer colorBuffer$default(int n, int n2, ColorFormat colorFormat, ColorType colorType, int n3, Object object) {
        if ((n3 & 4) != 0) {
            colorFormat = ColorFormat.RGBa;
        }
        if ((n3 & 8) != 0) {
            colorType = ColorType.UINT8;
        }
        return DrawerKt.colorBuffer(n, n2, colorFormat, colorType);
    }

    @NotNull
    public static final RenderTarget renderTarget(int width, int height, @NotNull Function1<? super RenderTargetBuilder, Unit> builder) {
        Intrinsics.checkParameterIsNotNull(builder, "builder");
        RenderTarget renderTarget = RenderTarget.Companion.create(width, height);
        builder.invoke(new RenderTargetBuilder(renderTarget));
        return renderTarget;
    }

    public static final void isolated(@NotNull Drawer $receiver, @NotNull Function1<? super Drawer, Unit> function) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(function, "function");
        $receiver.pushTransforms();
        $receiver.pushStyle();
        function.invoke($receiver);
        $receiver.popStyle();
        $receiver.popTransforms();
    }

    public static final void isolatedWithTarget(@NotNull Drawer $receiver, @NotNull RenderTarget target, @NotNull Function1<? super Drawer, Unit> function) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(target, "target");
        Intrinsics.checkParameterIsNotNull(function, "function");
        target.bind();
        DrawerKt.isolated($receiver, function);
        target.unbind();
    }
}

