/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARBSync {
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;

    protected ARBSync() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glFenceSync, caps.glIsSync, caps.glDeleteSync, caps.glClientWaitSync, caps.glWaitSync, caps.glGetInteger64v, caps.glGetSynciv);
    }

    @NativeType(value="GLsync")
    public static native long glFenceSync(@NativeType(value="GLenum") int var0, @NativeType(value="GLbitfield") int var1);

    public static native boolean nglIsSync(long var0);

    @NativeType(value="GLboolean")
    public static boolean glIsSync(@NativeType(value="GLsync") long sync) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        return ARBSync.nglIsSync(sync);
    }

    public static native void nglDeleteSync(long var0);

    public static void glDeleteSync(@NativeType(value="GLsync") long sync) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        ARBSync.nglDeleteSync(sync);
    }

    public static native int nglClientWaitSync(long var0, int var2, long var3);

    @NativeType(value="GLenum")
    public static int glClientWaitSync(@NativeType(value="GLsync") long sync, @NativeType(value="GLbitfield") int flags, @NativeType(value="GLuint64") long timeout) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        return ARBSync.nglClientWaitSync(sync, flags, timeout);
    }

    public static native void nglWaitSync(long var0, int var2, long var3);

    public static void glWaitSync(@NativeType(value="GLsync") long sync, @NativeType(value="GLbitfield") int flags, @NativeType(value="GLuint64") long timeout) {
        if (Checks.CHECKS) {
            Checks.check(sync);
        }
        ARBSync.nglWaitSync(sync, flags, timeout);
    }

    public static native void nglGetInteger64v(int var0, long var1);

    public static void glGetInteger64v(@NativeType(value="GLenum") int pname, @NativeType(value="GLint64 *") LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBSync.nglGetInteger64v(pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static long glGetInteger64(@NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer params = stack.callocLong(1);
            ARBSync.nglGetInteger64v(pname, MemoryUtil.memAddress(params));
            long l = params.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetSynciv(long var0, int var2, int var3, long var4, long var6);

    public static void glGetSynciv(@NativeType(value="GLsync") long sync, @NativeType(value="GLenum") int pname, @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLint *") IntBuffer values2) {
        if (Checks.CHECKS) {
            Checks.check(sync);
            Checks.checkSafe((Buffer)length, 1);
        }
        ARBSync.nglGetSynciv(sync, pname, values2.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetSynci(@NativeType(value="GLsync") long sync, @NativeType(value="GLenum") int pname, @NativeType(value="GLsizei *") IntBuffer length) {
        if (Checks.CHECKS) {
            Checks.check(sync);
            Checks.checkSafe((Buffer)length, 1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values2 = stack.callocInt(1);
            ARBSync.nglGetSynciv(sync, pname, 1, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values2));
            int n = values2.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetInteger64v(@NativeType(value="GLenum") int pname, @NativeType(value="GLint64 *") long[] params) {
        long __functionAddress = GL.getICD().glGetInteger64v;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, pname, params);
    }

    public static void glGetSynciv(@NativeType(value="GLsync") long sync, @NativeType(value="GLenum") int pname, @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLint *") int[] values2) {
        long __functionAddress = GL.getICD().glGetSynciv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(sync);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPPV(__functionAddress, sync, pname, values2.length, length, values2);
    }

    static {
        GL.initialize();
    }
}

