/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class ARBShaderSubroutine {
    public static final int GL_ACTIVE_SUBROUTINES = 36325;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORMS = 36326;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 36423;
    public static final int GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 36424;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 36425;
    public static final int GL_MAX_SUBROUTINES = 36327;
    public static final int GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 36328;
    public static final int GL_NUM_COMPATIBLE_SUBROUTINES = 36426;
    public static final int GL_COMPATIBLE_SUBROUTINES = 36427;

    protected ARBShaderSubroutine() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLCapabilities caps) {
        return Checks.checkFunctions(caps.glGetSubroutineUniformLocation, caps.glGetSubroutineIndex, caps.glGetActiveSubroutineUniformiv, caps.glGetActiveSubroutineUniformName, caps.glGetActiveSubroutineName, caps.glUniformSubroutinesuiv, caps.glGetUniformSubroutineuiv, caps.glGetProgramStageiv);
    }

    public static native int nglGetSubroutineUniformLocation(int var0, int var1, long var2);

    @NativeType(value="GLint")
    public static int glGetSubroutineUniformLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="const GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderSubroutine.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLint")
    public static int glGetSubroutineUniformLocation(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="const GLchar *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = ARBShaderSubroutine.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native int nglGetSubroutineIndex(int var0, int var1, long var2);

    @NativeType(value="GLuint")
    public static int glGetSubroutineIndex(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="const GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderSubroutine.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="GLuint")
    public static int glGetSubroutineIndex(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="const GLchar *") CharSequence name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer nameEncoded = stack.ASCII(name);
            int n = ARBShaderSubroutine.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(nameEncoded));
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveSubroutineUniformiv(int var0, int var1, int var2, int var3, long var4);

    public static void glGetActiveSubroutineUniformiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer values2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)values2, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetActiveSubroutineUniformi(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values2 = stack.callocInt(1);
            ARBShaderSubroutine.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values2));
            int n = values2.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetActiveSubroutineUniformName(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetActiveSubroutineUniformName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetActiveSubroutineUniformName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei") int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            ARBShaderSubroutine.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetActiveSubroutineUniformName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index) {
        return ARBShaderSubroutine.glGetActiveSubroutineUniformName(program, shadertype, index, ARBShaderSubroutine.glGetActiveSubroutineUniformi(program, shadertype, index, 35385));
    }

    public static native void nglGetActiveSubroutineName(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void glGetActiveSubroutineName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei *") IntBuffer length, @NativeType(value="GLchar *") ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)length, 1);
        }
        ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static String glGetActiveSubroutineName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei") int bufsize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer name = stack.malloc(bufsize);
            ARBShaderSubroutine.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(name));
            String string = MemoryUtil.memASCII(name, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="void")
    public static String glGetActiveSubroutineName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index) {
        return ARBShaderSubroutine.glGetActiveSubroutineName(program, shadertype, index, ARBShaderSubroutine.glGetProgramStagei(program, shadertype, 36424));
    }

    public static native void nglUniformSubroutinesuiv(int var0, int var1, long var2);

    public static void glUniformSubroutinesuiv(@NativeType(value="GLenum") int shadertype, @NativeType(value="const GLuint *") IntBuffer indices) {
        ARBShaderSubroutine.nglUniformSubroutinesuiv(shadertype, indices.remaining(), MemoryUtil.memAddress(indices));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glUniformSubroutinesui(@NativeType(value="GLenum") int shadertype, @NativeType(value="const GLuint *") int index) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer indices = stack.ints(index);
            ARBShaderSubroutine.nglUniformSubroutinesuiv(shadertype, 1, MemoryUtil.memAddress(indices));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetUniformSubroutineuiv(int var0, int var1, long var2);

    public static void glGetUniformSubroutineuiv(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLint") int location, @NativeType(value="GLuint *") IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)params, 1);
        }
        ARBShaderSubroutine.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetUniformSubroutineui(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLint") int location) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            ARBShaderSubroutine.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static native void nglGetProgramStageiv(int var0, int var1, int var2, long var3);

    public static void glGetProgramStageiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") IntBuffer values2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)values2, 1);
        }
        ARBShaderSubroutine.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="void")
    public static int glGetProgramStagei(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer values2 = stack.callocInt(1);
            ARBShaderSubroutine.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values2));
            int n = values2.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glGetActiveSubroutineUniformiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] values2) {
        long __functionAddress = GL.getICD().glGetActiveSubroutineUniformiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(values2, 1);
        }
        JNI.callPV(__functionAddress, program, shadertype, index, pname, values2);
    }

    public static void glGetActiveSubroutineUniformName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer name) {
        long __functionAddress = GL.getICD().glGetActiveSubroutineUniformName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, name.remaining(), length, MemoryUtil.memAddress(name));
    }

    public static void glGetActiveSubroutineName(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLuint") int index, @NativeType(value="GLsizei *") int[] length, @NativeType(value="GLchar *") ByteBuffer name) {
        long __functionAddress = GL.getICD().glGetActiveSubroutineName;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.checkSafe(length, 1);
        }
        JNI.callPPV(__functionAddress, program, shadertype, index, name.remaining(), length, MemoryUtil.memAddress(name));
    }

    public static void glUniformSubroutinesuiv(@NativeType(value="GLenum") int shadertype, @NativeType(value="const GLuint *") int[] indices) {
        long __functionAddress = GL.getICD().glUniformSubroutinesuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(__functionAddress, shadertype, indices.length, indices);
    }

    public static void glGetUniformSubroutineuiv(@NativeType(value="GLenum") int shadertype, @NativeType(value="GLint") int location, @NativeType(value="GLuint *") int[] params) {
        long __functionAddress = GL.getICD().glGetUniformSubroutineuiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(params, 1);
        }
        JNI.callPV(__functionAddress, shadertype, location, params);
    }

    public static void glGetProgramStageiv(@NativeType(value="GLuint") int program, @NativeType(value="GLenum") int shadertype, @NativeType(value="GLenum") int pname, @NativeType(value="GLint *") int[] values2) {
        long __functionAddress = GL.getICD().glGetProgramStageiv;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(values2, 1);
        }
        JNI.callPV(__functionAddress, program, shadertype, pname, values2);
    }

    static {
        GL.initialize();
    }
}

