


//#extension GL_EXT_gpu_shader4: enable
#version 130

varying vec4 position;
uniform sampler2D PositionTexture;
varying vec4 thecolor;
uniform sampler2D OriginalColorTexture;
uniform sampler2D ColorTexture;
uniform float DeltaT;
uniform float ttime;
uniform float ResolutionMultiplier;
uniform mat4 MVP;
uniform float Invocation;
uniform float ScreenSize;

uniform mat4 LightMVP;
const float InverseMaxInt = 1.0 / 4294967295.0;
varying vec4 ShadowPosZ;

float randhash(uint seed, float b)
{
	uint i = (seed ^ 12345391u) * 2654435769u;
	i ^= (i << 6u) ^ (i >> 26u);
	i *= 2654435769u;
	i += (i << 5u) ^ (i >> 12u);
	return float(b * i) * InverseMaxInt;
}

//#define INVOCATION_SIZE (2000)
//#define INVOCATION_SIZEF (2000.0)

void main()
{
	int INVOCATION_SIZE = int(Invocation);
	float INVOCATION_SIZEF = Invocation;
	vec4 glVertex = gl_Vertex;


	int rnd = gl_VertexID;
	int MyIndex = rnd;
	int poss = int(rnd);
	int x = poss%INVOCATION_SIZE;
	int y = poss / INVOCATION_SIZE;

	// get current position from positionTexture
	glVertex.xyz = texture(PositionTexture, 0.9999*vec2(float(x), float(y)) / INVOCATION_SIZEF).xyz;
	vec3 OriginalColors = texture(OriginalColorTexture, 0.9999*vec2(float(x), float(y)) / INVOCATION_SIZEF).xyz;

	float ball = texture(OriginalColorTexture, 0.9999*vec2(float(x), float(y)) / INVOCATION_SIZEF).w;
	float fcw = texture(PositionTexture, 0.9999*vec2(float(x), float(y)) / INVOCATION_SIZEF).w;

	vec3 GPUColors = texture(ColorTexture, 0.9999*vec2(float(x), float(y)) / INVOCATION_SIZEF).xyz;

	glVertex.w = 1.0;

	ShadowPosZ = LightMVP*(glVertex);


	gl_Position = glVertex;
	position = gl_Position.xyzw;


	position.xyz = glVertex.xyz;
	// (position.z<-1.5-ttime*0.2) 
	//position.x+=100000.0;


	if (MyIndex % 99130 == 0) {
		//	position.xyz=vec3 (ivec3 (position.xyz*40.0))/40.0;
		position.y += 1.0;
		position.y *= -1;
		position.y -= 1.0;
	}

	if (ttime>16.0)
		if (ttime<20.0)
	position.y+=0.4*(pow(0.5 + 0.5*sin(1.2*length(glVertex.xz*vec2(1, 1.0))*35.0), 4.0));
	gl_Position = MVP *position;



	thecolor.xyz = GPUColors;;
	//if (MyIndex%50<2)
	//thecolor.xyz+=(vec3 (1.0,0.7,0.4)*GPUColors*1.0-thecolor.xyz)*SizeW;
	//GPUColors*vec3 (0.6,1.0,1.2)*1.2;;
	//thecolor.xyz=GPUColors*vec3 (1.0,1.0,1.0)*1.3;;


	float fog = 10.0 - pow(gl_Position.w, 2.0);
	fog = clamp(fog, 2.0, 10);
	fog = 4.0;
	fog = 2.0;


	if (ScreenSize > 1500.0)
		if (MyIndex % 3 == 0)
			fog = 3.0;

	if (MyIndex % 2400 == 0) {
		//fog*=12.0;
		//thecolor.xyz*=0.0;
		//vec3 (1.0);

	}

	if (ttime>=20.0) { 

if (fcw < 1.0){
			//fog = 20.0;
			//thecolor.xyz *= 0.0;
		}


	}



	if (ttime < 20.0) {

		if (fcw < 1.0){
			fog = 1.0;
			thecolor.xyz *= 0.0;
		}

		else
			if (fcw < 8.0)
				fog = 4.0;

	}




	//if (length (position.xy)<ttime*0.05+0.02) {thecolor.xyz+=vec3 (0.3); thecolor*=1000.0;}
	//if (length (position.xy)<ttime*0.05) thecolor*=0.0;


	if (ttime < 20.0) {


		if (length(gl_Position.xy*vec2(1, 0.7)) < ttime*0.07 + 0.0) { thecolor.xyz += vec3(0.3); thecolor *= 1000.0; }
		if (length(gl_Position.xy*vec2(1, 0.7)) < ttime*0.07 - 0.03) { thecolor.xyz += vec3(0.3); thecolor *= 0.0; }
		//if (length (gl_Position.xy*vec2 (1,0.7))>ttime*0.07+0.1) {thecolor.xyz+=vec3 (0.3); thecolor*=0.0;}

		if (ttime > 8.0)
			if (fcw < 8.0) thecolor.xyz *= 0.0 + 1.0*vec3(pow(0.5 + 0.5*sin(1.2*length(gl_Position.xy*vec2(1, 0.7))*155.0), 4.0));


		if (ttime < 11.0)
			if (ttime > 8.0)
			{
				//fog*=3.0;
				thecolor.xyz *= 10.0;
			}



	}

	if (ttime>=34.0)
	fog=4.0;




	if (MyIndex%100==0)
	if (fcw<1.0)
	{
		//fog=50.0;
		thecolor*=100.0;

	}



	//if (length (gl_Position.xy)<ttime*0.05) thecolor*=0.0;
	if (ttime>42.0)
		if (ttime<97.0)
	 thecolor.xyz *= 1.0 + 3.0*vec3(pow(0.5 + 0.5*sin(1.2*length(glVertex.xz*vec2(1, 1.0))*35.0), 4.0));


	if (ttime>160.0) { 
		float fc=clamp ((ttime-165.0)*0.5,0.0,1.0);
		float fr1=randhash(uint(MyIndex), 1.0)*1.3;
		if (fr1+0.01<fc) 
			thecolor*=0.0;
	}


	//fog=fcw*8.0;
	if (ttime>54.0) 
		if (ttime<84.0)
	if (MyIndex%25==0)
	{
		fog*=1.0;
		thecolor=vec4 (1.0);
	}




	if (ttime>131.0) 
	if (MyIndex%55==0)
	fog*=3.0;



	//thecolor*=0.3;
	gl_PointSize = fog*0.5;

}