#version 110
#define float4 vec4
#define float3 vec3
#define float2 vec2
#define oUV gl_TexCoord[0]
#define tex3D texture3D
#define tex2D texture2D
#define tex1D texture1D
varying float fog;
varying vec4 Color;
varying vec4 ThePos;
uniform mat4 MV_Proj;
uniform float IsPedestal;
uniform float PedestalHeight;
uniform float ttime;
varying vec2 ReflectionUV;

varying vec3 Normal;
varying vec3 NormalCamera;
varying vec4 ShadowPosZ;
uniform float IsShadow;
uniform float PosY;
uniform float Refl;


varying float AOfactor;


uniform sampler2D texture2d_reflection;
uniform sampler2D texture2d_depth;
uniform sampler2D texture2d_depth2;

void main(void)
{

	vec4 Color2 = Color;
	if (IsShadow>0.5) 
	{
	gl_FragData[0]=Color;

	return;
	}


	float dott = dot(Normal.xyz, normalize(vec3(0.0, -0.0, 1.0)));
	dott = clamp(dott, 0.0, 1.0);

	vec4 Final_Color; 
	Final_Color = Color2*fog*dott;


	gl_FragData[0] = Final_Color;

	gl_FragData[0].w = 1.0;



	vec4 TheNormal = (Normal.xyzz + float4(1.0))*0.5;
	
	gl_FragData[1] = TheNormal;

	gl_FragData[0] = TheNormal;
	gl_FragData[0] = Color;

	///////

	float shadow = 1.0;

	float divv = (ShadowPosZ.z) / ShadowPosZ.w;
	float bias=0.010;
	if (ShadowPosZ.w > 0.0)

	{

		for (int tx = -5; tx < 5; tx++) {
		for (int ty = -5; ty < 5; ty++) {


			vec4 projection_pos = ShadowPosZ / (ShadowPosZ.w - 0.00+float(tx)*0.0);;

			projection_pos.xy *= 0.5;
			projection_pos.xy += vec2(0.5+vec2 (tx,ty)*0.001);



			float Shadow = texture2D(texture2d_depth, projection_pos.st).z;
			float diff = (divv - (Shadow));

			if ( Shadow -bias< divv) shadow *= 0.97;
			//if (Shadow<0.961) shadow*=0.95;
			
			//if (Shadow<0.993) shadow*=0.95;


		}
		}

	}


	
	vec2 TUV=(ShadowPosZ / (ShadowPosZ.w)).xy;
	
	float dist=length (ThePos.xz);
	dist=clamp (1.0-dist*0.5,0.0,1.0);


	gl_FragData[0]=vec4 (shadow)*Color;
	//*shadow*dist;
	gl_FragData[1]=TheNormal;
	

	float fdot=0.5+0.5*dot(NormalCamera,vec3 (0.0,0.0,1.0));
	fdot=pow(1.0*fdot,1.0);
	fdot=clamp (fdot,0.0,1.0);


	fdot=0.3;


	gl_FragData[0]=vec4 (fdot)*shadow*TheNormal;
	//*TheNormal;

	if (Refl<0.5){

	if (ThePos.y<-0.5) discard;
	}
	else
	{
	if (ThePos.y>-0.5) discard;

	}
	



	//AOfactor;
	//vec4(fdot)*TheNormal;


	// reflection
gl_FragData[0]=texture2D (texture2d_reflection, ReflectionUV.xy*0.2)*AOfactor*3.0;
gl_FragData[0]=vec4 (1.0)*AOfactor*0.0;


gl_FragData[0]=vec4 (0.0,0.0,0.03,0.0);



//if (Refl>0.5) gl_FragData[0]=vec4 (0.0,0.0,0.0,0.0);


//if (Refl>0.5) discard;
// spotlight
//		gl_FragData[0]=vec4 (1.0)*(1.0-2.0*length (ReflectionUV.xy-vec2 (0.5)));


}














