#version 430
uniform float ttime;
uniform float DeltaT;
uniform float PosY;
uniform float PosX;

//uniform image2D destTexPos;
//uniform image2D destTexCol;
float   hash(float v);
vec2    rhash(vec2 uv);

layout(binding = 0) writeonly uniform image2D destTexPos;
layout(binding = 1) writeonly uniform image2D destTexVel;
layout(binding = 2) writeonly uniform image2D destTexCol;


uniform sampler2D PositionTexture;

uniform sampler2D ColorTexture;
uniform sampler3D CurlTexture;
uniform sampler2D VoronoiTexture;

uniform sampler2D OriginalPositionTexture;
uniform sampler2D SuperOriginalPositionTexture;
uniform sampler2D OriginalUVTexture;
uniform sampler2D OriginalColorTexture;


uniform sampler2D OriginalPositionTexture1;
uniform sampler2D OriginalColorTexture1;
uniform sampler2D OriginalPositionTexture2;
uniform sampler2D OriginalColorTexture2;
uniform sampler2D OriginalPositionTexture3;
uniform sampler2D OriginalColorTexture3;
uniform sampler2D OriginalPositionTexture4;
uniform sampler2D OriginalColorTexture4;
uniform sampler2D OriginalPositionTexture5;
uniform sampler2D OriginalColorTexture5;
uniform sampler2D OriginalPositionTexture6;
uniform sampler2D OriginalColorTexture6;
uniform sampler2D OriginalPositionTexture7;
uniform sampler2D OriginalColorTexture7;
uniform sampler2D OriginalPositionTextureP0;


uniform sampler2D StoneTexture2;


uniform sampler2D OriginalPositionTexture_Text;
uniform sampler2D OriginalColorTexture_Text;

uniform sampler2D Swirl_Texture;


uniform sampler1D Original1DTexture;
layout(local_size_x = 16, local_size_y = 16) in;

layout(std140, binding = 4) buffer Pos{ vec4 Positions[]; };
layout(std140, binding = 5) buffer Vel{ vec4 Velocities[]; };
layout(std140, binding = 6) buffer Col{ vec4 Colors[]; };
uniform float Invocation;

const float InverseMaxInt = 1.0 / 4294967295.0;

vec3 hsv2rgb(vec3 inn)
{
	float      hh, p, q, t, ff;
	int        i;
	vec3         outt;

	if (inn.y <= 0.0) {       // < is bogus, just shuts up warnings
		outt.r = inn.z;
		outt.g = inn.z;
		outt.b = inn.z;
		return outt;
	}
	hh = inn.x;
	hh = mod(hh, 360.0);
	//if(hh >= 360.0) hh = 0.0;
	hh /= 60.0;
	i = int(hh);
	ff = hh - i;
	p = inn.z * (1.0 - inn.y);
	q = inn.z * (1.0 - (inn.y * ff));
	t = inn.z * (1.0 - (inn.y * (1.0 - ff)));

	switch (i) {
	case 0:
		outt.r = inn.z;
		outt.g = t;
		outt.b = p;
		break;
	case 1:
		outt.r = q;
		outt.g = inn.z;
		outt.b = p;
		break;
	case 2:
		outt.r = p;
		outt.g = inn.z;
		outt.b = t;
		break;

	case 3:
		outt.r = p;
		outt.g = q;
		outt.b = inn.z;
		break;
	case 4:
		outt.r = t;
		outt.g = p;
		outt.b = inn.z;
		break;
	case 5:
	default:
		outt.r = inn.z;
		outt.g = p;
		outt.b = q;
		break;
	}
	return outt;
}


float hash(float v)
{
	return fract(fract(v / 1e4)*v - 1e6);
}

vec2 rhash(vec2 uv) {
	const mat2 t = mat2(.12121212, .13131313, -.13131313, .12121212);
	const vec2 s = vec2(1e4, 1e6);
	uv *= t;
	uv *= s;
	return  fract(fract(uv / s)*uv);
}



float voronoi(const in vec2 uv)
{
	vec2 p = floor(uv);
	vec2 f = fract(uv);
	float v = 0.;
	for (int j = -1; j <= 1; j++)
		for (int i = -1; i <= 1; i++)
		{
			vec2 b = vec2(i, j);
			vec2 r = b - f + rhash(p + b);
			v += 1. / pow(dot(r, r), 8.);
		}
	return pow(1. / v, 0.0625);
}




vec3 Rotate(vec3 Input, mat4 RotationM) {
	vec4 Inn = Input.xyzz;
	Inn.w = 1.0;
	Inn = RotationM*Inn;

	float fc = 1.0 - clamp(pow(length(Input)*1.1, 1.0) + 0.0, 0.3, 1.0);
	fc = 0.4 + 0.4*sin(1 * length(Input) + ttime);
	fc *= clamp((ttime - 100)*0.5, 0.0, 1.0);
	fc = 0;
	Inn.xyz += (Input - Inn.xyz)*fc;

	return Inn.xyz;

};


vec2 Rot(vec2 uv, float theta, vec2 pivot) {
	uv -= pivot;
	float x = cos(theta)*uv.x - sin(theta)*uv.y;
	float y = sin(theta)*uv.x + cos(theta)*uv.y;
	x += pivot.x;
	y += pivot.y;
	return vec2(x, y);


};



float randhash(uint seed, float b)
{
	uint i = (seed ^ 12345391u) * 2654435769u;
	i ^= (i << 6u) ^ (i >> 26u);
	i *= 2654435769u;
	i += (i << 5u) ^ (i >> 12u);
	return float(b * i) * InverseMaxInt;
}
vec3 randhash3(uint seed) {
	float x = randhash(seed, 1.0) - 0.5;
	float y = randhash(seed + 413, 1.0) - 0.5;
	float z = randhash(seed * 2 + 12, 1.0) - 0.5;
	return vec3(x, y, z);

};

vec3 GetCurl(vec3 Pos) {

	return texture(CurlTexture, Pos.xyz).xyz;
};



float Octave(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime*0.073, fvy + UV.y + ttime*0.03 + ttime*0.0));
	fy *= voronoi(11 * vec2(UV.x - ttime*0.053, fvy + UV.y - ttime*0.02 + ttime*0.0));
	// fy+=sin(voronoi (6*vec2(UV.x+ttime*0.073,UV.y-ttime*0.02+ttime*0.0)));
	fy += (voronoi(10.4*vec2(UV.x - ttime*0.043, fv + UV.y - ttime*0.023 + ttime*0.0)));

	fy *= 1 * voronoi(4 * vec2(UV.x - ttime*0.043, fvy + UV.y + ttime*0.0 + ttime*0.0));
	fy += 1.4*voronoi(33.4*vec2(fv + UV.x - ttime*0.042, UV.y + fvy - ttime*0.01 + ttime*0.0))		*voronoi(6.4*vec2(fv + UV.x - ttime*0.033, UV.y + fvy - ttime*0.03 + ttime*0.0))
		;

	fy += 0.3*sin(ttime + 15.0*length(vec2(1.0, 0.2)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);

	// fy*=0.5;
	//fy=voronoi (vec2(UV.x,UV.y)*8.0)*0.0;
	return fy;



};



float Octave2(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	UV.y *= 0.6;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime*1.043, fvy + UV.y + ttime*0.03 + ttime*0.0));
	fy *= voronoi(11 * vec2(UV.x + ttime*0.043, fvy + UV.y - ttime*0.02 + ttime*0.0));
	fy += voronoi(6 * vec2(UV.x + ttime*0.143, UV.y - ttime*0.02 + ttime*0.0));
	fy += voronoi(10.4*vec2(UV.x + ttime*0.043, fv + UV.y - ttime*0.02 + ttime*0.0));
	fy += 1.4*voronoi(6.4*vec2(fv + UV.x + ttime*0.053, UV.y + fvy - ttime*0.01 + ttime*0.0))
		*voronoi(6.4*vec2(fv + UV.x + ttime*0.033, UV.y + fvy - ttime*0.03 + ttime*0.0))
		;

	fy *= voronoi(4 * vec2(UV.x - ttime*0.223, fvy + UV.y - ttime*0.01 + ttime*0.0));
	fy += 0.3*sin(ttime + 15.0*length(vec2(1.0, 0.0)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);
	return (fy);



};



float Octave3(vec2 UV) {
	float ff = 0.5;
	float fv = int(UV.x*ff * 20) / (ff*20.0);
	float fvy = int(UV.y*ff * 40) / (ff*40.0);
	fv = 0;
	fvy = 0;
	UV.y *= 0.6;
	float fy = voronoi(13 * vec2(-fv + UV.x + ttime * 0 * 1.043, fvy + UV.y + ttime * 0 * 0.03 + ttime * 0 * 0.0));
	fy *= voronoi(11 * vec2(UV.x + ttime * 0 * 0.043, fvy + UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += voronoi(6 * vec2(UV.x + ttime * 0 * 0.143, UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += voronoi(10.4*vec2(UV.x + ttime * 0 * 0.043, fv + UV.y - ttime * 0 * 0.02 + ttime * 0 * 0.0));
	fy += 1.4*voronoi(6.4*vec2(fv + UV.x + ttime * 0 * 0.053, UV.y + fvy - ttime * 0 * 0.01 + ttime * 0 * 0.0))
		*voronoi(6.4*vec2(fv + UV.x + ttime * 0 * 0.033, UV.y + fvy - ttime * 0 * 0.03 + ttime * 0 * 0.0))
		;

	fy *= voronoi(4 * vec2(UV.x - ttime * 0 * 0.223, fvy + UV.y - ttime * 0 * 0.01 + ttime * 0 * 0.0));
	fy += 0.3*sin(ttime * 0 + 15.0*length(vec2(1.0, 0.0)*(UV - vec2(0.5))));
	//fy=0.5+0.5*sin(fy*2);
	return (fy);



};


vec3 Texture(vec2 UV) {



	return vec3(1.0)*pow((1.0 - length(UV - vec2(0.5))), 2.0);



	UV += vec2(100.0);
	ivec2 iUV = ivec2(UV*256.0);
	if ((iUV.x + iUV.y) % 2 == 0)
		return vec3(1.0);
	else
		return vec3(0.3);




};

/*
vec2 Rot(vec2 uv, float theta, vec2 pivot) {
	uv -= pivot;
	float x = cos(theta)*uv.x - sin(theta)*uv.y;
	float y = sin(theta)*uv.x + cos(theta)*uv.y;
	x += pivot.x;
	y += pivot.y;
	return vec2(x, y);


};
*/

//#define INVOCATION_SIZE (2001)
//#define INVOCATION_SIZEF (2001.0)
void main() {


	int INVOCATION_SIZE = int(Invocation) + 1;
	float INVOCATION_SIZEF = Invocation+1.0;


	float TotalParticles = 1.0 / float(INVOCATION_SIZE*INVOCATION_SIZE);

	uint MyIndex = gl_GlobalInvocationID.x + gl_GlobalInvocationID.y*INVOCATION_SIZE;

	float fMyIndex = float(MyIndex);
	ivec2 storePos = ivec2(gl_GlobalInvocationID.xy);
	float fMyIndexX = float(gl_GlobalInvocationID.x)*1.0 / INVOCATION_SIZEF;
	float fMyIndexY = float(gl_GlobalInvocationID.y)*1.0 / INVOCATION_SIZEF;

	vec2 fMyIndexXY = vec2(fMyIndexX, fMyIndexY);
	float fr1 = randhash(MyIndex, 1.0);
	int MeshID = int(texture(OriginalPositionTexture, fMyIndexXY).w);

 
	vec3 OriginalPos;
	vec3 OriginalCol;

 



	float fup=1.0-clamp ((ttime - (-3.7))*0.25,0.0,1.0);

	OriginalPos.xyz = texture(OriginalPositionTexture, fMyIndexXY).xyz+vec3 (0.0,0.0,0.0);
	

	vec3 Normal = (texture(OriginalColorTexture, fMyIndexXY).xyz-vec3 (0.5))*2.0;
	float fcc = 0.5 + 0.5*dot(Normal, vec3(sin(ttime), 0.0, cos(ttime)));
	float fcw = texture(OriginalColorTexture, fMyIndexXY).w;
//	Colors[MyIndex].xyz = vec3(1.0)*fcc*texture(OriginalColorTexture, fMyIndexXY).w;
//	fcw*=fcc;




	OriginalPos.xyz = texture(OriginalPositionTexture, fMyIndexXY).xyz;
 


	float fcv=PosY*23.0;
	fcv=clamp (fcv,0.5,10000.0);
	
	
	
	
	
	
	
	
	fcv=2000.0;
	//+80*(0.5+0.5*sin(ttime*38.0));
	//+ttime*5.0-fMyIndex*0.0001;

float beat=1.0*pow (clamp (cos(-0.1+130.0/60.0*ttime*3.14159126535-fMyIndex*0.0000003),0.0,1.0),1.0);
beat=pow (beat,40.0);
//fcv*=

beat=clamp (beat,0.0,1.0);



vec3 NewPos1=OriginalPos*1.0;
NewPos1.y*=0.0;
NewPos1.y-=0.5;

NewPos1=randhash3(MyIndex)*vec3 (1,0,1)*112.0;
NewPos1=normalize(NewPos1)*20.0;
//if (texture2D (StoneTexture2, NewPos1.xy*0.1*0.53+vec2 (0.5)).x<0.2)
	//NewPos1.z-=1000.0;
float PosXX=1.78-ttime*0.15;
PosXX=clamp (PosXX,0.0,20.0);
//PosXX*=0.05;
//PosXX=PosX;
//PosXX=clamp (PosXX,-1.0,0.0);



	NewPos1.xyz = texture(OriginalPositionTexture4, fMyIndexXY).xyz;
	fcw = texture(OriginalColorTexture4, fMyIndexXY).w;









	/*
if (ttime>9.0)
if (ttime<15.0) { 
	NewPos1.xyz = texture(OriginalPositionTexture6, fMyIndexXY).xyz;
	fcw = texture(OriginalColorTexture6, fMyIndexXY).w;
}
*/


NewPos1.x*=clamp (ttime*0.05,0.0,1.0);
//NewPos1.x*=clamp (ttime*0.1,0.0,1.0);
OriginalPos=NewPos1;


//OriginalPos*=1.0-fr1*0.1*beat;
//clamp (PosY,0.0,1.0);
//OriginalPos.x+=PosXX;
OriginalPos.xy=Rot (OriginalPos.xy,ttime*0.1*1,vec2 (0.0));

//if (OriginalPos.z<-0.5)  OriginalPos.z-=100.0;

	if (ttime<18.0)
	if (ttime>17.0) {
	//OriginalPos.xyz = texture(OriginalPositionTexture5, fMyIndexXY).xyz*0.45+vec3 (-0.0,0,0); 
	//OriginalPos.xy=Rot (OriginalPos.xy,-ttime*0.1,vec2 (0.0));
	//fcw = texture(OriginalColorTexture5, fMyIndexXY).w*2.0;
//fcv=300000.0;
	}

//OriginalPos.xy=Rot (OriginalPos.xy,ttime*0.31,vec2 (0.0));
	

//vec3 (PosXX*0,0,0);

//1.0-clamp (ttime-10.0,0.0,1.0);


float vor=voronoi(OriginalPos.xy*0.1);
vor=pow(vor*1.2,10.0);
vor=fr1;
//OriginalPos.y*=0.0;
//OriginalPos*=10.0;
//OriginalPos.y+=3.5;
//vec3 NewPos1=normalize(randhash3(MyIndex)*vec3 (1,1,0))*2.0;





//iginalPos.xyz+=(NewPos1-OriginalPos)*clamp(PosX*2.0,0.0,1.0);


//	OriginalPos.xyz+=(vec3 (0,0,0)+randhash3(MyIndex)*vec3 (1,1,1)*3.0-OriginalPos.xyz)*clamp (PosY*200.0-
	//	fMyIndex*0.0001
		//,0.0,1.0);

	//OriginalPos.xyz+=(randhash3(MyIndex)*vec3 (1,1,1)*3.0-OriginalPos.xyz)*beat;


	vec3 SuperOriginalPos= OriginalPos.xyz;

OriginalPos.xyz=vec3 (ivec3 (OriginalPos.xyz*fcv))/fcv;

	//OriginalPos.x*=clamp (ttime*0.2,0.0,1.0);

	//if (ttime>=12.0)


	//stars
	if (MyIndex%500==0)	OriginalPos.xyz=normalize(randhash3(MyIndex))*140.0;

	if (ttime<12.0)
	if (ttime>9.0) { 
	OriginalPos.xyz=texture(OriginalPositionTextureP0, fMyIndexXY).xyz*vec3 (1,1,0)*2.5; 
	SuperOriginalPos= OriginalPos.xyz;
	//fcw=1.0;
	}

	/*
	OriginalPos.z+=5.0;
	OriginalPos.z=mod (OriginalPos.z+ttime*2.0,10.0);
	OriginalPos.z-=5.0;
	*/










	//Velocities[MyIndex].xyz = GetCurl(Positions[MyIndex].xyz*0.126*0.7+vec3 (ttime)*0.005)*1.04;
	//Velocities[MyIndex].xyz += GetCurl(Positions[MyIndex].xyz*0.415*0.7+vec3 (ttime)*-0.005)*1.04;
	
	Velocities[MyIndex].xyz=vec3 (0.0);
	//0.0;
	Velocities[MyIndex].xyz = (OriginalPos.xyz)*1.0;
	Velocities[MyIndex].z*=0.0;
	
	Velocities[MyIndex].xyz += GetCurl(Positions[MyIndex].xyz*0.415*0.7+vec3 (ttime)*-0.005)*1.0;
//	Velocities[MyIndex].xy += vec2 (0.0,2.2);
	//Velocities[MyIndex].xyz = (Normal.xyz)*1.0*(1.0+pow(fr1,10.0)*1.0);
	//Velocities[MyIndex].xy += vec2 (0.0,1.0);
	Velocities[MyIndex].z-= pow (fr1,10.0)*2.0;
	
	Velocities[MyIndex].xyz*=1.015;
	

	float fpull ;

 

	fpull = 1.3*sin (25.1*texture(VoronoiTexture, vec2(0.5) +0.0*OriginalPos.xz+ 0.2*SuperOriginalPos.xz).x+ttime*0.0);
	float fpullv=sin (0.0*ttime+11.1*texture(VoronoiTexture, vec2(0.5) +0.0*OriginalPos.xz+ 0.05*SuperOriginalPos.xy).x+ttime*0.0);
	//fpullv=1.0*sin (voronoi (vec2 (ttime)*0.1+SuperOriginalPos.xz*1.1));
	fpullv=pow (fpullv,1.0)*2.0;
	
	//fpullv=pow (fpullv,10.0);
	vec3 StoneTex=vec3 (0.1)+1.0*texture2D (StoneTexture2, SuperOriginalPos.xy*1.0*0.253+vec2 (0.5,0.5+beat)).xyz;
	
	
//if (ttime<4.0)		StoneTex=vec3 (1.0);
//StoneTex=vec3 (1.0)*0.5*pow (1.4*voronoi (SuperOriginalPos.xy*3.1+vec2 (ttime)),15.0);


	fpull=pow (StoneTex.x*1.5,55.0)*38.0;
	fpull=0.0+pow (1.8*StoneTex.x,25.0)*450.0;


		if (ttime<11.0)
	if (ttime>8.0)
	{
		//ull=0.9;
		fpullv=1.0;
	}
		
	//fpull+=ttime*0.1-OriginalPos.y;
	//fpull=0.0;

			//fpull+=pow ((0.5+0.5*sin(ttime+50.0*voronoi(0.3*SuperOriginalPos.xz))),100.0)*clamp (ttime-0.0,0,1);

	fpull=clamp (fpull,0.0,1.0);
	//fpull=0.3;
	//if (MyIndex%32==0)
	//fpull=0.0;
	//fpull=0.0;
	
//fpull*=fpullv;

	//clamp (PosY*10.0,0.0,1.0);
	//ull+=beat;

		//if (MyIndex%23==0)
		{
		//fpull+=fpullv*100.0*beat;
		}

	
		if (ttime>10.0)
			if (ttime<11.0)
		
			{
			//	fpull+=1.0;

				//;
	//fcw*=1.0;
			}

//fcw*=StoneTex.x;
	fcw*=clamp (fpull*8.0+0.0,1.0+pow (fr1,10.0)*0.0,14.0);
	
	//fpull=0.0;
		
	//fpull*=10.0*pow (cos(0+140.0/60.0*ttime*2*3.14159126535),1.0);
	
//fpull=0.0;
	Positions[MyIndex].w=fpull;
	fpull = clamp(fpull, 0.0, 1.0);

	Positions[MyIndex].xyz += 1.0*Velocities[MyIndex].xyz*DeltaT;
	Positions[MyIndex].xyz+=(OriginalPos-Positions[MyIndex].xyz)*clamp (1.0-fpull,-0.0,1.0);
	
	//if (length (Positions[MyIndex].xyz)<1.0)

	//Positions[MyIndex].xy=Rot (Positions[MyIndex].xy,fpull*0.1*DeltaT,vec2 (0.0));
	 //Positions[MyIndex].xz*=1.0+fpull*DeltaT;
	 //Rot (Positions[MyIndex].xz,fpull*2.1*DeltaT,vec2 (0.0));
	//(OriginalPos-Positions[MyIndex].xyz)*clamp (1.0-fpull,-0.0,1.0);




	fcw=clamp (fcw,0.0,1.0);
	vec3 Light=vec3 (0.0,-0.2*ttime,0.0)+SuperOriginalPos.xyz;
	
	//Light.x+=-10.5*pow (1.1*StoneTex,vec3 (17.0)).x;

	Light=normalize(Light);
	float fdot=0.5+0.5*pow (1.0*dot (Normal,Light),1.0);
	fdot=1.8+0.4*pow(fdot,15.0);

	

	StoneTex=pow (StoneTex,vec3(0.5));
	//fdot=0.8;
	
	//Fcol+=(1.3*vec3 (2.3,1.1,1.0)-Fcol)*clamp (ttime-9.0,0.0,1.0)*clamp (SuperOriginalPos.y*1.0,0.0,1.0);

	float vor1=0.3+voronoi(Positions[MyIndex].xy*0.5+vec2 (-0.3*ttime));
vor1*=1.9*voronoi(Positions[MyIndex].xz*1.0+vec2 (0.2*ttime));
vor1=pow(vor1,3.0);

if (MyIndex%500==0) {
	fcw=1.0;
	Positions[MyIndex].w=10.0;
}

	Colors[MyIndex].xyz = vec3 (1.0)*vor1*fcw*(1.0+0.0*beat);
	
	
	float ft=abs(sin(100.0*Positions[MyIndex].y));
	ft=clamp (ft,0.0,1.0);
	ft=pow(ft*4.2,10.0);
	ft=clamp (ft,0.0,1.0);
	//if (fpull<0.1) Colors[MyIndex].xyz*=ft;

	//if (length (Positions[MyIndex].x)<0.0+ttime*0.05) Colors[MyIndex]=vec4 (0.0);
	//if (length (Positions[MyIndex].xy)<0.0) Colors[MyIndex]=vec4 (0.0);

	//lors[MyIndex].xyz*=Colors[MyIndex].xyz;

	imageStore(destTexPos, storePos, Positions[MyIndex]);
	imageStore(destTexCol, storePos, Colors[MyIndex]);
}
