#version 110
#define float4 vec4
#define float3 vec3
#define float2 vec2
#define oUV gl_TexCoord[0]
#define tex3D texture3D
#define tex2D texture2D
#define tex1D texture1D
varying float fog;
varying vec4 Color;
varying vec4 ThePos;
uniform mat4 MV_Proj;
uniform float IsPedestal;
uniform float PedestalHeight;
uniform float ttime;
varying vec4 FromView;
varying vec4 LightPosZ;

varying vec3 Normal;
varying vec4 ShadowPosZ;
uniform float IsShadow;
uniform float PosY;
uniform float IsTV;
varying vec4 ShadowPosZ2;
uniform float HasReflection;
uniform float HasShadows;

uniform sampler2D texture2d_depth;
uniform sampler2D texture2d_depth2;
uniform sampler2D texture2d_reflection;
uniform sampler2D texture2d_stone;
uniform sampler2D texture2d_video;



float hash(vec3 p)
{
    p  = fract( p*0.3183099+.1 ); p *= 17.0;
    return fract( p.x*p.y*p.z*(p.x+p.y+p.z) );
}

float noise( in vec3 x )
{
    vec3 p = floor(x);
    vec3 f = fract(x);
    f = f*f*(3.0-2.0*f);
	
    return mix(mix(mix( hash(p+vec3(0,0,0)), 
                        hash(p+vec3(1,0,0)),f.x),
                   mix( hash(p+vec3(0,1,0)), 
                        hash(p+vec3(1,1,0)),f.x),f.y),
               mix(mix( hash(p+vec3(0,0,1)), 
                        hash(p+vec3(1,0,1)),f.x),
                   mix( hash(p+vec3(0,1,1)), 
                        hash(p+vec3(1,1,1)),f.x),f.y),f.z);
}

float map5( in vec3 p )
{
	vec3 q = p - vec3(0.0,0.1,1.0);
	float f;
    f  = 0.50000*noise( q ); q = q*2.02;
    f += 0.25000*noise( q ); q = q*2.03;
    f += 0.12500*noise( q ); q = q*2.01;
    f += 0.06250*noise( q ); q = q*2.02;
    f += 0.03125*noise( q );
	return clamp( f, 0.0, 1.0 );
}

float map4( in vec3 p )
{
	vec3 q = p - vec3(0.0,0.1,1.0)* ttime;
	float f;
    f  = 0.50000*noise( q ); q = q*2.02;
    f += 0.25000*noise( q ); q = q*2.03;
    f += 0.12500*noise( q ); q = q*2.01;
    f += 0.06250*noise( q );
	return clamp( 1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0 );
}

float map3( in vec3 p )
{
	vec3 q = p - vec3(0.0,0.1,1.0) * ttime;
	float f;
    f  = 0.50000*noise( q ); q = q*2.02;
    f += 0.25000*noise( q ); q = q*2.03;
    f += 0.12500*noise( q );
	return clamp( 1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0 );
}

float map2( in vec3 p )
{
	vec3 q = p - vec3(0.0,0.1,1.0)*ttime;
	float f;
    f  = 0.50000*noise( q ); q = q*2.02;
    f += 0.25000*noise( q );;
	return clamp( 1.5 - p.y - 2.0 + 1.75*f, 0.0, 1.0 );
}







void main(void)
{

	vec4 Color2 = Color;
	
	Color2.xyz=vec3 (1.0)*map2 (vec3 (ThePos.zy,0.0));
	Color2.xyz=vec3 (1.0);
	

	
	float sttime=ttime;
	if (ttime>=14.0)
	{
		sttime=0.05*ttime;
	if (abs(ThePos.x)<2.0) {
	float fbuf=clamp ((ttime-16.7)*0.5,0.0,1.0);
		sttime=-0.3*pow (sin (fbuf*0.5*3.1415926),4.0)*2.0;
	}


	}


	
	float mult=1.0;
	if (ttime>=14.0)
		mult=0.6;

	float smog=map5 (vec3 (ThePos.zy*mult-vec2 (sttime*1.0*6.0,0.0*ttime) ,ThePos.x));
	float add=0.25-clamp ((ttime-20.0)*0.02,0.0,1.0);
	add=0.27;
	smog*=1.0-clamp (abs (ThePos.z*0.04),0.0,1.0);

	Color2.w=smog*0.07*(1.0-clamp (ThePos.y*add,0.0,1.0));
	
vec3 BackCol=vec3 (0.75,0.8,0.84);
BackCol+=(vec3 (0.6,0.9,1.2)*1.0-BackCol)*clamp ((ttime-21.0)*0.3,0.0,1.0);
BackCol+=(vec3 (0.6,0.9,1.2)*0.0-BackCol)*clamp ((ttime-30.0)*0.3,0.0,1.0);

float ColUp=4.0-ThePos.y;
	ColUp=clamp ((ThePos.y-3.0)*0.2,0.0,1.0);
	ColUp=1.0;

	
	
Color2.xyz=clamp ((ttime-1.0)*0.2,0.0,1.0)*vec3 (smog)*1.0*BackCol*(1.0-0.1*ThePos.y);


vec4 Color3;
Color3.xyz=vec3 (0.6,0.7,1.4)*0.5*clamp ((ttime-1.0)*0.2,0.0,1.0)*vec3 (smog)*1.0*clamp ((ThePos.y-2.5)*0.05,0.0,1.0);;
//*clamp ((ThePos.y-2.0)*0.05,0.0,1.0);;
Color3.w=smog*0.67*clamp ((ThePos.y-2.3)*0.05,0.0,1.0);;;

Color3*=1.0+0.4*sin((-ThePos.z+ThePos.y*0.5+ttime*0.5)*4.0)*sin((-ThePos.z+ThePos.y*0.5-ttime*2.2)*1.0);
Color3*=1.0+clamp ((ThePos.y-5.5)*0.15,0.0,1.0)*10.0*vec4 (0.6,0.8,1.0,0.5);
Color3=clamp (Color3,vec4 (0.0), vec4 (1.0))*(1.0-clamp ((ttime-30.0)*0.3,0.0,1.0));



Color2+=clamp ((ttime-23.0-ThePos.z*0.1)*0.15,0.0,1.0)*Color3;
//lor2.xyz=vec3 (1.0);
//Color2.w*=5.0;
Color2.w*=1.0-0.6*clamp ((ttime-25.0)*0.3,0.0,1.0);
	gl_FragData[0]=Color2;
	gl_FragData[1]=Color2;
	//gl_FragData[0]=vec4 (1.0,0.0,0.0,0.2);

	//scard;

}














