import {
  coordinate,
  line,
  coordinatesEqual,
  linesEqual,
  listContainsCoordinate,
  listContainsLine,
  generateNeighbors,
  shuffle,
  getRandomCell
} from './mazeHelpers.js'


function make_filled_maze(h, w, cellSize, halfCellSize) {

  let visited = [];
  let CellCenters = [];

  let ver = [];
  let hor = [];


  ////console.log("Zellgröße", cellSize)

  for (var y=0; y<h; y+=cellSize) {
      for (var x=0; x<w; x+=cellSize) {
        //////console.log(x, y, x, y+cellSize);
        ver.push(line(x, y, x, y+cellSize));
      }
  }

  /*generate horizontal walls*/
  for (x=0; x<w; x+=cellSize) {
    for (y=0; y<h; y+=cellSize) {
      hor.push(line(x, y, x+cellSize, y));
    }
  }

  /*generate list with coordinates of cell centers*/
  for (x=halfCellSize; x<w; x+=cellSize) {
    for (y=halfCellSize; y<h; y+=cellSize) {
      CellCenters.push(coordinate(x,y));
    }
  }

  console.log(CellCenters)

  let RandomStartCell = getRandomCell(CellCenters)


  console.log(RandomStartCell)

  walk_fields(RandomStartCell.x,  RandomStartCell.y, visited, CellCenters, hor, ver, cellSize, halfCellSize)

  let Data = [hor, ver, h, w, CellCenters];
  return Data;
}

function walk_fields(x, y, visited, CellCenters, hor, ver, cellSize, halfCellSize) {
  //////console.log("Längen",visited.length, hor.length, ver.length)

  ////console.log("x,y",x,y)
  visited.push(coordinate(x, y));
  //////console.log("visited", visited)

  var NeighborCells = generateNeighbors(x,y, cellSize)

  //////console.log(NeighborCells)
  shuffle(NeighborCells);
  //////console.log("mapped", NeighborCells);

  let besetzteNachbarn = 0;

  //NeighborCells.forEach(function(element) {
  // for (i=0; i<4; i++) {
  for (var element in NeighborCells) {
    //////console.log("i",i)
    ////console.log("Besetzte Nachbarn", besetzteNachbarn)

    var actualNeighbor = NeighborCells[element]
    //////console.log("Nachbarn", NeighborCells)
    //////console.log("Nachbar", actualNeighbor)

    //////console.log(listContainsCoordinate(CellCenters, NeighborCells[i]))
    var theTruth = listContainsCoordinate(CellCenters, actualNeighbor)
    //////console.log("theTruth", theTruth)

    if (CellCenters.length == visited.length) {
      ////console.log("Alle wurden besucht")

      break

    } else if (besetzteNachbarn == 4) {
      ////console.log("besetzte Nachbarn sind besetzt")
      ////console.log("visited letzes",visited[-1])

      let letzterX = visited[-1].x;
      ////console.log("letzterX", letzterX)
      let letzterY = visited[-1].y;
      ////console.log("letzterY", letzterY)
      visited[0] = visited[-1];
      visited.pop();

      walk_fields(letzterX, letzterY, visited, CellCenters, hor, ver, cellSize, halfCellSize);


    } else if ( theTruth == false) {

      ////console.log("Nachbar liegt ausserhalb des Felds")

      besetzteNachbarn ++;
      ////console.log("Besetzte Nachbarn", besetzteNachbarn)
      continue

    } else if (listContainsCoordinate(visited, actualNeighbor) !== false) {
      ////console.log("Nachbar wurde schon besucht")

      besetzteNachbarn ++;
      ////console.log("Besetzte Nachbarn 2", besetzteNachbarn)
      continue

    } else if (actualNeighbor.x == x+cellSize) {
      ////console.log("Nachbar ist rechts neben Feld")

      try {
        //change
        var verticalLine = line(x+halfCellSize, y-halfCellSize, x+halfCellSize, y+halfCellSize)
        var index = ver.indexOf(listContainsLine(ver, verticalLine));
        ver.splice(index, 1)
        ////console.log("line removed")
      } catch(ValueError) {
        ////console.log("ValueError can't remove line")
        continue
      }

    } else if (actualNeighbor.x == x-cellSize) {
      ////console.log("Nachbar ist links neben Feld")

      try {
        var verticalLine = line(x-halfCellSize, y-halfCellSize, x-halfCellSize, y+halfCellSize)
        var index = ver.indexOf(listContainsLine(ver, verticalLine));
        ver.splice(index, 1)
        ////console.log("line removed")

      } catch(ValueError) {
        ////console.log("ValueError can't remove line")
        continue
      }

    } else if (actualNeighbor.y == y+cellSize) {
      //console.log("Nachbar ist unterhalb vom Feld")

      try{
        var horizontalLine = line(x-halfCellSize, y+halfCellSize, x+halfCellSize, y+halfCellSize)
        var index = hor.indexOf(listContainsLine(hor, horizontalLine));
        hor.splice(index, 1)
        //console.log("line removed")

      } catch(ValueError) {
        //console.log("ValueError can't remove line")
        continue
      }


    } else if (actualNeighbor.y == y-cellSize) {
      ////console.log("Nachbar ist oberhalb vom Feld")

      try{
        var horizontalLine = line(x-halfCellSize, y-halfCellSize, x+halfCellSize, y-halfCellSize)
        var index = hor.indexOf(listContainsLine(hor, horizontalLine));
        hor.splice(index, 1)
        ////console.log("line removed")

      } catch(ValueError) {
        ////console.log("ValueError can't remove line")
        continue
      }
    }
    ////console.log("next recursion")
    walk_fields(actualNeighbor.x, actualNeighbor.y,  visited, CellCenters, hor, ver, cellSize, halfCellSize)

  }

}

export { make_filled_maze };
