; -----------------------------------------------------------------------------------
; StarLine 256 bytes intro [main code include file] (c) 2018 by Jin X (jin_x@list.ru)
; -----------------------------------------------------------------------------------

; don't touch all these settings !!!
if	pts_on_line = 128 | draw_stars
  sub_pts_count	=	1
else
  sub_pts_count	=	0
end if

if	set_palette = -1
  connect_flash	=	0
end if

if	connect_flash & (inc_distance = 2 | flash_freq < 0x100)
  add_grad_col	=	0
else
  add_grad_col	=	connect_flash
end if

if	set_palette
  max_grad_col	=	63 + add_grad_col
  dist_div_coef	=	1
else
  max_grad_col	=	14 + add_grad_col
  dist_div_coef	=	4
end if

;-----------------------------------------------------------------------------------------------------------------------

; if-then-else
macro	ifel	cond, true, false
{
	if cond
		true
	else
		false
	end if
} ; ifel

; initialize video mode and palette
macro	InitVideo
{
ifel safe_mode,	<mov ax,0x13>, <mov al,0x13>
		int	0x10			; init video mode

if	set_palette = 1
  ifel safe_mode, <xor bl,bl>
		mov	dx,0x3C9
		mov	al,64
	@@:	xchg	ax,bx
		out	dx,al
		out	dx,al
		xchg	ax,bx
		out	dx,al
		dec	ax
		jnz	@B
end if
} ; InitVideo

; initialize star coordinates and deltas
macro	InitCoords
{
	local	.next
if	randomize
		rdtsc
		xchg	bp,ax
end if
ifel safe_mode,	cld
		mov	di,star_coords
ifel safe_mode,	<mov cx,star_count>, <mov cl,star_count>
	.next:
ifel careful_code = 2, <mov bx,320>, <mov bx,200>
	@@:	call	Random
		stosw
ifel careful_code = 2, <sub bx,320-200>, <dec bx>
		jnp	@B
ifel careful_code, <mov bl,max_speed*2+1>, <mov bl,max_speed>
	@@:	call	Random
if	careful_code
  if	max_speed = 1
		dec	ax
  else
		sub	al,max_speed
  end if
		jz	@B
else
		inc	ax
end if
		stosb
		neg	cx
		js	@B
		loop	.next
} ; InitCoords

; draw stars and lines, then move stars
; before call it must be set: ch = 0
macro	DrawAndMove
{
	local	.next1, .next2, .skip, .end2, .move
		mov	cl,star_count
		mov	si,star_coords

	.next1:	; draw lines
		lodsw
		xchg	di,ax			; di = Xa
		lodsw
		xchg	bp,ax			; bp = Ya

		pusha				; we need si and cx
		lodsw
	.next2:
		dec	cx
		jz	.end2
		lodsw
		sub	ax,di

if	sqrt_distance
		push	ax
		imul	ax
		xchg	bx,ax			; bx = (Xb-Xa)^2
		lodsw
		pop	dx			; dx = deltaX
		jc	.skip			; if result > 65535 on 'imul ax'

		sub	ax,bp
		push	ax
		imul	ax,ax			; ax = (Yb-Ya)^2 (we need to save dx)
		add	bx,ax			; bx = (Xb-Xa)^2 + (Yb-Ya)^2
		pop	ax			; ax = deltaY
		jc	.skip			; if overflow on 'add bx,ax'
		js	.skip			; if result is > 0x7FFF

		push	bx
		mov	bx,sp
		fild	word [bx]
		fsqrt
		fistp	word [bx]
		pop	bx			; bx = sqrt(bx) = distance

else ; ~ sqrt_distance
		mov	dx,ax
		jns	@F
		neg	ax
	@@:	xchg	bx,ax			; bx = |Xb-Xa| (deltaX)

		lodsw
		sub	ax,bp
		push	ax
		jns	@F
		neg	ax
	@@:
		cmp	bx,ax			; ax = |Yb-Ya| (deltaY)
		jnb	@F
		xchg	bx,ax			; bx = max(deltaX,deltaY) = distance
	@@:	pop	ax			; ax = deltaY
end if ; sqrt_distance

if	inc_distance = 1
		imul	bx,179/dist_div_coef	; bh = max(deltaX,deltaY)*0.7
		cmp	bh,max_grad_col
else
  if	inc_distance = 2
		shr	bx,1 + bsr dist_div_coef
  else ; inc_distance = 0
    ifel ~ set_palette, <shr bx,2>
  end if
		cmp	bx,max_grad_col
end if
		ja	.skip

if	connect_flash & flash_freq <> 0x100 & set_palette = 1
  if	flash_freq = 0
		test	[music_counter],flash_beat_freq-1
		jnz	@F
    ifel <inc_distance = 1>, <inc bh>, <inc bx>	; add 1 to flash sometimes
	@@:
  else
		push	ax
		in	al,0x40
		cmp	al,flash_freq
    ifel <inc_distance = 1>, <adc bh,ch>, <adc bl,ch> ; add 1 to flash sometimes
		pop	ax
  end if
end if

if	~ set_palette
  if	inc_distance = 1
    ifel connect_flash, <je @F>
		not	bh
	@@:	add	bh,0x20
  else
    ifel connect_flash, <je @F>
		not	bl
	@@:	add	bl,0x20
  end if
end if
ifel <connect_flash & inc_distance = 2 & flash_freq = 0x100>, <inc bx>
		DrawLine			; di,bp = Xa,Ya, dx,ax = deltaX,deltaY, bl (or bh) = color
	.skip:
		lodsw
		jmp	.next2
	.end2:
		popa				; cx and si

		; draw and move stars
		mov	dx,320
if	draw_stars
		imul	bp,dx
		mov	byte [di+bp+screen_buffer],star_color
end if
		mov	bx,-5
	.move:
		lodsb
		cbw
		add	[si+bx],ax
		cmp	[si+bx],dx
		jb	@F
		neg	byte [si-1]
		add	ax,ax
		sub	[si+bx],ax
	@@:	inc	bx
		sub	dx,320-200
		jnp	.move
if 	$-.next1 < 127
		loop	.next1
else
		dec	cx
		jnz	.next1
end if
} ; DrawAndMove

; draw line from di,bp to di+dx,bp+ax pixel coordinates (excluding first and last [if pts_on_line=128 | draw_stars] points)
; with color bl (bh in inc_distance = 1 mode)
; all registers are saved except ch = 0
macro	DrawLine
{
	local	.next
		mov	ch,pts_on_line-sub_pts_count
	.next:	pusha

		; i donno how to optimize this more :(
	@@:	imul	ch
		sar	ax,bsr pts_on_line	; y and then x distance of point
		add	bp,ax
		neg	di
		jns	@F
		imul	bp,320
		xchg	ax,dx
		jmp	@B
	@@:

  ifel <inc_distance = 1>, <mov [di+bp+screen_buffer],bh>, <mov [di+bp+screen_buffer],bl>
		popa
		dec	ch
		jnz	.next
} ; DrawLine

; copy screen buffer to video buffer
; before call it must be set: si = screen_buffer, cx = 0
macro	BufferToScreen
{
		xor	di,di
	@@:	movsb
		loop	@B
} ; BufferToScreen

; clear screen buffer
; before call it must be set: si = screen_buffer, cl = 0, dh = 0
macro	ClearBuffer
{
		mov	ch,320*200/256
if	blink_on_beat
		test	[music_counter],flash_beat_freq-1
		jnz	@F
  ifel later_clear_buf, <mov dh,blink_color>, <mov bh,blink_color>
end if
	@@:
ifel later_clear_buf, <mov [si],dh>, <mov [si],bh> ; bh maybe 0xFF but it's black color too :)
		inc	si
		loop	@B
} ; ClearBuffer

; little delay
; before call it must be set: cx = 0 (if delay_type = 2)
macro	Delay
{
if	delay_type = 1
  ifel dosbox_compat,  <display '>>> HLT delay may hang DOSBox on full speed (cycles=max) !!!',7,13,10>
		hlt
else if delay_type = 2
  ifel dosbox_compat, <mov ax,0x8600>, <mov ah,0x86>
		cwd				; dx = 0xFFFF
		int	0x15
else if delay_type = 3
		mov	dx,0x3DA
	@@:	in	al,dx
		test	al,8
		jz	@B			; vertical retrace
else if delay_type = 4
		mov	di,0x46C
		mov	ax,[fs:di]
	@@:	cmp	ax,[fs:di]
		je	@B
end if
} ; Delay

; play midi music
; before call it must be set: si = music_counter address
macro	PlayMusic
{
if	midi_sound = 1
		PlayMusicPSP
else if	midi_sound >= 2
		PlayMusicMelody
end if
} ; PlayMusic

; play midi music from PSP :)
; before call it must be set: si = music_counter address
macro	PlayMusicPSP
{
	local	.nosound
		inc	byte [si]
		lodsb
		aam	sound_speed
		jnz	.nosound

		and	ah,15
		movzx	si,ah
ifel <delay_type = 3>, <mov dl,0x31>, <mov dx,0x331>
		mov	al,0x3F
		out	dx,al			; enter UART mode

		dec	dx
if	midi_polyphony
		mov	al,0xC0
		out	dx,al			; program change (+ instrument)
		mov	al,ah
  if	midi_polyphony = 1
		inc	ax
  else
		and	al,3
		add	al,35
  end if
		out	dx,al			; instrument
end if
		mov	al,0x90
		out	dx,al			; note on (+ note + volume)
		lodsb
		and	al,15
		jz	.nosound
		add	al,base_note
		out	dx,al			; note
ifel safe_mode, <mov al,0x7F>
		out	dx,al			; volume
	.nosound:
} ; PlayMusicPSP

; play midi music with melody
; before call it must be set: si = music_counter address
macro	PlayMusicMelody
{
	local	.nosound, .1
		inc	byte [si]
		lodsb
		mov	cl,al
		aam	sound_speed
		jnz	.nosound
ifel <delay_type = 3>, <mov dl,0x31>, <mov dx,0x331>
		mov	al,0x3F
		out	dx,al			; enter UART mode

		dec	dx
if	midi_polyphony
		mov	al,0xC0
		out	dx,al			; program change (+ instrument)
  if	midi_polyphony = 1
		shr	ax,11
		inc	ax
  else
		shr	ax,9
		and	al,3
    if	midi_sound = 4
		add	al,37
    else
		add	al,36
    end if
  end if
		out	dx,al			; instrument
end if
		mov	al,0x90
		out	dx,al			; note on (+ note + volume)
if	midi_sound = 2
		mov	eax,0x99A5A5A0		; "Grasshopper" notes
else if	midi_sound = 3
		mov	eax,0x1949DBD0		; "Pop Corn" notes
else if	midi_sound = 4
		mov	ax,0xDCDC		; "Omen" notes (part 1)
		mov	bx,0x003C
else if	midi_sound = 5
		mov	eax,0x677B4559		; "I'm raving" notes (part 1)
end if
if	sound_speed > 4
		shr	cl,bsr sound_speed - 2
else if sound_speed < 4
		shl	cl,2 - bsr sound_speed
end if
if	midi_sound = 2 | midi_sound = 3
		shr	eax,cl
else if	midi_sound = 4 | midi_sound = 5
		test	cl,0x20
		jz	.1
  if	midi_sound = 4
		mov	ax,0x4343		; "Omen" notes (part 2)
		mov	bl,0x18
	.1:	shrd	ax,bx,cl
  else
		mov	eax,0x44014434		; "I'm raving" notes (part 2)
	.1:	shr	eax,cl
		and	al,15
		add	cl,cl
		and	cl,3*8			; (note number and 3) * 8
		add	al,cl			; add 8 semitones
  end if	
end if
if	midi_sound <> 5
		and	al,15
		jz	.nosound
end if
		add	al,base_note
		out	dx,al			; note
ifel safe_mode,	<mov al,0x7F>
		out	dx,al			; volume
	.nosound:
} ; PlayMusicMelody

;-----------------------------------------------------------------------------------------------------------------------

use16
org	0x100

		; ax=bx=0 (if no cmd line params), cx=0xFF, dx=cs=ds=es=ss, si=0x100, di=sp=0x0FFFE (as a rule), bp=0x91X, flags=0x7202 or 0x0202 (all base flags including cf=0; if=1)
		InitVideo
		InitCoords
		push	0xA000
		pop	es
ifel ~ later_clear_buf, <mov si,di>

	.mainloop:
if	~ later_clear_buf
		ClearBuffer
		PlayMusic
		DrawAndMove
		BufferToScreen
		Delay
else
		DrawAndMove
		BufferToScreen
		ClearBuffer
		Delay
		PlayMusic
end if

if	allow_exit
		in	al,0x60
		cbw
		dec	ax
		jnz	.mainloop

  if	ret_text_mode
		mov	al,3
		int	0x10
  end if

  if	print_sign
		mov	ah,9
		mov	dx,sign
		int	0x21
  end if

  if	wait_key
		mov	ax,0xC07
		int	0x21
  end if
  ifel safe_mode, <int 0x20>
else ; ~ allow_exit
		jmp	.mainloop
end if ; allow_exit

;-----------------------------------------------------------------------------------------------------------------------

; generate random number from 0 to bx-1, result in ax
Random:
		imul	bp,45		; 9421 will be larger a byte
		inc	bp
		mov	ax,bp
		mul	bx
		xchg	ax,dx
		ret

if	print_sign
  sign		db	"(c) Jin X / CC'18",10
  ifel allow_exit, <db '$'>
end if

align	4
star_coords	rw	star_count*3	; word X, word Y, byte deltaX, byte deltaY
screen_buffer	rb	320*200
music_counter	rb	1
