extends Area2D

signal mob_reached_end # emitted if reaching the end of the path
export var MAX_HEALTH = 50
export var SPEED = 100

export var STATIC_ROTATION = PI/2 # Pre-calculated angle (rad) to apply to sprite and hitbox rotation

var path
var progress = 0 # In pixles into the path

func _ready():
	$Health.max_value = MAX_HEALTH
	$Health.value = MAX_HEALTH

func _process(delta):
	if get_health() == 0:
		die()

	progress = progress + (SPEED * delta)
	if path:
		path.set_offset( progress )
		if(path.get_unit_offset() >= 1):
			path_completed()
		else:
			position = path.position
			$AnimatedSprite.rotation = path.rotation + STATIC_ROTATION
			$CollisionShape2D.rotation = path.rotation + STATIC_ROTATION


func setPath(p):
	path = p

func path_completed():
	print("Reached the end")
	get_parent().get_parent().mob_reached_end()
	queue_free()


func enter_range():
	pass

func exit_range():
	pass


func get_health():
	return $Health.value

func take_damage( amount ):
	$Health.value = max( $Health.value - amount, 0 )

func die():
	print("Died")
	get_parent().get_parent().mod_died()
	queue_free()
