#version 330 core

layout (location = 0) in vec3 vert;
layout (location = 1) in vec3 vertexNormal;

uniform float t;
uniform mat4 M; // Model to world matrix
uniform mat4 V; // World to camera matrix
uniform mat4 P; // Perspective projection
uniform float angle;
uniform vec3 lightpos;
uniform vec3 rotationAxis;
uniform vec3 color;

out vec3 LightPosition_worldspace;
out vec3 Position_worldspace;
out vec3 EyeDirection_worldspace;
out vec3 LightDirection_worldspace;
out vec3 Normal_worldspace;
out vec3 Color;


mat4 rotationMatrix(vec3 axis, float angle){
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;

    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
0.0,                                0.0,                                0.0,                                1.0);
}

void main() {

    mat4 R = rotationMatrix(rotationAxis, angle + t);
    
    // P*V*M: transformation so that the camera is a the origin, facing upright
    // and looking down the negative z-axis.
    gl_Position = P*V*M*R* vec4(vert.x, vert.y, vert.z, 1); 

    //LightPosition_worldspace = vec3(100*sin(t),100*cos(t),0);
    //LightPosition_worldspace = vec3(0,0,-10*t);
    LightPosition_worldspace = lightpos;
    Position_worldspace = (M*R* vec4(vert,1)).xyz;

    //vec3 camera_worldspace = -vec3(V[0][3], V[1][3], V[2][3]);
    // The last column of the view matrix is the translation part. TODO: give as uniform
    vec3 camera_worldspace = vec3(inverse(V)*vec4(0,0,0,1));
    
    EyeDirection_worldspace =  camera_worldspace - Position_worldspace;
    
    // Vector that goes from the vertex to the light
    LightDirection_worldspace = LightPosition_worldspace - Position_worldspace;

    Normal_worldspace = (R*vec4(vertexNormal,1)).xyz;
    Color = color; // Pass to fragment shader
}


