/*
 * Decompiled with CFR 0.152.
 */
package damkjer.ocd;

import processing.core.PApplet;

public class Camera {
    private static final float TWO_PI = (float)Math.PI * 2;
    private static final float PI = (float)Math.PI;
    private static final float HALF_PI = 1.5707964f;
    private static final float TOL = 1.0E-5f;
    private static final float DEFAULT_FOV = 1.0471976f;
    private PApplet theParent;
    private float theAzimuth;
    private float theElevation;
    private float theRoll;
    private float theCameraX;
    private float theCameraY;
    private float theCameraZ;
    private float theTargetX;
    private float theTargetY;
    private float theTargetZ;
    private float theUpX;
    private float theUpY;
    private float theUpZ;
    private float theFoV;
    private float theAspect;
    private float theNearClip;
    private float theFarClip;
    private float theShotLength;
    private float theDeltaX;
    private float theDeltaY;
    private float theDeltaZ;

    public Camera(PApplet pApplet) {
        this(pApplet, (float)pApplet.height * 0.5f / Camera.tan(0.5235988f));
    }

    public Camera(PApplet pApplet, float f) {
        this(pApplet, 0.0f, 0.0f, f);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3) {
        this(pApplet, f, f2, f3, 0.0f, 0.0f, 0.0f);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5, float f6) {
        this(pApplet, f, f2, f3, f4, f5, f6, 0.0f, 1.0f, 0.0f);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this(pApplet, f, f2, f3, f4, f5, f6, f7, f8, f9, 1.0471976f, 1.0f * (float)pApplet.width / (float)pApplet.height, 0.0f, 0.0f);
        this.theNearClip = this.theShotLength * 0.1f;
        this.theFarClip = this.theShotLength * 10.0f;
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4) {
        this(pApplet, 0.0f, 0.0f, (float)pApplet.height * 0.5f / Camera.tan(f * 0.5f), f, f2, f3, f4);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        this(pApplet, f, f2, f3, 0.0f, 0.0f, 0.0f, f4, f5, f6, f7);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this(pApplet, f, f2, f3, f4, f5, f6, 0.0f, 1.0f, 0.0f, f7, f8, f9, f10);
    }

    public Camera(PApplet pApplet, float f, float f2) {
        this(pApplet, 0.0f, 0.0f, (float)pApplet.height * 0.5f / Camera.tan(0.5235988f), f, f2);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5) {
        this(pApplet, f, f2, f3, 0.0f, 0.0f, 0.0f, f4, f5);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this(pApplet, f, f2, f3, f4, f5, f6, 0.0f, 1.0f, 0.0f, f7, f8);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this(pApplet, f, f2, f3, f4, f5, f6, f7, f8, f9, 1.0471976f, f10, f11);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        this(pApplet, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, 1.0f * (float)pApplet.width / (float)pApplet.height, f11, f12);
    }

    public Camera(PApplet pApplet, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        this.theParent = pApplet;
        this.theCameraX = f;
        this.theCameraY = f2;
        this.theCameraZ = f3;
        this.theTargetX = f4;
        this.theTargetY = f5;
        this.theTargetZ = f6;
        this.theUpX = f7;
        this.theUpY = f8;
        this.theUpZ = f9;
        this.theFoV = f10;
        this.theAspect = f11;
        this.theNearClip = f12;
        this.theFarClip = f13;
        this.theDeltaX = this.theCameraX - this.theTargetX;
        this.theDeltaY = this.theCameraY - this.theTargetY;
        this.theDeltaZ = this.theCameraZ - this.theTargetZ;
        this.theShotLength = Camera.magnitude(this.theDeltaX, this.theDeltaY, this.theDeltaZ);
        this.theAzimuth = Camera.atan2(this.theDeltaX, this.theDeltaZ);
        this.theElevation = Camera.atan2(this.theDeltaY, Camera.sqrt(this.theDeltaZ * this.theDeltaZ + this.theDeltaX * this.theDeltaX));
        if (this.theElevation > 1.5707864f) {
            this.theUpY = 0.0f;
            this.theUpZ = -1.0f;
        }
        if (this.theElevation < -1.5707864f) {
            this.theUpY = 0.0f;
            this.theUpZ = 1.0f;
        }
        this.updateUp();
    }

    public void feed() {
        this.theParent.perspective(this.theFoV, this.theAspect, this.theNearClip, this.theFarClip);
        this.theParent.camera(this.theCameraX, this.theCameraY, this.theCameraZ, this.theTargetX, this.theTargetY, this.theTargetZ, this.theUpX, this.theUpY, this.theUpZ);
    }

    public void aim(float f, float f2, float f3) {
        this.theTargetX = f;
        this.theTargetY = f2;
        this.theTargetZ = f3;
        this.updateDeltas();
    }

    public void jump(float f, float f2, float f3) {
        this.theCameraX = f;
        this.theCameraY = f2;
        this.theCameraZ = f3;
        this.updateDeltas();
    }

    public void zoom(float f) {
        this.theFoV = Camera.constrain(this.theFoV + f, 1.0E-5f, 3.1415827f);
    }

    public void truck(float f) {
        float f2 = this.theDeltaY * this.theUpZ - this.theDeltaZ * this.theUpY;
        float f3 = this.theDeltaX * this.theUpZ - this.theDeltaZ * this.theUpX;
        float f4 = this.theDeltaX * this.theUpY - this.theDeltaY * this.theUpX;
        float f5 = Camera.magnitude(f2, f3, f4);
        this.theCameraX -= f * (f2 /= f5);
        this.theCameraY -= f * (f3 /= f5);
        this.theCameraZ -= f * (f4 /= f5);
        this.theTargetX -= f * f2;
        this.theTargetY -= f * f3;
        this.theTargetZ -= f * f4;
    }

    public void boom(float f) {
        this.theCameraX += f * this.theUpX;
        this.theCameraY += f * this.theUpY;
        this.theCameraZ += f * this.theUpZ;
        this.theTargetX += f * this.theUpX;
        this.theTargetY += f * this.theUpY;
        this.theTargetZ += f * this.theUpZ;
    }

    public void dolly(float f) {
        float f2 = this.theDeltaX / this.theShotLength;
        float f3 = this.theDeltaY / this.theShotLength;
        float f4 = this.theDeltaZ / this.theShotLength;
        this.theCameraX += f * f2;
        this.theCameraY += f * f3;
        this.theCameraZ += f * f4;
        this.theTargetX += f * f2;
        this.theTargetY += f * f3;
        this.theTargetZ += f * f4;
    }

    public void tilt(float f) {
        this.theElevation = Camera.constrain(this.theElevation - f, -1.5707864f, 1.5707864f);
        this.updateTarget();
    }

    public void pan(float f) {
        this.theAzimuth = (this.theAzimuth - f + (float)Math.PI * 2) % ((float)Math.PI * 2);
        this.updateTarget();
    }

    public void roll(float f) {
        this.theRoll = (this.theRoll + f + (float)Math.PI * 2) % ((float)Math.PI * 2);
        this.updateUp();
    }

    public void arc(float f) {
        this.theElevation = Camera.constrain(this.theElevation + f, -1.5707864f, 1.5707864f);
        this.updateCamera();
    }

    public void circle(float f) {
        this.theAzimuth = (this.theAzimuth + f + (float)Math.PI * 2) % ((float)Math.PI * 2);
        this.updateCamera();
    }

    public void look(float f, float f2) {
        this.theElevation = Camera.constrain(this.theElevation - f2, -1.5707864f, 1.5707864f);
        this.theAzimuth = (this.theAzimuth - f + (float)Math.PI * 2) % ((float)Math.PI * 2);
        this.updateTarget();
    }

    public void tumble(float f, float f2) {
        this.theElevation = Camera.constrain(this.theElevation + f2, -1.5707864f, 1.5707864f);
        this.theAzimuth = (this.theAzimuth + f + (float)Math.PI * 2) % ((float)Math.PI * 2);
        this.updateCamera();
    }

    public void track(float f, float f2) {
        this.truck(f);
        this.boom(f2);
    }

    public float[] position() {
        return new float[]{this.theCameraX, this.theCameraY, this.theCameraZ};
    }

    public float[] attitude() {
        return new float[]{this.theAzimuth, this.theElevation, this.theRoll};
    }

    public float[] target() {
        return new float[]{this.theTargetX, this.theTargetY, this.theTargetZ};
    }

    public float[] up() {
        return new float[]{this.theUpX, this.theUpY, this.theUpZ};
    }

    public float fov() {
        return this.theFoV;
    }

    private void updateDeltas() {
        this.theDeltaX = this.theCameraX - this.theTargetX;
        this.theDeltaY = this.theCameraY - this.theTargetY;
        this.theDeltaZ = this.theCameraZ - this.theTargetZ;
        this.theShotLength = Camera.sqrt(this.theDeltaX * this.theDeltaX + this.theDeltaY * this.theDeltaY + this.theDeltaZ * this.theDeltaZ);
        this.theAzimuth = Camera.atan2(this.theDeltaX, this.theDeltaZ);
        this.theElevation = Camera.atan2(this.theDeltaY, Camera.sqrt(this.theDeltaZ * this.theDeltaZ + this.theDeltaX * this.theDeltaX));
        this.updateUp();
    }

    private void updateTarget() {
        this.theTargetX = this.theCameraX - this.theShotLength * Camera.sin(1.5707964f + this.theElevation) * Camera.sin(this.theAzimuth);
        this.theTargetY = this.theCameraY - -this.theShotLength * Camera.cos(1.5707964f + this.theElevation);
        this.theTargetZ = this.theCameraZ - this.theShotLength * Camera.sin(1.5707964f + this.theElevation) * Camera.cos(this.theAzimuth);
        this.updateUp();
    }

    private void updateCamera() {
        this.theCameraX = this.theTargetX + this.theShotLength * Camera.sin(1.5707964f + this.theElevation) * Camera.sin(this.theAzimuth);
        this.theCameraY = this.theTargetY + -this.theShotLength * Camera.cos(1.5707964f + this.theElevation);
        this.theCameraZ = this.theTargetZ + this.theShotLength * Camera.sin(1.5707964f + this.theElevation) * Camera.cos(this.theAzimuth);
        this.updateUp();
    }

    private void updateUp() {
        this.theDeltaX = this.theCameraX - this.theTargetX;
        this.theDeltaY = this.theCameraY - this.theTargetY;
        this.theDeltaZ = this.theCameraZ - this.theTargetZ;
        this.theUpX = -this.theDeltaX * this.theDeltaY;
        this.theUpY = this.theDeltaZ * this.theDeltaZ + this.theDeltaX * this.theDeltaX;
        this.theUpZ = -this.theDeltaZ * this.theDeltaY;
        float f = Camera.magnitude(this.theUpX, this.theUpY, this.theUpZ);
        this.theUpX /= f;
        this.theUpY /= f;
        this.theUpZ /= f;
        if (this.theRoll != 0.0f) {
            float f2 = this.theDeltaY * this.theUpZ - this.theDeltaZ * this.theUpY;
            float f3 = this.theDeltaX * this.theUpZ - this.theDeltaZ * this.theUpX;
            float f4 = this.theDeltaX * this.theUpY - this.theDeltaY * this.theUpX;
            f = Camera.magnitude(f2, f3, f4);
            this.theUpX = this.theUpX * Camera.cos(this.theRoll) + (f2 /= f) * Camera.sin(this.theRoll);
            this.theUpY = this.theUpY * Camera.cos(this.theRoll) + (f3 /= f) * Camera.sin(this.theRoll);
            this.theUpZ = this.theUpZ * Camera.cos(this.theRoll) + (f4 /= f) * Camera.sin(this.theRoll);
        }
    }

    private static final float magnitude(float f, float f2, float f3) {
        float f4 = Camera.sqrt(f * f + f2 * f2 + f3 * f3);
        return f4 < 1.0E-5f ? 1.0f : f4;
    }

    private static final float sin(float f) {
        return PApplet.sin((float)f);
    }

    private static final float cos(float f) {
        return PApplet.cos((float)f);
    }

    private static final float tan(float f) {
        return PApplet.tan((float)f);
    }

    private static final float sqrt(float f) {
        return PApplet.sqrt((float)f);
    }

    private static final float atan2(float f, float f2) {
        return PApplet.atan2((float)f, (float)f2);
    }

    private static final float degrees(float f) {
        return PApplet.degrees((float)f);
    }

    private static final float constrain(float f, float f2, float f3) {
        return PApplet.constrain((float)f, (float)f2, (float)f3);
    }
}

