import moonlander.library.*;

import ddf.minim.*;
import ddf.minim.analysis.*;
import ddf.minim.effects.*;
import ddf.minim.signals.*;
import ddf.minim.spi.*;
import ddf.minim.ugens.*;

Moonlander moonlander;

float PHI = (1+sqrt(5))/2;
int mindim;
int second = second();
int minute = minute();
int hour = hour();
int bg = 225;
boolean drawclock;
boolean drawcubes;
boolean drawspheres;

void setup() {
  fullScreen(P3D);
  moonlander = Moonlander.initWithSoundtrack(this, "music.mp3", 60, 8);
  moonlander.start();
}

void draw() {
  moonlander.update();
  
  mindim = min(width, height);
  drawclock = moonlander.getIntValue("drawclock") > 0;
  drawcubes = moonlander.getIntValue("drawcubes") > 0;
  drawspheres  = moonlander.getIntValue("drawspheres") > 0;
  bg = moonlander.getIntValue("bg");
  
  noCursor();
  background(bg);
  translate(width/2, height/2);
  
  if (drawclock) {
    perspective(f((float) moonlander.getCurrentTime()), (float) width/height, 0.001, 1000);
    drawClock();
  }
  
  else if (drawcubes) {
    perspective();
    drawCubes();
  }
  
  else if (drawspheres) {
    drawSpheres();
  }
  
  else if (moonlander.getCurrentTime() >= 52) {
    fill(255, 255, 0);
    textSize(mindim/40);
    textAlign(CENTER);
    textMode(SHAPE);
    float time = (float) moonlander.getCurrentTime();
    if (52 <= time && time <= 54) {
      text("by", 0, 0, 0);
    }
    time = (float) moonlander.getCurrentTime();
    if (53 <= time && time <= 55) {
      text("into", 0, textAscent() + textDescent(), 0);
    }
    textSize(mindim/160);
    time = (float) moonlander.getCurrentTime();
    if (56 <= time && time <= 58) {
      text("music:", 0, 0, 0);
    }
    time = (float) moonlander.getCurrentTime();
    if (57 <= time && time <= 59) {
      text("\"Noise Attack\" Kevin MacLeod (incompetech.com)\nLicensed under Creative Commons: By Attribution 3.0 License\nhttp://creativecommons.org/licenses/by/3.0/", 0, textAscent() + textDescent(), 0);
    }
    if (moonlander.getCurrentTime() >= 60) exit();
  }
}

float f(float time) {
  return PHI-1-pow(time/6.0-1.23, 3)/2.0;
}

void drawClock() {
  float handwidth = mindim/80;
  
  float hourhandlength = mindim/8;
  float minutehandlength = PHI * hourhandlength;
  float secondhandlength = 1.732051 * hourhandlength;
  
  float secondhandangle = (second + (int) moonlander.getCurrentTime()) * TAU/60;
  float minutehandangle = minute * TAU/60 + secondhandangle/60;
  float hourhandangle = hour * TAU/12 + minutehandangle/12;
    
  noStroke();
  
  fill(255);
  ellipse(0, 0, mindim/2, mindim/2);
  
  drawClockLines();
  
  fill(#ff0000);
  rotate(secondhandangle);
  rect(-handwidth/4, -secondhandlength, handwidth/2, secondhandlength);
  rotate(-secondhandangle);

  fill(0);
  rotate(minutehandangle);
  rect(-handwidth/2, -minutehandlength, handwidth, minutehandlength);
  rotate(-minutehandangle);
  
  rotate(hourhandangle);
  rect(-handwidth/2, -hourhandlength, handwidth, hourhandlength);
  rotate(-hourhandangle);

  ellipse(0, 0, handwidth*2, handwidth*2);
}

void drawClockLines() {
  fill(0);
  for (int i = 0; i < 60; i++) {
    int rectwidth = mindim/160;
    int rectlength = mindim/30;
    if (i%5 != 0) {
      rectwidth /= PHI;
      rectlength /= PHI;
    }
    rect(-rectwidth/2, -mindim/4.1, rectwidth, rectlength);
    rotate(TAU/60);
  }
}

void drawCubes() {
  int cubestroke = moonlander.getIntValue("cubestroke");
  float cameraZangle = (float) moonlander.getValue("cameraZangle");
  
  rotateX(cameraZangle);
  rotateY((float) moonlander.getCurrentTime());
  
  int side = mindim/4;
  int offset = (int) (side * 1.1);
  int coordlist[] = new int[] {0, -offset, 0, 0, offset, 0};
  float cubetodraw = (float) moonlander.getIntValue("cobetodraw");
  int alpha = moonlander.getIntValue("alpha");
  
  if (moonlander.getCurrentTime() > 24) {
    int lightr = moonlander.getIntValue("lightr");
    int lightg = moonlander.getIntValue("lightg");
    int lightb = moonlander.getIntValue("lightb");
    noStroke();
    fill(255, alpha);
    lightFalloff(0.1, 0.002, 0);
    ambientLight(lightr/5, lightg/5, lightb/5);
    pointLight(lightr, lightg, lightb, -mindim/2, -mindim/2, -mindim/2);
  } else {
    stroke(cubestroke);
    noFill();
  }
  
  
  if (moonlander.getCurrentTime() >= 23) box(side);
  
  int i = 0;
  for (int x = 0; x < cubetodraw; x++) {
    translate(coordlist[i % 6], coordlist[(i + 1) % 6], coordlist[(i + 2) % 6]);
    box(side/PHI);
    translate(-coordlist[i % 6], -coordlist[(i + 1) % 6], -coordlist[(i + 2) % 6]);
    i += 3*(x+1) + x%2;
  }
}

void drawSpheres() {
  noStroke();

  float cameraZangle = (float) moonlander.getValue("cameraZangle");
  float fov = (float) moonlander.getValue("alpha");
  int lightr = moonlander.getIntValue("lightr");
  int lightg = moonlander.getIntValue("lightg");
  int lightb = moonlander.getIntValue("lightb");

  rotateX(cameraZangle);
  rotateY((float) moonlander.getCurrentTime());

  if (moonlander.getCurrentTime() >= 51) {
    perspective(fov, (float) width/height, 0.001, 1000); 
  }

  fill(lightr, lightg, lightb);
  lightFalloff(0.05, 0.001, 0);
  ambientLight(50, 50, 50);
  pointLight(255, 255, 255, -1.5*mindim, -1.5*mindim, -1.5*mindim);

  sphere(mindim/4);
}
