/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim;

import ddf.minim.AudioListener;
import ddf.minim.Recordable;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;

public class SignalSplitter
implements Recordable,
AudioListener {
    private Vector<AudioListener> listeners;
    private AudioFormat f;
    private int bs;

    public SignalSplitter(AudioFormat format, int bufferSize) {
        this.f = format;
        this.bs = bufferSize;
        this.listeners = new Vector(5);
    }

    @Override
    public int bufferSize() {
        return this.bs;
    }

    @Override
    public AudioFormat getFormat() {
        return this.f;
    }

    @Override
    public int type() {
        return this.f.getChannels();
    }

    @Override
    public synchronized void addListener(AudioListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeListener(AudioListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public synchronized void samples(float[] samp) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            AudioListener al = this.listeners.get(i);
            float[] copy = new float[samp.length];
            System.arraycopy(samp, 0, copy, 0, copy.length);
            al.samples(copy);
        }
    }

    @Override
    public synchronized void samples(float[] sampL, float[] sampR) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            AudioListener al = this.listeners.get(i);
            float[] copyL = new float[sampL.length];
            float[] copyR = new float[sampR.length];
            System.arraycopy(sampL, 0, copyL, 0, copyL.length);
            System.arraycopy(sampR, 0, copyR, 0, copyR.length);
            al.samples(copyL, copyR);
        }
    }

    @Override
    public float sampleRate() {
        return this.f.getSampleRate();
    }
}

