PShape box1;
PShape box2;
int BOX_SIZE = 10;
int BOXES_NUM = 90;
int BOXES_ROWS = 8;
int BOXES_PER_ROW = BOXES_NUM / BOXES_ROWS;
int DEFAULT_COLOR_R = 0xAA;
int DEFAULT_COLOR_G = 0x39;
int DEFAULT_COLOR_B = 0x39;
int INITIAL_X = ((BOX_SIZE * 2) * BOXES_PER_ROW / 2) * -1 - 1;
int INITIAL_Y = ((BOX_SIZE * 2) * BOXES_ROWS / 2) * -1 - 1;
int CURRENT_X = INITIAL_X;
int CURRENT_Y = INITIAL_Y;
int CURRENT_Z = 0;
int ROW_SWITCH = 0;
boolean SWITCH_THE_ROW = false;

PShape[] boxes = new PShape[BOXES_NUM];


void setup () {
  fullScreen(P3D);
  //size(800, 600, P3D);
  noStroke();

  for (int i=0; i < BOXES_NUM; i++) {
    boxes[i] = createShape(BOX, BOX_SIZE);
    boxes[i].setFill(color(DEFAULT_COLOR_R, DEFAULT_COLOR_G, DEFAULT_COLOR_B));
    DEFAULT_COLOR_R += 10;
    DEFAULT_COLOR_G += 10;
    DEFAULT_COLOR_B += 10;
  }
}

void draw () {
  noFill();
  camera(0.0, 0.0, 160.0, 0.0, 0.0, 0.0, 
         0.0, 1.0, 0.0);

  float t = millis() * 0.001;
  background(0);
  lights();


  for (int i=0; i<BOXES_NUM; i++) {
    pushMatrix();
    translate(CURRENT_X, CURRENT_Y, CURRENT_Z);

    if (((i + 1) % 2 == 0 && int(t) % 4 == 0) || i % 2 == 0 && ((int(t) % 2 == 0) && int(t) % 4 != 0)) {
        rotateY(PI * t);
    }
    shape(boxes[i]);

    popMatrix();

    //print("Current x is " + str(CURRENT_X) + ", Current Y is " + str(CURRENT_Y) + "\n");

    CURRENT_X = INITIAL_X + int(((i % BOXES_PER_ROW) + 1) * (BOX_SIZE * 2));
    CURRENT_Y = INITIAL_Y + int(((i % BOXES_ROWS) + 1) * (BOX_SIZE * 2));
  }
}
