import ddf.minim.*;

final float WIDTH = 720.0;
final float HEIGHT = 400.0;
ArrayList<Bar> bars = new ArrayList<Bar>();
Finalizer finalizer = new Finalizer();

Minim minim;
AudioPlayer player;


void setup() {
    //size(640, 360);
    fullScreen();

    colorMode(HSB, 360, 100, 100);

    for (int i = 0; i < 6; i++) {
        bars.add(new Bar(330 - (i * 40)));
    }

    minim = new Minim(this);
    player = minim.loadFile("home-base-groove.mp3");
    player.play();
}


void draw() {
    background(0);
    scale(height / HEIGHT);

    int timestamp = millis() / 1000;

    if (timestamp < 17) {
        for (Bar bar : bars) {
            bar.update();
            bar.draw();
        }
    } else {
        finalizer.run();
    }
}


class Bar {
    final int SPEED = 5;

    int y;
    boolean toUp = true;
    boolean gray = true;
    int bottomBrightness = 5;

    Bar(int y) {
        this.y = y;
    }

    void update() {
        y = y + (toUp ? -SPEED : SPEED);

        if (y < 30) {
            toUp = false;
        } else if (y > HEIGHT - 70) {
            toUp = true;

            if (!gray) {
                bottomBrightness += 25;

                if (bottomBrightness > 100) {
                    bottomBrightness = 100;
                }
            }

            gray = false;
        }
    }

    void draw() {
        if (gray) {
            verticalGradient(0, y, WIDTH, 30, color(0), color(255));
        } else {
            int hueTop;
            int hueBottom;

            if (toUp) {
                hueTop = int(map(y - 15, 0, HEIGHT, 0, 180));
                hueBottom = int(map(y + 15, 0, HEIGHT, 0, 180));
            } else {
                hueTop = int(map(y - 15, 0, HEIGHT, 180, 360));
                hueBottom = int(map(y + 15, 0, HEIGHT, 180, 360));
            }

            verticalGradient(0, y, WIDTH, 30, color(hueTop, 100, 100), color(hueBottom, 100, bottomBrightness));
        }
    }
}


class Finalizer {
    int frames = 0;
    int diffInSec = -1;

    void run() {
        int timestamp = millis() / 1000;

        if (diffInSec == -1) {
            diffInSec = timestamp;
        }

        int secsGone = timestamp - diffInSec;

        if (frames < 25) {
            background(255 - frames * 4);
        } else if (secsGone < 1) {
            color(0, 100, 100);
            strokeWeight(3.0);

            int left = int(0 + frames * 7);
            int right = int(WIDTH - frames * 7);

            if (left > right) {
                left = int(WIDTH / 2);
                right = int(WIDTH / 2);
            }

            line(left, HEIGHT / 2, right, HEIGHT / 2);
        } else if (secsGone < 5) {
            textSize(10);
            text("Thank you for watching!", 200, HEIGHT - 260);

            text("Music:", 200, HEIGHT - 200);
            text("\"Home Base Groove\" Kevin MacLeod (incompetech.com)", 200, HEIGHT - 180);
            text("Licensed under Creative Commons: By Attribution 3.0 License", 200, HEIGHT - 160);
            text("http://creativecommons.org/licenses/by/3.0/", 200, HEIGHT - 140);
        } else {
            exit();
        }

        frames++;
    }
}


/**
 * Modified version of:
 * https://processing.org/examples/lineargradient.html
 */
void verticalGradient(int x, int y, float w, float h, color c1, color c2) {
    for (int i = y; i <= y + h; i++) {
        float inter = map(i, y, y + h, 0, 1);
        color c = lerpColor(c1, c2, inter);
        stroke(c);
        strokeWeight(1.2);
        line(x, i, x + w, i);
    }
}
