// Generated by Haxe 3.4.0
(function ($hx_exports, $global) { "use strict";
$hx_exports["kvg"] = $hx_exports["kvg"] || {};
$hx_exports["kvg"]["core"] = $hx_exports["kvg"]["core"] || {};
$hx_exports["wl"] = $hx_exports["wl"] || {};
$hx_exports["wl"]["util"] = $hx_exports["wl"]["util"] || {};
var $hxClasses = {},$estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var wl_core_Signal = function() {
	this.callbacks = [];
};
$hxClasses["wl.core.Signal"] = wl_core_Signal;
wl_core_Signal.__name__ = ["wl","core","Signal"];
wl_core_Signal.prototype = {
	connect: function(callback) {
		this.callbacks.push(callback);
	}
	,disconnect: function(callback) {
		HxOverrides.remove(this.callbacks,callback);
	}
	,emit: function(param) {
		var _g = 0;
		var _g1 = this.callbacks;
		while(_g < _g1.length) {
			var cb = _g1[_g];
			++_g;
			cb(param);
		}
	}
	,__class__: wl_core_Signal
};
var DemoMain = $hx_exports["wl"]["DemoMain"] = function() {
	Math.random = ($_=new wl_util_Random(123),$bind($_,$_.NextFloat));
};
$hxClasses["DemoMain"] = DemoMain;
DemoMain.__name__ = ["DemoMain"];
DemoMain.setup = function() {
};
DemoMain.onSoundReady = function() {
	var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
	DemoMain.canvas = window.document.createElement("canvas");
	DemoMain.ctx2d = DemoMain.canvas.getContext("2d",null);
	DemoMain.canvas.width = fft.length;
	DemoMain.canvas.height = 128;
	DemoMain.ctx2d.fillStyle = "#000";
	DemoMain.ctx2d.fillRect(0,0,fft.length,128);
	DemoMain.canvas.style.position = "fixed";
	DemoMain.canvas.style.right = "0px";
	DemoMain.canvas.style.left = "0px";
};
DemoMain.update = function(ts,partial,frameTime,delta) {
};
DemoMain.prototype = {
	__class__: DemoMain
};
var HxOverrides = function() { };
$hxClasses["HxOverrides"] = HxOverrides;
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Main = function() { };
$hxClasses["Main"] = Main;
Main.__name__ = ["Main"];
Main.main = function() {
	$(window).ready(Main.windowReady);
};
Main.windowReady = function(e) {
	wl_util_LoadManager.onComplete = Main.onAssetsLoaded;
	Main.jsonConfigurator = new wl_setup_JsonConfigurator();
	Main.jsonConfigurator.fromJson(haxe_Resource.getString("Demo.json"));
	$("#setup").css("display","none");
	Main.demo = new wl_core_Demo();
	if(!wl_core_Config.DEBUG) {
		$(".debug").css("display","none");
		$("#debug").find("input").attr("checked",null);
		$(".checkbox").css("display","none");
	}
	if(wl_util_LoadManager.get_totalCount() == 0) {
		Main.assetsLoaded = true;
	}
	wl_sounds_SoundWL.onSoundLoaded.connect(Main.onSoundLoaded);
	wl_sounds_SoundWL.init();
};
Main.onAssetsLoaded = function() {
	Main.assetsLoaded = true;
	Main.loadReady();
};
Main.onSoundLoaded = function() {
	Main.soundLoaded = true;
	DemoMain.onSoundReady();
	Main.loadReady();
};
Main.loadReady = function() {
	if(Main.assetsLoaded && Main.soundLoaded) {
		$("#setup").css("display","");
		wl_setup_Setup.init(Main.demo);
	}
};
Math.__name__ = ["Math"];
var Reflect = function() { };
$hxClasses["Reflect"] = Reflect;
Reflect.__name__ = ["Reflect"];
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
var Std = function() { };
$hxClasses["Std"] = Std;
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
var StringTools = function() { };
$hxClasses["StringTools"] = StringTools;
StringTools.__name__ = ["StringTools"];
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
var Type = function() { };
$hxClasses["Type"] = Type;
Type.__name__ = ["Type"];
Type.getClassName = function(c) {
	var a = c.__name__;
	if(a == null) {
		return null;
	}
	return a.join(".");
};
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) {
		return null;
	}
	return cl;
};
Type.createInstance = function(cl,args) {
	var _g = args.length;
	switch(_g) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	case 9:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8]);
	case 10:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9]);
	case 11:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10]);
	case 12:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11]);
	case 13:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12]);
	case 14:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12],args[13]);
	default:
		throw new js__$Boot_HaxeError("Too many arguments");
	}
};
var wl_core_Part = function() {
	this.customPosts = [];
	this.autoClear = true;
	this.multiPart = false;
	this.clearColor = wl_core_Config.CLEAR_COLOR;
	this.generateDepthMap = true;
	this.renderToScreen = false;
	this.inTransition = false;
	this.running = false;
	this.isActive = false;
};
$hxClasses["wl.core.Part"] = wl_core_Part;
wl_core_Part.__name__ = ["wl","core","Part"];
wl_core_Part.prototype = {
	get_engine: function() {
		return wl_core_Graphics.instance.renderer;
	}
	,init: function() {
		this.triggers = new haxe_ds_ObjectMap();
		this.scene = new BABYLON.Scene(wl_core_Graphics.instance.renderer);
		this.renderTo = new BABYLON.RenderTargetTexture("part rt",{ width : wl_core_Config.RESOLUTION[0], height : wl_core_Config.RESOLUTION[1]},this.scene,false);
		this.scene.customRenderTargets.push(this.renderTo);
		this.scene.renderTargetsEnabled = true;
	}
	,initPipeline: function(post) {
		post.bloom = post.bloom == null ? false : post.bloom;
		post.chromaticAberration = post.chromaticAberration == null ? false : post.chromaticAberration;
		post.dof = post.dof == null ? false : post.dof;
		post.fxaa = post.fxaa == null ? false : post.fxaa;
		post.grain = post.grain == null ? false : post.grain;
		post.imageProcessing = post.imageProcessing == null ? false : post.imageProcessing;
		post.sharpen = post.sharpen == null ? false : post.sharpen;
		this.pipeline = new BABYLON.DefaultRenderingPipeline(this.name + ":pipeline",true,this.scene,[this.camera]);
		this.pipeline.bloomEnabled = post.bloom;
		this.pipeline.chromaticAberrationEnabled = post.chromaticAberration;
		this.pipeline.depthOfFieldEnabled = post.dof;
		this.pipeline.fxaaEnabled = post.fxaa;
		this.pipeline.grainEnabled = post.grain;
		this.pipeline.imageProcessingEnabled = true;
		this.pipeline.sharpenEnabled = post.sharpen;
		this.post = { };
		this.post.bloom = this.pipeline;
		this.post.chromaticAberration = this.pipeline.chromaticAberration;
		this.post.dof = this.pipeline.depthOfField;
		this.post.fxaa = this.pipeline.fxaa;
		this.post.grain = this.pipeline.grain;
		this.post.imageProcessing = this.pipeline.imageProcessing;
		this.post.sharpen = this.pipeline.sharpen;
		if(post.distort) {
			var tmp = this.camera;
			var tmp1 = this.scene.getEngine();
			this.post.distort = new wl_post_distort_DistortPostProcess(tmp,tmp1);
			this.pipeline.addEffect(new BABYLON.PostProcessRenderEffect(this.scene.getEngine(),"distortPostProcessEffect",[this.post.distort]));
			this.customPosts.push(this.post.distort);
		}
	}
	,postInit: function() {
	}
	,setupDatGui: function(folder) {
		if(this.camera != null) {
			var cam = folder.addFolder("camera");
			cam.add(this.camera,"fov");
		}
		var _g = 0;
		var _g1 = this.customPosts;
		while(_g < _g1.length) {
			var pp = _g1[_g];
			++_g;
			if(pp.setupDatGui != null) {
				pp.setupDatGui(folder.addFolder(Type.getClassName(pp == null ? null : js_Boot.getClass(pp))));
			}
		}
		if(this.pipeline != null) {
			wl_debug_PostProcessSliders.applySliders(folder,this.pipeline);
		}
	}
	,start: function(ts) {
		this.running = true;
	}
	,stop: function() {
		this.running = false;
	}
	,setRenderToScreen: function(value) {
		this.renderToScreen = value;
	}
	,update: function(ts,partial,frameTime,delta) {
	}
	,render: function(ts,frameTime,toScreen) {
		if(toScreen) {
			this.scene.render();
		} else if(this.renderTo != null) {
			this.renderTo.render(false);
		}
	}
	,addTrigger: function(timesig,handler) {
		if(this.triggers.h.__keys__[timesig.__id__] != null) {
			this.triggers.h[timesig.__id__].push(handler);
		} else {
			this.triggers.set(timesig,[handler]);
		}
	}
	,removeTrigger: function(handler,timesig) {
		if(timesig != null && this.triggers.h.__keys__[timesig.__id__] != null) {
			HxOverrides.remove(this.triggers.h[timesig.__id__],handler);
		} else {
			var t = this.triggers.iterator();
			while(t.hasNext()) {
				var t1 = t.next();
				while(t1.indexOf(handler) >= 0) HxOverrides.remove(t1,handler);
			}
		}
	}
	,initStandardScene: function() {
		this.scene.clearColor = this.clearColor;
		this.scene.autoClear = true;
		this.camera = new BABYLON.UniversalCamera("mainCamera",new BABYLON.Vector3(0,5,-10),this.scene);
		this.camera.setTarget(BABYLON.Vector3.Zero());
		if(this.generateDepthMap) {
			this.depthRenderer = this.scene.enableDepthRenderer();
			this.depthMap = this.depthRenderer.getDepthMap();
		}
		wl_debug_ManualControl.attachPart(this);
	}
	,__class__: wl_core_Part
};
var blank_Blank = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.Blank"] = blank_Blank;
blank_Blank.__name__ = ["blank","Blank"];
blank_Blank.__super__ = wl_core_Part;
blank_Blank.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 16, diameter : 2},this.scene);
		BABYLON.MeshBuilder.CreateGround("ground1",{ height : 6, width : 6, subdivisions : 2},this.scene);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		sphere.position.y = 1;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: blank_Blank
});
var blank_Blank2 = function() {
	wl_core_Part.call(this);
};
$hxClasses["blank.Blank2"] = blank_Blank2;
blank_Blank2.__name__ = ["blank","Blank2"];
blank_Blank2.__super__ = wl_core_Part;
blank_Blank2.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var box = BABYLON.MeshBuilder.CreateBox("box1",{ width : 2, height : 2, depth : 2},this.scene);
		BABYLON.MeshBuilder.CreateGround("ground1",{ height : 6, width : 6, subdivisions : 2},this.scene);
		new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		box.position.y = 1;
		this.scene.clearColor = new BABYLON.Color4(0,1,0);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,__class__: blank_Blank2
});
var haxe_IMap = function() { };
$hxClasses["haxe.IMap"] = haxe_IMap;
haxe_IMap.__name__ = ["haxe","IMap"];
var haxe_Resource = function() { };
$hxClasses["haxe.Resource"] = haxe_Resource;
haxe_Resource.__name__ = ["haxe","Resource"];
haxe_Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe_Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) {
				return x.str;
			}
			return haxe_crypto_Base64.decode(x.data).toString();
		}
	}
	return null;
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
$hxClasses["haxe.Timer"] = haxe_Timer;
haxe_Timer.__name__ = ["haxe","Timer"];
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
$hxClasses["haxe.io.Bytes"] = haxe_io_Bytes;
haxe_io_Bytes.__name__ = ["haxe","io","Bytes"];
haxe_io_Bytes.ofString = function(s) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.prototype = {
	getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				s += fcc((c & 31) << 12 | (b[i++] & 127) << 6 | b[i++] & 127);
			} else {
				var u = (c & 15) << 18 | (b[i++] & 127) << 12 | (b[i++] & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
$hxClasses["haxe.crypto.Base64"] = haxe_crypto_Base64;
haxe_crypto_Base64.__name__ = ["haxe","crypto","Base64"];
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
$hxClasses["haxe.crypto.BaseCode"] = haxe_crypto_BaseCode;
haxe_crypto_BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) tbl[_g++] = -1;
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i = _g1++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_Either = { __ename__ : true, __constructs__ : ["Left","Right"] };
haxe_ds_Either.Left = function(v) { var $x = ["Left",0,v]; $x.__enum__ = haxe_ds_Either; $x.toString = $estr; return $x; };
haxe_ds_Either.Right = function(v) { var $x = ["Right",1,v]; $x.__enum__ = haxe_ds_Either; $x.toString = $estr; return $x; };
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
$hxClasses["haxe.ds.ObjectMap"] = haxe_ds_ObjectMap;
haxe_ds_ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe_ds_ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
$hxClasses["haxe.ds.StringMap"] = haxe_ds_StringMap;
haxe_ds_StringMap.__name__ = ["haxe","ds","StringMap"];
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_Error = { __ename__ : true, __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
$hxClasses["haxe.io.FPHelper"] = haxe_io_FPHelper;
haxe_io_FPHelper.__name__ = ["haxe","io","FPHelper"];
haxe_io_FPHelper.i32ToFloat = function(i) {
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return (1 - (i >>> 31 << 1)) * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0 ? -f : f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	var sig = Math.round((af / Math.pow(2,exp) - 1) * 8388608);
	if(sig == 8388608 && exp < 128) {
		sig = 0;
		++exp;
	}
	return (f < 0 ? -2147483648 : 0) | exp + 127 << 23 | sig;
};
var intro_Intro = function() {
	this.chroma = 0;
	this.distortMp = 0;
	this.camMove = 0;
	wl_core_Part.call(this);
};
$hxClasses["intro.Intro"] = intro_Intro;
intro_Intro.__name__ = ["intro","Intro"];
intro_Intro.__super__ = wl_core_Part;
intro_Intro.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.scene.clearColor = new BABYLON.Color4(0,0,0,1);
		this.sphere = BABYLON.MeshBuilder.CreateSphere("sphere1",{ segments : 32, diameter : 10},this.scene);
		var smat = new BABYLON.StandardMaterial("spheremat",this.scene);
		smat.diffuseColor = DemoMain.BLUE_DARK;
		this.sphere.material = smat;
		this.light = new BABYLON.HemisphericLight("light1",new BABYLON.Vector3(0,1,0),this.scene);
		this.light.intensity = 0;
		this.light.diffuse = DemoMain.WHITE;
		this.ringTargetscale = 1.1;
		this.ringsInPlace = 0;
		this.originRing = wl_util_ExtendedMeshBuilder.BuildRingDisc(10,9,0.1,this.scene);
		this.originRing.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		var extraRing = wl_util_ExtendedMeshBuilder.BuildRingDisc(10,9.8,0.1,this.scene);
		extraRing.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		this.rings = [];
		var _g = 0;
		while(_g < 5) {
			var i = _g++;
			var ring = new intro_Ring(extraRing.createInstance("aaa" + i));
			ring.maxRotSpeed = (18 - i) / 1000;
			this.rings.push(ring);
		}
		this.scene.ambientColor = new BABYLON.Color3(1,1,1);
		this.camera.fov = 0.34;
		this.columns = [];
		var looks = [new BABYLON.Vector3(15,20,50),new BABYLON.Vector3(2,-1,-30),new BABYLON.Vector3(-100,-900,50)];
		var _g1 = 0;
		while(_g1 < 2) {
			var c = new intro_IntroColumn("C");
			this.scene.addTransformNode(c);
			c.lookAt(looks[_g1++]);
			c.scaling.z = 0;
			c.scaling.x = c.scaling.y = 0.8;
			this.columns.push(c);
		}
		this.c0 = this.columns[0];
		var glowmat = new BABYLON.StandardMaterial("glowmat",this.scene);
		glowmat.emissiveColor = DemoMain.HILIGHT;
		this.originRing.material = glowmat;
		this.ship = new posttest_Ship("ship",this.scene,false);
		var v = new BABYLON.Vector3(-15,-20,-50);
		v = v.normalize().scale(100);
		this.ship.position.y = -49;
		this.ship.position.z = -122;
		this.ship.position.x = 3;
		this.ship.scaling.x = this.ship.scaling.y = this.ship.scaling.z = 10;
		this.ship.rotation.z = 1;
		this.ship.rotation.y = 1.57;
		extraRing.material = glowmat;
		this.camera.position.y = 0;
		this.camera.position.z = -40;
		this.camera.setTarget(BABYLON.Vector3.Zero());
		new BABYLON.GlowLayer("gl",this.scene).intensity = 1;
		var emitter = BABYLON.MeshBuilder.CreateSphere("emitter",{ diameter : 1},this.scene);
		emitter.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		this.particleSystem = new BABYLON.GPUParticleSystem("particles",{ capacity : 250000},this.scene);
		this.particleSystem.emitRate = 50;
		this.particleSystem.particleEmitterType = new BABYLON.ConeParticleEmitter(10,Math.PI);
		this.particleSystem.particleTexture = wl_core_Assets.getTexture("flare.png");
		this.particleSystem.color1 = DemoMain.BLUE.toColor4(1);
		this.particleSystem.color2 = DemoMain.BLUE_DARK.toColor4(1);
		this.particleSystem.colorDead = DemoMain.BLACK.toColor4(1);
		this.particleSystem.maxLifeTime = 60;
		this.particleSystem.maxEmitPower = 2;
		this.particleSystem.minEmitPower = 0.3;
		this.particleSystem.minSize = 0.01;
		this.particleSystem.maxSize = 0.1;
		this.particleSystem.emitter = emitter;
		this.particleSystem.gravity = new BABYLON.Vector3(0,0,-0.5);
		this.particleSystem.start();
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.ring1));
		this.addTrigger(new wl_core_TimeSig(2,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.fovOut));
		this.addTrigger(new wl_core_TimeSig(2,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.startParticles));
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.ring2));
		this.addTrigger(new wl_core_TimeSig(6,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.fadeCenterOut));
		this.addTrigger(new wl_core_TimeSig(16,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.distortOk));
		this.addTrigger(new wl_core_TimeSig(18,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.columnGrowStart));
		this.addTrigger(new wl_core_TimeSig(19,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.movecam));
		var textplane = BABYLON.MeshBuilder.CreatePlane("",{ width : 8, height : 4},this.scene);
		textplane.position.z = -5.5;
		var decalMaterial = new BABYLON.StandardMaterial("",null);
		decalMaterial.diffuseTexture = wl_core_Assets.getTexture("stellar_explorer.png");
		decalMaterial.diffuseTexture.hasAlpha = true;
		textplane.material = decalMaterial;
		this.setupPostprocessing();
		this.initSoundFilter();
	}
	,movecam: function(ts) {
		var v = new BABYLON.Vector3(-15,-20,-50);
		v.normalize();
		v = v.scale(90);
		createjs.Tween.get(this.camera.position).to({ x : v.x + 11, y : v.y - 5.5, z : v.z - 16},wl_core_TimeSig.milliseconds(5,0,0,0),createjs.Ease.quadIn);
		var camRot = this.camera.rotation.clone();
		this.camera.setTarget(v.scale(1.4).add(new BABYLON.Vector3(0,10,-10)));
		var targetRot = this.camera.rotation;
		this.camera.rotation = camRot;
		createjs.Tween.get(this.camera.rotation).to({ x : targetRot.x, y : targetRot.y, z : targetRot.z},wl_core_TimeSig.milliseconds(5,0,0,0),createjs.Ease.quadInOut);
		createjs.Tween.get(this.camera).wait(wl_core_TimeSig.milliseconds(3,0,0,0)).to({ fov : 0.05},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
		createjs.Tween.get(this.post.imageProcessing).wait(wl_core_TimeSig.milliseconds(4,2,0,0)).to({ exposure : 0},wl_core_TimeSig.milliseconds(0,1,10,0),createjs.Ease.quadIn);
		createjs.Tween.get(this).to({ distortMp : 0, chroma : 0},wl_core_TimeSig.milliseconds(3,0,0,0));
	}
	,distortOk: function(ts) {
		this.distortMp = 0.37;
	}
	,columnGrowStart: function(ts) {
		var _g = 0;
		var _g1 = this.rings;
		while(_g < _g1.length) {
			var r = _g1[_g];
			++_g;
			r.stopRot();
		}
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.columnGrow));
		this.columnGrow(ts);
	}
	,columnGrow: function(ts) {
		if(this.columns.length == 0) {
			return;
		}
		if(ts.beat % 2 != 0) {
			return;
		}
		createjs.Tween.get(this.columns.shift().scaling).to({ z : 505},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadOut);
	}
	,setupPostprocessing: function() {
		var plConf = { };
		plConf.dof = true;
		plConf.bloom = false;
		plConf.chromaticAberration = true;
		plConf.imageProcessing = true;
		plConf.grain = true;
		plConf.fxaa = true;
		plConf.sharpen = true;
		plConf.distort = true;
		this.initPipeline(plConf);
		this.post.dof.focalLength = 25;
		this.post.dof.focusDistance = 2500;
		this.post.dof.fStop = 1.0;
		this.post.dof.lensSize = 30;
		this.post.chromaticAberration.aberrationAmount = 5;
		this.post.imageProcessing.exposure = 1;
		this.post.imageProcessing.toneMappingEnabled = false;
		this.post.imageProcessing.vignetteEnabled = true;
		this.post.imageProcessing.vignetteBlendMode = 1;
		this.post.grain.animated = true;
		this.post.grain.intensity = 15;
	}
	,ring1: function(ts) {
		createjs.Tween.get(this.originRing.scaling).to({ x : 1.1, y : 1.1, z : 1.1},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadInOut);
	}
	,fovOut: function(ts) {
		createjs.Tween.get(this).to({ camMove : 4},wl_core_TimeSig.milliseconds(14,0,0,0),createjs.Ease.quadInOut);
		createjs.Tween.get(this.camera).to({ fov : 0.8},wl_core_TimeSig.milliseconds(8,0,0,0),createjs.Ease.quadInOut).wait(wl_core_TimeSig.milliseconds(2,0,0,0)).to({ fov : 1.2},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadInOut);
		createjs.Tween.get(this).to({ chroma : 1},wl_core_TimeSig.milliseconds(4,0,0,0));
	}
	,startParticles: function(ts) {
		createjs.Tween.get(this.particleSystem).to({ emitRate : 50000},wl_core_TimeSig.milliseconds(8,0,0,0),createjs.Ease.quadIn);
	}
	,ring2: function(ts) {
		this.addTrigger(new wl_core_TimeSig(-1,0,0,-1,wl_core_TimeSig.PATTERN),$bind(this,this.pulseRings));
		this.pulseRings(ts);
	}
	,pulseRings: function(ts) {
		if(this.ringsInPlace == this.rings.length) {
			return;
		}
		this.ringTargetscale += 0.58;
		var _g1 = this.ringsInPlace;
		var _g = this.rings.length;
		while(_g1 < _g) this.rings[_g1++].pulseTo(this.ringTargetscale,wl_core_TimeSig.milliseconds(0,2,0,0));
		this.ringsInPlace++;
	}
	,fadeCenterOut: function(ts) {
		createjs.Tween.get(this.light).to({ intensity : 1},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadOut);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var _g1 = 0;
		var _g = this.ringsInPlace;
		while(_g1 < _g) this.rings[_g1++].update(delta);
		this.updateSoundFilter();
		if(ts.bar < 19) {
			this.camera.position.y = Math.sin(ts.toMilliseconds() / 3500) * 2 * this.camMove;
			this.camera.position.x = Math.sin(ts.toMilliseconds() / 6500 + 2) * 3 * this.camMove;
			this.camera.setTarget(BABYLON.Vector3.Zero());
		}
		this.c0.update(ts);
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,stop: function() {
		wl_core_Part.prototype.stop.call(this);
	}
	,initSoundFilter: function() {
		this.soundAnalyzer = new wl_sounds_SoundAnalyzer();
		this.lowFilter = { lowLimit : 50, highLimit : 250, isolate : true};
		this.midFilter = { lowLimit : 750, highLimit : 3500, isolate : true};
		this.highFilter = { lowLimit : 10000, highLimit : 20000, isolate : true};
		this.soundAnalyzer.historySize = 6;
		this.soundAnalyzer.filters.push(this.lowFilter);
		this.soundAnalyzer.filters.push(this.midFilter);
		this.soundAnalyzer.filters.push(this.highFilter);
	}
	,updateSoundFilter: function() {
		this.soundAnalyzer.update();
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max > 0.0 ? this.lowFilter.max * 5 + 1.5 : 0;
		this.post.chromaticAberration.aberrationAmount = this.chroma * (this.midFilter.max > 0.65 ? (this.midFilter.max - 0.65) * (100 + this.distortMp * 110) + 5 : 5);
		this.post.grain.intensity = 15 + this.highFilter.max * 15;
		this.post.distort.intensity = this.highFilter.max > 0.55 - this.distortMp ? (this.highFilter.max - 0.55) / 60 : 0;
	}
	,__class__: intro_Intro
});
var intro_IntroColumn = function(name,scene) {
	BABYLON.TransformNode.call(this,name,scene);
	if(intro_IntroColumn.baseMesh == null) {
		this.windowShader = new snaketunnel_TubeWindow(wl_core_Assets.getTexture("perlin-512.png"));
		this.windowShader.color = DemoMain.WHITE.toColor4();
		var glowmaterial = this.windowShader.material;
		this.windowShader.material.setFloat("texScale",500);
		var glowstick = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : 1.5, height : 1},null);
		glowstick.material = glowmaterial;
		glowstick.parent = this;
		glowstick.rotation.x = Math.PI / 2;
		intro_IntroColumn.baseMesh = glowstick;
		this.mesh = intro_IntroColumn.baseMesh;
	} else {
		this.mesh = intro_IntroColumn.baseMesh.createInstance("col");
	}
	this.mesh.parent = this;
};
$hxClasses["intro.IntroColumn"] = intro_IntroColumn;
intro_IntroColumn.__name__ = ["intro","IntroColumn"];
intro_IntroColumn.__super__ = BABYLON.TransformNode;
intro_IntroColumn.prototype = $extend(BABYLON.TransformNode.prototype,{
	update: function(ts) {
		this.windowShader.update(ts);
	}
	,__class__: intro_IntroColumn
});
var intro_Ring = function(mesh) {
	this.rotMp = 1;
	this.pulsing = false;
	this.rotPhase = 0;
	this.rotAcceleration = 0;
	this.maxRot = 1400;
	this.maxRotSpeed = 0.005;
	this.mesh = mesh;
	this.rotAxis = [];
	var rndc = new wl_util_Random(7989);
	var _g = 0;
	while(_g < 3) {
		++_g;
		this.rotAxis.push(new BABYLON.Vector3(rndc.NextFloat(),rndc.NextFloat(),rndc.NextFloat()));
	}
};
$hxClasses["intro.Ring"] = intro_Ring;
intro_Ring.__name__ = ["intro","Ring"];
intro_Ring.prototype = {
	stopRot: function() {
		createjs.Tween.get(this).to({ rotMp : 0},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadOut);
	}
	,pulseTo: function(scale,time) {
		var _gthis = this;
		createjs.Tween.removeTweens(this.mesh.scaling);
		var tmp = createjs.Tween.get(this.mesh.scaling);
		var tmp1 = createjs.Ease.getBackOut(3.7);
		tmp.to({ x : scale, y : scale, z : scale},time,tmp1);
		if(this.pulsing) {
			return;
		}
		this.pulsing = true;
		haxe_Timer.delay(function() {
			_gthis.rotate = true;
		},wl_core_TimeSig.milliseconds(0,2,0,0));
	}
	,update: function(delta) {
		if(!this.rotate) {
			return;
		}
		this.rotPhase += 1 / wl_core_TimeSig.milliseconds(8,0,0,0) * delta * this.rotMp;
		var rotAngle = createjs.Ease.quadInOut(this.rotPhase) * this.maxRot;
		BABYLON.Quaternion.RotationAxisToRef(BABYLON.Vector3.Up(),0,this.mesh.rotationQuaternion);
		BABYLON.Quaternion.RotationAxisToRef(BABYLON.Vector3.Forward(),0,this.mesh.rotationQuaternion);
		BABYLON.Quaternion.RotationAxisToRef(BABYLON.Vector3.Right(),Math.PI / 2,this.mesh.rotationQuaternion);
		var _g = 0;
		var _g1 = this.rotAxis;
		while(_g < _g1.length) {
			var r = _g1[_g];
			++_g;
			this.mesh.rotate(r,rotAngle);
		}
	}
	,__class__: intro_Ring
};
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
$hxClasses["js._Boot.HaxeError"] = js__$Boot_HaxeError;
js__$Boot_HaxeError.__name__ = ["js","_Boot","HaxeError"];
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
$hxClasses["js.Boot"] = js_Boot;
js_Boot.__name__ = ["js","Boot"];
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0 ? "," : "") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = intf[_g1++];
			if(i == cl || js_Boot.__interfLoop(i,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_babylon_Promise = function() { };
$hxClasses["js.babylon.Promise"] = js_babylon_Promise;
js_babylon_Promise.__name__ = ["js","babylon","Promise"];
var js_babylon_ReadonlyArray = function() { };
$hxClasses["js.babylon.ReadonlyArray"] = js_babylon_ReadonlyArray;
js_babylon_ReadonlyArray.__name__ = ["js","babylon","ReadonlyArray"];
var js_babylon_Partial = function() { };
$hxClasses["js.babylon.Partial"] = js_babylon_Partial;
js_babylon_Partial.__name__ = ["js","babylon","Partial"];
var js_babylon_PromiseLike = function() { };
$hxClasses["js.babylon.PromiseLike"] = js_babylon_PromiseLike;
js_babylon_PromiseLike.__name__ = ["js","babylon","PromiseLike"];
var js_babylon_ArrayLike = function() { };
$hxClasses["js.babylon.ArrayLike"] = js_babylon_ArrayLike;
js_babylon_ArrayLike.__name__ = ["js","babylon","ArrayLike"];
var js_babylon_GamepadButton = function() { };
$hxClasses["js.babylon.GamepadButton"] = js_babylon_GamepadButton;
js_babylon_GamepadButton.__name__ = ["js","babylon","GamepadButton"];
var BABYLON_Window = function() { };
$hxClasses["BABYLON.Window"] = BABYLON_Window;
BABYLON_Window.__name__ = ["BABYLON","Window"];
BABYLON_Window.prototype = {
	__class__: BABYLON_Window
};
var BABYLON_WebGLRenderingContext = function() { };
$hxClasses["BABYLON.WebGLRenderingContext"] = BABYLON_WebGLRenderingContext;
BABYLON_WebGLRenderingContext.__name__ = ["BABYLON","WebGLRenderingContext"];
BABYLON_WebGLRenderingContext.prototype = {
	__class__: BABYLON_WebGLRenderingContext
};
var BABYLON_Document = function() { };
$hxClasses["BABYLON.Document"] = BABYLON_Document;
BABYLON_Document.__name__ = ["BABYLON","Document"];
BABYLON_Document.prototype = {
	__class__: BABYLON_Document
};
var BABYLON_HTMLCanvasElement = function() { };
$hxClasses["BABYLON.HTMLCanvasElement"] = BABYLON_HTMLCanvasElement;
BABYLON_HTMLCanvasElement.__name__ = ["BABYLON","HTMLCanvasElement"];
BABYLON_HTMLCanvasElement.prototype = {
	__class__: BABYLON_HTMLCanvasElement
};
var BABYLON_CanvasRenderingContext2D = function() { };
$hxClasses["BABYLON.CanvasRenderingContext2D"] = BABYLON_CanvasRenderingContext2D;
BABYLON_CanvasRenderingContext2D.__name__ = ["BABYLON","CanvasRenderingContext2D"];
BABYLON_CanvasRenderingContext2D.prototype = {
	__class__: BABYLON_CanvasRenderingContext2D
};
var BABYLON_WebGLBuffer = function() { };
$hxClasses["BABYLON.WebGLBuffer"] = BABYLON_WebGLBuffer;
BABYLON_WebGLBuffer.__name__ = ["BABYLON","WebGLBuffer"];
BABYLON_WebGLBuffer.prototype = {
	__class__: BABYLON_WebGLBuffer
};
var BABYLON_WebGLProgram = function() { };
$hxClasses["BABYLON.WebGLProgram"] = BABYLON_WebGLProgram;
BABYLON_WebGLProgram.__name__ = ["BABYLON","WebGLProgram"];
BABYLON_WebGLProgram.prototype = {
	__class__: BABYLON_WebGLProgram
};
var BABYLON_MouseEvent = function() { };
$hxClasses["BABYLON.MouseEvent"] = BABYLON_MouseEvent;
BABYLON_MouseEvent.__name__ = ["BABYLON","MouseEvent"];
BABYLON_MouseEvent.prototype = {
	__class__: BABYLON_MouseEvent
};
var BABYLON_Navigator = function() { };
$hxClasses["BABYLON.Navigator"] = BABYLON_Navigator;
BABYLON_Navigator.__name__ = ["BABYLON","Navigator"];
BABYLON_Navigator.prototype = {
	__class__: BABYLON_Navigator
};
var BABYLON_HTMLVideoElement = function() { };
$hxClasses["BABYLON.HTMLVideoElement"] = BABYLON_HTMLVideoElement;
BABYLON_HTMLVideoElement.__name__ = ["BABYLON","HTMLVideoElement"];
BABYLON_HTMLVideoElement.prototype = {
	__class__: BABYLON_HTMLVideoElement
};
var BABYLON_Screen = function() { };
$hxClasses["BABYLON.Screen"] = BABYLON_Screen;
BABYLON_Screen.__name__ = ["BABYLON","Screen"];
BABYLON_Screen.prototype = {
	__class__: BABYLON_Screen
};
var BABYLON_EXT_$disjoint_$timer_$query = function() { };
$hxClasses["BABYLON.EXT_disjoint_timer_query"] = BABYLON_EXT_$disjoint_$timer_$query;
BABYLON_EXT_$disjoint_$timer_$query.__name__ = ["BABYLON","EXT_disjoint_timer_query"];
BABYLON_EXT_$disjoint_$timer_$query.prototype = {
	__class__: BABYLON_EXT_$disjoint_$timer_$query
};
var BABYLON_WebGLUniformLocation = function() { };
$hxClasses["BABYLON.WebGLUniformLocation"] = BABYLON_WebGLUniformLocation;
BABYLON_WebGLUniformLocation.__name__ = ["BABYLON","WebGLUniformLocation"];
BABYLON_WebGLUniformLocation.prototype = {
	__class__: BABYLON_WebGLUniformLocation
};
var BABYLON_IDisposable = function() { };
$hxClasses["BABYLON.IDisposable"] = BABYLON_IDisposable;
BABYLON_IDisposable.__name__ = ["BABYLON","IDisposable"];
BABYLON_IDisposable.prototype = {
	__class__: BABYLON_IDisposable
};
var BABYLON_IActiveMeshCandidateProvider = function() { };
$hxClasses["BABYLON.IActiveMeshCandidateProvider"] = BABYLON_IActiveMeshCandidateProvider;
BABYLON_IActiveMeshCandidateProvider.__name__ = ["BABYLON","IActiveMeshCandidateProvider"];
BABYLON_IActiveMeshCandidateProvider.prototype = {
	__class__: BABYLON_IActiveMeshCandidateProvider
};
var BABYLON_IAnimatable = function() { };
$hxClasses["BABYLON.IAnimatable"] = BABYLON_IAnimatable;
BABYLON_IAnimatable.__name__ = ["BABYLON","IAnimatable"];
BABYLON_IAnimatable.prototype = {
	__class__: BABYLON_IAnimatable
};
var BABYLON_IAnimationKey = function() { };
$hxClasses["BABYLON.IAnimationKey"] = BABYLON_IAnimationKey;
BABYLON_IAnimationKey.__name__ = ["BABYLON","IAnimationKey"];
BABYLON_IAnimationKey.prototype = {
	__class__: BABYLON_IAnimationKey
};
var BABYLON_IEasingFunction = function() { };
$hxClasses["BABYLON.IEasingFunction"] = BABYLON_IEasingFunction;
BABYLON_IEasingFunction.__name__ = ["BABYLON","IEasingFunction"];
BABYLON_IEasingFunction.prototype = {
	__class__: BABYLON_IEasingFunction
};
var BABYLON_Behavior = function() { };
$hxClasses["BABYLON.Behavior"] = BABYLON_Behavior;
BABYLON_Behavior.__name__ = ["BABYLON","Behavior"];
BABYLON_Behavior.prototype = {
	__class__: BABYLON_Behavior
};
var BABYLON_ICollisionCoordinator = function() { };
$hxClasses["BABYLON.ICollisionCoordinator"] = BABYLON_ICollisionCoordinator;
BABYLON_ICollisionCoordinator.__name__ = ["BABYLON","ICollisionCoordinator"];
BABYLON_ICollisionCoordinator.prototype = {
	__class__: BABYLON_ICollisionCoordinator
};
var BABYLON_SerializedMesh = function() { };
$hxClasses["BABYLON.SerializedMesh"] = BABYLON_SerializedMesh;
BABYLON_SerializedMesh.__name__ = ["BABYLON","SerializedMesh"];
BABYLON_SerializedMesh.prototype = {
	__class__: BABYLON_SerializedMesh
};
var BABYLON_SerializedSubMesh = function() { };
$hxClasses["BABYLON.SerializedSubMesh"] = BABYLON_SerializedSubMesh;
BABYLON_SerializedSubMesh.__name__ = ["BABYLON","SerializedSubMesh"];
BABYLON_SerializedSubMesh.prototype = {
	__class__: BABYLON_SerializedSubMesh
};
var BABYLON_SerializedGeometry = function() { };
$hxClasses["BABYLON.SerializedGeometry"] = BABYLON_SerializedGeometry;
BABYLON_SerializedGeometry.__name__ = ["BABYLON","SerializedGeometry"];
BABYLON_SerializedGeometry.prototype = {
	__class__: BABYLON_SerializedGeometry
};
var BABYLON_BabylonMessage = function() { };
$hxClasses["BABYLON.BabylonMessage"] = BABYLON_BabylonMessage;
BABYLON_BabylonMessage.__name__ = ["BABYLON","BabylonMessage"];
BABYLON_BabylonMessage.prototype = {
	__class__: BABYLON_BabylonMessage
};
var BABYLON_SerializedColliderToWorker = function() { };
$hxClasses["BABYLON.SerializedColliderToWorker"] = BABYLON_SerializedColliderToWorker;
BABYLON_SerializedColliderToWorker.__name__ = ["BABYLON","SerializedColliderToWorker"];
BABYLON_SerializedColliderToWorker.prototype = {
	__class__: BABYLON_SerializedColliderToWorker
};
var BABYLON_WorkerReply = function() { };
$hxClasses["BABYLON.WorkerReply"] = BABYLON_WorkerReply;
BABYLON_WorkerReply.__name__ = ["BABYLON","WorkerReply"];
BABYLON_WorkerReply.prototype = {
	__class__: BABYLON_WorkerReply
};
var BABYLON_CollisionReplyPayload = function() { };
$hxClasses["BABYLON.CollisionReplyPayload"] = BABYLON_CollisionReplyPayload;
BABYLON_CollisionReplyPayload.__name__ = ["BABYLON","CollisionReplyPayload"];
BABYLON_CollisionReplyPayload.prototype = {
	__class__: BABYLON_CollisionReplyPayload
};
var BABYLON_InitPayload = function() { };
$hxClasses["BABYLON.InitPayload"] = BABYLON_InitPayload;
BABYLON_InitPayload.__name__ = ["BABYLON","InitPayload"];
var BABYLON_CollidePayload = function() { };
$hxClasses["BABYLON.CollidePayload"] = BABYLON_CollidePayload;
BABYLON_CollidePayload.__name__ = ["BABYLON","CollidePayload"];
BABYLON_CollidePayload.prototype = {
	__class__: BABYLON_CollidePayload
};
var BABYLON_UpdatePayload = function() { };
$hxClasses["BABYLON.UpdatePayload"] = BABYLON_UpdatePayload;
BABYLON_UpdatePayload.__name__ = ["BABYLON","UpdatePayload"];
BABYLON_UpdatePayload.prototype = {
	__class__: BABYLON_UpdatePayload
};
var BABYLON_ICollisionDetector = function() { };
$hxClasses["BABYLON.ICollisionDetector"] = BABYLON_ICollisionDetector;
BABYLON_ICollisionDetector.__name__ = ["BABYLON","ICollisionDetector"];
BABYLON_ICollisionDetector.prototype = {
	__class__: BABYLON_ICollisionDetector
};
var BABYLON_ICameraInput = function() { };
$hxClasses["BABYLON.ICameraInput"] = BABYLON_ICameraInput;
BABYLON_ICameraInput.__name__ = ["BABYLON","ICameraInput"];
BABYLON_ICameraInput.prototype = {
	__class__: BABYLON_ICameraInput
};
var BABYLON_CameraInputsMap = function() { };
$hxClasses["BABYLON.CameraInputsMap"] = BABYLON_CameraInputsMap;
BABYLON_CameraInputsMap.__name__ = ["BABYLON","CameraInputsMap"];
var BABYLON_VRDisplay = function() { };
$hxClasses["BABYLON.VRDisplay"] = BABYLON_VRDisplay;
BABYLON_VRDisplay.__name__ = ["BABYLON","VRDisplay"];
BABYLON_VRDisplay.prototype = {
	__class__: BABYLON_VRDisplay
};
var BABYLON_VRLayer = function() { };
$hxClasses["BABYLON.VRLayer"] = BABYLON_VRLayer;
BABYLON_VRLayer.__name__ = ["BABYLON","VRLayer"];
BABYLON_VRLayer.prototype = {
	__class__: BABYLON_VRLayer
};
var BABYLON_VRDisplayCapabilities = function() { };
$hxClasses["BABYLON.VRDisplayCapabilities"] = BABYLON_VRDisplayCapabilities;
BABYLON_VRDisplayCapabilities.__name__ = ["BABYLON","VRDisplayCapabilities"];
BABYLON_VRDisplayCapabilities.prototype = {
	__class__: BABYLON_VRDisplayCapabilities
};
var BABYLON_VREyeParameters = function() { };
$hxClasses["BABYLON.VREyeParameters"] = BABYLON_VREyeParameters;
BABYLON_VREyeParameters.__name__ = ["BABYLON","VREyeParameters"];
BABYLON_VREyeParameters.prototype = {
	__class__: BABYLON_VREyeParameters
};
var BABYLON_VRFieldOfView = function() { };
$hxClasses["BABYLON.VRFieldOfView"] = BABYLON_VRFieldOfView;
BABYLON_VRFieldOfView.__name__ = ["BABYLON","VRFieldOfView"];
BABYLON_VRFieldOfView.prototype = {
	__class__: BABYLON_VRFieldOfView
};
var BABYLON_VRFrameData = function() { };
$hxClasses["BABYLON.VRFrameData"] = BABYLON_VRFrameData;
BABYLON_VRFrameData.__name__ = ["BABYLON","VRFrameData"];
BABYLON_VRFrameData.prototype = {
	__class__: BABYLON_VRFrameData
};
var BABYLON_VRPose = function() { };
$hxClasses["BABYLON.VRPose"] = BABYLON_VRPose;
BABYLON_VRPose.__name__ = ["BABYLON","VRPose"];
BABYLON_VRPose.prototype = {
	__class__: BABYLON_VRPose
};
var BABYLON_VRStageParameters = function() { };
$hxClasses["BABYLON.VRStageParameters"] = BABYLON_VRStageParameters;
BABYLON_VRStageParameters.__name__ = ["BABYLON","VRStageParameters"];
BABYLON_VRStageParameters.prototype = {
	__class__: BABYLON_VRStageParameters
};
var BABYLON_EngineOptions = function() { };
$hxClasses["BABYLON.EngineOptions"] = BABYLON_EngineOptions;
BABYLON_EngineOptions.__name__ = ["BABYLON","EngineOptions"];
BABYLON_EngineOptions.prototype = {
	__class__: BABYLON_EngineOptions
};
var BABYLON_IDisplayChangedEventArgs = function() { };
$hxClasses["BABYLON.IDisplayChangedEventArgs"] = BABYLON_IDisplayChangedEventArgs;
BABYLON_IDisplayChangedEventArgs.__name__ = ["BABYLON","IDisplayChangedEventArgs"];
BABYLON_IDisplayChangedEventArgs.prototype = {
	__class__: BABYLON_IDisplayChangedEventArgs
};
var BABYLON_ImageBitmap = function() { };
$hxClasses["BABYLON.ImageBitmap"] = BABYLON_ImageBitmap;
BABYLON_ImageBitmap.__name__ = ["BABYLON","ImageBitmap"];
BABYLON_ImageBitmap.prototype = {
	__class__: BABYLON_ImageBitmap
};
var BABYLON_WebGLQuery = function() { };
$hxClasses["BABYLON.WebGLQuery"] = BABYLON_WebGLQuery;
BABYLON_WebGLQuery.__name__ = ["BABYLON","WebGLQuery"];
var BABYLON_WebGLSampler = function() { };
$hxClasses["BABYLON.WebGLSampler"] = BABYLON_WebGLSampler;
BABYLON_WebGLSampler.__name__ = ["BABYLON","WebGLSampler"];
var BABYLON_WebGLSync = function() { };
$hxClasses["BABYLON.WebGLSync"] = BABYLON_WebGLSync;
BABYLON_WebGLSync.__name__ = ["BABYLON","WebGLSync"];
var BABYLON_WebGLTransformFeedback = function() { };
$hxClasses["BABYLON.WebGLTransformFeedback"] = BABYLON_WebGLTransformFeedback;
BABYLON_WebGLTransformFeedback.__name__ = ["BABYLON","WebGLTransformFeedback"];
var BABYLON_WebGLVertexArrayObject = function() { };
$hxClasses["BABYLON.WebGLVertexArrayObject"] = BABYLON_WebGLVertexArrayObject;
BABYLON_WebGLVertexArrayObject.__name__ = ["BABYLON","WebGLVertexArrayObject"];
var BABYLON_ICullable = function() { };
$hxClasses["BABYLON.ICullable"] = BABYLON_ICullable;
BABYLON_ICullable.__name__ = ["BABYLON","ICullable"];
BABYLON_ICullable.prototype = {
	__class__: BABYLON_ICullable
};
var BABYLON_GamepadButtonChanges = function() { };
$hxClasses["BABYLON.GamepadButtonChanges"] = BABYLON_GamepadButtonChanges;
BABYLON_GamepadButtonChanges.__name__ = ["BABYLON","GamepadButtonChanges"];
BABYLON_GamepadButtonChanges.prototype = {
	__class__: BABYLON_GamepadButtonChanges
};
var BABYLON_IEnvironmentHelperOptions = function() { };
$hxClasses["BABYLON.IEnvironmentHelperOptions"] = BABYLON_IEnvironmentHelperOptions;
BABYLON_IEnvironmentHelperOptions.__name__ = ["BABYLON","IEnvironmentHelperOptions"];
BABYLON_IEnvironmentHelperOptions.prototype = {
	__class__: BABYLON_IEnvironmentHelperOptions
};
var BABYLON_IEffectLayerOptions = function() { };
$hxClasses["BABYLON.IEffectLayerOptions"] = BABYLON_IEffectLayerOptions;
BABYLON_IEffectLayerOptions.__name__ = ["BABYLON","IEffectLayerOptions"];
BABYLON_IEffectLayerOptions.prototype = {
	__class__: BABYLON_IEffectLayerOptions
};
var BABYLON_IGlowLayerOptions = function() { };
$hxClasses["BABYLON.IGlowLayerOptions"] = BABYLON_IGlowLayerOptions;
BABYLON_IGlowLayerOptions.__name__ = ["BABYLON","IGlowLayerOptions"];
BABYLON_IGlowLayerOptions.prototype = {
	__class__: BABYLON_IGlowLayerOptions
};
var BABYLON_IHighlightLayerOptions = function() { };
$hxClasses["BABYLON.IHighlightLayerOptions"] = BABYLON_IHighlightLayerOptions;
BABYLON_IHighlightLayerOptions.__name__ = ["BABYLON","IHighlightLayerOptions"];
BABYLON_IHighlightLayerOptions.prototype = {
	__class__: BABYLON_IHighlightLayerOptions
};
var BABYLON_IShadowLight = function() { };
$hxClasses["BABYLON.IShadowLight"] = BABYLON_IShadowLight;
BABYLON_IShadowLight.__name__ = ["BABYLON","IShadowLight"];
BABYLON_IShadowLight.prototype = {
	__class__: BABYLON_IShadowLight
};
var BABYLON_ILoadingScreen = function() { };
$hxClasses["BABYLON.ILoadingScreen"] = BABYLON_ILoadingScreen;
BABYLON_ILoadingScreen.__name__ = ["BABYLON","ILoadingScreen"];
BABYLON_ILoadingScreen.prototype = {
	__class__: BABYLON_ILoadingScreen
};
var BABYLON_ISceneLoaderPluginExtensions = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginExtensions"] = BABYLON_ISceneLoaderPluginExtensions;
BABYLON_ISceneLoaderPluginExtensions.__name__ = ["BABYLON","ISceneLoaderPluginExtensions"];
var BABYLON_ISceneLoaderPluginFactory = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginFactory"] = BABYLON_ISceneLoaderPluginFactory;
BABYLON_ISceneLoaderPluginFactory.__name__ = ["BABYLON","ISceneLoaderPluginFactory"];
BABYLON_ISceneLoaderPluginFactory.prototype = {
	__class__: BABYLON_ISceneLoaderPluginFactory
};
var BABYLON_ISceneLoaderPlugin = function() { };
$hxClasses["BABYLON.ISceneLoaderPlugin"] = BABYLON_ISceneLoaderPlugin;
BABYLON_ISceneLoaderPlugin.__name__ = ["BABYLON","ISceneLoaderPlugin"];
BABYLON_ISceneLoaderPlugin.prototype = {
	__class__: BABYLON_ISceneLoaderPlugin
};
var BABYLON_ISceneLoaderPluginAsync = function() { };
$hxClasses["BABYLON.ISceneLoaderPluginAsync"] = BABYLON_ISceneLoaderPluginAsync;
BABYLON_ISceneLoaderPluginAsync.__name__ = ["BABYLON","ISceneLoaderPluginAsync"];
BABYLON_ISceneLoaderPluginAsync.prototype = {
	__class__: BABYLON_ISceneLoaderPluginAsync
};
var BABYLON_IImageProcessingConfigurationDefines = function() { };
$hxClasses["BABYLON.IImageProcessingConfigurationDefines"] = BABYLON_IImageProcessingConfigurationDefines;
BABYLON_IImageProcessingConfigurationDefines.__name__ = ["BABYLON","IImageProcessingConfigurationDefines"];
BABYLON_IImageProcessingConfigurationDefines.prototype = {
	__class__: BABYLON_IImageProcessingConfigurationDefines
};
var BABYLON_ISize = function() { };
$hxClasses["BABYLON.ISize"] = BABYLON_ISize;
BABYLON_ISize.__name__ = ["BABYLON","ISize"];
BABYLON_ISize.prototype = {
	__class__: BABYLON_ISize
};
var BABYLON_IGetSetVerticesData = function() { };
$hxClasses["BABYLON.IGetSetVerticesData"] = BABYLON_IGetSetVerticesData;
BABYLON_IGetSetVerticesData.__name__ = ["BABYLON","IGetSetVerticesData"];
BABYLON_IGetSetVerticesData.prototype = {
	__class__: BABYLON_IGetSetVerticesData
};
var BABYLON_ISimplifier = function() { };
$hxClasses["BABYLON.ISimplifier"] = BABYLON_ISimplifier;
BABYLON_ISimplifier.__name__ = ["BABYLON","ISimplifier"];
BABYLON_ISimplifier.prototype = {
	__class__: BABYLON_ISimplifier
};
var BABYLON_ISimplificationSettings = function() { };
$hxClasses["BABYLON.ISimplificationSettings"] = BABYLON_ISimplificationSettings;
BABYLON_ISimplificationSettings.__name__ = ["BABYLON","ISimplificationSettings"];
BABYLON_ISimplificationSettings.prototype = {
	__class__: BABYLON_ISimplificationSettings
};
var BABYLON_ISimplificationTask = function() { };
$hxClasses["BABYLON.ISimplificationTask"] = BABYLON_ISimplificationTask;
BABYLON_ISimplificationTask.__name__ = ["BABYLON","ISimplificationTask"];
BABYLON_ISimplificationTask.prototype = {
	__class__: BABYLON_ISimplificationTask
};
var BABYLON_IParticleSystem = function() { };
$hxClasses["BABYLON.IParticleSystem"] = BABYLON_IParticleSystem;
BABYLON_IParticleSystem.__name__ = ["BABYLON","IParticleSystem"];
BABYLON_IParticleSystem.prototype = {
	__class__: BABYLON_IParticleSystem
};
var BABYLON_PhysicsImpostorJoint = function() { };
$hxClasses["BABYLON.PhysicsImpostorJoint"] = BABYLON_PhysicsImpostorJoint;
BABYLON_PhysicsImpostorJoint.__name__ = ["BABYLON","PhysicsImpostorJoint"];
BABYLON_PhysicsImpostorJoint.prototype = {
	__class__: BABYLON_PhysicsImpostorJoint
};
var BABYLON_IPhysicsEnginePlugin = function() { };
$hxClasses["BABYLON.IPhysicsEnginePlugin"] = BABYLON_IPhysicsEnginePlugin;
BABYLON_IPhysicsEnginePlugin.__name__ = ["BABYLON","IPhysicsEnginePlugin"];
BABYLON_IPhysicsEnginePlugin.prototype = {
	__class__: BABYLON_IPhysicsEnginePlugin
};
var BABYLON_PhysicsForceAndContactPoint = function() { };
$hxClasses["BABYLON.PhysicsForceAndContactPoint"] = BABYLON_PhysicsForceAndContactPoint;
BABYLON_PhysicsForceAndContactPoint.__name__ = ["BABYLON","PhysicsForceAndContactPoint"];
BABYLON_PhysicsForceAndContactPoint.prototype = {
	__class__: BABYLON_PhysicsForceAndContactPoint
};
var BABYLON_PhysicsRadialExplosionEventData = function() { };
$hxClasses["BABYLON.PhysicsRadialExplosionEventData"] = BABYLON_PhysicsRadialExplosionEventData;
BABYLON_PhysicsRadialExplosionEventData.__name__ = ["BABYLON","PhysicsRadialExplosionEventData"];
BABYLON_PhysicsRadialExplosionEventData.prototype = {
	__class__: BABYLON_PhysicsRadialExplosionEventData
};
var BABYLON_PhysicsGravitationalFieldEventData = function() { };
$hxClasses["BABYLON.PhysicsGravitationalFieldEventData"] = BABYLON_PhysicsGravitationalFieldEventData;
BABYLON_PhysicsGravitationalFieldEventData.__name__ = ["BABYLON","PhysicsGravitationalFieldEventData"];
BABYLON_PhysicsGravitationalFieldEventData.prototype = {
	__class__: BABYLON_PhysicsGravitationalFieldEventData
};
var BABYLON_PhysicsUpdraftEventData = function() { };
$hxClasses["BABYLON.PhysicsUpdraftEventData"] = BABYLON_PhysicsUpdraftEventData;
BABYLON_PhysicsUpdraftEventData.__name__ = ["BABYLON","PhysicsUpdraftEventData"];
BABYLON_PhysicsUpdraftEventData.prototype = {
	__class__: BABYLON_PhysicsUpdraftEventData
};
var BABYLON_PhysicsVortexEventData = function() { };
$hxClasses["BABYLON.PhysicsVortexEventData"] = BABYLON_PhysicsVortexEventData;
BABYLON_PhysicsVortexEventData.__name__ = ["BABYLON","PhysicsVortexEventData"];
BABYLON_PhysicsVortexEventData.prototype = {
	__class__: BABYLON_PhysicsVortexEventData
};
var BABYLON_PhysicsImpostorParameters = function() { };
$hxClasses["BABYLON.PhysicsImpostorParameters"] = BABYLON_PhysicsImpostorParameters;
BABYLON_PhysicsImpostorParameters.__name__ = ["BABYLON","PhysicsImpostorParameters"];
BABYLON_PhysicsImpostorParameters.prototype = {
	__class__: BABYLON_PhysicsImpostorParameters
};
var BABYLON_IPhysicsEnabledObject = function() { };
$hxClasses["BABYLON.IPhysicsEnabledObject"] = BABYLON_IPhysicsEnabledObject;
BABYLON_IPhysicsEnabledObject.__name__ = ["BABYLON","IPhysicsEnabledObject"];
BABYLON_IPhysicsEnabledObject.prototype = {
	__class__: BABYLON_IPhysicsEnabledObject
};
var BABYLON_PhysicsJointData = function() { };
$hxClasses["BABYLON.PhysicsJointData"] = BABYLON_PhysicsJointData;
BABYLON_PhysicsJointData.__name__ = ["BABYLON","PhysicsJointData"];
BABYLON_PhysicsJointData.prototype = {
	__class__: BABYLON_PhysicsJointData
};
var BABYLON_IMotorEnabledJoint = function() { };
$hxClasses["BABYLON.IMotorEnabledJoint"] = BABYLON_IMotorEnabledJoint;
BABYLON_IMotorEnabledJoint.__name__ = ["BABYLON","IMotorEnabledJoint"];
BABYLON_IMotorEnabledJoint.prototype = {
	__class__: BABYLON_IMotorEnabledJoint
};
var BABYLON_DistanceJointData = function() { };
$hxClasses["BABYLON.DistanceJointData"] = BABYLON_DistanceJointData;
BABYLON_DistanceJointData.__name__ = ["BABYLON","DistanceJointData"];
BABYLON_DistanceJointData.__interfaces__ = [BABYLON_PhysicsJointData];
BABYLON_DistanceJointData.prototype = {
	__class__: BABYLON_DistanceJointData
};
var BABYLON_SpringJointData = function() { };
$hxClasses["BABYLON.SpringJointData"] = BABYLON_SpringJointData;
BABYLON_SpringJointData.__name__ = ["BABYLON","SpringJointData"];
BABYLON_SpringJointData.__interfaces__ = [BABYLON_PhysicsJointData];
BABYLON_SpringJointData.prototype = {
	__class__: BABYLON_SpringJointData
};
var BABYLON_IAssetsProgressEvent = function() { };
$hxClasses["BABYLON.IAssetsProgressEvent"] = BABYLON_IAssetsProgressEvent;
BABYLON_IAssetsProgressEvent.__name__ = ["BABYLON","IAssetsProgressEvent"];
BABYLON_IAssetsProgressEvent.prototype = {
	__class__: BABYLON_IAssetsProgressEvent
};
var BABYLON_ITextureAssetTask = function() { };
$hxClasses["BABYLON.ITextureAssetTask"] = BABYLON_ITextureAssetTask;
BABYLON_ITextureAssetTask.__name__ = ["BABYLON","ITextureAssetTask"];
BABYLON_ITextureAssetTask.prototype = {
	__class__: BABYLON_ITextureAssetTask
};
var BABYLON_DDSInfo = function() { };
$hxClasses["BABYLON.DDSInfo"] = BABYLON_DDSInfo;
BABYLON_DDSInfo.__name__ = ["BABYLON","DDSInfo"];
BABYLON_DDSInfo.prototype = {
	__class__: BABYLON_DDSInfo
};
var BABYLON_IFileRequest = function() { };
$hxClasses["BABYLON.IFileRequest"] = BABYLON_IFileRequest;
BABYLON_IFileRequest.__name__ = ["BABYLON","IFileRequest"];
BABYLON_IFileRequest.prototype = {
	__class__: BABYLON_IFileRequest
};
var BABYLON_VRTeleportationOptions = function() { };
$hxClasses["BABYLON.VRTeleportationOptions"] = BABYLON_VRTeleportationOptions;
BABYLON_VRTeleportationOptions.__name__ = ["BABYLON","VRTeleportationOptions"];
BABYLON_VRTeleportationOptions.prototype = {
	__class__: BABYLON_VRTeleportationOptions
};
var BABYLON_WebVROptions = function() { };
$hxClasses["BABYLON.WebVROptions"] = BABYLON_WebVROptions;
BABYLON_WebVROptions.__name__ = ["BABYLON","WebVROptions"];
BABYLON_WebVROptions.prototype = {
	__class__: BABYLON_WebVROptions
};
var BABYLON_VRExperienceHelperOptions = function() { };
$hxClasses["BABYLON.VRExperienceHelperOptions"] = BABYLON_VRExperienceHelperOptions;
BABYLON_VRExperienceHelperOptions.__name__ = ["BABYLON","VRExperienceHelperOptions"];
BABYLON_VRExperienceHelperOptions.__interfaces__ = [BABYLON_WebVROptions];
BABYLON_VRExperienceHelperOptions.prototype = {
	__class__: BABYLON_VRExperienceHelperOptions
};
var BABYLON_DevicePose = function() { };
$hxClasses["BABYLON.DevicePose"] = BABYLON_DevicePose;
BABYLON_DevicePose.__name__ = ["BABYLON","DevicePose"];
BABYLON_DevicePose.prototype = {
	__class__: BABYLON_DevicePose
};
var BABYLON_PoseControlled = function() { };
$hxClasses["BABYLON.PoseControlled"] = BABYLON_PoseControlled;
BABYLON_PoseControlled.__name__ = ["BABYLON","PoseControlled"];
BABYLON_PoseControlled.prototype = {
	__class__: BABYLON_PoseControlled
};
var BABYLON_IOctreeContainer = function() { };
$hxClasses["BABYLON.IOctreeContainer"] = BABYLON_IOctreeContainer;
BABYLON_IOctreeContainer.__name__ = ["BABYLON","IOctreeContainer"];
BABYLON_IOctreeContainer.prototype = {
	__class__: BABYLON_IOctreeContainer
};
var BABYLON_MutableGamepadButton = function() { };
$hxClasses["BABYLON.MutableGamepadButton"] = BABYLON_MutableGamepadButton;
BABYLON_MutableGamepadButton.__name__ = ["BABYLON","MutableGamepadButton"];
BABYLON_MutableGamepadButton.prototype = {
	__class__: BABYLON_MutableGamepadButton
};
var BABYLON_ExtendedGamepadButton = function() { };
$hxClasses["BABYLON.ExtendedGamepadButton"] = BABYLON_ExtendedGamepadButton;
BABYLON_ExtendedGamepadButton.__name__ = ["BABYLON","ExtendedGamepadButton"];
BABYLON_ExtendedGamepadButton.prototype = {
	__class__: BABYLON_ExtendedGamepadButton
};
var BABYLON_IShadowGenerator = function() { };
$hxClasses["BABYLON.IShadowGenerator"] = BABYLON_IShadowGenerator;
BABYLON_IShadowGenerator.__name__ = ["BABYLON","IShadowGenerator"];
BABYLON_IShadowGenerator.prototype = {
	__class__: BABYLON_IShadowGenerator
};
var BABYLON_IInternalTextureTracker = function() { };
$hxClasses["BABYLON.IInternalTextureTracker"] = BABYLON_IInternalTextureTracker;
BABYLON_IInternalTextureTracker.__name__ = ["BABYLON","IInternalTextureTracker"];
BABYLON_IInternalTextureTracker.prototype = {
	__class__: BABYLON_IInternalTextureTracker
};
var BABYLON_IMultiRenderTargetOptions = function() { };
$hxClasses["BABYLON.IMultiRenderTargetOptions"] = BABYLON_IMultiRenderTargetOptions;
BABYLON_IMultiRenderTargetOptions.__name__ = ["BABYLON","IMultiRenderTargetOptions"];
BABYLON_IMultiRenderTargetOptions.prototype = {
	__class__: BABYLON_IMultiRenderTargetOptions
};
var BABYLON_VideoTextureSettings = function() { };
$hxClasses["BABYLON.VideoTextureSettings"] = BABYLON_VideoTextureSettings;
BABYLON_VideoTextureSettings.__name__ = ["BABYLON","VideoTextureSettings"];
BABYLON_VideoTextureSettings.prototype = {
	__class__: BABYLON_VideoTextureSettings
};
var BABYLON_IDracoCompressionConfiguration = function() { };
$hxClasses["BABYLON.IDracoCompressionConfiguration"] = BABYLON_IDracoCompressionConfiguration;
BABYLON_IDracoCompressionConfiguration.__name__ = ["BABYLON","IDracoCompressionConfiguration"];
BABYLON_IDracoCompressionConfiguration.prototype = {
	__class__: BABYLON_IDracoCompressionConfiguration
};
var BABYLON_IParticleEmitterType = function() { };
$hxClasses["BABYLON.IParticleEmitterType"] = BABYLON_IParticleEmitterType;
BABYLON_IParticleEmitterType.__name__ = ["BABYLON","IParticleEmitterType"];
BABYLON_IParticleEmitterType.prototype = {
	__class__: BABYLON_IParticleEmitterType
};
var BABYLON_HDRInfo = function() { };
$hxClasses["BABYLON.HDRInfo"] = BABYLON_HDRInfo;
BABYLON_HDRInfo.__name__ = ["BABYLON","HDRInfo"];
BABYLON_HDRInfo.prototype = {
	__class__: BABYLON_HDRInfo
};
var BABYLON_CubeMapInfo = function() { };
$hxClasses["BABYLON.CubeMapInfo"] = BABYLON_CubeMapInfo;
BABYLON_CubeMapInfo.__name__ = ["BABYLON","CubeMapInfo"];
BABYLON_CubeMapInfo.prototype = {
	__class__: BABYLON_CubeMapInfo
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) this.a[_g1++] = 0;
		this.byteLength = len;
	}
};
$hxClasses["js.html.compat.ArrayBuffer"] = js_html_compat_ArrayBuffer;
js_html_compat_ArrayBuffer.__name__ = ["js","html","compat","ArrayBuffer"];
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null ? null : end - begin);
	var result = new ArrayBuffer(u.byteLength);
	new Uint8Array(result).set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_Float32Array = function() { };
$hxClasses["js.html.compat.Float32Array"] = js_html_compat_Float32Array;
js_html_compat_Float32Array.__name__ = ["js","html","compat","Float32Array"];
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Uint8Array = function() { };
$hxClasses["js.html.compat.Uint8Array"] = js_html_compat_Uint8Array;
js_html_compat_Uint8Array.__name__ = ["js","html","compat","Uint8Array"];
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var posttest_Column = function(name,scene) {
	BABYLON.TransformNode.call(this,name,scene);
	if(posttest_Column.baseMesh == null) {
		this.windowShader = new snaketunnel_TubeWindow(wl_core_Assets.getTexture("perlin-512.png"));
		this.windowShader.color = DemoMain.WHITE.toColor4();
		var glowmaterial = this.windowShader.material;
		this.windowShader.material.setFloat("texScale",500);
		var glowstick = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : 1.5, height : 1},null);
		glowstick.material = glowmaterial;
		glowstick.parent = this;
		glowstick.rotation.x = Math.PI / 2;
		posttest_Column.baseMesh = glowstick;
		this.mesh = posttest_Column.baseMesh;
	} else {
		this.mesh = posttest_Column.baseMesh.createInstance("col");
	}
	this.mesh.parent = this;
};
$hxClasses["posttest.Column"] = posttest_Column;
posttest_Column.__name__ = ["posttest","Column"];
posttest_Column.__super__ = BABYLON.TransformNode;
posttest_Column.prototype = $extend(BABYLON.TransformNode.prototype,{
	update: function(ts) {
		this.windowShader.update(ts);
	}
	,__class__: posttest_Column
});
var posttest_CubeSPS = function(scene) {
	BABYLON.TransformNode.call(this,"sps",scene);
	this.sps = new BABYLON.SolidParticleSystem("sps",scene,{ updatable : false, isPickable : false, enableDepthSort : true, particleIntersection : false, boundingSphereOnly : true});
	var b = BABYLON.MeshBuilder.CreateBox("box",{ });
	var sm = new BABYLON.StandardMaterial("sm",scene);
	b.material = sm;
	sm.specularColor = DemoMain.WHITE;
	var size = 500;
	var r = new wl_util_Random(123);
	var cols = [DemoMain.GROUND,DemoMain.LIGHT];
	var posfunc = function(p,i,s) {
		var posfunc1 = r.NextFloat() - 0.5;
		p.position.x = posfunc1 * size;
		var posfunc2 = r.NextFloat() - 0.5;
		p.position.y = posfunc2 * size;
		var posfunc3 = r.NextFloat() - 0.5;
		p.position.z = posfunc3 * size;
		p.position.normalize();
		var d = r.NextFloat() * r.NextFloat() * size;
		p.position = p.position.multiplyByFloats(d,d,d);
		var posfunc4 = r.NextFloat();
		p.rotation.x = posfunc4 * Math.PI;
		var posfunc5 = r.NextFloat();
		p.rotation.y = posfunc5 * Math.PI;
		var posfunc6 = r.NextFloat();
		p.rotation.z = posfunc6 * Math.PI;
		var posfunc7 = r.Next() % cols.length;
		p.color = cols[posfunc7].toColor4(1);
	};
	this.sps.addShape(b,100000,{ positionFunction : posfunc});
	this.sps.buildMesh().parent = this;
	b.dispose();
};
$hxClasses["posttest.CubeSPS"] = posttest_CubeSPS;
posttest_CubeSPS.__name__ = ["posttest","CubeSPS"];
posttest_CubeSPS.__super__ = BABYLON.TransformNode;
posttest_CubeSPS.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: posttest_CubeSPS
});
var posttest_GreetSPS = function(name,scene,mat) {
	this.conf = [];
	this.phase = 0;
	this.intro = 0;
	var _gthis = this;
	BABYLON.TransformNode.call(this,name,scene);
	var img = wl_core_Assets.get(name);
	var id = wl_util_ExtractPixels.extract(img);
	this.sps = new BABYLON.SolidParticleSystem("sps",scene,{ updatable : true, isPickable : false, enableDepthSort : false, particleIntersection : false, boundingSphereOnly : true});
	var b = BABYLON.MeshBuilder.CreateBox("box",{ width : 1, height : 1, depth : 1});
	b.receiveShadows = false;
	b.material = mat;
	this.sps.computeParticleColor = false;
	this.sps.computeParticleRotation = false;
	this.sps.computeParticleTexture = false;
	var amount = id.width * id.height;
	new wl_util_Random(123);
	var _g1 = 0;
	while(_g1 < amount) {
		var i = _g1++;
		if(i >= id.width * id.height) {
			var angle = i % 2 == 1 ? wl_util_Random.nextFloat() - 0.5 : wl_util_Random.nextFloat() - 0.5 - Math.PI;
			var dist = wl_util_Random.nextFloat() * wl_util_Random.nextFloat() * 70;
			var spx = i % 2 == 0 ? -1 : id.width;
			var spy = id.height - Math.floor(Math.random() * id.height);
			var gpc = { startX : spx - img.width / 2, startY : spy - img.height / 2, startZ : 0, targetX : spx + Math.cos(angle) * dist - img.width / 2, targetY : spy + Math.sin(angle) * dist - img.height / 2, targetZ : (wl_util_Random.nextFloat() - 0.5) * dist / 3, rotX : wl_util_Random.nextFloat(), rotY : wl_util_Random.nextFloat(), rotZ : wl_util_Random.nextFloat(), delay : wl_util_Random.nextFloat() * 0.5, targetScale : 1};
			this.conf.push(gpc);
		} else {
			var gpc1 = { startX : i % id.width - img.width / 2, startY : id.height - Math.floor(i / id.width) - img.height / 2, startZ : 0, targetX : i % id.width - (id.width / 2 - i % id.width) * (wl_util_Random.nextFloat() + 0.5) - img.width / 2, targetY : id.height - (Math.floor(i / id.width) - id.height / 2) * 3 * (wl_util_Random.nextFloat() + 0.5) - img.height / 2, targetZ : (wl_util_Random.nextFloat() - 0.5) * 3, rotX : 0, rotY : 0, rotZ : 0, delay : wl_util_Random.nextFloat() * 0.5 + 1.0, targetScale : 1};
			this.conf.push(gpc1);
		}
	}
	var posfunc = function(p,i1,s) {
		if(i1 == null) {
			i1 = p.idx;
		} else {
			i1 = i1;
		}
		var conf = _gthis.conf[i1];
		p.color = i1 >= id.width * id.height || id.data[i1 * 4] > 0 ? DemoMain.GROUND.toColor4(1).scale(0.6) : DemoMain.WHITE.toColor4(1);
		var phase = _gthis.phase - conf.delay;
		var introPhase = _gthis.intro - conf.delay * 0.25;
		if(_gthis.intro < 1) {
			if(introPhase > 0) {
				introPhase = 0;
			} else {
				introPhase = introPhase;
			}
			p.position.x = conf.startX;
			p.position.y = conf.startY;
			var posfunc1 = conf.startZ + Math.sin(conf.startY / 5 + conf.startX / 9 + _gthis.intro * 7) * 5;
			p.position.z = posfunc1 + (id.data[i1 * 4] > 0 ? -1 : 0);
			p.rotation.x = conf.rotX;
			p.rotation.y = conf.rotY;
			p.rotation.z = conf.rotZ;
			if(_gthis.intro <= 0) {
				p.scaling.x = p.scaling.y = p.scaling.z = 0.0001;
			} else {
				p.scaling.x = p.scaling.y = p.scaling.z = 1 + introPhase;
			}
		} else {
			if(phase < 0) {
				phase = 0;
			} else {
				phase = phase;
			}
			var movePhase = createjs.Ease.quadIn(phase);
			p.position.x = conf.startX + (conf.targetX - conf.startX) * movePhase * 16;
			p.position.y = conf.startY + (conf.targetY - conf.startY) * movePhase * 16;
			var posfunc2 = conf.startZ + (conf.targetZ - conf.startZ) * movePhase * 16 + Math.sin(conf.startY / 5 + conf.startX / 9 + _gthis.intro * 7 + _gthis.phase * 7) * 5;
			p.position.z = posfunc2 + (id.data[i1 * 4] > 0 ? -1 : 0);
			p.rotation.x = conf.rotX;
			p.rotation.y = conf.rotY;
			p.rotation.z = conf.rotZ;
			p.scaling.x = p.scaling.y = p.scaling.z = 1 - phase / (2 - conf.delay);
		}
	};
	this.sps.updateParticle = posfunc;
	this.sps.addShape(b,amount,{ positionFunction : posfunc});
	this.mesh = this.sps.buildMesh();
	this.mesh.parent = this;
	b.dispose();
	this.sps.setParticles();
	this.mesh.visibility = 1;
};
$hxClasses["posttest.GreetSPS"] = posttest_GreetSPS;
posttest_GreetSPS.__name__ = ["posttest","GreetSPS"];
posttest_GreetSPS.__super__ = BABYLON.TransformNode;
posttest_GreetSPS.prototype = $extend(BABYLON.TransformNode.prototype,{
	update: function() {
		if(this.sps != null) {
			this.sps.setParticles();
		}
	}
	,animateIn: function(ts,cb,longOut) {
		var _gthis = this;
		this.mesh.visibility = 1;
		createjs.Tween.get(this).to({ intro : 1},wl_core_TimeSig.milliseconds(0,2,0,0)).to({ phase : 2},wl_core_TimeSig.milliseconds(longOut ? 100 : 1,2,0,0)).call(function() {
			cb(_gthis);
			createjs.Tween.removeTweens(_gthis);
			_gthis.sps.dispose();
			_gthis.sps = null;
		});
	}
	,__class__: posttest_GreetSPS
});
var posttest_HairyBall = function(name,scene) {
	this.offset = wl_util_Random.nextFloat() * 0.5;
	BABYLON.TransformNode.call(this,name);
	this.scene = scene;
	if(posttest_HairyBall.texture == null) {
		posttest_HairyBall.texture = this.generateTexture();
	}
	this.initializeControls();
};
$hxClasses["posttest.HairyBall"] = posttest_HairyBall;
posttest_HairyBall.__name__ = ["posttest","HairyBall"];
posttest_HairyBall.__super__ = BABYLON.TransformNode;
posttest_HairyBall.prototype = $extend(BABYLON.TransformNode.prototype,{
	initializeControls: function() {
		if(posttest_HairyBall.baseMesh == null) {
			posttest_HairyBall.baseMesh = BABYLON.MeshBuilder.CreateBox("box",{ });
			this.mesh = posttest_HairyBall.baseMesh;
			posttest_HairyBall.fur = new BABYLON.StandardMaterial("mat",this.scene);
			posttest_HairyBall.fur.wireframe = false;
			posttest_HairyBall.fur.diffuseColor = DemoMain.HILIGHT;
			this.mesh.material = posttest_HairyBall.fur;
		} else {
			this.mesh = posttest_HairyBall.baseMesh.createInstance("inst");
		}
		this.mesh.parent = this;
	}
	,generateTexture: function() {
		var r = new wl_util_Random(10);
		var texture = new BABYLON.DynamicTexture("FurTexture " + this.name,256,null,true);
		var context = texture.getContext();
		var _g = 0;
		while(_g < 20000) {
			++_g;
			context.fillStyle = "rgba(255, " + Math.floor(r.NextFloat() * 255) + ", " + Math.floor(r.NextFloat() * 255) + ", 1)";
			context.fillRect(r.NextFloat() * texture.getSize().width,r.NextFloat() * texture.getSize().height,2,2);
		}
		texture.update(false);
		texture.wrapU = BABYLON.Texture.WRAP_ADDRESSMODE;
		texture.wrapV = BABYLON.Texture.WRAP_ADDRESSMODE;
		return texture;
	}
	,__class__: posttest_HairyBall
});
var posttest_PostTest = function() {
	this.startTime = 0;
	this.exposureMp = 0;
	this.bloomMp = 1;
	this.positions = [new BABYLON.Vector3(140,5,-600),new BABYLON.Vector3(50,30,-500),new BABYLON.Vector3(80,-30,-560),new BABYLON.Vector3(105,0,-520),new BABYLON.Vector3(50,30,-460),new BABYLON.Vector3(54,-25,-450),new BABYLON.Vector3(120,25,-470),new BABYLON.Vector3(30,10,-460),new BABYLON.Vector3(120,-30,-300),new BABYLON.Vector3(0,30,-340),new BABYLON.Vector3(10,-10,-350),new BABYLON.Vector3(90,30,-360),new BABYLON.Vector3(55,-30,-380),new BABYLON.Vector3(-20,0,-320),new BABYLON.Vector3(130,25,-350),new BABYLON.Vector3(70,0,-320),new BABYLON.Vector3(50,40,-270),new BABYLON.Vector3(50,-45,-270),new BABYLON.Vector3(80,15,-250),new BABYLON.Vector3(85,45,-200),new BABYLON.Vector3(70,-20,-300),new BABYLON.Vector3(30,10,-320),new BABYLON.Vector3(75,0,-260),new BABYLON.Vector3(50,25,-250),new BABYLON.Vector3(90,-30,-220),new BABYLON.Vector3(-36,-26,-200),new BABYLON.Vector3(-13,27,-195),new BABYLON.Vector3(50,3,-170),new BABYLON.Vector3(48,-28,-200),new BABYLON.Vector3(50,20,-200),new BABYLON.Vector3(-10,-10,-170)];
	this.greetNames = ["greet_adapt.png","greet_api.png","greet_alumni.png","greet_asd.png","greet_cncd.png","greet_ananasmurska.png","greet_artline_designs.png","greet_fgj.png","greet_tahtituho.png","greet_hbc.png","greet_damones.png","greet_darklite.png","greet_dekadence.png","greet_ekspert.png","greet_epoch.png","greet_fairlight.png","greet_hedelmae.png","greet_jumalauta.png","greet_kewlers.png","greet_matt_current.png","greet_mercury.png","greet_mfx.png","greet_paraguay.png","greet_primitive.png","greet_npli.png","greet_traction.png","greet_quadtrip.png","greet_scenesat.png","greet_byterapers.png","greet_pyrotech.png","greet_xzm.png"];
	this.greetsActive = [];
	this.shake = 0;
	this.camdist = -900;
	wl_core_Part.call(this);
};
$hxClasses["posttest.PostTest"] = posttest_PostTest;
posttest_PostTest.__name__ = ["posttest","PostTest"];
posttest_PostTest.__super__ = wl_core_Part;
posttest_PostTest.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.targetNode = new BABYLON.TransformNode("target",this.scene);
		this.pl = new BABYLON.PointLight("pl",new BABYLON.Vector3(0,0,0),this.scene);
		this.pl.diffuse = DemoMain.WHITE;
		this.pl.intensity = 0.7;
		this.pl.range = 1550;
		this.camera.position = new BABYLON.Vector3(0,0,this.camdist);
		this.camera.fov = 0.6;
		this.sps = new posttest_CubeSPS(this.scene);
		this.greets = [];
		var p = [];
		p.push(new BABYLON.Vector3(0,0,0));
		p.push(new BABYLON.Vector3(0,0,0));
		var _g = 0;
		var _g1 = this.greetNames;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			var gsps = new posttest_GreetSPS(g,this.scene);
			this.greets.push(gsps);
			gsps.position = this.positions[this.greets.length - 1];
			gsps.lookAt(this.camera.position);
		}
		this.ship = new posttest_Ship("ship",this.scene);
		this.ship.position.z = -990;
		this.ship.position.x = 163;
		this.ship.position.y = 8;
		this.ship.lookAt(new BABYLON.Vector3(-100,60,50));
		this.columns = [];
		var rndC = new wl_util_Random(4564);
		var _g11 = 0;
		var _g2 = this.greetNames.length;
		while(_g11 < _g2) {
			var c = new posttest_Column(this.greetNames[_g11++] + "col",this.scene);
			this.scene.addTransformNode(c);
			c.position.z = -700;
			if(rndC.NextFloat() < 0.65) {
				c.position.x = -rndC.NextFloat() * 500;
			} else {
				var tmp = rndC.NextFloat() * 500;
				c.position.x = tmp + 500;
			}
			var tmp1 = rndC.NextFloat() - 0.5;
			c.position.y = tmp1 * 1000;
			c.scaling.y = 1;
			c.scaling.z = 0;
			c.scaling.x = 1;
			c.lookAt(new BABYLON.Vector3((rndC.NextFloat() - 0.5) * 50,(rndC.NextFloat() - 0.5) * 50,(rndC.NextFloat() - 0.5) * 50));
			this.columns.push(c);
		}
		p.push(new BABYLON.Vector3(-60,10,0));
		p.push(new BABYLON.Vector3(50,-10,0));
		p.push(new BABYLON.Vector3(-20,-20,0));
		p.push(new BABYLON.Vector3(10,10,0));
		p.push(new BABYLON.Vector3(0,0,0));
		this.targetCC = new wl_demo_CameraController(this.targetNode);
		this.targetCC.updateLook = false;
		this.targetCC.initBezier(p,p);
		this.targetNode.position.copyFrom(this.greets[0].position);
		this.setupPostprocessing();
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.addTrigger(new wl_core_TimeSig(-1,-1,0,0,wl_core_TimeSig.PATTERN),function(ts1) {
				if(ts1.beat % 2 == 0 && _gthis.greets.length > 0) {
					var g1 = _gthis.greets.shift();
					_gthis.greetsActive.push(g1);
					g1.animateIn(ts1,function(gg) {
						HxOverrides.remove(_gthis.greetsActive,gg);
					});
					var c1 = _gthis.columns[_gthis.greets.length];
					var dist = c1.position.length();
					createjs.Tween.get(c1.scaling).wait(wl_core_TimeSig.milliseconds(0,3,0,0)).to({ z : dist * 2},wl_core_TimeSig.milliseconds(0,1,7,0),createjs.Ease.quadIn).call(function() {
						_gthis.shake += 1.3;
					});
				}
			});
		});
		this.addTrigger(new wl_core_TimeSig(22,0,0,0,wl_core_TimeSig.RELATIVE),function(ts2) {
			createjs.Tween.removeTweens(_gthis);
			createjs.Tween.get(_gthis).to({ bloomMp : 100},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
			createjs.Tween.get(_gthis).wait(wl_core_TimeSig.milliseconds(1,3,0,0)).to({ exposureMp : 30},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadIn);
			createjs.Tween.get(_gthis).to({ camdist : -10},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
			createjs.Tween.get(_gthis.camera).to({ fov : 1.2},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
		});
		this.helpTN = new BABYLON.TransformNode("helpTN");
		this.initSoundAnalyzer();
		this.camera.position = new BABYLON.Vector3(-this.camdist * 0.2,Math.sin(this.camdist / 100) * 15,this.camdist);
		this.targetCC.update(0);
		this.camera.setTarget(this.targetNode.position);
	}
	,setupPostprocessing: function() {
		var plConf = { };
		plConf.dof = false;
		plConf.bloom = true;
		plConf.chromaticAberration = true;
		plConf.imageProcessing = true;
		plConf.grain = true;
		plConf.fxaa = true;
		plConf.sharpen = true;
		plConf.distort = true;
		this.initPipeline(plConf);
		this.post.chromaticAberration.aberrationAmount = 5;
		this.post.imageProcessing.exposure = 1;
		this.post.imageProcessing.toneMappingEnabled = true;
		this.post.imageProcessing.vignetteEnabled = true;
		this.post.imageProcessing.vignetteBlendMode = 1;
		this.post.grain.animated = true;
		this.post.grain.intensity = 15;
		this.post.bloom.bloomWeight = 0.8;
		this.post.bloom.bloomThreshold = 0.01;
		this.post.bloom.bloomKernel = 256;
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.startTime = ts.toMilliseconds();
		createjs.Tween.get(this).to({ camdist : -200},wl_core_TimeSig.milliseconds(24,0,0,0),createjs.Ease.linear);
		createjs.Tween.get(this).to({ exposureMp : 1},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadInOut);
		createjs.Tween.get(this.ship.position).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ x : -50, y : 30, z : 50},wl_core_TimeSig.milliseconds(8,0,0,0),createjs.Ease.linear);
		createjs.Tween.get(this.ship.scaling).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ x : 1, y : 1, z : 5},wl_core_TimeSig.milliseconds(6,0,0,0),createjs.Ease.quadIn);
		createjs.Tween.get(this.ship.rotation).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ z : 1.9},wl_core_TimeSig.milliseconds(6,0,0,0),createjs.Ease.linear);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.columns[0].update(ts);
		this.camera.position = new BABYLON.Vector3(-this.camdist * 0.2,Math.sin(this.camdist / 100) * 15,this.camdist);
		this.targetCC.update((ts.toMilliseconds() - wl_core_TimeSig.milliseconds(3,0,0,0) - this.startTime) / wl_core_TimeSig.milliseconds(22,2,0,0));
		this.camera.setTarget(this.targetNode.position);
		this.camera.position.x += (wl_util_Random.nextFloat() - 0.5) * this.shake;
		this.camera.position.y += (wl_util_Random.nextFloat() - 0.5) * this.shake;
		this.shake -= this.shake / (15 * delta);
		console.log(this.helpTN);
		this.camera.rotation = this.helpTN.rotation;
		this.targetNode.position.x += (this.greets.length > 0 ? this.greets[0].position.x - this.targetNode.position.x : 0 - this.targetNode.position.x) / 140;
		this.targetNode.position.y += (this.greets.length > 0 ? this.greets[0].position.y - this.targetNode.position.y : 0 - this.targetNode.position.y) / 140;
		this.targetNode.position.z += (this.greets.length > 0 ? this.greets[0].position.z - this.targetNode.position.z : 0 - this.targetNode.position.z) / 140;
		if(this.greetsActive.length > 0) {
			this.greetsActive[0].update();
		}
		if(this.greetsActive.length > 1) {
			this.greetsActive[1].update();
		}
		if(this.greetsActive.length > 2) {
			this.greetsActive[2].update();
		}
		if(this.greetsActive.length > 3) {
			this.greetsActive[3].update();
		}
		if(this.greetsActive.length > 4) {
			this.greetsActive[4].update();
		}
		if(this.greetsActive.length > 5) {
			this.greetsActive[5].update();
		}
		if(this.greetsActive.length == 0 && this.greets.length > 2) {
			this.greets[0].update();
			this.greets[1].update();
			this.greets[2].update();
		}
		var _g = 0;
		var _g1 = this.greets;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			g.lookAt(this.camera.position);
		}
		this.pl.position = this.camera.position;
		this.updateSoundFilter();
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,initSoundAnalyzer: function() {
		this.soundAnalyzer = new wl_sounds_SoundAnalyzer();
		this.lowFilter = { lowLimit : 50, highLimit : 250, isolate : true};
		this.midFilter = { lowLimit : 750, highLimit : 3500, isolate : true};
		this.highFilter = { lowLimit : 10000, highLimit : 20000, isolate : true};
		this.soundAnalyzer.historySize = 6;
		this.soundAnalyzer.filters.push(this.lowFilter);
		this.soundAnalyzer.filters.push(this.midFilter);
		this.soundAnalyzer.filters.push(this.highFilter);
	}
	,updateSoundFilter: function() {
		this.soundAnalyzer.update();
		this.post.bloom.bloomWeight = this.bloomMp * 0.6 * this.lowFilter.max * this.lowFilter.max * this.lowFilter.max;
		this.post.imageProcessing.vignetteWeight = this.lowFilter.max > 0.0 ? this.lowFilter.max * 5 + 1.5 : 0;
		this.post.imageProcessing.exposure = this.exposureMp;
		this.post.chromaticAberration.aberrationAmount = this.midFilter.max > 0.70 ? (this.midFilter.max - 0.70) / 0.3 * 8 + 2 : 2;
		this.post.grain.intensity = 15 + this.highFilter.max * 15;
		this.post.distort.intensity = this.highFilter.max > 0.6 ? (this.highFilter.max - 0.6) / 50 : 0;
	}
	,__class__: posttest_PostTest
});
var posttest_Ship = function(name,scene,glow) {
	if(glow == null) {
		glow = false;
	}
	BABYLON.TransformNode.call(this,name,scene);
	this.w1 = new washers_Tower("w1",50,null,glow);
	this.w2 = new washers_Tower("w2",50,null,glow);
	this.w3 = new washers_Tower("w3",50,null,glow);
	this.w1.rotation.x = -Math.PI / 2;
	this.w2.rotation.x = -Math.PI / 2;
	this.w3.rotation.x = -Math.PI / 2;
	this.w1.position.x = Math.sin(0) * 0.5;
	this.w1.position.y = Math.cos(0) * 0.5;
	this.w2.position.x = Math.sin(Math.PI * 2 / 3) * 0.5;
	this.w2.position.y = Math.cos(Math.PI * 2 / 3) * 0.5;
	this.w3.position.x = Math.sin(Math.PI * 2 / 3 * 2) * 0.5;
	this.w3.position.y = Math.cos(Math.PI * 2 / 3 * 2) * 0.5;
	this.scaling.x = this.scaling.y = this.scaling.z = 10;
	this.w1.parent = this;
	this.w2.parent = this;
	this.w3.parent = this;
};
$hxClasses["posttest.Ship"] = posttest_Ship;
posttest_Ship.__name__ = ["posttest","Ship"];
posttest_Ship.__super__ = BABYLON.TransformNode;
posttest_Ship.prototype = $extend(BABYLON.TransformNode.prototype,{
	__class__: posttest_Ship
});
var snaketunnel_Cluster = function() {
	this.started = false;
	this.towers = [];
	var _g1 = 0;
	while(_g1 < 12) {
		var i = _g1++;
		var t = new snaketunnel_Tower("",100);
		t.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		var angle = Math.PI * 2 * i / 12 + Math.PI;
		var tmp = Math.cos(angle);
		t.position.x = tmp * 13;
		var tmp1 = Math.sin(angle);
		t.position.y = tmp1 * 13;
		t.position.z = 270;
		t.angle = Math.PI * 2 * (12 - i) / 12;
		if(i == 0) {
			t.angle = 0;
		}
		this.towers.push(t);
	}
};
$hxClasses["snaketunnel.Cluster"] = snaketunnel_Cluster;
snaketunnel_Cluster.__name__ = ["snaketunnel","Cluster"];
snaketunnel_Cluster.prototype = {
	start: function(ts) {
		this.started = true;
		var _g = 0;
		var _g1 = this.towers;
		while(_g < _g1.length) {
			var t = _g1[_g];
			++_g;
			createjs.Tween.get(t).to({ progression : 1},wl_core_TimeSig.milliseconds(8,0,0,0));
			t.colorToHilight();
		}
	}
	,update: function(delta) {
		var _g = 0;
		var _g1 = this.towers;
		while(_g < _g1.length) {
			var t = _g1[_g];
			++_g;
			t.update(delta);
		}
	}
	,breakCaps: function(angle) {
		var _g = 0;
		var _g1 = this.towers;
		while(_g < _g1.length) {
			var t = _g1[_g];
			++_g;
			if(angle > t.angle) {
				t.removeCap();
			}
		}
	}
	,switchLights: function(on) {
		var _g = 0;
		var _g1 = this.towers;
		while(_g < _g1.length) {
			var t = _g1[_g];
			++_g;
			t.switchLight(on);
		}
	}
	,__class__: snaketunnel_Cluster
};
var snaketunnel_ExtraStuff = function() {
	BABYLON.TransformNode.call(this,"");
	var tubematerial = new BABYLON.StandardMaterial("",null);
	tubematerial.specularPower = 0;
	tubematerial.diffuseColor = new BABYLON.Color3(0,0,0);
	this.windowShader = new snaketunnel_TubeWindow(wl_core_Assets.getTexture("perlin-512.png"));
	this.windowShader.color = DemoMain.HILIGHT.toColor4();
	var glowmaterial = this.windowShader.material;
	this.meshes = [];
	this.instances = [];
	this.meshes.push(wl_util_ExtendedMeshBuilder.CreateWindowedTube(.4,8,2,tubematerial,glowmaterial));
	this.meshes.push(wl_util_ExtendedMeshBuilder.CreateWindowedTube(0.6,12,2,tubematerial,glowmaterial));
	this.meshes.push(wl_util_ExtendedMeshBuilder.CreateWindowedTube(0.8,20,2,tubematerial,glowmaterial));
	this.meshes.push(wl_util_ExtendedMeshBuilder.CreateWindowedTube(0.8,30,2,tubematerial,glowmaterial));
	this.meshes.push(wl_util_ExtendedMeshBuilder.CreateWindowedTube(0.4,40,2,tubematerial,glowmaterial));
	this.meshes.push(wl_util_ExtendedMeshBuilder.CreateWindowedTube(0.6,15,2,tubematerial,glowmaterial));
	this.meshes.push(wl_util_ExtendedMeshBuilder.CreateWindowedTube(0.6,20,2,tubematerial,glowmaterial));
	var _g = 0;
	var _g1 = this.meshes;
	while(_g < _g1.length) {
		var m = _g1[_g];
		++_g;
		m.receiveShadows = true;
	}
	var positions = [{ angle : Math.PI / 3, z : 2, typeIndex : 4},{ angle : 2 * Math.PI / 3, z : 10, typeIndex : 4},{ angle : 3 * Math.PI / 3, z : 4, typeIndex : 4},{ angle : 4 * Math.PI / 3, z : 3, typeIndex : 4},{ angle : 5 * Math.PI / 3, z : 1, typeIndex : 4},{ angle : 6.7 * Math.PI / 3, z : 8, typeIndex : 4},{ angle : 7 * Math.PI / 3, z : 5, typeIndex : 4},{ angle : Math.PI / 4, z : 75, typeIndex : 1},{ angle : Math.PI / 2.4, z : 70, typeIndex : 1},{ angle : Math.PI * 8 / 9, z : 65, typeIndex : 3},{ angle : Math.PI * 2 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 2 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 3 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 4 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 5 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 6 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 7 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 8 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 9 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 10 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 11 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * 2 * 12 / 12, z : 110, typeIndex : 3},{ angle : Math.PI * .5, z : 160, typeIndex : 2},{ angle : Math.PI * 0.7, z : 160, typeIndex : 1},{ angle : Math.PI * 2.9, z : 160, typeIndex : 3},{ angle : Math.PI * 2 / 16, z : 240, typeIndex : 5},{ angle : Math.PI * 2 * 1.4 / 16, z : 240, typeIndex : 6},{ angle : Math.PI * 2 * 3 / 16, z : 240, typeIndex : 5},{ angle : Math.PI * 2 * 3.4 / 16, z : 240, typeIndex : 6},{ angle : Math.PI * 2 * 5 / 16, z : 240, typeIndex : 5},{ angle : Math.PI * 2 * 5.4 / 16, z : 240, typeIndex : 6},{ angle : Math.PI * 2 * 6 / 16, z : 240, typeIndex : 5},{ angle : Math.PI * 2 * 6.4 / 16, z : 240, typeIndex : 6},{ angle : Math.PI * 2 * 9 / 16, z : 240, typeIndex : 5},{ angle : Math.PI * 2 * 9.4 / 16, z : 240, typeIndex : 6},{ angle : Math.PI * 2 * 11 / 16, z : 240, typeIndex : 5},{ angle : Math.PI * 2 * 11.4 / 16, z : 240, typeIndex : 6},{ angle : Math.PI * 2 * 13 / 16, z : 240, typeIndex : 5},{ angle : Math.PI * 2 * 13.4 / 16, z : 240, typeIndex : 6},{ angle : Math.PI * 2 * 15 / 16, z : 240, typeIndex : 5},{ angle : Math.PI * 2 * 15.4 / 16, z : 240, typeIndex : 6}];
	var _g11 = 0;
	var _g2 = positions.length;
	while(_g11 < _g2) {
		var p = positions[_g11++];
		var m1 = this.meshes[p.typeIndex];
		var inst = m1.createInstance("");
		m1.getChildren()[0].createInstance("").parent = inst;
		var angle = p.angle;
		inst.position.x = Math.cos(angle) * 15;
		inst.position.y = Math.sin(angle) * 15;
		inst.position.z = p.z;
		inst.rotate(BABYLON.Vector3.Forward(),Math.atan2(inst.position.y,inst.position.x) + Math.PI / 2);
		this.instances.push(inst);
	}
	var _g3 = 0;
	var _g12 = this.meshes;
	while(_g3 < _g12.length) {
		var m2 = _g12[_g3];
		++_g3;
		m2.position.y = -2000;
	}
};
$hxClasses["snaketunnel.ExtraStuff"] = snaketunnel_ExtraStuff;
snaketunnel_ExtraStuff.__name__ = ["snaketunnel","ExtraStuff"];
snaketunnel_ExtraStuff.__super__ = BABYLON.TransformNode;
snaketunnel_ExtraStuff.prototype = $extend(BABYLON.TransformNode.prototype,{
	update: function(ts) {
		this.windowShader.update(ts);
	}
	,__class__: snaketunnel_ExtraStuff
});
var snaketunnel_LoopCurve = function(mat,path,tubeDiameter,radius) {
	this.path = path;
	this.radius = radius;
	this.tubeDiameter = tubeDiameter;
	this.mesh = BABYLON.MeshBuilder.CreateTube("",{ radius : radius, path : this.path, updatable : true},null);
	this.mesh.material = mat;
};
$hxClasses["snaketunnel.LoopCurve"] = snaketunnel_LoopCurve;
snaketunnel_LoopCurve.__name__ = ["snaketunnel","LoopCurve"];
snaketunnel_LoopCurve.prototype = {
	updateAngle: function(startAngle,angle,radius,minZ,maxZ) {
		var length = this.path.length;
		var _g1 = 0;
		while(_g1 < length) {
			var i = _g1++;
			var vec = this.path[i];
			vec.x = Math.cos(startAngle + angle * i / (length - 1)) * radius;
			vec.y = Math.sin(startAngle + angle * i / (length - 1)) * radius;
			vec.z = minZ + i / length * (maxZ - minZ);
		}
		this.mesh = BABYLON.MeshBuilder.CreateTube(null,{ instance : this.mesh, path : this.path},null);
	}
	,__class__: snaketunnel_LoopCurve
};
var snaketunnel_Sequence = function() {
	this.trackAngle = false;
	this.started = false;
};
$hxClasses["snaketunnel.Sequence"] = snaketunnel_Sequence;
snaketunnel_Sequence.__name__ = ["snaketunnel","Sequence"];
snaketunnel_Sequence.prototype = {
	__class__: snaketunnel_Sequence
};
var snaketunnel_Snake = function(diameter) {
	this.sequences = [{ length : new wl_core_TimeSig(1,0,0,0), change : new BABYLON.Vector3(0,0,52)},{ length : new wl_core_TimeSig(0,1,0,0), change : new BABYLON.Vector3(-5,0,0)},{ length : new wl_core_TimeSig(1,0,0,0), angle : -Math.PI * 3 / 2, distance : 0},{ length : new wl_core_TimeSig(0,1,0,0), change : new BABYLON.Vector3(0,0,6)},{ length : new wl_core_TimeSig(1,1,0,0), angle : -Math.PI * 2, distance : 0},{ length : new wl_core_TimeSig(1,0,0,0), change : new BABYLON.Vector3(0,0,26)},{ length : new wl_core_TimeSig(2,0,0,0), angle : Math.PI * 2, distance : 16},{ length : new wl_core_TimeSig(1,0,0,0), change : new BABYLON.Vector3(0,0,48)},{ length : new wl_core_TimeSig(1,0,0,0), angle : Math.PI / 2, distance : 0},{ length : new wl_core_TimeSig(0,1,0,0), change : new BABYLON.Vector3(0,0,6)},{ length : new wl_core_TimeSig(0,3,0,0), angle : Math.PI, distance : 0},{ length : new wl_core_TimeSig(0,2,0,0), change : new BABYLON.Vector3(-2,0,40)},{ length : new wl_core_TimeSig(1,1,0,0), angle : Math.PI * 2, distance : 16},{ length : new wl_core_TimeSig(0,1,0,0), change : new BABYLON.Vector3(-1,0,6)},{ length : new wl_core_TimeSig(1,1,0,0), angle : -Math.PI, distance : 16},{ length : new wl_core_TimeSig(0,1,0,0), change : new BABYLON.Vector3(-2,0,10)},{ length : new wl_core_TimeSig(0,1,0,0), change : new BABYLON.Vector3(-4.5,-0.7,28)},{ length : new wl_core_TimeSig(2,0,0,0), angle : -Math.PI * 2, distance : 0, trackAngle : true}];
	this.trackedAngle = 0;
	this.ended = false;
	this.currentRadius = 0;
	this.changePosition = new BABYLON.Vector3(0,0,0);
	this.changeRadius = 0;
	this.changeAngle = 0;
	this.currentAngle = 0;
	this.currentDistance = 0;
	BABYLON.TransformNode.call(this,"snake");
	this.tubeDiameter = diameter;
	var diameter1 = this.tubeDiameter / 50;
	var snakeMat = new BABYLON.StandardMaterial("",null);
	snakeMat.emissiveColor = new BABYLON.Color3(1,1,1);
	this.populateCylinderPool(snakeMat,diameter1);
	this.populateLoopPool(snakeMat,diameter1);
	this.activeLoops = [];
	this.activeCylinders = [];
	this.currentRadius = 14;
	this.changeAngle = 0;
	this.changePosition = new BABYLON.Vector3(0,0,0);
	this.currentDistance = 0;
	this.headPosition = new BABYLON.Vector3(0,0,0);
};
$hxClasses["snaketunnel.Snake"] = snaketunnel_Snake;
snaketunnel_Snake.__name__ = ["snaketunnel","Snake"];
snaketunnel_Snake.__super__ = BABYLON.TransformNode;
snaketunnel_Snake.prototype = $extend(BABYLON.TransformNode.prototype,{
	start: function(ts) {
		this.startTime = ts;
		this.sequenceChangedAt = ts.toMilliseconds();
		this.nextSequenceTime = this.sequenceChangedAt;
	}
	,populateCylinderPool: function(mat,diameter) {
		var cylinder = BABYLON.MeshBuilder.CreateCylinder("",{ height : 1, diameter : diameter},null);
		cylinder.parent = this;
		cylinder.rotate(BABYLON.Vector3.Right(),-Math.PI / 2);
		cylinder.translate(new BABYLON.Vector3(0,1,0),0.5);
		cylinder = cylinder.bakeCurrentTransformIntoVertices();
		cylinder.material = mat;
		cylinder.position = new BABYLON.Vector3(15,0,0);
		this.cylinderPool = [];
		var _g = 0;
		while(_g < 50) {
			++_g;
			var instance = cylinder.createInstance("");
			instance.position = new BABYLON.Vector3(15,0,0);
			instance.parent = this;
			this.cylinderPool.push(instance);
		}
	}
	,populateLoopPool: function(mat,diameter) {
		this.loopPool = [];
		var _g = 0;
		while(_g < 50) {
			++_g;
			var path = [];
			var _g1 = 0;
			while(_g1 < 30) {
				++_g1;
				path.push(new BABYLON.Vector3(0,0,0));
			}
			var loop = new snaketunnel_LoopCurve(mat,path,this.tubeDiameter,diameter / 2);
			loop.mesh.parent = this;
			this.loopPool.push(loop);
		}
	}
	,update: function(ts,delta) {
		this.headPosition.x = Math.cos(this.currentAngle) * this.currentRadius;
		this.headPosition.y = Math.sin(this.currentAngle) * this.currentRadius;
		this.headPosition.z = this.currentDistance;
		var filteredSequences = this.sequences.filter(function(s) {
			return !s.started;
		});
		if(filteredSequences.length > 0) {
			var nextSequence = filteredSequences[0];
			if(ts.isInsideFloat(this.nextSequenceTime,this.nextSequenceTime + nextSequence.length.toMilliseconds())) {
				if(this.activeSequence != null) {
					if(this.activeSequence.angle != null) {
						this.activeLoop.updateAngle(this.changeAngle,this.activeSequence.angle,this.currentRadius,this.changeDistance,this.changeDistance + this.activeSequence.distance);
						this.currentDistance = this.changeDistance + this.activeSequence.distance;
						this.changeAngle += this.activeSequence.angle;
					}
					if(this.activeSequence.change != null) {
						this.activeCylinder.scaling.z = BABYLON.Vector3.Distance(this.activeCylinder.position,this.target);
						this.currentDistance = this.target.z;
						this.changeAngle = Math.atan2(this.target.y,this.target.x);
					}
					this.sequenceChangedAt += this.activeSequence.length.toMilliseconds();
				}
				this.nextSequenceTime = this.sequenceChangedAt + nextSequence.length.toMilliseconds();
				this.activeSequence = nextSequence;
				this.trackedAngle = 0;
				if(this.activeLoop != null) {
					this.activeLoop = null;
				}
				if(this.activeCylinder != null) {
					this.activeCylinder = null;
				}
				if(this.activeSequence.change != null) {
					this.activeCylinder = this.cylinderPool.pop();
					this.activeCylinder.position.x = Math.cos(this.changeAngle) * this.currentRadius;
					this.activeCylinder.position.y = Math.sin(this.changeAngle) * this.currentRadius;
					this.activeCylinder.position.z = this.currentDistance;
					this.target = this.activeCylinder.position.add(this.activeSequence.change);
					this.activeCylinder.lookAt(this.target);
				} else {
					this.activeLoop = this.loopPool.pop();
				}
				this.activeSequence.started = true;
				this.changeRadius = this.currentRadius;
				this.changeDistance = this.currentDistance;
				this.changePosition.x = Math.cos(this.changeAngle) * this.changeRadius;
				this.changePosition.y = Math.sin(this.changeAngle) * this.changeRadius;
				this.changePosition.z = this.currentDistance;
			}
		}
		if(filteredSequences.length == 0 && !ts.isInsideFloat(this.sequenceChangedAt,this.sequenceChangedAt + this.activeSequence.length.toMilliseconds())) {
			this.ended = true;
			return;
		}
		if(this.activeSequence == null) {
			return;
		}
		var end = this.sequenceChangedAt + this.activeSequence.length.toMilliseconds();
		var partial = 1 - (end - ts.toMilliseconds()) / (end - this.sequenceChangedAt);
		if(this.activeCylinder != null) {
			var tmp = BABYLON.Vector3.Distance(this.activeCylinder.position,this.target);
			this.activeCylinder.scaling.z = tmp * partial;
			this.currentDistance = this.changeDistance + (this.target.z - this.changeDistance) * partial;
			var partialpos = this.activeCylinder.position.add(this.target.subtract(this.activeCylinder.position).scale(partial));
			this.currentRadius = BABYLON.Vector2.Distance(BABYLON.Vector2.Zero(),partialpos);
			this.currentAngle = Math.atan2(partialpos.y,partialpos.x);
		}
		if(this.activeLoop != null) {
			this.activeLoop.updateAngle(this.changeAngle,this.activeSequence.angle * partial,this.currentRadius,this.changeDistance,this.changeDistance + this.activeSequence.distance * partial);
			this.currentDistance = this.changeDistance + partial * this.activeSequence.distance;
			this.currentAngle = this.changeAngle + this.activeSequence.angle * partial;
		}
		if(this.activeSequence.trackAngle) {
			this.trackedAngle = this.activeSequence.angle * partial;
		}
	}
	,hasReachedEnd: function() {
		return this.ended;
	}
	,__class__: snaketunnel_Snake
});
var snaketunnel_SnakeTunnel = function() {
	this.darkens = 0;
	this.activeGreets = [];
	this.firstTimeDone = false;
	this.endcamlook = [new BABYLON.Vector3(-1.01,4.01,94),new BABYLON.Vector3(-1.27,-4,218),new BABYLON.Vector3(0.0267,3.83,220),new BABYLON.Vector3(-7.43587334936,-1.260795902,440.37935031)];
	this.endcampos = [new BABYLON.Vector3(-2.71,4.11,105),new BABYLON.Vector3(-1.38,-2.6,227.13),new BABYLON.Vector3(-6.13,2.97,228.83),new BABYLON.Vector3(-23.6638709225,0.889741685,461.1056470)];
	wl_core_Part.call(this);
};
$hxClasses["snaketunnel.SnakeTunnel"] = snaketunnel_SnakeTunnel;
snaketunnel_SnakeTunnel.__name__ = ["snaketunnel","SnakeTunnel"];
snaketunnel_SnakeTunnel.__super__ = wl_core_Part;
snaketunnel_SnakeTunnel.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		var diameter = 30;
		var tube = wl_util_ExtendedMeshBuilder.CreateTrashTube("sphere1",{ height : 400, diameter : diameter, wallThickness : 1},this.scene);
		tube.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
		tube.position.z = 0;
		tube.receiveShadows = true;
		var tubemat = new BABYLON.StandardMaterial("",null);
		tubemat.maxSimultaneousLights = 5;
		tubemat.specularColor = DemoMain.BLUE_DARK.clone().scale(0.5);
		tubemat.specularPower = 0;
		tube.material = tubemat;
		var bridgeMat = new BABYLON.StandardMaterial("",this.scene);
		bridgeMat.specularPower = 1.0;
		var bumpTex = wl_core_Assets.getTexture("Metal_weaved_normal.png");
		var diffTex = wl_core_Assets.getTexture("Metal_weaved.jpg");
		bumpTex.level = 2;
		diffTex.uScale = bumpTex.uScale = 20;
		diffTex.vScale = bumpTex.vScale = 20;
		diffTex.wrapU = bumpTex.wrapU = 30;
		diffTex.wrapV = bumpTex.wrapV = 30;
		bridgeMat.diffuseTexture = diffTex;
		bridgeMat.bumpTexture = bumpTex;
		bridgeMat.alpha = 1;
		bridgeMat.diffuseColor = BABYLON.Color3.Black();
		var bridgepieces = [];
		var grateBridge = wl_util_ExtendedMeshBuilder.CreateGrate("",{ width : 12.5, depth : 40, height : 0.3, gridSize : 2, gridSpacing : 0.5},this.scene);
		grateBridge.material = bridgeMat;
		bridgepieces.push(grateBridge);
		var _g = 0;
		while(_g < 5) {
			var i = _g++;
			var instance = grateBridge.createInstance("");
			instance.position.z = 40 + i * 40;
			instance.rotate(BABYLON.Vector3.Forward(),Math.PI / 20 - Math.PI / 10 * wl_util_Random.nextFloat());
			bridgepieces.push(instance);
		}
		this.scene.fogMode = BABYLON.Scene.FOGMODE_EXP2;
		this.scene.fogEnabled = true;
		this.scene.fogDensity = 0.01;
		this.scene.fogColor = new BABYLON.Color3(0,0,0);
		var skybox = BABYLON.MeshBuilder.CreateBox("skyBox",{ size : 8000},this.scene);
		var skyboxMaterial = new BABYLON.StandardMaterial("smat",this.scene);
		skyboxMaterial.backFaceCulling = false;
		skyboxMaterial.diffuseColor = new BABYLON.Color3(0,0,0);
		skyboxMaterial.specularColor = new BABYLON.Color3(0,0,0);
		skyboxMaterial.disableLighting = true;
		skybox.material = skyboxMaterial;
		this.snake = new snaketunnel_Snake(diameter);
		this.camera.position.z = -30;
		this.camera.position.y = 5;
		this.camera.setTarget(BABYLON.Vector3.Zero());
		var gl = new BABYLON.GlowLayer("glow",this.scene);
		gl.intensity = 0.7;
		this.snakeHeadLight = new BABYLON.PointLight("",BABYLON.Vector3.Zero(),this.scene);
		this.snakeHeadLight.intensity = 0.3;
		this.snakeHeadLight.shadowMinZ = 1;
		this.snakeHeadLight.shadowMaxZ = 200;
		this.snakeHeadLight.shadowEnabled = true;
		this.snakeHeadLightShadowGenerator = new BABYLON.ShadowGenerator(1024,this.snakeHeadLight);
		this.snakeHeadLightShadowGenerator.forceBackFacesOnly = true;
		this.snakeHeadLightShadowGenerator.useCloseExponentialShadowMap = true;
		this.snakeHeadLightShadowGenerator.getShadowMap().renderList.push(tube);
		this.snakeHeadLightShadowGenerator.setDarkness(0.05);
		var _g1 = 0;
		while(_g1 < bridgepieces.length) {
			var bridgepiece = bridgepieces[_g1];
			++_g1;
			this.snakeHeadLightShadowGenerator.getShadowMap().renderList.push(bridgepiece);
		}
		this.cluster = new snaketunnel_Cluster();
		this.extraStuff = new snaketunnel_ExtraStuff();
		this.emitter = BABYLON.MeshBuilder.CreateBox("",{ size : 1},null);
		this.emitter.position.z = -20;
		this.tubeParticles = new BABYLON.GPUParticleSystem("",{ capacity : 50000},this.scene);
		this.tubeParticles.particleEmitterType = new BABYLON.SphereParticleEmitter(3);
		this.tubeParticles.particleTexture = wl_core_Assets.getTexture("particleTexture.png");
		this.tubeParticles.color1 = DemoMain.HILIGHT.toColor4(0.5);
		this.tubeParticles.color2 = DemoMain.HILIGHT.toColor4(0.5);
		this.tubeParticles.maxLifeTime = 10;
		this.tubeParticles.minSize = .01;
		this.tubeParticles.maxSize = .4;
		this.tubeParticles.maxEmitPower = 2;
		this.tubeParticles.emitter = this.emitter;
		this.tubeParticles.emitRate = 300;
		this.tubeParticles.gravity = new BABYLON.Vector3(0,0,15);
		this.tubeParticles.preWarmCycles = 100;
		this.tubeParticles.preWarmStepOffset = 5;
		this.tubeParticles.start();
		this.initBoard();
		this.addTrigger(new wl_core_TimeSig(15,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			createjs.Tween.get(_gthis.camera).to({ fov : 1.3},wl_core_TimeSig.milliseconds(9,0,0,0),createjs.Ease.quadInOut);
		});
		this.setupPostprocessing();
		this.initSoundFilter();
		this.endCylinder = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : 1, height : 1},this.scene);
		this.endCylinder.rotate(BABYLON.Vector3.Right(),-Math.PI / 2);
		this.endCylinder = this.endCylinder.bakeCurrentTransformIntoVertices();
		this.endCylinder.setPivotPoint(new BABYLON.Vector3(0.5,0,0.5));
		this.endCylinder.isVisible = false;
		this.endCylinder.position.z = 200;
		this.endCylinder.scaling.x = this.endCylinder.scaling.y = 2;
		this.endCylinder.rotation.z = Math.PI;
		this.endCylinder.rotation.x = Math.PI;
		this.endCylinder.scaling.z = 200;
		var sm = new BABYLON.StandardMaterial("",this.scene);
		sm.emissiveColor = DemoMain.WHITE;
		this.endCylinder.material = sm;
		var standmat = new BABYLON.BackgroundMaterial("",null);
		standmat.primaryColor = new BABYLON.Color3(1,1,1);
		this.codeByExca = new posttest_GreetSPS("exca.png",this.scene,standmat);
		this.codeExca = new posttest_GreetSPS("code.png",this.scene,standmat);
		this.codeByPoro = new posttest_GreetSPS("poro.png",this.scene,standmat);
		this.codePoro = new posttest_GreetSPS("code.png",this.scene,standmat);
		this.musicByEclipser = new posttest_GreetSPS("eclipser.png",this.scene,standmat);
		this.musicEclipser = new posttest_GreetSPS("music.png",this.scene,standmat);
		this.codeByExca.scaling.scaleInPlace(0.2);
		this.codeExca.scaling.scaleInPlace(0.2);
		this.codeByPoro.scaling.scaleInPlace(0.2);
		this.codePoro.scaling.scaleInPlace(0.2);
		this.musicByEclipser.scaling.scaleInPlace(0.2);
		this.musicEclipser.scaling.scaleInPlace(0.2);
		this.post.imageProcessing.exposure = 0;
	}
	,stop: function() {
		if(this.firstTimeDone) {
			this.post.distort.brightness = 1;
			this.post.imageProcessing.exposure = 0;
		} else {
			this.post.imageProcessing.exposure = 0;
		}
		this.firstTimeDone = true;
		this.post.distort.brightness = 0;
		createjs.Tween.removeTweens(this.post.distort);
		createjs.Tween.removeTweens(this.post.imageProcessing);
		createjs.Tween.removeTweens(this.post.bloom);
		this.post.bloom.bloomWeight = 0.15;
		wl_core_Part.prototype.stop.call(this);
	}
	,initBoard: function() {
		var _gthis = this;
		this.board = new wl_demo_SceneBoard();
		var firstController = new wl_demo_CameraController(this.camera);
		firstController.initLinear([new BABYLON.Vector3(0,5,-15),new BABYLON.Vector3(3,5,29)],[new BABYLON.Vector3(0,3,28),new BABYLON.Vector3(0,5,49)]);
		new wl_demo_CameraController(this.camera).initLinear([new BABYLON.Vector3(0,2,28),new BABYLON.Vector3(0,5,29)],[new BABYLON.Vector3(0,2,48),new BABYLON.Vector3(0,5,59)]);
		var thirdController = new wl_demo_CameraController(this.camera);
		thirdController.initLinear([new BABYLON.Vector3(14,-0.2,58),new BABYLON.Vector3(5,3,74)],[new BABYLON.Vector3(-4,8,76),new BABYLON.Vector3(-10,0.1,116)]);
		var controller4 = new wl_demo_CameraController(this.camera);
		controller4.initLinear([new BABYLON.Vector3(-11.68,-3.725,103),new BABYLON.Vector3(-4.4,5.32,120)],[new BABYLON.Vector3(-3.7,-1.5,128),new BABYLON.Vector3(-2.29,1.00,168)]);
		var controller5 = new wl_demo_CameraController(this.camera);
		controller5.initLinear([new BABYLON.Vector3(8.6,-3.05,175),new BABYLON.Vector3(13,3.2,203.9)],[new BABYLON.Vector3(1.2,-3.2,139),new BABYLON.Vector3(-2.9,4.64,177)]);
		new wl_demo_CameraController(this.camera).initLinear([new BABYLON.Vector3(0.96,-0.05,152),new BABYLON.Vector3(6.28,3.4,214)],[new BABYLON.Vector3(1.27,4.05,187),new BABYLON.Vector3(-1.12,2.8,300)]);
		var controller7 = new wl_demo_CameraController(this.camera);
		controller7.initLinear([new BABYLON.Vector3(11.86,-6.007,220),new BABYLON.Vector3(4.47,9.41,225),new BABYLON.Vector3(0.42,7.7,225)],[new BABYLON.Vector3(-1.86,7.31,255),new BABYLON.Vector3(-0.38,2.23,253.8),new BABYLON.Vector3(-0.35,2.08,254)]);
		var controller8 = new wl_demo_CameraController(this.camera);
		controller8.initLinear([new BABYLON.Vector3(-1.42,-4.7,235),new BABYLON.Vector3(0,3.0,285)],[new BABYLON.Vector3(-1.42,0.08,300),new BABYLON.Vector3(0,0,300)]);
		this.board.add(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(5,0,0,0,wl_core_TimeSig.RELATIVE),firstController);
		this.board.add(new wl_core_TimeSig(5,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),thirdController);
		this.board.add(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(10,0,0,0,wl_core_TimeSig.RELATIVE),controller4);
		this.board.add(new wl_core_TimeSig(10,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(12,0,0,0,wl_core_TimeSig.RELATIVE),controller5);
		this.board.add(new wl_core_TimeSig(12,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(15,0,0,0,wl_core_TimeSig.RELATIVE),controller7);
		this.board.add(new wl_core_TimeSig(15,0,0,0,wl_core_TimeSig.RELATIVE),new wl_core_TimeSig(24,0,0,0,wl_core_TimeSig.RELATIVE),controller8);
		this.addTrigger(new wl_core_TimeSig(46,3,0,0,wl_core_TimeSig.ABSOLUTE),function(ts) {
			_gthis.endCylinder.isVisible = true;
			_gthis.endCylinder.scaling.z = 1;
			createjs.Tween.get(_gthis.endCylinder.scaling).to({ z : 500},wl_core_TimeSig.milliseconds(7,0,0,0),createjs.Ease.quadOut);
		});
		this.addTrigger(new wl_core_TimeSig(47,0,0,0,wl_core_TimeSig.ABSOLUTE),function(ts1) {
			createjs.Tween.get(_gthis.post.distort).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ brightness : 1},wl_core_TimeSig.milliseconds(0,1,11,0),createjs.Ease.quadIn);
			createjs.Tween.get(_gthis.post.imageProcessing).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ exposure : 3},wl_core_TimeSig.milliseconds(0,2,0,0));
			createjs.Tween.get(_gthis.post.bloom).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ bloomWeight : 3},wl_core_TimeSig.milliseconds(0,2,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(72,0,0,0,wl_core_TimeSig.ABSOLUTE),function(ts2) {
			console.log("First credits");
			_gthis.camera.position = _gthis.endcampos[0];
			_gthis.camera.setTarget(_gthis.endcamlook[0]);
			_gthis.codePoro.position = _gthis.endcamlook[0].add(new BABYLON.Vector3(-3,-2,0));
			_gthis.codeByPoro.position = _gthis.endcamlook[0].add(new BABYLON.Vector3(2,1,0));
			_gthis.codeByPoro.lookAt(_gthis.camera.position);
			_gthis.codePoro.lookAt(_gthis.camera.position);
			_gthis.activeGreets.push(_gthis.codePoro);
			_gthis.activeGreets.push(_gthis.codeByPoro);
			_gthis.codePoro.animateIn(ts2,function(g) {
				HxOverrides.remove(_gthis.activeGreets,g);
			});
			_gthis.codeByPoro.animateIn(ts2,function(g1) {
				HxOverrides.remove(_gthis.activeGreets,g1);
			});
		});
		this.addTrigger(new wl_core_TimeSig(74,0,0,0,wl_core_TimeSig.ABSOLUTE),function(ts3) {
			console.log("second credits");
			_gthis.camera.position = _gthis.endcampos[1];
			_gthis.camera.setTarget(_gthis.endcamlook[1]);
			_gthis.musicEclipser.position = _gthis.endcamlook[1].add(new BABYLON.Vector3(-3,0.6,0));
			_gthis.musicByEclipser.position = _gthis.endcamlook[1].add(new BABYLON.Vector3(-2,-4,0));
			_gthis.musicEclipser.lookAt(_gthis.camera.position);
			_gthis.musicByEclipser.lookAt(_gthis.camera.position);
			_gthis.activeGreets.push(_gthis.musicEclipser);
			_gthis.activeGreets.push(_gthis.musicByEclipser);
			_gthis.musicEclipser.animateIn(ts3,function(g2) {
				HxOverrides.remove(_gthis.activeGreets,g2);
			});
			_gthis.musicByEclipser.animateIn(ts3,function(g3) {
				HxOverrides.remove(_gthis.activeGreets,g3);
			});
		});
		this.addTrigger(new wl_core_TimeSig(76,0,0,0,wl_core_TimeSig.ABSOLUTE),function(ts4) {
			console.log("fourth credits");
			_gthis.camera.position = _gthis.endcampos[2];
			_gthis.camera.setTarget(_gthis.endcamlook[2]);
			_gthis.codeExca.position = _gthis.endcamlook[2].add(new BABYLON.Vector3(-3,2.9,0));
			_gthis.codeByExca.position = _gthis.endcamlook[2].add(new BABYLON.Vector3(1,-0.7,0));
			_gthis.codeByExca.lookAt(_gthis.camera.position);
			_gthis.codeExca.lookAt(_gthis.camera.position);
			_gthis.activeGreets.push(_gthis.codeExca);
			_gthis.activeGreets.push(_gthis.codeByExca);
			_gthis.codeExca.animateIn(ts4,function(g4) {
				HxOverrides.remove(_gthis.activeGreets,g4);
			});
			_gthis.codeByExca.animateIn(ts4,function(g5) {
				HxOverrides.remove(_gthis.activeGreets,g5);
			});
		});
		this.addTrigger(new wl_core_TimeSig(78,0,0,0,wl_core_TimeSig.ABSOLUTE),function(ts5) {
			_gthis.cluster.switchLights(true);
			console.log("fifth credits");
			_gthis.camera.position = _gthis.endcampos[3];
			_gthis.camera.setTarget(_gthis.endcamlook[3]);
			createjs.Tween.get(_gthis.post.imageProcessing).wait(wl_core_TimeSig.milliseconds(1,0,0,0)).to({ exposure : 0},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadIn);
		});
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.snake.start(ts);
		this.board.start(ts);
		createjs.Tween.get(this.post.imageProcessing).to({ exposure : 1},wl_core_TimeSig.milliseconds(0,3,0,0),createjs.Ease.quadInOut);
		createjs.Tween.get(this.post.distort).to({ brightness : 0},wl_core_TimeSig.milliseconds(0,1,0,0),createjs.Ease.quadOut);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var _g = 0;
		var _g1 = this.activeGreets;
		while(_g < _g1.length) {
			var g = _g1[_g];
			++_g;
			g.update();
		}
		this.cluster.update(delta);
		this.extraStuff.update(ts);
		if(!this.firstTimeDone) {
			this.board.update(ts,partial,frameTime,delta);
			this.snake.update(ts,delta);
			if(this.snake.hasReachedEnd() && !this.cluster.started) {
				this.cluster.start(ts);
				this.emitter.position.z = 400;
				this.tubeParticles.gravity = new BABYLON.Vector3(0,0,0);
				this.tubeParticles.emitRate = 5000;
				this.tubeParticles.maxEmitPower = 1;
			}
			this.cluster.breakCaps(-this.snake.trackedAngle);
			this.snakeHeadLight.position = this.snake.headPosition;
		} else if(ts.bar < 74) {
			this.camera.position.x += delta * 0.001;
			this.camera.position.y += delta * 0.0007;
			this.camera.position.z += delta * 0.0008;
		} else if(ts.bar < 76) {
			this.camera.position.x += delta * 0.0002;
			this.camera.position.z -= delta * 0.0007;
			this.camera.position.y += delta * 0.0005;
		} else if(ts.bar < 78) {
			this.camera.position.x -= delta * 0.001;
			this.camera.position.y += delta * 0.001;
			this.camera.position.z += delta * 0.002;
		} else if(ts.bar < 80) {
			this.camera.position.x += delta * 0.0011;
			this.camera.position.y += delta * 0.005;
			this.camera.position.z -= delta * 0.01;
		}
		this.updateSoundFilter();
	}
	,render: function(ts,frameTime,toScreen) {
		wl_core_Part.prototype.render.call(this,ts,frameTime,toScreen);
	}
	,initSoundFilter: function() {
		this.soundAnalyzer = new wl_sounds_SoundAnalyzer();
		this.lowFilter = { lowLimit : 50, highLimit : 250, isolate : true};
		this.midFilter = { lowLimit : 750, highLimit : 3500, isolate : true};
		this.highFilter = { lowLimit : 10000, highLimit : 20000, isolate : true};
		this.soundAnalyzer.historySize = 6;
		this.soundAnalyzer.filters.push(this.lowFilter);
		this.soundAnalyzer.filters.push(this.midFilter);
		this.soundAnalyzer.filters.push(this.highFilter);
	}
	,updateSoundFilter: function() {
		this.soundAnalyzer.update();
		this.post.chromaticAberration.aberrationAmount = this.midFilter.max > 0.75 ? (this.midFilter.max - 0.75) * 50 : 0;
		this.post.grain.intensity = 15 + this.highFilter.max * 15;
	}
	,setupPostprocessing: function() {
		var plConf = { };
		plConf.dof = true;
		plConf.bloom = true;
		plConf.chromaticAberration = true;
		plConf.imageProcessing = true;
		plConf.grain = true;
		plConf.fxaa = true;
		plConf.sharpen = true;
		plConf.distort = true;
		this.initPipeline(plConf);
		this.post.dof.focalLength = 36;
		this.post.dof.focusDistance = 2300;
		this.post.dof.fStop = 1.5;
		this.post.dof.lensSize = 67;
		this.post.chromaticAberration.aberrationAmount = 5;
		this.post.imageProcessing.exposure = 2;
		this.post.imageProcessing.toneMappingEnabled = false;
		this.post.imageProcessing.vignetteEnabled = false;
		this.post.grain.animated = true;
		this.post.grain.intensity = 15;
	}
	,__class__: snaketunnel_SnakeTunnel
});
var snaketunnel_Tower = function(name,stacks,rotSpeed) {
	if(rotSpeed == null) {
		rotSpeed = 0.01;
	}
	this.progression = 0;
	BABYLON.TransformNode.call(this,name);
	this.rotationspeed = rotSpeed;
	if(snaketunnel_Tower.mesh == null) {
		snaketunnel_Tower.mesh = this.CreateSlice();
		snaketunnel_Tower.mesh.position.y = 3000;
	}
	snaketunnel_Tower.instances = [];
	var finalMesh = null;
	if(snaketunnel_Tower.originalFinalMesh == null) {
		var _g1 = 0;
		while(_g1 < stacks) {
			var instance = snaketunnel_Tower.mesh.clone("instance",this);
			instance.position.y = _g1++ * snaketunnel_Tower.SLICEHEIGHT;
			instance.rotate(BABYLON.Vector3.Up(),Math.PI * 2 * wl_util_Random.nextFloat());
			instance.setParent(this);
			snaketunnel_Tower.instances.push(instance);
		}
		finalMesh = BABYLON.Mesh.MergeMeshes(snaketunnel_Tower.instances,true);
		finalMesh.parent = this;
		var mat = new BABYLON.StandardMaterial("",null);
		mat.diffuseColor = DemoMain.GROUND;
		finalMesh.material = mat;
	} else {
		finalMesh = snaketunnel_Tower.originalFinalMesh.createInstance("");
		finalMesh.setParent(this);
	}
	this.height = snaketunnel_Tower.SLICEHEIGHT * stacks;
	this.innerCylinder = BABYLON.MeshBuilder.CreateCylinder("incyl",{ height : this.height, diameter : snaketunnel_Tower.DIAMETER - 0.4, tessellation : 20},null);
	this.innerCylinder.translate(BABYLON.Vector3.Up(),this.height / 2);
	this.innerCylinder = this.innerCylinder.bakeCurrentTransformIntoVertices();
	this.innerCylinder.position.y = 0;
	this.innerCylinder.setParent(this);
	this.innermaterial = new BABYLON.StandardMaterial("incylmat",null);
	this.innermaterial.emissiveColor = new BABYLON.Color3(1,1,1);
	this.innerCylinder.material = this.innermaterial;
	this.bottomcylinder = BABYLON.MeshBuilder.CreateCylinder("cyl",{ height : snaketunnel_Tower.SLICEHEIGHT, diameter : snaketunnel_Tower.DIAMETER, tessellation : 20},null);
	this.bottomcylinder.parent = this;
	var topcylinder = this.bottomcylinder.clone("topcyl",this);
	topcylinder.parent = this;
	topcylinder.position.y = this.height;
	if(snaketunnel_Tower.generatedLights % 3 == 0) {
		this.innerlight = new BABYLON.PointLight("dirlit",BABYLON.Vector3.Zero(),null);
		this.innerlight.position.y = this.height / 2;
		this.innerlight.position.x = 0;
		this.innerlight.parent = this;
		this.innerlight.range = 40;
		this.innerlight.radius = 0.1;
		this.innerlight.shadowMinZ = 0.1;
		this.innerlight.shadowMaxZ = 40;
		this.innerlight.intensity = 0;
		var shadowGenerator = new BABYLON.ShadowGenerator(256,this.innerlight);
		shadowGenerator.getShadowMap().renderList.push(finalMesh);
		shadowGenerator.forceBackFacesOnly = false;
		shadowGenerator.setDarkness(0.0);
		shadowGenerator.usePercentageCloserFiltering = true;
		shadowGenerator.getShadowMap().renderList.push(this.bottomcylinder);
		shadowGenerator.getShadowMap().renderList.push(topcylinder);
	}
	snaketunnel_Tower.generatedLights++;
};
$hxClasses["snaketunnel.Tower"] = snaketunnel_Tower;
snaketunnel_Tower.__name__ = ["snaketunnel","Tower"];
snaketunnel_Tower.__super__ = BABYLON.TransformNode;
snaketunnel_Tower.prototype = $extend(BABYLON.TransformNode.prototype,{
	CreateSlice: function() {
		var cylinder = BABYLON.MeshBuilder.CreateCylinder("cyl",{ height : snaketunnel_Tower.SLICEHEIGHT, diameter : snaketunnel_Tower.DIAMETER, tessellation : 20},null);
		var innerCylinder = BABYLON.MeshBuilder.CreateCylinder("cyl2",{ height : 2 * snaketunnel_Tower.SLICEHEIGHT, diameter : snaketunnel_Tower.DIAMETER - 1},null);
		var box = BABYLON.MeshBuilder.CreateBox("box",{ height : 2 * snaketunnel_Tower.SLICEHEIGHT, width : snaketunnel_Tower.DIAMETER - 0.2, depth : snaketunnel_Tower.DIAMETER / 2 + 0.2},null);
		box.position.x = -0.5;
		box.rotate(BABYLON.Vector3.Up(),Math.PI / 2);
		var csgcyl = BABYLON.CSG.FromMesh(cylinder);
		csgcyl.subtractInPlace(BABYLON.CSG.FromMesh(innerCylinder));
		csgcyl.subtractInPlace(BABYLON.CSG.FromMesh(box));
		var hollow = csgcyl.buildMeshGeometry("hollow",null,false);
		cylinder.isVisible = false;
		innerCylinder.isVisible = false;
		box.isVisible = false;
		cylinder.dispose();
		innerCylinder.dispose();
		box.dispose();
		return hollow;
	}
	,update: function(delta) {
		this.rotate(BABYLON.Vector3.Up(),this.rotationspeed * delta);
		this.innerCylinder.scaling.y = this.progression;
		if(this.innerlight != null) {
			this.innerlight.position.y = this.progression * this.height;
		}
	}
	,removeCap: function() {
		this.bottomcylinder.isVisible = false;
		if(this.innerlight != null) {
			createjs.Tween.get(this.innerlight).to({ intensity : 1.0},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
		}
	}
	,colorToHilight: function() {
		console.log("color hilight");
		var c = DemoMain.HILIGHT;
		if(this.innerlight != null) {
			createjs.Tween.get(this.innerlight.diffuse).to({ r : c.r, g : c.g, b : c.b},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadIn);
		}
		createjs.Tween.get(this.innermaterial.emissiveColor).to({ r : c.r, g : c.g, b : c.b},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadIn);
	}
	,switchLight: function(on) {
		if(this.innerlight == null) {
			return;
		}
		this.innerlight.setEnabled(on);
	}
	,__class__: snaketunnel_Tower
});
var wl_core_ShaderBase = function() {
	this.staticDone = false;
	this._defaultUniforms = ["world","viewProjection"];
	console.log("init simple shader: " + Std.string(this.staticDone));
	if(!this.staticDone) {
		console.log("init simple shader");
		BABYLON.Effect.ShadersStore["simpleVertexShader"] = haxe_Resource.getString("simple.vert");
		this.staticDone = true;
	}
};
$hxClasses["wl.core.ShaderBase"] = wl_core_ShaderBase;
wl_core_ShaderBase.__name__ = ["wl","core","ShaderBase"];
wl_core_ShaderBase.prototype = {
	UseDefaultUniforms: function(customUniforms) {
		return this._defaultUniforms.concat(customUniforms);
	}
	,__class__: wl_core_ShaderBase
};
var snaketunnel_TubeWindow = function(tDiffuse) {
	this.uniforms = ["tDiffuse","time","color","texScale"];
	this.color = new BABYLON.Color4(1,1,1,1);
	wl_core_ShaderBase.call(this);
	BABYLON.Effect.ShadersStore["tubewindowFragmentShader"] = haxe_Resource.getString("tubewindow.frag");
	BABYLON.Effect.ShadersStore["tubewindowVertexShader"] = haxe_Resource.getString("tubewindow.vert");
	var tmp = this.UseDefaultUniforms(this.uniforms);
	this.material = new BABYLON.ShaderMaterial("tubewindow",null,{ vertexElement : "simple", fragmentElement : "tubewindow"},{ attributes : ["position","normal","uv","world0","world1","world2","world3"], uniforms : tmp, defines : ["#define INSTANCES"], needAlphaBlending : true});
	this.material.setFloat("texScale",100);
	this.material.setTexture("tDiffuse",tDiffuse);
	this.material.setColor4("color",this.color);
	this.material.isReady(null,null);
};
$hxClasses["snaketunnel.TubeWindow"] = snaketunnel_TubeWindow;
snaketunnel_TubeWindow.__name__ = ["snaketunnel","TubeWindow"];
snaketunnel_TubeWindow.__super__ = wl_core_ShaderBase;
snaketunnel_TubeWindow.prototype = $extend(wl_core_ShaderBase.prototype,{
	update: function(ts) {
		this.material.setFloat("time",ts.toMilliseconds() / 80);
		this.material.setColor4("color",this.color);
	}
	,__class__: snaketunnel_TubeWindow
});
var washers_Tower = function(name,stacks,rotSpeed,glow) {
	if(glow == null) {
		glow = false;
	}
	if(rotSpeed == null) {
		rotSpeed = 0.01;
	}
	BABYLON.TransformNode.call(this,name);
	this.rotationspeed = rotSpeed;
	washers_Tower.mesh = this.CreateSlice();
	washers_Tower.mesh.isVisible = false;
	washers_Tower.instances = [];
	var finalMesh = null;
	var _g1 = 0;
	while(_g1 < stacks) {
		var instance = washers_Tower.mesh.clone("instance",this);
		instance.position.y = _g1++ * washers_Tower.SLICEHEIGHT;
		instance.rotate(BABYLON.Vector3.Up(),Math.PI * 2 * wl_util_Random.nextFloat());
		instance.setParent(this);
		washers_Tower.instances.push(instance);
	}
	finalMesh = BABYLON.Mesh.MergeMeshes(washers_Tower.instances,true);
	finalMesh.parent = this;
	washers_Tower.originalFinalMesh = finalMesh;
	var mat = new BABYLON.StandardMaterial("",null);
	mat.diffuseColor = DemoMain.BLUE_DARK;
	finalMesh.material = mat;
	var height = washers_Tower.SLICEHEIGHT * stacks;
	var innercylinder = BABYLON.MeshBuilder.CreateCylinder("incyl",{ height : height, diameter : 0.6, tessellation : 30},null);
	innercylinder.position.y = height / 2;
	innercylinder.setParent(this);
	var innermaterial = new BABYLON.StandardMaterial("incylmat",null);
	if(glow) {
		innermaterial.emissiveColor = new BABYLON.Color3(1,1,1);
	} else {
		innermaterial.diffuseColor = DemoMain.BLACK;
	}
	innercylinder.material = innermaterial;
	var bottomcylinder = BABYLON.MeshBuilder.CreateCylinder("cyl",{ height : washers_Tower.SLICEHEIGHT, diameter : 1, tessellation : 30},null);
	bottomcylinder.parent = this;
	bottomcylinder.position.y = -washers_Tower.SLICEHEIGHT;
	var topcylinder = bottomcylinder.clone("topcyl",this);
	topcylinder.parent = this;
	topcylinder.position.y = height + washers_Tower.SLICEHEIGHT;
	if(glow) {
		var glowmat = new BABYLON.StandardMaterial("",null);
		glowmat.emissiveColor = DemoMain.BLUE_DARK.clone().scale(0.5);
		bottomcylinder.material = glowmat;
	}
};
$hxClasses["washers.Tower"] = washers_Tower;
washers_Tower.__name__ = ["washers","Tower"];
washers_Tower.__super__ = BABYLON.TransformNode;
washers_Tower.prototype = $extend(BABYLON.TransformNode.prototype,{
	CreateSlice: function() {
		var cylinder = BABYLON.MeshBuilder.CreateCylinder("cyl",{ height : washers_Tower.SLICEHEIGHT, diameter : 1, tessellation : 30},null);
		var innerCylinder = BABYLON.MeshBuilder.CreateCylinder("cyl2",{ height : 2 * washers_Tower.SLICEHEIGHT, diameter : 0.5},null);
		var box = BABYLON.MeshBuilder.CreateBox("box",{ height : 2 * washers_Tower.SLICEHEIGHT, width : 0.5, depth : 1},null);
		box.position.x = -0.5;
		box.rotate(BABYLON.Vector3.Up(),Math.PI / 2);
		var csgcyl = BABYLON.CSG.FromMesh(cylinder);
		csgcyl.subtractInPlace(BABYLON.CSG.FromMesh(innerCylinder));
		csgcyl.subtractInPlace(BABYLON.CSG.FromMesh(box));
		var hollow = csgcyl.buildMeshGeometry("hollow",null,false);
		cylinder.dispose();
		innerCylinder.dispose();
		box.dispose();
		return hollow;
	}
	,update: function(delta) {
		this.rotate(BABYLON.Vector3.Up(),this.rotationspeed * delta);
	}
	,__class__: washers_Tower
});
var wl_core_Assets = $hx_exports["kvg"]["core"]["assets"] = function() {
};
$hxClasses["wl.core.Assets"] = wl_core_Assets;
wl_core_Assets.__name__ = ["wl","core","Assets"];
wl_core_Assets.register = function(id,type,data,compressed) {
	if(compressed) {
		throw new js__$Boot_HaxeError("Compression not implemented.");
	}
	if(type == "png" || type == "jpg") {
		var img = new Image();
		img.src = "data:image/" + (type == "jpg" ? "jpeg" : type) + ";base64," + data;
		var _this = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,img);
		} else {
			_this.h[id] = img;
		}
	} else if(type == "mp3" || type == "ogg") {
		var _this1 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this1.setReserved(id,data);
		} else {
			_this1.h[id] = data;
		}
	} else if(type == "json") {
		var _this2 = wl_core_Assets._assets;
		var value = JSON.parse(data);
		if(__map_reserved[id] != null) {
			_this2.setReserved(id,value);
		} else {
			_this2.h[id] = value;
		}
	} else if(type == "object") {
		var _this3 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this3.setReserved(id,data);
		} else {
			_this3.h[id] = data;
		}
	}
};
wl_core_Assets.get = function(id) {
	var _this = wl_core_Assets._assets;
	if(!(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id))) {
		console.log("Asset " + id + " not found");
	}
	var _this1 = wl_core_Assets._assets;
	if(__map_reserved[id] != null) {
		return _this1.getReserved(id);
	} else {
		return _this1.h[id];
	}
};
wl_core_Assets.getTexture = function(id) {
	var img = wl_core_Assets.get(id);
	if(img == null) {
		throw new js__$Boot_HaxeError("Texture " + id + " not found.");
	}
	return new BABYLON.Texture(img.src,null);
};
wl_core_Assets.prototype = {
	__class__: wl_core_Assets
};
var wl_core_Config = $hx_exports["wl"]["Config"] = function() {
	throw new js__$Boot_HaxeError("Config is static only.");
};
$hxClasses["wl.core.Config"] = wl_core_Config;
wl_core_Config.__name__ = ["wl","core","Config"];
wl_core_Config.prototype = {
	__class__: wl_core_Config
};
var wl_core_Demo = $hx_exports["Demo"] = function() {
	this.waitingFirstFrame = true;
	this.allowUpdate = false;
	this.previousUpdate = 0;
	this.partMap = new haxe_ds_StringMap();
	wl_core_Demo.instance = this;
};
$hxClasses["wl.core.Demo"] = wl_core_Demo;
wl_core_Demo.__name__ = ["wl","core","Demo"];
wl_core_Demo.prototype = {
	getPart: function(name) {
		var _this = this.partMap;
		if(__map_reserved[name] != null) {
			return _this.getReserved(name);
		} else {
			return _this.h[name];
		}
	}
	,init: function(container,callback) {
		var _gthis = this;
		this.onUpdate = new wl_core_Signal();
		wl_util_Random.init(wl_core_Config.SEED);
		this.graphics = new wl_core_Graphics(container);
		wl_sounds_SoundWL.onSoundComplete.connect($bind(this,this.onSoundEnd));
		container.appendChild(this.graphics.canvas);
		haxe_Timer.delay(function() {
			_gthis.previousTS = wl_core_TimeSig.create(0);
			_gthis.graphics.onRender.connect($bind(_gthis,_gthis.onRender));
			_gthis.initializeParts();
			if(wl_core_Config.DEBUG) {
				_gthis.initializeDebug();
			}
			createjs.Ticker.setPaused(true);
			callback();
		},100);
	}
	,initDemoComposer: function() {
	}
	,onSoundEnd: function() {
		this.end();
	}
	,initializeDebug: function() {
		wl_debug_Debug.init(this);
		wl_debug_ManualControl.init();
	}
	,initializeParts: function() {
		this.parts = [];
		var _g = 0;
		var _g1 = wl_core_Config.TIMELINE;
		while(_g < _g1.length) {
			var tl = _g1[_g];
			++_g;
			var id;
			if(tl.partId == null) {
				var o = tl.part;
				id = Type.getClassName(o == null ? null : js_Boot.getClass(o));
			} else {
				id = tl.partId;
			}
			tl.part.name = id;
			var _this = this.partMap;
			var key = tl.partId;
			console.log(tl.partId + " exists in partmap? " + Std.string(__map_reserved[key] != null ? _this.existsReserved(key) : _this.h.hasOwnProperty(key)) + " force new part is false? " + (tl.forceNewPart == null ? "null" : "" + tl.forceNewPart));
			var tmp;
			var _this1 = this.partMap;
			var key1 = tl.partId;
			if(__map_reserved[key1] != null ? _this1.existsReserved(key1) : _this1.h.hasOwnProperty(key1)) {
				tmp = !tl.forceNewPart;
			} else {
				tmp = false;
			}
			if(tmp) {
				var _this2 = this.partMap;
				var key2 = tl.partId;
				tl.part = __map_reserved[key2] != null ? _this2.getReserved(key2) : _this2.h[key2];
				tl.part.multiPart = true;
			} else {
				var _this3 = this.partMap;
				var key3 = tl.partId;
				var value = tl.part;
				if(__map_reserved[key3] != null) {
					_this3.setReserved(key3,value);
				} else {
					_this3.h[key3] = value;
				}
				this.parts.push(tl.part);
			}
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var part = _g11[_g2];
			++_g2;
			part.init();
		}
		console.log(this.parts);
		var _g3 = 0;
		var _g12 = this.parts;
		while(_g3 < _g12.length) {
			var part1 = _g12[_g3];
			++_g3;
			part1.render(this.previousTS,0);
		}
		var _g4 = 0;
		var _g13 = this.parts;
		while(_g4 < _g13.length) ++_g4;
	}
	,start: function() {
		var _gthis = this;
		this.previousRts = this.parts[0];
		this.graphics.start();
		haxe_Timer.delay(function() {
			wl_sounds_SoundWL.start();
			_gthis.allowUpdate = true;
			_gthis.waitingFirstFrame = false;
			console.log("allow upds.");
		},400);
		haxe_Timer.delay(function() {
			_gthis.parts[0].update(new wl_core_TimeSig(0),0,10,10);
			_gthis.parts[0].setRenderToScreen(true);
			_gthis.parts[0].render(new wl_core_TimeSig(0),10);
			_gthis.onRender(0);
		},40);
	}
	,end: function() {
		this.graphics.stop();
	}
	,onRender: function(time) {
		createjs.Tween.tick(time,false);
		var rts = null;
		var _g = 0;
		var _g1 = this.parts;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			if(p.inTransition) {
				p.render(this.previousTS,time,false);
			} else if(p.running) {
				if(rts == null && p.renderToScreen) {
					rts = p;
				} else {
					p.render(this.previousTS,time,false);
				}
			}
		}
		if(rts == null) {
			rts = this.previousRts;
		}
		if(rts != null) {
			this.previousRts = rts;
			rts.render(this.previousTS,time,true);
		}
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onrender();
		}
		if(this.allowUpdate) {
			this.update();
		}
	}
	,update: function() {
		var ts = wl_sounds_SoundWL.getPosition();
		var ms = ts.toMilliseconds();
		var frameTime = ms - this.previousUpdate;
		var delta = frameTime / 16.666666666666668;
		this.previousUpdate = ms;
		if(delta == 0) {
			return;
		}
		var _g1 = 0;
		var _g = wl_core_Config.TIMELINE.length;
		while(_g1 < _g) {
			var tl = wl_core_Config.TIMELINE[_g1++];
			if(ts.isInside(tl.runOn,tl.runOff)) {
				var p = tl.part;
				p.timeline = tl;
				var inTransition = ts.isInside(tl.runOn,tl.rtsOn) || ts.isInside(tl.rtsOff,tl.runOff);
				p.setRenderToScreen(tl.renderToScreen && !inTransition);
				if(!p.running) {
					p.start(ts);
				}
				p.isActive = true;
			}
		}
		if(wl_debug_Debug.paused) {
			0;
		} else {
			frameTime;
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			if(p1.isActive) {
				p1.update(ts,(ts.toMilliseconds() - p1.timeline.runOn.toMilliseconds()) / (p1.timeline.runOff.toMilliseconds() - p1.timeline.runOn.toMilliseconds()),wl_debug_Debug.paused ? 0 : frameTime,delta);
			} else if(p1.running) {
				p1.stop();
			}
			p1.isActive = false;
		}
		while(this.previousTS.isSmallerThan(ts)) {
			var _g3 = 0;
			var _g12 = this.parts;
			while(_g3 < _g12.length) {
				var p2 = _g12[_g3];
				++_g3;
				if(p2.running) {
					var key = p2.triggers.keys();
					while(key.hasNext()) {
						var key1 = key.next();
						var matches = key1.matchesPattern(this.previousTS,p2.timeline.runOn);
						if(matches && !key1.triggered) {
							var triggers = p2.triggers.h[key1.__id__];
							key1.triggered = true;
							var _g21 = 0;
							while(_g21 < triggers.length) {
								var toCall = triggers[_g21];
								++_g21;
								toCall(this.previousTS);
							}
						} else if(!matches) {
							key1.triggered = false;
						}
					}
				}
			}
			this.previousTS.addTicks(1);
		}
		this.onUpdate.emit(ts);
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onupdate();
		}
	}
	,__class__: wl_core_Demo
};
var wl_core_Graphics = function(container) {
	this.last = 0;
	this.stopped = true;
	this.container = container;
	if(wl_core_Graphics.instance == null) {
		wl_core_Graphics.instance = this;
	} else {
		console.log("Creating multiple Graphics instances. Are you sure?");
	}
	this.initGraphics();
};
$hxClasses["wl.core.Graphics"] = wl_core_Graphics;
wl_core_Graphics.__name__ = ["wl","core","Graphics"];
wl_core_Graphics.prototype = {
	initGraphics: function() {
		this.onRender = new wl_core_Signal();
		this.interval = 1000 / wl_core_Config.FPS;
		this.canvas = window.document.createElement("canvas");
		this.canvas.id = "demoCanvas";
		this.renderer = new BABYLON.Engine(this.canvas,true,{ });
		this.canvas.width = wl_core_Config.RESOLUTION[0];
		this.canvas.height = wl_core_Config.RESOLUTION[1];
		console.log("Using webgl version: " + this.renderer.webGLVersion);
	}
	,start: function() {
		this.last = 0;
		this.stopped = false;
		this.renderLoop(0);
	}
	,stop: function() {
		this.stopped = true;
	}
	,renderLoop: function(time) {
		this.delta = time - this.last;
		if(wl_core_Config.FPS < 0 || this.delta >= this.interval) {
			this.last = time;
			this.renderer.beginFrame();
			this.onRender.emit(this.delta);
			this.renderer.endFrame();
		}
		if(!this.stopped) {
			window.requestAnimationFrame($bind(this,this.renderLoop));
		}
	}
	,__class__: wl_core_Graphics
};
var wl_core_TimeSig = $hx_exports["wl"]["TimeSig"] = function(bar,beat,tick,delay,pattern) {
	this.triggered = false;
	this.delay = 0;
	this.set_bar(bar == null ? 0 : bar);
	this.set_beat(beat == null ? 0 : beat);
	this.set_tick(tick == null ? 0 : tick);
	this.delay = delay == null ? 0 : delay;
	this.pattern = pattern == null ? wl_core_TimeSig.ABSOLUTE : pattern;
};
$hxClasses["wl.core.TimeSig"] = wl_core_TimeSig;
wl_core_TimeSig.__name__ = ["wl","core","TimeSig"];
wl_core_TimeSig.create = function(time) {
	return new wl_core_TimeSig().fromTime(time);
};
wl_core_TimeSig.milliseconds = function(bar,beat,tick,delay) {
	return (bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + beat / wl_core_Config.BEATS_PER_MINUTE + tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
};
wl_core_TimeSig.prototype = {
	set_beat: function(value) {
		this.beat = value;
		return this.beat;
	}
	,set_bar: function(value) {
		this.bar = value;
		return this.bar;
	}
	,set_tick: function(value) {
		this.tick = value;
		return this.tick;
	}
	,adjust: function() {
	}
	,matchesPattern: function(time,begin) {
		if(this.pattern == wl_core_TimeSig.ABSOLUTE) {
			return this.equals(time);
		} else if(this.pattern == wl_core_TimeSig.RELATIVE) {
			if(time.bar == begin.bar + this.bar && time.beat == begin.beat + this.beat) {
				return time.tick == begin.tick + this.tick;
			} else {
				return false;
			}
		} else if(this.pattern == wl_core_TimeSig.PATTERN) {
			if((this.bar == -1 || time.bar % this.bar == 0) && (this.beat == -1 || time.beat % wl_core_Config.BEATS_PER_BAR == this.beat)) {
				if(this.tick != -1) {
					return time.tick % wl_core_Config.TICKS_PER_BEAT == this.tick;
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	,add: function(ts) {
		this.addBars(ts.bar);
		this.addBeats(ts.beat);
		this.addTicks(ts.tick);
	}
	,addBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar + bars);
	}
	,addBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat + beats);
		var _g1 = this;
		_g1.set_bar(_g1.bar + Math.floor(this.beat / wl_core_Config.BEATS_PER_BAR));
		var _g2 = this;
		_g2.set_beat(_g2.beat % wl_core_Config.BEATS_PER_BAR);
	}
	,addTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick + ticks);
		while(this.tick >= wl_core_Config.TICKS_PER_BEAT) {
			var _g1 = this;
			_g1.set_tick(_g1.tick - wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat + 1);
		}
		while(this.beat >= wl_core_Config.BEATS_PER_BAR) {
			var _g3 = this;
			_g3.set_beat(_g3.beat - wl_core_Config.BEATS_PER_BAR);
			var _g4 = this;
			_g4.set_bar(_g4.bar + 1);
		}
	}
	,subtract: function(ts) {
		this.subtractBars(ts.bar);
		this.subtractBeats(ts.beat);
		this.subtractTicks(ts.tick);
	}
	,subtractBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar - bars);
	}
	,subtractBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat - beats);
		while(this.beat < 0) {
			var _g1 = this;
			_g1.set_bar(_g1.bar - 1);
			var _g2 = this;
			_g2.set_beat(_g2.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,subtractTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick - ticks);
		while(this.tick < 0) {
			var _g1 = this;
			_g1.set_tick(_g1.tick + wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat - 1);
		}
		while(this.beat < 0) {
			var _g3 = this;
			_g3.set_bar(_g3.bar - 1);
			var _g4 = this;
			_g4.set_beat(_g4.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,fromTime: function(time) {
		var totalBeats = wl_core_Config.BEATS_PER_MINUTE * time;
		var comp = time < 0 ? Math.ceil : Math.floor;
		this.set_bar(comp(totalBeats / wl_core_Config.BEATS_PER_BAR));
		this.set_beat(comp(totalBeats % wl_core_Config.BEATS_PER_BAR));
		this.set_tick(comp((totalBeats - comp(totalBeats)) * wl_core_Config.TICKS_PER_BEAT));
		this.delay = 0;
		this.delay = Math.floor(255 * (time * 60 * 1000 - this.toMilliseconds()) / (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT) % 255);
		return this;
	}
	,isInside: function(begin,end) {
		if(this.isSmallerThan(end)) {
			return this.isLargerThan(begin);
		} else {
			return false;
		}
	}
	,isInsideFloat: function(begin,end) {
		if(this.toMilliseconds() >= begin) {
			return this.toMilliseconds() <= end;
		} else {
			return false;
		}
	}
	,isSmallerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks >= tickso) {
			if(ticks == tickso) {
				return this.delay < other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,isLargerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks <= tickso) {
			if(ticks == tickso) {
				return this.delay >= other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,toMilliseconds: function() {
		return (this.bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + this.beat / wl_core_Config.BEATS_PER_MINUTE + this.tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(this.delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
	}
	,equals: function(other) {
		return this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick == other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
	}
	,clone: function() {
		return new wl_core_TimeSig(this.bar,this.beat,this.tick,this.delay,this.pattern);
	}
	,toString: function(full) {
		return this.bar + ":" + this.beat + ":" + this.tick + (full ? " / " + this.delay + "\n[" + this.pattern + "]" : "");
	}
	,__class__: wl_core_TimeSig
};
var wl_debug_CustomCameraControl = function() {
	this.availableKeys = [];
	this.keysDown = [];
	this.shift = 16;
	this.down = 70;
	this.up = 82;
	this.right = 68;
	this.left = 65;
	this.backward = 83;
	this.forward = 87;
	this.availableKeys = [this.forward,this.backward,this.left,this.right,this.up,this.down,this.shift];
};
$hxClasses["wl.debug.CustomCameraControl"] = wl_debug_CustomCameraControl;
wl_debug_CustomCameraControl.__name__ = ["wl","debug","CustomCameraControl"];
wl_debug_CustomCameraControl.__interfaces__ = [BABYLON_ICameraInput];
wl_debug_CustomCameraControl.prototype = {
	getClassName: function() {
		return "CustomCameraController";
	}
	,getSimpleName: function() {
		return "CustomCameraController";
	}
	,attachControl: function(element,noPreventDefault) {
		var _gthis = this;
		if(this.onCanvasBlurObserver != null) {
			return;
		}
		console.log(noPreventDefault);
		this.scene = this.camera.getScene();
		this.engine = this.scene.getEngine();
		this.onCanvasBlurObserver = this.engine.onCanvasBlurObservable.add(function(engine,eventState) {
			_gthis.keysDown = [];
		});
		this.onKeyboardObserver = this.scene.onKeyboardObservable.add(function(info,eventState1) {
			var evt = info.event;
			if(info.type == BABYLON.KeyboardEventTypes.KEYDOWN) {
				if(_gthis.availableKeys.indexOf(evt.keyCode) == -1) {
					return;
				}
				if(_gthis.shift == evt.keyCode) {
					_gthis.shiftDown = true;
				} else if(_gthis.keysDown.indexOf(evt.keyCode) == -1) {
					_gthis.keysDown.push(evt.keyCode);
				}
			} else {
				if(_gthis.shift == evt.keyCode) {
					_gthis.shiftDown = false;
				}
				var index = _gthis.keysDown.indexOf(evt.keyCode);
				if(index >= 0) {
					_gthis.keysDown.splice(index,1);
				}
			}
		});
	}
	,detachControl: function(element) {
		if(this.scene != null) {
			if(this.onKeyboardObserver != null) {
				this.scene.onKeyboardObservable.remove(this.onKeyboardObserver);
			}
		}
		if(this.engine != null) {
			if(this.onCanvasBlurObserver != null) {
				this.engine.onCanvasBlurObservable.remove(this.onCanvasBlurObserver);
			}
		}
		this.keysDown = [];
		this.onCanvasBlurObserver = null;
		this.onKeyboardObserver = null;
	}
	,checkInputs: function() {
		if(this.onKeyboardObserver != null) {
			var _g1 = 0;
			var _g = this.keysDown.length;
			while(_g1 < _g) {
				var index = _g1++;
				var keyCode = this.keysDown[index];
				var speed = this.camera._computeLocalCameraSpeed();
				if(this.shiftDown) {
					speed /= 10.0;
				}
				if(this.left == keyCode) {
					this.camera._localDirection.copyFromFloats(-speed,0,0);
				} else if(this.forward == keyCode) {
					this.camera._localDirection.copyFromFloats(0,0,speed);
				} else if(this.right == keyCode) {
					this.camera._localDirection.copyFromFloats(speed,0,0);
				} else if(this.backward == keyCode) {
					this.camera._localDirection.copyFromFloats(0,0,-speed);
				} else if(this.up == keyCode) {
					this.camera._localDirection.copyFromFloats(0,speed,0);
				} else if(this.down == keyCode) {
					this.camera._localDirection.copyFromFloats(0,-speed,0);
				}
				if(this.camera.getScene().useRightHandedSystem) {
					this.camera._localDirection.z *= -1;
				}
				this.camera.getViewMatrix().invertToRef(this.camera._cameraTransformMatrix);
				BABYLON.Vector3.TransformNormalToRef(this.camera._localDirection,this.camera._cameraTransformMatrix,this.camera._transformedDirection);
				this.camera.cameraDirection.addInPlace(this.camera._transformedDirection);
			}
		}
	}
	,_onLostFocus: function(e) {
		this.keysDown = [];
	}
	,__class__: wl_debug_CustomCameraControl
};
var wl_debug_Debug = function() {
};
$hxClasses["wl.debug.Debug"] = wl_debug_Debug;
wl_debug_Debug.__name__ = ["wl","debug","Debug"];
wl_debug_Debug.init = function(demo) {
	wl_debug_Debug.gui = new dat.gui.GUI();
	window.document.addEventListener("keydown",wl_debug_Debug.onKeyDown);
	wl_debug_Debug.debugDiv = $(".debug");
	wl_debug_Debug.debugTimeSig = wl_debug_Debug.debugDiv.find("#debug_timesig");
	var tldiv = wl_debug_Debug.debugDiv.find("#timeline_parts");
	var _g = 0;
	var _g1 = wl_core_Config.TIMELINE;
	while(_g < _g1.length) {
		var tl = _g1[_g];
		++_g;
		var tlel = $("<li>" + Std.string(tl) + "</li>");
		tldiv.append(tlel);
		tlel.click(wl_debug_Debug.tlClick(tl));
		wl_debug_Debug.datGuiPart(tl.part);
	}
	wl_debug_Debug.stats = new Stats();
	wl_debug_Debug.stats.showPanel(1);
	wl_debug_Debug.stats.dom.style.position = "absolute";
	wl_debug_Debug.stats.dom.style.bottom = "0px";
	wl_debug_Debug.stats.dom.style.top = null;
	wl_debug_Debug.debugDiv.eq(0).append(wl_debug_Debug.stats.dom);
	wl_debug_Debug.stats.begin();
};
wl_debug_Debug.datGuiPart = function(part) {
	var name = part.name;
	while(wl_debug_Debug.usedFolderNames.indexOf(name) >= 0) name += ">";
	var folder = wl_debug_Debug.gui.addFolder(name);
	wl_debug_Debug.usedFolderNames.push(name);
	var composer = Reflect.field(part,"composer");
	if(composer != null) {
		var _g = 0;
		var _g1 = composer.passes;
		while(_g < _g1.length) {
			var pass = _g1[_g];
			++_g;
			if(pass.setupDatGui != null) {
				pass.setupDatGui(folder);
			}
		}
	}
	var occlusioncomposer = Reflect.field(part,"occlusionComposer");
	if(occlusioncomposer != null) {
		var _g2 = 0;
		var _g11 = occlusioncomposer.passes;
		while(_g2 < _g11.length) {
			var pass1 = _g11[_g2];
			++_g2;
			if(pass1.setupDatGui != null) {
				pass1.setupDatGui(folder);
			}
		}
	}
	part.setupDatGui(folder);
};
wl_debug_Debug.tlClick = function(tl) {
	return function() {
		var curtime = wl_sounds_SoundWL.instance.getPosition();
		var tlpos = tl.rtsOn.toMilliseconds();
		wl_sounds_SoundWL.instance.setPosition(tlpos);
		createjs.Tween.tick(Math.floor(tlpos - curtime),false);
		wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	};
};
wl_debug_Debug.onupdate = function() {
	var ts = wl_sounds_SoundWL.getPosition();
	wl_debug_Debug.debugTimeSig.html(StringTools.replace(ts.toString(),"\n","<br/>") + "<br/>" + Math.round(ts.toMilliseconds() / 100) / 10 + "s");
};
wl_debug_Debug.onrender = function() {
	wl_debug_Debug.stats.update();
};
wl_debug_Debug.onKeyDown = function(e) {
	if(e.keyCode == 90) {
		console.log("Time captured: " + Std.string(wl_core_Demo.instance.previousTS));
	}
	if(e.keyCode == 109 || e.keyCode == 188) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() - 5000);
			createjs.Tween.tick(-5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 107 || e.keyCode == 190) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() + 5000);
			createjs.Tween.tick(5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 32) {
		wl_debug_Debug.paused = !wl_debug_Debug.paused;
		wl_sounds_SoundWL.instance.paused = wl_debug_Debug.paused;
		createjs.Tween.removeAllTweens();
	}
};
wl_debug_Debug.prototype = {
	__class__: wl_debug_Debug
};
var wl_debug_ManualControl = function() {
	throw new js__$Boot_HaxeError("Manual control is static");
};
$hxClasses["wl.debug.ManualControl"] = wl_debug_ManualControl;
wl_debug_ManualControl.__name__ = ["wl","debug","ManualControl"];
wl_debug_ManualControl.init = function() {
	if(wl_debug_ManualControl.inited) {
		return;
	}
	wl_debug_ManualControl.inited = true;
};
wl_debug_ManualControl.onMouseDown = function(event) {
	console.log("mouse down");
};
wl_debug_ManualControl.onMouseUp = function(event) {
	console.log("Mouse up");
};
wl_debug_ManualControl.onKeyDown = function(event) {
};
wl_debug_ManualControl.update = function() {
};
wl_debug_ManualControl.attachPart = function(part) {
	if(!wl_core_Config.DEBUG) {
		return;
	}
	part.camera.attachControl(wl_core_Graphics.instance.canvas,true);
	console.log(part.camera.inputs);
	part.camera.inputs.add(new wl_debug_CustomCameraControl());
};
wl_debug_ManualControl.prototype = {
	__class__: wl_debug_ManualControl
};
var wl_debug_PostProcessSliders = function() {
};
$hxClasses["wl.debug.PostProcessSliders"] = wl_debug_PostProcessSliders;
wl_debug_PostProcessSliders.__name__ = ["wl","debug","PostProcessSliders"];
wl_debug_PostProcessSliders.applySliders = function(folder,pipeline) {
	wl_debug_PostProcessSliders.applyFXAA(folder.addFolder("FXAA"),pipeline);
	wl_debug_PostProcessSliders.applySharpen(folder.addFolder("Sharpen"),pipeline);
	wl_debug_PostProcessSliders.applyDoF(folder.addFolder("DoF"),pipeline);
	wl_debug_PostProcessSliders.applyBloom(folder.addFolder("Bloom"),pipeline);
	wl_debug_PostProcessSliders.applyImageProcessing(folder.addFolder("ImageProcessing"),pipeline);
	wl_debug_PostProcessSliders.applyChromaticAberration(folder.addFolder("ChromaticAberration"),pipeline);
	wl_debug_PostProcessSliders.applyGrain(folder.addFolder("Grain"),pipeline);
};
wl_debug_PostProcessSliders.applyFXAA = function(folder,pipeline) {
	folder.add(pipeline,"fxaaEnabled");
};
wl_debug_PostProcessSliders.applySharpen = function(folder,pipeline) {
	folder.add(pipeline,"sharpenEnabled");
	folder.add(pipeline.sharpen,"colorAmount");
	folder.add(pipeline.sharpen,"edgeAmount");
};
wl_debug_PostProcessSliders.applyDoF = function(folder,pipeline) {
	folder.add(pipeline,"depthOfFieldEnabled");
	folder.add(pipeline.depthOfField,"focalLength").min(0).max(200).step(1);
	folder.add(pipeline.depthOfField,"focusDistance").min(0).max(5000).step(0.1);
	folder.add(pipeline.depthOfField,"fStop").min(0).max(20).step(0.01);
	folder.add(pipeline.depthOfField,"lensSize").min(0).max(500).step(0.01);
	folder.add(pipeline,"depthOfFieldBlurLevel").min(0).max(2).step(1);
};
wl_debug_PostProcessSliders.applyBloom = function(folder,pipeline) {
	folder.add(pipeline,"bloomEnabled");
	folder.add(pipeline.bloom,"kernel");
	folder.add(pipeline.bloom,"bloomScale");
	folder.add(pipeline.bloom,"threshold");
	folder.add(pipeline.bloom,"weight");
};
wl_debug_PostProcessSliders.applyImageProcessing = function(folder,pipeline) {
	folder.add(pipeline,"imageProcessingEnabled");
	folder.add(pipeline.imageProcessing,"toneMappingEnabled");
	folder.add(pipeline.imageProcessing,"exposure").min(-5).max(5000).step(0.01);
	folder.add(pipeline.imageProcessing,"contrast").min(-5).max(5).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteEnabled");
	folder.add(pipeline.imageProcessing,"vignetteCentreX").min(-1).max(1).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteCentreY").min(-1).max(1).step(0.01);
	folder.addColor(pipeline.imageProcessing,"vignetteColor");
	folder.add(pipeline.imageProcessing,"vignetteStretch").min(0).max(1).step(0.01);
	folder.add(pipeline.imageProcessing,"vignetteWeight").min(0).max(20).step(0.01);
};
wl_debug_PostProcessSliders.applyChromaticAberration = function(folder,pipeline) {
	folder.add(pipeline,"chromaticAberrationEnabled");
	folder.add(pipeline.chromaticAberration,"aberrationAmount").min(0).max(100).step(0.01);
	folder.add(pipeline.chromaticAberration,"radialIntensity").min(-5).max(5).step(0.01);
	var dir = folder.addFolder("direction");
	dir.add(pipeline.chromaticAberration.direction,"x").min(-1).max(1).step(0.01);
	dir.add(pipeline.chromaticAberration.direction,"y").min(-1).max(1).step(0.01);
	var center = folder.addFolder("center position");
	center.add(pipeline.chromaticAberration.centerPosition,"x").min(-1).max(1).step(0.01);
	center.add(pipeline.chromaticAberration.centerPosition,"y").min(-1).max(1).step(0.01);
};
wl_debug_PostProcessSliders.applyGrain = function(folder,pipeline) {
	folder.add(pipeline,"grainEnabled");
	folder.add(pipeline.grain,"intensity").min(0).max(500).step(0.1);
	folder.add(pipeline.grain,"animated");
};
wl_debug_PostProcessSliders.prototype = {
	__class__: wl_debug_PostProcessSliders
};
var wl_demo_BoardItem = function(startTime,endTime,controller) {
	this.startTime = startTime;
	this.controller = controller;
	this.endTime = endTime;
};
$hxClasses["wl.demo.BoardItem"] = wl_demo_BoardItem;
wl_demo_BoardItem.__name__ = ["wl","demo","BoardItem"];
wl_demo_BoardItem.prototype = {
	Run: function(ts) {
		if(ts.isLargerThan(this.startTime) && ts.isSmallerThan(this.endTime)) {
			this.controller.update((ts.toMilliseconds() - this.startTime.toMilliseconds()) / (this.endTime.toMilliseconds() - this.startTime.toMilliseconds()));
		}
	}
	,__class__: wl_demo_BoardItem
};
var wl_demo_IController = function() { };
$hxClasses["wl.demo.IController"] = wl_demo_IController;
wl_demo_IController.__name__ = ["wl","demo","IController"];
wl_demo_IController.prototype = {
	__class__: wl_demo_IController
};
var wl_demo_CameraController = function(camera) {
	this.ignoreStop = false;
	this.updateLook = true;
	this.updatePath = true;
	if(camera != null) {
		this.attachCamera(camera);
	}
};
$hxClasses["wl.demo.CameraController"] = wl_demo_CameraController;
wl_demo_CameraController.__name__ = ["wl","demo","CameraController"];
wl_demo_CameraController.__interfaces__ = [wl_demo_IController];
wl_demo_CameraController.stopAllControl = function() {
	wl_demo_CameraController.STOPPED = true;
};
wl_demo_CameraController.prototype = {
	attachCamera: function(camera) {
		this.camera = camera;
	}
	,set_mode: function(mode) {
		this.mode = mode;
		return mode;
	}
	,initStatic: function(position,lookAt) {
		this.position = position;
		this.lookAt = lookAt;
		this.set_mode(wl_demo_CameraController.STATIC);
	}
	,initFollow: function(target,followOffset,followLookOffset) {
		this.set_mode(wl_demo_CameraController.FOLLOW);
		this.follow = target;
		this.followOffset = followOffset == null ? new BABYLON.Vector3(0,0,0) : followOffset;
		this.followLookOffset = followLookOffset == null ? new BABYLON.Vector3(0,0,0) : followLookOffset;
	}
	,initLinear: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.LINEAR);
		this.points = points;
		this.lookAts = lookAts;
	}
	,initBezier: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.BEZIER);
		this.points = points;
		this.lookAts = lookAts;
		this.path = BABYLON.Curve3.CreateCatmullRomSpline(points,2000);
		this.lookPath = BABYLON.Curve3.CreateCatmullRomSpline(lookAts,2000);
	}
	,showbezierPaths: function(scene) {
	}
	,update: function(phase) {
		if(wl_demo_CameraController.STOPPED && !this.ignoreStop) {
			return;
		}
		if(this.mode == wl_demo_CameraController.STATIC) {
			if(this.updatePath) {
				this.camera.position.x = this.position.x;
				this.camera.position.y = this.position.y;
				this.camera.position.z = this.position.z;
			}
			if(this.updateLook) {
				this.camera.setTarget(this.lookAt);
			}
		} else if(this.mode == wl_demo_CameraController.LINEAR) {
			if(this.updatePath) {
				var a = this.points[0];
				var b = this.points[1];
				var c = new BABYLON.Vector3(0,0,0);
				BABYLON.Vector3.LerpToRef(a,b,phase,c);
				this.camera.position.x = c.x;
				this.camera.position.y = c.y;
				this.camera.position.z = c.z;
			}
			if(this.updateLook) {
				var a1 = this.lookAts[0];
				var b1 = this.lookAts[1];
				var c1 = new BABYLON.Vector3(0,0,0);
				BABYLON.Vector3.LerpToRef(a1,b1,phase,c1);
				this.camera.setTarget(c1);
			}
		} else if(this.mode == wl_demo_CameraController.FOLLOW) {
			if(this.updatePath) {
				this.camera.position.x = this.follow.position.x + this.followOffset.x;
				this.camera.position.y = this.follow.position.y + this.followOffset.y;
				this.camera.position.z = this.follow.position.z + this.followOffset.z;
			}
			if(this.updateLook) {
				this.camera.setTarget(this.follow.position.add(this.followLookOffset));
			}
		} else if(this.mode == wl_demo_CameraController.BEZIER) {
			if(phase < 0) {
				phase = 0;
			} else if(phase > 1) {
				phase = 1;
			}
			if(this.updatePath) {
				var p = this.path.getPoints()[Math.floor(Math.min(phase * this.path.getPoints().length,this.path.getPoints().length - 1))];
				this.camera.position.x = p.x;
				this.camera.position.y = p.y;
				this.camera.position.z = p.z;
			}
			if(this.updateLook) {
				var p1 = this.lookPath.getPoints()[Math.floor(Math.min(phase * this.path.getPoints().length,this.path.getPoints().length - 1))];
				this.camera.setTarget(p1);
				this.lookAt = p1;
			}
			this.position = this.camera.position;
		}
	}
	,__class__: wl_demo_CameraController
};
var wl_demo_SceneBoard = function() {
	this.startTime = new wl_core_TimeSig();
	this.BoardItems = [];
};
$hxClasses["wl.demo.SceneBoard"] = wl_demo_SceneBoard;
wl_demo_SceneBoard.__name__ = ["wl","demo","SceneBoard"];
wl_demo_SceneBoard.prototype = {
	add: function(startTime,endTime,controller) {
		this.BoardItems.push(new wl_demo_BoardItem(startTime,endTime,controller));
	}
	,start: function(ts) {
		this.startTime = ts.clone();
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.BoardItems;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			var ts2 = ts.clone();
			ts2.subtract(this.startTime);
			b.Run(ts2);
		}
	}
	,__class__: wl_demo_SceneBoard
};
var wl_demo_TimeLine = function(instance,runOn,runOff,partId,renderToScreen,rtsOn,rtsOff,forceNewPart,extra) {
	console.log("Timeline init:" + (forceNewPart == null ? "null" : "" + forceNewPart));
	this.part = instance;
	this.partId = partId;
	this.runOn = runOn;
	this.runOff = runOff;
	this.rtsOn = rtsOn == null ? runOn.clone() : rtsOn;
	this.rtsOff = rtsOff == null ? runOff.clone() : rtsOff;
	this.renderToScreen = renderToScreen == null ? true : renderToScreen;
	this.forceNewPart = forceNewPart == null ? false : forceNewPart;
	this.extra = extra;
};
$hxClasses["wl.demo.TimeLine"] = wl_demo_TimeLine;
wl_demo_TimeLine.__name__ = ["wl","demo","TimeLine"];
wl_demo_TimeLine.prototype = {
	toString: function() {
		return this.part.name + ":" + this.rtsOn.toString() + " - " + this.rtsOff.toString();
	}
	,__class__: wl_demo_TimeLine
};
var wl_post_distort_DistortPostProcess = function(camera,engine) {
	this.brightness = 0;
	this.autoOffset = false;
	this.offsetSpeed = 0.001;
	this.offset = 0;
	this.lineHeight = wl_core_Config.RESOLUTION[1] / 4;
	this.intensity = 0;
	var _gthis = this;
	BABYLON.Effect.ShadersStore["distortFragmentShader"] = haxe_Resource.getString("distort.frag");
	BABYLON.PostProcess.call(this,"distortPostProcess","distort",["intensity","height","offsetY","brightness"],[],1.0,camera,BABYLON.Texture.NEAREST_SAMPLINGMODE,engine,false,null,BABYLON.Engine.TEXTURETYPE_UNSIGNED_INT,"postprocess",null,false);
	this.onApplyObservable.add(function(e,es) {
		e.setFloat("intensity",_gthis.intensity);
		e.setFloat("height",_gthis.lineHeight);
		e.setFloat("offsetY",_gthis.offset);
		e.setFloat("brightness",_gthis.brightness);
	});
	wl_core_Demo.instance.onUpdate.connect(function(ts) {
		var _gthis1 = _gthis.offsetSpeed;
		var tmp = ts.toMilliseconds();
		_gthis.offset = _gthis1 * tmp;
	});
};
$hxClasses["wl.post.distort.DistortPostProcess"] = wl_post_distort_DistortPostProcess;
wl_post_distort_DistortPostProcess.__name__ = ["wl","post","distort","DistortPostProcess"];
wl_post_distort_DistortPostProcess.__super__ = BABYLON.PostProcess;
wl_post_distort_DistortPostProcess.prototype = $extend(BABYLON.PostProcess.prototype,{
	setupDatGui: function(folder) {
		folder.add(this,"intensity").min(0).max(1).step(0.001);
		folder.add(this,"height").min(0).max(1080).step(0.1);
		folder.add(this,"offsetSpeed").min(0).max(1).step(0.0001);
		folder.add(this,"autoOffset");
	}
	,__class__: wl_post_distort_DistortPostProcess
});
var wl_setup_JsonConfigurator = function() {
};
$hxClasses["wl.setup.JsonConfigurator"] = wl_setup_JsonConfigurator;
wl_setup_JsonConfigurator.__name__ = ["wl","setup","JsonConfigurator"];
wl_setup_JsonConfigurator.prototype = {
	fromJson: function(json) {
		var config = JSON.parse(json);
		this.audioSettingsfromJson(config);
		this.visualSettingsfromJson(config);
		this.timelineFromJson(config);
	}
	,audioSettingsfromJson: function(config) {
		wl_core_Config.BEATS_PER_MINUTE = config.audio.beatsPerMinute;
		wl_core_Config.BEATS_PER_BAR = config.audio.beatsPerBar;
		wl_core_Config.TICKS_PER_BEAT = config.audio.ticksPerBeat;
		wl_core_Config.MUSIC_BEGIN = config.audio.musicBegin;
		wl_core_Config.SONG_PATH = config.audio.songPath;
		wl_core_Config.ENABLE_FFT = config.audio.enableFFT;
	}
	,visualSettingsfromJson: function(config) {
		wl_core_Config.FPS = config.visual.targetFps;
		wl_core_Config.RESOLUTION = config.visual.resolution;
		wl_core_Config.ANTIALIAS = config.visual.antiAlias;
		wl_core_Config.ENABLE_SHADOWS = config.visual.enableShadows;
		wl_core_Config.CLEAR_COLOR = BABYLON.Color4.FromHexString(config.visual.clearColor);
		console.log(wl_core_Config.CLEAR_COLOR);
		wl_core_Config.SHADOW_MAP_SIZE = config.visual.shadowMapSize;
	}
	,timelineFromJson: function(config) {
		var tl = config.timeline;
		var convertedTl = [];
		var ignoreParts = window.location.hash.indexOf("Coverride=") >= 0;
		if(window.location.hash.indexOf("override=") >= 0) {
			convertedTl = [];
			var m = new RegExp("override=(.*)","").exec(window.location.hash);
			console.log("overriding timeline with " + m[1]);
			convertedTl.push(this.tlFromConfig({ "partId" : "override", "type" : m[1], "renderToScreen" : true, "runOn" : [0,0,0,0], "runOff" : [128,0,0,0], "extra" : "", "forceNewPart" : false}));
		}
		if(!ignoreParts) {
			var _g = 0;
			while(_g < tl.length) {
				var c = tl[_g];
				++_g;
				convertedTl.push(this.tlFromConfig(c));
			}
		}
		wl_core_Config.TIMELINE = convertedTl;
	}
	,tlFromConfig: function(config) {
		return new wl_demo_TimeLine(Type.createInstance(Type.resolveClass(config.type),[]),this.mainTimesigFromArray(config.runOn),this.mainTimesigFromArray(config.runOff),config.partId,config.renderToScreen,this.mainTimesigFromArray(config.rtsOn),this.mainTimesigFromArray(config.rtsOff),config.forceNewPart,config.extra);
	}
	,mainTimesigFromArray: function(tsArray) {
		if(tsArray == null) {
			return null;
		}
		return new wl_core_TimeSig(tsArray.length > 0 ? tsArray[0] : null,tsArray.length > 1 ? tsArray[1] : null,tsArray.length > 2 ? tsArray[2] : null,tsArray.length > 3 ? tsArray[3] : null,wl_core_TimeSig.ABSOLUTE);
	}
	,__class__: wl_setup_JsonConfigurator
};
var wl_setup_Setup = function() {
	throw new js__$Boot_HaxeError("Setup is static only.");
};
$hxClasses["wl.setup.Setup"] = wl_setup_Setup;
wl_setup_Setup.__name__ = ["wl","setup","Setup"];
wl_setup_Setup.init = function(demo) {
	wl_setup_Setup.setupDiv = $("#setup");
	wl_setup_Setup.demoDiv = $("#demo");
	wl_setup_Setup.resolution = wl_setup_Setup.setupDiv.find("#resolution");
	var fullscreen = wl_setup_Setup.setupDiv.find("#fullscreen");
	var start = wl_setup_Setup.setupDiv.find("#start");
	fullscreen.click(wl_setup_Setup.fullScreenClickHandler);
	start.click(wl_setup_Setup.startClickHandler);
	wl_setup_Setup.demo = demo;
	if(window.location.protocol.indexOf("file") >= 0) {
		$("#localWarning").css("display","");
	}
};
wl_setup_Setup.hideSetup = function() {
	wl_setup_Setup.setupDiv.remove();
};
wl_setup_Setup.startRun = function() {
	if(wl_setup_Setup.setupDiv.find("#muted").find("input")["is"](":checked")) {
		wl_core_Config.MUTED = true;
	}
	var debug = wl_setup_Setup.setupDiv.find("#debug").find("input")["is"](":checked");
	wl_core_Config.DEBUG = debug;
	if(debug) {
		$(".debug").css("display","block");
	} else {
		$(".debug").css("display","none");
	}
	wl_setup_Setup.loadImg = wl_core_Assets.get("loadingImage.png");
	wl_setup_Setup.loadImg.style.position = "absolute";
	wl_setup_Setup.loadImg.style.left = "0px";
	wl_setup_Setup.loadImg.style.right = "0px";
	wl_setup_Setup.loadImg.style.top = "0px";
	wl_setup_Setup.loadImg.style.bottom = "0px";
	wl_setup_Setup.loadImg.style.width = "100%";
	wl_setup_Setup.loadImg.style.height = "100%";
	wl_setup_Setup.demoDiv.append(wl_setup_Setup.loadImg);
	wl_setup_Setup.demo.init(wl_setup_Setup.demoDiv[0],function() {
		wl_setup_Setup.loadImg.remove();
		wl_setup_Setup.demo.start();
	});
	window.document.getElementById("demo").style.display = "block";
};
wl_setup_Setup.fullScreenClickHandler = function(e) {
	wl_setup_Setup.hideSetup();
	try {
		wl_setup_Setup.demoDiv[0].requestFullscreen();
	} catch( e1 ) {
		throw new js__$Boot_HaxeError("Full screen could not be initialized. Please reload and try again.");
	}
	var w = window.screen.width;
	var h = window.screen.height;
	var ratio = wl_core_Config.RATIO;
	var lockAspect = $("#aspectLock input").val() == "on";
	if(lockAspect && w / ratio < h) {
		h = w * 720 / 1280;
	} else if(lockAspect && h < w / ratio) {
		w = h * 1280 / 720;
	}
	wl_core_Config.RESOLUTION[0] = Math.floor(w);
	wl_core_Config.RESOLUTION[1] = Math.floor(h);
	wl_setup_Setup.demoDiv.css("background","black");
	haxe_Timer.delay(wl_setup_Setup.startRun,5000);
};
wl_setup_Setup.startClickHandler = function(e) {
	$("#zoomWarning").css("display","none");
	$("#demo").css("transform","").css("-webkit-transform","");
	var lockAspect = $("#aspectLock input").val() == "on";
	$("#muted input")["is"](":checked");
	var resolutionType = $("#resolution .active input[name='options']").val();
	wl_setup_Setup.hideSetup();
	var w = 1280;
	var h = 720;
	if(resolutionType == "b") {
		w = 1920;
		h = 1080;
	} else if(resolutionType == "c") {
		w = window.innerWidth;
		h = window.innerHeight;
		var ratio = wl_core_Config.RATIO;
		if(lockAspect && w / ratio < h) {
			h = w / ratio;
		} else if(lockAspect && h < w / ratio) {
			w = h * ratio;
		}
	}
	wl_core_Config.RESOLUTION[0] = w;
	wl_core_Config.RESOLUTION[1] = h;
	wl_setup_Setup.demoDiv.css("width",w + "px").css("height",h + "px");
	haxe_Timer.delay(wl_setup_Setup.startRun,50);
};
wl_setup_Setup.prototype = {
	__class__: wl_setup_Setup
};
var wl_sounds_SoundAnalyzer = function() {
	this.historySize = 6;
	this.filters = [];
	this.historyLeft = [];
	this.historyRight = [];
	var _g1 = 0;
	var _g = wl_sounds_SoundWL.FFT_PRECISION;
	while(_g1 < _g) {
		++_g1;
		this.historyLeft.push([]);
		this.historyRight.push([]);
	}
};
$hxClasses["wl.sounds.SoundAnalyzer"] = wl_sounds_SoundAnalyzer;
wl_sounds_SoundAnalyzer.__name__ = ["wl","sounds","SoundAnalyzer"];
wl_sounds_SoundAnalyzer.prototype = {
	update: function() {
		var _g = 0;
		var _g1 = this.filters;
		while(_g < _g1.length) {
			var filter = _g1[_g];
			++_g;
			filter.min = 1;
			filter.max = 0;
			filter.triggered = false;
			if(filter.channels == null) {
				filter.channels = wl_sounds_Channels.both;
			}
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var band = wl_sounds_SoundWL.sampleRate / wl_sounds_SoundWL.FFT_PRECISION;
		if(fft.frequencyLeft == null) {
			return;
		}
		var _g11 = 0;
		var _g2 = fft.frequencyLeft.length;
		while(_g11 < _g2) {
			var i = _g11++;
			var hL = this.historyLeft[i];
			hL.push(fft.frequencyLeft[i] / 255);
			var hR = this.historyRight[i];
			hR.push(fft.frequencyRight[i] / 255);
			while(hL.length > this.historySize) {
				hL.shift();
				hR.shift();
			}
			var sumL = 0;
			var _g21 = 0;
			while(_g21 < hL.length) {
				var v = hL[_g21];
				++_g21;
				sumL += v;
			}
			sumL /= this.historySize;
			var sumR = 0;
			var _g22 = 0;
			while(_g22 < hR.length) {
				var v1 = hR[_g22];
				++_g22;
				sumR += v1;
			}
			sumR /= this.historySize;
			var hz = band * i;
			var _g23 = 0;
			var _g3 = this.filters;
			while(_g23 < _g3.length) {
				var filter1 = _g3[_g23];
				++_g23;
				if(filter1.isolate ? hz >= filter1.lowLimit && hz <= filter1.highLimit : hz > filter1.highLimit || hz < filter1.lowLimit) {
					var sum = filter1.channels == wl_sounds_Channels.both ? (sumL + sumR) / 2 : filter1.channels == wl_sounds_Channels.right ? sumR : sumL;
					filter1.min = filter1.min > sum ? sum : filter1.min;
					filter1.max = filter1.max < sum ? sum : filter1.max;
					filter1.triggered = true;
				}
			}
		}
		var _g4 = 0;
		var _g12 = this.filters;
		while(_g4 < _g12.length) ++_g4;
	}
	,__class__: wl_sounds_SoundAnalyzer
};
var wl_sounds_Channels = { __ename__ : true, __constructs__ : ["left","right","both"] };
wl_sounds_Channels.left = ["left",0];
wl_sounds_Channels.left.toString = $estr;
wl_sounds_Channels.left.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.right = ["right",1];
wl_sounds_Channels.right.toString = $estr;
wl_sounds_Channels.right.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.both = ["both",2];
wl_sounds_Channels.both.toString = $estr;
wl_sounds_Channels.both.__enum__ = wl_sounds_Channels;
var wl_sounds_SoundWL = function() {
	throw new js__$Boot_HaxeError("Sound is static");
};
$hxClasses["wl.sounds.SoundWL"] = wl_sounds_SoundWL;
wl_sounds_SoundWL.__name__ = ["wl","sounds","SoundWL"];
wl_sounds_SoundWL.init = function() {
	wl_sounds_SoundWL.loadMusicFile();
	wl_sounds_SoundWL.context = createjs.Sound.activePlugin.context;
	wl_sounds_SoundWL.sampleRate = createjs.Sound.activePlugin.context.sampleRate;
	wl_sounds_SoundWL.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode;
	wl_sounds_SoundWL.gainNode = createjs.Sound.activePlugin.gainNode;
	if(wl_core_Config.ENABLE_FFT) {
		wl_sounds_SoundWL.initializeFFT();
	}
};
wl_sounds_SoundWL.setVolume = function(volume) {
	wl_sounds_SoundWL.volume = volume;
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.instance.volume = volume;
	}
};
wl_sounds_SoundWL.getPosition = function() {
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.time.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	} else if(wl_sounds_SoundWL.context != null) {
		wl_sounds_SoundWL.time.fromTime((wl_sounds_SoundWL.context.currentTime - wl_sounds_SoundWL.startTime) / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	}
	return wl_sounds_SoundWL.time;
};
wl_sounds_SoundWL.getFFT = function() {
	return wl_sounds_SoundWL.FFT;
};
wl_sounds_SoundWL.updateFFT = function() {
	if(!wl_debug_Debug.paused && (wl_sounds_SoundWL.instance != null || wl_sounds_SoundWL.context != null) && wl_core_Config.ENABLE_FFT && wl_sounds_SoundWL.analyserNodeLeft != null) {
		wl_sounds_SoundWL.analyserNodeLeft.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataLeft);
		wl_sounds_SoundWL.analyserNodeRight.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataRight);
	}
};
wl_sounds_SoundWL.start = function() {
	wl_sounds_SoundWL.instance = createjs.Sound.play("music");
	wl_sounds_SoundWL.instance.on("complete",wl_sounds_SoundWL.handleComplete);
	wl_sounds_SoundWL.instance.volume = wl_core_Config.MUTED ? 0 : wl_sounds_SoundWL.volume;
	if(wl_core_Config.ENABLE_FFT) {
		wl_core_Graphics.instance.onRender.disconnect(wl_sounds_SoundWL.updateFFT);
		wl_core_Graphics.instance.onRender.connect(wl_sounds_SoundWL.updateFFT);
	}
	wl_sounds_SoundWL.onSoundReady.emit();
};
wl_sounds_SoundWL.handleComplete = function() {
	wl_sounds_SoundWL.onSoundComplete.emit();
};
wl_sounds_SoundWL.loadMusicFile = function() {
	var sounds = [{ id : "music", src : wl_core_Config.SONG_PATH}];
	createjs.Sound.alternateExtensions = ["mp3"];
	createjs.Sound.addEventListener("fileload",wl_sounds_SoundWL.handleLoad);
	createjs.Sound.registerSounds(sounds);
};
wl_sounds_SoundWL.initializeFFT = function() {
	var context = wl_sounds_SoundWL.context;
	var fftsize = wl_sounds_SoundWL.FFT_PRECISION;
	if(context != null && $bind(context,context.createAnalyser) != null) {
		var mergerNode = context.createChannelMerger(2);
		wl_sounds_SoundWL.analyserNodeLeft = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeLeft.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeLeft.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.analyserNodeRight = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeRight.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeRight.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.dynamicsCompressorNode.disconnect();
		var splitterNode = context.createChannelSplitter(2);
		wl_sounds_SoundWL.gainNode.disconnect();
		wl_sounds_SoundWL.gainNode.connect(splitterNode);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeLeft,0,0);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeRight,1,0);
		wl_sounds_SoundWL.freqFloatDataLeft = new Float32Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqFloatDataRight = new Float32Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.analyserNodeLeft.connect(mergerNode,0,0);
		wl_sounds_SoundWL.analyserNodeRight.connect(mergerNode,0,1);
		mergerNode.connect(context.destination);
	} else {
		console.log("FFT could not be initialized.");
	}
	wl_sounds_SoundWL.FFT.dbLeft = wl_sounds_SoundWL.freqFloatDataLeft;
	wl_sounds_SoundWL.FFT.frequencyLeft = wl_sounds_SoundWL.freqByteDataLeft;
	wl_sounds_SoundWL.FFT.waveformLeft = wl_sounds_SoundWL.timeByteDataLeft;
	wl_sounds_SoundWL.FFT.dbRight = wl_sounds_SoundWL.freqFloatDataRight;
	wl_sounds_SoundWL.FFT.frequencyRight = wl_sounds_SoundWL.freqByteDataRight;
	wl_sounds_SoundWL.FFT.waveformRight = wl_sounds_SoundWL.timeByteDataRight;
};
wl_sounds_SoundWL.handleLoad = function() {
	wl_sounds_SoundWL.loaded = true;
	wl_sounds_SoundWL.onSoundLoaded.emit();
};
wl_sounds_SoundWL.prototype = {
	__class__: wl_sounds_SoundWL
};
var wl_util_ExtendedMeshBuilder = function() {
};
$hxClasses["wl.util.ExtendedMeshBuilder"] = wl_util_ExtendedMeshBuilder;
wl_util_ExtendedMeshBuilder.__name__ = ["wl","util","ExtendedMeshBuilder"];
wl_util_ExtendedMeshBuilder.BuildRingDisc = function(diameter,innerDiameter,height,scene,tessellation) {
	if(tessellation == null) {
		tessellation = 40;
	}
	var outerdisc = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : diameter, tessellation : tessellation, height : height});
	var innerDisc = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : innerDiameter, tessellation : tessellation, height : height * 2});
	var csg = BABYLON.CSG.FromMesh(outerdisc);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innerDisc));
	var mesh = csg.toMesh("name",null,scene,false);
	outerdisc.dispose();
	innerDisc.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.BuildHollowCube = function(name,options,scene) {
	var outerBox = BABYLON.MeshBuilder.CreateBox(name + "outer",options,null);
	options.size -= options.wallThickness;
	options.width -= options.wallThickness;
	options.height -= options.wallThickness;
	options.depth -= options.wallThickness;
	var innerBox = BABYLON.MeshBuilder.CreateBox(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outerBox);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innerBox));
	return csg.toMesh(name,null,scene,false);
};
wl_util_ExtendedMeshBuilder.CreateTube = function(name,options,scene) {
	var outertube = BABYLON.MeshBuilder.CreateCylinder(name + "outer",options,null);
	options.diameter -= options.wallThickness;
	options.diameterBottom -= options.wallThickness;
	options.diameterTop -= options.wallThickness;
	options.height *= 1.1;
	var innertube = BABYLON.MeshBuilder.CreateCylinder(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outertube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innertube));
	var mesh = csg.toMesh(name,null,scene,false);
	outertube.dispose();
	innertube.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateTrashTube = function(name,options,scene) {
	var targetHeight = options.height;
	var targetDiameter = options.diameter;
	var outertube = BABYLON.MeshBuilder.CreateCylinder(name + "outer",options,null);
	options.diameter -= options.wallThickness;
	options.diameterBottom -= options.wallThickness;
	options.diameterTop -= options.wallThickness;
	options.height *= 1.1;
	var innertube = BABYLON.MeshBuilder.CreateCylinder(name + "inner",options,null);
	var csg = BABYLON.CSG.FromMesh(outertube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(innertube));
	var mesh = csg.toMesh(name,null,scene,false);
	outertube.dispose();
	innertube.dispose();
	mesh.translate(new BABYLON.Vector3(0,1,0),targetHeight / 2);
	var meshes = [];
	meshes.push(mesh);
	var _g1 = 0;
	var _g = targetHeight;
	while(_g1 < _g) {
		var i = _g1++;
		if(wl_util_Random.nextFloat() < 0.5 || i > 250) {
			continue;
		}
		var b = BABYLON.MeshBuilder.CreateBox("",{ width : 40 * wl_util_Random.nextFloat(), size : wl_util_Random.nextFloat() + .25},null);
		meshes.push(b);
		var tmp = options.diameter * wl_util_Random.nextFloat();
		b.position.x = tmp - options.diameter / 2;
		var tmp1 = options.diameter * wl_util_Random.nextFloat() * 0.5;
		var tmp2 = options.diameter * 0.2 * wl_util_Random.nextFloat();
		b.position.z = tmp1 + tmp2;
		b.rotate(new BABYLON.Vector3(0,1,0),wl_util_Random.nextFloat() * Math.PI * 2);
		b.position.y = i;
	}
	var ringplaces = [55,98,151,213,276,320,350,370];
	var ringRadiuses = [targetDiameter - 10,targetDiameter - 11,targetDiameter - 11,targetDiameter - 12,targetDiameter - 11,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12,targetDiameter - 12];
	var _g2 = 0;
	while(_g2 < 8) {
		var i1 = _g2++;
		var cyl = wl_util_ExtendedMeshBuilder.BuildRingDisc(targetDiameter,ringRadiuses[i1],5,null);
		cyl.position.y = ringplaces[i1];
		meshes.push(cyl);
	}
	return BABYLON.Mesh.MergeMeshes(meshes,true);
};
wl_util_ExtendedMeshBuilder.CreateGrate = function(name,options,scene) {
	var box = BABYLON.MeshBuilder.CreateBox("",options);
	box.translate(new BABYLON.Vector3(0,0,1),options.depth / 2);
	box.translate(BABYLON.Vector3.Right(),options.width / 2.0);
	box.bakeCurrentTransformIntoVertices();
	var csg = BABYLON.CSG.FromMesh(box);
	console.log(options.width / 2);
	console.log(options.depth / options.gridSize);
	var _g1 = 0;
	var _g = Math.floor(options.width / options.gridSize);
	while(_g1 < _g) {
		var x = _g1++;
		var _g3 = 0;
		var _g2 = options.depth / options.gridSize;
		while(_g3 < _g2) {
			var holeb = BABYLON.MeshBuilder.CreateBox("",{ width : options.gridSize - options.gridSpacing, depth : options.gridSize - options.gridSpacing, height : options.height * 4});
			holeb.position.x = x * options.gridSize + options.gridSize / 2;
			console.log(holeb.position.x);
			holeb.position.z = _g3++ * options.gridSize + options.gridSize / 2;
			csg.subtractInPlace(BABYLON.CSG.FromMesh(holeb));
			holeb.dispose();
		}
	}
	var mesh = csg.toMesh("",null,null,false);
	mesh.translate(BABYLON.Vector3.Right(),-options.width / 2);
	mesh.bakeCurrentTransformIntoVertices();
	box.dispose();
	return mesh;
};
wl_util_ExtendedMeshBuilder.CreateWindowedTube = function(radius,length,height,tubeMaterial,glowMaterial) {
	var tube = BABYLON.MeshBuilder.CreateTube("",{ path : [new BABYLON.Vector3(0,0,0),new BABYLON.Vector3(0,height,length * 0.05),new BABYLON.Vector3(0,height,length * 0.8),new BABYLON.Vector3(0,height,length * 0.95),new BABYLON.Vector3(0,0,length)], radius : radius},null);
	var cylinder = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : radius, height : length * 0.75});
	cylinder.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
	cylinder.position.y = height + radius;
	cylinder.position.z = length / 2;
	var csg = BABYLON.CSG.FromMesh(tube);
	csg.subtractInPlace(BABYLON.CSG.FromMesh(cylinder));
	var mesh = csg.toMesh("",null,null,false);
	tube.dispose();
	cylinder.dispose();
	var glowstick = BABYLON.MeshBuilder.CreateCylinder("",{ diameter : radius * 1.65, height : length * 0.8},null);
	glowstick.rotate(BABYLON.Vector3.Right(),Math.PI / 2);
	glowstick.position.z = length / 2;
	glowstick.position.y = height;
	glowstick.material = glowMaterial;
	glowstick.parent = mesh;
	mesh.material = tubeMaterial;
	mesh.bakeCurrentTransformIntoVertices();
	glowstick.bakeCurrentTransformIntoVertices();
	mesh.setPivotPoint(new BABYLON.Vector3(0,0,length / 2));
	return mesh;
};
wl_util_ExtendedMeshBuilder.prototype = {
	__class__: wl_util_ExtendedMeshBuilder
};
var wl_util_ExtractPixels = function() {
	throw new js__$Boot_HaxeError("Extract pixels is a static class");
};
$hxClasses["wl.util.ExtractPixels"] = wl_util_ExtractPixels;
wl_util_ExtractPixels.__name__ = ["wl","util","ExtractPixels"];
wl_util_ExtractPixels.extract = function(img,sx,sy,w,h) {
	if(sx == null) {
		sx = 0;
	} else {
		sx = sx;
	}
	if(sy == null) {
		sy = 0;
	} else {
		sy = sy;
	}
	if(w == null) {
		w = img.width;
	} else {
		w = w;
	}
	if(h == null) {
		h = img.height;
	} else {
		h = h;
	}
	var canvas = window.document.createElement("canvas");
	var ctx = canvas.getContext("2d",null);
	canvas.width = w;
	canvas.height = h;
	ctx.drawImage(img,-sx,-sy,w,h);
	return ctx.getImageData(0,0,w,h);
};
wl_util_ExtractPixels.prototype = {
	__class__: wl_util_ExtractPixels
};
var wl_util_LoadManager = $hx_exports["wl"]["util"]["LoadManafer"] = function() {
};
$hxClasses["wl.util.LoadManager"] = wl_util_LoadManager;
wl_util_LoadManager.__name__ = ["wl","util","LoadManager"];
wl_util_LoadManager.get_totalCount = function() {
	return wl_util_LoadManager._totalCount + wl_util_LoadManager.loadersWaiting.length;
};
wl_util_LoadManager.onload = function() {
	wl_util_LoadManager.managerDone = true;
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.checkAllDone = function() {
	if(wl_util_LoadManager.managerDone || wl_util_LoadManager._totalCount == 0 && wl_util_LoadManager.loadersWaiting.length == 0) {
		wl_util_LoadManager.onComplete();
	}
};
wl_util_LoadManager.onerror = function() {
};
wl_util_LoadManager.onprogress = function(s,p,t) {
	console.log(s + "," + p + "," + t);
};
wl_util_LoadManager.addLoader = function(loaderClass) {
	var ldr = Type.createInstance(loaderClass,[wl_util_LoadManager.loadingManager]);
	wl_util_LoadManager._totalCount++;
	return ldr;
};
wl_util_LoadManager.addManualLoader = function(loader) {
	wl_util_LoadManager.loadersWaiting.push(loader);
};
wl_util_LoadManager.manualLoaderComplete = function(loader) {
	HxOverrides.remove(wl_util_LoadManager.loadersWaiting,loader);
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.prototype = {
	__class__: wl_util_LoadManager
};
var wl_util_MathUtil = function() {
};
$hxClasses["wl.util.MathUtil"] = wl_util_MathUtil;
wl_util_MathUtil.__name__ = ["wl","util","MathUtil"];
wl_util_MathUtil.clamp = function(low,high,val) {
	if(val < low) {
		return low;
	} else if(val > high) {
		return high;
	} else {
		return val;
	}
};
wl_util_MathUtil.FromVector3 = function(position,sphereRadius) {
	return [(270 + Math.atan2(position.x,position.z) * 180 / Math.PI) % 360 - 180,90 - Math.acos(position.y / sphereRadius) * 180 / Math.PI];
};
wl_util_MathUtil.componentLerp = function(v1,v2,phase,easex,easey,easez,setTo) {
	if(setTo == null) {
		setTo = new THREE.Vector3();
	} else {
		setTo = setTo;
	}
	setTo.set(easex(1 - phase) * v1.x + easex(phase) * v2.x,easey(1 - phase) * v1.y + easey(phase) * v2.y,easez(1 - phase) * v1.z + easez(phase) * v2.z);
	return setTo;
};
wl_util_MathUtil.prototype = {
	__class__: wl_util_MathUtil
};
var wl_util_Random = function(seed) {
	this.seed = 123;
	this.Init(seed);
};
$hxClasses["wl.util.Random"] = wl_util_Random;
wl_util_Random.__name__ = ["wl","util","Random"];
wl_util_Random.init = function(seed) {
	wl_util_Random.instance.Init(seed);
};
wl_util_Random.next = function() {
	return wl_util_Random.instance.Next();
};
wl_util_Random.nextFloat = function() {
	return wl_util_Random.instance.NextFloat();
};
wl_util_Random.range = function(low,high) {
	return wl_util_Random.instance.Range(low,high);
};
wl_util_Random.prototype = {
	Init: function(seed) {
		this.seed = seed;
	}
	,Next: function() {
		var test = 16807 * Math.floor(this.seed % 127773) - 2836 * Math.floor(this.seed / 127773);
		if(test < 0) {
			test += 2147483647;
		}
		this.seed = test;
		return this.seed;
	}
	,NextFloat: function() {
		return this.Next() / 2147483647;
	}
	,Range: function(low,high) {
		return Math.floor(this.NextFloat() * (high - low) + low);
	}
	,__class__: wl_util_Random
};
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
$hxClasses["Math"] = Math;
String.prototype.__class__ = $hxClasses["String"] = String;
String.__name__ = ["String"];
$hxClasses["Array"] = Array;
Array.__name__ = ["Array"];
var Int = $hxClasses["Int"] = { __name__ : ["Int"]};
var Dynamic = $hxClasses["Dynamic"] = { __name__ : ["Dynamic"]};
var Float = $hxClasses["Float"] = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses["Class"] = { __name__ : ["Class"]};
var Enum = { };
haxe_Resource.content = [{ name : "colorhilight.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gdmVjMiBwaXhlbGFtb3VudDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl1di54ID0gZmxvb3IodXYueCpwaXhlbGFtb3VudC54KS9waXhlbGFtb3VudC54Ow0KCXV2LnkgPSBmbG9vcih1di55KnBpeGVsYW1vdW50LnkpL3BpeGVsYW1vdW50Lnk7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "aspect.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gaW50IHR5cGU7DQp1bmlmb3JtIGZsb2F0IGFzcGVjdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQp1bmlmb3JtIHZlYzQgY29sb3I7DQoNCnZvaWQgbWFpbigpIHsNCglmbG9hdCBtcCA9IDAuMDsNCglmbG9hdCByZXNBc3BlY3QgPSByZXNvbHV0aW9uLngvcmVzb2x1dGlvbi55Ow0KCXZlYzIgdXYgPSB2VXY7DQoJCQ0KCS8vQmxhY2sgbGluZXMgbGVmdCBhbmQgcmlnaHQNCglpZihyZXNBc3BlY3QgPiBhc3BlY3QpDQoJew0KCQlmbG9hdCBkaWYgPSByZXNBc3BlY3QtYXNwZWN0Ow0KCQltcCA9IHV2LnggPiBkaWYvMi4gJiYgdXYueCA8IDEuLWRpZi8yLiA/IDAuIDogMS47DQoJfQ0KCWVsc2UNCgl7DQoJCS8vQmxhY2sgaW5lcyB0b3AgJiBib3R0b20NCgkJZmxvYXQgZGlmID0gYXNwZWN0LXJlc0FzcGVjdDsNCgkJbXAgPSB1di55ID4gZGlmLzIuICYmIHV2LnkgPCAxLi1kaWYvMi4gPyAwLiA6IDEuOw0KCQkNCgl9DQoJDQoJLy9UT0RPIC0gaW4gZmlsbCBjaGFuZ2UgdXYgYWxzby4gDQoJdmVjNCBjID0gbWl4KHRleHR1cmUyRCh0RGlmZnVzZSx1diksIGNvbG9yLG1wKTsNCg0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "aspect.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "colorhilight.frag", data : "dW5pZm9ybSBmbG9hdCByYW5nZTsNCnVuaWZvcm0gZmxvYXQgdmFsdWUxOw0KdW5pZm9ybSBmbG9hdCB2YWx1ZTI7DQp1bmlmb3JtIGZsb2F0IG9yaWdpbmFsOw0KdW5pZm9ybSBmbG9hdCBhbW91bnQ7DQp1bmlmb3JtIHZlYzQgY29sb3IxOw0KdW5pZm9ybSB2ZWM0IGNvbG9yMjsNCnVuaWZvcm0gdmVjMiB0aWxlOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYqdGlsZSk7DQoJDQoJLy9NYWtlIGNvbnRpbnVvdXMgdHJpYW5nbGUgZnVuY3Rpb24NCglmbG9hdCB2YWwxID0gdmFsdWUxKjIuOw0KCXZhbDEgPSB2YWwxIDwgMS4gPyB2YWwxIDogMi4tdmFsMTsNCglmbG9hdCB2YWwyID0gdmFsdWUyKjIuOw0KCXZhbDEgPSB2YWwyIDwgMS4gPyB2YWwyIDogMi4tdmFsMjsNCgkNCglmbG9hdCB0aW1lb2ZmMSA9IG1vZCh2YWwxLCAxLiArIHJhbmdlKTsNCglmbG9hdCB0aW1lb2ZmMiA9IG1vZCh2YWwyLCAxLiArIHJhbmdlKTsNCgkNCglmbG9hdCBtcDEgPSAoYWJzKGMuciAtIHRpbWVvZmYxKSA+IHJhbmdlKSA/IDEuIDogMC47DQoJZmxvYXQgbXAyID0gKGFicyhjLmcgLSB0aW1lb2ZmMikgPiByYW5nZSkgPyAxLiA6IDAuOw0KCQ0KCWZsb2F0IGF2ZyA9IChjLnIrYy5nK2MuYikvMy47DQoJdmVjNCBhZHMxID0gY29sb3IxICogYWJzKGF2ZyAtIHRpbWVvZmYxKTsNCgl2ZWM0IGFkczIgPSBjb2xvcjIgKiBhYnMoYXZnIC0gdGltZW9mZjIpOw0KCQ0KCXZlYzQgY29sID0gKDEuLSBtcDEpICogYWRzMSArICgxLiAtIG1wMikqYWRzMjsNCgkNCglnbF9GcmFnQ29sb3IgPSBjKm9yaWdpbmFsICsgY29sKmFtb3VudDsNCn0NCg"},{ name : "tubewindow.frag", data : "aW4gdmVjMiB2VXY7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCnVuaWZvcm0gZmxvYXQgdGV4U2NhbGU7DQp1bmlmb3JtIHZlYzQgY29sb3I7DQoNCnZvaWQgbWFpbigpIHsNCiAgICAvLyBOb3JtYWxpemVkIHBpeGVsIGNvb3JkaW5hdGVzIChmcm9tIDAgdG8gMSkNCiAgICB2ZWMyIHV2ID0gdlV2Ow0KCXV2LnkgKj0gdGV4U2NhbGU7DQogICAgZmxvYXQgdCA9IC10aW1lLzEwLjsgICAgDQogICAgDQogICAgdmVjMiB1djEgPSB1djsNCiAgICB2ZWMyIHV2MiA9IHV2Ow0KICAgIHZlYzIgdXYzID0gdXY7DQogICAgDQogICAgdXYxLnkgKj0uMTsvLyAodCtzaW4odCt1di54KSkqNC47DQogICAgdXYxLnkrPXQ7DQogICAgDQogICAgdXYyLnkgKj0uMjsvLyAodCtzaW4odCt1di54KSkqNC47DQogICAgdXYyLnkrPXQqLjU7DQogICAgDQogICAgdXYzLnkgKj0uMDU7Ly8gKHQrc2luKHQrdXYueCkpKjQuOw0KICAgIHV2My55Kz10Ki4yNTsgICAgDQogICAgDQogICAgZmxvYXQgczEgPSB0ZXh0dXJlKHREaWZmdXNlLCB1djEpLnI7DQogICAgZmxvYXQgczIgPSB0ZXh0dXJlKHREaWZmdXNlLCB1djIpLnI7DQogICAgZmxvYXQgczMgPSB0ZXh0dXJlKHREaWZmdXNlLCB1djMpLnI7DQogICAgDQogICAgZmxvYXQgcyA9IHNtb290aHN0ZXAoMC41LCAxLjUsczErczIrczMpOyANCiAgICANCiAgICAvLyBPdXRwdXQgdG8gc2NyZWVuDQogICAgZ2xfRnJhZ0NvbG9yID0gdmVjNChzKzAuNSkqY29sb3I7DQp9"},{ name : "rgbshift.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "gray.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSBmbG9hdCBncmF5Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYpOw0KCWZsb2F0IGdyID0gZG90KGMucmdiLCB2ZWMzKDAuMjk5LCAwLjU4NywgMC4xMTQpKTsNCiAgICB2ZWMzIGZjID0gbWl4KGMucmdiLCB2ZWMzKGdyKSwgZ3JheSk7DQoJZ2xfRnJhZ0NvbG9yID12ZWM0KGZjLDEuKTsNCn0NCg"},{ name : "vhs.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgaW50ZW5zaXR5Ow0KdW5pZm9ybSBmbG9hdCBqaXR0ZXI7DQp1bmlmb3JtIGZsb2F0IHNpemU7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHROb2lzZTsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCnVuaWZvcm0gZmxvYXQgaG9sZFRpbWU7DQp1bmlmb3JtIGZsb2F0IGNvbG9yTm9pc2U7DQoNCmZsb2F0IHJhbmQodmVjMiBjbyl7DQogICAgcmV0dXJuIGZyYWN0KHNpbihkb3QoY28ueHkgLHZlYzIoMTIuOTg5OCw3OC4yMzMpKSkgKiA0Mzc1OC41NDUzKTsNCn0NCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJDQoJdXYueCArPSAocmFuZCh2ZWMyKHRpbWUqMC4xLCB1di55KjE5MjAuKSktMC41KSowLjAwOCpqaXR0ZXI7DQoJdXYueSArPSAocmFuZCh2ZWMyKHRpbWUpKS0wLjUpKjAuMDEqaml0dGVyOw0KCQ0KCXZlYzQgYmFzZSA9ICh2ZWM0KC0wLjUpK3ZlYzQocmFuZCh2ZWMyKHV2LnkqMTA4MC4sdGltZSkpLHJhbmQodmVjMigxMDgwLix0aW1lKzEuMCkpLHJhbmQodmVjMigxMDgwLix0aW1lKzIuMCkpLDApKSowLjEqY29sb3JOb2lzZTsNCgliYXNlICs9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgbm9pc2UgPSB0ZXh0dXJlMkQodE5vaXNlLHV2K3ZlYzIodGltZSx0aW1lKjAuMSkpLnI7DQoJDQoJaWYoKG5vaXNlKm1vZCh1di55ICsgaG9sZFRpbWUqMC4yLCAxLikgPiBzaXplKSB8fCANCgkJKG5vaXNlKm1vZCh1di55ICsgKGhvbGRUaW1lKzEuNSkqMC4yLCAxLikgPiBzaXplKSB8fA0KCQkobm9pc2UqbW9kKHV2LnkgKyAoaG9sZFRpbWUrMy4pKjAuMiwgMS4pID4gc2l6ZSkpIGJhc2UrPXZlYzQoMS4pKmludGVuc2l0eTsNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBiYXNlOw0KfQ0K"},{ name : "standard.frag", data : "dW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KdW5pZm9ybSBmbG9hdCBnYW1tYTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCgljID0gcG93KGMsIHZlYzQoMS4wL2dhbW1hKSk7DQoJYys9YnJpZ2h0bmVzczsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ"},{ name : "cga.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgYW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIHZlYzIgcmVzb2x1dGlvbjsNCg0KdW5pZm9ybSB2ZWMzIGNvbG9yc1sxNl07DQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlV2Ow0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgY2xvc2VzdCA9IDk5OTk5LjsNCiAgICB2ZWMzIHNlbGVjdGVkPXZlYzMoMC4pOw0KICAgIGZvcihpbnQgaSA9IDA7IGkgPCAxNjsgaSsrKQ0KICAgIHsNCiAgICAgICAgZmxvYXQgZCA9IGRpc3RhbmNlKGNvbG9yc1tpXSwgYy5yZ2IpOw0KICAgICAgICBpZihjbG9zZXN0ID4gZCkNCiAgICAgICAgew0KICAgICAgICAgCWNsb3Nlc3QgPSBkOw0KICAgICAgICAgICAgc2VsZWN0ZWQgPSBjb2xvcnNbaV07DQogICAgICAgIH0NCiAgICB9DQoJZ2xfRnJhZ0NvbG9yID0gbWl4KGMsdmVjNChzZWxlY3RlZCwxLiksIGFtb3VudCk7DQp9DQo"},{ name : "rgbshift.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgcnNoaWZ0Ow0KdW5pZm9ybSBmbG9hdCBnc2hpZnQ7DQp1bmlmb3JtIGZsb2F0IGJzaGlmdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHZVdik7DQoJZmxvYXQgcm8gPSB0ZXh0dXJlMkQodERpZmZ1c2UsdmVjMih2VXYueC1yc2hpZnQsIHZVdi55KSkucjsNCglmbG9hdCBnbyA9IHRleHR1cmUyRCh0RGlmZnVzZSx2ZWMyKHZVdi54LWdzaGlmdCwgdlV2LnkpKS5nOw0KCWZsb2F0IGJvID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodlV2LngtYnNoaWZ0LCB2VXYueSkpLmI7DQoJZ2xfRnJhZ0NvbG9yID0gdmVjNChybywgZ28sIGJvLCBjLncpOw0KfQ"},{ name : "dof.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ0KICAgIA"},{ name : "gray.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "dof.frag", data : "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"},{ name : "Demo.json", data : "ew0KCSJuYW1lIjogIlN0ZWxsYXIgRXhwbG9yZXIiLA0KCSJ0aW1lbGluZSIgOiBbDQoJCXsNCgkJCSJwYXJ0SWQiOiAiSW50cm8iLA0KCQkJInR5cGUiOiAiaW50cm8uSW50cm8iLA0KCQkJInJlbmRlclRvU2NyZWVuIjogdHJ1ZSwNCgkJCSJydW5PbiI6IFswLDAsMCwwXSwNCgkJCSJydW5PZmYiOiBbMjQsMCwwLDBdLA0KCQkJImV4dHJhIjoiIiwNCgkJCSJmb3JjZU5ld1BhcnQiOiBmYWxzZQ0KCQl9LA0KCQl7DQoJCQkicGFydElkIjogIndlYXBvbiBwcmVwICsgZmlyZSIsDQoJCQkidHlwZSI6ICJzbmFrZXR1bm5lbC5TbmFrZVR1bm5lbCIsDQoJCQkicmVuZGVyVG9TY3JlZW4iOiB0cnVlLA0KCQkJInJ1bk9uIjogWzI0LDAsMCwwXSwNCgkJCSJydW5PZmYiOiBbNDgsMCwwLDBdLA0KCQkJImV4dHJhIjoiIiwNCgkJCSJmb3JjZU5ld1BhcnQiOiBmYWxzZQ0KCQl9LA0KCQl7DQoJCQkicGFydElkIjogImdyZWV0cyIsDQoJCQkidHlwZSI6ICJwb3N0dGVzdC5Qb3N0VGVzdCIsDQoJCQkicmVuZGVyVG9TY3JlZW4iOiB0cnVlLA0KCQkJInJ1bk9uIjogWzQ4LDAsMCwwXSwNCgkJCSJydW5PZmYiOiBbNzIsMCwwLDBdLA0KCQkJImV4dHJhIjoiIiwNCgkJCSJmb3JjZU5ld1BhcnQiOiBmYWxzZQ0KCQl9LA0KCQl7DQoJCQkicGFydElkIjogIndlYXBvbiBwcmVwICsgZmlyZSIsDQoJCQkidHlwZSI6ICJzbmFrZXR1bm5lbC5TbmFrZVR1bm5lbCIsDQoJCQkicmVuZGVyVG9TY3JlZW4iOiB0cnVlLA0KCQkJInJ1bk9uIjogWzcyLDAsMCwwXSwNCgkJCSJydW5PZmYiOiBbODAsMCwwLDBdLA0KCQkJImV4dHJhIjoiIiwNCgkJCSJmb3JjZU5ld1BhcnQiOiBmYWxzZQ0KCQl9DQoJXSwNCgkiYXVkaW8iOiB7DQoJCSJiZWF0c1Blck1pbnV0ZSI6IDEzMywNCgkJImJlYXRzUGVyQmFyIiA6IDQsDQoJCSJ0aWNrc1BlckJlYXQiOiAxMiwNCgkJIm11c2ljQmVnaW4iOiA1MDAsDQoJCSJzb25nUGF0aCI6ICJhc20xOC5vZ2ciLA0KCQkiZW5hYmxlRkZUIjogdHJ1ZQ0KCX0sDQoJInZpc3VhbCI6IHsNCgkJInRhcmdldEZwcyI6IC0xLA0KCQkicmVzb2x1dGlvbiI6IFsxMjgwLDcyMF0sDQoJCSJhbnRpQWxpYXMiOiB0cnVlLA0KCQkiZW5hYmxlU2hhZG93cyI6IHRydWUsDQoJCSJjbGVhckNvbG9yIjogIiMwMDAwMDBmZiIsDQoJCSJzaGFkb3dNYXBTaXplIjpbMjA0OCwyMDQ4XQ0KCX0NCn0"},{ name : "cga.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "simple.vert", data : "YXR0cmlidXRlIHZlYzMgcG9zaXRpb247DQphdHRyaWJ1dGUgdmVjMiB1djsNCg0KI2luY2x1ZGU8aW5zdGFuY2VzRGVjbGFyYXRpb24+DQp1bmlmb3JtIG1hdDQgdmlld1Byb2plY3Rpb247DQoNCm91dCB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCSNpbmNsdWRlPGluc3RhbmNlc1ZlcnRleD4NCgl2ZWMzIHAgPSBwb3NpdGlvbjsNCgl2VXYgPSB1djsNCglnbF9Qb3NpdGlvbiA9IHZpZXdQcm9qZWN0aW9uICogZmluYWxXb3JsZCAqIHZlYzQocG9zaXRpb24sIDEuMCk7DQp9"},{ name : "distortedTv.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "standard.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "displacement.frag", data : "dW5pZm9ybSBmbG9hdCBzY2FsZVg7DQp1bmlmb3JtIGZsb2F0IHNjYWxlWTsNCnVuaWZvcm0gZmxvYXQgem9vbTsNCnVuaWZvcm0gdmVjMiBvZmZzZXQ7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaXNwTWFwOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjZCA9IHRleHR1cmUyRCh0RGlzcE1hcCwodXYrb2Zmc2V0KSp6b29tKTsNCgkNCgkvL2NhbGN1bGF0ZSBvZmZzZXQNCgl2ZWMyIG9mZnNldCA9dmVjMiggY2QuciAqIHNjYWxlWCwgY2QuZypzY2FsZVkpIC0gdmVjMihzY2FsZVgqMC41LHNjYWxlWSowLjUpOw0KCQ0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1ditvZmZzZXQpOw0KCQ0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "distort.frag", data : "I2luY2x1ZGU8aGVscGVyRnVuY3Rpb25zPg0KDQovLyBzYW1wbGVycw0KdW5pZm9ybSBzYW1wbGVyMkQgdGV4dHVyZVNhbXBsZXI7CS8vIG9yaWdpbmFsIGNvbG9yDQoNCi8vIHVuaWZvcm1zDQp1bmlmb3JtIGZsb2F0IGludGVuc2l0eTsNCnVuaWZvcm0gZmxvYXQgaGVpZ2h0Ow0KdW5pZm9ybSBmbG9hdCBvZmZzZXRZOw0KdW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KDQovLyB2YXJ5aW5ncw0KdmFyeWluZyB2ZWMyIHZVVjsNCg0Kdm9pZCBtYWluKHZvaWQpDQp7DQoJdmVjMiB1diA9IHZVVjsNCglmbG9hdCBhZGRWYWwgPSAoc3RlcCgwLjUsbW9kKCh1di55KmhlaWdodCtvZmZzZXRZKSwgMS4wKSktMC41KTsNCgl1di54ICs9IGFkZFZhbCppbnRlbnNpdHk7DQogICAgZ2xfRnJhZ0NvbG9yID0gdGV4dHVyZTJEKHRleHR1cmVTYW1wbGVyLCB1dikrYnJpZ2h0bmVzczsNCn0"},{ name : "distortedTv.frag", data : "dW5pZm9ybSBmbG9hdCBkaXN0b3J0QW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIGZsb2F0IHRpbWU7DQp1bmlmb3JtIGZsb2F0IGdyZWVuYW1wbGlmeTsNCnVuaWZvcm0gZmxvYXQgYmx1ZWFtcGxpZnk7DQp1bmlmb3JtIGZsb2F0IHZpZ25BbW91bnQ7DQp1bmlmb3JtIGZsb2F0IG9mZnNldEFtb3VudDsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TXVsdGlwbGllcjsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TGltaXQ7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKQ0Kew0KCXZlYzIgdXYgPSB2VXY7DQogICAgZmxvYXQgb2Zmc2V0ID0gbW9kKGNlaWwodXYueSpkaXN0b3J0QW1vdW50K3RpbWUpKnRpbWUsMC4wMTIpOw0KICAgIHZlYzQgdENvbG9yID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodXYueCtvZmZzZXRBbW91bnQqb2Zmc2V0LHV2LnkpKTsNCiAgICB0Q29sb3IuZyAqPSBncmVlbmFtcGxpZnk7DQogICAgdENvbG9yLmIgKj0gYmx1ZWFtcGxpZnk7DQogICAgZmxvYXQgdmlnbiA9IDEuMC1sZW5ndGgodmVjMigwLjUsMC41KS11dikqdmlnbkFtb3VudDsNCiAgICANCgl2ZWMzIGJyaWdodG5lc3MgPSB0Q29sb3IucmdiOw0KCXZlYzMgbXAgPSB2ZWMzKDEuKS1zbW9vdGhzdGVwKHZlYzMoYnJpZ2h0TGltaXQpLCB2ZWMzKDEuKSwgYnJpZ2h0bmVzcykqYnJpZ2h0TXVsdGlwbGllcjsNCgl0Q29sb3IqPXZlYzQobXAsMS4pOw0KCQ0KICAgIHRDb2xvciAqPSB2aWduOw0KCWdsX0ZyYWdDb2xvciA9IHRDb2xvcjsNCn0"},{ name : "displacement.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "vhs.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"}];
var __map_reserved = {}
var ArrayBuffer = $global.ArrayBuffer || js_html_compat_ArrayBuffer;
if(ArrayBuffer.prototype.slice == null) {
	ArrayBuffer.prototype.slice = js_html_compat_ArrayBuffer.sliceImpl;
}
var Float32Array = $global.Float32Array || js_html_compat_Float32Array._new;
var Uint8Array = $global.Uint8Array || js_html_compat_Uint8Array._new;
DemoMain.DEMO_READY = new wl_core_Signal();
DemoMain.HILIGHT = BABYLON.Color3.FromHexString("#E84113");
DemoMain.LIGHT = BABYLON.Color3.FromHexString("#E8C47B");
DemoMain.GROUND = BABYLON.Color3.FromHexString("#FFB44B");
DemoMain.BLUE = BABYLON.Color3.FromHexString("#8DDFFF");
DemoMain.BLUE_DARK = BABYLON.Color3.FromHexString("#2598FF");
DemoMain.WHITE = BABYLON.Color3.FromHexString("#FFFFFF");
DemoMain.BLACK = BABYLON.Color3.FromHexString("#000000");
DemoMain.historyind = 0;
haxe_crypto_Base64.CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
haxe_crypto_Base64.BYTES = haxe_io_Bytes.ofString(haxe_crypto_Base64.CHARS);
haxe_ds_ObjectMap.count = 0;
js_Boot.__toStr = ({ }).toString;
js_html_compat_Float32Array.BYTES_PER_ELEMENT = 4;
js_html_compat_Uint8Array.BYTES_PER_ELEMENT = 1;
snaketunnel_Tower.SLICEHEIGHT = 1.0;
snaketunnel_Tower.DIAMETER = 3;
snaketunnel_Tower.generatedLights = 0;
snaketunnel_Tower.colors = [new BABYLON.Color3(1,0,0),new BABYLON.Color3(0,1,0),new BABYLON.Color3(0,0,1)];
washers_Tower.SLICEHEIGHT = 0.2;
wl_core_Assets._assets = new haxe_ds_StringMap();
wl_core_Config.BEATS_PER_MINUTE = 104;
wl_core_Config.BEATS_PER_BAR = 4;
wl_core_Config.TICKS_PER_BEAT = 12;
wl_core_Config.MUSIC_BEGIN = 500;
wl_core_Config.SONG_PATH = "bg.ogg";
wl_core_Config.ENABLE_FFT = false;
wl_core_Config.MUTED = false;
wl_core_Config.FPS = 24;
wl_core_Config.RESOLUTION = [1280,720];
wl_core_Config.RATIO = 1.7777777777777777;
wl_core_Config.ANTIALIAS = true;
wl_core_Config.ENABLE_SHADOWS = false;
wl_core_Config.CLEAR_COLOR = new BABYLON.Color4(0.0,0.0,0.0);
wl_core_Config.SHADOW_MAP_SIZE = [512,512];
wl_core_Config.SEED = 123;
wl_core_Config.DEBUG = false;
wl_core_Config.TIMELINE = [];
wl_core_TimeSig.ABSOLUTE = "absolute";
wl_core_TimeSig.RELATIVE = "relative";
wl_core_TimeSig.PATTERN = "pattern";
wl_debug_Debug.paused = false;
wl_debug_Debug.usedFolderNames = [];
wl_debug_ManualControl.parts = [];
wl_debug_ManualControl.storedPoints = [];
wl_demo_CameraController.STOPPED = false;
wl_demo_CameraController.STATIC = "static";
wl_demo_CameraController.LINEAR = "linear";
wl_demo_CameraController.BEZIER = "bezier";
wl_demo_CameraController.FOLLOW = "follow";
wl_sounds_SoundWL.FFT_PRECISION = 1024;
wl_sounds_SoundWL.onSoundLoaded = new wl_core_Signal();
wl_sounds_SoundWL.onSoundComplete = new wl_core_Signal();
wl_sounds_SoundWL.onSoundReady = new wl_core_Signal();
wl_sounds_SoundWL.time = new wl_core_TimeSig();
wl_sounds_SoundWL.volume = 1;
wl_sounds_SoundWL.startTime = 0;
wl_sounds_SoundWL.loaded = false;
wl_sounds_SoundWL.lastFFT = 0;
wl_sounds_SoundWL.FFT = { dbLeft : null, frequencyLeft : null, waveformLeft : null, dbRight : null, frequencyRight : null, waveformRight : null, fftsize : 1024, sampleRate : 44100};
wl_util_LoadManager._totalCount = 0;
wl_util_LoadManager.loadersWaiting = [];
wl_util_LoadManager.managerDone = false;
wl_util_Random.instance = new wl_util_Random(123);
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
