var Text = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(4);
    var paragraphs = [
        "FLASHBACKS",
        "by",
        "Paraguay"
    ];

    this.teksti = this.createText(paragraphs);
    this.scene.add(this.teksti);
    this.createSurroundings();
};

Text.prototype = PartBase.prototype.inheritance();

Text.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);
};

Text.prototype.createText = function(paragraphs){

    var texts = new THREE.Object3D();
  
    var material = [
        new THREE.MeshBasicMaterial( { color: 0x8F8FBC } ),
        new THREE.MeshBasicMaterial( { color: 0xF8F8FF } )
    ];

    var options = {
        font: TDEMO.font,
        size: 70,
        height: 25,
        curveSegments: 12,
        bevelEnabled: true,
        bevelThickness: 10,
        bevelSize: 8,
        bevelSegments: 5
    };

    var rowHeight = 90;
    var yPos = 90;
    var zPos = -200;

    for(var i = 0; i < paragraphs.length; ++i){
        var geometry = new THREE.TextGeometry(paragraphs[i], options);
        geometry.computeBoundingBox();
        geometry.computeVertexNormals();
        var centerOffset = -0.5*(geometry.boundingBox.max.x-geometry.boundingBox.min.x);
        
        var mesh = new THREE.Mesh(geometry, material);
        mesh.position.x = centerOffset;
        mesh.position.y = yPos - rowHeight*i;
        mesh.position.z = zPos*i;

        texts.add(mesh);
    }
    return texts;
};

Text.prototype.createSurroundings = function(){

    this.scene.fog = new THREE.Fog(0x5D478B, 200, 600);
    var material = new THREE.MeshStandardMaterial({
        color : 0xCDCCFF,
        side : THREE.BackSide
    });
    this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(800, 64, 64), material);
    this.scene.add(this.skySphere);
}
