var Lines = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setHorizontalBlur(8);
    this.setVerticalBlur(8);
    this.setEdgeDetection();
    this.setBloom(10);

    this.createSurroundings();

    this.lines = new THREE.Object3D();
    this.lineMaterial = new THREE.LineBasicMaterial({ color: 0xFFFFFF});
    this.lineMaterial2 = new THREE.LineBasicMaterial({ color: 0xBA55D3});

    this.lsystem = new LSYSTEM();

    this.lsystem.interpret(9, 90, "FrFrFruFuFuFulFlFl","FuFrFFtFrFlF", 4);
    this.lsystem.moveToCenter();

    this.line = this.lsystem.createLine(this.lineMaterial);
    this.line.position.x = 10;
    this.lines.add(this.line);


    this.line2 = new THREE.Line(this.line.geometry, this.lineMaterial2);
    this.line2.position.x = -10;
    this.lines.add(this.line2);

    this.lines.position.z = this.lsystem.center.z;
    this.scene.add(this.lines);
};

Lines.prototype = PartBase.prototype.inheritance();

Lines.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta, true);

    var lp = TDEMO.SYNC.getObjRotation();
    this.line.rotation.x = lp.x;
    this.line.rotation.y = lp.y;
    this.line.rotation.z = lp.z;

    this.line2.rotation.x = -lp.x;
    this.line2.rotation.y = -lp.y;
    this.line2.rotation.z = -lp.z;
};

Lines.prototype.createSurroundings = function(){

    this.scene.fog = new THREE.Fog(0x5D478B, 200, 800);
    var material = new THREE.MeshStandardMaterial({
        color : 0xCDCCFF,
        side : THREE.BackSide
    });
    this.skySphere = new THREE.Mesh(new THREE.SphereGeometry(800, 64, 64), material);
    this.scene.add(this.skySphere);
}
