var Rainbow = function(size, texture) {
  this.rainbowObj = new THREE.Object3D();

  var ringGeom;
  var ringsystem;
  var particleAmount = 2000;
  var colors = [0xff0000, 0xFF7F00, 0xffff00, 0x00ff00, 0x0000ff, 0x4B0082, 0x8B00FF];
  var outers = [300, 275, 250, 230, 210, 195, 182];
  this.rings = [];
  this.texture = texture;
  
  for (var i = 0; i<colors.length; i++) {
    if (outers[i] > 210) inner = 30;
    else inner = 20;
    ringGeom = this.createRing(outers[i],inner,particleAmount);
    var ring = new THREE.Points( ringGeom, new THREE.PointsMaterial({color: colors[i], size : size, map : this.texture}));
    this.rainbowObj.add(ring);
    this.rings.push(ring);
  }
}


Rainbow.prototype.createRing = function(outer, inner, particleAmount){
  var geom = new THREE.Geometry();

  for(i=5; i<=particleAmount; i++) {

    var p = new THREE.Vector3();

    p.x = Math.sin(i) * outer + Math.random() * inner;
    p.y = Math.cos(i) * outer + Math.random() * inner;
    p.z = Math.sin(i) * outer + Math.random() * inner;

    geom.vertices.push( p );
  }

  //console.log(geom);
  return geom;
}
