import QtQuick 2.3
import "."
import AdaptDemoSystem 1.0

// handle storing of the previous blurred version of the scene
// for shaders using the ultimate fake GI with g_prevBlurAmount
Group {
    name: "prevblur"
    effectName: "PrevBlur"
    enabled: syncRoot(name+".ON")

    Blit { textureRT: "depth"; blitRT: 1 }
    Blit { textureRT: "prev" }
    Blur {}
    Blit { textureRT: "prevBlur" }

    RenderTarget {
        RenderTargetLayer {
            textureRT: "prevNormal"
            format: "RGBA32F"
            width: demo.windowWidth
            height: demo.windowHeight
        }
        Texture {
            textureUnit: 0
            textureRT: "mainDepth"
        }
        Shader {
            file: "fx/_SharedQML/drawRtTexel"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }
    }

//    RenderTarget {
//        RenderTargetLayer {
//            textureRT: "prevDepth"
//            format: "RGBA32F"
//            width: demo.windowWidth
//            height: demo.windowHeight
//        }
//        Texture {
//            textureUnit: 0
//            textureRT: "mainDepth"
//        }
//        Shader {
//            file: "fx/_SharedQML/drawRtTexel"
//        }
//        DrawVB {
//            type: "quad"
//            depthTest: false
//            depthWrite: false
//            ShaderParam {
//                paramName: "flip"
//                paramValue: 1.0
//            }
//            blendMode: "off"
//        }
//    }

//    Group {
//        enabled: sync("camera.autoMove.ON") && sync("camera.autoMove.gain") > 0.0
//        RenderTarget {
//            RenderTargetLayer {
//                textureRT: "areaPositions"
//                format: "RGBA32F"
//                width: 256
//                height: 256
//            }
//            Texture {
//                textureUnit: 0
//                textureRT: "mainDepth"
//            }
//            Shader {
//                file: "fx/_SharedQML/areaPositions"
//            }
//            DrawVB {
//                type: "quad"
//                depthTest: false
//                depthWrite: false
//                ShaderParam { paramName: "flip"; paramValue: 1.0 }
//                ShaderParam { paramName: "g_maxZ"; paramValue: sync("camera.autoMove.maxZ") }
//                ShaderParam { paramName: "g_powZ"; paramValue: sync("camera.autoMove.powZ") }
//                ShaderParam { paramName: "g_gain"; paramValueVec4: sync("camera.autoMove.gain")+","+sync("camera.autoMove.gainX")+","+sync("camera.autoMove.gainY")+","+sync("camera.autoMove.gainZ") }
//                ShaderParam { paramName: "g_destW"; paramValue: 256 }
//                ShaderParam { paramName: "g_destH"; paramValue: 256 }
//                blendMode: "off"
//            }
//        }
//     }
//        Average {
//            enabled: sync("camera.autoMove.ON") && sync("camera.autoMove.gain") > 0.0
//            id: averagePosition
//            textureRT: "areaPositions"
//        }
//  //  }

//    function hasAvgPos() {
//        if (averagePosition.getZ() > -999000.0) {
//            return true;
//        }
//        return false;
//    }

//    function getAvgPosX() {
//        if (hasAvgPos()) {
//            return averagePosition.getX();
//        }
//        return 0.0;
//    }
//    function getAvgPosY() {
//        if (hasAvgPos()) {
//            return averagePosition.getY();
//        }
//        return 0.0;
//    }
//    function getAvgPosZ() {
//        if (hasAvgPos()) {
//            return averagePosition.getZ();
//        }
//        return 0.0;
//    }

    BlurRt {
        textureRT: "prevNormal"
    }

    Texture {
        textureUnit: 0
        textureRT: "prev"
    }
    Shader {
        file: "fx/_SharedQML/drawRt"
    }

    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        ShaderParam {
            paramName: "flip"
            paramValue: 1.0
        }
        ShaderParam { paramName: "g_overlayScale"; paramValue: 1.0 }
        blendMode: "off"
    }

}

