import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    // generic mesh just named box :)
    id: box
    name: "box"
    property string shader: "smBreakIn"
    enabled: syncRoot(box.name+".ON");

    property string particlesName: "part"
    property bool clearParticleEmits: true


    VariClockTrigger {
        id: animFrame
        clockSpeed: sync(box.name+".anim.FPS", 0.0)
        reset: syncTrigger(box.name+".anim.reset")
    }
    property real animFramesPerRow: sync(box.name+".anim.framesPerRow", 1.0)
    property int animFrames: Math.max(1.0, sync(box.name+".anim.frames", 1.0))
    property int animFrameInt: (animFrame.time.toFixed(0)/animFrames-Math.floor(animFrame.time.toFixed(0)/animFrames))*(animFrames-1)
    property real animFrameUVX: (animFrameInt/animFramesPerRow-Math.floor(animFrameInt/animFramesPerRow))*animFramesPerRow*sync(box.name+".anim.width", 1.0/6.0)
    property real animFrameUVY: Math.floor(animFrameInt/animFramesPerRow)*animHeight

    property real animHeight: sync(box.name+".anim.height", 1.0/6.0)

    property real uvScale: presets.get("uvScale") //sync(box.name+".uvScale", 1.0);


    ShaderAtomicCounter { name: particlesName+"sacVortex1"; clear: clearParticleEmits }
    Texture { textureUnit: 0; imageUnit: 0; textureRT: particlesName+"emitVortexPartPos" }
    Texture { textureUnit: 1; imageUnit: 1; textureRT: particlesName+"emitVortexPartVel" }
    Texture { textureUnit: 2; imageUnit: 2; textureRT: particlesName+"emitVortexPartCol" }


    Texture { textureUnit: 3; textureRT: "prev" }
    Texture { textureUnit: 4; textureRT: "prevBlur" }
    Texture { textureUnit: 5; textureRT: "prevNormal" }

    BreakinPresets { id: presets; effectName: box.name }

    TextureSel { textureUnit: 0; name: box.name; selPresets: presets }
    TextureSel { textureUnit: 1; name: box.name; selPresets: presets }


    property alias autoCenter: meshInst.autoCenter
    property alias autoScale: meshInst.autoScale

    property string shaderVaryings: "vec3 posG;"

    property int instCount: presets.get("num")

    Shader { file: shader }

    DrawVB { // actually don't draw, just generate the vbo for instanced drawing below..
        enabled: true
        type: "pointGrid"
        vboId: sceneName+"_breakIn"
        tfVaryings: shaderVaryings
        gridWidth: 1000
        gridHeight: 500
        drawNumPoints: 0
    }

    Shader { file: shader }
    DrawMesh {
        id: meshInst
        property string name: box.name
        file: meshSelPresets(box.name, presets)
        property string kikkare: file
        depthTest: presets.get("depthEnabled") > 0.5
        depthWrite: presets.get("depthEnabled") > 0.5
        blendMode: blendSelPresets(box.name, presets)
        autoCenter: false
        autoScale: false
        instanceVBO: sceneName+"_breakIn"
        instanceCount: instCount
        property int kikkare2: instanceCount

        onKikkareChanged: {
           console.log("file:"+kikkare);
        }

        onKikkare2Changed: {
            console.log("instanceCount:"+kikkare2)
        }

        tfVaryings: shaderVaryings

        smoothNormals: true; normalSmoothAngle: 60;

        property real sca: presets.get("scale")
        property real scaX: sync(box.name+".scaleX", 1.0)
        property real scaZ: presets.get("scaleZ")

        Sca { s: meshInst.sca; x: meshInst.scaX; y: 1.0; z: meshInst.scaZ }

        property real posX: presets.get("x")
        property real posY: presets.get("y")
        property real posZ: presets.get("z")

        ShaderParam { paramName: "g_texBrightness"; paramValue: presets.get("bright") }
        ShaderParam { paramName: "g_texAmbient"; paramValue: presets.get("ambient") }
//        ShaderParam { paramName: "g_uvScale"; paramValue: uvScale }
        ShaderParam { paramName: "g_uvScale"; paramValueVec4: (uvScale*sync(box.name+".uvScaleX", 1.0))+","+(uvScale*sync(box.name+".uvScaleY", 1.0))}

        ShaderParam { paramName: "g_uvOfsX"; paramValue: sync(box.name+".uvOfsX", 0.0)+animFrameUVX }
        ShaderParam { paramName: "g_uvOfsY"; paramValue: sync(box.name+".uvOfsY", 0.0)+animFrameUVY }

        ShaderParam { paramName: "g_animHeight"; paramValue: animHeight }



        ShaderParam { paramName: "g_uvRandom"; paramValueVec4: presets.get("uvRandom")+","+presets.get("uvScaleMin")+","+presets.get("uvScaleMax") }
        ShaderParam { paramName: "g_uvOfsRand"; paramValueVec4: presets.get("uvOfsXRand")+","+presets.get("uvOfsYRand")+",0.0" }
        ShaderParam { paramName: "g_prevBlurAmount"; paramValue: presets.get("prevBlur") }
        ShaderParam { paramName: "g_prevBlurType"; paramValue: presets.get("prevBlurType") }
        ShaderParam { paramName: "g_bump"; paramValue: presets.get("bump") }
        ShaderParam { paramName: "g_genUV"; paramValue: presets.get("genUV") }
        ShaderParam { paramName: "g_alpha"; paramValue: presets.get("alpha") }

        ShaderParam { paramName: "g_emitThr"; paramValue: presets.get("emitThr") }
        ShaderParam { paramName: "g_emitAmp"; paramValue: presets.get("emitAmp") }

        ShaderParam { paramName: "g_pos"; paramValueVec4: meshInst.posX+","+meshInst.posY+","+meshInst.posZ }
        ShaderParam { paramName: "g_cen"; paramValueVec4: presets.get("cenX")+","+ presets.get("cenY")+","+ presets.get("cenZ") }
        ShaderParam { paramName: "g_rot"; paramValueVec4: presets.get("rotX")+","+presets.get("rotY")+","+presets.get("rotZ") }
        ShaderParam { paramName: "g_rotDel"; paramValueVec4: presets.get("rotXDel")+","+presets.get("rotYDel")+","+presets.get("rotZDel") }

        ShaderParam { paramName: "g_rotSingle"; paramValueVec4: presets.get("rotSingleX")+","+presets.get("rotSingleY")+","+presets.get("rotSingleZ") }
        ShaderParam { paramName: "g_centroAmpFreq"; paramValueVec4: presets.get("radAmp")+","+presets.get("radAmpIn")+","+presets.get("radFreq")+","+presets.get("radFreqIn") }

        ShaderParam { paramName: "g_centroOfs"; paramValue:  presets.get("radOfs") }
        ShaderParam { paramName: "g_radRotDel"; paramValue: presets.get("radRotDel") }
        ShaderParam { paramName: "g_radDel"; paramValue:  presets.get("radDel") }

        ShaderParam { paramName: "g_delOfs"; paramValue:  presets.get("delOfs") }

        ShaderParam { paramName: "g_emitPercent"; paramValue: presets.get("emitPercent") }
        ShaderParam { paramName: "g_vortexAngSpeed"; paramValue: presets.get("emitAngSpd") }
        ShaderParam { paramName: "g_emitVelX"; paramValue: presets.get("emitVel.x") }
        ShaderParam { paramName: "g_emitVelY"; paramValue: presets.get("emitVel.y") }
        ShaderParam { paramName: "g_emitVelZ"; paramValue: presets.get("emitVel.z") }
        ShaderParam { paramName: "g_emitColorThr"; paramValue: presets.get("emitColThr") }
        ShaderParam { paramName: "g_emitGrayness"; paramValue: presets.get("emitGrayness") }

        ShaderParam { paramName: "g_globalRot"; paramValueVec4: presets.get("globalRotX")+","+presets.get("globalRotY")+","+presets.get("globalRotZ") }
        ShaderParam { paramName: "g_globalScale"; paramValueVec4: presets.get("globalScale")+",0.0,0.0,0.0" }

        ShaderParam { paramName: "g_mirrorX"; paramValueVec4: presets.get("mirrorX")+","+presets.get("mirrorXPos")+","+presets.get("mirrorXClip")+",0.0" }
        ShaderParam { paramName: "g_mirrorY"; paramValueVec4: presets.get("mirrorY")+","+presets.get("mirrorYPos")+","+presets.get("mirrorYClip")+",0.0" }
        ShaderParam { paramName: "g_mirrorZ"; paramValueVec4: presets.get("mirrorZ")+","+presets.get("mirrorZPos")+","+presets.get("mirrorZClip")+",0.0" }

        ShaderParam { paramName: "g_circularCen"; paramValueVec4: presets.get("circCenX")+","+presets.get("circCenY")+","+presets.get("circCenZ")+",0.0" }
        ShaderParam { paramName: "g_circularDist"; paramValueVec4: presets.get("circDistX")+","+presets.get("circDistY")+","+presets.get("circDistZ")+",0.0" }
        ShaderParam { paramName: "g_circularRot"; paramValueVec4: presets.get("circRotX")+","+presets.get("circRotY")+","+presets.get("circRotZ")+",0.0" }

        SavePoint {
            target: box.name+"_SP"
            x: meshInst.posX+presets.get("spx")/meshInst.sca; y: meshInst.posY/meshInst.sca+presets.get("spy"); z: meshInst.posZ/(meshInst.sca*meshInst.scaZ)+presets.get("spz");
        }

    }



}


