import QtQuick 2.3
import AdaptDemoSystem 1.0

Group {
    id: blur
    name: "blurRt"
    effectName: "BlurRt"
    enabled: syncRoot(name+".ON")
    property string shader: "fx/_SharedQML/blur"
    property string textureRT

    property string textureWrap: "clamp"

    property real posX: 0.0
    property real posY: 0.0

    RenderTarget {
        RenderTargetLayer {
            textureRT: "blurBuffer1"
            format: "RGBA32F"
            width: demo.windowWidth
            height: demo.windowHeight
//            Clear {
//                cR: 1.0; cG: 0.0; cB: 0.0; cA: 1.0;
//            }
        }
        Texture {
            textureUnit: 0
            textureRT: blur.textureRT
        }
        Shader {
            file: "fx/_SharedQML/drawRtTexel"
        }
        DrawVB {
            type: "quad"
            depthTest: false
            depthWrite: false
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            blendMode: "off"
        }
    }

    Repeater {
        model: sync(blur.name+".blurLoops")
        delegate: Group {

//            Blit {
//                textureRT: index===0 ? "screenBuffer" : "screenBuffer"
//                blitRT: 0
//            }

            RenderTarget {
                RenderTargetLayer {
                    textureRT: index===0 ? "blurBuffer2" : "blurBuffer1"
                    format: "RGBA32F"
                    width: demo.windowWidth
                    height: demo.windowHeight
                }
                Texture {
                    textureUnit: 0
                    textureRT: index===0 ? "blurBuffer1" : "blurBuffer2"
                    textureWrap: blur.textureWrap
                }
                Shader {
                    file: shader
                    ShaderParam {
                        paramName: "g_blurStrength"
                        property real strengthAddPerLoop: sync(blur.name+".strength.addPerLoop")
                        paramValue: sync(blur.name+".strength")*(1.0+index*strengthAddPerLoop)
                    }
                    ShaderParam { paramName: "g_screenSize"; paramValue: sync(blur.name+".screenSize") }
                    ShaderParam { paramName: "g_readSize"; paramValue: index===0 ? 1.0 : sync(blur.name+".screenSize") }
                    // ShaderParam { paramName: "g_readSize"; paramValue: index===0 ? 1.0 : 1.0 }
                }
                DrawVB {
                    type: "quad"
                    depthTest: false
                    depthWrite: false
                    blendMode: "off"
                    drawBuffers: 1
                }
            }


        }
    }

//    Blit {
//        textureRT: "screenBuffer"
//        blitRT: 0
//    }

    RenderTarget {
        RenderTargetLayer {
            textureRT: blur.textureRT
            format: "RGBA32F"
            width: demo.windowWidth
            height: demo.windowHeight
//            Clear {
//                cR: 1.0; cG: 0.0; cB: 0.0; cA: 1.0;
//            }
        }
        // mix original and result
        Shader {
            file: "fx/_SharedQML/drawRt"
        }
        Texture {
            textureUnit: 0
            textureRT: (sync(blur.name+".blurLoops")&1) === 0 ? "blurBuffer2" : "blurBuffer1"
        }
        DrawVB {
            ShaderParam {
                paramName: "flip"
                paramValue: 1.0
            }
            ShaderParam {
                paramName: "overlayAlpha"
                paramValue: 1.0
            }
            ShaderParam {
                paramName: "g_origAmount"
                paramValue: 1.0
            }
            ShaderParam { paramName: "g_overlayScale"; paramValue: sync(blur.name+".screenSize") }
            type: "quad"
            depthTest: false
            depthWrite: false
            blendMode: "off"
            drawBuffers: 1
        }
    }


}
