import QtQuick 2.3

Item {
    id: shadowText
    property string text
    width: windowWidth
    height: mainText.height
    property int contentHeight: mainText.height
    property real ofs: 1.0
    property real opac: 1.0
    property real ofsY: 0.0
    property int pixelSize: 16
    property int edgeMargin: 10
   // anchors.fill: parent
   // anchors.verticalCenter: parent.verticalCenter
    anchors.horizontalCenter : parent.horizontalCenter

    property real ofsX: 100.0

//    FontLoader {
//        name: "Expansiva"
//        source: "../images/expansiva/Expansiva.otf"
//    }

 //   property alias wrapMode: textu.wrapMode
    Text {
        id: textu
        x: shadowText.ofs+ofsX
        y: shadowText.ofs+ofsY*contentHeight
        opacity: shadowText.opac
        font.pixelSize: shadowText.pixelSize
        color: "black"
      //  font.family: "Expansiva"
        text: shadowText.text
        width: (1280.0-edgeMargin)*(windowWidth/1280.0)
        wrapMode: Text.WordWrap
        textFormat: Text.RichText
        antialiasing: true
        smooth: true
        anchors.horizontalCenter : parent.horizontalCenter
    }
    Text {
        id: mainText
        x: ofsX
        y: ofsY*contentHeight
        font.pixelSize: shadowText.pixelSize
        color: "white"
        text: shadowText.text
        antialiasing: true
        smooth: true
        width: (1280.0-edgeMargin)*(windowWidth/1280.0)
        anchors.horizontalCenter : parent.horizontalCenter
      //  font.family: "Expansiva"
        textFormat: Text.RichText
        wrapMode: Text.WordWrap
    }
}

