/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

class TrackKey
implements Comparable<TrackKey> {
    private int row;
    private float value;
    private KeyType keyType;

    public TrackKey(int row, float value, KeyType keyType) {
        this.row = row;
        this.value = value;
        this.keyType = keyType;
    }

    public TrackKey(int row, float value, int keyType) {
        this(row, value, KeyType.values()[keyType]);
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public void setKeyType(KeyType keyType) {
        this.keyType = keyType;
    }

    @Override
    public int compareTo(TrackKey other) {
        return this.row > other.row ? 1 : (this.row < other.row ? -1 : 0);
    }

    public String toString() {
        return String.format("TrackKey(row=%d value=%f type=%s)", new Object[]{this.row, Float.valueOf(this.value), this.keyType});
    }

    public static double interpolate(TrackKey first, TrackKey second, double row) {
        double t = (row - (double)first.row) / (double)(second.row - first.row);
        switch (first.keyType) {
            case STEP: {
                return first.value;
            }
            case SMOOTH: {
                t = t * t * (3.0 - 2.0 * t);
                break;
            }
            case RAMP: {
                t = Math.pow(t, 2.0);
                break;
            }
        }
        return (double)first.value + (double)(second.value - first.value) * t;
    }

    public static enum KeyType {
        STEP,
        LINEAR,
        SMOOTH,
        RAMP;

    }
}

