/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import moonlander.library.Track;
import moonlander.library.TrackContainerListener;

class TrackContainer {
    private LinkedHashMap<String, Track> tracks = new LinkedHashMap();
    private ArrayList<TrackContainerListener> listeners = new ArrayList();

    public void addEventListener(TrackContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(TrackContainerListener listener) {
        this.listeners.remove(listener);
    }

    public Track get(String name) {
        return this.tracks.get(name);
    }

    public Track getById(int id) {
        return new ArrayList<Track>(this.tracks.values()).get(id);
    }

    public Track getOrCreate(String name) {
        Track track = this.get(name);
        if (track == null) {
            track = new Track(name);
            this.tracks.put(name, track);
            for (TrackContainerListener l : this.listeners) {
                l.trackAdded(name);
            }
        }
        return track;
    }

    public void delete(String name) {
        if (this.tracks.get(name) != null) {
            this.tracks.remove(name);
            for (TrackContainerListener l : this.listeners) {
                l.trackDeleted(name);
            }
        }
    }

    public List<Track> getAll() {
        return Collections.unmodifiableList(new ArrayList<Track>(this.tracks.values()));
    }
}

