/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import moonlander.library.Connector;
import moonlander.library.Controller;
import moonlander.library.MinimController;
import moonlander.library.ProjectFileConnector;
import moonlander.library.SocketConnector;
import moonlander.library.Track;
import moonlander.library.TrackContainer;
import processing.core.PApplet;

public class Moonlander {
    public static final String VERSION = "##library.prettyVersion##";
    PApplet parent;
    private TrackContainer tracks;
    private Connector connector;
    private Controller controller;
    private static Logger logger = Logger.getLogger("moonlander.library");

    public Moonlander(PApplet parent, Controller controller) {
        this.setupLogging(Level.INFO);
        this.tracks = new TrackContainer();
        this.parent = parent;
        this.controller = controller;
    }

    public static Moonlander initWithSoundtrack(PApplet applet, String filename, int beatsPerMinute, int rowsPerBeat) {
        Minim minim = new Minim((Object)applet);
        AudioPlayer song = minim.loadFile(filename, 1024);
        return new Moonlander(applet, new MinimController(song, beatsPerMinute, rowsPerBeat));
    }

    private void setupLogging(Level logLevel) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINEST);
        logger.setUseParentHandlers(false);
        logger.addHandler(handler);
        logger.setLevel(logLevel);
    }

    public void changeLogLevel(Level logLevel) {
        logger.setLevel(logLevel);
    }

    public boolean start(String host, int port, String filePath) {
        try {
            this.connector = new SocketConnector(logger, this.tracks, this.controller, host, port);
        }
        catch (Exception e) {
            try {
                this.connector = new ProjectFileConnector(logger, this.tracks, this.controller, this.parent.sketchPath(filePath));
            }
            catch (Exception ex) {
                logger.severe("Both connectors failed. Either run Rocket or put 'syncdata.rocket' file into sketch's folder.");
                return false;
            }
        }
        logger.info("Moonlander initialized successfully.");
        return true;
    }

    public boolean start(String filePath) {
        try {
            this.connector = new ProjectFileConnector(logger, this.tracks, this.controller, this.parent.sketchPath(filePath));
        }
        catch (Exception ex) {
            logger.severe("Could not load file:" + filePath);
            return false;
        }
        logger.info("Moonlander initialized successfully.");
        return true;
    }

    public boolean start() {
        return this.start("localhost", 1338, "syncdata.rocket");
    }

    public void update() {
        if (this.controller != null && this.connector != null) {
            this.controller.update();
            this.connector.update();
        }
    }

    public Track getTrack(String name) {
        return this.tracks.getOrCreate(name);
    }

    public double getValue(String name) {
        return this.getTrack(name).getValue(this.controller.getCurrentRow());
    }

    public int getIntValue(String name) {
        return (int)this.getValue(name);
    }

    public double getCurrentTime() {
        return this.controller.getCurrentTime();
    }

    public double getCurrentRow() {
        return this.controller.getCurrentRow();
    }

    public static String version() {
        return VERSION;
    }
}

