/*
 * Paraguay fades by rimina
 */

THREE.ParaguayFades = {

	uniforms: {
		"tDiffuse":   { type: "t", value: null },
		"brightness": { type: "f", value: 0 },
		"negate":   { type: "i", value: 0},
		"fade" : {type: "f", value: 0},
		"fadeColor" : {type: "v3", value: new THREE.Vector3(0, 0, 0)},
		"time"	: {type: "f", value : 0},
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [

        "uniform sampler2D tDiffuse;",
        "uniform float brightness;",
		"uniform float fade;",
		"uniform vec3 fadeColor;",
        "uniform int negate;",
        "uniform float time;",

        "varying vec2 vUv;",

        "float Hash11F(float p ){",
		    "vec3 p3 = fract(vec3(p     ) * 443.8975);",
		    "p3 += dot(p3, p3.yzx  + 19.19);",
		    "return fract((p3.x    + p3.y   ) * p3.z   );",
		"}",

		"vec3 ca(vec2 u){",
		    "vec3 c = vec3(0.0);",
		    "float rf=1.0, gf=1.0, bf=1.0;",
		    "float canim = 25.0;",//*smoothstep(130.0, 150.0, time);",
		    "for(int i = 0; i < 75; ++i){",/*25+int(canim)*/
		        "c.r+=texture2D(tDiffuse, 0.5+0.5*(u*rf)).r;",
		        "c.g+=texture2D(tDiffuse, 0.5+0.5*(u*gf)).g;",
		        "c.b+=texture2D(tDiffuse, 0.5+0.5*(u*bf)).b;",
		        "rf*=0.9988/(1.0+0.0002*canim);",
		        "gf*=0.9982/(1.0+0.0002*canim);",
		        "bf*=0.996/(1.0+0.0002*canim);",
		    "}",
		    "return c/(25.0+canim*0.25);",
		"}",


        "void main() {",
            //"vec4 c = texture2D( tDiffuse, vUv );",

            "vec4 c = vec4(0);",
			"for(int t = 0; t < 25; t++){",
				"float s1 = -1.0+2.0*Hash11F(mod(time,2.0)+float(t)+dot(vUv,vUv));",
				"float s2 = -1.0+2.0*Hash11F(mod(time,2.0)-float(t)+dot(vUv,vUv));",
				"vec2 f = 0.01*(-1.0+2.0*vec2(s1,s2));",
				"c += 0.2*sqrt(float(t))*pow(vec4(texture2D(tDiffuse, vUv+vec2(s1,s2)*0.1, float(t)*0.4).rgb,1),vec4(0.5));",
			"}",
			"c /= vec4(25.0);",

		    "c = (c+vec4(ca(-1.0+2.0*vUv), 1.0));",


			//fade
			"c.rgb = mix(c.rgb, fadeColor, smoothstep(0.0, 1.0, fade));",

            //Brightness
            "c.rgb += brightness;",
			//"c.rgb = clamp(c.rgb, vec3(0.), vec3(1.));",

            //negate
            "if(negate == 1){",
                "c.rgb = vec3(1.)-c.rgb;",
            "}",

            "gl_FragColor = c;",
        "}"

	].join("\n")

};
