// Generated by Haxe 3.4.0
(function ($hx_exports, $global) { "use strict";
$hx_exports["wl"] = $hx_exports["wl"] || {};
$hx_exports["kvg"] = $hx_exports["kvg"] || {};
$hx_exports["kvg"]["core"] = $hx_exports["kvg"]["core"] || {};
var $estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var DemoMain = function() {
	this.currentIndex = 0;
	this.displayVAO = [];
	this.feedbackVAO = [];
	this.mousePoint = { x : 0, y : 0};
	if(window.location.hash.length > 0) {
		var p = Std.parseInt(HxOverrides.substr(window.location.hash,1,null));
		if(typeof(p) == "number" && ((p | 0) === p)) {
			DemoMain.points = p;
		}
	}
	DemoMain.instance = this;
};
DemoMain.__name__ = true;
DemoMain.main = function() {
};
DemoMain.prototype = {
	start: function() {
		wl_core_Graphics.instance.canvas.addEventListener("mousemove",function(event) {
		});
		this.canvas = wl_core_Graphics.instance.canvas;
		this.gl = wl_core_Graphics.instance.gl;
		this.initializeControls();
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.filterHigh = { isolate : true, channels : wl_sounds_Channels.both, lowLimit : 8000, highLimit : 20000};
		this.filterLow = { isolate : true, channels : wl_sounds_Channels.both, lowLimit : 100, highLimit : 800};
		this.analyzer.filters.push(this.filterHigh);
		this.analyzer.filters.push(this.filterLow);
	}
	,render: function(t) {
		this.ontick(t);
	}
	,initializeControls: function() {
		this.vertices = new Float32Array(DemoMain.points * 2);
		this.velocities = new Float32Array(DemoMain.points * 2);
		this.indices = new Float32Array(DemoMain.points * 2);
		var _g1 = 0;
		var _g = this.vertices.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.vertices[i] = Math.random() * 0.2 - 0.1;
			this.velocities[i] = 0;
			this.indices[i] = i;
		}
		this.vertexBuffers = [wl_core_GLUtil.createBufferFromArray(this.gl,this.vertices,35044),wl_core_GLUtil.createBufferWithSize(this.gl,DemoMain.points * 2 * 4,35044)];
		this.velocityBuffers = [wl_core_GLUtil.createBufferFromArray(this.gl,this.velocities,35044),wl_core_GLUtil.createBufferWithSize(this.gl,DemoMain.points * 2 * 4,35044)];
		this.indexBuffers = [wl_core_GLUtil.createBufferFromArray(this.gl,this.indices,35044),wl_core_GLUtil.createBufferWithSize(this.gl,DemoMain.points * 2 * 4,35044)];
		this.feedbackProgram = wl_core_GLUtil.createProgram(this.gl,haxe_Resource.getString("calc.vert"),haxe_Resource.getString("empty.frag"),["v_position","v_velocity"],this.gl.SEPARATE_ATTRIBS);
		this.displayProgram = wl_core_GLUtil.createProgram(this.gl,haxe_Resource.getString("display.vert"),haxe_Resource.getString("display.frag"),null,null);
		this.feedbackVAO.push(wl_core_GLUtil.createVAO(this.gl,[{ data : this.vertexBuffers[0], location : 0, elementSize : 2},{ data : this.velocityBuffers[0], location : 1, elementSize : 2},{ data : this.indexBuffers[0], location : 2, elementSize : 2}]));
		this.feedbackVAO.push(wl_core_GLUtil.createVAO(this.gl,[{ data : this.vertexBuffers[1], location : 0, elementSize : 2},{ data : this.velocityBuffers[1], location : 1, elementSize : 2},{ data : this.indexBuffers[0], location : 2, elementSize : 2}]));
		this.displayVAO.push(wl_core_GLUtil.createVAO(this.gl,[{ data : this.vertexBuffers[0], location : 0, elementSize : 2},{ data : this.velocityBuffers[0], location : 1, elementSize : 2}]));
		this.displayVAO.push(wl_core_GLUtil.createVAO(this.gl,[{ data : this.vertexBuffers[1], location : 0, elementSize : 2},{ data : this.velocityBuffers[1], location : 1, elementSize : 2}]));
		this.transformFeedback = this.gl.createTransformFeedback();
		this.mouseLocation = this.gl.getUniformLocation(this.feedbackProgram,"u_mouse");
		this.timeLocation = this.gl.getUniformLocation(this.feedbackProgram,"time");
		this.intensity = this.gl.getUniformLocation(this.displayProgram,"intensity");
		this.mouseLocation2 = this.gl.getUniformLocation(this.displayProgram,"u_mouse");
	}
	,draw: function(vao) {
		this.gl.bindVertexArray(vao);
		this.gl.drawArrays(0,0,DemoMain.points);
	}
	,calculateFeedback: function(currentIndex,time) {
		this.analyzer.update();
		this.mousePoint.x = this.filterLow.max - 0.8;
		this.mousePoint.y = this.filterHigh.max * 1.4;
		var invertedIndex = (currentIndex + 1) % 2;
		this.gl.enable(this.gl.RASTERIZER_DISCARD);
		this.gl.bindTransformFeedback(this.gl.TRANSFORM_FEEDBACK,this.transformFeedback);
		this.gl.bindBufferBase(this.gl.TRANSFORM_FEEDBACK_BUFFER,0,this.vertexBuffers[invertedIndex]);
		this.gl.bindBufferBase(this.gl.TRANSFORM_FEEDBACK_BUFFER,1,this.velocityBuffers[invertedIndex]);
		this.gl.useProgram(this.feedbackProgram);
		this.gl.uniform2fv(this.mouseLocation,[this.mousePoint.x,this.mousePoint.y]);
		this.gl.uniform1f(this.timeLocation,time);
		this.gl.beginTransformFeedback(0);
		this.draw(this.feedbackVAO[currentIndex]);
		this.gl.endTransformFeedback();
		this.gl.disable(this.gl.RASTERIZER_DISCARD);
		this.gl.bindBufferBase(this.gl.TRANSFORM_FEEDBACK_BUFFER,0,null);
		this.gl.bindBufferBase(this.gl.TRANSFORM_FEEDBACK_BUFFER,1,null);
	}
	,ontick: function(t) {
		var invertedIndex = (this.currentIndex + 1) % 2;
		this.gl.clearColor(0.0,0.0,0.0,1.0);
		this.gl.clear(16384);
		this.calculateFeedback(this.currentIndex,t * 0.01);
		this.gl.useProgram(this.displayProgram);
		this.gl.uniform1f(this.intensity,this.filterLow.max);
		this.gl.uniform2fv(this.mouseLocation2,[this.mousePoint.x,this.mousePoint.y]);
		this.draw(this.displayVAO[invertedIndex]);
		this.currentIndex = (this.currentIndex + 1) % 2;
	}
	,__class__: DemoMain
};
var HxOverrides = function() { };
HxOverrides.__name__ = true;
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
var Main = function() { };
Main.__name__ = true;
Main.main = function() {
	$(window).ready(Main.windowReady);
};
Main.windowReady = function(e) {
	$("#setup").css("display","none");
	new DemoMain();
	Main.demo = new wl_core_Demo();
	if(!wl_core_Config.DEBUG) {
		$(".debug").css("display","none");
		$("#debug").find("input").attr("checked",null);
		$(".checkbox").css("display","none");
	}
	wl_sounds_SoundWL.onSoundLoaded.connect(Main.onSoundLoaded);
	wl_sounds_SoundWL.init();
};
Main.onSoundLoaded = function() {
	Main.loadReady();
};
Main.loadReady = function() {
	$("#setup").css("display","");
	wl_setup_Setup.init(Main.demo);
};
Math.__name__ = true;
var Std = function() { };
Std.__name__ = true;
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) {
		v = parseInt(x);
	}
	if(isNaN(v)) {
		return null;
	}
	return v;
};
var haxe_IMap = function() { };
haxe_IMap.__name__ = true;
var haxe_Resource = function() { };
haxe_Resource.__name__ = true;
haxe_Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe_Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) {
				return x.str;
			}
			return haxe_crypto_Base64.decode(x.data).toString();
		}
	}
	return null;
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
haxe_Timer.__name__ = true;
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
haxe_io_Bytes.__name__ = true;
haxe_io_Bytes.ofString = function(s) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.prototype = {
	getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				s += fcc((c & 31) << 12 | (b[i++] & 127) << 6 | b[i++] & 127);
			} else {
				var u = (c & 15) << 18 | (b[i++] & 127) << 12 | (b[i++] & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
haxe_crypto_Base64.__name__ = true;
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
haxe_crypto_BaseCode.__name__ = true;
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) tbl[_g++] = -1;
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i = _g1++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
haxe_ds_StringMap.__name__ = true;
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_Error = { __ename__ : true, __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
haxe_io_FPHelper.__name__ = true;
haxe_io_FPHelper.i32ToFloat = function(i) {
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return (1 - (i >>> 31 << 1)) * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0 ? -f : f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	var sig = Math.round((af / Math.pow(2,exp) - 1) * 8388608);
	if(sig == 8388608 && exp < 128) {
		sig = 0;
		++exp;
	}
	return (f < 0 ? -2147483648 : 0) | exp + 127 << 23 | sig;
};
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
js__$Boot_HaxeError.__name__ = true;
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
js_Boot.__name__ = true;
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0 ? "," : "") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = intf[_g1++];
			if(i == cl || js_Boot.__interfLoop(i,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class ? o.__name__ != null : false) {
			return true;
		}
		if(cl == Enum ? o.__ename__ != null : false) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_Browser = function() { };
js_Browser.__name__ = true;
js_Browser.alert = function(v) {
	window.alert(js_Boot.__string_rec(v,""));
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) this.a[_g1++] = 0;
		this.byteLength = len;
	}
};
js_html_compat_ArrayBuffer.__name__ = true;
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null ? null : end - begin);
	var result = new ArrayBuffer(u.byteLength);
	new Uint8Array(result).set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_Float32Array = function() { };
js_html_compat_Float32Array.__name__ = true;
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Uint8Array = function() { };
js_html_compat_Uint8Array.__name__ = true;
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var wl_core_Assets = $hx_exports["kvg"]["core"]["assets"] = function() {
};
wl_core_Assets.__name__ = true;
wl_core_Assets.register = function(id,type,data,compressed) {
	if(compressed) {
		throw new js__$Boot_HaxeError("Compression not implemented.");
	}
	if(type == "png" || type == "jpg") {
		var img = new Image();
		img.src = "data:image/" + (type == "jpg" ? "jpeg" : type) + ";base64," + data;
		var _this = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,img);
		} else {
			_this.h[id] = img;
		}
	} else if(type == "mp3" || type == "ogg") {
		var _this1 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this1.setReserved(id,data);
		} else {
			_this1.h[id] = data;
		}
	} else if(type == "json") {
		var _this2 = wl_core_Assets._assets;
		var value = JSON.parse(data);
		if(__map_reserved[id] != null) {
			_this2.setReserved(id,value);
		} else {
			_this2.h[id] = value;
		}
	} else if(type == "object") {
		var _this3 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this3.setReserved(id,data);
		} else {
			_this3.h[id] = data;
		}
	}
};
wl_core_Assets.get = function(id) {
	var _this = wl_core_Assets._assets;
	if(!(__map_reserved[id] != null ? _this.existsReserved(id) : _this.h.hasOwnProperty(id))) {
		console.log("Asset " + id + " not found");
	}
	var _this1 = wl_core_Assets._assets;
	if(__map_reserved[id] != null) {
		return _this1.getReserved(id);
	} else {
		return _this1.h[id];
	}
};
wl_core_Assets.prototype = {
	__class__: wl_core_Assets
};
var wl_core_Config = $hx_exports["wl"]["Config"] = function() {
	throw new js__$Boot_HaxeError("Config is static only.");
};
wl_core_Config.__name__ = true;
wl_core_Config.prototype = {
	__class__: wl_core_Config
};
var wl_core_Demo = $hx_exports["Demo"] = function() {
	this.waitingFirstFrame = true;
	this.allowUpdate = false;
	this.previousUpdate = 0;
	wl_core_Demo.instance = this;
};
wl_core_Demo.__name__ = true;
wl_core_Demo.prototype = {
	init: function(container,callback) {
		var _gthis = this;
		wl_util_Random.init(wl_core_Config.SEED);
		this.graphics = new wl_core_Graphics(container);
		wl_sounds_SoundWL.onSoundComplete.connect($bind(this,this.onSoundEnd));
		haxe_Timer.delay(function() {
			_gthis.previousTS = wl_core_TimeSig.create(0);
			_gthis.graphics.onRender.connect($bind(_gthis,_gthis.onRender));
			createjs.Ticker.setPaused(true);
			callback();
		},100);
	}
	,onSoundEnd: function() {
		this.end();
	}
	,initializeDebug: function() {
	}
	,initializeParts: function() {
	}
	,start: function() {
		var _gthis = this;
		this.graphics.start();
		DemoMain.instance.start();
		haxe_Timer.delay(function() {
			wl_sounds_SoundWL.start();
			_gthis.allowUpdate = true;
			_gthis.waitingFirstFrame = false;
		},400);
	}
	,end: function() {
		this.graphics.stop();
	}
	,onRender: function(time) {
		createjs.Tween.tick(time,false);
		if(this.allowUpdate) {
			this.update();
		}
		DemoMain.instance.render(wl_core_Graphics.instance.last);
	}
	,update: function() {
		this.previousUpdate = wl_sounds_SoundWL.getPosition().toMilliseconds();
	}
	,__class__: wl_core_Demo
};
var wl_core_GLUtil = function() {
};
wl_core_GLUtil.__name__ = true;
wl_core_GLUtil.createShader = function(gl,source,type) {
	var shader = gl.createShader(type);
	gl.shaderSource(shader,source);
	gl.compileShader(shader);
	return shader;
};
wl_core_GLUtil.createProgram = function(gl,vertex,fragment,varyings,feedbackType) {
	var vert = wl_core_GLUtil.createShader(gl,vertex,35633);
	var frag = wl_core_GLUtil.createShader(gl,fragment,35632);
	var program = gl.createProgram();
	gl.attachShader(program,vert);
	gl.attachShader(program,frag);
	gl.deleteShader(vert);
	gl.deleteShader(frag);
	if(varyings != null && varyings.length > 0) {
		gl.transformFeedbackVaryings(program,varyings,feedbackType);
	}
	gl.linkProgram(program);
	var failed = false;
	var log = gl.getProgramInfoLog(program);
	if(log.length > 0) {
		console.log("---Webgl program error---");
		console.log(log);
		js_Browser.alert("Something went wrong with webgl2. Please reload.");
		failed = true;
	}
	log = gl.getShaderInfoLog(vert);
	if(log.length > 0) {
		console.log("---webgl shader error---");
		js_Browser.alert("Something went wrong with webgl2. Please reload.");
		console.log(log);
		failed = true;
	}
	log = gl.getShaderInfoLog(frag);
	if(log.length > 0) {
		console.log("---webgl shader error---");
		console.log(log);
		js_Browser.alert("Something went wrong with webgl2. Please reload.");
		failed = true;
	}
	if(failed) {
		gl.deleteProgram(program);
		return null;
	}
	return program;
};
wl_core_GLUtil.createBufferFromArray = function(gl,data,type) {
	var buffer = gl.createBuffer();
	gl.bindBuffer(34962,buffer);
	gl.bufferData(34962,data,type);
	gl.bindBuffer(34962,null);
	return buffer;
};
wl_core_GLUtil.createBufferWithSize = function(gl,size,type) {
	var buffer = gl.createBuffer();
	gl.bindBuffer(34962,buffer);
	gl.bufferData(34962,size,type);
	gl.bindBuffer(34962,null);
	return buffer;
};
wl_core_GLUtil.createVAO = function(gl,buffers) {
	var vao = gl.createVertexArray();
	gl.bindVertexArray(vao);
	var _g = 0;
	while(_g < buffers.length) {
		var buffer = buffers[_g];
		++_g;
		gl.bindBuffer(34962,buffer.data);
		gl.enableVertexAttribArray(buffer.location);
		gl.vertexAttribPointer(buffer.location,buffer.elementSize,5126,false,0,0);
	}
	gl.bindBuffer(34962,null);
	gl.bindVertexArray(null);
	return vao;
};
wl_core_GLUtil.prototype = {
	__class__: wl_core_GLUtil
};
var wl_core_Graphics = function(container) {
	this.last = 0;
	this.stopped = true;
	this.container = container;
	if(wl_core_Graphics.instance == null) {
		wl_core_Graphics.instance = this;
	} else {
		console.log("Creating multiple Graphics instances. Are you sure?");
	}
	this.initGraphics();
};
wl_core_Graphics.__name__ = true;
wl_core_Graphics.prototype = {
	initGraphics: function() {
		this.canvas = window.document.getElementById("game");
		this.canvas.width = wl_core_Config.RESOLUTION[0];
		this.canvas.height = wl_core_Config.RESOLUTION[1];
		this.canvas.style.width = wl_core_Config.RESOLUTION[0] + "px";
		this.canvas.style.height = wl_core_Config.RESOLUTION[1] + "px";
		this.onRender = new wl_core_Signal();
		this.interval = 1000 / wl_core_Config.FPS;
		this.gl = this.canvas.getContext("webgl2",{ antialias : false});
		if(this.gl == null) {
			window.alert("No webgl2 support");
		}
		this.gl.enable(3042);
		this.gl.blendFunc(1,771);
		this.gl.viewport(0,0,wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1]);
	}
	,start: function() {
		this.canvas.style.display = "block";
		this.last = 0;
		this.stopped = false;
		this.renderLoop(0);
	}
	,stop: function() {
		this.stopped = true;
	}
	,renderLoop: function(time) {
		this.delta = time - this.last;
		if(wl_core_Config.FPS < 0 || this.delta >= this.interval) {
			this.last = time;
			this.onRender.emit(this.delta);
		}
		if(!this.stopped) {
			window.requestAnimationFrame($bind(this,this.renderLoop));
		}
	}
	,__class__: wl_core_Graphics
};
var wl_core_Signal = function() {
	this.callbacks = [];
};
wl_core_Signal.__name__ = true;
wl_core_Signal.prototype = {
	connect: function(callback) {
		this.callbacks.push(callback);
	}
	,disconnect: function(callback) {
		HxOverrides.remove(this.callbacks,callback);
	}
	,emit: function(param) {
		var _g = 0;
		var _g1 = this.callbacks;
		while(_g < _g1.length) {
			var cb = _g1[_g];
			++_g;
			cb(param);
		}
	}
	,__class__: wl_core_Signal
};
var wl_core_TimeSig = $hx_exports["wl"]["TimeSig"] = function(bar,beat,tick,delay,pattern) {
	this.triggered = false;
	this.delay = 0;
	this.set_bar(bar == null ? 0 : bar);
	this.set_beat(beat == null ? 0 : beat);
	this.set_tick(tick == null ? 0 : tick);
	this.delay = delay == null ? 0 : delay;
	this.pattern = pattern == null ? wl_core_TimeSig.ABSOLUTE : pattern;
};
wl_core_TimeSig.__name__ = true;
wl_core_TimeSig.create = function(time) {
	return new wl_core_TimeSig().fromTime(time);
};
wl_core_TimeSig.milliseconds = function(bar,beat,tick,delay) {
	return (bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + beat / wl_core_Config.BEATS_PER_MINUTE + tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
};
wl_core_TimeSig.prototype = {
	set_beat: function(value) {
		this.beat = value;
		return this.beat;
	}
	,set_bar: function(value) {
		this.bar = value;
		return this.bar;
	}
	,set_tick: function(value) {
		this.tick = value;
		return this.tick;
	}
	,adjust: function() {
	}
	,matchesPattern: function(time,begin) {
		if(this.pattern == wl_core_TimeSig.ABSOLUTE) {
			return this.equals(time);
		} else if(this.pattern == wl_core_TimeSig.RELATIVE) {
			if(time.bar == begin.bar + this.bar && time.beat == begin.beat + this.beat) {
				return time.tick == begin.tick + this.tick;
			} else {
				return false;
			}
		} else if(this.pattern == wl_core_TimeSig.PATTERN) {
			if((this.bar == -1 || time.bar % this.bar == 0) && (this.beat == -1 || time.beat % wl_core_Config.BEATS_PER_BAR == this.beat)) {
				if(this.tick != -1) {
					return time.tick % wl_core_Config.TICKS_PER_BEAT == this.tick;
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	,add: function(ts) {
		this.addBars(ts.bar);
		this.addBeats(ts.beat);
		this.addTicks(ts.tick);
	}
	,addBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar + bars);
	}
	,addBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat + beats);
		var _g1 = this;
		_g1.set_bar(_g1.bar + Math.floor(this.beat / wl_core_Config.BEATS_PER_BAR));
		var _g2 = this;
		_g2.set_beat(_g2.beat % wl_core_Config.BEATS_PER_BAR);
	}
	,addTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick + ticks);
		while(this.tick >= wl_core_Config.TICKS_PER_BEAT) {
			var _g1 = this;
			_g1.set_tick(_g1.tick - wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat + 1);
		}
		while(this.beat >= wl_core_Config.BEATS_PER_BAR) {
			var _g3 = this;
			_g3.set_beat(_g3.beat - wl_core_Config.BEATS_PER_BAR);
			var _g4 = this;
			_g4.set_bar(_g4.bar + 1);
		}
	}
	,subtract: function(ts) {
		this.subtractBars(ts.bar);
		this.subtractBeats(ts.beat);
		this.subtractTicks(ts.tick);
	}
	,subtractBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar - bars);
	}
	,subtractBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat - beats);
		while(this.beat < 0) {
			var _g1 = this;
			_g1.set_bar(_g1.bar - 1);
			var _g2 = this;
			_g2.set_beat(_g2.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,subtractTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick - ticks);
		while(this.tick < 0) {
			var _g1 = this;
			_g1.set_tick(_g1.tick + wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat - 1);
		}
		while(this.beat < 0) {
			var _g3 = this;
			_g3.set_bar(_g3.bar - 1);
			var _g4 = this;
			_g4.set_beat(_g4.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,fromTime: function(time) {
		var totalBeats = wl_core_Config.BEATS_PER_MINUTE * time;
		var comp = time < 0 ? Math.ceil : Math.floor;
		this.set_bar(comp(totalBeats / wl_core_Config.BEATS_PER_BAR));
		this.set_beat(comp(totalBeats % wl_core_Config.BEATS_PER_BAR));
		this.set_tick(comp((totalBeats - comp(totalBeats)) * wl_core_Config.TICKS_PER_BEAT));
		this.delay = 0;
		this.delay = Math.floor(255 * (time * 60 * 1000 - this.toMilliseconds()) / (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT) % 255);
		return this;
	}
	,isInside: function(begin,end) {
		if(this.isSmallerThan(end)) {
			return this.isLargerThan(begin);
		} else {
			return false;
		}
	}
	,isSmallerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks >= tickso) {
			if(ticks == tickso) {
				return this.delay < other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,isLargerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks <= tickso) {
			if(ticks == tickso) {
				return this.delay >= other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,toMilliseconds: function() {
		return (this.bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + this.beat / wl_core_Config.BEATS_PER_MINUTE + this.tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(this.delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
	}
	,equals: function(other) {
		return this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick == other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
	}
	,clone: function() {
		return new wl_core_TimeSig(this.bar,this.beat,this.tick,this.delay,this.pattern);
	}
	,toString: function(full) {
		return this.bar + ":" + this.beat + ":" + this.tick + (full ? " / " + this.delay + "\n[" + this.pattern + "]" : "");
	}
	,__class__: wl_core_TimeSig
};
var wl_setup_Setup = function() {
	throw new js__$Boot_HaxeError("Setup is static only.");
};
wl_setup_Setup.__name__ = true;
wl_setup_Setup.init = function(demo) {
	wl_setup_Setup.setupDiv = $("#setup");
	wl_setup_Setup.demoDiv = $("#demo");
	wl_setup_Setup.resolution = wl_setup_Setup.setupDiv.find("#resolution");
	var fullscreen = wl_setup_Setup.setupDiv.find("#fullscreen");
	var start = wl_setup_Setup.setupDiv.find("#start");
	fullscreen.click(wl_setup_Setup.fullScreenClickHandler);
	start.click(wl_setup_Setup.startClickHandler);
	wl_setup_Setup.demo = demo;
	if(window.location.protocol.indexOf("file") >= 0) {
		$("#localWarning").css("display","");
	}
};
wl_setup_Setup.hideSetup = function() {
	wl_setup_Setup.setupDiv.remove();
};
wl_setup_Setup.startRun = function() {
	if(wl_setup_Setup.setupDiv.find("#muted").find("input")["is"](":checked")) {
		wl_core_Config.MUTED = true;
	}
	var debug = wl_setup_Setup.setupDiv.find("#debug").find("input")["is"](":checked");
	wl_core_Config.DEBUG = debug;
	if(debug) {
		$(".debug").css("display","block");
	} else {
		$(".debug").css("display","none");
	}
	wl_setup_Setup.demo.init(wl_setup_Setup.demoDiv[0],function() {
		wl_setup_Setup.demo.start();
	});
	window.document.getElementById("demo").style.display = "block";
};
wl_setup_Setup.fullScreenClickHandler = function(e) {
	wl_setup_Setup.hideSetup();
	try {
		wl_setup_Setup.demoDiv[0].requestFullscreen();
	} catch( e1 ) {
		throw new js__$Boot_HaxeError("Full screen could not be initialized. Please reload and try again.");
	}
	var w = window.screen.width;
	var h = window.screen.height;
	var ratio = wl_core_Config.RATIO;
	var lockAspect = $("#aspectLock input").val() == "on";
	if(lockAspect && w / ratio < h) {
		h = w * 720 / 1280;
	} else if(lockAspect && h < w / ratio) {
		w = h * 1280 / 720;
	}
	wl_core_Config.RESOLUTION[0] = Math.floor(w);
	wl_core_Config.RESOLUTION[1] = Math.floor(h);
	wl_setup_Setup.demoDiv.css("background","black");
	haxe_Timer.delay(wl_setup_Setup.startRun,5000);
};
wl_setup_Setup.startClickHandler = function(e) {
	$("#demo").css("transform","").css("-webkit-transform","");
	var lockAspect = $("#aspectLock input").val() == "on";
	$("#muted input")["is"](":checked");
	var resolutionType = $("#resolution .active input[name='options']").val();
	wl_setup_Setup.hideSetup();
	var w = 1280;
	var h = 720;
	if(resolutionType == "b") {
		w = 1920;
		h = 1080;
	} else if(resolutionType == "c") {
		w = window.innerWidth;
		h = window.innerHeight;
		var ratio = wl_core_Config.RATIO;
		if(lockAspect && w / ratio < h) {
			h = w / ratio;
		} else if(lockAspect && h < w / ratio) {
			w = h * ratio;
		}
	}
	wl_core_Config.RESOLUTION[0] = w;
	wl_core_Config.RESOLUTION[1] = h;
	wl_setup_Setup.demoDiv.css("width",w + "px").css("height",h + "px");
	haxe_Timer.delay(wl_setup_Setup.startRun,50);
};
wl_setup_Setup.prototype = {
	__class__: wl_setup_Setup
};
var wl_sounds_SoundAnalyzer = function() {
	this.historySize = 6;
	this.filters = [];
	this.historyLeft = [];
	this.historyRight = [];
	var _g1 = 0;
	var _g = wl_sounds_SoundWL.FFT_PRECISION;
	while(_g1 < _g) {
		++_g1;
		this.historyLeft.push([]);
		this.historyRight.push([]);
	}
};
wl_sounds_SoundAnalyzer.__name__ = true;
wl_sounds_SoundAnalyzer.prototype = {
	update: function() {
		var _g = 0;
		var _g1 = this.filters;
		while(_g < _g1.length) {
			var filter = _g1[_g];
			++_g;
			filter.min = 1;
			filter.max = 0;
			filter.triggered = false;
			if(filter.channels == null) {
				filter.channels = wl_sounds_Channels.both;
			}
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var band = wl_sounds_SoundWL.sampleRate / wl_sounds_SoundWL.FFT_PRECISION;
		if(fft.frequencyLeft == null) {
			return;
		}
		var _g11 = 0;
		var _g2 = fft.frequencyLeft.length;
		while(_g11 < _g2) {
			var i = _g11++;
			var hL = this.historyLeft[i];
			hL.push(fft.frequencyLeft[i] / 255);
			var hR = this.historyRight[i];
			hR.push(fft.frequencyRight[i] / 255);
			while(hL.length > this.historySize) {
				hL.shift();
				hR.shift();
			}
			var sumL = 0;
			var _g21 = 0;
			while(_g21 < hL.length) {
				var v = hL[_g21];
				++_g21;
				sumL += v;
			}
			sumL /= this.historySize;
			var sumR = 0;
			var _g22 = 0;
			while(_g22 < hR.length) {
				var v1 = hR[_g22];
				++_g22;
				sumR += v1;
			}
			sumR /= this.historySize;
			var hz = band * i;
			var _g23 = 0;
			var _g3 = this.filters;
			while(_g23 < _g3.length) {
				var filter1 = _g3[_g23];
				++_g23;
				if(filter1.isolate ? hz >= filter1.lowLimit && hz <= filter1.highLimit : hz > filter1.highLimit || hz < filter1.lowLimit) {
					var sum = filter1.channels == wl_sounds_Channels.both ? (sumL + sumR) / 2 : filter1.channels == wl_sounds_Channels.right ? sumR : sumL;
					filter1.min = filter1.min > sum ? sum : filter1.min;
					filter1.max = filter1.max < sum ? sum : filter1.max;
					filter1.triggered = true;
				}
			}
		}
		var _g4 = 0;
		var _g12 = this.filters;
		while(_g4 < _g12.length) ++_g4;
	}
	,__class__: wl_sounds_SoundAnalyzer
};
var wl_sounds_Channels = { __ename__ : true, __constructs__ : ["left","right","both"] };
wl_sounds_Channels.left = ["left",0];
wl_sounds_Channels.left.toString = $estr;
wl_sounds_Channels.left.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.right = ["right",1];
wl_sounds_Channels.right.toString = $estr;
wl_sounds_Channels.right.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.both = ["both",2];
wl_sounds_Channels.both.toString = $estr;
wl_sounds_Channels.both.__enum__ = wl_sounds_Channels;
var wl_sounds_SoundWL = function() {
	throw new js__$Boot_HaxeError("Sound is static");
};
wl_sounds_SoundWL.__name__ = true;
wl_sounds_SoundWL.init = function() {
	wl_sounds_SoundWL.loadMusicFile();
	wl_sounds_SoundWL.context = createjs.Sound.activePlugin.context;
	wl_sounds_SoundWL.sampleRate = createjs.Sound.activePlugin.context.sampleRate;
	wl_sounds_SoundWL.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode;
	if(wl_core_Config.ENABLE_FFT) {
		wl_sounds_SoundWL.initializeFFT();
	}
};
wl_sounds_SoundWL.setVolume = function(volume) {
	wl_sounds_SoundWL.volume = volume;
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.instance.volume = volume;
	}
};
wl_sounds_SoundWL.getPosition = function() {
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.time.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	} else if(wl_sounds_SoundWL.context != null) {
		wl_sounds_SoundWL.time.fromTime((wl_sounds_SoundWL.context.currentTime - wl_sounds_SoundWL.startTime) / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	}
	return wl_sounds_SoundWL.time;
};
wl_sounds_SoundWL.getFFT = function() {
	return wl_sounds_SoundWL.FFT;
};
wl_sounds_SoundWL.updateFFT = function() {
	if((wl_sounds_SoundWL.instance != null || wl_sounds_SoundWL.context != null) && wl_core_Config.ENABLE_FFT && wl_sounds_SoundWL.analyserNodeLeft != null) {
		wl_sounds_SoundWL.analyserNodeLeft.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataLeft);
		wl_sounds_SoundWL.analyserNodeRight.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataRight);
	}
};
wl_sounds_SoundWL.start = function() {
	wl_sounds_SoundWL.instance = createjs.Sound.play("music");
	wl_sounds_SoundWL.instance.on("complete",wl_sounds_SoundWL.handleComplete);
	wl_sounds_SoundWL.instance.volume = wl_core_Config.MUTED ? 0 : wl_sounds_SoundWL.volume;
	wl_sounds_SoundWL.onSoundReady.emit();
	wl_sounds_SoundWL.initializeFFT();
};
wl_sounds_SoundWL.handleComplete = function() {
	wl_sounds_SoundWL.onSoundComplete.emit();
};
wl_sounds_SoundWL.loadMusicFile = function() {
	var sounds = [{ id : "music", src : wl_core_Config.SONG_PATH}];
	createjs.Sound.alternateExtensions = ["mp3"];
	createjs.Sound.addEventListener("fileload",wl_sounds_SoundWL.handleLoad);
	createjs.Sound.registerSounds(sounds);
};
wl_sounds_SoundWL.initializeFFT = function() {
	var context = wl_sounds_SoundWL.context;
	var fftsize = wl_sounds_SoundWL.FFT_PRECISION;
	if(context != null && $bind(context,context.createAnalyser) != null) {
		wl_sounds_SoundWL.analyserNodeLeft = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeLeft.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeLeft.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.analyserNodeLeft.connect(context.destination);
		wl_sounds_SoundWL.analyserNodeRight = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeRight.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeRight.smoothingTimeConstant = 0.0;
		var dynamicsNode = wl_sounds_SoundWL.dynamicsCompressorNode;
		dynamicsNode.disconnect();
		var splitterNode = context.createChannelSplitter(2);
		dynamicsNode.connect(splitterNode);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeLeft,0);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeRight,1);
		wl_sounds_SoundWL.freqFloatDataLeft = new Float32Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqFloatDataRight = new Float32Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.scriptProcessor = context.createScriptProcessor(wl_sounds_SoundWL.FFT_PRECISION * 2,2,2);
		wl_sounds_SoundWL.scriptProcessor.onaudioprocess = wl_sounds_SoundWL.updateFFT;
		wl_sounds_SoundWL.analyserNodeLeft.connect(wl_sounds_SoundWL.scriptProcessor);
		wl_sounds_SoundWL.scriptProcessor.connect(context.destination);
	} else {
		console.log("FFT could not be initialized.");
	}
	wl_sounds_SoundWL.FFT.dbLeft = wl_sounds_SoundWL.freqFloatDataLeft;
	wl_sounds_SoundWL.FFT.frequencyLeft = wl_sounds_SoundWL.freqByteDataLeft;
	wl_sounds_SoundWL.FFT.waveformLeft = wl_sounds_SoundWL.timeByteDataLeft;
	wl_sounds_SoundWL.FFT.dbRight = wl_sounds_SoundWL.freqFloatDataRight;
	wl_sounds_SoundWL.FFT.frequencyRight = wl_sounds_SoundWL.freqByteDataRight;
	wl_sounds_SoundWL.FFT.waveformRight = wl_sounds_SoundWL.timeByteDataRight;
};
wl_sounds_SoundWL.handleLoad = function() {
	wl_sounds_SoundWL.loaded = true;
	wl_sounds_SoundWL.onSoundLoaded.emit();
};
wl_sounds_SoundWL.prototype = {
	__class__: wl_sounds_SoundWL
};
var wl_util_Random = function(seed) {
	this.seed = 123;
	this.Init(seed);
};
wl_util_Random.__name__ = true;
wl_util_Random.init = function(seed) {
	wl_util_Random.instance.Init(seed);
};
wl_util_Random.next = function() {
	return wl_util_Random.instance.Next();
};
wl_util_Random.nextFloat = function() {
	return wl_util_Random.instance.NextFloat();
};
wl_util_Random.range = function(low,high) {
	return wl_util_Random.instance.Range(low,high);
};
wl_util_Random.prototype = {
	Init: function(seed) {
		this.seed = seed;
	}
	,Next: function() {
		var test = 16807 * Math.floor(this.seed % 127773) - 2836 * Math.floor(this.seed / 127773);
		if(test < 0) {
			test += 2147483647;
		}
		this.seed = test;
		return this.seed;
	}
	,NextFloat: function() {
		return this.Next() / 2147483647;
	}
	,Range: function(low,high) {
		return Math.floor(this.NextFloat() * (high - low) + low);
	}
	,__class__: wl_util_Random
};
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
String.prototype.__class__ = String;
String.__name__ = true;
Array.__name__ = true;
var Int = { __name__ : ["Int"]};
var Dynamic = { __name__ : ["Dynamic"]};
var Float = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = { __name__ : ["Class"]};
var Enum = { };
haxe_Resource.content = [{ name : "empty.frag", data : "I3ZlcnNpb24gMzAwIGVzDQoNCnByZWNpc2lvbiBsb3dwIGZsb2F0Ow0Kb3V0IHZlYzQgY29sb3I7DQoNCnZvaWQgbWFpbigpIA0Kew0KCWNvbG9yID0gdmVjNCgxLjApOw0KfQ"},{ name : "calc.vert", data : "I3ZlcnNpb24gMzAwIGVzDQoNCmxheW91dChsb2NhdGlvbiA9IDApIGluIHZlYzQgYV9wb3NpdGlvbjsNCmxheW91dChsb2NhdGlvbiA9IDEpIGluIHZlYzIgYV92ZWxvY2l0eTsNCmxheW91dChsb2NhdGlvbiA9IDIpIGluIGZsb2F0IGFfaW5kOw0KDQpmbGF0IG91dCB2ZWMyIHZfcG9zaXRpb247DQpmbGF0IG91dCB2ZWMyIHZfdmVsb2NpdHk7DQoNCnVuaWZvcm0gdmVjMiB1X21vdXNlOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KZmxvYXQgUEFSVElDTEVfTUFTUyA9IDEwLjA7DQpmbG9hdCBHUkFWSVRZX0NFTlRFUl9NQVNTID0gMTAwLjA7DQpmbG9hdCBEQU1QSU5HID0gMWUtNTsNCg0KZmxvYXQgcmFuZCh2ZWMyIGNvKXsNCiAgICByZXR1cm4gZnJhY3Qoc2luKGRvdChjby54eSAsdmVjMigxMi45ODk4LDc4LjIzMykpKSAqIDQzNzU4LjU0NTMpOw0KfQ0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiBncmF2aXR5Q2VudGVyID0gKHVfbW91c2UqMS4yLXZlYzIoMC41KStzaW4odGltZSowLjIpKjAuMykqMC4yOw0KCQ0KCWZsb2F0IHIgPSBkaXN0YW5jZShhX3Bvc2l0aW9uLnh5LCBncmF2aXR5Q2VudGVyKTsNCgl2ZWMyIGRpcmVjdGlvbiA9IGdyYXZpdHlDZW50ZXIgLSBhX3Bvc2l0aW9uLnh5Ow0KCWZsb2F0IGZvcmNlID1yKnIqMC4zOy8vIFBBUlRJQ0xFX01BU1MgKiBHUkFWSVRZX0NFTlRFUl9NQVNTIC8gKHIgKiByKSAqIERBTVBJTkc7DQovLwlmbG9hdCBtYXhGb3JjZSA9IG1pbihmb3JjZSwgREFNUElORyAqIDEwLjApOw0KCWZsb2F0IHhwID0gKHVfbW91c2UueC0xLjMpKjAuMTsNCgl2ZWMyIGFjY2VsZXJhdGlvbiA9IGZvcmNlIC8gUEFSVElDTEVfTUFTUyAqIGRpcmVjdGlvbjsNCgl2X3ZlbG9jaXR5ID1hX3ZlbG9jaXR5KjAuOTk5OTkgKyBhY2NlbGVyYXRpb24qMy4reHAqdl9wb3NpdGlvbi54K3hwKnZlYzIoc2luKGFfaW5kKjAuMSt0aW1lKjAuMDErYV9wb3NpdGlvbi54KjUuKSxjb3MoYV9pbmQqMC4wNSt0aW1lKjAuMDcrYV9wb3NpdGlvbi55KjMuKSkqKDAuMDA1ICswLjAwMSpzaW4oYV9pbmQqMC4yKSkgKyByYW5kKGFfcG9zaXRpb24ueHkpKjAuMDAyKnNpbih0aW1lKjAuMithX2luZCowLjEpOw0KCXZfcG9zaXRpb24gPSBhX3Bvc2l0aW9uLnh5K3ZfdmVsb2NpdHk7Ly8rdmVjMihzaW4oYV9pbmQqMC4xK3RpbWUqMC4wMSthX3Bvc2l0aW9uLnkpLCBzaW4oYV9pbmQqMC40K3RpbWUqMC4wMDUrYV9wb3NpdGlvbi54KmFfcG9zaXRpb24ueSkpKjAuMTsNCgkvLyBib3VuY2UgYXQgYm9yZGVycw0KCQ0KCWlmICh2X3Bvc2l0aW9uLnggPiAxLjAgfHwgdl9wb3NpdGlvbi54IDwgLTEuMCkgew0KCQl2X3ZlbG9jaXR5LnggKj0gLTAuNTsNCgl9DQoJaWYgKHZfcG9zaXRpb24ueSA+IDEuMCB8fCB2X3Bvc2l0aW9uLnkgPCAtMS4wKSB7DQoJCXZfdmVsb2NpdHkueSAqPSAtMC41Ow0KCX0NCn0"},{ name : "display.frag", data : "I3ZlcnNpb24gMzAwIGVzDQoNCnByZWNpc2lvbiBsb3dwIGZsb2F0Ow0Kb3V0IHZlYzQgY29sb3I7DQoNCmluIGZsb2F0IHZTcGVlZDsNCnVuaWZvcm0gdmVjMiB1X21vdXNlOw0KdW5pZm9ybSBmbG9hdCBpbnRlbnNpdHk7DQp2b2lkIG1haW4oKSANCnsJDQoJY29sb3IgPW1peCggdmVjNCh2U3BlZWQqMC40KmludGVuc2l0eSwgdlNwZWVkKjAuNippbnRlbnNpdHksIHZTcGVlZCoxLjYqaW50ZW5zaXR5LHZTcGVlZCkqMC44LCB2ZWM0KHZTcGVlZCowLjgqaW50ZW5zaXR5K3ZTcGVlZCppbnRlbnNpdHksIHZTcGVlZCoxLjEqaW50ZW5zaXR5LCB2U3BlZWQqMC4yKmludGVuc2l0eSx2U3BlZWQpKjAuOCx1X21vdXNlLnkpOw0KfQ"},{ name : "display.vert", data : "I3ZlcnNpb24gMzAwIGVzDQoNCmxheW91dChsb2NhdGlvbiA9IDApIGluIHZlYzQgYV9wb3NpdGlvbjsNCmxheW91dChsb2NhdGlvbiA9IDEpIGluIHZlYzIgYV92ZWxvY2l0eTsNCg0Kb3V0IGZsb2F0IHZTcGVlZDsNCg0Kdm9pZCBtYWluKCkgDQp7DQoJZ2xfUG9zaXRpb24gPSBhX3Bvc2l0aW9uOw0KCWdsX1BvaW50U2l6ZSA9IDAuMDU7DQoJdlNwZWVkID0gbGVuZ3RoKGFfdmVsb2NpdHkpOw0KfQ"}];
var __map_reserved = {}
var ArrayBuffer = $global.ArrayBuffer || js_html_compat_ArrayBuffer;
if(ArrayBuffer.prototype.slice == null) {
	ArrayBuffer.prototype.slice = js_html_compat_ArrayBuffer.sliceImpl;
}
var Float32Array = $global.Float32Array || js_html_compat_Float32Array._new;
var Uint8Array = $global.Uint8Array || js_html_compat_Uint8Array._new;
DemoMain.points = 10000000;
haxe_crypto_Base64.CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
haxe_crypto_Base64.BYTES = haxe_io_Bytes.ofString(haxe_crypto_Base64.CHARS);
js_Boot.__toStr = ({ }).toString;
js_html_compat_Float32Array.BYTES_PER_ELEMENT = 4;
js_html_compat_Uint8Array.BYTES_PER_ELEMENT = 1;
wl_core_Assets._assets = new haxe_ds_StringMap();
wl_core_Config.BEATS_PER_MINUTE = 104;
wl_core_Config.BEATS_PER_BAR = 4;
wl_core_Config.TICKS_PER_BEAT = 12;
wl_core_Config.MUSIC_BEGIN = 500;
wl_core_Config.SONG_PATH = "bg.ogg";
wl_core_Config.ENABLE_FFT = true;
wl_core_Config.MUTED = false;
wl_core_Config.FPS = 24;
wl_core_Config.RESOLUTION = [1280,720];
wl_core_Config.RATIO = 1.7777777777777777;
wl_core_Config.ANTIALIAS = true;
wl_core_Config.ENABLE_SHADOWS = false;
wl_core_Config.CLEAR_COLOR = 0;
wl_core_Config.SHADOW_MAP_SIZE = [512,512];
wl_core_Config.SEED = 123;
wl_core_Config.DEBUG = false;
wl_core_TimeSig.ABSOLUTE = "absolute";
wl_core_TimeSig.RELATIVE = "relative";
wl_core_TimeSig.PATTERN = "pattern";
wl_sounds_SoundWL.FFT_PRECISION = 1024;
wl_sounds_SoundWL.onSoundLoaded = new wl_core_Signal();
wl_sounds_SoundWL.onSoundComplete = new wl_core_Signal();
wl_sounds_SoundWL.onSoundReady = new wl_core_Signal();
wl_sounds_SoundWL.time = new wl_core_TimeSig();
wl_sounds_SoundWL.volume = 1;
wl_sounds_SoundWL.startTime = 0;
wl_sounds_SoundWL.loaded = false;
wl_sounds_SoundWL.lastFFT = 0;
wl_sounds_SoundWL.FFT = { dbLeft : null, frequencyLeft : null, waveformLeft : null, dbRight : null, frequencyRight : null, waveformRight : null, fftsize : 1024, sampleRate : 44100};
wl_util_Random.instance = new wl_util_Random(123);
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
