// Generated by Haxe 3.3.0
(function ($hx_exports, $global) { "use strict";
$hx_exports["kvg"] = $hx_exports["kvg"] || {};
$hx_exports["kvg"]["core"] = $hx_exports["kvg"]["core"] || {};
$hx_exports["wl"] = $hx_exports["wl"] || {};
$hx_exports["wl"]["util"] = $hx_exports["wl"]["util"] || {};
var $estr = function() { return js_Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function Inherit() {} Inherit.prototype = from; var proto = new Inherit();
	for (var name in fields) proto[name] = fields[name];
	if( fields.toString !== Object.prototype.toString ) proto.toString = fields.toString;
	return proto;
}
var wl_core_Signal = function() {
	this.callbacks = [];
};
wl_core_Signal.__name__ = ["wl","core","Signal"];
wl_core_Signal.prototype = {
	connect: function(callback) {
		this.callbacks.push(callback);
	}
	,disconnect: function(callback) {
		HxOverrides.remove(this.callbacks,callback);
	}
	,emit: function(param) {
		var _g = 0;
		var _g1 = this.callbacks;
		while(_g < _g1.length) {
			var cb = _g1[_g];
			++_g;
			cb(param);
		}
	}
	,__class__: wl_core_Signal
};
var DemoMain = function() {
};
DemoMain.__name__ = ["DemoMain"];
DemoMain.setup = function() {
	wl_core_Config.SONG_PATH = "Konvergence_Kapital_soundtrack_minomus_m1t.mp3";
	wl_core_Config.BEATS_PER_MINUTE = 173;
	wl_core_Config.MUSIC_BEGIN = 0;
	wl_core_Config.FPS = -1;
	wl_core_Config.ENABLE_SHADOWS = true;
	wl_core_Config.DEBUG = false;
	wl_core_Config.CLEAR_COLOR = 0;
	wl_core_Config.SHADOW_MAP_SIZE = [2048,2048];
	wl_core_Config.ENABLE_FFT = true;
	wl_core_Config.TIMELINE = [new wl_demo_TimeLine(new groundlines_GroundLines(),new wl_core_TimeSig(0),new wl_core_TimeSig(32),"groundlines",true),new wl_demo_TimeLine(new twistedplane_TwistedPlanePart(false,5),new wl_core_TimeSig(40),new wl_core_TimeSig(58),"twistedplane_outrun",false),new wl_demo_TimeLine(new outrun_Outrun(true),new wl_core_TimeSig(32),new wl_core_TimeSig(58),"outrun",true),new wl_demo_TimeLine(new engine_Engine(true),new wl_core_TimeSig(58),new wl_core_TimeSig(80),"engine",true),new wl_demo_TimeLine(new tunnel_TunnelPart(),new wl_core_TimeSig(80),new wl_core_TimeSig(88),"tunnel",true),new wl_demo_TimeLine(new moneyball_MoneyBall(),new wl_core_TimeSig(88),new wl_core_TimeSig(108),null,true),new wl_demo_TimeLine(new twisters_Twisters(),new wl_core_TimeSig(108),new wl_core_TimeSig(120),"twisters",true),new wl_demo_TimeLine(new sunset_Sunset(),new wl_core_TimeSig(120),new wl_core_TimeSig(136),null,true),new wl_demo_TimeLine(new twistedplane_TwistedPlanePart(true),new wl_core_TimeSig(136),new wl_core_TimeSig(154),null,true)];
	new THREE.FontLoader().load("font/BlackOpsOne_Regular.json",function(font) {
		DemoMain.font2 = font;
	},function() {
	},function() {
	});
};
DemoMain.onSoundReady = function() {
	var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
	DemoMain.SOUNDTEXTURE = new THREE.DataTexture(fft,fft.length,1,THREE.LuminanceFormat,THREE.UnsignedByteType,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,THREE.LinearFilter,THREE.LinearFilter);
	carmat_CarMat.init();
	dollarmat_DollarMat.init();
	DemoMain.canvas = window.document.createElement("canvas");
	DemoMain.ctx2d = DemoMain.canvas.getContext("2d",null);
	DemoMain.canvas.width = fft.length;
	DemoMain.canvas.height = 128;
	DemoMain.ctx2d.fillStyle = "#000";
	DemoMain.ctx2d.fillRect(0,0,fft.length,128);
	DemoMain.canvas.style.position = "fixed";
	DemoMain.canvas.style.right = "0px";
	DemoMain.canvas.style.left = "0px";
	DemoMain.SOUNDTEXTURE_HISTORY = new THREE.Texture(DemoMain.canvas);
};
DemoMain.update = function(ts,partial,frameTime,delta) {
	generic_Money.updateMoney();
	carmat_CarMat.updatemat();
	var fft = wl_sounds_SoundWL.getFFT().frequencyLeft;
	var _g1 = 0;
	var _g = DemoMain.canvas.width;
	while(_g1 < _g) {
		var i = _g1++;
		var v = fft[i];
		DemoMain.ctx2d.fillStyle = "#" + StringTools.hex(v << 16 | v << 8 | v,6);
		DemoMain.ctx2d.fillRect(i,DemoMain.historyind % DemoMain.canvas.height,1,2);
	}
	DemoMain.historyind++;
	DemoMain.SOUNDTEXTURE_HISTORY.needsUpdate = true;
};
DemoMain.prototype = {
	__class__: DemoMain
};
var HxOverrides = function() { };
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) {
		return undefined;
	}
	return x;
};
HxOverrides.substr = function(s,pos,len) {
	if(len == null) {
		len = s.length;
	} else if(len < 0) {
		if(pos == 0) {
			len = s.length + len;
		} else {
			return "";
		}
	}
	return s.substr(pos,len);
};
HxOverrides.remove = function(a,obj) {
	var i = a.indexOf(obj);
	if(i == -1) {
		return false;
	}
	a.splice(i,1);
	return true;
};
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
};
var Main = function() { };
Main.__name__ = ["Main"];
Main.main = function() {
	$(window).ready(Main.windowReady);
};
Main.windowReady = function(e) {
	wl_util_LoadManager.onComplete = Main.onAssetsLoaded;
	DemoMain.setup();
	$("#setup").css("display","none");
	Main.demo = new wl_core_Demo();
	if(!wl_core_Config.DEBUG) {
		$(".debug").css("display","none");
		$("#debug").find("input").attr("checked",null);
		$(".checkbox").css("display","none");
	}
	if(wl_util_LoadManager.get_totalCount() == 0) {
		Main.assetsLoaded = true;
	}
	wl_sounds_SoundWL.onSoundLoaded.connect(Main.onSoundLoaded);
	wl_sounds_SoundWL.init();
};
Main.onAssetsLoaded = function() {
	Main.assetsLoaded = true;
	Main.loadReady();
};
Main.onSoundLoaded = function() {
	Main.soundLoaded = true;
	DemoMain.onSoundReady();
	Main.loadReady();
};
Main.loadReady = function() {
	if(Main.assetsLoaded && Main.soundLoaded) {
		$("#setup").css("display","");
		wl_setup_Setup.init(Main.demo);
	}
};
Math.__name__ = ["Math"];
var Reflect = function() { };
Reflect.__name__ = ["Reflect"];
Reflect.field = function(o,field) {
	try {
		return o[field];
	} catch( e ) {
		return null;
	}
};
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(f != "__id__" && f != "hx__closures__" && hasOwnProperty.call(o,f)) {
			a.push(f);
		}
		}
	}
	return a;
};
Reflect.compare = function(a,b) {
	if(a == b) {
		return 0;
	} else if(a > b) {
		return 1;
	} else {
		return -1;
	}
};
Reflect.isEnumValue = function(v) {
	if(v != null) {
		return v.__enum__ != null;
	} else {
		return false;
	}
};
var Std = function() { };
Std.__name__ = ["Std"];
Std.string = function(s) {
	return js_Boot.__string_rec(s,"");
};
var StringTools = function() { };
StringTools.__name__ = ["StringTools"];
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
};
StringTools.hex = function(n,digits) {
	var s = "";
	while(true) {
		s = "0123456789ABCDEF".charAt(n & 15) + s;
		n >>>= 4;
		if(!(n > 0)) {
			break;
		}
	}
	if(digits != null) {
		while(s.length < digits) s = "0" + s;
	}
	return s;
};
var Type = function() { };
Type.__name__ = ["Type"];
Type.getClassName = function(c) {
	var a = c.__name__;
	if(a == null) {
		return null;
	}
	return a.join(".");
};
Type.createInstance = function(cl,args) {
	var _g = args.length;
	switch(_g) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	case 9:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8]);
	case 10:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9]);
	case 11:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10]);
	case 12:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11]);
	case 13:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12]);
	case 14:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7],args[8],args[9],args[10],args[11],args[12],args[13]);
	default:
		throw new js__$Boot_HaxeError("Too many arguments");
	}
};
var wl_core_Part = function() {
	this.postProcessing = { };
	this.effects = [];
	this.autoClear = true;
	this.clearColor = 0;
	this.generateDepthMap = true;
	this.renderToScreen = false;
	this.inTransition = false;
	this.running = false;
	this.isActive = false;
};
wl_core_Part.__name__ = ["wl","core","Part"];
wl_core_Part.prototype = {
	init: function() {
		this.triggers = new haxe_ds_ObjectMap();
		if(this.generateDepthMap) {
			this.depthMap = wl_core_Graphics.instance.getRenderTarget();
		}
		this.renderTo = wl_core_Graphics.instance.getRenderTarget(this.renderFormat);
		this.effects = [];
	}
	,postInit: function() {
	}
	,setupDatGui: function(folder) {
		if(this.camera != null) {
			var cam = folder.addFolder("camera");
			cam.add(this.camera,"fov").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
			cam.add(this.camera,"near").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
			cam.add(this.camera,"far").onChange(($_=this.camera,$bind($_,$_.updateProjectionMatrix)));
		}
	}
	,start: function(ts) {
		this.running = true;
	}
	,stop: function() {
		this.running = false;
	}
	,setRenderToScreen: function(value) {
		this.renderToScreen = value;
	}
	,update: function(ts,partial,frameTime,delta) {
	}
	,render: function(ts,frameTime) {
		var r = wl_core_Graphics.instance.renderer;
		if(this.generateDepthMap) {
			r.autoClear = true;
			r.setClearColor(0,1.0);
			this.scene.overrideMaterial = wl_core_Graphics.instance.depthMaterial;
			wl_core_Graphics.instance.renderer.render(this.scene,this.camera,this.depthMap);
			this.scene.overrideMaterial = null;
		}
		r.autoClear = this.autoClear;
		r.setClearColor(this.clearColor,1.0);
		if(this.composer != null) {
			this.composer.render();
		} else {
			wl_core_Graphics.instance.renderer.render(this.scene,this.camera,this.renderTo);
		}
	}
	,addTrigger: function(timesig,handler) {
		if(this.triggers.h.__keys__[timesig.__id__] != null) {
			this.triggers.h[timesig.__id__].push(handler);
		} else {
			this.triggers.set(timesig,[handler]);
		}
	}
	,removeTrigger: function(handler,timesig) {
		if(timesig != null && this.triggers.h.__keys__[timesig.__id__] != null) {
			HxOverrides.remove(this.triggers.h[timesig.__id__],handler);
		} else {
			var tmp = this.triggers.iterator();
			while(tmp.hasNext()) {
				var t = tmp.next();
				while(t.indexOf(handler) >= 0) HxOverrides.remove(t,handler);
			}
		}
	}
	,addEffect: function(effect) {
		this.effects.push(effect);
	}
	,initStandardScene: function() {
		this.scene = new THREE.Scene();
		this.camera = new THREE.PerspectiveCamera(30,wl_core_Config.RESOLUTION[0] / wl_core_Config.RESOLUTION[1],0.1,1000);
		this.camera.position.y = 0;
		this.camera.position.x = 0;
		this.camera.position.z = 500;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.autoUpdate = true;
		this.scene.add(this.camera);
		wl_debug_ManualControl.attachPart(this);
	}
	,getComposerList: function(post) {
		var list = [];
		if(post.cga) {
			list.push(this.postProcessing.cga = new wl_post_cga_CGA());
		}
		if(post.dof) {
			list.push(this.postProcessing.dof = new wl_post_dof_DoF(this.depthMap.texture,this.camera));
		}
		if(post.bloom) {
			list.push(this.postProcessing.bloom = new wl_post_bloom_Bloom());
		}
		if(post.gray) {
			list.push(this.postProcessing.gray = new wl_post_gray_Gray(0));
		}
		if(post.rgbShift) {
			list.push(this.postProcessing.rgbShift = new wl_post_rgbshift_RGBShift());
		}
		if(post.colorHilight) {
			list.push(this.postProcessing.colorHilight = new wl_post_colorhilight_ColorHilight());
		}
		if(post.pixelate) {
			list.push(this.postProcessing.pixelate = new wl_post_pixelate_Pixelate());
		}
		if(post.distortedTV) {
			list.push(this.postProcessing.distortedTV = new wl_post_distortedTv_DistortedTv());
		}
		if(post.vhs) {
			list.push(this.postProcessing.vhs = new wl_post_vhs_VHS());
		}
		if(post.standard) {
			list.push(this.postProcessing.standard = new wl_post_standard_StandardShader());
		}
		if(post.displacement) {
			list.push(this.postProcessing.displacement = new wl_post_displacement_Displacement(wl_core_Assets.getTexture("perlin-512.png")));
		}
		if(post.aspect) {
			list.push(this.postProcessing.aspect = new wl_post_aspect_Aspect());
		}
		return list;
	}
	,initComposer: function(postprocessingList,preventCopy,preventRender) {
		if(postprocessingList == null) {
			postprocessingList = this.getComposerList({ });
		}
		var g = wl_core_Graphics.instance;
		this.composer = new THREE.EffectComposer(g.renderer,this.renderTo);
		if(!preventRender) {
			this.renderPass = new THREE.RenderPass(this.scene,this.camera,null,new THREE.Color(this.clearColor),1);
			this.composer.addPass(this.renderPass);
		}
		var _g = 0;
		while(_g < postprocessingList.length) {
			var pass = postprocessingList[_g];
			++_g;
			this.composer.addPass(pass);
		}
		if(!preventCopy) {
			this.copyPass = new THREE.ShaderPass(THREE.CopyShader);
			this.copyPass.renderToScreen = false;
			this.composer.addPass(this.copyPass);
		}
	}
	,__class__: wl_core_Part
};
var ballvines_Ballvines = function() {
	this.oktoanim = false;
	this.speed = 0;
	this.useColors = [DemoMain.WHITE.getHex(),DemoMain.LIGHT.getHex(),DemoMain.HILIGHT.getHex(),DemoMain.GREEN.getHex(),DemoMain.BLUE.getHex()];
	this.vines = [];
	this.points = [];
	wl_core_Part.call(this);
};
ballvines_Ballvines.__name__ = ["ballvines","Ballvines"];
ballvines_Ballvines.__super__ = wl_core_Part;
ballvines_Ballvines.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.lookto = new THREE.Object3D();
		this.scene.add(this.lookto);
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false}));
		this.container = new THREE.Object3D();
		this.cubeCamera = new THREE.CubeCamera(1,400,512);
		this.container.add(this.cubeCamera);
		this.cubeCamera.position.y = 0.1;
		this.bgMat = new THREE.MeshBasicMaterial({ color : DemoMain.BLACK.getHex(), side : THREE.BackSide});
		this.container.add(new THREE.Mesh(new THREE.BoxGeometry(400,400,400),this.bgMat));
		var cubegeometry = new THREE.DodecahedronGeometry(1,3);
		var cubemat = new THREE.MeshBasicMaterial({ color : DemoMain.WHITE.getHex()});
		var _g = 0;
		while(_g < 1) {
			++_g;
			var mesh = new THREE.Mesh(cubegeometry,cubemat);
			this.container.add(mesh);
			mesh.position.x = 0;
			mesh.position.z = 0;
			mesh.position.y = 0;
		}
		this.rootMesh = new THREE.Mesh(new THREE.SphereGeometry(1),new THREE.MeshBasicMaterial({ color : 16711680}));
		this.container.add(this.rootMesh);
		this.rootMesh.visible = false;
		var sprite = wl_core_Assets.getTexture("arrow.png");
		var _g1 = 0;
		var _g2 = this.useColors.length;
		while(_g1 < _g2) {
			var size = 3 * Math.pow(0.7,_g1++ + 1);
			var material = new THREE.PointsMaterial({ size : size, map : sprite, vertexColors : THREE.VertexColors, alphaTest : 0.5, transparent : true});
			var geometry = new THREE.Geometry();
			var balls = [];
			var colors = [];
			var _g21 = 0;
			while(_g21 < 50000) {
				var j = _g21++;
				var vertex = new THREE.Vector3(Math.random() * 100 - 50,Math.random() * -4 - 4,Math.random() * 100 - 50);
				balls.push(vertex);
				geometry.vertices.push(vertex);
				colors[j] = new THREE.Color(DemoMain.BLACK.getHex());
			}
			geometry.colors = colors;
			var pointLayer = { };
			pointLayer.balls = balls;
			pointLayer.material = material;
			pointLayer.size = size;
			pointLayer.points = new THREE.Points(geometry,material);
			pointLayer.colors = colors;
			pointLayer.ind = 0;
			this.container.add(pointLayer.points);
			this.points.push(pointLayer);
		}
		this.camera.position.z = 15;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.scene.add(this.container);
		this.scene.add(new THREE.AmbientLight(3158064));
		this.root = { };
		this.root.position = new THREE.Vector3();
		this.root.direction = new THREE.Vector3(0,1,0);
		this.root.size = 1;
		this.root.angleAdd = new THREE.Vector3();
		this.root.lvl = 0;
		this.vines.push(this.root);
		this.postProcessing.bloom.radius = 0.2;
		this.postProcessing.bloom.strength = 3;
		this.postProcessing.bloom.threshold = 0.3;
		this.postProcessing.distortedTV.set_distortAmount(6000);
		this.postProcessing.distortedTV.set_vignAmount(0.1);
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.cam));
		this.addTrigger(new wl_core_TimeSig(-1,1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.cam));
		this.addTrigger(new wl_core_TimeSig(-1,2,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.cam));
		this.addTrigger(new wl_core_TimeSig(-1,3,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.cam));
		this.addTrigger(new wl_core_TimeSig(15,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.outro));
		this.addTrigger(new wl_core_TimeSig(0,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.startAnim));
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.startZoom));
		this.cubeCamera.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
		this.cc = new wl_demo_CameraController(this.camera);
		this.cc.initFollow(this.rootMesh,new THREE.Vector3(0,0,-34));
	}
	,outro: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : -1.5},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadOut);
	}
	,start: function(ts) {
		this.startTime = ts.toMilliseconds();
		wl_core_Part.prototype.start.call(this,ts);
		var tc = DemoMain.BLUE_DARK;
		createjs.Tween.get(this.bgMat.color).wait(wl_core_TimeSig.milliseconds(2,0,0,0)).to({ r : tc.r, g : tc.g, b : tc.b},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 1.4, radius : 0.2, threshold : 0.3},wl_core_TimeSig.milliseconds(0,0,6,0));
		createjs.Tween.get(this.camera.position).to({ z : 8},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.getBackInOut(2.5));
	}
	,startAnim: function(ts) {
		var _gthis = this;
		createjs.Tween.get(this.camera.position).wait(wl_core_TimeSig.milliseconds(0,8,0,0)).to({ z : 10},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.linear);
		createjs.Tween.get(this.camera.position).wait(wl_core_TimeSig.milliseconds(0,4,0,0)).to({ y : 5},wl_core_TimeSig.milliseconds(3,2,0,0),createjs.Ease.linear);
		createjs.Tween.get(this.lookto.position,{ onChange : function() {
			_gthis.camera.lookAt(_gthis.lookto.position);
		}}).wait(wl_core_TimeSig.milliseconds(0,4,0,0)).to({ x : 3},wl_core_TimeSig.milliseconds(3,0,0,0),createjs.Ease.quadOut);
		createjs.Tween.get(this.lookto.position).wait(wl_core_TimeSig.milliseconds(0,4,0,0)).to({ y : 7},wl_core_TimeSig.milliseconds(3,2,0,0),createjs.Ease.quadOut);
		createjs.Tween.get(this.postProcessing.bloom).wait(wl_core_TimeSig.milliseconds(0,4,0,0)).to({ strength : 1.4, radius : 0.1, threshold : 0.3},wl_core_TimeSig.milliseconds(0,2,0,0));
		createjs.Tween.get(this).to({ speed : 1},wl_core_TimeSig.milliseconds(1,0,0,0));
		this.oktoanim = true;
	}
	,startZoom: function(ts) {
		this.addTrigger(new wl_core_TimeSig(-1,3,8,0,wl_core_TimeSig.PATTERN),$bind(this,this.prezoom));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.changeZoom));
	}
	,prezoom: function(ts) {
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 3},wl_core_TimeSig.milliseconds(0,0,4,0));
	}
	,changeZoom: function(ts) {
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 1.4},wl_core_TimeSig.milliseconds(0,0,4,0));
		createjs.Tween.removeTweens(this.camera.position);
		createjs.Tween.removeTweens(this.lookto);
		this.camera.position.y = this.rootMesh.position.y + Math.random() * 2.5 - 2;
		this.container.rotation.y = wl_util_Random.nextFloat() * 3;
		this.camera.position.z = 10 + wl_util_Random.nextFloat() * 10;
		this.camera.lookAt(new THREE.Vector3(0,this.camera.position.y,0));
		createjs.Tween.get(this.camera.position).to({ y : this.camera.position.y - 0.5},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,cam: function(ts) {
		this.spawnVine(this.root);
	}
	,spawn: function(ts) {
		var _g = 0;
		var _g1 = this.vines;
		while(_g < _g1.length) {
			var vine = _g1[_g];
			++_g;
			var points = this.points[vine.lvl];
			points.points.geometry.colorsNeedUpdate = true;
			points.points.geometry.verticesNeedUpdate = true;
			var ball = points.balls[points.ind];
			points.colors[points.ind].setHex(this.useColors[Math.min(vine.lvl,this.useColors.length - 1)]);
			points.ind = (points.ind + 1) % points.balls.length;
			ball.copy(vine.position);
		}
	}
	,spawnVine: function(parent) {
		if(parent.lvl >= this.useColors.length - 1) {
			return;
		}
		parent = this.cloneVine(parent);
		var vine = { };
		vine.position = parent.position.clone();
		vine.direction = parent.direction.clone();
		vine.direction.x += (wl_util_Random.nextFloat() * 0.2 - 0.1) * vine.direction.x;
		vine.direction.y += (wl_util_Random.nextFloat() * 0.2 - 0.1) * vine.direction.y;
		vine.direction.z += (wl_util_Random.nextFloat() * 0.2 - 0.1) * vine.direction.z;
		vine.direction.normalize();
		vine.size = parent.size / 2;
		vine.lifetime = vine.size * 200 + 150;
		vine.maxlife = vine.lifetime;
		vine.angleAdd = parent.angleAdd.clone();
		vine.lvl = parent.lvl + 1;
		this.vines.push(vine);
	}
	,render: function(ts,frameTime) {
		if(!this.running) {
			return;
		}
		var delta = frameTime / 16.666666666666668;
		if(this.oktoanim) {
			this.spawn(ts);
			this.rootMesh.position.copy(this.root.position);
			var remove = [];
			var ms = (ts.toMilliseconds() - this.startTime) * 0.001;
			this.root.angleAdd.x = Math.sin(ms) * 2;
			this.root.angleAdd.z = Math.cos(ms) * 2;
			this.root.angleAdd.y = ms * 0.06;
			this.root.angleAdd.normalize();
			var _g = 0;
			var _g1 = this.vines;
			while(_g < _g1.length) {
				var vine = _g1[_g];
				++_g;
				if(vine != this.root) {
					vine.angleAdd.x += Math.sin((vine.maxlife - vine.lifetime) * 0.05) * 0.1;
					vine.angleAdd.y += Math.sin((vine.maxlife - vine.lifetime) * 0.025) * 0.1;
					vine.angleAdd.z += Math.sin((vine.maxlife - vine.lifetime) * 0.045) * 0.1;
				}
				vine.direction.x += vine.angleAdd.x;
				vine.direction.y += vine.angleAdd.y;
				vine.direction.z += vine.angleAdd.z;
				vine.direction.normalize();
				vine.position.addScaledVector(vine.direction,delta * 0.12 * this.speed * vine.size);
				if(wl_util_Random.nextFloat() < 0.1 * this.speed * this.speed && vine != this.root && this.vines.length < 400) {
					this.spawnVine(vine);
				}
				vine.lifetime -= delta;
				if(vine.lifetime < 0 && vine != this.root) {
					remove.push(vine);
				}
			}
			var _g2 = 0;
			while(_g2 < remove.length) {
				var vine1 = remove[_g2];
				++_g2;
				HxOverrides.remove(this.vines,vine1);
			}
		}
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,cloneVine: function(vine) {
		return { position : vine.position.clone(), direction : vine.direction.clone(), size : vine.size, lifetime : vine.lifetime, angleAdd : vine.angleAdd.clone(), lvl : vine.lvl};
	}
	,__class__: ballvines_Ballvines
});
var blank_Blank = function() {
	wl_core_Part.call(this);
};
blank_Blank.__name__ = ["blank","Blank"];
blank_Blank.__super__ = wl_core_Part;
blank_Blank.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer();
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: blank_Blank
});
var carmat_CarMat = function(geo) {
	THREE.Object3D.call(this);
	throw new js__$Boot_HaxeError("foo");
};
carmat_CarMat.__name__ = ["carmat","CarMat"];
carmat_CarMat.init = function() {
	carmat_CarMat.material = carmat_CarMat.getMaterial();
	carmat_CarMat.leatherMaterial = carmat_CarMat.getLeatherMaterial();
	carmat_CarMat.drivingWheelMaterial = carmat_CarMat.getDrivingWheelMaterial();
	carmat_CarMat.seatMaterial = carmat_CarMat.getSeatMaterial();
};
carmat_CarMat.updatemat = function() {
	carmat_CarMat.leatherMaterial.uniforms.time.value = carmat_CarMat.drivingWheelMaterial.uniforms.time.value = carmat_CarMat.seatMaterial.uniforms.time.value = carmat_CarMat.material.uniforms.time.value = wl_core_Demo.instance.previousTS.toMilliseconds() / 500;
	var fft = wl_sounds_SoundWL.getFFT();
	var lc = fft.frequencyLeft[80] / 255;
	var rc = fft.frequencyRight[80] / 255;
	carmat_CarMat.material.uniforms.fft.value = [lc,rc];
	carmat_CarMat.leatherMaterial.uniforms.fft.value = [lc,rc];
	carmat_CarMat.drivingWheelMaterial.uniforms.fft.value = [lc,rc];
	carmat_CarMat.seatMaterial.uniforms.fft.value = [lc,rc];
};
carmat_CarMat.getMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("CarMat.frag");
	params.vertexShader = haxe_Resource.getString("CarMat.vert");
	params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [1,1]}, wallX : { type : "f", value : 0.0105}, sizeX : { type : "f", value : 0.025}, wallY : { type : "f", value : 0.042}, sizeY : { type : "f", value : 0.1}};
	var mat = new THREE.ShaderMaterial(params);
	params.uniforms.fftMap.value = DemoMain.SOUNDTEXTURE;
	return mat;
};
carmat_CarMat.getLeatherMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("CarMat.frag");
	params.vertexShader = haxe_Resource.getString("CarMat.vert");
	params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [1,1]}, wallX : { type : "f", value : 0.0105}, sizeX : { type : "f", value : 0.025}, wallY : { type : "f", value : 0.042}, sizeY : { type : "f", value : 0.1}};
	var mat = new THREE.ShaderMaterial(params);
	params.uniforms.fftMap.value = DemoMain.SOUNDTEXTURE;
	return mat;
};
carmat_CarMat.getDrivingWheelMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("CarMat.frag");
	params.vertexShader = haxe_Resource.getString("CarMat.vert");
	params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [1,1]}, wallX : { type : "f", value : 0.0105}, sizeX : { type : "f", value : 0.025}, wallY : { type : "f", value : 0.042}, sizeY : { type : "f", value : 0.1}};
	var mat = new THREE.ShaderMaterial(params);
	params.uniforms.fftMap.value = DemoMain.SOUNDTEXTURE;
	return mat;
};
carmat_CarMat.getSeatMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("CarMat.frag");
	params.vertexShader = haxe_Resource.getString("CarMat.vert");
	params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [1,1]}, wallX : { type : "f", value : 0.0105}, sizeX : { type : "f", value : 0.025}, wallY : { type : "f", value : 0.042}, sizeY : { type : "f", value : 0.1}};
	var mat = new THREE.ShaderMaterial(params);
	params.uniforms.fftMap.value = DemoMain.SOUNDTEXTURE;
	return mat;
};
carmat_CarMat.__super__ = THREE.Object3D;
carmat_CarMat.prototype = $extend(THREE.Object3D.prototype,{
	__class__: carmat_CarMat
});
var credits_Credits = function() {
	this.count = 0;
	wl_core_Part.call(this);
};
credits_Credits.__name__ = ["credits","Credits"];
credits_Credits.__super__ = wl_core_Part;
credits_Credits.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer();
		this.cubecamera = new THREE.CubeCamera(1,1000,128);
		this.scene.add(new THREE.AmbientLight(4210752));
		this.spots = [];
		var spotColors = [DemoMain.WHITE,DemoMain.WHITE,DemoMain.WHITE];
		var spotPositions = [new THREE.Vector3(10,50,10),new THREE.Vector3(-10,50,-10),new THREE.Vector3(20,60,-20)];
		var _g = 0;
		while(_g < 3) {
			var i = _g++;
			var sl = new THREE.SpotLight(spotColors[i].getHex(),0.7,100);
			sl.position.copy(spotPositions[i]);
			this.scene.add(sl);
			this.spots.push(sl);
		}
		this.podium = new THREE.Object3D();
		this.testarossa = new outrun_Testarossa(this.cubecamera.renderTarget.texture);
		this.carCenter = this.getCenterPoint(this.testarossa);
		this.testarossa.translateZ(-this.carCenter.z);
		this.testarossa.translateY(-this.carCenter.y / 2 + 0.2);
		this.podium.add(this.testarossa);
		this.scene.add(this.podium);
		this.camera.position.y = 8;
		this.camera.position.z = -20;
		this.camera.lookAt(this.podium.position);
		this.scene.add(new THREE.Mesh(new THREE.CubeGeometry(100,0.1,100),new THREE.MeshPhongMaterial({ color : 11447982})));
		var skymat = new THREE.MeshBasicMaterial({ color : 16777215});
		skymat.map = wl_core_Assets.getTexture("infinitemirrorspace_fisheye.jpg");
		this.skysphere = new THREE.Mesh(new THREE.SphereGeometry(30),skymat);
		skymat.side = THREE.BackSide;
		this.scene.add(this.skysphere);
	}
	,getCenterPoint: function(mesh) {
		var bb = new THREE.Box3();
		bb.setFromObject(mesh);
		return bb.center();
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.explode(this.testarossa);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		this.cubecamera.position.copy(this.testarossa.position);
		this.testarossa.hide();
		this.cubecamera.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
		this.testarossa.show();
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,explode: function(mesh) {
		this.explodeR(mesh,0);
	}
	,explodeR: function(mesh,depth) {
		var normalvec = new THREE.Vector3(0,0.2,0);
		this.count++;
		if(!this.IsBody(mesh)) {
			if(this.count > 2) {
				createjs.Tween.get(mesh.position,{ loop : true}).to({ x : normalvec.x, y : Math.abs(normalvec.y * 5), z : normalvec.z},5000,createjs.Ease.quadInOut).to({ x : mesh.position.x, y : mesh.position.y, z : mesh.position.z},5000,createjs.Ease.quadInOut);
			}
		} else {
			createjs.Tween.get(mesh.position,{ loop : true}).to({ x : mesh.position.x, y : mesh.position.y, z : mesh.position.z},5000);
		}
		var _g = 0;
		var _g1 = mesh.children;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			depth += 0.1;
			this.explodeR(c,depth);
		}
	}
	,IsBody: function(m) {
		if(m.name == "Body") {
			return true;
		}
		var _g1 = m.children;
		while(0 < _g1.length) return this.IsBody(_g1[0]);
		if(m.parent != null && m.parent.name == "Body") {
			return true;
		}
		return false;
	}
	,__class__: credits_Credits
});
var wl_sounds_SoundAnalyzer = function() {
	this.historySize = 6;
	this.filters = [];
	this.historyLeft = [];
	this.historyRight = [];
	var _g1 = 0;
	var _g = wl_sounds_SoundWL.FFT_PRECISION;
	while(_g1 < _g) {
		++_g1;
		this.historyLeft.push([]);
		this.historyRight.push([]);
	}
};
wl_sounds_SoundAnalyzer.__name__ = ["wl","sounds","SoundAnalyzer"];
wl_sounds_SoundAnalyzer.prototype = {
	update: function() {
		var _g = 0;
		var _g1 = this.filters;
		while(_g < _g1.length) {
			var filter = _g1[_g];
			++_g;
			filter.min = 1;
			filter.max = 0;
			filter.triggered = false;
			if(filter.channels == null) {
				filter.channels = wl_sounds_Channels.both;
			}
		}
		var fft = wl_sounds_SoundWL.getFFT();
		var band = wl_sounds_SoundWL.sampleRate / wl_sounds_SoundWL.FFT_PRECISION;
		if(fft.frequencyLeft == null) {
			return;
		}
		var _g11 = 0;
		var _g2 = fft.frequencyLeft.length;
		while(_g11 < _g2) {
			var i = _g11++;
			var hL = this.historyLeft[i];
			hL.push(fft.frequencyLeft[i] / 255);
			var hR = this.historyRight[i];
			hR.push(fft.frequencyRight[i] / 255);
			while(hL.length > this.historySize) {
				hL.shift();
				hR.shift();
			}
			var sumL = 0;
			var _g21 = 0;
			while(_g21 < hL.length) {
				var v = hL[_g21];
				++_g21;
				sumL += v;
			}
			sumL /= this.historySize;
			var sumR = 0;
			var _g22 = 0;
			while(_g22 < hR.length) {
				var v1 = hR[_g22];
				++_g22;
				sumR += v1;
			}
			sumR /= this.historySize;
			var hz = band * i;
			var _g23 = 0;
			var _g3 = this.filters;
			while(_g23 < _g3.length) {
				var filter1 = _g3[_g23];
				++_g23;
				if(filter1.isolate?hz >= filter1.lowLimit && hz <= filter1.highLimit:hz > filter1.highLimit || hz < filter1.lowLimit) {
					var sum = filter1.channels == wl_sounds_Channels.both?(sumL + sumR) / 2:filter1.channels == wl_sounds_Channels.right?sumR:sumL;
					filter1.min = filter1.min > sum?sum:filter1.min;
					filter1.max = filter1.max < sum?sum:filter1.max;
					filter1.triggered = true;
				}
			}
		}
		var _g4 = 0;
		var _g12 = this.filters;
		while(_g4 < _g12.length) {
			var f = _g12[_g4];
			++_g4;
		}
	}
	,__class__: wl_sounds_SoundAnalyzer
};
var wl_core_TimeSig = $hx_exports["wl"]["TimeSig"] = function(bar,beat,tick,delay,pattern) {
	this.triggered = false;
	this.delay = 0;
	this.set_bar(bar == null?0:bar);
	this.set_beat(beat == null?0:beat);
	this.set_tick(tick == null?0:tick);
	this.delay = delay == null?0:delay;
	this.pattern = pattern == null?wl_core_TimeSig.ABSOLUTE:pattern;
};
wl_core_TimeSig.__name__ = ["wl","core","TimeSig"];
wl_core_TimeSig.create = function(time) {
	return new wl_core_TimeSig().fromTime(time);
};
wl_core_TimeSig.milliseconds = function(bar,beat,tick,delay) {
	return (bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + beat / wl_core_Config.BEATS_PER_MINUTE + tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
};
wl_core_TimeSig.prototype = {
	set_beat: function(value) {
		this.beat = value;
		this.adjust();
		return this.beat;
	}
	,set_bar: function(value) {
		this.bar = value;
		this.adjust();
		return this.bar;
	}
	,set_tick: function(value) {
		this.tick = value;
		this.adjust();
		return this.tick;
	}
	,adjust: function() {
	}
	,matchesPattern: function(time,begin) {
		if(this.pattern == wl_core_TimeSig.ABSOLUTE) {
			return this.equals(time);
		} else if(this.pattern == wl_core_TimeSig.RELATIVE) {
			if(time.bar == begin.bar + this.bar && time.beat == begin.beat + this.beat) {
				return time.tick == begin.tick + this.tick;
			} else {
				return false;
			}
		} else if(this.pattern == wl_core_TimeSig.PATTERN) {
			if((this.bar == -1 || time.bar % this.bar == 0) && (this.beat == -1 || time.beat % wl_core_Config.BEATS_PER_BAR == this.beat)) {
				if(this.tick != -1) {
					return time.tick % wl_core_Config.TICKS_PER_BEAT == this.tick;
				} else {
					return true;
				}
			} else {
				return false;
			}
		}
		return false;
	}
	,add: function(ts) {
		this.addBars(ts.bar);
		this.addBeats(ts.beat);
		this.addTicks(ts.tick);
	}
	,addBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar + bars);
	}
	,addBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat + beats);
		var _g1 = this;
		_g1.set_bar(_g1.bar + Math.floor(this.beat / wl_core_Config.BEATS_PER_BAR));
		var _g2 = this;
		_g2.set_beat(_g2.beat % wl_core_Config.BEATS_PER_BAR);
	}
	,addTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick + ticks);
		while(this.tick >= wl_core_Config.TICKS_PER_BEAT) {
			var _g1 = this;
			_g1.set_tick(_g1.tick - wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat + 1);
		}
		while(this.beat >= wl_core_Config.BEATS_PER_BAR) {
			var _g3 = this;
			_g3.set_beat(_g3.beat - wl_core_Config.BEATS_PER_BAR);
			var _g4 = this;
			_g4.set_bar(_g4.bar + 1);
		}
	}
	,subtract: function(ts) {
		this.subtractBars(ts.bar);
		this.subtractBeats(ts.beat);
		this.subtractTicks(ts.tick);
	}
	,subtractBars: function(bars) {
		var _g = this;
		_g.set_bar(_g.bar - bars);
	}
	,subtractBeats: function(beats) {
		var _g = this;
		_g.set_beat(_g.beat - beats);
		while(this.beat < 0) {
			var _g1 = this;
			_g1.set_bar(_g1.bar - 1);
			var _g2 = this;
			_g2.set_beat(_g2.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,subtractTicks: function(ticks) {
		var _g = this;
		_g.set_tick(_g.tick - ticks);
		while(this.tick < 0) {
			var _g1 = this;
			_g1.set_tick(_g1.tick + wl_core_Config.TICKS_PER_BEAT);
			var _g2 = this;
			_g2.set_beat(_g2.beat - 1);
		}
		while(this.beat < 0) {
			var _g3 = this;
			_g3.set_bar(_g3.bar - 1);
			var _g4 = this;
			_g4.set_beat(_g4.beat + wl_core_Config.BEATS_PER_BAR);
		}
	}
	,fromTime: function(time) {
		var totalBeats = wl_core_Config.BEATS_PER_MINUTE * time;
		var comp = time < 0?Math.ceil:Math.floor;
		this.set_bar(comp(totalBeats / wl_core_Config.BEATS_PER_BAR));
		this.set_beat(comp(totalBeats % wl_core_Config.BEATS_PER_BAR));
		this.set_tick(comp((totalBeats - comp(totalBeats)) * wl_core_Config.TICKS_PER_BEAT));
		this.delay = 0;
		this.delay = Math.floor(255 * (time * 60 * 1000 - this.toMilliseconds()) / (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT) % 255);
		return this;
	}
	,isInside: function(begin,end) {
		if(this.isSmallerThan(end)) {
			return this.isLargerThan(begin);
		} else {
			return false;
		}
	}
	,isSmallerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks >= tickso) {
			if(ticks == tickso) {
				return this.delay < other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,isLargerThan: function(other) {
		var ticks = this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick;
		var tickso = other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
		if(ticks <= tickso) {
			if(ticks == tickso) {
				return this.delay >= other.delay;
			} else {
				return false;
			}
		} else {
			return true;
		}
	}
	,toMilliseconds: function() {
		return (this.bar * wl_core_Config.BEATS_PER_BAR / wl_core_Config.BEATS_PER_MINUTE + this.beat / wl_core_Config.BEATS_PER_MINUTE + this.tick / wl_core_Config.TICKS_PER_BEAT / wl_core_Config.BEATS_PER_MINUTE) * 60 * 1000 + Math.floor(this.delay / 255 * (60000 / wl_core_Config.BEATS_PER_MINUTE / wl_core_Config.TICKS_PER_BEAT));
	}
	,equals: function(other) {
		return this.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + this.beat * wl_core_Config.TICKS_PER_BEAT + this.tick == other.bar * wl_core_Config.BEATS_PER_BAR * wl_core_Config.TICKS_PER_BEAT + other.beat * wl_core_Config.TICKS_PER_BEAT + other.tick;
	}
	,clone: function() {
		return new wl_core_TimeSig(this.bar,this.beat,this.tick,this.delay,this.pattern);
	}
	,toString: function(full) {
		return this.bar + ":" + this.beat + ":" + this.tick + (full?" / " + this.delay + "\n[" + this.pattern + "]":"");
	}
	,__class__: wl_core_TimeSig
};
var wl_sounds_SoundWL = function() {
	throw new js__$Boot_HaxeError("Sound is static");
};
wl_sounds_SoundWL.__name__ = ["wl","sounds","SoundWL"];
wl_sounds_SoundWL.init = function() {
	wl_sounds_SoundWL.loadMusicFile();
	wl_sounds_SoundWL.context = createjs.Sound.activePlugin.context;
	wl_sounds_SoundWL.sampleRate = createjs.Sound.activePlugin.context.sampleRate;
	wl_sounds_SoundWL.dynamicsCompressorNode = createjs.Sound.activePlugin.dynamicsCompressorNode;
	if(wl_core_Config.ENABLE_FFT) {
		wl_sounds_SoundWL.initializeFFT();
	}
};
wl_sounds_SoundWL.setVolume = function(volume) {
	wl_sounds_SoundWL.volume = volume;
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.instance.volume = volume;
	}
};
wl_sounds_SoundWL.getPosition = function() {
	if(wl_sounds_SoundWL.instance != null) {
		wl_sounds_SoundWL.time.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	} else if(wl_sounds_SoundWL.context != null) {
		wl_sounds_SoundWL.time.fromTime((wl_sounds_SoundWL.context.currentTime - wl_sounds_SoundWL.startTime) / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	}
	return wl_sounds_SoundWL.time;
};
wl_sounds_SoundWL.getFFT = function() {
	return wl_sounds_SoundWL.FFT;
};
wl_sounds_SoundWL.updateFFT = function() {
	if(!wl_debug_Debug.paused && (wl_sounds_SoundWL.instance != null || wl_sounds_SoundWL.context != null) && wl_core_Config.ENABLE_FFT && wl_sounds_SoundWL.analyserNodeLeft != null) {
		wl_sounds_SoundWL.analyserNodeLeft.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataLeft);
		wl_sounds_SoundWL.analyserNodeLeft.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataLeft);
		wl_sounds_SoundWL.analyserNodeRight.getFloatFrequencyData(wl_sounds_SoundWL.freqFloatDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteFrequencyData(wl_sounds_SoundWL.freqByteDataRight);
		wl_sounds_SoundWL.analyserNodeRight.getByteTimeDomainData(wl_sounds_SoundWL.timeByteDataRight);
	}
};
wl_sounds_SoundWL.start = function() {
	wl_sounds_SoundWL.instance = createjs.Sound.play("music");
	wl_sounds_SoundWL.instance.on("complete",wl_sounds_SoundWL.handleComplete);
	wl_sounds_SoundWL.instance.volume = wl_core_Config.MUTED?0:wl_sounds_SoundWL.volume;
	wl_sounds_SoundWL.onSoundReady.emit();
};
wl_sounds_SoundWL.handleComplete = function() {
	wl_sounds_SoundWL.onSoundComplete.emit();
};
wl_sounds_SoundWL.loadMusicFile = function() {
	var sounds = [{ id : "music", src : wl_core_Config.SONG_PATH}];
	createjs.Sound.alternateExtensions = ["mp3"];
	createjs.Sound.addEventListener("fileload",wl_sounds_SoundWL.handleLoad);
	createjs.Sound.registerSounds(sounds);
};
wl_sounds_SoundWL.initializeFFT = function() {
	var context = wl_sounds_SoundWL.context;
	var fftsize = wl_sounds_SoundWL.FFT_PRECISION;
	if(context != null && $bind(context,context.createAnalyser) != null) {
		wl_sounds_SoundWL.analyserNodeLeft = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeLeft.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeLeft.smoothingTimeConstant = 0.0;
		wl_sounds_SoundWL.analyserNodeLeft.connect(context.destination);
		wl_sounds_SoundWL.analyserNodeRight = context.createAnalyser();
		wl_sounds_SoundWL.analyserNodeRight.fftSize = fftsize;
		wl_sounds_SoundWL.analyserNodeRight.smoothingTimeConstant = 0.0;
		var dynamicsNode = wl_sounds_SoundWL.dynamicsCompressorNode;
		dynamicsNode.disconnect();
		var splitterNode = context.createChannelSplitter(2);
		dynamicsNode.connect(splitterNode);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeLeft,0);
		splitterNode.connect(wl_sounds_SoundWL.analyserNodeRight,1);
		wl_sounds_SoundWL.freqFloatDataLeft = new Float32Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataLeft = new Uint8Array(wl_sounds_SoundWL.analyserNodeLeft.frequencyBinCount);
		wl_sounds_SoundWL.freqFloatDataRight = new Float32Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.freqByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.timeByteDataRight = new Uint8Array(wl_sounds_SoundWL.analyserNodeRight.frequencyBinCount);
		wl_sounds_SoundWL.scriptProcessor = context.createScriptProcessor(wl_sounds_SoundWL.FFT_PRECISION * 2,2,2);
		wl_sounds_SoundWL.scriptProcessor.onaudioprocess = wl_sounds_SoundWL.updateFFT;
		wl_sounds_SoundWL.analyserNodeLeft.connect(wl_sounds_SoundWL.scriptProcessor);
		wl_sounds_SoundWL.scriptProcessor.connect(context.destination);
	} else {
		console.log("FFT could not be initialized.");
	}
	wl_sounds_SoundWL.FFT.dbLeft = wl_sounds_SoundWL.freqFloatDataLeft;
	wl_sounds_SoundWL.FFT.frequencyLeft = wl_sounds_SoundWL.freqByteDataLeft;
	wl_sounds_SoundWL.FFT.waveformLeft = wl_sounds_SoundWL.timeByteDataLeft;
	wl_sounds_SoundWL.FFT.dbRight = wl_sounds_SoundWL.freqFloatDataRight;
	wl_sounds_SoundWL.FFT.frequencyRight = wl_sounds_SoundWL.freqByteDataRight;
	wl_sounds_SoundWL.FFT.waveformRight = wl_sounds_SoundWL.timeByteDataRight;
};
wl_sounds_SoundWL.handleLoad = function() {
	wl_sounds_SoundWL.loaded = true;
	wl_sounds_SoundWL.onSoundLoaded.emit();
};
wl_sounds_SoundWL.prototype = {
	__class__: wl_sounds_SoundWL
};
var dollarmat_DollarMat = function() {
	throw new js__$Boot_HaxeError("foo");
};
dollarmat_DollarMat.__name__ = ["dollarmat","DollarMat"];
dollarmat_DollarMat.init = function() {
	dollarmat_DollarMat.material = dollarmat_DollarMat.getMaterial();
	dollarmat_DollarMat.analyzer.filters.push(dollarmat_DollarMat.filter);
};
dollarmat_DollarMat.updatemat = function() {
	dollarmat_DollarMat.analyzer.update();
	dollarmat_DollarMat.material.uniforms.time.value = wl_core_Demo.instance.previousTS.toMilliseconds() / 500;
	var val = Math.max(0,dollarmat_DollarMat.filter.max - 0.85) / 0.2;
	dollarmat_DollarMat.material.uniforms.fft.value = [val,val];
};
dollarmat_DollarMat.getMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("DollarMat.frag");
	params.vertexShader = haxe_Resource.getString("DollarMat.vert");
	params.uniforms = { tDiff : { type : "t", value : null}, fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, fft : { type : "f2", value : [1,1]}, sizeX : { type : "f", value : 20}, sizeY : { type : "f", value : 20}, brightness : { type : "f:", value : 0.3}};
	var mat = new THREE.ShaderMaterial(params);
	params.uniforms.fftMap.value = DemoMain.SOUNDTEXTURE;
	params.uniforms.tDiff.value = wl_core_Assets.getTexture("bitcoin.png");
	return mat;
};
dollarmat_DollarMat.prototype = {
	__class__: dollarmat_DollarMat
};
var engine_Engine = function(first) {
	this.explosionBodyStart = 0;
	this.explosionStart = 0;
	this.explodingBody = false;
	this.explodingBodyParts = [];
	this.explodingParts = [];
	this.exploding = false;
	this.ccind = 0;
	this.carMoney = [];
	this.money = [];
	this.previous = 0;
	this.phase = 0;
	wl_core_Part.call(this);
	this.first = first;
};
engine_Engine.__name__ = ["engine","Engine"];
engine_Engine.__super__ = wl_core_Part;
engine_Engine.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false, vhs : true}));
		this.moneycc = new wl_demo_CameraController(new THREE.Object3D());
		this.moneycc.initBezier([new THREE.Vector3(0.8,-0.24,1.74),new THREE.Vector3(-0.11,-0.73,-1.75),new THREE.Vector3(-0.01,-0.08,-2.75),new THREE.Vector3(0.8,0.65,-3.67),new THREE.Vector3(-0.19,2.18,-5.44),new THREE.Vector3(-1.04,3.26,-4.85),new THREE.Vector3(-1.4,2.9,-3),new THREE.Vector3(-0.9,3.17,-2.17),new THREE.Vector3(0.94,4.17,-1.36),new THREE.Vector3(0.46,5.44,-0.52),new THREE.Vector3(0.48,6.14,-0.47),new THREE.Vector3(-0.25,7.63,-0.12),new THREE.Vector3(1.31,9.26,0.25),new THREE.Vector3(0.02,10.23,0.25)],[new THREE.Vector3(9.83,7.17,-97.58),new THREE.Vector3(20.16,-1.17,-99.67),new THREE.Vector3(3.36,61.14,-81.74),new THREE.Vector3(-47.75,75.26,-49.25),new THREE.Vector3(-62.6,73.81,25.75),new THREE.Vector3(14.08,-46.74,80.42),new THREE.Vector3(44.74,-4.51,85.42),new THREE.Vector3(49.02,53.55,68.32),new THREE.Vector3(-16.75,72.05,69.91),new THREE.Vector3(-31.27,89.78,42.84),new THREE.Vector3(-2.93,-93.48,-8.49),new THREE.Vector3(-2.94,-91.86,-9.77),new THREE.Vector3(-1.86,-90.1,-10.61),new THREE.Vector3(0.86,-88.17,-17.52)]);
		this.postProcessing.vhs.set_intensity(0.03);
		this.postProcessing.vhs.set_jitter(0.05);
		this.postProcessing.vhs.set_size(0.3);
		this.postProcessing.bloom.strength = 1;
		this.postProcessing.bloom.radius = 0.2;
		this.postProcessing.bloom.threshold = 0.3;
		this.blocks = [];
		var s = 20;
		var _g1 = 0;
		var _g = s;
		while(_g1 < _g) {
			var i = _g1++;
			var xp = i % s;
			var yp = Math.floor(i / s);
			var b = new engine_EngineBlock(false);
			b.off = i * 0.2;
			b.position.x = Math.sin(i / s * Math.PI * 2) * 50;
			b.position.z = Math.cos(i / s * Math.PI * 2) * 50;
			b.position.y = 0;
			b.scale.x = b.scale.z = 0.2;
			b.scale.y = 1;
			this.scene.add(b);
			this.blocks.push(b);
		}
		this.cylinder = new tunnel_TunnelCylinder();
		this.cylinder.scale.x = 5;
		this.cylinder.scale.z = 5;
		this.cylinder.position.y = -350;
		this.cylinder.visible = false;
		this.cylinder.material.side = THREE.BackSide;
		this.scene.add(this.cylinder);
		this.cylinder.material.uniforms.speed.value = 0.3;
		this.ball = new groundlines_LinePlane(new THREE.SphereGeometry(250,16,12));
		this.ball.material.side = THREE.BackSide;
		this.blocks = wl_util_ArrayUtil.shuffle(this.blocks);
		var box = new THREE.Mesh(new THREE.BoxGeometry(200,140,1),new THREE.MeshPhongMaterial({ color : 0}));
		box.position.z = 4;
		this.rndcc = new wl_demo_RandomCameraController(this.camera,26,[],12115,[wl_demo_CameraController.STATIC],[50,70],new THREE.Box3(new THREE.Vector3(32,45,-13),new THREE.Vector3(-43,10,3)));
		this.addTrigger(new wl_core_TimeSig(-1,-1,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchcam));
		this.camera.position.z = 20.0;
		this.camera.position.x = 0.0;
		this.camera.position.y = 0.5;
		this.camera.rotation.x = 0;
		this.camera.rotation.y = 0;
		this.camera.rotation.z = 0;
		this.cubecam = new THREE.CubeCamera(1,1000,512);
		this.carc = new THREE.Object3D();
		this.car = new outrun_Testarossa(this.cubecam.renderTarget.texture);
		this.carc.add(this.car);
		this.scene.add(this.carc);
		this.carc.scale.x = this.carc.scale.y = this.carc.scale.z = 4;
		this.ground = new engine_RoundPlane();
		this.ground.rotation.y = Math.PI;
		this.ground.rotation.x = Math.PI / 2;
		this.ground.material.uniforms.fftMap.value = this.soundtexture;
		this.ground.material.transparent = true;
		this.ground.position.z = 0;
		this.ground.position.y = -1.25;
		this.ground.scale.x = this.ground.scale.y = this.ground.scale.z = 0.08;
		this.carc.add(this.ground);
		this.scene.add(this.camera);
		var _g2 = 0;
		while(_g2 < 250) {
			var i1 = _g2++;
			var m = new generic_Money();
			m.mesh.position.x = Math.random() * 3;
			m.mesh.position.z = Math.random() * 3;
			var deg = Math.random() * 2 * Math.PI;
			var dist = Math.random() * 4 + 15;
			m.position.x = Math.sin(deg) * dist;
			m.position.y = Math.random() * 50;
			m.position.z = Math.cos(deg) * dist;
			m.scale.set(0.05,0.05,0.05);
			m.rotation.x = wl_util_Random.nextFloat() * 3.14;
			m.rotation.y = wl_util_Random.nextFloat() * 3.14;
			m.rotation.z = wl_util_Random.nextFloat() * 3.14;
			m.mesh.rotation.x = Math.PI / 2;
			this.scene.add(m);
			this.money.push(m);
			var _g11 = 0;
			while(_g11 < 2) {
				var i2 = _g11++;
				var cm = m.clone();
				cm.angle = 0;
				cm.position.y = -0.8;
				cm.position.z = -2 + wl_util_Random.nextFloat() * 0.5 - 0.25;
				cm.position.x = wl_util_Random.nextFloat() * 0.5 - 0.25;
				cm.scale.set(0.0125,0.0125,0.0125);
				this.carMoney.push(cm);
				cm.origpos = cm.position.clone();
				this.carc.add(cm);
			}
		}
		var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
		this.soundtexture = DemoMain.SOUNDTEXTURE;
		this.ball.material.uniforms.fftMap.value = DemoMain.SOUNDTEXTURE;
		this.ball.material.uniforms.speed.value = 0;
		this.ball.material.uniforms.mountains.value = 0;
		this.car.position.z = -1.45;
		this.car.position.y = -1.7;
		this.car.position.x = 0.0;
		if(this.first) {
			var koheaspect = 1.5;
			this.kapital = new THREE.Mesh(new THREE.PlaneGeometry(1,wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0]),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Demo.instance.getPart("outrun").renderTo.texture, side : THREE.FrontSide}));
			this.kapital.scale.setY(-1);
			this.kapital.position.x = 0.5;
			this.kapital.material.opacity = 0;
			this.kapital.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
			this.addTrigger(new wl_core_TimeSig(6,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
				createjs.Tween.get(_gthis.kapital.material).to({ opacity : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
			});
			this.over = new THREE.Mesh(new THREE.PlaneGeometry(1,wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0]),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("over_wimp.png"), side : THREE.FrontSide}));
			this.over.scale.setY(-1);
			this.over.position.x = 0.5;
			this.over.material.opacity = 1;
			this.over.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
			this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.explodecar));
			this.addTrigger(new wl_core_TimeSig(16,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.explodecarBody));
		}
		this.clearColor = 16777215;
		this.scene.add(new THREE.AmbientLight(268435455));
		this.ccs = [new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera),new wl_demo_CameraController(this.camera)];
		var tmp = new THREE.Vector3(-1.98,28.9,1.85);
		this.ccs[0].initStatic(tmp,new THREE.Vector3(1.9,0,3.21));
		var tmp1 = new THREE.Vector3(0.8020504445181147,-0.23737160204691776,1.7360397845965718);
		this.ccs[1].initStatic(tmp1,new THREE.Vector3(13.814432797553287,7.608537970737561,-97.102816989822393));
		var tmp2 = new THREE.Vector3(-20.65649850251446,-1.7928139135493297,2.813752109604476);
		this.ccs[2].initStatic(tmp2,new THREE.Vector3(78.76161125283244,-4.410508744336698,-7.635512287790355));
		var tmp3 = new THREE.Vector3(20.63400819588754,1.547764162344915,13.707343511657815);
		this.ccs[3].initStatic(tmp3,new THREE.Vector3(-42.054292022724944,-4.328378738527135,-22.310144431227837));
		var tmp4 = new THREE.Vector3(-20.65649850251446,-1.7928139135493297,2.813752109604476);
		this.ccs[4].initStatic(tmp4,new THREE.Vector3(78.76161125283244,-4.410508744336698,-7.635512287790355));
		this.greets = new greets_Greets();
		this.greets.position.y = 3;
		this.scene.add(this.greets);
	}
	,switchcam: function(ts) {
		if(ts.bar == 76) {
			wl_core_Demo.instance.overlay.remove(this.over);
			createjs.Tween.get(this.camera.position).to({ y : 84},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadOut);
			this.cylinder.visible = true;
			createjs.Tween.get(this.cylinder.position).to({ y : 0},wl_core_TimeSig.milliseconds(4,0,0,0));
			createjs.Tween.get(this.postProcessing.bloom).wait(wl_core_TimeSig.milliseconds(1,0,0,0)).to({ strength : 12},wl_core_TimeSig.milliseconds(1,0,0,0));
			createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).wait(wl_core_TimeSig.milliseconds(2,0,0,0)).to({ value : -2},wl_core_TimeSig.milliseconds(4,0,0,0));
		}
		if(ts.bar < 77) {
			if(ts.bar % 4 == 0 && ts.beat == 0) {
				this.ccind++;
				this.ccs[this.ccind % this.ccs.length].update(0);
				if(this.ccind % 5 == 1) {
					this.carc.add(this.camera);
				} else {
					this.scene.add(this.camera);
				}
			}
			if(ts.beat % 2 == 0) {
				this.greets.position.y = this.camera.position.y + 4.5;
				if(this.ccind % 5 == 1 || this.ccind % 5 == 2 || this.ccind % 5 == 3 || this.ccind % 5 == 4) {
					this.greets.nextGreet();
					if(this.ccind % 5 != 1) {
						if(this.ccind % 5 != 2) {
							if(this.ccind % 5 != 3) {
								var tmp = this.ccind % 5 == 4;
							}
						}
					}
				}
			}
		}
	}
	,stop: function() {
		wl_core_Part.prototype.stop.call(this);
	}
	,start: function(ts) {
		var _gthis = this;
		wl_core_Part.prototype.start.call(this,ts);
		wl_core_Demo.instance.overlay.add(this.over);
		generic_Money.material.uniforms.intensity.value = 0.5;
		this.car.setEnvmap(this.cubecam.renderTarget.texture,true);
		if(this.first) {
			this.kapital.material.opacity = 1;
			createjs.Tween.get(this.kapital.material).to({ opacity : 0},wl_core_TimeSig.milliseconds(1,0,0,0)).call(function() {
				wl_core_Demo.instance.overlay.remove(_gthis.kapital);
			});
		}
		this.outrun = wl_core_Demo.instance.getPart("outrun");
		console.log("srtatattatatt");
	}
	,explodecar: function(ts) {
		this.exploding = true;
		this.explosionStart = ts.toMilliseconds();
		return;
	}
	,explodecarBody: function(ts) {
		this.explosionBodyStart = ts.toMilliseconds();
		this.explodingBody = true;
		wl_core_Demo.instance.overlay.remove(this.over);
		createjs.Tween.get(this.car.bonnet.rotation).to({ x : Math.PI / 2},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quartOut);
		var c = 0;
		var _g = 0;
		var _g1 = this.carMoney;
		while(_g < _g1.length) {
			var m = _g1[_g];
			++_g;
			++c;
			createjs.Tween.get(m.position).wait(c * 11).to({ y : 40},wl_core_TimeSig.milliseconds(8,0,0,0));
			createjs.Tween.get(m.position).wait(c * 11).to({ x : m.position.x - 1},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadInOut).to({ x : m.position.x + 0.31},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadInOut).to({ x : m.position.x - 2.4},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadInOut).to({ x : 3.6},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadInOut).to({ x : 0.3},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadInOut);
			createjs.Tween.get(m.position).wait(c * 25).to({ y : m.position.z + 0.4},wl_core_TimeSig.milliseconds(1,0,0,0)).to({ y : m.position.z - 1},wl_core_TimeSig.milliseconds(1,0,0,0)).to({ y : m.position.z + 2},wl_core_TimeSig.milliseconds(1,0,0,0)).to({ y : 0.5},wl_core_TimeSig.milliseconds(1,0,0,0)).to({ y : 0.4},wl_core_TimeSig.milliseconds(1,0,0,0));
		}
	}
	,explodeChr: function(m) {
		var _g = 0;
		var _g1 = m.children;
		while(_g < _g1.length) {
			++_g;
			this.explodeChr(m);
		}
		createjs.Tween.get(m.position).to({ y : wl_util_Random.nextFloat() * 5},26000);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var tmp = this.explodingBody && delta > 0;
	}
	,render: function(ts,frameTime) {
		var _g = 0;
		var _g1 = this.money;
		while(_g < _g1.length) {
			var m = _g1[_g];
			++_g;
			if(m.position.y < -10.7) {
				m.position.y += 60;
			} else {
				m.rotation.x += frameTime / 16.6 * 0.05;
				m.rotation.z += frameTime / 16.6 * 0.025;
				m.rotation.y += frameTime / 16.6 * 0.055;
				m.position.y -= frameTime / 16.6 * 0.05;
			}
		}
		var delta = ts.toMilliseconds() - this.previous;
		this.carc.rotation.y = ts.toMilliseconds() / 5000;
		if(this.carc.children.indexOf(this.camera) == -1) {
			this.greets.rotation.y -= delta / 16.6 * 0.005;
		}
		var b = delta * 0.003;
		this.phase += b;
		this.previous = ts.toMilliseconds();
		var fft = wl_sounds_SoundWL.getFFT();
		if(fft.frequencyLeft != null) {
			this.ball.material.uniforms.fft.value = [fft.frequencyLeft[100] / 255 * 15,fft.frequencyRight[100] / 255 * 15];
		}
		this.ball.material.uniforms.time.value = ts.toMilliseconds() / 5000;
		if(fft.frequencyLeft != null) {
			this.ground.material.uniforms.fft.value = [2 * fft.frequencyLeft[100] / 255 * 5,2 * fft.frequencyRight[100] / 255 * 5];
		}
		this.ground.material.uniforms.time.value = ts.toMilliseconds() / 5000;
		var _g11 = 0;
		var _g2 = this.blocks.length;
		while(_g11 < _g2) {
			var i = _g11++;
			var b1 = this.blocks[i];
			b1.phase(this.phase + Math.PI / this.blocks.length * i,ts.toMilliseconds() / 3000);
		}
		this.car.visible = false;
		this.cubecam.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
		this.car.envmap.needsUpdate = true;
		this.car.visible = true;
		if(fft.frequencyLeft != null) {
			this.cylinder.material.uniforms.fft.value = [fft.frequencyLeft[100] / 255 * 15,fft.frequencyRight[100] / 255 * 15];
		}
		this.cylinder.material.uniforms.time.value = ts.toMilliseconds() / 5000;
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: engine_Engine
});
var engine_EngineBlock = function(hide) {
	this.off = 0;
	this.dir = 0;
	this.previousPos = 0;
	THREE.Object3D.call(this);
	this.hide = hide;
	if(engine_EngineBlock.material == null) {
		engine_EngineBlock.material = new THREE.MeshPhongMaterial({ color : 16777215});
		engine_EngineBlock.cylgeo = new THREE.CylinderGeometry(24,24,100,24,1,false);
		engine_EngineBlock.pc = new THREE.PlaneGeometry(100,100,100,100);
	}
	this.top = new THREE.Mesh(engine_EngineBlock.cylgeo,engine_EngineBlock.material);
	this.bottom = new THREE.Mesh(engine_EngineBlock.cylgeo,engine_EngineBlock.material);
	this.top.position.y = -50;
	this.bottom.position.y = 50;
	this.light = new twistedplane_TwistedPlane(engine_EngineBlock.pc);
	this.light.position.z = 0;
	this.add(this.light);
	if(engine_EngineBlock.soundtexture == null) {
		var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
		engine_EngineBlock.soundtexture = DemoMain.SOUNDTEXTURE;
	}
	this.light.material.uniforms.fftMap.value = engine_EngineBlock.soundtexture;
	this.light.material.uniforms.speed.value = 0;
	this.light.material.uniforms.mountains.value = 0;
};
engine_EngineBlock.__name__ = ["engine","EngineBlock"];
engine_EngineBlock.__super__ = THREE.Object3D;
engine_EngineBlock.prototype = $extend(THREE.Object3D.prototype,{
	phase: function(pos,time) {
		var p = Math.abs(Math.sin(pos));
		if(p - this.previousPos < 0) {
			this.dir = -1;
		} else if(p - this.previousPos > 0) {
			this.dir = 1;
		}
		var useLight = this.dir == 1;
		this.previousPos = p;
		this.light.visible = !this.hide || useLight;
		this.top.position.y = p * -20 - 50;
		this.bottom.position.y = p * 20 + 50;
		var fft = wl_sounds_SoundWL.getFFT();
		if(fft.frequencyLeft != null) {
			this.light.material.uniforms.fft.value = [fft.frequencyLeft[100] / 255 * 15,fft.frequencyRight[100] / 255 * 15];
		}
		this.light.material.uniforms.time.value = this.off + time;
		engine_EngineBlock.soundtexture.needsUpdate = true;
	}
	,__class__: engine_EngineBlock
});
var engine_RoundPlane = function(geo) {
	THREE.Object3D.call(this);
	var pc = geo != null?geo:new THREE.PlaneGeometry(100,100,1,1);
	this.material = engine_RoundPlane.getMaterial();
	this.mesh = new THREE.Mesh(pc,this.material);
	this.add(this.mesh);
};
engine_RoundPlane.__name__ = ["engine","RoundPlane"];
engine_RoundPlane.getMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("RoundPlane.frag");
	params.vertexShader = haxe_Resource.getString("RoundPlane.vert");
	params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [0,0]}, wallX : { type : "f", value : 0.0105}, sizeX : { type : "f", value : 0.025}, wallY : { type : "f", value : 0.042}, sizeY : { type : "f", value : 0.1}};
	return new THREE.ShaderMaterial(params);
};
engine_RoundPlane.__super__ = THREE.Object3D;
engine_RoundPlane.prototype = $extend(THREE.Object3D.prototype,{
	__class__: engine_RoundPlane
});
var ffttest_FFTest = function() {
	this.cols = [new THREE.Color(16711680),new THREE.Color(65280),new THREE.Color(16776960),new THREE.Color(16711935)];
	this.whiteMat = new THREE.MeshBasicMaterial({ color : 16777215});
	this.fil4t = 0.5;
	this.fil3t = 0.5;
	this.fil2t = 0.5;
	this.fil1t = 0.5;
	this.boxes = [];
	wl_core_Part.call(this);
};
ffttest_FFTest.__name__ = ["ffttest","FFTest"];
ffttest_FFTest.__super__ = wl_core_Part;
ffttest_FFTest.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.camera.fov = 80;
		this.camera.updateProjectionMatrix();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false, vhs : true}));
		this.camera.position.z = -235;
		this.camera.position.y = 0;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.postProcessing.bloom.strength = 2;
		this.postProcessing.bloom.threshold = 0.1;
		this.postProcessing.bloom.radius = 0.05;
		this.postProcessing.distortedTV.set_vignAmount(1);
		var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
		this.soundtexture = new THREE.DataTexture(fft,fft.length,1,THREE.LuminanceFormat,THREE.UnsignedByteType,THREE.UVMapping,THREE.ClampToEdgeWrapping,THREE.ClampToEdgeWrapping,THREE.LinearFilter,THREE.LinearFilter);
		var bg = new THREE.BoxGeometry(0.5,1,0.5);
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.mats = [new THREE.MeshBasicMaterial({ color : 16777215}),new THREE.MeshBasicMaterial({ color : 16777215}),new THREE.MeshBasicMaterial({ color : 16777215}),new THREE.MeshBasicMaterial({ color : 16777215})];
		var _g1 = 0;
		var _g = wl_sounds_SoundWL.getFFT().frequencyLeft.length;
		while(_g1 < _g) {
			var i = _g1++;
			var bm = this.mats[Math.floor(i / wl_sounds_SoundWL.getFFT().frequencyLeft.length * 4)];
			var box = new THREE.Mesh(bg,bm);
			this.scene.add(box);
			box.position.x = wl_sounds_SoundWL.getFFT().frequencyLeft.length / 2 - i;
			this.boxes.push(box);
			this.analyzer.filters.push({ lowLimit : i * 20000 / wl_sounds_SoundWL.getFFT().frequencyLeft.length, highLimit : (1 + i) * 20000 / wl_sounds_SoundWL.getFFT().frequencyLeft.length, isolate : true});
		}
		this.fil1 = { lowLimit : 0, highLimit : 5000., isolate : true};
		this.analyzer.filters.push(this.fil1);
		this.fil2 = { lowLimit : 5000., highLimit : 10000., isolate : true};
		this.analyzer.filters.push(this.fil2);
		this.fil3 = { lowLimit : 10000., highLimit : 15000., isolate : true};
		this.analyzer.filters.push(this.fil3);
		this.fil4 = { lowLimit : 15000., highLimit : 20000., isolate : true};
		this.analyzer.filters.push(this.fil4);
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
	}
	,switchcam: function(ts) {
		var tmp = ts.bar % 4 == 0;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.analyzer.update();
		var fft = wl_sounds_SoundWL.getFFT();
		this.mats[0].color = this.fil1.max > this.fil1t?this.cols[0]:new THREE.Color(16777215);
		this.mats[1].color = this.fil2.max > this.fil2t?this.cols[1]:new THREE.Color(16777215);
		this.mats[2].color = this.fil3.max > this.fil3t?this.cols[2]:new THREE.Color(16777215);
		this.mats[3].color = this.fil4.max > this.fil4t?this.cols[3]:new THREE.Color(16777215);
		var _g1 = 0;
		var _g = fft.frequencyLeft.length;
		while(_g1 < _g) {
			var i = _g1++;
			var m = this.boxes[i];
			var ind = Math.floor(Math.max(0,i + Math.sin(ts.toMilliseconds() / 500 + i) * 30)) % this.analyzer.filters.length;
			if(ind > fft.frequencyLeft.length / 2) {
				ind = fft.frequencyLeft.length - ind;
			}
			if(ind < 0) {
				ind = 0;
			}
			if(ind > fft.frequencyLeft.length) {
				ind = fft.frequencyLeft.length - 1;
			}
			m.scale.y = Math.max(0.01,this.analyzer.filters[ind].max / 2 * 150);
			m.material = this.whiteMat;
		}
		var _g11 = this.fil1.lowLimit;
		var _g2 = this.fil1.highLimit;
		while(_g11 < _g2) {
			var ind1 = Math.floor(_g11++ / 20000 * this.boxes.length);
			this.boxes[ind1].material = this.mats[0];
		}
		var _g12 = this.fil2.lowLimit;
		var _g3 = this.fil2.highLimit;
		while(_g12 < _g3) {
			var ind2 = Math.floor(_g12++ / 20000 * this.boxes.length);
			this.boxes[ind2].material = this.mats[1];
		}
		var _g13 = this.fil3.lowLimit;
		var _g4 = this.fil3.highLimit;
		while(_g13 < _g4) {
			var ind3 = Math.floor(_g13++ / 20000 * this.boxes.length);
			this.boxes[ind3].material = this.mats[2];
		}
		var _g14 = this.fil4.lowLimit;
		var _g5 = this.fil4.highLimit;
		while(_g14 < _g5) {
			var ind4 = Math.floor(_g14++ / 20000 * this.boxes.length);
			this.boxes[ind4].material = this.mats[3];
		}
		this.soundtexture.needsUpdate = true;
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		folder.add(this.analyzer,"historySize").step(1).min(1).max(50);
		var f1 = folder.addFolder("filter 1");
		f1.add(this.fil1,"lowLimit").min(0).max(20000);
		f1.add(this.fil1,"highLimit").min(0).max(20000);
		f1.add(this,"fil1t").min(0).max(1);
		var f11 = folder.addFolder("filter 2");
		f11.add(this.fil2,"lowLimit").min(0).max(20000);
		f11.add(this.fil2,"highLimit").min(0).max(20000);
		f11.add(this,"fil2t").min(0).max(1);
		var f12 = folder.addFolder("filter 3");
		f12.add(this.fil3,"lowLimit").min(0).max(20000);
		f12.add(this.fil3,"highLimit").min(0).max(20000);
		f12.add(this,"fil3t").min(0).max(1);
		var f13 = folder.addFolder("filter 4");
		f13.add(this.fil4,"lowLimit").min(0).max(20000);
		f13.add(this.fil4,"highLimit").min(0).max(20000);
		f13.add(this,"fil4t").min(0).max(1);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: ffttest_FFTest
});
var generic_Money = function() {
	this.angle = 0;
	this.theta = 0;
	this.phi = 0;
	THREE.Object3D.call(this);
	if(generic_Money.material == null) {
		generic_Money.material = generic_Money.getMaterial();
	}
	var pc = generic_Money.geometry;
	this.mesh = new THREE.Mesh(pc,generic_Money.material);
	this.add(this.mesh);
};
generic_Money.__name__ = ["generic","Money"];
generic_Money.updateMoney = function() {
	if(generic_Money.material == null) {
		return;
	}
	generic_Money.material.uniforms.time.value = wl_core_Demo.instance.previousTS.toMilliseconds() / 1000;
};
generic_Money.getMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("moneyplane.frag");
	params.vertexShader = haxe_Resource.getString("moneyplane.vert");
	params.uniforms = { fftMap : { type : "t", value : DemoMain.SOUNDTEXTURE}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [1,1]}, wallX : { type : "f", value : 0.1}, sizeX : { type : "f", value : 0.25}, wallY : { type : "f", value : 0.1}, sizeY : { type : "f", value : 0.25}, intensity : { type : "f", value : 1.0}, bill : { type : "t", value : wl_core_Assets.getTexture("bill.png")}};
	params.transparent = true;
	params.side = THREE.DoubleSide;
	return new THREE.ShaderMaterial(params);
};
generic_Money.__super__ = THREE.Object3D;
generic_Money.prototype = $extend(THREE.Object3D.prototype,{
	__class__: generic_Money
});
var godrays_AdditiveBlendingShader = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.scene = new THREE.Scene();
	this.uniforms = { tDiffuse : { type : "t"}, tAdd : { type : "t"}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("additiveblending.frag"), vertexShader : haxe_Resource.getString("additiveblending.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
godrays_AdditiveBlendingShader.__name__ = ["godrays","AdditiveBlendingShader"];
godrays_AdditiveBlendingShader.prototype = {
	render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: godrays_AdditiveBlendingShader
};
var godrays_GodRays = function() {
	this.filters = [];
	this.started = false;
	this.stopped = false;
	this.lightPillars = [];
	wl_core_Part.call(this);
};
godrays_GodRays.__name__ = ["godrays","GodRays"];
godrays_GodRays.__super__ = wl_core_Part;
godrays_GodRays.prototype = $extend(wl_core_Part.prototype,{
	initanalyzer: function() {
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 12;
		this.filters = [];
		var filter = { lowLimit : 50, highLimit : 400, isolate : true};
		this.filters.push(filter);
		this.analyzer.filters.push(filter);
		var filter1 = { lowLimit : 7000, highLimit : 10000, isolate : true};
		this.filters.push(filter1);
		this.analyzer.filters.push(filter1);
	}
	,init: function() {
		this.renderFormat = THREE.RGBAFormat;
		wl_core_Part.prototype.init.call(this);
		this.initanalyzer();
		this.initStandardScene();
		this.occlusionScene = new THREE.Scene();
		var aspect = wl_core_Config.RESOLUTION[0] / wl_core_Config.RESOLUTION[1];
		var lp = new godrays_LightPillar();
		this.scene.add(lp);
		this.lightPillars.push(lp);
		this.scene.add(new THREE.AmbientLight(1052688));
		var blackMaterial = new THREE.MeshBasicMaterial({ color : 0});
		var whiteMaterial = new THREE.MeshBasicMaterial({ color : DemoMain.HILIGHT.getHex()});
		var actuallyWhiteMaterial = new THREE.MeshBasicMaterial({ color : DemoMain.WHITE.getHex()});
		var lpc = new godrays_LightPillar(blackMaterial);
		this.lightPillars.push(lpc);
		this.occlusionScene.add(lpc);
		var helper = new THREE.BoxHelper(lpc);
		this.camera.position.set(50,20,50);
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		var geometry = helper.geometry;
		geometry.computeBoundingBox();
		var box = geometry.boundingBox.size();
		var size = box.multiplyScalar(0.7);
		this.lightCube = new THREE.Mesh(new THREE.BoxGeometry(size.x,10,size.z),whiteMaterial);
		console.log(size);
		this.occlusionScene.add(this.lightCube);
		this.lightCube.position.set(0,-60,0);
		this.addTrigger(new wl_core_TimeSig(0,0,1,0,wl_core_TimeSig.RELATIVE),$bind(this,this.launch));
		this.addTrigger(new wl_core_TimeSig(7,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.fadeout));
		this.addTrigger(new wl_core_TimeSig(14,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.end));
		this.occlusionCamera = this.camera.clone();
		this.setupPostprocessing();
		this.postProcessing.bloom.enabled = false;
		var boxmesh = new THREE.Mesh(new THREE.BoxGeometry(60,400,60),new THREE.MeshStandardMaterial({ color : DemoMain.WHITE.getHex()}));
		boxmesh.material.side = THREE.BackSide;
		boxmesh.receiveShadow = true;
		this.scene.add(boxmesh);
		this.oclusionpass.uniforms.exposure.value = 0;
	}
	,end: function(ts) {
		console.log("end is near");
		createjs.Tween.get(this.oclusionpass.uniforms.exposure).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0),createjs.Ease.quadIn);
		var _g = 0;
		var _g1 = this.lightPillars;
		while(_g < _g1.length) {
			var lpi = _g1[_g];
			++_g;
			createjs.Tween.get(lpi.sun).to({ intensity : 0},null,new wl_core_TimeSig(2,0,0,0,wl_core_TimeSig.RELATIVE).toMilliseconds());
		}
		this.stopped = true;
	}
	,launch: function(ts) {
		var movement = new wl_core_TimeSig(7,2,0,0,wl_core_TimeSig.ABSOLUTE).toMilliseconds();
		createjs.Tween.get(this.lightCube.position).to({ y : 130},movement,createjs.Ease.quadInOut).to({ y : 0},movement,createjs.Ease.quadInOut);
		var _g = 0;
		var _g1 = this.lightPillars;
		while(_g < _g1.length) {
			var lpi = _g1[_g];
			++_g;
			lpi.start();
			createjs.Tween.get(lpi.sun).to({ distance : 50},null,new wl_core_TimeSig(5,0,0,0,wl_core_TimeSig.RELATIVE).toMilliseconds());
		}
		createjs.Tween.get(this.oclusionpass.uniforms.exposure).to({ value : 0.21},wl_core_TimeSig.milliseconds(0,2,0,0),createjs.Ease.quadOut);
	}
	,fadeout: function(ts) {
		var _g = 0;
		var _g1 = this.lightPillars;
		while(_g < _g1.length) {
			var lpi = _g1[_g];
			++_g;
			createjs.Tween.get(lpi.sun).to({ distance : 30},null,new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.RELATIVE).toMilliseconds());
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		this.camera.lookAt(this.lightCube.position.clone().add(new THREE.Vector3((wl_util_Random.nextFloat() - 0.5) * 0.15 * (1 - partial),(wl_util_Random.nextFloat() - 0.5) * 0.15 * (1 - partial),(wl_util_Random.nextFloat() - 0.5) * 0.15 * (1 - partial))));
		var delta1 = ts.toMilliseconds() / 1000;
		this.oclusionpass.uniforms.lightPosition.value = wl_util_ScreenUtil.projectToNormalizedScreenPosition(this.lightCube.position,this.camera);
		this.occlusionCamera.position.copy(this.camera.position);
		this.occlusionCamera.quaternion.copy(this.camera.quaternion);
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta1);
	}
	,render: function(ts,frameTime) {
		this.analyzer.update();
		if(!this.stopped && this.started) {
			if(this.filters[0].triggered) {
				this.oclusionpass.set_exposure(this.filters[0].max + .1);
			} else {
				this.oclusionpass.set_exposure(0.21);
			}
		}
		wl_core_Graphics.instance.renderer.setClearColor(0);
		wl_core_Graphics.instance.renderer.setClearAlpha(0);
		this.occlusionComposer.render();
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,setupPostprocessing: function() {
		this.occlusionRenderTarget = new THREE.WebGLRenderTarget(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1]);
		this.occlusionComposer = new THREE.EffectComposer(wl_core_Graphics.instance.renderer,this.occlusionRenderTarget);
		var rp = new THREE.RenderPass(this.occlusionScene,this.occlusionCamera);
		this.occlusionComposer.addPass(rp);
		this.copyPass = new THREE.ShaderPass(THREE.CopyShader);
		this.copyPass.renderToScreen = true;
		this.oclusionpass = new godrays_VolumetricShader();
		this.oclusionpass.needsSwap = false;
		this.oclusionpass.renderToScreen = false;
		this.occlusionComposer.addPass(this.oclusionpass);
		var pass = new godrays_AdditiveBlendingShader();
		pass.uniforms.tAdd.value = this.occlusionRenderTarget.texture;
		pass.renderToScreen = false;
		var composerlist = [];
		composerlist.push(pass);
		var composerlist2 = this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : false, standard : true, displacement : false, bloom : true, gray : false});
		this.postProcessing.standard.set_gamma(1);
		var _g = 0;
		while(_g < composerlist2.length) {
			var p = composerlist2[_g];
			++_g;
			composerlist.push(p);
		}
		this.postProcessing.standard.enabled = true;
		this.initComposer(composerlist);
		this.renderPass.clearAlpha = 0;
	}
	,__class__: godrays_GodRays
});
var godrays_LightPillar = function(m) {
	this.movement = 10000;
	this.w = 2;
	THREE.Object3D.call(this);
	this.sun = new THREE.PointLight(DemoMain.HILIGHT.getHex(),2.0,10);
	this.sun.position.set(0,0,0);
	this.add(this.sun);
	var geo = new THREE.BoxGeometry(this.w,this.w,this.w);
	if(m == null) {
		m = new THREE.MeshStandardMaterial({ color : DemoMain.LIGHT.getHex()});
	}
	this.sun.castShadow = true;
	var _g = 0;
	while(_g < 40) {
		var y = _g++;
		var _g1 = -3;
		while(_g1 < 3) {
			var x = _g1++;
			var _g2 = -3;
			while(_g2 < 3) {
				var z = _g2++;
				if(x > -3 && x < 2 && z > -3 && z < 2) {
					continue;
				}
				if((y + 1) % 3 == 0) {
					continue;
				}
				var mesh = new THREE.Mesh(geo,m);
				mesh.castShadow = true;
				mesh.position.set(x * this.w,y * this.w,z * this.w);
				this.add(mesh);
			}
		}
	}
};
godrays_LightPillar.__name__ = ["godrays","LightPillar"];
godrays_LightPillar.__super__ = THREE.Object3D;
godrays_LightPillar.prototype = $extend(THREE.Object3D.prototype,{
	start: function() {
		var tmp = 40 * this.w;
		createjs.Tween.get(this.sun.position,{ loop : true}).to({ y : tmp},this.movement,createjs.Ease.quadInOut).to({ y : 0},this.movement,createjs.Ease.quadInOut);
	}
	,__class__: godrays_LightPillar
});
var godrays_VolumetricShader = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { tDiffuse : { type : "t"}, lightPosition : { type : "v2", value : new THREE.Vector2(0.5,0.5)}, exposure : { type : "f", value : 0.21}, decay : { type : "f", value : 0.96}, density : { type : "f", value : 0.55}, weight : { type : "f", value : 0.75}, samples : { type : "i", value : 70}, brigthness : { type : "f", value : 1}};
	this.lightPosition = new THREE.Vector2(0.5,0.5);
	this.samples = 70;
	this.weight = 0.75;
	this.density = 0.55;
	this.decay = 0.96;
	this.exposure = 0.21;
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("volumetric.vert"), fragmentShader : haxe_Resource.getString("volumetric.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
godrays_VolumetricShader.__name__ = ["godrays","VolumetricShader"];
godrays_VolumetricShader.prototype = {
	set_exposure: function(value) {
		this.exposure = value;
		this.uniforms.exposure.value = value;
		return value;
	}
	,set_decay: function(value) {
		this.decay = value;
		this.uniforms.decay.value = value;
		return value;
	}
	,set_density: function(value) {
		this.density = value;
		this.uniforms.density.value = value;
		return value;
	}
	,set_weight: function(value) {
		this.weight = value;
		this.uniforms.weight.value = value;
		return value;
	}
	,set_samples: function(value) {
		this.samples = value;
		this.uniforms.samples.value = value;
		return value;
	}
	,set_lightPosition: function(value) {
		this.lightPosition = value;
		this.uniforms.lightPosition.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Volumetric");
		f.add(this,"exposure").step(0.01).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.exposure.value = _gthis.exposure;
		});
		f.add(this.lightPosition,"x").step(0.01).min(0).max(1).onChange(function(val1) {
			_gthis.uniforms.lightPosition.value = _gthis.lightPosition;
		});
		f.add(this.lightPosition,"y").step(0.01).min(0).max(1).onChange(function(val2) {
			_gthis.uniforms.lightPosition.value = _gthis.lightPosition;
		});
		f.add(this,"decay").step(0.01).min(0).max(1).onChange(function(val3) {
			_gthis.uniforms.decay.value = _gthis.decay;
		});
		f.add(this,"density").step(0.01).min(0).max(1).onChange(function(val4) {
			_gthis.uniforms.density.value = _gthis.density;
		});
		f.add(this,"weight").step(0.01).min(0).max(1).onChange(function(val5) {
			_gthis.uniforms.weight.value = _gthis.weight;
		});
		f.add(this,"samples").step(1).min(0).max(500).onChange(function(val6) {
			_gthis.uniforms.samples.value = _gthis.samples;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: godrays_VolumetricShader
};
var greets_Greets = function() {
	this.greetGeoms = [];
	this.greets = ["","HBC","FGJ","ASD","API","MFX","CNCD","NPLI","ADAPT","EPOCH","ALUMNI","DAMONES","KEWLERS","MERCURY","SCENESAT","QUADTRIP","PARAGUAY","DARKLITE","TRACTION","HEDELMAE","DEKADENCE","FAIRLIGHT","PRIMITIVE","JUMALAUTA","BYTERAPERS","MEMORY LEEK","MATT CURRENT","ANANASMURSKA","ARTLINE DESIGNS","PYROTECH"];
	THREE.Object3D.call(this);
	this.init();
};
greets_Greets.__name__ = ["greets","Greets"];
greets_Greets.__super__ = THREE.Object3D;
greets_Greets.prototype = $extend(THREE.Object3D.prototype,{
	init: function() {
		var boxmat = new THREE.MeshBasicMaterial({ color : DemoMain.HILIGHT.getHex(), map : wl_core_Assets.getTexture("greets.png")});
		this.greetMat = boxmat;
		var _g = 0;
		var _g1 = this.greets;
		while(_g < _g1.length) {
			var greet = _g1[_g];
			++_g;
			var geometry = new THREE.TextGeometry(greet,{ font : DemoMain.font2, size : 8.8, height : 0.1, curveSegments : 12, bevelEnabled : false, bevelThickness : 10, bevelSize : 8, bevelSegments : 5});
			geometry.center();
			if(greet == "QUADTRIP") {
				geometry.translate(0,-1.2000000000000002,0);
			}
			this.greetGeoms.push(geometry);
		}
		this.greet = new THREE.Mesh(this.greetGeoms[0],boxmat);
		this.greet.position.y = 20;
		var gm = new THREE.Mesh(new THREE.CylinderGeometry(30,30,5,20,2,true),boxmat);
		gm.material.side = THREE.DoubleSide;
		this.add(gm);
	}
	,nextGreet: function() {
		if(this.greetGeoms.length == 0) {
			this.greet.visible = false;
		} else {
			this.greet.geometry = this.greetGeoms.shift();
		}
	}
	,__class__: greets_Greets
});
var groundlines_GroundLines = function() {
	this.prevcam = 0;
	this.camdelta = 0;
	this.mountainsMP = 0;
	this.mountainsV = 0;
	this.mind = 0;
	this.money = [];
	this.stripes = [];
	this.tunnelmp = 0;
	this.fftIntensity = 0;
	wl_core_Part.call(this);
};
groundlines_GroundLines.__name__ = ["groundlines","GroundLines"];
groundlines_GroundLines.__super__ = wl_core_Part;
groundlines_GroundLines.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.camera.fov = 16;
		this.camera.updateProjectionMatrix();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false, aspect : true, cga : true, vhs : true}));
		this.ground = new groundlines_LinePlane();
		this.ground.rotation.y = Math.PI;
		this.ground.rotation.x = Math.PI / 2;
		this.mountains = new groundlines_LinePlane(new THREE.PlaneGeometry(100,500,40,200));
		this.mountains.rotation.y = Math.PI;
		this.mountains.rotation.x = Math.PI / 2;
		this.mountains.position.z = 100;
		this.mountains.material.uniforms.mountains.value = 0;
		this.scene.add(this.mountains);
		this.postProcessing.bloom.strength = 0;
		this.postProcessing.bloom.threshold = 0.1;
		this.postProcessing.bloom.radius = 0.05;
		this.postProcessing.vhs.set_jitter(0.3);
		this.postProcessing.vhs.set_size(0.985);
		this.postProcessing.vhs.set_intensity(0.66);
		this.postProcessing.cga.set_amount(1);
		this.postProcessing.aspect.set_aspect(1.3333333333333333);
		this.postProcessing.standard.set_brightness(-1);
		this.postProcessing.distortedTV.set_vignAmount(0);
		console.log("DATA: " + Std.string(wl_sounds_SoundWL.getFFT().frequencyLeft));
		this.soundtexture = DemoMain.SOUNDTEXTURE;
		this.ground.material.uniforms.fftMap.value = this.soundtexture;
		this.mountains.material.uniforms.fftMap.value = this.soundtexture;
		this.ground.material.uniforms.speed.value = 1;
		this.rndcc = new wl_demo_RandomCameraController(this.camera,6,[this.ground],123415,[wl_demo_CameraController.STATIC],[10,100],new THREE.Box3(new THREE.Vector3(-40,10,-40),new THREE.Vector3(40,80,40)));
		var _g = 0;
		while(_g < 1990) {
			++_g;
			var m = new generic_Money();
			m.mesh.position.x = 10 + Math.random() * 10;
			m.mesh.position.z = 10 + Math.random() * 10;
			m.position.x = Math.random() * 400 - 200;
			m.position.y = Math.random() * 400 - 200;
			m.position.z = Math.random() * 400 - 200;
			m.scale.set(0.03,0.03,0.03);
			m.visible = false;
			m.rotation.x = wl_util_Random.nextFloat() * 3.14;
			m.rotation.y = wl_util_Random.nextFloat() * 3.14;
			m.rotation.z = wl_util_Random.nextFloat() * 3.14;
			this.scene.add(m);
			this.money.push(m);
		}
		this.kapital = new THREE.Mesh(new THREE.PlaneGeometry(1,0.5),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("kapital.png"), side : THREE.FrontSide}));
		this.kapital.scale.setY(-1);
		this.kapital.position.x = 0.5;
		this.kapital.position.y = -2 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.kapitalAdd = new THREE.Mesh(new THREE.PlaneGeometry(1,0.5625),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("kapital.png"), side : THREE.FrontSide, blending : THREE.AdditiveBlending}));
		this.sun = new THREE.Mesh(new THREE.SphereGeometry(20,32,40),new THREE.MeshBasicMaterial({ color : 16776960}));
		var sm = new THREE.MeshBasicMaterial({ color : 0});
		var sg = new THREE.BoxGeometry(45,0.8,2);
		var _g1 = 0;
		while(_g1 < 5) {
			var i = _g1++;
			var stripe = new THREE.Mesh(sg,sm);
			stripe.scale.set(1,1.5 + 2 * i / 6,1);
			stripe.position.y = 0 - i * 2.1 * 2;
			stripe.position.z = -30;
			stripe.scale.set(1,1 - i * 0.8,1);
			this.sun.add(stripe);
			this.stripes.push(stripe);
		}
		this.scene.add(this.sun);
		this.sun.scale.z = 0.1;
		this.sun.position.z = 350;
		this.sun.position.y = -23;
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.filterL = { highLimit : 2200, lowLimit : 2000, isolate : false, channels : wl_sounds_Channels.left};
		this.filterR = { highLimit : 10000, lowLimit : 8000, isolate : false, channels : wl_sounds_Channels.both};
		this.analyzer.filters.push(this.filterL);
		this.analyzer.filters.push(this.filterR);
		this.analyzer.historySize = 1;
		this.testarossa = new outrun_Testarossa();
		this.scene.add(this.testarossa);
		this.testarossa.rotateY(Math.PI);
		this.testarossa.position.z = 200;
		this.testarossa.position.y = -3;
		this.road = new outrun_OutrunLinePlane();
		this.scene.add(this.road);
		this.road.rotation.y = Math.PI;
		this.road.rotation.x = Math.PI / 2;
		this.road.position.y = 0.01;
		this.road.position.z = 500;
		this.road.set_speed(0);
		this.road.mesh.material.opacity = 0;
		this.road.mesh.material.transparent = true;
		this.road.material.uniforms.fftMap.value = this.soundtexture;
		this.tunnel = new tunnel_TunnelCylinder();
		this.tunnel.scale.x = 0.5;
		this.tunnel.scale.z = 0.5;
		this.tunnel.position.y = -4;
		this.tunnel.material.uniforms.mountains.value = 0;
		this.tunnel.material.uniforms.speed.value = 0.43;
		this.scene.add(this.tunnel);
		this.tunnel.position.z = 550;
		this.tunnel.rotation.x = Math.PI / 2;
		this.tunnel.material.side = THREE.DoubleSide;
		this.tunnelLights = [];
		var _g2 = 0;
		while(_g2 < 8) {
			var p = _g2++;
			var tl = new THREE.RectAreaLight(16777215,80,15,15);
			tl.position.z = 447.5 - p * 50;
			tl.position.y = 0.25;
			tl.rotateZ(Math.PI / 2);
			this.tunnelLights.push(tl);
			this.scene.add(tl);
		}
		this.camera.position.set(0,2.2,-45);
		this.board = new wl_demo_SceneBoard();
		var cc1 = new wl_demo_CameraController(this.camera);
		cc1.initStatic(new THREE.Vector3(0,2.2,-45),new THREE.Vector3(0,3,0));
		new wl_demo_CameraController(this.camera).initLinear([new THREE.Vector3(0,2.2,-45),new THREE.Vector3(0,2.2,350)],[new THREE.Vector3(0,3,0),new THREE.Vector3(0,3,400)]);
		this.board.add(new wl_core_TimeSig(0,0,0,0),new wl_core_TimeSig(18,2,0,0),cc1);
		this.addTrigger(new wl_core_TimeSig(2,0,0,0),$bind(this,this.showkvg));
		this.addTrigger(new wl_core_TimeSig(10,0,0,0),$bind(this,this.backto169));
		this.addTrigger(new wl_core_TimeSig(11,2,0,0),$bind(this,this.showkapital));
		this.addTrigger(new wl_core_TimeSig(16,0,0,0),$bind(this,this.hidekapital));
		this.addTrigger(new wl_core_TimeSig(19,0,0,0),$bind(this,this.sendCamera));
		this.addTrigger(new wl_core_TimeSig(18,0,0,0),$bind(this,this.sendCar));
		this.scene.add(new THREE.AmbientLight(4210752));
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		generic_Money.material.uniforms.intensity.value = 0.2;
		this.testarossa.setEnvmap(null,false);
		wl_core_Demo.instance.overlay.add(this.kapital);
		createjs.Tween.get(this.sun.position).to({ y : 24},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadOut);
		createjs.Tween.get(this).wait(wl_core_TimeSig.milliseconds(0,0,0,0)).to({ fftIntensity : 35},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadOut).wait(wl_core_TimeSig.milliseconds(4,0,0,0)).to({ fftIntensity : 8},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this).wait(wl_core_TimeSig.milliseconds(4,0,0,0)).to({ mountainsMP : 1.1},wl_core_TimeSig.milliseconds(8,0,0,0),createjs.Ease.quadOut);
		this.board.start(ts);
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,stop: function() {
		wl_core_Part.prototype.stop.call(this);
		wl_core_Demo.instance.overlay.remove(this.kapital);
		wl_core_Demo.instance.overlay.remove(this.kapitalAdd);
		this.kapitalAdd.position.z = 1;
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		wl_util_DatGuiHelper.addVector(folder.addFolder("mountainpos"),this.mountains.position);
		wl_util_DatGuiHelper.addVector(folder.addFolder("groundpos"),this.ground.position);
	}
	,showkvg: function(ts) {
	}
	,backto169: function(ts) {
		createjs.Tween.get(this.postProcessing.aspect.uniforms.aspect).to({ value : 1.7777777777777777},wl_core_TimeSig.milliseconds(1,2,0,0));
		createjs.Tween.get(this.postProcessing.cga.uniforms.amount).to({ value : 0},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 2},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.vhs.uniforms.jitter).to({ value : 0.05},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.vhs.uniforms.intensity).to({ value : 0.1},wl_core_TimeSig.milliseconds(4,0,0,0));
	}
	,showkapital: function(ts) {
		createjs.Tween.get(this.kapital.position).to({ y : 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0]},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadOut);
		createjs.Tween.get(this.road.mesh.material).to({ opacity : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,hidekapital: function(ts) {
		createjs.Tween.get(this).to({ mountainsMP : 1.5},wl_core_TimeSig.milliseconds(6,0,0,0));
		createjs.Tween.get(this.kapital.position).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ y : 2 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0]},wl_core_TimeSig.milliseconds(1,0,0,0),createjs.Ease.quadIn);
		createjs.Tween.get(this.camera,{ onChange : ($_=this.camera,$bind($_,$_.updateProjectionMatrix))}).wait(wl_core_TimeSig.milliseconds(0,0,1,0)).to({ fov : 80},wl_core_TimeSig.milliseconds(10,0,0,0),createjs.Ease.quadIn);
	}
	,sendCamera: function(ts) {
		createjs.Tween.get(this.camera.position).to({ z : 300, y : 1},wl_core_TimeSig.milliseconds(5,0,0,0),createjs.Ease.sineIn).to({ z : 650},wl_core_TimeSig.milliseconds(8,0,0,0));
	}
	,sendCar: function(ts) {
		this.testarossa.position.z = -80;
		this.testarossa.position.y = 0;
		this.tunnel.position.y = 0;
		createjs.Tween.get(this.testarossa.position,{ onChange : $bind(this,this.spendMoney)}).to({ z : 780},wl_core_TimeSig.milliseconds(9,0,0,0),createjs.Ease.sineIn);
		createjs.Tween.get(this).wait(wl_core_TimeSig.milliseconds(1,0,0,0)).to({ tunnelmp : 1},wl_core_TimeSig.milliseconds(1,0,0,0));
		var _g = 0;
		var _g1 = this.stripes;
		while(_g < _g1.length) ++_g;
	}
	,spendMoney: function() {
		if(wl_util_Random.nextFloat() - 0.98 < 0.51 && this.testarossa.position.z > 100) {
			var _g = 0;
			while(_g < 4) {
				++_g;
				var m = this.money[this.mind % this.money.length];
				this.mind++;
				m.visible = true;
				m.position.x = this.testarossa.position.x;
				m.position.y = this.testarossa.position.y;
				m.position.z = this.testarossa.position.z;
				createjs.Tween.get(m.position).to({ y : 2 * Math.random() + this.testarossa.position.y, x : this.testarossa.position.x + Math.random() - 0.5},null,2000 + Math.random() * 3000);
			}
		}
	}
	,mountain_up: function(ts) {
		this.mountainsV += 0.2;
		var tmp = ts.bar % 4 == 0;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.board.update(ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		this.testarossa.update(frameTime);
		var fft = wl_sounds_SoundWL.getFFT();
		this.camdelta = this.camera.position.z - this.prevcam;
		this.prevcam = this.camera.position.z;
		var _g = 0;
		var _g1 = this.money;
		while(_g < _g1.length) {
			var m = _g1[_g];
			++_g;
			m.rotation.x += frameTime / 16.6 * 0.01;
			m.rotation.z += frameTime / 16.6 * 0.02;
			m.rotation.y += frameTime / 16.6 * 0.015;
			if(m.position.z - this.camera.position.z < 50) {
				m.position.z += this.camdelta * 0.7;
			}
		}
		var lc = fft.frequencyLeft[80] / 255;
		var rc = fft.frequencyRight[80] / 255;
		this.ground.material.uniforms.fft.value = [lc * this.fftIntensity,rc * this.fftIntensity];
		this.mountains.material.uniforms.fft.value = [lc * this.fftIntensity,rc * this.fftIntensity];
		this.ground.material.uniforms.time.value = ts.toMilliseconds() / 5000;
		this.mountains.material.uniforms.time.value = ts.toMilliseconds() / 5000;
		this.mountains.material.uniforms.mountains.value = (0.9 + Math.min(1,this.mountainsV * 0.2)) * this.mountainsMP;
		this.mountainsV /= 1.1;
		this.road.material.uniforms.fft.value = [lc * this.fftIntensity,rc * this.fftIntensity];
		this.road.material.uniforms.time.value = ts.toMilliseconds() / 5000;
		this.road.render();
		this.soundtexture.needsUpdate = true;
		if(fft.frequencyLeft != null) {
			this.tunnel.material.uniforms.fft.value = [fft.frequencyLeft[100] / 255 * 15 * this.tunnelmp,fft.frequencyRight[100] / 255 * 15 * this.tunnelmp];
		}
		this.tunnel.material.uniforms.time.value = ts.toMilliseconds() / 5000;
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: groundlines_GroundLines
});
var groundlines_LinePlane = function(geo) {
	THREE.Object3D.call(this);
	var pc = geo != null?geo:new THREE.PlaneGeometry(100,100,40,40);
	this.material = groundlines_LinePlane.getMaterial();
	this.mesh = new THREE.Mesh(pc,this.material);
	this.add(this.mesh);
};
groundlines_LinePlane.__name__ = ["groundlines","LinePlane"];
groundlines_LinePlane.getMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("LinePlane.frag");
	params.vertexShader = haxe_Resource.getString("LinePlane.vert");
	params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [0,0]}, wallX : { type : "f", value : 0.0105}, sizeX : { type : "f", value : 0.025}, wallY : { type : "f", value : 0.042}, sizeY : { type : "f", value : 0.1}};
	return new THREE.ShaderMaterial(params);
};
groundlines_LinePlane.__super__ = THREE.Object3D;
groundlines_LinePlane.prototype = $extend(THREE.Object3D.prototype,{
	__class__: groundlines_LinePlane
});
var haxe_IMap = function() { };
haxe_IMap.__name__ = ["haxe","IMap"];
var haxe_Resource = function() { };
haxe_Resource.__name__ = ["haxe","Resource"];
haxe_Resource.getString = function(name) {
	var _g = 0;
	var _g1 = haxe_Resource.content;
	while(_g < _g1.length) {
		var x = _g1[_g];
		++_g;
		if(x.name == name) {
			if(x.str != null) {
				return x.str;
			}
			return haxe_crypto_Base64.decode(x.data).toString();
		}
	}
	return null;
};
var haxe_Timer = function(time_ms) {
	var me = this;
	this.id = setInterval(function() {
		me.run();
	},time_ms);
};
haxe_Timer.__name__ = ["haxe","Timer"];
haxe_Timer.delay = function(f,time_ms) {
	var t = new haxe_Timer(time_ms);
	t.run = function() {
		t.stop();
		f();
	};
	return t;
};
haxe_Timer.prototype = {
	stop: function() {
		if(this.id == null) {
			return;
		}
		clearInterval(this.id);
		this.id = null;
	}
	,run: function() {
	}
	,__class__: haxe_Timer
};
var haxe_io_Bytes = function(data) {
	this.length = data.byteLength;
	this.b = new Uint8Array(data);
	this.b.bufferValue = data;
	data.hxBytes = this;
	data.bytes = this.b;
};
haxe_io_Bytes.__name__ = ["haxe","io","Bytes"];
haxe_io_Bytes.ofString = function(s) {
	var a = [];
	var i = 0;
	while(i < s.length) {
		var c = s.charCodeAt(i++);
		if(55296 <= c && c <= 56319) {
			c = c - 55232 << 10 | s.charCodeAt(i++) & 1023;
		}
		if(c <= 127) {
			a.push(c);
		} else if(c <= 2047) {
			a.push(192 | c >> 6);
			a.push(128 | c & 63);
		} else if(c <= 65535) {
			a.push(224 | c >> 12);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		} else {
			a.push(240 | c >> 18);
			a.push(128 | c >> 12 & 63);
			a.push(128 | c >> 6 & 63);
			a.push(128 | c & 63);
		}
	}
	return new haxe_io_Bytes(new Uint8Array(a).buffer);
};
haxe_io_Bytes.prototype = {
	getString: function(pos,len) {
		if(pos < 0 || len < 0 || pos + len > this.length) {
			throw new js__$Boot_HaxeError(haxe_io_Error.OutsideBounds);
		}
		var s = "";
		var b = this.b;
		var fcc = String.fromCharCode;
		var i = pos;
		var max = pos + len;
		while(i < max) {
			var c = b[i++];
			if(c < 128) {
				if(c == 0) {
					break;
				}
				s += fcc(c);
			} else if(c < 224) {
				s += fcc((c & 63) << 6 | b[i++] & 127);
			} else if(c < 240) {
				s += fcc((c & 31) << 12 | (b[i++] & 127) << 6 | b[i++] & 127);
			} else {
				var u = (c & 15) << 18 | (b[i++] & 127) << 12 | (b[i++] & 127) << 6 | b[i++] & 127;
				s += fcc((u >> 10) + 55232);
				s += fcc(u & 1023 | 56320);
			}
		}
		return s;
	}
	,toString: function() {
		return this.getString(0,this.length);
	}
	,__class__: haxe_io_Bytes
};
var haxe_crypto_Base64 = function() { };
haxe_crypto_Base64.__name__ = ["haxe","crypto","Base64"];
haxe_crypto_Base64.decode = function(str,complement) {
	if(complement == null) {
		complement = true;
	}
	if(complement) {
		while(HxOverrides.cca(str,str.length - 1) == 61) str = HxOverrides.substr(str,0,-1);
	}
	return new haxe_crypto_BaseCode(haxe_crypto_Base64.BYTES).decodeBytes(haxe_io_Bytes.ofString(str));
};
var haxe_crypto_BaseCode = function(base) {
	var len = base.length;
	var nbits = 1;
	while(len > 1 << nbits) ++nbits;
	if(nbits > 8 || len != 1 << nbits) {
		throw new js__$Boot_HaxeError("BaseCode : base length must be a power of two.");
	}
	this.base = base;
	this.nbits = nbits;
};
haxe_crypto_BaseCode.__name__ = ["haxe","crypto","BaseCode"];
haxe_crypto_BaseCode.prototype = {
	initTable: function() {
		var tbl = [];
		var _g = 0;
		while(_g < 256) tbl[_g++] = -1;
		var _g1 = 0;
		var _g2 = this.base.length;
		while(_g1 < _g2) {
			var i = _g1++;
			tbl[this.base.b[i]] = i;
		}
		this.tbl = tbl;
	}
	,decodeBytes: function(b) {
		var nbits = this.nbits;
		if(this.tbl == null) {
			this.initTable();
		}
		var tbl = this.tbl;
		var size = b.length * nbits >> 3;
		var out = new haxe_io_Bytes(new ArrayBuffer(size));
		var buf = 0;
		var curbits = 0;
		var pin = 0;
		var pout = 0;
		while(pout < size) {
			while(curbits < 8) {
				curbits += nbits;
				buf <<= nbits;
				var i = tbl[b.b[pin++]];
				if(i == -1) {
					throw new js__$Boot_HaxeError("BaseCode : invalid encoded char");
				}
				buf |= i;
			}
			curbits -= 8;
			out.b[pout++] = buf >> curbits & 255 & 255;
		}
		return out;
	}
	,__class__: haxe_crypto_BaseCode
};
var haxe_ds_BalancedTree = function() {
};
haxe_ds_BalancedTree.__name__ = ["haxe","ds","BalancedTree"];
haxe_ds_BalancedTree.prototype = {
	set: function(key,value) {
		this.root = this.setLoop(key,value,this.root);
	}
	,get: function(key) {
		var node = this.root;
		while(node != null) {
			var c = this.compare(key,node.key);
			if(c == 0) {
				return node.value;
			}
			if(c < 0) {
				node = node.left;
			} else {
				node = node.right;
			}
		}
		return null;
	}
	,setLoop: function(k,v,node) {
		if(node == null) {
			return new haxe_ds_TreeNode(null,k,v,null);
		}
		var c = this.compare(k,node.key);
		if(c == 0) {
			return new haxe_ds_TreeNode(node.left,k,v,node.right,node == null?0:node._height);
		} else if(c < 0) {
			return this.balance(this.setLoop(k,v,node.left),node.key,node.value,node.right);
		} else {
			return this.balance(node.left,node.key,node.value,this.setLoop(k,v,node.right));
		}
	}
	,balance: function(l,k,v,r) {
		var hl = l == null?0:l._height;
		var hr = r == null?0:r._height;
		if(hl > hr + 2) {
			var _this = l.left;
			var tmp = _this == null?0:_this._height;
			var _this1 = l.right;
			if(tmp >= (_this1 == null?0:_this1._height)) {
				return new haxe_ds_TreeNode(l.left,l.key,l.value,new haxe_ds_TreeNode(l.right,k,v,r));
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l.left,l.key,l.value,l.right.left),l.right.key,l.right.value,new haxe_ds_TreeNode(l.right.right,k,v,r));
			}
		} else if(hr > hl + 2) {
			var _this2 = r.right;
			var tmp1 = _this2 == null?0:_this2._height;
			var _this3 = r.left;
			if(tmp1 > (_this3 == null?0:_this3._height)) {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left),r.key,r.value,r.right);
			} else {
				return new haxe_ds_TreeNode(new haxe_ds_TreeNode(l,k,v,r.left.left),r.left.key,r.left.value,new haxe_ds_TreeNode(r.left.right,r.key,r.value,r.right));
			}
		} else {
			return new haxe_ds_TreeNode(l,k,v,r,(hl > hr?hl:hr) + 1);
		}
	}
	,compare: function(k1,k2) {
		return Reflect.compare(k1,k2);
	}
	,__class__: haxe_ds_BalancedTree
};
var haxe_ds_TreeNode = function(l,k,v,r,h) {
	if(h == null) {
		h = -1;
	}
	this.left = l;
	this.key = k;
	this.value = v;
	this.right = r;
	if(h == -1) {
		var tmp;
		var _this = this.left;
		var tmp1 = _this == null?0:_this._height;
		var _this1 = this.right;
		if(tmp1 > (_this1 == null?0:_this1._height)) {
			var _this2 = this.left;
			if(_this2 == null) {
				tmp = 0;
			} else {
				tmp = _this2._height;
			}
		} else {
			var _this3 = this.right;
			if(_this3 == null) {
				tmp = 0;
			} else {
				tmp = _this3._height;
			}
		}
		this._height = tmp + 1;
	} else {
		this._height = h;
	}
};
haxe_ds_TreeNode.__name__ = ["haxe","ds","TreeNode"];
haxe_ds_TreeNode.prototype = {
	__class__: haxe_ds_TreeNode
};
var haxe_ds_EnumValueMap = function() {
	haxe_ds_BalancedTree.call(this);
};
haxe_ds_EnumValueMap.__name__ = ["haxe","ds","EnumValueMap"];
haxe_ds_EnumValueMap.__interfaces__ = [haxe_IMap];
haxe_ds_EnumValueMap.__super__ = haxe_ds_BalancedTree;
haxe_ds_EnumValueMap.prototype = $extend(haxe_ds_BalancedTree.prototype,{
	compare: function(k1,k2) {
		var d = k1[1] - k2[1];
		if(d != 0) {
			return d;
		}
		var p1 = k1.slice(2);
		var p2 = k2.slice(2);
		if(p1.length == 0 && p2.length == 0) {
			return 0;
		}
		return this.compareArgs(p1,p2);
	}
	,compareArgs: function(a1,a2) {
		var ld = a1.length - a2.length;
		if(ld != 0) {
			return ld;
		}
		var _g1 = 0;
		var _g = a1.length;
		while(_g1 < _g) {
			var i = _g1++;
			var d = this.compareArg(a1[i],a2[i]);
			if(d != 0) {
				return d;
			}
		}
		return 0;
	}
	,compareArg: function(v1,v2) {
		if(Reflect.isEnumValue(v1) && Reflect.isEnumValue(v2)) {
			return this.compare(v1,v2);
		} else if((v1 instanceof Array) && v1.__enum__ == null && ((v2 instanceof Array) && v2.__enum__ == null)) {
			return this.compareArgs(v1,v2);
		} else {
			return Reflect.compare(v1,v2);
		}
	}
	,__class__: haxe_ds_EnumValueMap
});
var haxe_ds_ObjectMap = function() {
	this.h = { __keys__ : { }};
};
haxe_ds_ObjectMap.__name__ = ["haxe","ds","ObjectMap"];
haxe_ds_ObjectMap.__interfaces__ = [haxe_IMap];
haxe_ds_ObjectMap.prototype = {
	set: function(key,value) {
		var id = key.__id__ || (key.__id__ = ++haxe_ds_ObjectMap.count);
		this.h[id] = value;
		this.h.__keys__[id] = key;
	}
	,keys: function() {
		var a = [];
		for( var key in this.h.__keys__ ) {
		if(this.h.hasOwnProperty(key)) {
			a.push(this.h.__keys__[key]);
		}
		}
		return HxOverrides.iter(a);
	}
	,iterator: function() {
		return { ref : this.h, it : this.keys(), hasNext : function() {
			return this.it.hasNext();
		}, next : function() {
			var i = this.it.next();
			return this.ref[i.__id__];
		}};
	}
	,__class__: haxe_ds_ObjectMap
};
var haxe_ds_StringMap = function() {
	this.h = { };
};
haxe_ds_StringMap.__name__ = ["haxe","ds","StringMap"];
haxe_ds_StringMap.__interfaces__ = [haxe_IMap];
haxe_ds_StringMap.prototype = {
	setReserved: function(key,value) {
		if(this.rh == null) {
			this.rh = { };
		}
		this.rh["$" + key] = value;
	}
	,getReserved: function(key) {
		if(this.rh == null) {
			return null;
		} else {
			return this.rh["$" + key];
		}
	}
	,existsReserved: function(key) {
		if(this.rh == null) {
			return false;
		}
		return this.rh.hasOwnProperty("$" + key);
	}
	,__class__: haxe_ds_StringMap
};
var haxe_io_Error = { __ename__ : true, __constructs__ : ["Blocked","Overflow","OutsideBounds","Custom"] };
haxe_io_Error.Blocked = ["Blocked",0];
haxe_io_Error.Blocked.toString = $estr;
haxe_io_Error.Blocked.__enum__ = haxe_io_Error;
haxe_io_Error.Overflow = ["Overflow",1];
haxe_io_Error.Overflow.toString = $estr;
haxe_io_Error.Overflow.__enum__ = haxe_io_Error;
haxe_io_Error.OutsideBounds = ["OutsideBounds",2];
haxe_io_Error.OutsideBounds.toString = $estr;
haxe_io_Error.OutsideBounds.__enum__ = haxe_io_Error;
haxe_io_Error.Custom = function(e) { var $x = ["Custom",3,e]; $x.__enum__ = haxe_io_Error; $x.toString = $estr; return $x; };
var haxe_io_FPHelper = function() { };
haxe_io_FPHelper.__name__ = ["haxe","io","FPHelper"];
haxe_io_FPHelper.i32ToFloat = function(i) {
	var sign = 1 - (i >>> 31 << 1);
	var exp = i >>> 23 & 255;
	var sig = i & 8388607;
	if(sig == 0 && exp == 0) {
		return 0.0;
	}
	return sign * (1 + Math.pow(2,-23) * sig) * Math.pow(2,exp - 127);
};
haxe_io_FPHelper.floatToI32 = function(f) {
	if(f == 0) {
		return 0;
	}
	var af = f < 0?-f:f;
	var exp = Math.floor(Math.log(af) / 0.6931471805599453);
	if(exp < -127) {
		exp = -127;
	} else if(exp > 128) {
		exp = 128;
	}
	return (f < 0?-2147483648:0) | exp + 127 << 23 | Math.round((af / Math.pow(2,exp) - 1) * 8388608) & 8388607;
};
var js__$Boot_HaxeError = function(val) {
	Error.call(this);
	this.val = val;
	this.message = String(val);
	if(Error.captureStackTrace) {
		Error.captureStackTrace(this,js__$Boot_HaxeError);
	}
};
js__$Boot_HaxeError.__name__ = ["js","_Boot","HaxeError"];
js__$Boot_HaxeError.wrap = function(val) {
	if((val instanceof Error)) {
		return val;
	} else {
		return new js__$Boot_HaxeError(val);
	}
};
js__$Boot_HaxeError.__super__ = Error;
js__$Boot_HaxeError.prototype = $extend(Error.prototype,{
	__class__: js__$Boot_HaxeError
});
var js_Boot = function() { };
js_Boot.__name__ = ["js","Boot"];
js_Boot.getClass = function(o) {
	if((o instanceof Array) && o.__enum__ == null) {
		return Array;
	} else {
		var cl = o.__class__;
		if(cl != null) {
			return cl;
		}
		var name = js_Boot.__nativeClassName(o);
		if(name != null) {
			return js_Boot.__resolveNativeClass(name);
		}
		return null;
	}
};
js_Boot.__string_rec = function(o,s) {
	if(o == null) {
		return "null";
	}
	if(s.length >= 5) {
		return "<...>";
	}
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) {
		t = "object";
	}
	switch(t) {
	case "function":
		return "<function>";
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) {
					return o[0];
				}
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2;
				var _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) {
						str += "," + js_Boot.__string_rec(o[i],s);
					} else {
						str += js_Boot.__string_rec(o[i],s);
					}
				}
				return str + ")";
			}
			var l = o.length;
			var i1;
			var str1 = "[";
			s += "\t";
			var _g11 = 0;
			var _g2 = l;
			while(_g11 < _g2) {
				var i2 = _g11++;
				str1 += (i2 > 0?",":"") + js_Boot.__string_rec(o[i2],s);
			}
			str1 += "]";
			return str1;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString && typeof(tostr) == "function") {
			var s2 = o.toString();
			if(s2 != "[object Object]") {
				return s2;
			}
		}
		var k = null;
		var str2 = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) {
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str2.length != 2) {
			str2 += ", \n";
		}
		str2 += s + k + " : " + js_Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str2 += "\n" + s + "}";
		return str2;
	case "string":
		return o;
	default:
		return String(o);
	}
};
js_Boot.__interfLoop = function(cc,cl) {
	if(cc == null) {
		return false;
	}
	if(cc == cl) {
		return true;
	}
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0;
		var _g = intf.length;
		while(_g1 < _g) {
			var i = intf[_g1++];
			if(i == cl || js_Boot.__interfLoop(i,cl)) {
				return true;
			}
		}
	}
	return js_Boot.__interfLoop(cc.__super__,cl);
};
js_Boot.__instanceof = function(o,cl) {
	if(cl == null) {
		return false;
	}
	switch(cl) {
	case Array:
		if((o instanceof Array)) {
			return o.__enum__ == null;
		} else {
			return false;
		}
		break;
	case Bool:
		return typeof(o) == "boolean";
	case Dynamic:
		return true;
	case Float:
		return typeof(o) == "number";
	case Int:
		if(typeof(o) == "number") {
			return (o|0) === o;
		} else {
			return false;
		}
		break;
	case String:
		return typeof(o) == "string";
	default:
		if(o != null) {
			if(typeof(cl) == "function") {
				if(o instanceof cl) {
					return true;
				}
				if(js_Boot.__interfLoop(js_Boot.getClass(o),cl)) {
					return true;
				}
			} else if(typeof(cl) == "object" && js_Boot.__isNativeObj(cl)) {
				if(o instanceof cl) {
					return true;
				}
			}
		} else {
			return false;
		}
		if(cl == Class && o.__name__ != null) {
			return true;
		}
		if(cl == Enum && o.__ename__ != null) {
			return true;
		}
		return o.__enum__ == cl;
	}
};
js_Boot.__nativeClassName = function(o) {
	var name = js_Boot.__toStr.call(o).slice(8,-1);
	if(name == "Object" || name == "Function" || name == "Math" || name == "JSON") {
		return null;
	}
	return name;
};
js_Boot.__isNativeObj = function(o) {
	return js_Boot.__nativeClassName(o) != null;
};
js_Boot.__resolveNativeClass = function(name) {
	return $global[name];
};
var js_html_compat_ArrayBuffer = function(a) {
	if((a instanceof Array) && a.__enum__ == null) {
		this.a = a;
		this.byteLength = a.length;
	} else {
		var len = a;
		this.a = [];
		var _g1 = 0;
		var _g = len;
		while(_g1 < _g) this.a[_g1++] = 0;
		this.byteLength = len;
	}
};
js_html_compat_ArrayBuffer.__name__ = ["js","html","compat","ArrayBuffer"];
js_html_compat_ArrayBuffer.sliceImpl = function(begin,end) {
	var u = new Uint8Array(this,begin,end == null?null:end - begin);
	var result = new ArrayBuffer(u.byteLength);
	new Uint8Array(result).set(u);
	return result;
};
js_html_compat_ArrayBuffer.prototype = {
	slice: function(begin,end) {
		return new js_html_compat_ArrayBuffer(this.a.slice(begin,end));
	}
	,__class__: js_html_compat_ArrayBuffer
};
var js_html_compat_Float32Array = function() { };
js_html_compat_Float32Array.__name__ = ["js","html","compat","Float32Array"];
js_html_compat_Float32Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		var _g2 = [];
		var _g21 = 0;
		var _g11 = arr.length << 2;
		while(_g21 < _g11) {
			var i1 = _g21++;
			_g2.push(0);
		}
		arr.buffer = new js_html_compat_ArrayBuffer(_g2);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset >> 2;
		}
		arr = [];
		var _g12 = 0;
		var _g3 = length;
		while(_g12 < _g3) {
			var i2 = _g12++;
			var val = buffer.a[offset++] | buffer.a[offset++] << 8 | buffer.a[offset++] << 16 | buffer.a[offset++] << 24;
			arr.push(haxe_io_FPHelper.i32ToFloat(val));
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		var buffer1 = [];
		var _g4 = 0;
		while(_g4 < arr.length) {
			var f = arr[_g4];
			++_g4;
			var i3 = haxe_io_FPHelper.floatToI32(f);
			buffer1.push(i3 & 255);
			buffer1.push(i3 >> 8 & 255);
			buffer1.push(i3 >> 16 & 255);
			buffer1.push(i3 >>> 24);
		}
		arr.byteLength = arr.length << 2;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(buffer1);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Float32Array._subarray;
	arr.set = js_html_compat_Float32Array._set;
	return arr;
};
js_html_compat_Float32Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Float32Array._subarray = function(start,end) {
	var a = js_html_compat_Float32Array._new(this.slice(start,end));
	a.byteOffset = start * 4;
	return a;
};
var js_html_compat_Uint8Array = function() { };
js_html_compat_Uint8Array.__name__ = ["js","html","compat","Uint8Array"];
js_html_compat_Uint8Array._new = function(arg1,offset,length) {
	var arr;
	if(typeof(arg1) == "number") {
		arr = [];
		var _g1 = 0;
		var _g = arg1;
		while(_g1 < _g) {
			var i = _g1++;
			arr[i] = 0;
		}
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else if(js_Boot.__instanceof(arg1,js_html_compat_ArrayBuffer)) {
		var buffer = arg1;
		if(offset == null) {
			offset = 0;
		}
		if(length == null) {
			length = buffer.byteLength - offset;
		}
		if(offset == 0) {
			arr = buffer.a;
		} else {
			arr = buffer.a.slice(offset,offset + length);
		}
		arr.byteLength = arr.length;
		arr.byteOffset = offset;
		arr.buffer = buffer;
	} else if((arg1 instanceof Array) && arg1.__enum__ == null) {
		arr = arg1.slice();
		arr.byteLength = arr.length;
		arr.byteOffset = 0;
		arr.buffer = new js_html_compat_ArrayBuffer(arr);
	} else {
		throw new js__$Boot_HaxeError("TODO " + Std.string(arg1));
	}
	arr.subarray = js_html_compat_Uint8Array._subarray;
	arr.set = js_html_compat_Uint8Array._set;
	return arr;
};
js_html_compat_Uint8Array._set = function(arg,offset) {
	if(js_Boot.__instanceof(arg.buffer,js_html_compat_ArrayBuffer)) {
		var a = arg;
		if(arg.byteLength + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g1 = 0;
		var _g = arg.byteLength;
		while(_g1 < _g) {
			var i = _g1++;
			this[i + offset] = a[i];
		}
	} else if((arg instanceof Array) && arg.__enum__ == null) {
		var a1 = arg;
		if(a1.length + offset > this.byteLength) {
			throw new js__$Boot_HaxeError("set() outside of range");
		}
		var _g11 = 0;
		var _g2 = a1.length;
		while(_g11 < _g2) {
			var i1 = _g11++;
			this[i1 + offset] = a1[i1];
		}
	} else {
		throw new js__$Boot_HaxeError("TODO");
	}
};
js_html_compat_Uint8Array._subarray = function(start,end) {
	var a = js_html_compat_Uint8Array._new(this.slice(start,end));
	a.byteOffset = start;
	return a;
};
var moneyball_MoneyBall = function(first) {
	this.money = [];
	wl_core_Part.call(this);
};
moneyball_MoneyBall.__name__ = ["moneyball","MoneyBall"];
moneyball_MoneyBall.__super__ = wl_core_Part;
moneyball_MoneyBall.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : true, colorHilight : true, pixelate : false, distortedTV : false, standard : true, displacement : false, bloom : true, gray : false, vhs : true}));
		this.postProcessing.vhs.set_intensity(0.03);
		this.postProcessing.vhs.set_jitter(0.05);
		this.postProcessing.vhs.set_size(0.3);
		this.postProcessing.bloom.strength = 1.39;
		this.postProcessing.bloom.radius = 1.14;
		this.postProcessing.bloom.threshold = 0.33;
		this.postProcessing.colorHilight.set_range(0.14);
		this.postProcessing.colorHilight.set_value1(1);
		this.postProcessing.colorHilight.set_value2(1);
		this.postProcessing.colorHilight.set_amount(1);
		this.postProcessing.colorHilight.set_color1(15335679);
		this.postProcessing.colorHilight.set_color2(15335679);
		this.postProcessing.colorHilight.set_original(1);
		this.rndcc = new wl_demo_RandomCameraController(this.camera,26,[],12115,[wl_demo_CameraController.BEZIER],[50,70],new THREE.Box3(new THREE.Vector3(160,195,-130),new THREE.Vector3(-200,100,30)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchcam));
		this.camera.position.z = 3.0;
		this.camera.position.x = 0.8;
		this.camera.position.y = 0.2;
		this.camera.rotation.x = 0;
		this.camera.rotation.y = 0;
		this.camera.rotation.z = 0;
		this.scene.add(this.camera);
		var _g = 0;
		while(_g < 1000) {
			++_g;
			var m = new generic_Money();
			m.mesh.position.x = Math.random() * 3;
			m.mesh.position.z = Math.random() * 3;
			var deg = Math.random() * 2 * Math.PI;
			var dist = Math.random() * 250;
			m.position.x = Math.sin(deg) * dist;
			m.position.y = Math.cos(Math.random() * Math.PI) * dist;
			m.position.z = Math.cos(deg) * dist;
			m.rotation.x = wl_util_Random.nextFloat() * 3.14;
			m.rotation.y = wl_util_Random.nextFloat() * 3.14;
			m.rotation.z = wl_util_Random.nextFloat() * 3.14;
			m.mesh.rotation.x = Math.PI / 2;
			m.theta = Math.random() * Math.PI * 2;
			m.phi = Math.random() * Math.PI * 2 - Math.PI;
			this.scene.add(m);
			this.money.push(m);
		}
		this.soundtexture = DemoMain.SOUNDTEXTURE;
		this.clearColor = 16777215;
		this.scene.add(new THREE.AmbientLight(16777215));
		this.filter = { channels : wl_sounds_Channels.both, highLimit : 1000, lowLimit : 200, isolate : true};
		this.soundanalyzer = new wl_sounds_SoundAnalyzer();
		this.soundanalyzer.filters.push(this.filter);
		this.addTrigger(new wl_core_TimeSig(94,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.beginlead));
		this.addTrigger(new wl_core_TimeSig(97,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.stoplead));
		this.addTrigger(new wl_core_TimeSig(101,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.beginlead));
		this.addTrigger(new wl_core_TimeSig(104,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.stoplead));
		this.addTrigger(new wl_core_TimeSig(106,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.out));
	}
	,beginlead: function(ts) {
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.range).to({ value : 0.3},wl_core_TimeSig.milliseconds(3,0,0,0));
		createjs.Tween.get(this.postProcessing.rgbShift.uniforms.bshift).to({ value : -0.01},wl_core_TimeSig.milliseconds(3,0,0,0));
		createjs.Tween.get(this.postProcessing.rgbShift.uniforms.gshift).to({ value : 0.01},wl_core_TimeSig.milliseconds(3,0,0,0));
	}
	,stoplead: function(ts) {
		createjs.Tween.get(this.postProcessing.rgbShift.uniforms.bshift).to({ value : -0.0},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.rgbShift.uniforms.gshift).to({ value : 0.0},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.range).to({ value : 0.14},wl_core_TimeSig.milliseconds(3,0,0,0));
	}
	,out: function(ts) {
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : -1},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,switchcam: function(ts) {
		if(ts.bar % 2 == 0) {
			this.rndcc.swap();
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		generic_Money.material.uniforms.intensity.value = 0.5;
		this.postProcessing.bloom.strength = 7;
		this.postProcessing.bloom.radius = 1;
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 1.39},wl_core_TimeSig.milliseconds(1,0,0,0));
		this.postProcessing.standard.set_brightness(0.5);
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		this.soundanalyzer.update();
		this.postProcessing.bloom.radius = 0.9 + (this.filter.max - 0.2) * 0.3;
		this.rndcc.updateLength(wl_core_TimeSig.milliseconds(2,0,0,0));
		var t = ts.toMilliseconds() / 1000;
		var _g = 0;
		var _g1 = this.money;
		while(_g < _g1.length) {
			var m = _g1[_g];
			++_g;
			var d = Math.sin(m.theta + m.phi + t * 0.8 + Math.cos(m.theta + m.phi + t * 0.3) * 0.5) * 45 + 50;
			m.position.x = Math.sin(m.phi) * Math.cos(m.theta) * d;
			m.position.y = Math.sin(m.phi) * Math.sin(m.theta) * d;
			m.position.z = Math.cos(m.phi) * d;
			m.rotation.x += frameTime / 16.6 * 0.05;
			m.rotation.z += frameTime / 16.6 * 0.025;
			m.rotation.y += frameTime / 16.6 * 0.055;
			m.position.y -= frameTime / 16.6 * 0.05;
		}
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: moneyball_MoneyBall
});
var outrun_City = function(gridSize,innerGridSize,roadLength,generateGreets) {
	this.greets = ["HBC","FGJ","ASD","API","MFX","CNCD","NPLI","ADAPT","EPOCH","ALUMNI","DAMONES","KEWLERS","MERCURY","SCENESAT","QUADTRIP","PARAGUAY","DARKLITE","TRACTION","HEDELMAE","DEKADENCE","FAIRLIGHT","PRIMITIVE","JUMALAUTA","BYTERAPERS","MEMORY LEEK","MATT CURRENT","ANANASMURSKA","ARTLINE DESIGNS","PYROTECH"];
	this.shadow = new THREE.Color(3158096);
	this.light = new THREE.Color(16777215);
	THREE.Object3D.call(this);
	if(gridSize == null) {
		gridSize = new THREE.Vector2(6,6);
	}
	if(innerGridSize == null) {
		innerGridSize = new THREE.Vector2(4,4);
	}
	if(roadLength == null) {
		roadLength = new THREE.Vector2(3,3);
	}
	if(generateGreets == null) {
		generateGreets = false;
	}
	this.geometry = new THREE.CubeGeometry(1,1,1);
	this.geometry.applyMatrix(new THREE.Matrix4().makeTranslation(0,0.5,0));
	this.geometry.faces.splice(7,1);
	this.geometry.faces.splice(6,1);
	var params = { };
	params.fragmentShader = haxe_Resource.getString("colorEdgeShader.frag");
	params.vertexShader = haxe_Resource.getString("colorEdgeShader.vert");
	params.uniforms = { time : { type : "f", value : 0.0}};
	this.windowMaterial = new THREE.ShaderMaterial(params);
	this.windowMaterialScene = new THREE.Scene();
	this.windowMaterialCamera = new THREE.OrthographicCamera(-1,1,1,-1);
	this.windowMaterialCamera.position.z = 100;
	this.windowMaterialCamera.lookAt(new THREE.Vector3(0,0,0));
	this.windowMaterialScene.add(new THREE.Mesh(new THREE.BoxGeometry(2,2,2),this.windowMaterial));
	this.renderTg = wl_core_Graphics.instance.getRenderTarget();
	wl_core_Graphics.instance.renderer.render(this.windowMaterialScene,this.windowMaterialCamera,this.renderTg);
	this.materialPool = [new THREE.MeshPhongMaterial({ map : this.renderTg.texture, vertexColors : THREE.VertexColors, emissive : 1052688}),new THREE.MeshPhongMaterial({ map : this.renderTg.texture, vertexColors : THREE.VertexColors, emissive : 1052720}),new THREE.MeshPhongMaterial({ map : this.renderTg.texture, vertexColors : THREE.VertexColors, emissive : 1053968}),new THREE.MeshPhongMaterial({ map : this.renderTg.texture, vertexColors : THREE.VertexColors, emissive : 2102544})];
	this.buildings = [];
	var _g1 = 0;
	var _g = gridSize.x;
	while(_g1 < _g) {
		var x = _g1++;
		var _g3 = 0;
		var _g2 = gridSize.y;
		while(_g3 < _g2) {
			var z = _g3++;
			var _g5 = 0;
			var _g4 = innerGridSize.x;
			while(_g5 < _g4) {
				var xs = _g5++;
				var _g7 = 0;
				var _g6 = innerGridSize.y;
				while(_g7 < _g6) {
					var zs = _g7++;
					var buildingMesh = this.createBuilding(this.materialPool[wl_util_Random.range(0,this.materialPool.length - 1)]);
					buildingMesh.rotateY(Math.PI * 2 * wl_util_Random.nextFloat());
					buildingMesh.position.x = x * (innerGridSize.x + roadLength.x) + xs * 2;
					buildingMesh.position.z = z * (innerGridSize.y + roadLength.y) + zs * 2;
					buildingMesh.scale.x = 0.80 + wl_util_Random.nextFloat() * 0.6;
					buildingMesh.scale.z = buildingMesh.scale.x;
					buildingMesh.scale.y = 1 + wl_util_Random.nextFloat() * wl_util_Random.nextFloat() * 11;
					this.add(buildingMesh);
					this.buildings.push(buildingMesh);
				}
			}
		}
	}
	this.citySize = new THREE.Box3().setFromObject(this).size();
};
outrun_City.__name__ = ["outrun","City"];
outrun_City.__super__ = THREE.Object3D;
outrun_City.prototype = $extend(THREE.Object3D.prototype,{
	createBuilding: function(m) {
		var bgeo = new THREE.Geometry();
		var startmesh = new THREE.Mesh(this.geometry);
		startmesh.scale.x = 0.5;
		startmesh.scale.z = 0.5;
		THREE.GeometryUtils.merge(bgeo,new THREE.Mesh(this.geometry));
		var _g1 = 1;
		var _g = wl_util_Random.range(4,20);
		while(_g1 < _g) {
			var i = _g1++;
			var mesh2 = new THREE.Mesh(this.geometry);
			var mgeo = mesh2.geometry;
			mesh2.position.set(wl_util_Random.nextFloat() - 0.5,0,wl_util_Random.nextFloat() - 0.5);
			mesh2.scale.set(1,wl_util_Random.nextFloat() * 0.78,1);
			var value = 1 - Math.random() * Math.random();
			var baseColor = new THREE.Color().setRGB(value + Math.random() * 0.1,value,value + Math.random() * 0.1);
			var topColor = baseColor.clone().multiply(this.light);
			var bottomColor = baseColor.clone().multiply(this.shadow);
			var geometry = mesh2.geometry;
			var _g3 = 0;
			var _g2 = geometry.faces.length;
			while(_g3 < _g2) {
				var j = _g3++;
				if(j == 2) {
					geometry.faces[j].vertexColors = [baseColor,baseColor,baseColor,baseColor];
				} else {
					geometry.faces[j].vertexColors = [topColor,bottomColor,bottomColor,topColor];
				}
			}
			THREE.GeometryUtils.merge(bgeo,mesh2);
		}
		return new THREE.Mesh(bgeo,m);
	}
	,update: function(ts,speed) {
		var _g = 0;
		var _g1 = this.buildings;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			b.position.z += speed;
			if(b.position.z > this.citySize.z) {
				b.position.z -= this.citySize.z;
			}
		}
	}
	,render: function(ts) {
		this.windowMaterial.uniforms.time.value = ts.toMilliseconds() / 1000;
		wl_core_Graphics.instance.renderer.render(this.windowMaterialScene,this.windowMaterialCamera,this.renderTg);
	}
	,__class__: outrun_City
});
var outrun_Outrun = function(first) {
	this.first = false;
	var _gthis = this;
	wl_core_Part.call(this);
	this.first = first;
	var loader = new THREE.ColladaLoader();
	loader.options.convertUpAxis = true;
	var loadcb = function(collada) {
		console.log("foo");
		var mesh = collada.scene;
		mesh.translateY(0.5);
		outrun_Testarossa.MESH = mesh;
		wl_util_LoadManager.manualLoaderComplete(loader);
	};
	wl_util_LoadManager.addManualLoader(loader);
	var treeloader = new THREE.ColladaLoader();
	treeloader.options.convertUpAxis = true;
	var loadpalm = function(collada1) {
		_gthis.treecollada = collada1.scene;
		_gthis.treecollada.scale.multiplyScalar(0.5);
		wl_util_LoadManager.manualLoaderComplete(treeloader);
	};
	wl_util_LoadManager.addManualLoader(treeloader);
	loader.load("./models/testarossa.dae",loadcb);
	treeloader.load("./models/palm.dae",loadpalm);
};
outrun_Outrun.__name__ = ["outrun","Outrun"];
outrun_Outrun.__super__ = wl_core_Part;
outrun_Outrun.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : true, rgbShift : true, colorHilight : true, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false, cga : false, vhs : true}));
		this.postProcessing.dof.set_focalLength(90);
		this.postProcessing.dof.set_fstop(0.04);
		this.postProcessing.dof.set_maxblur(0.2);
		this.postProcessing.dof.set_bias(0.3);
		this.postProcessing.dof.set_gain(0.2);
		this.postProcessing.dof.set_threshold(0.3);
		this.postProcessing.dof.set_shaderFocus(false);
		this.postProcessing.distortedTV.set_vignAmount(0);
		this.postProcessing.bloom.radius = 0.05;
		this.postProcessing.bloom.strength = 6;
		this.postProcessing.bloom.threshold = 0.5;
		this.postProcessing.vhs.set_intensity(0.02);
		this.postProcessing.vhs.set_jitter(0.1);
		this.postProcessing.vhs.set_size(0.3);
		this.cubecamera = new THREE.CubeCamera(1,1000,512);
		this.testarossa = new outrun_Testarossa(this.cubecamera.renderTarget.texture);
		this.testarossa.position.y = -0.51;
		this.scene.add(this.cubecamera);
		this.scene.add(this.testarossa);
		var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
		this.soundtexture = DemoMain.SOUNDTEXTURE;
		this.ground = new outrun_OutrunLinePlane();
		this.ground.rotation.y = Math.PI;
		this.ground.rotation.x = Math.PI / 2;
		this.ground.material.uniforms.fftMap.value = this.soundtexture;
		this.ground.position.z = -180;
		this.scene.add(this.ground);
		var hemiLight = new THREE.HemisphereLight(8421504,0,0.8);
		this.scene.add(new THREE.AmbientLight(9474192));
		this.pl = new THREE.PointLight(16777215,0,40);
		this.pl.position.x = 15;
		this.pl.position.z = -3;
		this.pl.position.y = 15;
		this.scene.add(this.pl);
		this.bottomlight = new THREE.PointLight(16777215,0.0,10);
		this.clearColor = 16777215;
		this.city = new outrun_City(new THREE.Vector2(2,18),new THREE.Vector2(2,2),new THREE.Vector2(6.8,5),true);
		this.city.position.z = -410;
		this.city.position.x = -21.5;
		this.city.position.y = -3;
		this.city.scale.set(4,4,4);
		this.scene.add(this.city);
		var cc_pan = new wl_demo_CameraController(this.camera);
		cc_pan.initBezier([new THREE.Vector3(1.1,22,-2),new THREE.Vector3(2,10,-1),new THREE.Vector3(2,0.25,2)],[new THREE.Vector3(0,0,0),new THREE.Vector3(0,0.2,-1),new THREE.Vector3(0,0.5,-5)]);
		var cc_top_to_down = new wl_demo_CameraController(this.camera);
		cc_top_to_down.initLinear([new THREE.Vector3(4.1,22,-7),new THREE.Vector3(4.1,12,-7)],[new THREE.Vector3(0,0,0),new THREE.Vector3(0,0,0)]);
		var cc_wheel = new wl_demo_CameraController(this.camera);
		cc_wheel.initLinear([new THREE.Vector3(3.75,0.4,-4),new THREE.Vector3(3.75,1,7)],[new THREE.Vector3(-3.75,1.5,-4),new THREE.Vector3(-3,1.0,5)]);
		var cc_side = new wl_demo_CameraController(this.camera);
		cc_side.initLinear([new THREE.Vector3(3.2144,0.763622,6.45767),new THREE.Vector3(3.2144,0.763622,4.55767)],[new THREE.Vector3(-36.19446377948321,3.038068475344594,-85.42139806139176),new THREE.Vector3(-36.19446377948321,3.038068475344594,-88.42139806139176)]);
		var cc_testarossa_logo = new wl_demo_CameraController(this.camera);
		cc_testarossa_logo.initLinear([new THREE.Vector3(-2.3,0.725,3.635),new THREE.Vector3(1.82,0.725,3.635)],[new THREE.Vector3(-2.3,0.725,-10),new THREE.Vector3(1.82,0.725,-10)]);
		var cc_indoors = new wl_demo_CameraController(this.camera);
		cc_indoors.initLinear([new THREE.Vector3(-0.0,0.88,1.05),new THREE.Vector3(0.15,0.88,1.25)],[new THREE.Vector3(-1.2,0.6,-2),new THREE.Vector3(-1.0,0.6,-2)]);
		this.board = new wl_demo_SceneBoard();
		this.board.add(new wl_core_TimeSig(0,0,0,0),new wl_core_TimeSig(4,0,0,0),cc_top_to_down);
		this.board.add(new wl_core_TimeSig(4,0,0,0),new wl_core_TimeSig(8,0,0,0),cc_wheel);
		this.board.add(new wl_core_TimeSig(8,0,0,0),new wl_core_TimeSig(16,0,0,0),cc_side);
		this.board.add(new wl_core_TimeSig(16,0,0,0),new wl_core_TimeSig(20,0,0,0),cc_testarossa_logo);
		this.board.add(new wl_core_TimeSig(20,0,0,0),new wl_core_TimeSig(24,0,0,0),cc_indoors);
		this.city.visible = false;
		this.testarossa.speed = 0;
		this.testarossa.position.z = 10;
		this.scene.add(new THREE.HemisphereLight(10526880,1052688,0.4));
		this.addTrigger(new wl_core_TimeSig(6,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.accelerate));
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			_gthis.city.visible = true;
		});
		this.over = new THREE.Mesh(new THREE.PlaneGeometry(1,wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0]),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("over_cocaine.png"), side : THREE.FrontSide}));
		this.over.scale.setY(-1);
		this.over.position.x = 0.5;
		this.over.material.opacity = 1;
		this.over.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.tunnel = new tunnel_TunnelCylinder();
		this.tunnel.material.uniforms.mountains.value = 0;
		this.scene.add(this.tunnel);
		this.tunnel.position.z = 0;
		this.tunnel.scale.x = this.tunnel.scale.z = 1.5;
		this.tunnel.position.z = -200;
		this.tunnel.rotation.x = Math.PI / 2;
		this.tunnel.material.side = THREE.BackSide;
		this.tunnel.material.uniforms.speed.value = -0.7;
		this.tunnel.material.transparent = true;
		if(this.first) {
			this.addTrigger(new wl_core_TimeSig(44,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.outro));
		}
		this.addTrigger(new wl_core_TimeSig(48,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.intro));
		this.addTrigger(new wl_core_TimeSig(8,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.hideover));
		var skysphere = new THREE.Mesh(new THREE.BoxGeometry(1000,1000,1000),dollarmat_DollarMat.material);
		skysphere.material.side = THREE.BackSide;
		skysphere.position.z = -200;
		this.scene.add(skysphere);
	}
	,hideover: function(ts) {
		wl_core_Demo.instance.overlay.remove(this.over);
	}
	,outro: function(ts) {
		var _gthis = this;
		this.postProcessing.colorHilight.testSweep = true;
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.amount).to({ value : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.range).to({ value : 0.6},wl_core_TimeSig.milliseconds(4,0,0,0)).call(function() {
			_gthis.testarossa.setEnvmap(_gthis.cubecamera.renderTarget.texture,true);
		});
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.original).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.value1).to({ value : 0.5},wl_core_TimeSig.milliseconds(1,0,0,0));
		createjs.Tween.get(this.postProcessing.rgbShift.uniforms.rshift).to({ value : -0.05},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.rgbShift.uniforms.gshift).to({ value : 0.05},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.bloom).wait(wl_core_TimeSig.milliseconds(2,0,0,0)).to({ strength : 6},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0.9},wl_core_TimeSig.milliseconds(4,0,0,0));
	}
	,intro: function(ts) {
		this.postProcessing.colorHilight.testSweep = true;
		this.postProcessing.colorHilight.set_amount(1);
		this.postProcessing.colorHilight.set_range(0.6);
		this.postProcessing.colorHilight.set_original(0);
		this.postProcessing.colorHilight.set_value1(0.5);
		this.postProcessing.rgbShift.set_rshift(-0.05);
		this.postProcessing.rgbShift.set_gshift(0.05);
		this.postProcessing.bloom.strength = 6;
		this.postProcessing.standard.set_brightness(0.9);
		this.tunnel.material.uniforms.angle.value = 0.3;
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.amount).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.range).to({ value : 0.0},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.original).to({ value : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.colorHilight.uniforms.value1).to({ value : 0.0},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.rgbShift.uniforms.rshift).to({ value : -0.0},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.rgbShift.uniforms.gshift).to({ value : 0.0},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0.0},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,accelerate: function(ts) {
	}
	,stop: function() {
		wl_core_Part.prototype.stop.call(this);
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.board.start(ts);
		var time = wl_core_TimeSig.milliseconds(2,0,0,0);
		createjs.Tween.get(this.pl).to({ intensity : 1},time);
		createjs.Tween.get(this.bottomlight).to({ intensity : 1},time);
		createjs.Tween.get(this.pl.position).to({ y : 15},time);
		createjs.Tween.get(this.testarossa.position).to({ z : 0},time).wait(wl_core_TimeSig.milliseconds(2,0,0,0)).to({ z : -1},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.testarossa).wait(time).to({ speed : 0.10},time);
		createjs.Tween.get(this.ground.material.uniforms.speed).to({ value : -1},time);
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 1.2},wl_core_TimeSig.milliseconds(4,0,0,0));
		this.testarossa.setEnvmap(this.cubecamera.renderTarget.texture,false);
		wl_core_Demo.instance.overlay.add(this.over);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.testarossa.update(delta);
		this.board.update(ts,partial,frameTime,delta);
		this.city.update(ts,0.1 * delta);
		this.tunnel.rotateY(delta * 0.001);
		this.testarossa.position.x = 0.04 * Math.sin(ts.toMilliseconds() * 0.001) + Math.max(0,2 - partial * 8);
		dollarmat_DollarMat.updatemat();
	}
	,render: function(ts,frameTime) {
		this.cubecamera.position.copy(this.testarossa.position);
		this.cubecamera.position.y += 2;
		this.testarossa.hide();
		this.cubecamera.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
		this.testarossa.show();
		var fft = wl_sounds_SoundWL.getFFT();
		if(fft.frequencyLeft != null) {
			this.ground.material.uniforms.fft.value = [2 * fft.frequencyLeft[100] / 255 * 5,2 * fft.frequencyRight[100] / 255 * 5];
		}
		this.ground.material.uniforms.time.value = ts.toMilliseconds() / 5000;
		if(fft.frequencyLeft != null) {
			this.tunnel.material.uniforms.fft.value = [fft.frequencyLeft[100] / 255 * 15,fft.frequencyRight[100] / 255 * 15];
		}
		this.tunnel.material.uniforms.time.value = ts.toMilliseconds() / 1500;
		this.soundtexture.needsUpdate = true;
		this.ground.render();
		wl_core_Part.prototype.render.call(this,ts,frameTime);
		this.city.render(ts);
	}
	,setupDatGui: function(folder) {
		wl_core_Part.prototype.setupDatGui.call(this,folder);
		this.ground.setupDatGui(folder);
		folder.add(this.pl.position,"x").step(0.01);
		folder.add(this.pl.position,"y").step(0.01);
		folder.add(this.pl.position,"z").step(0.01);
		wl_util_DatGuiHelper.addVector(folder,this.city.position);
	}
	,__class__: outrun_Outrun
});
var outrun_OutrunLinePlane = function(useShaderasMat) {
	this.speed = 0.0;
	this.sizeX = 0.1;
	this.wallX = 0.0379;
	this.sizeY = 0.0851;
	this.wallY = 0.0357;
	THREE.Object3D.call(this);
	var pc = new THREE.PlaneGeometry(8,400,1,1);
	this.material = this.getMaterial();
	this.secondScene = new THREE.Scene();
	this.secondCamera = new THREE.OrthographicCamera(-1,1,1,-1);
	this.secondCamera.position.z = 100;
	this.secondCamera.lookAt(new THREE.Vector3(0,0,0));
	this.quad = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),this.material);
	this.secondScene.add(this.quad);
	this.renderTg = wl_core_Graphics.instance.getRenderTarget();
	var roadmat = new THREE.MeshPhongMaterial({ color : 16777215, map : this.renderTg.texture});
	roadmat.specular = new THREE.Color(16777215);
	roadmat.transparent = true;
	this.mesh = new THREE.Mesh(pc,roadmat);
	this.add(this.mesh);
	if(useShaderasMat) {
		this.mesh.material = this.material;
	}
};
outrun_OutrunLinePlane.__name__ = ["outrun","OutrunLinePlane"];
outrun_OutrunLinePlane.__super__ = THREE.Object3D;
outrun_OutrunLinePlane.prototype = $extend(THREE.Object3D.prototype,{
	set_wallY: function(value) {
		this.wallY = value;
		this.material.uniforms.wallY.value = value;
		return value;
	}
	,set_sizeY: function(value) {
		this.sizeY = value;
		this.material.uniforms.sizeY.value = value;
		return value;
	}
	,set_wallX: function(value) {
		this.wallX = value;
		this.material.uniforms.wallX.value = value;
		return value;
	}
	,set_sizeX: function(value) {
		this.sizeX = value;
		this.material.uniforms.sizeX.value = value;
		return value;
	}
	,set_speed: function(value) {
		this.speed = value;
		this.material.uniforms.speed.value = value;
		return value;
	}
	,getMaterial: function() {
		var params = { };
		params.fragmentShader = haxe_Resource.getString("OutrunLinePlane.frag");
		params.vertexShader = haxe_Resource.getString("OutrunLinePlane.vert");
		params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [0,0]}, wallX : { type : "f", value : this.wallX}, sizeX : { type : "f", value : this.sizeX}, wallY : { type : "f", value : this.wallY}, sizeY : { type : "f", value : this.sizeY}};
		return new THREE.ShaderMaterial(params);
	}
	,render: function() {
		wl_core_Graphics.instance.renderer.render(this.secondScene,this.secondCamera,this.renderTg);
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Road");
		f.add(this,"wallY").step(0.0001).min(0).max(0.1).onChange(function(val) {
			_gthis.material.uniforms.wallY.value = val;
		});
		f.add(this,"sizeY").step(0.0001).min(0).max(0.1).onChange(function(val1) {
			_gthis.material.uniforms.sizeY.value = val1;
		});
		f.add(this,"wallX").step(0.0001).min(0).max(0.1).onChange(function(val2) {
			_gthis.material.uniforms.wallX.value = val2;
		});
		f.add(this,"sizeX").step(0.0001).min(0).max(0.1).onChange(function(val3) {
			_gthis.material.uniforms.sizeX.value = val3;
		});
	}
	,__class__: outrun_OutrunLinePlane
});
var outrun_Testarossa = function(envmap,customBodyMaterial) {
	this.forceShaders = false;
	this.speed = 0.1;
	this.carmeshes = [];
	this.backTyres = [];
	this.firstTraverse = true;
	THREE.Object3D.call(this);
	this.envmap = envmap;
	this.customBodyMaterial = customBodyMaterial;
	this.mesh = outrun_Testarossa.MESH.clone();
	this.add(this.mesh);
	this.mesh.traverse($bind(this,this.traveseChildren));
	this.firstTraverse = false;
	this.createLights();
};
outrun_Testarossa.__name__ = ["outrun","Testarossa"];
outrun_Testarossa.__super__ = THREE.Object3D;
outrun_Testarossa.prototype = $extend(THREE.Object3D.prototype,{
	onKeyDown: function(event) {
		if(event.keyCode == 38) {
			this.speed += 0.01;
		}
		if(event.keyCode == 40) {
			this.speed -= 0.01;
		}
		if(event.keyCode == 37) {
			this.left_front_tyre.rotateY(-0.1);
			this.right_front_tyre.rotateY(0.1);
		}
		if(event.keyCode == 39) {
			this.left_front_tyre.rotateY(0.1);
			this.right_front_tyre.rotateY(-0.1);
		}
	}
	,setEnvmap: function(envmap,forceShaders) {
		this.envmap = envmap;
		this.forceShaders = forceShaders;
		this.mesh.traverse($bind(this,this.traveseChildren));
		this.bonnet.material.side = THREE.DoubleSide;
	}
	,createLights: function() {
		this.front_left_ligth = new THREE.SpotLight(16777215,1,95,Math.PI / 180 * 20,1,0.6);
		this.front_right_light = new THREE.SpotLight(16777215,1,95,Math.PI / 180 * 20,1,0.6);
		this.back_left_light = new THREE.SpotLight(16711680,0.4,15,Math.PI / 180 * 90,1,1.2);
		this.back_right_light = new THREE.SpotLight(16711680,0.4,15,Math.PI / 180 * 90,1,1.2);
		this.add(this.front_left_ligth);
		this.add(this.front_right_light);
		this.front_left_ligth.position.z = -0.7;
		this.front_left_ligth.position.x = -0.6;
		this.front_left_ligth.position.y = 1.2;
		this.front_right_light.position.z = -0.7;
		this.front_right_light.position.x = 0.6;
		this.front_right_light.position.y = 1.2;
		this.front_light_target = new THREE.Object3D();
		this.front_light_target.position.z = -95;
		this.front_light_target.position.y = 0;
		this.back_light_target = new THREE.Object3D();
		this.back_light_target.position.z = 1200;
		this.front_left_ligth.target = this.front_light_target;
		this.front_right_light.target = this.front_light_target;
		this.add(this.front_light_target);
		this.back_left_light.position.x = -0.7;
		this.back_left_light.position.y = 1.3;
		this.back_left_light.position.z = 3.4;
		this.back_right_light.position.x = 0.7;
		this.back_right_light.position.y = 1.3;
		this.back_right_light.position.z = 3.4;
		this.back_right_light.target = this.back_light_target;
		this.back_left_light.target = this.back_light_target;
		this.add(this.back_light_target);
		this.add(this.back_left_light);
		this.add(this.back_right_light);
	}
	,update: function(delta) {
		var _g = 0;
		var _g1 = this.backTyres;
		while(_g < _g1.length) {
			var t = _g1[_g];
			++_g;
			t.rotateX(-this.speed * delta);
		}
		this.left_front_tyre.geometry.rotateX(-this.speed * delta);
		this.right_front_tyre.geometry.rotateX(-this.speed * delta);
	}
	,traveseChildren: function(child) {
		if(js_Boot.__instanceof(child,THREE.Mesh)) {
			var meshchild = child;
			if(child.parent != null && child.parent.name == "right_front_tyre") {
				this.right_front_tyre = child;
			}
			if(child.parent != null && child.parent.name == "left_front_tyre") {
				this.left_front_tyre = child;
			}
			if(child.parent != null && child.parent.name == "right_back_tyre" && this.backTyres.length < 2) {
				this.backTyres.push(child.parent);
			}
			if(child.parent != null && child.parent.name == "left_back_tyre" && this.backTyres.length < 2) {
				this.backTyres.push(child.parent);
			}
			if(child.parent != null && child.parent.name == "bonnet") {
				this.bonnet = child;
			}
			if(this.firstTraverse) {
				this.carmeshes.push(child);
			}
			this.enableEnvironmentMap(meshchild.material,meshchild);
		}
	}
	,enableEnvironmentMap: function(mat,mesh) {
		if((mat instanceof Array) && mat.__enum__ == null) {
			var matarray = mat;
			var _g = 0;
			while(_g < matarray.length) {
				var m = matarray[_g];
				++_g;
				this.enableEnvironmentMap(m,mesh);
			}
		}
		if(mat != null && js_Boot.__instanceof(mat,THREE.MeshPhongMaterial)) {
			var mm = mat;
			if(mat.name == "Body") {
				this.bodyMaterial = mm;
				mm.envMap = this.envmap;
				mm.color = new THREE.Color(10159360);
				mm.reflectivity = 0.16;
				mm.shininess = 1.2;
				mm.specular = new THREE.Color(16777215);
				if(this.customBodyMaterial != null) {
					mesh.material = this.customBodyMaterial;
				}
				this.replaceMaterial(mesh,"Body",carmat_CarMat.material);
			} else {
				mm.shininess = 0;
			}
			if(mat.name == "Screen") {
				var twistedplanert = wl_core_Demo.instance.getPart("twistedplane_outrun").renderTo;
				if(twistedplanert != null) {
					mm.map = twistedplanert.texture;
				}
			}
			if(mat.name == "Chrome") {
				console.log(mesh.material);
				this.replaceMaterial(mesh,mat.name,wl_library_Library.get_instance().getMaterial(wl_library_Materials.chrome));
			}
			mm.needsUpdate = true;
		}
		if(mat.name == "BlackLeather") {
			this.replaceMaterial(mesh,"BlackLeather",carmat_CarMat.leatherMaterial);
		}
		if(mat.name == "purpleLeather") {
			this.replaceMaterial(mesh,"purplleLeather",carmat_CarMat.leatherMaterial);
		}
		if(mat.name == "InLeather") {
			this.replaceMaterial(mesh,"InLeather",carmat_CarMat.seatMaterial);
		}
		if(mat.name == "wheel") {
			this.replaceMaterial(mesh,"wheel",carmat_CarMat.drivingWheelMaterial);
		}
	}
	,replaceMaterial: function(mesh,matname,newmat) {
		if(!this.forceShaders) {
			return;
		}
		if(mesh.material.isMultiMaterial) {
			var multi = mesh.material;
			var foundmat = multi.materials.filter(function(m) {
				return m.name == matname;
			})[0];
			var index = multi.materials.indexOf(multi);
			HxOverrides.remove(multi.materials,foundmat);
			newmat.name = matname;
			multi.materials.splice(index - 1,0,newmat);
		} else {
			mesh.material = newmat;
		}
		mesh.material.needsUpdate = true;
	}
	,leather: function(mesh,diff) {
	}
	,hide: function() {
		this.mesh.visible = false;
	}
	,show: function() {
		this.mesh.visible = true;
	}
	,__class__: outrun_Testarossa
});
var raytrace_Raytrace = function(instantBloom) {
	this.limits = [0,0,0.42,0.42,0.4,0.4,0.4,0.4,0.26,0.26,0.25,0.25,0.25,0.25,0.25,0.25];
	this.thresholds = [0,0,0.04,0.04,0.04,0.04,0.1,0.1,0.2,0.2,0.4,0.4,1.4,1.4,1.4,1.4];
	this.blooms = [0,0,0.6,0.6,1.8,1.8,2.4,2.4,4,4,10,10,15,16,17,18];
	this.phase = 0;
	this.cams = [0,1,2,3,0,3,0,3,0,3];
	this.globalMP = 1;
	this.ending2 = false;
	this.ending = false;
	this.filters = [];
	this.startBloom = 0;
	this.bloomOn = false;
	this.swapcount = 0;
	this.camstate = 0;
	this.triangleMaterials = [];
	this.balls = [];
	this.tirangleMaterials = [];
	this.triangles = [];
	wl_core_Part.call(this);
	this.bloomOn = instantBloom;
};
raytrace_Raytrace.__name__ = ["raytrace","Raytrace"];
raytrace_Raytrace.__super__ = wl_core_Part;
raytrace_Raytrace.prototype = $extend(wl_core_Part.prototype,{
	initanalyzer: function() {
		this.analyzer = new wl_sounds_SoundAnalyzer();
		this.analyzer.historySize = 6;
		this.filters = [];
		var filter = { lowLimit : 50, highLimit : 400, isolate : true};
		this.filters.push(filter);
		this.analyzer.filters.push(filter);
		var filter1 = { lowLimit : 7000, highLimit : 10000, isolate : true};
		this.filters.push(filter1);
		this.analyzer.filters.push(filter1);
	}
	,init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initanalyzer();
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : false, displacement : false, bloom : true, gray : false}));
		var w = 30;
		this.plane = new THREE.Mesh(new THREE.PlaneGeometry(w,30 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[1]),new THREE.MeshBasicMaterial({ side : THREE.DoubleSide, color : 16777215, map : wl_core_Demo.instance.getPart("intro").renderTo.texture}));
		this.plane.position.z = 120;
		this.plane.rotation.x = Math.PI;
		this.plane.scale.x = this.plane.scale.y = 3.5;
		this.plane.scale.x = 4;
		this.scene.add(this.plane);
		this.plane.visible = false;
		this.container = new THREE.Object3D();
		this.scene.add(this.container);
		var halfspawnerJson = JSON.parse(haxe_Resource.getString("triangle.json"));
		var jsonloader = new THREE.OfflineJSONLoader();
		var callbackModel = function(geometry) {
			_gthis.triangleGeo = geometry;
			_gthis.triangleGeo.rotateX(-Math.PI / 2);
			_gthis.triangleGeo.scale(14,14,14);
		};
		jsonloader.load(halfspawnerJson,callbackModel);
		var colors = [DemoMain.BLUE,DemoMain.BLUE_DARK,DemoMain.HILIGHT];
		var _g = 0;
		while(_g < 3) this.triangleMaterials.push(new THREE.MeshBasicMaterial({ color : colors[_g++ % colors.length].getHex(), side : THREE.DoubleSide}));
		var _g1 = 0;
		while(_g1 < 40) {
			var i = _g1++;
			var triangle = new THREE.Mesh(this.triangleGeo,this.triangleMaterials[i % this.triangleMaterials.length]);
			this.triangles.push(triangle);
			this.scene.add(triangle);
			triangle.position.z = i * 24;
		}
		this.ballGeo = new THREE.DodecahedronGeometry(1,4);
		var d = Math.sin(Math.PI * 2 / 3);
		Math.sqrt(d * d + 0.25);
		var positions = [new THREE.Vector3(-1,0,-1 / Math.sqrt(2)),new THREE.Vector3(1,0,-1 / Math.sqrt(2)),new THREE.Vector3(0,1,1 / Math.sqrt(2)),new THREE.Vector3(0,-1,1 / Math.sqrt(2))];
		var _g2 = 0;
		while(_g2 < 4) {
			var i1 = _g2++;
			var ball = { };
			ball.cubecam = new THREE.CubeCamera(1,100,512);
			var ballmat = new THREE.MeshBasicMaterial({ envMap : ball.cubecam.renderTarget.texture, color : DemoMain.LIGHT.getHex()});
			ball.mesh = new THREE.Mesh(this.ballGeo,ballmat);
			this.container.add(ball.mesh);
			ball.mesh.position.copy(positions[i1 % 4]);
			ball.mesh.add(ball.cubecam);
			ball.origPos = positions[i1 % 4];
			this.balls.push(ball);
		}
		this.postProcessing.bloom.strength = 0.4;
		this.postProcessing.bloom.threshold = 0.7;
		if(this.bloomOn) {
			this.postProcessing.distortedTV.set_offsetAmount(1);
			this.postProcessing.distortedTV.set_distortAmount(wl_core_Config.RESOLUTION[1] * 2);
			this.postProcessing.distortedTV.set_vignAmount(0);
			this.addTrigger(new wl_core_TimeSig(-1,0,1,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
			this.addTrigger(new wl_core_TimeSig(-1,0,2,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
			this.addTrigger(new wl_core_TimeSig(-1,0,3,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
			this.cams = [0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1,0,2,1,2,0,1];
			this.globalMP = 1.5;
		}
		this.camera.position.z = -10;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchCam));
		this.addTrigger(new wl_core_TimeSig(14,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.outro));
		this.addTrigger(new wl_core_TimeSig(14,2,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.outro1));
	}
	,outro1: function(ts) {
		var _gthis = this;
		this.ending2 = true;
		createjs.Tween.removeTweens(this.postProcessing.bloom);
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 0.5, threshold : 0.3, radius : 0},wl_core_TimeSig.milliseconds(1,1,0,0),createjs.Ease.quadOut).call(function() {
			_gthis.postProcessing.bloom.strength = 0;
		});
	}
	,outro: function(ts) {
		this.container.visible = false;
		createjs.Tween.get(this.container.position).to({ y : -40},wl_core_TimeSig.milliseconds(0,2,0,0));
		createjs.Tween.get(this.postProcessing.bloom).wait(wl_core_TimeSig.milliseconds(1,1,6,0)).to({ strength : 2, threshold : 0, radius : 0},wl_core_TimeSig.milliseconds(0,0,6,0));
		this.ending = true;
		this.plane.visible = true;
	}
	,switchCam: function(ts) {
		if(this.ending) {
			return;
		}
		if(ts.bar % 2 == 0 || this.bloomOn) {
			this.swapcount++;
			if(this.cams.length == 0) {
				this.cams = [0,1,2,3];
			}
			if(this.cams.length > 0) {
				this.camstate = this.cams.shift();
			}
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.container.rotation.x = Math.sin(partial * 20) * 3 * this.globalMP;
		this.container.rotation.y = Math.sin(partial * 11) * 3 * this.globalMP;
		console.log(this.container.rotation);
	}
	,render: function(ts,frameTime) {
		var delta = frameTime / 16.666666666666668;
		var bd = 1;
		var tsc = 1;
		var space = 5;
		var speed = 0.05;
		var tAngle = 0;
		var tPhase = 0;
		var tPhaseMP = 1;
		var fov = 30;
		var bs = 1;
		var geo = this.ballGeo;
		var sbs = 1;
		if(this.ending) {
			this.camera.rotation.z = 0;
			this.camera.position.z = -6;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		} else if(this.camstate == 0) {
			tAngle = 0;
			tPhase = 0;
			space = 14;
			tsc = 1;
			bd = 1;
			fov = 30;
			this.camera.rotation.z = 0;
			this.camera.position.z = -6;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		} else if(this.camstate == 1) {
			tAngle = 3.7;
			tPhase = 0.1;
			space = 13;
			bd = 2.5;
			tsc = 1.4;
			speed = 0.05;
			tPhaseMP = 0.02;
			fov = 60;
			bs = 1;
			this.camera.rotation.z = Math.PI;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		} else if(this.camstate == 2) {
			tAngle = 0;
			tPhase = 0.1;
			space = 10;
			bd = 1;
			tsc = 3;
			speed = 0.01;
			tPhaseMP = 0.02;
			fov = 90;
			this.camera.position.z = -2.7;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		} else if(this.camstate == 3) {
			tAngle = 1.7;
			tPhase = 0.05;
			space = 25;
			bd = 1;
			tsc = 1;
			speed = 0.05;
			tPhaseMP = 0.02;
			fov = 30;
			bs = 1;
			geo = this.triangleGeo;
			bs = 1;
			sbs = 0.1;
			this.camera.position.z = 10;
			this.camera.position.y = 0;
			this.camera.position.x = 0;
			this.camera.lookAt(new THREE.Vector3(0,0,0));
		}
		if(this.bloomOn) {
			this.postProcessing.bloom.strength = this.blooms[10];
			this.postProcessing.bloom.radius = this.thresholds[10];
			this.postProcessing.bloom.threshold = this.limits[10];
		} else if(!this.ending2) {
			if(ts.bar < this.blooms.length) {
				this.postProcessing.bloom.strength = this.blooms[ts.bar] + (this.filters[1].triggered?this.filters[1].max * 0.4:0);
				this.postProcessing.bloom.radius = this.thresholds[ts.bar];
				this.postProcessing.bloom.threshold = this.limits[ts.bar];
			}
		}
		this.container.scale.x = this.container.scale.y = this.container.scale.z = bs;
		this.camera.rotation.z = this.ending?0:Math.PI / 2 * this.swapcount;
		this.camera.fov = fov;
		this.camera.updateProjectionMatrix();
		speed *= this.globalMP;
		this.phase += delta * speed;
		var _g1 = 0;
		var _g = this.triangles.length;
		while(_g1 < _g) {
			var i = _g1++;
			var t = this.triangles[i];
			if(this.ending) {
				t.scale.z = 8;
				t.position.z -= delta * 3.7;
			} else {
				t.position.z = -((i + this.phase) * space % (40 * space)) + 20 * space;
				t.scale.x = t.scale.y = t.scale.z = tsc;
			}
			t.rotation.z = Math.sin(i * tPhase + this.phase * tPhaseMP) * tAngle;
		}
		var _g2 = 0;
		var _g11 = this.balls;
		while(_g2 < _g11.length) {
			var b = _g11[_g2];
			++_g2;
			b.mesh.geometry = geo;
			b.mesh.scale.x = b.mesh.scale.y = b.mesh.scale.z = sbs;
			b.mesh.visible = false;
			b.mesh.position.set(b.origPos.x * bd,b.origPos.y * bd,b.origPos.z * bd);
			b.cubecam.updateCubeMap(wl_core_Graphics.instance.renderer,this.scene);
			b.mesh.visible = true;
		}
		this.analyzer.update();
		if(this.filters[0].triggered) {
			this.postProcessing.distortedTV.set_vignAmount(this.filters[0].max * 0.2 + 0.1);
		} else {
			this.postProcessing.distortedTV.set_vignAmount(0.1);
		}
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: raytrace_Raytrace
});
var rebuild_Rebuild = function() {
	wl_core_Part.call(this);
};
rebuild_Rebuild.__name__ = ["rebuild","Rebuild"];
rebuild_Rebuild.__super__ = wl_core_Part;
rebuild_Rebuild.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false, vhs : true}));
		this.postProcessing.bloom.strength = 2;
		this.postProcessing.bloom.threshold = 0.1;
		this.postProcessing.bloom.radius = 0.05;
		this.postProcessing.vhs.set_intensity(0.03);
		this.postProcessing.vhs.set_jitter(0.08);
		this.postProcessing.vhs.set_size(0.3);
		var whitematerialParams = { };
		whitematerialParams.color = 16777215;
		whitematerialParams.reflectivity = 0.2;
		whitematerialParams.shininess = 0.5;
		var mat = wl_library_Library.get_instance().getMaterial(wl_library_Materials.chrome);
		mat.shininess = 0.9;
		mat.reflectivity = 0.4;
		mat.color = new THREE.Color(16777215);
		this.testarossa = new outrun_Testarossa(null,mat);
		this.testarossa.setEnvmap(null,true);
		this.soundplane = new rebuild_SoundPlane();
		this.scene.add(this.soundplane);
		this.soundplane.mesh.rotation.x = 0;
		this.soundplane.position.y = 0;
		this.soundplane.position.z = -50;
		this.scene.add(new THREE.AmbientLight(8421504));
		this.spotlight = new THREE.SpotLight(16777215,1.0,20,50);
		this.spotlight.position.y = 10;
		this.spotlight.position.z = -10;
		this.scene.add(this.spotlight);
		this.fftTest = new ffttest_FFTest();
		this.fftTest.init();
		this.fftTest.scene.scale.set(0.06,0.2,0.06);
		this.fftTest.scene.position.z = -180;
		this.twister = new twistedplane_TwistedPlanePart(false);
		this.twister.init();
		this.camera.position.z = -235;
		this.camera.position.y = 0;
		this.camera.lookAt(new THREE.Vector3());
		this.camera.fov = 16;
		this.camera.updateProjectionMatrix();
		this.originalPositions = [];
		this.originalRotations = [];
		this.testarossa.position.z = -220;
		this.testarossa.position.y = -2.8;
		var _g = 0;
		var _g1 = this.testarossa.carmeshes;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			if(c.parent.name == "Body") {
				continue;
			}
			this.originalPositions.push(c.position.clone());
			this.originalRotations.push(c.rotation.clone());
			c.position.set(wl_util_Random.nextFloat() * 3000 - 1500,wl_util_Random.nextFloat() * 1500 + 250,wl_util_Random.nextFloat() * 3000 - 1500);
			c.rotateX(Math.PI * 2 * wl_util_Random.nextFloat());
			c.rotateY(Math.PI * 2 * wl_util_Random.nextFloat());
			c.rotateZ(Math.PI * 2 * wl_util_Random.nextFloat());
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		var _g1 = 0;
		var _g = this.testarossa.carmeshes.length - 1;
		while(_g1 < _g) {
			var i = _g1++;
			var c = this.testarossa.carmeshes[i];
			var originalpos = this.originalPositions[i];
			var originalrot = this.originalRotations[i];
			var time = wl_core_TimeSig.milliseconds(10,0,0,0) * wl_util_Random.nextFloat();
			createjs.Tween.get(c.position).to({ x : originalpos.x, y : originalpos.y, z : originalpos.z},time);
			createjs.Tween.get(c.rotation).to({ x : originalrot.x, y : originalrot.y, z : originalrot.z},time);
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		this.fftTest.update(ts,partial,frameTime,delta);
		this.twister.update(ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: rebuild_Rebuild
});
var rebuild_SoundPlane = function(geo) {
	THREE.Object3D.call(this);
	var pc = geo != null?geo:new THREE.PlaneGeometry(100,56.25,512,200);
	this.material = rebuild_SoundPlane.getMaterial();
	this.mesh = new THREE.Mesh(pc,this.material);
	this.add(this.mesh);
};
rebuild_SoundPlane.__name__ = ["rebuild","SoundPlane"];
rebuild_SoundPlane.getMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("SoundPlane.frag");
	params.vertexShader = haxe_Resource.getString("SoundPlane.vert");
	params.uniforms = { fftMap : { type : "t", value : DemoMain.SOUNDTEXTURE_HISTORY}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 50}, fft : { type : "f2", value : [1,1]}, wallX : { type : "f", value : 0.0105}, sizeX : { type : "f", value : 0.025}, wallY : { type : "f", value : 0.042}, sizeY : { type : "f", value : 0.1}};
	var mat = new THREE.ShaderMaterial(params);
	mat.side = THREE.DoubleSide;
	return mat;
};
rebuild_SoundPlane.__super__ = THREE.Object3D;
rebuild_SoundPlane.prototype = $extend(THREE.Object3D.prototype,{
	__class__: rebuild_SoundPlane
});
var shared_BgQuad = function(camera) {
	THREE.Object3D.call(this);
	this.sm = new THREE.ShaderMaterial({ vertexShader : haxe_Resource.getString("bgQuad.vert"), fragmentShader : haxe_Resource.getString("bgQuad.frag"), uniforms : { time : { type : "f", value : 0.0}}});
	new THREE.MeshBasicMaterial({ color : 16777215});
	this.plane = new THREE.Mesh(new THREE.PlaneGeometry(1,1),this.sm);
	this.add(this.plane);
	this.plane.lookAt(camera.position);
	this.camera = camera;
};
shared_BgQuad.__name__ = ["shared","BgQuad"];
shared_BgQuad.__super__ = THREE.Object3D;
shared_BgQuad.prototype = $extend(THREE.Object3D.prototype,{
	update: function(ts) {
		this.sm.uniforms.time.value = ts.toMilliseconds() / 1000;
		this.plane.lookAt(this.camera.position);
		var lookAtVector = new THREE.Vector3(0,0,-1);
		lookAtVector.applyQuaternion(this.camera.quaternion);
		this.plane.position.copy(lookAtVector.multiplyScalar(this.camera.far * 0.5));
		var height = 2 * Math.tan(this.camera.fov * Math.PI / 180 / 2) * this.plane.position.distanceTo(this.camera.position);
		this.plane.scale.set(height * this.camera.aspect,height * this.camera.aspect,height * this.camera.aspect);
	}
	,__class__: shared_BgQuad
});
var sunrise_Sunrise = function() {
	wl_core_Part.call(this);
};
sunrise_Sunrise.__name__ = ["sunrise","Sunrise"];
sunrise_Sunrise.__super__ = wl_core_Part;
sunrise_Sunrise.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : true, colorHilight : false, pixelate : true, distortedTV : true, standard : false, displacement : false, bloom : true, gray : true, cga : true}));
		this.postProcessing.cga.set_amount(1);
		this.postProcessing.pixelate.set_pixelamount(new THREE.Vector2(128,72));
		this.sun = new THREE.Mesh(new THREE.SphereGeometry(9,16,16),new THREE.MeshBasicMaterial({ color : 16446977}));
		this.sun.position.set(0,-9.5,0);
		this.scene.add(this.sun);
		this.sunlight = new THREE.DirectionalLight(16315905,0.0);
		this.sunlight_point = new THREE.PointLight(16315905,0.8,1000,0.0);
		this.sunlight.position.y = 5;
		this.sunlight_point.position.y = 11;
		this.sun.add(this.sunlight);
		this.sun.add(this.sunlight_point);
		this.sea = new THREE.Mesh(new THREE.BoxGeometry(500,1,500),new THREE.MeshPhongMaterial({ color : 1704086}));
		this.sea.position.z = -250;
		this.scene.add(this.sea);
		this.camera.position.y = 1;
		this.camera.position.z = -60;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.sunlight.lookAt(new THREE.Vector3(0,-10,-80));
		this.stripes = [];
		var sm = new THREE.MeshBasicMaterial({ color : 0});
		var sg = new THREE.BoxGeometry(15,0.8,2);
		var _g = 0;
		while(_g < 5) {
			var i = _g++;
			var stripe = new THREE.Mesh(sg,sm);
			stripe.scale.set(1,1 + i / 6,1);
			stripe.position.y = 0 - i * 2;
			stripe.position.z = -20;
			this.sun.add(stripe);
		}
		this.addTrigger(new wl_core_TimeSig(5,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.toModernEra));
	}
	,toModernEra: function(ts) {
		createjs.Tween.get(this.postProcessing.cga).to({ amount : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.pixelate.pixelamount).to({ x : wl_core_Graphics.instance.canvas.clientWidth, y : wl_core_Graphics.instance.canvas.clientHeight},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		var time = wl_core_TimeSig.milliseconds(5,0,0,0);
		var cameratime = time + wl_core_TimeSig.milliseconds(2,0,0,0);
		createjs.Tween.get(this.sun.position).to({ y : 11.5},time);
		createjs.Tween.get(this.sunlight).wait(wl_core_TimeSig.milliseconds(4,0,0,0)).to({ intensity : 4},wl_core_TimeSig.milliseconds(1,0,0,0));
		createjs.Tween.get(this.sunlight_point).to({ intensity : 1.5},time);
		createjs.Tween.get(this.camera.position).to({ z : -90},cameratime);
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: sunrise_Sunrise
});
var sunset_Sunset = function() {
	wl_core_Part.call(this);
};
sunset_Sunset.__name__ = ["sunset","Sunset"];
sunset_Sunset.__super__ = wl_core_Part;
sunset_Sunset.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : true, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false, cga : false}));
		this.sun = new THREE.Mesh(new THREE.SphereGeometry(50,32,32),new THREE.MeshBasicMaterial({ color : 16739584}));
		this.sun.scale.set(1,1,0.2);
		this.sun.position.set(0,100,350);
		this.scene.add(this.sun);
		this.camera.position.y = 2;
		this.camera.position.z = -100;
		this.camera.lookAt(new THREE.Vector3(0,2.5,0));
		this.testarossa = new outrun_Testarossa();
		this.testarossa.position.z = -111;
		this.testarossa.position.y = -0.25;
		this.testarossa.rotateY(Math.PI);
		this.scene.add(this.testarossa);
		this.ground = new THREE.Mesh(new THREE.BoxGeometry(500,0.1,500),new THREE.MeshBasicMaterial({ color : 0}));
		this.scene.add(this.ground);
		this.ground.position.y = -1;
		this.road = new outrun_OutrunLinePlane(true);
		this.scene.add(this.road);
		this.road.rotation.y = Math.PI;
		this.road.rotation.x = Math.PI / 2;
		this.road.material.uniforms.fftMap.value = DemoMain.SOUNDTEXTURE;
		this.addTrigger(new wl_core_TimeSig(1,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.startcar));
		this.addTrigger(new wl_core_TimeSig(0,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.descendSun));
		this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.descendCamera));
		this.addTrigger(new wl_core_TimeSig(12,0,0,0,wl_core_TimeSig.RELATIVE),$bind(this,this.fadeout));
		this.over = new THREE.Mesh(new THREE.PlaneGeometry(1,wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0]),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("over_jerk.png"), side : THREE.FrontSide}));
		this.over.scale.setY(-1);
		this.over.position.x = 0.86;
		this.over.material.opacity = 1;
		this.over.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
	}
	,fadeout: function(ts) {
		createjs.Tween.get(this.over.material).to({ opacity : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : -1},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,descendCamera: function(ts) {
		createjs.Tween.get(this.camera.position).to({ y : 1.5},wl_core_TimeSig.milliseconds(4,0,0,0),createjs.Ease.quadOut);
	}
	,stop: function() {
		wl_core_Part.prototype.stop.call(this);
		wl_core_Demo.instance.overlay.remove(this.over);
	}
	,startcar: function(ts) {
		wl_core_Demo.instance.overlay.add(this.over);
		createjs.Tween.get(this.testarossa.position).to({ z : 120},wl_core_TimeSig.milliseconds(8,0,0,0));
	}
	,descendSun: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		createjs.Tween.get(this.sun.position).to({ y : -110},wl_core_TimeSig.milliseconds(12,0,0,0));
		createjs.Tween.get(this.sun.scale).to({ x : 2, y : 2},wl_core_TimeSig.milliseconds(12,0,0,0));
		createjs.Tween.get(this.camera.position).wait(wl_core_TimeSig.milliseconds(0,2,0,0)).to({ y : 0.25, z : 80},wl_core_TimeSig.milliseconds(10,0,0,0));
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		this.postProcessing.standard.set_brightness(-1);
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var fft = wl_sounds_SoundWL.getFFT();
		if(fft.frequencyLeft != null) {
			this.road.material.uniforms.fft.value = [2 * fft.frequencyLeft[100] / 255 * 5,2 * fft.frequencyRight[100] / 255 * 5];
		}
		this.road.material.uniforms.time.value = ts.toMilliseconds() / 5000;
	}
	,render: function(ts,frameTime) {
		wl_core_Part.prototype.render.call(this,ts,frameTime);
		this.road.render();
	}
	,__class__: sunset_Sunset
});
var tunnel_TunnelCylinder = function() {
	THREE.Object3D.call(this);
	var pc = new THREE.CylinderGeometry(5,5,500,20,250,true);
	this.material = tunnel_TunnelCylinder.getMaterial();
	this.mesh = new THREE.Mesh(pc,this.material);
	this.add(this.mesh);
};
tunnel_TunnelCylinder.__name__ = ["tunnel","TunnelCylinder"];
tunnel_TunnelCylinder.getMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("tunnelcylinder.frag");
	params.vertexShader = haxe_Resource.getString("tunnelcylinder.vert");
	params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [0,0]}, wallX : { type : "f", value : 0.0105}, sizeX : { type : "f", value : 0.025}, wallY : { type : "f", value : 0.042}, sizeY : { type : "f", value : 0.1}, displacement : { type : "f", value : 0.0}, angle : { type : "f", value : 0.0}};
	return new THREE.ShaderMaterial(params);
};
tunnel_TunnelCylinder.__super__ = THREE.Object3D;
tunnel_TunnelCylinder.prototype = $extend(THREE.Object3D.prototype,{
	__class__: tunnel_TunnelCylinder
});
var tunnel_TunnelPart = function() {
	this.money = [];
	wl_core_Part.call(this);
};
tunnel_TunnelPart.__name__ = ["tunnel","TunnelPart"];
tunnel_TunnelPart.__super__ = wl_core_Part;
tunnel_TunnelPart.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.camera.fov = 16;
		this.camera.updateProjectionMatrix();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : true, colorHilight : true, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : true, vhs : true}));
		this.over = new THREE.Mesh(new THREE.PlaneGeometry(1,wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0]),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("over_dog.png"), side : THREE.FrontSide}));
		this.over.scale.setY(-1);
		this.over.position.x = 0.5;
		this.over.material.opacity = 1;
		this.over.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.postProcessing.distortedTV.set_vignAmount(0);
		this.postProcessing.bloom.radius = 0.05;
		this.postProcessing.bloom.strength = 6;
		this.postProcessing.bloom.threshold = 0.5;
		this.postProcessing.vhs.set_intensity(0.02);
		this.postProcessing.vhs.set_jitter(0.1);
		this.postProcessing.vhs.set_size(0.3);
		this.postProcessing.vhs.set_intensity(0.05);
		this.postProcessing.vhs.set_jitter(0.1);
		this.postProcessing.vhs.set_size(0.3);
		this.tunnel = new tunnel_TunnelCylinder();
		this.tunnel.material.side = THREE.BackSide;
		this.tunnel.rotation.z = Math.PI / 2;
		this.tunnel.rotation.y = Math.PI / 2;
		this.scene.add(this.tunnel);
		this.torus = new THREE.Mesh(new THREE.TorusGeometry(0.2,0.06,8,12),new THREE.MeshPhongMaterial({ color : 16777215, shading : THREE.FlatShading}));
		this.light = new THREE.PointLight(4202592,0.5,40);
		this.light.position.z = -45;
		this.light.position.y = 3;
		this.light.position.x = -2;
		this.light2 = new THREE.PointLight(8336,0.5,40);
		this.light2.position.z = 0;
		this.light2.position.y = 0;
		this.light2.position.x = 0;
		this.testarossa = new outrun_Testarossa();
		this.testarossa.position.z = -70;
		this.testarossa.position.y = -1;
		this.scene.add(this.testarossa);
		var _g = 0;
		while(_g < 1990) {
			var i = _g++;
			var m = new generic_Money();
			m.mesh.position.x = Math.random() - 0.5;
			m.mesh.position.y = Math.random() - 0.5;
			m.mesh.position.z = -70;
			m.position.x = Math.random() - 0.5;
			m.position.y = Math.random() - 0.5;
			m.position.z = -70 - Math.random() * 10;
			m.scale.set(0.1,0.1,0.1);
			m.visible = true;
			m.rotation.x = wl_util_Random.nextFloat() * 3.14;
			m.rotation.y = wl_util_Random.nextFloat() * 3.14;
			m.rotation.z = wl_util_Random.nextFloat() * 3.14;
			this.scene.add(m);
			this.money.push(m);
		}
		this.meshRotations = [];
		var _g1 = 0;
		var _g11 = this.money;
		while(_g1 < _g11.length) {
			var c = _g11[_g1];
			++_g1;
			this.meshRotations.push(new THREE.Vector3(Math.PI / 180 * (wl_util_Random.nextFloat() * 3 - 1.5),Math.PI / 180 * (wl_util_Random.nextFloat() * 3 - 1.5),Math.PI / 180 * (wl_util_Random.nextFloat() * 3 - 1.5)));
		}
		this.camera.position.z = -45;
		this.camera.position.y = 0;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.postProcessing.bloom.strength = 2;
		this.postProcessing.bloom.threshold = 0.1;
		this.postProcessing.bloom.radius = 0.05;
		this.postProcessing.distortedTV.set_vignAmount(1);
		var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
		this.soundtexture = DemoMain.SOUNDTEXTURE;
		this.tunnel.material.uniforms.fftMap.value = this.soundtexture;
		this.tunnel.material.uniforms.speed.value = 1;
		this.tunnel.material.uniforms.displacement.value = 0;
		this.tunnel.material.uniforms.mountains.value = 1;
		this.rndcc = new wl_demo_RandomCameraController(this.camera,26,[],1215,[wl_demo_CameraController.BEZIER,wl_demo_CameraController.LINEAR],[10,100],new THREE.Box3(new THREE.Vector3(-1,-1,-40),new THREE.Vector3(1,1,-40)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchcam));
		var koheaspect = 1.5;
		this.kapital = new THREE.Mesh(new THREE.PlaneGeometry(1,wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0]),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Demo.instance.getPart("engine").renderTo.texture, side : THREE.FrontSide}));
		this.kapital.scale.setY(-1);
		this.kapital.position.x = 0.5;
		this.kapital.material.opacity = 1;
		this.kapital.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.addTrigger(new wl_core_TimeSig(6,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
			createjs.Tween.get(_gthis.kapital.material).to({ opacity : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
		});
		this.addTrigger(new wl_core_TimeSig(86,0,0,0,wl_core_TimeSig.ABSOLUTE),$bind(this,this.outro));
	}
	,stop: function() {
		wl_core_Part.prototype.stop.call(this);
		wl_core_Demo.instance.overlay.remove(this.over);
	}
	,start: function(ts) {
		var _gthis = this;
		generic_Money.material.needsUpdate = true;
		generic_Money.material.uniforms.intensity.value = 0.2;
		wl_core_Demo.instance.overlay.add(this.over);
		wl_core_Part.prototype.start.call(this,ts);
		this.testarossa.setEnvmap(null,true);
		this.sendmesh();
		createjs.Tween.get(this.tunnel.material.uniforms.displacement).to({ value : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
		createjs.Tween.get(this.kapital.material).to({ opacity : 0},wl_core_TimeSig.milliseconds(2,0,0,0)).call(function() {
			_gthis.kapital.visible = false;
		});
		this.postProcessing.bloom.strength = 7.9;
		this.postProcessing.bloom.threshold = 0.1;
		this.postProcessing.bloom.radius = 0.3;
		this.postProcessing.standard.set_brightness(1);
		createjs.Tween.get(this.postProcessing.bloom).to({ strength : 4},wl_core_TimeSig.milliseconds(1,0,0,0));
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(1,0,0,0));
	}
	,outro: function(ts) {
		createjs.Tween.get(this.camera,{ onChange : ($_=this.camera,$bind($_,$_.updateProjectionMatrix))}).to({ fov : 150},wl_core_TimeSig.milliseconds(4,0,0,0));
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 3},wl_core_TimeSig.milliseconds(4,0,0,0));
	}
	,switchcam: function(ts) {
		var tmp = ts.bar % 4 == 0;
	}
	,sendmesh: function() {
		var _g = 0;
		var _g1 = this.money;
		while(_g < _g1.length) {
			var c = _g1[_g];
			++_g;
			createjs.Tween.get(c.position).wait(wl_core_TimeSig.milliseconds(12,0,0,0) * wl_util_Random.nextFloat()).to({ z : 10000},wl_core_TimeSig.milliseconds(22,0,0,0) * wl_util_Random.nextFloat(),createjs.Ease.quadIn);
		}
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var _g1 = 0;
		var _g = this.money.length;
		while(_g1 < _g) {
			var i = _g1++;
			var rotvec = this.meshRotations[i];
			var mesh = this.money[i];
			mesh.rotateX(rotvec.x * delta);
			mesh.rotateY(rotvec.y * delta);
			mesh.rotateZ(rotvec.z * delta);
		}
	}
	,render: function(ts,frameTime) {
		var fft = wl_sounds_SoundWL.getFFT();
		if(fft.frequencyLeft != null) {
			this.tunnel.material.uniforms.fft.value = [fft.frequencyLeft[100] / 255 * 15,fft.frequencyRight[100] / 255 * 15];
		}
		this.tunnel.material.uniforms.time.value = 5000 + ts.toMilliseconds() / 5000;
		this.torus.rotation.x = ts.toMilliseconds() / 2000;
		this.torus.rotation.y = ts.toMilliseconds() / 3000;
		this.light2.position.z = Math.sin(ts.toMilliseconds() / 500) * 3;
		this.soundtexture.needsUpdate = true;
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: tunnel_TunnelPart
});
var twistedplane_TwistedPlane = function(geo,count) {
	THREE.Object3D.call(this);
	var pc = geo != null?geo:new THREE.PlaneGeometry(100,100,100,100);
	this.material = twistedplane_TwistedPlane.getMaterial();
	this.mesh = new THREE.Mesh(pc,this.material);
	this.add(this.mesh);
};
twistedplane_TwistedPlane.__name__ = ["twistedplane","TwistedPlane"];
twistedplane_TwistedPlane.getMaterial = function() {
	var params = { };
	params.fragmentShader = haxe_Resource.getString("twistedplane.frag");
	params.vertexShader = haxe_Resource.getString("twistedplane.vert");
	params.uniforms = { fftMap : { type : "t", value : null}, time : { type : "f", value : 0}, speed : { type : "f", value : 0}, mountains : { type : "f", value : 0}, fft : { type : "f2", value : [0,0]}, wallX : { type : "f", value : 0.1}, sizeX : { type : "f", value : 0.25}, wallY : { type : "f", value : 0.1}, sizeY : { type : "f", value : 0.25}};
	params.transparent = true;
	params.side = THREE.DoubleSide;
	return new THREE.ShaderMaterial(params);
};
twistedplane_TwistedPlane.__super__ = THREE.Object3D;
twistedplane_TwistedPlane.prototype = $extend(THREE.Object3D.prototype,{
	__class__: twistedplane_TwistedPlane
});
var twistedplane_TwistedPlanePart = function(last,speed) {
	this.last = false;
	this.speed = 1;
	wl_core_Part.call(this);
	this.last = last;
	console.log(speed);
	console.log("TWISTER START");
	if(speed != null) {
		this.speed = speed;
	}
};
twistedplane_TwistedPlanePart.__name__ = ["twistedplane","TwistedPlanePart"];
twistedplane_TwistedPlanePart.__super__ = wl_core_Part;
twistedplane_TwistedPlanePart.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		var _gthis = this;
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.camera.fov = 16;
		this.camera.updateProjectionMatrix();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : false, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false, vhs : true}));
		this.postProcessing.vhs.set_intensity(0.03);
		this.postProcessing.vhs.set_jitter(0.08);
		this.postProcessing.vhs.set_size(0.3);
		this.tunnel = new twistedplane_TwistedPlane();
		this.tunnel.material.side = THREE.DoubleSide;
		this.scene.add(this.tunnel);
		this.camera.position.z = -235;
		this.camera.position.y = 0;
		this.camera.lookAt(new THREE.Vector3(0,0,0));
		this.postProcessing.bloom.strength = 2;
		this.postProcessing.bloom.threshold = 0.1;
		this.postProcessing.bloom.radius = 0.05;
		this.postProcessing.distortedTV.set_vignAmount(1);
		var fft = wl_sounds_SoundWL.getFFT().waveformLeft;
		this.soundtexture = DemoMain.SOUNDTEXTURE;
		this.tunnel.material.uniforms.fftMap.value = this.soundtexture;
		this.tunnel.material.uniforms.speed.value = 0;
		this.tunnel.material.uniforms.mountains.value = 0;
		this.rndcc = new wl_demo_RandomCameraController(this.camera,26,[],1215,[wl_demo_CameraController.BEZIER,wl_demo_CameraController.LINEAR],[10,100],new THREE.Box3(new THREE.Vector3(-1,-1,-40),new THREE.Vector3(1,1,-40)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchcam));
		if(this.last) {
			var koheaspect = 1.5;
			this.kapital = new THREE.Mesh(new THREE.PlaneGeometry(1,0.5625),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("kvg.png"), side : THREE.FrontSide}));
			this.kapital.scale.setY(-1);
			this.kapital.position.x = 0.5;
			this.kapital.material.opacity = 0;
			this.kapital.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
			this.addTrigger(new wl_core_TimeSig(4,0,0,0,wl_core_TimeSig.RELATIVE),function(ts) {
				console.log("tween kvg to 1");
				createjs.Tween.get(_gthis.kapital.material).to({ opacity : 1},wl_core_TimeSig.milliseconds(2,0,0,0)).wait(wl_core_TimeSig.milliseconds(2,0,0,0)).to({ opacity : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
			});
			this.kredits = new THREE.Mesh(new THREE.PlaneGeometry(1,0.5625),new THREE.MeshBasicMaterial({ transparent : true, color : 16777215, map : wl_core_Assets.getTexture("credits.png"), side : THREE.FrontSide}));
			this.kredits.scale.setY(-1);
			this.kredits.position.x = 0.5;
			this.kredits.material.opacity = 0;
			this.kredits.position.y = 0.5 * wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
			this.addTrigger(new wl_core_TimeSig(10,0,0,0,wl_core_TimeSig.RELATIVE),function(ts1) {
				createjs.Tween.get(_gthis.kredits.material).to({ opacity : 1},wl_core_TimeSig.milliseconds(2,0,0,0));
			});
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		if(this.last) {
			wl_core_Demo.instance.overlay.add(this.kapital);
			wl_core_Demo.instance.overlay.add(this.kredits);
		}
	}
	,switchcam: function(ts) {
		var tmp = ts.bar % 4 == 0;
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
		var fft = wl_sounds_SoundWL.getFFT();
		if(fft.frequencyLeft != null) {
			this.tunnel.material.uniforms.fft.value = [fft.frequencyLeft[100] / 255 * 15 + fft.frequencyLeft[36] / 255 * 12,fft.frequencyRight[100] / 255 * 15 + fft.frequencyRight[36] / 255 * 12];
		}
		this.tunnel.material.uniforms.time.value = ts.toMilliseconds() / 5000 * this.speed;
	}
	,render: function(ts,frameTime) {
		this.soundtexture.needsUpdate = true;
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: twistedplane_TwistedPlanePart
});
var twisters_Twisters = function(first) {
	this.money = [];
	this.previous = 0;
	this.phase = 0;
	wl_core_Part.call(this);
};
twisters_Twisters.__name__ = ["twisters","Twisters"];
twisters_Twisters.__super__ = wl_core_Part;
twisters_Twisters.prototype = $extend(wl_core_Part.prototype,{
	init: function() {
		wl_core_Part.prototype.init.call(this);
		this.initStandardScene();
		this.initComposer(this.getComposerList({ dof : false, rgbShift : false, colorHilight : true, pixelate : false, distortedTV : true, standard : true, displacement : false, bloom : true, gray : false, vhs : true}));
		this.postProcessing.vhs.set_intensity(0.03);
		this.postProcessing.vhs.set_jitter(0.05);
		this.postProcessing.vhs.set_size(0.3);
		this.postProcessing.colorHilight.set_range(0.14);
		this.postProcessing.colorHilight.set_value1(1);
		this.postProcessing.colorHilight.set_value2(1);
		this.postProcessing.colorHilight.set_amount(1);
		this.postProcessing.colorHilight.set_color1(15335679);
		this.postProcessing.colorHilight.set_color2(15335679);
		this.postProcessing.colorHilight.set_original(1);
		this.postProcessing.bloom.strength = 1.69;
		this.postProcessing.bloom.radius = 1.14;
		this.postProcessing.bloom.threshold = 0.0;
		this.blocks = [];
		var _g1 = 0;
		while(_g1 < 100) {
			var i = _g1++;
			Math.floor(i / 100);
			var b = new engine_EngineBlock(true);
			b.off = i * 0.1;
			b.position.x = wl_util_Random.nextFloat() * 200 - 100;
			b.position.z = wl_util_Random.nextFloat() * 200 - 100;
			b.position.y = wl_util_Random.nextFloat() * 200 - 100;
			b.scale.x = b.scale.y = b.scale.z = 0.2 + Math.random() * 0.4;
			this.scene.add(b);
			this.blocks.push(b);
		}
		this.blocks = wl_util_ArrayUtil.shuffle(this.blocks);
		new THREE.Mesh(new THREE.BoxGeometry(200,140,1),new THREE.MeshPhongMaterial({ color : 0})).position.z = 4;
		this.rndcc = new wl_demo_RandomCameraController(this.camera,26,[],12115,[wl_demo_CameraController.BEZIER],[50,70],new THREE.Box3(new THREE.Vector3(220,205,-130),new THREE.Vector3(-230,100,30)));
		this.addTrigger(new wl_core_TimeSig(-1,0,0,0,wl_core_TimeSig.PATTERN),$bind(this,this.switchcam));
		this.camera.position.z = 3.0;
		this.camera.position.x = 0.8;
		this.camera.position.y = 0.2;
		this.camera.rotation.x = 0;
		this.camera.rotation.y = 0;
		this.camera.rotation.z = 0;
		this.scene.add(this.camera);
		var _g = 0;
		while(_g < 250) {
			++_g;
			var m = new generic_Money();
			m.mesh.position.x = Math.random() * 3;
			m.mesh.position.z = Math.random() * 3;
			var deg = Math.random() * 2 * Math.PI;
			var dist = Math.random() * 250;
			m.position.x = Math.sin(deg) * dist;
			m.position.y = Math.random() * 50;
			m.position.z = Math.cos(deg) * dist;
			m.rotation.x = wl_util_Random.nextFloat() * 3.14;
			m.rotation.y = wl_util_Random.nextFloat() * 3.14;
			m.rotation.z = wl_util_Random.nextFloat() * 3.14;
			m.mesh.rotation.x = Math.PI / 2;
			this.money.push(m);
		}
		this.soundtexture = DemoMain.SOUNDTEXTURE;
		this.clearColor = 16777215;
		this.scene.add(new THREE.AmbientLight(16777215));
	}
	,switchcam: function(ts) {
		this.rndcc.swap();
		this.rndcc.updatePartial(0);
		var _g = 0;
		var _g1 = this.blocks;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			b.position.x = wl_util_Random.nextFloat() * 200 - 100;
			b.position.z = wl_util_Random.nextFloat() * 200 - 100;
			b.position.y = wl_util_Random.nextFloat() * 200 - 100;
		}
	}
	,start: function(ts) {
		wl_core_Part.prototype.start.call(this,ts);
		generic_Money.material.uniforms.intensity.value = 0.5;
		this.postProcessing.standard.set_brightness(-1);
		createjs.Tween.get(this.postProcessing.standard.uniforms.brightness).to({ value : 0},wl_core_TimeSig.milliseconds(2,0,0,0));
	}
	,update: function(ts,partial,frameTime,delta) {
		wl_core_Part.prototype.update.call(this,ts,partial,frameTime,delta);
	}
	,render: function(ts,frameTime) {
		this.rndcc.updateLength(wl_core_TimeSig.milliseconds(1,0,0,0));
		var _g = 0;
		var _g1 = this.money;
		while(_g < _g1.length) {
			var m = _g1[_g];
			++_g;
			if(m.position.y < -10.7) {
				m.position.y += 60;
			} else {
				m.rotation.x += frameTime / 16.6 * 0.05;
				m.rotation.z += frameTime / 16.6 * 0.025;
				m.rotation.y += frameTime / 16.6 * 0.055;
				m.position.y -= frameTime / 16.6 * 0.05;
			}
		}
		var _g11 = 0;
		var _g2 = this.blocks.length;
		while(_g11 < _g2) {
			var i = _g11++;
			this.blocks[i].phase(this.phase + Math.PI / this.blocks.length * i,ts.toMilliseconds() / 3000);
		}
		wl_core_Part.prototype.render.call(this,ts,frameTime);
	}
	,__class__: twisters_Twisters
});
var wl_core_Assets = $hx_exports["kvg"]["core"]["assets"] = function() {
};
wl_core_Assets.__name__ = ["wl","core","Assets"];
wl_core_Assets.register = function(id,type,data,compressed) {
	if(compressed) {
		throw new js__$Boot_HaxeError("Compression not implemented.");
	}
	if(type == "png" || type == "jpg") {
		var img = new Image();
		img.src = "data:image/" + (type == "jpg"?"jpeg":type) + ";base64," + data;
		var _this = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this.setReserved(id,img);
		} else {
			_this.h[id] = img;
		}
	} else if(type == "mp3" || type == "ogg") {
		var _this1 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this1.setReserved(id,data);
		} else {
			_this1.h[id] = data;
		}
	} else if(type == "json") {
		var _this2 = wl_core_Assets._assets;
		var value = JSON.parse(data);
		if(__map_reserved[id] != null) {
			_this2.setReserved(id,value);
		} else {
			_this2.h[id] = value;
		}
	} else if(type == "object") {
		var _this3 = wl_core_Assets._assets;
		if(__map_reserved[id] != null) {
			_this3.setReserved(id,data);
		} else {
			_this3.h[id] = data;
		}
	}
};
wl_core_Assets.get = function(id) {
	var _this = wl_core_Assets._assets;
	if(!(__map_reserved[id] != null?_this.existsReserved(id):_this.h.hasOwnProperty(id))) {
		console.log("Asset " + id + " not found");
	}
	var _this1 = wl_core_Assets._assets;
	if(__map_reserved[id] != null) {
		return _this1.getReserved(id);
	} else {
		return _this1.h[id];
	}
};
wl_core_Assets.getTexture = function(id) {
	var img = wl_core_Assets.get(id);
	if(img == null) {
		throw new js__$Boot_HaxeError("Texture " + id + " not found.");
	}
	var tex = new THREE.Texture(img);
	tex.needsUpdate = true;
	return tex;
};
wl_core_Assets.prototype = {
	__class__: wl_core_Assets
};
var wl_core_Config = $hx_exports["wl"]["Config"] = function() {
	throw new js__$Boot_HaxeError("Config is static only.");
};
wl_core_Config.__name__ = ["wl","core","Config"];
wl_core_Config.prototype = {
	__class__: wl_core_Config
};
var wl_core_Demo = $hx_exports["Demo"] = function() {
	this.waitingFirstFrame = true;
	this.allowUpdate = false;
	this.previousUpdate = 0;
	this.partMap = new haxe_ds_StringMap();
	wl_core_Demo.instance = this;
};
wl_core_Demo.__name__ = ["wl","core","Demo"];
wl_core_Demo.prototype = {
	getPart: function(name) {
		var _this = this.partMap;
		if(__map_reserved[name] != null) {
			return _this.getReserved(name);
		} else {
			return _this.h[name];
		}
	}
	,init: function(container,callback) {
		var _gthis = this;
		wl_util_Random.init(wl_core_Config.SEED);
		this.graphics = new wl_core_Graphics(container);
		wl_sounds_SoundWL.onSoundComplete.connect($bind(this,this.onSoundEnd));
		haxe_Timer.delay(function() {
			_gthis.previousTS = wl_core_TimeSig.create(0);
			_gthis.graphics.onRender.connect($bind(_gthis,_gthis.onRender));
			_gthis.initializeParts();
			if(wl_core_Config.DEBUG) {
				_gthis.initializeDebug();
			}
			createjs.Ticker.setPaused(true);
			_gthis.initDemoComposer();
			callback();
		},100);
	}
	,initDemoComposer: function() {
		this.overlay = new THREE.Scene();
		var aspect = wl_core_Config.RESOLUTION[1] / wl_core_Config.RESOLUTION[0];
		this.overlayCamera = new THREE.OrthographicCamera(0,1,0,aspect,1,1000);
		this.demoComposer = new THREE.EffectComposer(this.graphics.renderer,this.graphics.getRenderTarget());
		this.texturePass = new THREE.TexturePass(null,1);
		this.demoComposer.addPass(this.texturePass);
		var copyPass = new THREE.ShaderPass(THREE.CopyShader);
		copyPass.renderToScreen = true;
		this.demoComposer.addPass(copyPass);
		this.overlayCamera.position.z = 10;
		this.overlayCamera.lookAt(new THREE.Vector3());
	}
	,onSoundEnd: function() {
		this.end();
	}
	,initializeDebug: function() {
		wl_debug_Debug.init(this);
		wl_debug_ManualControl.init();
	}
	,initializeParts: function() {
		this.parts = [];
		var _g = 0;
		var _g1 = wl_core_Config.TIMELINE;
		while(_g < _g1.length) {
			var tl = _g1[_g];
			++_g;
			var id;
			if(tl.partId == null) {
				var o = tl.part;
				id = Type.getClassName(o == null?null:js_Boot.getClass(o));
			} else {
				id = tl.partId;
			}
			tl.part.name = id;
			var _this = this.partMap;
			var key = tl.partId;
			var value = tl.part;
			if(__map_reserved[key] != null) {
				_this.setReserved(key,value);
			} else {
				_this.h[key] = value;
			}
			this.parts.push(tl.part);
		}
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var part = _g11[_g2];
			++_g2;
			part.init();
		}
		var _g3 = 0;
		var _g12 = this.parts;
		while(_g3 < _g12.length) {
			var part1 = _g12[_g3];
			++_g3;
			part1.render(this.previousTS,0);
		}
		var _g4 = 0;
		var _g13 = this.parts;
		while(_g4 < _g13.length) {
			var part2 = _g13[_g4];
			++_g4;
			part2.postInit();
		}
	}
	,start: function() {
		var _gthis = this;
		this.previousRts = this.parts[0];
		this.graphics.start();
		haxe_Timer.delay(function() {
			wl_sounds_SoundWL.start();
			_gthis.allowUpdate = true;
			_gthis.waitingFirstFrame = false;
			console.log("allow upds.");
		},400);
		haxe_Timer.delay(function() {
			_gthis.parts[0].update(new wl_core_TimeSig(0),0,10,10);
			_gthis.parts[0].setRenderToScreen(true);
			_gthis.parts[0].render(new wl_core_TimeSig(0),10);
			_gthis.onRender(0);
		},40);
	}
	,end: function() {
		this.graphics.stop();
	}
	,onRender: function(time) {
		this.graphics.renderer.clear();
		createjs.Tween.tick(time,false);
		var rts = null;
		var _g = 0;
		var _g1 = this.parts;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			if(p.inTransition) {
				p.render(this.previousTS,time);
			} else if(p.running) {
				if(rts == null && p.renderToScreen) {
					rts = p;
				} else {
					p.render(this.previousTS,time);
				}
			}
		}
		if(rts == null) {
			rts = this.previousRts;
		}
		if(rts != null) {
			this.previousRts = rts;
			rts.render(this.previousTS,time);
		}
		this.texturePass.setTexture(rts.renderTo);
		this.demoComposer.render();
		this.graphics.renderer.autoClearColor = false;
		this.graphics.renderer.render(this.overlay,this.overlayCamera);
		this.graphics.renderer.autoClearColor = true;
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onrender();
		}
		if(this.allowUpdate) {
			this.update();
		}
	}
	,update: function() {
		var ts = wl_sounds_SoundWL.getPosition();
		var ms = ts.toMilliseconds();
		var frameTime = ms - this.previousUpdate;
		var delta = frameTime / 16.666666666666668;
		this.previousUpdate = ms;
		var _g1 = 0;
		var _g = wl_core_Config.TIMELINE.length;
		while(_g1 < _g) {
			var tl = wl_core_Config.TIMELINE[_g1++];
			if(ts.isInside(tl.runOn,tl.runOff)) {
				var p = tl.part;
				p.timeline = tl;
				var inTransition = ts.isInside(tl.runOn,tl.rtsOn) || ts.isInside(tl.rtsOff,tl.runOff);
				p.setRenderToScreen(tl.renderToScreen && !inTransition);
				if(!p.running) {
					p.start(ts);
				}
				p.isActive = true;
			}
		}
		DemoMain.update(ts,0,wl_debug_Debug.paused?0:frameTime,delta);
		var _g2 = 0;
		var _g11 = this.parts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			if(p1.isActive) {
				var timespan = p1.timeline.runOff.toMilliseconds() - p1.timeline.runOn.toMilliseconds();
				p1.update(ts,(ts.toMilliseconds() - p1.timeline.runOn.toMilliseconds()) / timespan,wl_debug_Debug.paused?0:frameTime,delta);
			} else if(p1.running) {
				p1.stop();
			}
			p1.isActive = false;
		}
		while(this.previousTS.isSmallerThan(ts)) {
			var _g3 = 0;
			var _g12 = this.parts;
			while(_g3 < _g12.length) {
				var p2 = _g12[_g3];
				++_g3;
				if(p2.running) {
					var tmp = p2.triggers.keys();
					while(tmp.hasNext()) {
						var key = tmp.next();
						var matches = key.matchesPattern(this.previousTS,p2.timeline.runOn);
						if(matches && !key.triggered) {
							var triggers = p2.triggers.h[key.__id__];
							key.triggered = true;
							var _g21 = 0;
							while(_g21 < triggers.length) {
								var toCall = triggers[_g21];
								++_g21;
								toCall(this.previousTS);
							}
						} else if(!matches) {
							key.triggered = false;
						}
					}
				}
			}
			this.previousTS.addTicks(1);
		}
		if(wl_core_Config.DEBUG) {
			wl_debug_Debug.onupdate();
		}
	}
	,__class__: wl_core_Demo
};
var wl_core_Graphics = function(container) {
	this.last = 0;
	this.stopped = true;
	this.container = container;
	if(wl_core_Graphics.instance == null) {
		wl_core_Graphics.instance = this;
	} else {
		console.log("Creating multiple Graphics instances. Are you sure?");
	}
	this.initGraphics();
};
wl_core_Graphics.__name__ = ["wl","core","Graphics"];
wl_core_Graphics.prototype = {
	initGraphics: function() {
		this.onRender = new wl_core_Signal();
		this.interval = 1000 / wl_core_Config.FPS;
		var params = { };
		params.antialias = wl_core_Config.ANTIALIAS;
		this.renderer = new THREE.WebGLRenderer(params);
		this.renderer.setClearColor(wl_core_Config.CLEAR_COLOR);
		this.renderer.autoClear = false;
		this.renderer.shadowMap.enabled = wl_core_Config.ENABLE_SHADOWS;
		this.renderer.shadowMap.type = THREE.PCFSoftShadowMap;
		this.renderer.shadowMapCascade = true;
		this.renderer.setSize(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1],true);
		this.canvas = this.renderer.domElement;
		this.canvas.id = "demoCanvas";
		this.depthMaterial = new THREE.MeshDepthMaterial();
	}
	,start: function() {
		this.last = 0;
		this.stopped = false;
		this.renderLoop(0);
	}
	,stop: function() {
		this.renderer.clear();
		this.stopped = true;
	}
	,renderLoop: function(time) {
		this.delta = time - this.last;
		if(wl_core_Config.FPS < 0 || this.delta >= this.interval) {
			this.last = time;
			this.onRender.emit(this.delta);
		}
		if(!this.stopped) {
			window.requestAnimationFrame($bind(this,this.renderLoop));
		}
	}
	,getRenderTarget: function(format) {
		var options = { };
		options.stencilBuffer = true;
		options.minFilter = THREE.LinearFilter;
		options.magFilter = THREE.LinearFilter;
		options.format = format == null?THREE.RGBAFormat:format;
		return new THREE.WebGLRenderTarget(wl_core_Config.RESOLUTION[0],wl_core_Config.RESOLUTION[1],options);
	}
	,getRenderTargetCube: function() {
		return new THREE.WebGLRenderTargetCube(1024,1024,{ });
	}
	,__class__: wl_core_Graphics
};
var wl_debug_Debug = function() {
};
wl_debug_Debug.__name__ = ["wl","debug","Debug"];
wl_debug_Debug.init = function(demo) {
	wl_debug_Debug.gui = new dat.gui.GUI();
	window.document.addEventListener("keydown",wl_debug_Debug.onKeyDown);
	wl_debug_Debug.debugDiv = $(".debug");
	wl_debug_Debug.debugTimeSig = wl_debug_Debug.debugDiv.find("#debug_timesig");
	var tldiv = wl_debug_Debug.debugDiv.find("#timeline_parts");
	var _g = 0;
	var _g1 = wl_core_Config.TIMELINE;
	while(_g < _g1.length) {
		var tl = _g1[_g];
		++_g;
		var tlel = $("<li>" + Std.string(tl) + "</li>");
		tldiv.append(tlel);
		tlel.click(wl_debug_Debug.tlClick(tl));
		wl_debug_Debug.datGuiPart(tl.part);
	}
	wl_debug_Debug.stats = new Stats();
	wl_debug_Debug.stats.showPanel(1);
	wl_debug_Debug.stats.dom.style.position = "absolute";
	wl_debug_Debug.stats.dom.style.bottom = "0px";
	wl_debug_Debug.stats.dom.style.top = null;
	wl_debug_Debug.debugDiv.eq(0).append(wl_debug_Debug.stats.dom);
	wl_debug_Debug.stats.begin();
};
wl_debug_Debug.datGuiPart = function(part) {
	var name = part.name;
	while(wl_debug_Debug.usedFolderNames.indexOf(name) >= 0) name += ">";
	var folder = wl_debug_Debug.gui.addFolder(name);
	wl_debug_Debug.usedFolderNames.push(name);
	var composer = Reflect.field(part,"composer");
	if(composer != null) {
		var _g = 0;
		var _g1 = composer.passes;
		while(_g < _g1.length) {
			var pass = _g1[_g];
			++_g;
			if(pass.setupDatGui != null) {
				pass.setupDatGui(folder);
			}
		}
	}
	var occlusioncomposer = Reflect.field(part,"occlusionComposer");
	if(occlusioncomposer != null) {
		var _g2 = 0;
		var _g11 = occlusioncomposer.passes;
		while(_g2 < _g11.length) {
			var pass1 = _g11[_g2];
			++_g2;
			if(pass1.setupDatGui != null) {
				pass1.setupDatGui(folder);
			}
		}
	}
	part.setupDatGui(folder);
};
wl_debug_Debug.tlClick = function(tl) {
	return function() {
		var curtime = wl_sounds_SoundWL.instance.getPosition();
		var tlpos = tl.rtsOn.toMilliseconds();
		wl_sounds_SoundWL.instance.setPosition(tlpos);
		createjs.Tween.tick(Math.floor(tlpos - curtime),false);
		wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
	};
};
wl_debug_Debug.onupdate = function() {
	var ts = wl_sounds_SoundWL.getPosition();
	wl_debug_Debug.debugTimeSig.html(StringTools.replace(ts.toString(),"\n","<br/>") + "<br/>" + Math.round(ts.toMilliseconds() / 100) / 10 + "s");
};
wl_debug_Debug.onrender = function() {
	wl_debug_Debug.stats.update();
	wl_debug_ManualControl.update();
};
wl_debug_Debug.onKeyDown = function(e) {
	if(e.keyCode == 90) {
		console.log("Time captured: " + Std.string(wl_core_Demo.instance.previousTS));
	}
	if(e.keyCode == 109 || e.keyCode == 188) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() - 5000);
			createjs.Tween.tick(-5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 107 || e.keyCode == 190) {
		if(wl_sounds_SoundWL.instance != null) {
			wl_sounds_SoundWL.instance.setPosition(wl_sounds_SoundWL.instance.getPosition() + 5000);
			createjs.Tween.tick(5000,false);
			wl_core_Demo.instance.previousTS.fromTime(wl_sounds_SoundWL.instance.getPosition() / 1000 / 60 - wl_core_Config.MUSIC_BEGIN / 1000 / 60);
		}
	}
	if(e.keyCode == 32) {
		wl_debug_Debug.paused = !wl_debug_Debug.paused;
		wl_sounds_SoundWL.instance.paused = wl_debug_Debug.paused;
		createjs.Tween.removeAllTweens();
	}
};
wl_debug_Debug.prototype = {
	__class__: wl_debug_Debug
};
var wl_debug_ManualControl = function() {
	throw new js__$Boot_HaxeError("Manual control is static");
};
wl_debug_ManualControl.__name__ = ["wl","debug","ManualControl"];
wl_debug_ManualControl.init = function() {
	if(wl_debug_ManualControl.inited) {
		return;
	}
	wl_debug_ManualControl.inited = true;
	window.document.addEventListener("keydown",wl_debug_ManualControl.onKeyDown);
	window.document.getElementById("demo").addEventListener("mousedown",wl_debug_ManualControl.onMouseDown);
};
wl_debug_ManualControl.onMouseDown = function(event) {
	console.log("mouse down");
	window.document.getElementById("demo").childNodes[0].requestPointerLock();
	window.document.addEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	window.document.getElementById("demo").addEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	event.preventDefault();
	event.stopPropagation();
	var _g1 = 0;
	var _g = wl_debug_ManualControl.parts.length;
	while(_g1 < _g) {
		var i = _g1++;
		var p = wl_debug_ManualControl.parts[i];
		var control = wl_debug_ManualControl.fpsControls[i];
		var lookingTo = new THREE.Vector3(0,0,-1);
		lookingTo = p.camera.getWorldDirection();
		control.enabled = p.running;
		var x = lookingTo.x;
		var y = lookingTo.y;
		var z = lookingTo.z;
		var lat = 90 - Math.acos(y / 1) * 180 / Math.PI;
		var lon = (270 + Math.atan2(x,z) * 180 / Math.PI) % 360 - 180;
		control.lat = lat;
		control.lon = lon;
	}
};
wl_debug_ManualControl.onMouseUp = function(event) {
	console.log("Mouse up");
	window.document.exitPointerLock();
	var _g1 = 0;
	var _g = wl_debug_ManualControl.fpsControls.length;
	while(_g1 < _g) {
		var control = wl_debug_ManualControl.fpsControls[_g1++];
		control.enabled = false;
		control.movementSpeed = 1;
	}
	window.document.removeEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
	window.document.getElementById("demo").removeEventListener("mouseup",wl_debug_ManualControl.onMouseUp);
};
wl_debug_ManualControl.onKeyDown = function(event) {
	wl_debug_ManualControl.ctrlDown = event.shiftKey;
	var _g1 = 0;
	var _g = wl_debug_ManualControl.parts.length;
	while(_g1 < _g) {
		var i = _g1++;
		var p = wl_debug_ManualControl.parts[i];
		if(!p.running) {
			continue;
		}
		var control = wl_debug_ManualControl.fpsControls[i];
		var camera = p.camera;
		var camdir = new THREE.Vector3(0,0,-100);
		camdir.applyQuaternion(camera.quaternion);
		control.movementSpeed = event.shiftKey?0.1:1;
		if(event.keyCode == 80) {
			wl_demo_CameraController.stopAllControl();
			console.log("--- " + camera.name + " ---");
			console.log("Pos: x: " + camera.position.x + " y: " + camera.position.y + " z: " + camera.position.z);
			console.log("Dir: " + camdir.x + ", " + camdir.y + ", " + camdir.z);
			console.log("Look at: ");
			var la = camera.position.clone().add(camdir);
			console.log(la.x + ", " + la.y + ", " + la.z);
			console.log("Camera rotations: x " + camera.rotation.x + " y " + camera.rotation.y + " z " + camera.rotation.z + " Array ( " + camera.rotation.x + "," + camera.rotation.y + "," + camera.rotation.z + " )");
		}
		if(event.keyCode == 81) {
			console.log("point stored");
			if(wl_debug_ManualControl.storedPoints[p.name] == null) {
				wl_debug_ManualControl.storedPoints[p.name] = { pos : [], rot : [], look : []};
			}
			var la1 = camera.position.clone().add(camdir);
			wl_debug_ManualControl.storedPoints[p.name].pos.push("new Vector3(" + Math.round(camera.position.x * 100) / 100 + "," + Math.round(camera.position.y * 100) / 100 + "," + Math.round(camera.position.z * 100) / 100 + ")");
			wl_debug_ManualControl.storedPoints[p.name].rot.push("new Vector3(" + Math.round(camera.rotation.x * 100) / 100 + "," + Math.round(camera.rotation.y * 100) / 100 + "," + Math.round(camera.rotation.z * 100) / 100 + ")\n");
			wl_debug_ManualControl.storedPoints[p.name].look.push("new Vector3(" + Math.round(la1.x * 100) / 100 + "," + Math.round(la1.y * 100) / 100 + "," + Math.round(la1.z * 100) / 100 + ")");
		}
		if(event.keyCode == 85) {
			console.log("------------------------");
			var _g2 = 0;
			var _g3 = Reflect.fields(wl_debug_ManualControl.storedPoints);
			while(_g2 < _g3.length) {
				var point = _g3[_g2];
				++_g2;
				console.log("--- " + point + " ---");
				console.log("[\r\n" + wl_debug_ManualControl.storedPoints[point].pos.join(",\r\n") + "],[\r\n" + wl_debug_ManualControl.storedPoints[point].look.join(",\r\n") + "]");
			}
			wl_debug_ManualControl.storedPoints = { };
		}
	}
};
wl_debug_ManualControl.update = function() {
	var _g = 0;
	var _g1 = wl_debug_ManualControl.fpsControls;
	while(_g < _g1.length) {
		var c = _g1[_g];
		++_g;
		if(c.enabled) {
			c.update(1);
		}
	}
};
wl_debug_ManualControl.attachPart = function(part) {
	if(!wl_core_Config.DEBUG) {
		return;
	}
	wl_debug_ManualControl.parts.push(part);
	var control = new THREE.FirstPersonControls(part.camera);
	control.enabled = false;
	wl_debug_ManualControl.fpsControls.push(control);
};
wl_debug_ManualControl.prototype = {
	__class__: wl_debug_ManualControl
};
var wl_demo_BoardItem = function(startTime,endTime,controller) {
	this.startTime = startTime;
	this.controller = controller;
	this.endTime = endTime;
};
wl_demo_BoardItem.__name__ = ["wl","demo","BoardItem"];
wl_demo_BoardItem.prototype = {
	Run: function(ts) {
		if(ts.isLargerThan(this.startTime) && ts.isSmallerThan(this.endTime)) {
			var timespan = this.endTime.toMilliseconds() - this.startTime.toMilliseconds();
			this.controller.update((ts.toMilliseconds() - this.startTime.toMilliseconds()) / timespan);
		}
	}
	,__class__: wl_demo_BoardItem
};
var wl_demo_IController = function() { };
wl_demo_IController.__name__ = ["wl","demo","IController"];
wl_demo_IController.prototype = {
	__class__: wl_demo_IController
};
var wl_demo_CameraController = function(camera) {
	this.ignoreStop = false;
	this.updateLook = true;
	this.updatePath = true;
	if(camera != null) {
		this.attachCamera(camera);
	}
};
wl_demo_CameraController.__name__ = ["wl","demo","CameraController"];
wl_demo_CameraController.__interfaces__ = [wl_demo_IController];
wl_demo_CameraController.stopAllControl = function() {
	wl_demo_CameraController.STOPPED = true;
};
wl_demo_CameraController.prototype = {
	attachCamera: function(camera) {
		this.camera = camera;
	}
	,set_mode: function(mode) {
		this.mode = mode;
		return mode;
	}
	,initStatic: function(position,lookAt) {
		this.position = position;
		this.lookAt = lookAt;
		this.set_mode(wl_demo_CameraController.STATIC);
	}
	,initFollow: function(target,followOffset,followLookOffset) {
		this.set_mode(wl_demo_CameraController.FOLLOW);
		this.follow = target;
		this.followOffset = followOffset == null?new THREE.Vector3(0,0,0):followOffset;
		this.followLookOffset = followLookOffset == null?new THREE.Vector3(0,0,0):followLookOffset;
	}
	,initLinear: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.LINEAR);
		this.points = points;
		this.lookAts = lookAts;
	}
	,initBezier: function(points,lookAts) {
		this.set_mode(wl_demo_CameraController.BEZIER);
		this.points = points;
		this.lookAts = lookAts;
		this.path = new THREE.SplineCurve3(points);
		this.lookPath = new THREE.SplineCurve3(lookAts);
	}
	,showbezierPaths: function(scene) {
		var _g = 0;
		var _g1 = this.points;
		while(_g < _g1.length) {
			var p = _g1[_g];
			++_g;
			var b = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),new THREE.MeshBasicMaterial({ color : 16711680}));
			b.position.set(p.x,p.y,p.z);
			scene.add(b);
		}
		var _g2 = 0;
		var _g11 = this.lookAts;
		while(_g2 < _g11.length) {
			var p1 = _g11[_g2];
			++_g2;
			var b1 = new THREE.Mesh(new THREE.BoxGeometry(2,2,2),new THREE.MeshBasicMaterial({ color : 255}));
			b1.position.set(p1.x,p1.y,p1.z);
			scene.add(b1);
		}
		var geometry = new THREE.Geometry();
		var linematerial = new THREE.LineBasicMaterial({ color : 16711680, linewidth : 4});
		var lookAtGeometry = new THREE.Geometry();
		var lookAtLineMaterial = new THREE.LineBasicMaterial({ color : 255});
		var _g12 = 0;
		while(_g12 < 1200) {
			var k = _g12++;
			geometry.vertices.push(this.path.getPointAt(k / 1200).clone());
			lookAtGeometry.vertices.push(this.lookPath.getPointAt(k / 1200));
		}
		scene.add(new THREE.Line(geometry,linematerial));
		scene.add(new THREE.Line(lookAtGeometry,lookAtLineMaterial));
	}
	,update: function(phase) {
		if(wl_demo_CameraController.STOPPED && !this.ignoreStop) {
			return;
		}
		if(this.mode == wl_demo_CameraController.STATIC) {
			if(this.updatePath) {
				this.camera.position.x = this.position.x;
				this.camera.position.y = this.position.y;
				this.camera.position.z = this.position.z;
			}
			if(this.updateLook) {
				this.camera.lookAt(this.lookAt);
			}
		} else if(this.mode == wl_demo_CameraController.LINEAR) {
			if(this.updatePath) {
				var a = this.points[0];
				var b = this.points[1];
				var c = new THREE.Vector3();
				c.lerpVectors(a,b,phase);
				this.camera.position.x = c.x;
				this.camera.position.y = c.y;
				this.camera.position.z = c.z;
			}
			if(this.updateLook) {
				var a1 = this.lookAts[0];
				var b1 = this.lookAts[1];
				var c1 = new THREE.Vector3();
				c1.lerpVectors(a1,b1,phase);
				this.camera.lookAt(c1);
			}
		} else if(this.mode == wl_demo_CameraController.FOLLOW) {
			if(this.updatePath) {
				this.camera.position.x = this.follow.position.x + this.followOffset.x;
				this.camera.position.y = this.follow.position.y + this.followOffset.y;
				this.camera.position.z = this.follow.position.z + this.followOffset.z;
			}
			if(this.updateLook) {
				this.camera.lookAt(this.follow.position.add(this.followLookOffset));
			}
		} else if(this.mode == wl_demo_CameraController.BEZIER) {
			if(phase < 0) {
				phase = 0;
			} else if(phase > 1) {
				phase = 1;
			}
			if(this.updatePath) {
				var p = this.path.getPointAt(phase);
				this.camera.position.x = p.x;
				this.camera.position.y = p.y;
				this.camera.position.z = p.z;
			}
			if(this.updateLook) {
				var p1 = this.lookPath.getPointAt(phase);
				this.camera.lookAt(p1);
				this.lookAt = p1;
			}
			this.position = this.camera.position;
		}
	}
	,__class__: wl_demo_CameraController
};
var wl_demo_DustParticles = function(params) {
	THREE.Object3D.call(this);
	this.particles = new THREE.Object3D();
	this.p = params;
	this.particleMaterial = new THREE.SpriteMaterial({ map : new THREE.CanvasTexture(this.generateSprite()), blending : THREE.AdditiveBlending, transparent : true});
	var _g1 = 0;
	var _g = this.p.amount;
	while(_g1 < _g) {
		++_g1;
		var particle = new THREE.Sprite(this.particleMaterial);
		particle.position.set(wl_util_Random.range(this.p.minx,this.p.maxx),wl_util_Random.range(this.p.miny,this.p.maxy),wl_util_Random.range(-this.p.minz,this.p.maxz));
		this.particles.add(particle);
	}
	this.add(this.particles);
};
wl_demo_DustParticles.__name__ = ["wl","demo","DustParticles"];
wl_demo_DustParticles.__super__ = THREE.Object3D;
wl_demo_DustParticles.prototype = $extend(THREE.Object3D.prototype,{
	generateSprite: function() {
		var canvas = window.document.createElement("canvas");
		canvas.width = this.p.particleSize.x;
		canvas.height = this.p.particleSize.y;
		var context = canvas.getContext("2d");
		var gradient = context.createRadialGradient(canvas.width / 2,canvas.height / 2,0,canvas.width / 2,canvas.height / 2,canvas.width / 2);
		gradient.addColorStop(0,"rgba(255,255,255,1)");
		gradient.addColorStop(0.2,"rgba(0,255,255,1)");
		gradient.addColorStop(0.4,"rgba(0,0,64,1)");
		gradient.addColorStop(1,"rgba(0,0,0,1)");
		context.fillStyle = gradient;
		context.fillRect(0,0,canvas.width,canvas.height);
		return canvas;
	}
	,__class__: wl_demo_DustParticles
});
var wl_demo_DustParameters = function() {
};
wl_demo_DustParameters.__name__ = ["wl","demo","DustParameters"];
wl_demo_DustParameters.prototype = {
	__class__: wl_demo_DustParameters
};
var wl_demo_RandomCameraController = function(camera,cameraAmount,follow,seed,allowTypes,distanceRange,bounds) {
	this.distanceRange = [];
	this.cameraSwap = 0;
	this.current = 0;
	if(allowTypes.length == 0) {
		throw new js__$Boot_HaxeError("Random camera requires at least 1 type");
	}
	this.md = distanceRange[0];
	this.bounds = bounds;
	this.rnd = distanceRange[1] - distanceRange[0];
	this.distanceRange = distanceRange;
	this.random = new wl_util_Random(seed);
	this.follow = follow;
	this.camera = camera;
	this.ccs = [];
	var _g1 = 0;
	while(_g1 < cameraAmount) {
		++_g1;
		var cc = new wl_demo_CameraController(this.camera);
		var type = allowTypes[this.random.Next() % allowTypes.length];
		if(type == wl_demo_CameraController.FOLLOW) {
			this.initFollow(cc);
		} else if(type == wl_demo_CameraController.LINEAR) {
			this.initLinear(cc);
		} else if(type == wl_demo_CameraController.STATIC) {
			this.initStatic(cc);
		} else if(type == wl_demo_CameraController.BEZIER) {
			this.initBezier(cc);
		}
		this.ccs.push(cc);
	}
};
wl_demo_RandomCameraController.__name__ = ["wl","demo","RandomCameraController"];
wl_demo_RandomCameraController.prototype = {
	start: function() {
		this.cameraSwap = new Date().getTime();
	}
	,swap: function() {
		this.cameraSwap = new Date().getTime();
		this.current = (this.current + 1) % this.ccs.length;
	}
	,updatePartial: function(val) {
		this.ccs[this.current].update(val);
	}
	,updateLength: function(time) {
		var tmp = new Date().getTime() - this.cameraSwap;
		this.ccs[this.current].update(tmp / time);
	}
	,getRndPoint: function() {
		var v = this.bounds.min.clone();
		v = v.addScaledVector(this.bounds.max.clone().sub(this.bounds.min),this.random.NextFloat());
		return v;
	}
	,initFollow: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		var dir = new THREE.Vector3(this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5,this.random.NextFloat() - 0.5);
		dir.normalize();
		dir.multiplyScalar(this.random.NextFloat() * this.rnd + this.md);
		cc.initFollow(obj,dir,new THREE.Vector3(this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10,this.random.NextFloat() * this.md / 10));
	}
	,initStatic: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		cc.initStatic(this.getRndPoint(),obj.position);
	}
	,initLinear: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		cc.initLinear([this.getRndPoint(),this.getRndPoint()],[obj.position.clone(),obj.position.clone().add(new THREE.Vector3(this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10,this.random.NextFloat() * 20 - 10))]);
	}
	,initBezier: function(cc) {
		var obj = this.follow.length > 0?this.follow[this.random.Next() % this.follow.length]:new THREE.Object3D();
		var start = this.getRndPoint();
		var end = this.getRndPoint();
		var pos = [start];
		var looks = [obj.position.clone(),obj.position.clone()];
		var dx = end.x - start.x;
		var dy = end.y - start.y;
		var dz = end.z - start.z;
		var _g = 1;
		while(_g < 6) {
			var i = _g++;
			looks.push(obj.position.clone());
			pos.push(new THREE.Vector3(this.random.NextFloat() * dx / 10 - dx / 20 + i / 6 * dx + start.x,this.random.NextFloat() * dy / 10 - dy / 20 + i / 6 * dy + start.y,this.random.NextFloat() * dz / 10 - dz / 20 + i / 6 * dz + start.z));
		}
		pos.push(end);
		cc.initBezier(pos,looks);
	}
	,__class__: wl_demo_RandomCameraController
};
var wl_demo_SceneBoard = function() {
	this.startTime = new wl_core_TimeSig();
	this.BoardItems = [];
};
wl_demo_SceneBoard.__name__ = ["wl","demo","SceneBoard"];
wl_demo_SceneBoard.prototype = {
	add: function(startTime,endTime,controller) {
		this.BoardItems.push(new wl_demo_BoardItem(startTime,endTime,controller));
	}
	,start: function(ts) {
		this.startTime = ts.clone();
	}
	,update: function(ts,partial,frameTime,delta) {
		var _g = 0;
		var _g1 = this.BoardItems;
		while(_g < _g1.length) {
			var b = _g1[_g];
			++_g;
			var ts2 = ts.clone();
			ts2.subtract(this.startTime);
			b.Run(ts2);
		}
	}
	,__class__: wl_demo_SceneBoard
};
var wl_demo_TimeLine = function(instance,runOn,runOff,partId,renderToScreen,rtsOn,rtsOff,forceNewPart,extra) {
	this.part = instance;
	this.partId = partId;
	this.runOn = runOn;
	this.runOff = runOff;
	this.rtsOn = rtsOn == null?runOn.clone():rtsOn;
	this.rtsOff = rtsOff == null?runOff.clone():rtsOff;
	this.renderToScreen = renderToScreen == null?true:renderToScreen;
	this.forceNewPart = forceNewPart == null?false:forceNewPart;
	this.extra = extra;
};
wl_demo_TimeLine.__name__ = ["wl","demo","TimeLine"];
wl_demo_TimeLine.prototype = {
	toString: function() {
		return this.part.name + ":" + this.rtsOn.toString() + " - " + this.rtsOff.toString();
	}
	,__class__: wl_demo_TimeLine
};
var wl_library_Library = function() {
	if(wl_library_Library.inst == null) {
		wl_library_Library.inst = this;
	} else {
		console.log("Creating multiple Library instances. Are you sure?");
	}
	this.materials = new wl_library_MaterialBuilders();
	this.staticMaterials = new haxe_ds_EnumValueMap();
};
wl_library_Library.__name__ = ["wl","library","Library"];
wl_library_Library.get_instance = function() {
	if(wl_library_Library.inst == null) {
		wl_library_Library.instance = new wl_library_Library();
	}
	return wl_library_Library.inst;
};
wl_library_Library.prototype = {
	getMaterial: function(type,asStatic) {
		if(asStatic) {
			var m = this.staticMaterials.get(type);
			if(m == null) {
				m = Reflect.field(this.materials,type[0]).apply(this.materials,[]);
				this.staticMaterials.set(type,m);
			}
			return m;
		}
		return Reflect.field(this.materials,type[0]).apply(this.materials,[]);
	}
	,__class__: wl_library_Library
};
var wl_library_MaterialBuilders = function() {
};
wl_library_MaterialBuilders.__name__ = ["wl","library","MaterialBuilders"];
wl_library_MaterialBuilders.prototype = {
	chrome: function() {
		var params = { };
		params.envMap = wl_core_Assets.getTexture("chrome_env_map.png");
		params.envMap.mapping = THREE.SphericalReflectionMapping;
		params.reflectivity = 0.8;
		params.color = 16777215;
		return new THREE.MeshPhongMaterial(params);
	}
	,whiteChrome: function() {
		var params = { };
		params.envMap = wl_core_Assets.getTexture("white_chrome_env_map.png");
		params.envMap.mapping = THREE.SphericalReflectionMapping;
		params.reflectivity = 0.8;
		params.color = 16777215;
		return new THREE.MeshPhongMaterial(params);
	}
	,__class__: wl_library_MaterialBuilders
};
var wl_library_Materials = { __ename__ : true, __constructs__ : ["chrome","whiteChrome"] };
wl_library_Materials.chrome = ["chrome",0];
wl_library_Materials.chrome.toString = $estr;
wl_library_Materials.chrome.__enum__ = wl_library_Materials;
wl_library_Materials.whiteChrome = ["whiteChrome",1];
wl_library_Materials.whiteChrome.toString = $estr;
wl_library_Materials.whiteChrome.__enum__ = wl_library_Materials;
var wl_post_aspect_Aspect = function() {
	this.aspect = 1.7777777777777777;
	this.type = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, type : { type : "i", value : 0}, aspect : { type : "f", value : 1.7777777777777777}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("aspect.vert"), fragmentShader : haxe_Resource.getString("aspect.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_aspect_Aspect.__name__ = ["wl","post","aspect","Aspect"];
wl_post_aspect_Aspect.prototype = {
	set_type: function(value) {
		this.type = value;
		this.uniforms.type.value = value;
		return value;
	}
	,set_aspect: function(value) {
		this.aspect = value;
		this.uniforms.aspect.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Aspect");
		f.add(this,"type").step(1).min(0).max(2).onChange(function(val) {
			_gthis.uniforms.type.value = _gthis.type;
		});
		f.add(this,"aspect").step(0.1).min(1).max(4).onChange(function(val1) {
			_gthis.uniforms.aspect.value = _gthis.aspect;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_aspect_Aspect
};
var wl_post_bloom_Bloom = function(resolution,strength,radius,threshold) {
	if(threshold == null) {
		threshold = 0;
	}
	if(radius == null) {
		radius = 0;
	}
	if(strength == null) {
		strength = 0.5;
	}
	this.nMips = 5;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { };
	if(resolution == null) {
		resolution = new THREE.Vector2(2048,2048);
	}
	this.resolution = resolution;
	this.strength = strength;
	this.radius = radius;
	this.threshold = threshold;
	this.enabled = true;
	var pars = { minFilter : THREE.LinearFilter, magFilter : THREE.LinearFilter, format : THREE.RGBAFormat};
	this.renderTargetsHorizontal = [];
	this.renderTargetsVertical = [];
	this.nMips = 5;
	var resx = Math.round(this.resolution.x / 2);
	var resy = Math.round(this.resolution.y / 2);
	this.renderTargetBright = new THREE.WebGLRenderTarget(resx,resy,pars);
	this.renderTargetBright.texture.generateMipmaps = false;
	var _g1 = 0;
	var _g = this.nMips;
	while(_g1 < _g) {
		var i = _g1++;
		var renderTarget = new THREE.WebGLRenderTarget(resx,resy,pars);
		renderTarget.texture.generateMipmaps = false;
		this.renderTargetsHorizontal.push(renderTarget);
		var renderTarget1 = new THREE.WebGLRenderTarget(resx,resy,pars);
		renderTarget1.texture.generateMipmaps = false;
		this.renderTargetsVertical.push(renderTarget1);
		resx = Math.round(resx / 2);
		resy = Math.round(resy / 2);
	}
	if(THREE.LuminosityHighPassShader == null) {
		console.log("THREE.UnrealBloomPass relies on THREE.LuminosityHighPassShader");
	}
	var highPassShader = THREE.LuminosityHighPassShader;
	this.highPassUniforms = THREE.UniformsUtils.clone(highPassShader.uniforms);
	this.highPassUniforms.luminosityThreshold.value = threshold;
	this.highPassUniforms.smoothWidth.value = 0.01;
	this.materialHighPassFilter = new THREE.ShaderMaterial({ uniforms : this.highPassUniforms, vertexShader : highPassShader.vertexShader, fragmentShader : highPassShader.fragmentShader, defines : { }});
	this.separableBlurMaterials = [];
	var kernelSizeArray = [3,5,7,9,11];
	var resx1 = Math.round(this.resolution.x / 2);
	var resy1 = Math.round(this.resolution.y / 2);
	var _g11 = 0;
	var _g2 = this.nMips;
	while(_g11 < _g2) {
		var i1 = _g11++;
		this.separableBlurMaterials.push(this.getSeperableBlurMaterial(kernelSizeArray[i1]));
		this.separableBlurMaterials[i1].uniforms.texSize.value = new THREE.Vector2(resx1,resy1);
		resx1 = Math.round(resx1 / 2);
		resy1 = Math.round(resy1 / 2);
	}
	this.compositeMaterial = this.getCompositeMaterial(this.nMips);
	this.compositeMaterial.uniforms.blurTexture1.value = this.renderTargetsVertical[0].texture;
	this.compositeMaterial.uniforms.blurTexture2.value = this.renderTargetsVertical[1].texture;
	this.compositeMaterial.uniforms.blurTexture3.value = this.renderTargetsVertical[2].texture;
	this.compositeMaterial.uniforms.blurTexture4.value = this.renderTargetsVertical[3].texture;
	this.compositeMaterial.uniforms.blurTexture5.value = this.renderTargetsVertical[4].texture;
	this.compositeMaterial.uniforms.bloomStrength.value = strength;
	this.compositeMaterial.uniforms.bloomRadius.value = 0.1;
	this.compositeMaterial.needsUpdate = true;
	var bloomFactors = [1.0,0.8,0.6,0.4,0.2];
	this.compositeMaterial.uniforms.bloomFactors.value = bloomFactors;
	this.bloomTintColors = [new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1),new THREE.Vector3(1,1,1)];
	this.compositeMaterial.uniforms.bloomTintColors.value = this.bloomTintColors;
	if(THREE.CopyShader == null) {
		console.log("THREE.BloomPass relies on THREE.CopyShader");
	}
	var copyShader = THREE.CopyShader;
	this.copyUniforms = THREE.UniformsUtils.clone(copyShader.uniforms);
	this.copyUniforms.opacity.value = 1.0;
	this.materialCopy = new THREE.ShaderMaterial({ uniforms : this.copyUniforms, vertexShader : copyShader.vertexShader, fragmentShader : copyShader.fragmentShader, blending : THREE.AdditiveBlending, depthTest : false, depthWrite : false, transparent : true});
	this.enabled = true;
	this.needsSwap = false;
	this.oldClearColor = new THREE.Color();
	this.oldClearAlpha = 1;
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.scene = new THREE.Scene();
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene.add(this.quad);
};
wl_post_bloom_Bloom.__name__ = ["wl","post","bloom","Bloom"];
wl_post_bloom_Bloom.prototype = {
	setupDatGui: function(folder) {
		var f = folder.addFolder("Bloom");
		f.add(this,"strength").step(0.01);
		f.add(this,"radius").step(0.01);
		f.add(this,"threshold").step(0.01);
	}
	,setSize: function(width,height) {
		var resx = Math.round(width / 2);
		var resy = Math.round(height / 2);
		this.renderTargetBright.setSize(resx,resy);
		var _g1 = 0;
		var _g = this.nMips;
		while(_g1 < _g) {
			var i = _g1++;
			this.renderTargetsHorizontal[i].setSize(resx,resy);
			this.renderTargetsVertical[i].setSize(resx,resy);
			this.separableBlurMaterials[i].uniforms.texSize.value = new THREE.Vector2(resx,resy);
			resx = Math.round(resx / 2);
			resy = Math.round(resy / 2);
		}
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.oldClearColor.copy(renderer.getClearColor());
		this.oldClearAlpha = renderer.getClearAlpha();
		var oldAutoClear = renderer.autoClear;
		renderer.autoClear = false;
		renderer.setClearColor(new THREE.Color(0,0,0),0);
		this.highPassUniforms.tDiffuse.value = readBuffer.texture;
		this.highPassUniforms.luminosityThreshold.value = this.threshold;
		this.quad.material = this.materialHighPassFilter;
		renderer.render(this.scene,this.camera,this.renderTargetBright,true);
		var inputRenderTarget = this.renderTargetBright;
		var _g1 = 0;
		var _g = this.nMips;
		while(_g1 < _g) {
			var i = _g1++;
			this.quad.material = this.separableBlurMaterials[i];
			this.separableBlurMaterials[i].uniforms.colorTexture.value = inputRenderTarget.texture;
			this.separableBlurMaterials[i].uniforms.direction.value = wl_post_bloom_Bloom.BlurDirectionX;
			renderer.render(this.scene,this.camera,this.renderTargetsHorizontal[i],true);
			this.separableBlurMaterials[i].uniforms.colorTexture.value = this.renderTargetsHorizontal[i].texture;
			this.separableBlurMaterials[i].uniforms.direction.value = wl_post_bloom_Bloom.BlurDirectionY;
			renderer.render(this.scene,this.camera,this.renderTargetsVertical[i],true);
			inputRenderTarget = this.renderTargetsVertical[i];
		}
		this.quad.material = this.compositeMaterial;
		this.compositeMaterial.uniforms.bloomStrength.value = this.strength;
		this.compositeMaterial.uniforms.bloomRadius.value = this.radius;
		this.compositeMaterial.uniforms.bloomTintColors.value = this.bloomTintColors;
		renderer.render(this.scene,this.camera,this.renderTargetsHorizontal[0],true);
		this.quad.material = this.materialCopy;
		this.copyUniforms.tDiffuse.value = this.renderTargetsHorizontal[0].texture;
		renderer.render(this.scene,this.camera,readBuffer,false);
		renderer.setClearColor(this.oldClearColor,this.oldClearAlpha);
		renderer.autoClear = oldAutoClear;
	}
	,getSeperableBlurMaterial: function(kernelRadius) {
		return new THREE.ShaderMaterial({ defines : { 'KERNEL_RADIUS' : kernelRadius, 'SIGMA' : kernelRadius}, uniforms : { 'colorTexture' : { value : null}, 'texSize' : { value : new THREE.Vector2(0.5,0.5)}, 'direction' : { value : new THREE.Vector2(0.5,0.5)}}, vertexShader : ["varying vec2 vUv;","void main() {","\tvUv = uv;","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"), fragmentShader : ["#include <common>","varying vec2 vUv;","uniform sampler2D colorTexture;","uniform vec2 texSize;","uniform vec2 direction;","float gaussianPdf(in float x, in float sigma) {","\treturn 0.39894 * exp( -0.5 * x * x/( sigma * sigma))/sigma;","}","void main() {","\tvec2 invSize = 1.0 / texSize;","\tfloat fSigma = float(SIGMA);","\tfloat weightSum = gaussianPdf(0.0, fSigma);","\tvec3 diffuseSum = texture2D( colorTexture, vUv).rgb * weightSum;","\tfor( int i = 1; i < KERNEL_RADIUS; i ++ ) {","\t\tfloat x = float(i);","\t\tfloat w = gaussianPdf(x, fSigma);","\t\tvec2 uvOffset = direction * invSize * x;","\t\tvec3 sample1 = texture2D( colorTexture, vUv + uvOffset).rgb;","\t\tvec3 sample2 = texture2D( colorTexture, vUv - uvOffset).rgb;","\t\tdiffuseSum += (sample1 + sample2) * w;","\t\tweightSum += 2.0 * w;","\t}","\tgl_FragColor = vec4(diffuseSum/weightSum, 1.0);","}"].join("\n")});
	}
	,getCompositeMaterial: function(nMips) {
		return new THREE.ShaderMaterial({ defines : { 'NUM_MIPS' : nMips}, uniforms : { 'blurTexture1' : { value : null}, 'blurTexture2' : { value : null}, 'blurTexture3' : { value : null}, 'blurTexture4' : { value : null}, 'blurTexture5' : { value : null}, 'dirtTexture' : { value : null}, 'bloomStrength' : { value : 1.0}, 'bloomFactors' : { value : null}, 'bloomTintColors' : { value : null}, 'bloomRadius' : { value : 0.0}}, vertexShader : ["varying vec2 vUv;","void main() {","\tvUv = uv;","\tgl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );","}"].join("\n"), fragmentShader : ["varying vec2 vUv;","uniform sampler2D blurTexture1;","uniform sampler2D blurTexture2;","uniform sampler2D blurTexture3;","uniform sampler2D blurTexture4;","uniform sampler2D blurTexture5;","uniform sampler2D dirtTexture;","uniform float bloomStrength;","uniform float bloomRadius;","uniform float bloomFactors[NUM_MIPS];","uniform vec3 bloomTintColors[NUM_MIPS];","float lerpBloomFactor(const in float factor) { ","\tfloat mirrorFactor = 1.2 - factor;","\treturn mix(factor, mirrorFactor, bloomRadius);","}","void main() {","\tgl_FragColor = bloomStrength * ( lerpBloomFactor(bloomFactors[0]) * vec4(bloomTintColors[0], 1.0) * texture2D(blurTexture1, vUv) + ","\t \t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[1]) * vec4(bloomTintColors[1], 1.0) * texture2D(blurTexture2, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[2]) * vec4(bloomTintColors[2], 1.0) * texture2D(blurTexture3, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[3]) * vec4(bloomTintColors[3], 1.0) * texture2D(blurTexture4, vUv) + ","\t\t\t\t\t\t\t\t lerpBloomFactor(bloomFactors[4]) * vec4(bloomTintColors[4], 1.0) * texture2D(blurTexture5, vUv) );","}"].join("\n")});
	}
	,__class__: wl_post_bloom_Bloom
};
var wl_post_cga_CGA = function() {
	this.amount = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, amount : { type : "f", value : 0}, colors : { type : "v3v", value : [new THREE.Vector3(0,0,0),new THREE.Vector3(0.35,0.35,0.35),new THREE.Vector3(0.,0.,0.66),new THREE.Vector3(0.35,0.35,1.),new THREE.Vector3(0.,0.66,0.),new THREE.Vector3(0.35,0.66,0.35),new THREE.Vector3(0.,0.66,0.66),new THREE.Vector3(0.35,1.,1.),new THREE.Vector3(0.66,0.,0.),new THREE.Vector3(1.,0.35,0.35),new THREE.Vector3(0.66,0.,0.66),new THREE.Vector3(1.,0.35,1.),new THREE.Vector3(0.66,0.35,0.0),new THREE.Vector3(1.,1.,0.35),new THREE.Vector3(0.66,0.66,0.66),new THREE.Vector3(1.,1.,1.)]}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("cga.vert"), fragmentShader : haxe_Resource.getString("cga.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_cga_CGA.__name__ = ["wl","post","cga","CGA"];
wl_post_cga_CGA.prototype = {
	set_amount: function(value) {
		this.amount = value;
		this.uniforms.amount.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		folder.addFolder("CGA").add(this,"amount").step(0.1).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.amount.value = _gthis.amount;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_cga_CGA
};
var wl_post_colorhilight_ColorHilight = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.sweep = 0;
	this.targetVal = 40;
	this.testSweep = false;
	this.color2 = 16777215;
	this.color1 = 16777215;
	this.original = 0.01;
	this.amount = 0.01;
	this.value2 = 0.01;
	this.value1 = 0.01;
	this.range = 0.01;
	this.uniforms = { range : { type : "f", value : 0.03}, value1 : { type : "f", value : 0.2}, value2 : { type : "f", value : 0.5}, amount : { type : "f", value : 0.0}, original : { type : "f", value : 1}, color1 : { type : "v4", value : [1.0,1.0,1.0,1]}, color2 : { type : "v4", value : [1.0,1.0,1.0,1]}, tile : { type : "v2", value : [1.0,1.0]}, tDiffuse : { type : "t"}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("colorhilight.frag"), vertexShader : haxe_Resource.getString("colorhilight.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_colorhilight_ColorHilight.__name__ = ["wl","post","colorhilight","ColorHilight"];
wl_post_colorhilight_ColorHilight.prototype = {
	set_range: function(value) {
		this.range = value;
		this.uniforms.range.value = value;
		return value;
	}
	,set_value1: function(value) {
		this.value1 = value;
		this.uniforms.value1.value = value;
		return value;
	}
	,set_value2: function(value) {
		this.value2 = value;
		this.uniforms.value2.value = value;
		return value;
	}
	,set_amount: function(value) {
		this.amount = value;
		this.uniforms.amount.value = value;
		return value;
	}
	,set_original: function(value) {
		this.original = value;
		this.uniforms.original.value = value;
		return value;
	}
	,set_color1: function(value) {
		this.color1 = value;
		this.uniforms.color1.value = [(value >> 16 & 255) / 255,(value >> 8 & 255) / 255,(value & 255) / 255,1];
		return value;
	}
	,set_color2: function(value) {
		this.color2 = value;
		this.uniforms.color2.value = [(value >> 16 & 255) / 255,(value >> 8 & 255) / 255,(value & 255) / 255,1];
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Color hilight");
		f.add(this,"range").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.set_range(value);
		});
		f.add(this,"value1").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.set_value1(value1);
		});
		f.add(this,"value2").step(0.0001).min(0).max(1).onChange(function(value2) {
			_gthis.set_value2(value2);
		});
		f.add(this,"amount").step(0.0001).min(0).max(1).onChange(function(value3) {
			_gthis.set_amount(value3);
		});
		f.addColor(this,"color1").onChange(function(value4) {
			_gthis.set_color1(value4);
		});
		f.addColor(this,"color2").onChange(function(value5) {
			_gthis.set_color2(value5);
		});
		f.add(this,"original").min(0).max(1).onChange(function(value6) {
			_gthis.set_original(value6);
		});
		f.add(this,"testSweep");
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		if(this.testSweep) {
			this.set_value1(wl_core_Demo.instance.previousTS.toMilliseconds() / 1000 % 1);
			this.set_value2((0.5 + wl_core_Demo.instance.previousTS.toMilliseconds() / 1000) % 1);
		}
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,doSweep: function(time) {
		this.sweep = 0;
		createjs.Tween.get(this,{ onChange : $bind(this,this.sweepUpdate)}).to({ sweep : 1},time,createjs.Ease.quadInOut);
	}
	,sweepUpdate: function() {
		this.uniforms.amount.value = this.targetVal;
		this.uniforms.value1.value = this.sweep;
		this.uniforms.value2.value = (this.sweep + 0.5) % 1;
		this.uniforms.original.value = 1;
	}
	,__class__: wl_post_colorhilight_ColorHilight
};
var wl_post_displacement_Displacement = function(dispmap) {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.zoom = 0.01;
	this.scaleY = 0.01;
	this.scaleX = 0.01;
	this.uniforms = { scaleX : { type : "f", value : 0.03}, scaleY : { type : "f", value : 0.03}, zoom : { type : "f", value : 1}, tDiffuse : { type : "t"}, tDispMap : { type : "t"}, offset : { type : "f2", value : [0,0]}};
	dispmap.wrapS = THREE.RepeatWrapping;
	dispmap.wrapT = THREE.RepeatWrapping;
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("displacement.frag"), vertexShader : haxe_Resource.getString("displacement.vert")});
	this.uniforms.tDispMap.value = dispmap;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_displacement_Displacement.__name__ = ["wl","post","displacement","Displacement"];
wl_post_displacement_Displacement.prototype = {
	set_scaleX: function(value) {
		this.scaleX = value;
		this.uniforms.scaleX.value = value;
		return value;
	}
	,set_scaleY: function(value) {
		this.scaleY = value;
		this.uniforms.scaleY.value = value;
		return value;
	}
	,set_zoom: function(value) {
		this.zoom = value;
		this.uniforms.zoom.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("displacement (post)");
		f.add(this,"scaleX").step(0.0001).min(0).max(1).onChange(function(value) {
			_gthis.set_scaleX(value);
		});
		f.add(this,"scaleY").step(0.0001).min(0).max(1).onChange(function(value1) {
			_gthis.set_scaleY(value1);
		});
		f.add(this,"zoom").step(0.0001).min(0).max(100).onChange(function(value2) {
			_gthis.set_zoom(value2);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_displacement_Displacement
};
var wl_post_distortedTv_DistortedTv = function() {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.brightLimit = 1.00;
	this.brightMultiplier = 1.00;
	this.offsetAmount = 0.00;
	this.vignAmount = 1.00;
	this.blueamplify = 1.0;
	this.greenamplify = 1.0;
	this.distortAmount = 100;
	this.uniforms = { distortAmount : { type : "f", value : 100.1}, tDiffuse : { type : "t"}, greenamplify : { type : "f", value : 1}, blueamplify : { type : "f", value : 1}, vignAmount : { type : "f", value : 1.00}, time : { type : "f", value : 0.0}, offsetAmount : { type : "f", value : 0.0}, brightMultiplier : { type : "f", value : 1.0}, brightLimit : { type : "f", value : 1.0}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, fragmentShader : haxe_Resource.getString("distortedTv.frag"), vertexShader : haxe_Resource.getString("distortedTv.vert")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_distortedTv_DistortedTv.__name__ = ["wl","post","distortedTv","DistortedTv"];
wl_post_distortedTv_DistortedTv.prototype = {
	set_distortAmount: function(value) {
		this.distortAmount = value;
		this.uniforms.distortAmount.value = value;
		return value;
	}
	,set_greenamplify: function(value) {
		this.greenamplify = value;
		this.uniforms.greenamplify.value = value;
		return value;
	}
	,set_blueamplify: function(value) {
		this.blueamplify = value;
		this.uniforms.blueamplify.value = value;
		return value;
	}
	,set_vignAmount: function(value) {
		this.vignAmount = value;
		this.uniforms.vignAmount.value = value;
		return value;
	}
	,set_offsetAmount: function(value) {
		this.offsetAmount = value;
		this.uniforms.offsetAmount.value = value;
		return value;
	}
	,set_brightMultiplier: function(value) {
		this.brightMultiplier = value;
		this.uniforms.brightMultiplier.value = value;
		return value;
	}
	,set_brightLimit: function(value) {
		this.brightLimit = value;
		this.uniforms.brightLimit.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Distorted tv");
		f.add(this,"distortAmount").step(0.01).onChange(function(value) {
			_gthis.set_distortAmount(value);
		});
		f.add(this,"greenamplify").step(0.01).onChange(function(value1) {
			_gthis.set_greenamplify(value1);
			console.log("green change " + value1);
		});
		f.add(this,"blueamplify").step(0.01).onChange(function(value2) {
			_gthis.set_blueamplify(value2);
		});
		f.add(this,"vignAmount").step(0.01).onChange(function(value3) {
			_gthis.set_vignAmount(value3);
		});
		f.add(this,"offsetAmount").step(0.01).onChange(function(value4) {
			_gthis.set_offsetAmount(value4);
		});
		f.add(this,"brightMultiplier").step(0.01).onChange(function(value5) {
			_gthis.set_brightMultiplier(value5);
		});
		f.add(this,"brightLimit").step(0.01).onChange(function(value6) {
			_gthis.set_brightLimit(value6);
		});
	}
	,setTime: function(t) {
		this.uniforms.time.value = t;
	}
	,setDistortion: function(t) {
		this.uniforms.distortAmount.value = t;
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.setTime(wl_core_Demo.instance.previousTS.toMilliseconds() / 1000);
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_distortedTv_DistortedTv
};
var wl_post_dof_DoF = function(depth,camera) {
	this.focusCoords = new THREE.Vector2(0.5,0.5);
	this.shaderFocus = true;
	this.pentagon = false;
	this.dithering = 0.00001;
	this.noise = false;
	this.fringe = 0;
	this.bias = 0;
	this.gain = 0;
	this.threshold = 0;
	this.depthblur = false;
	this.maxblur = 1;
	this.fstop = 1;
	this.focalLength = 90;
	this.focalDepth = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { 'textureWidth' : { type : "f", value : 1.0}, 'textureHeight' : { type : "f", value : 1.0}, 'focalDepth' : { type : "f", value : 2.8}, 'focalLength' : { type : "f", value : 35.0}, 'fstop' : { type : "f", value : 2.2}, 'tColor' : { type : "t", value : null}, 'tDepth' : { type : "t", value : null}, 'maxblur' : { type : "f", value : 1.0}, 'depthblur' : { type : "b", value : 0}, 'threshold' : { type : "f", value : 0.5}, 'gain' : { type : "f", value : 2.0}, 'bias' : { type : "f", value : 0.5}, 'fringe' : { type : "f", value : 0.7}, 'znear' : { type : "f", value : 0.1}, 'zfar' : { type : "f", value : 100}, 'noise' : { type : "b", value : 1}, 'dithering' : { type : "f", value : 0.0001}, 'pentagon' : { type : "b", value : 0}, 'shaderFocus' : { type : "b", value : 1}, 'focusCoords' : { type : "v2", value : new THREE.Vector2(0.5,0.5)}};
	this.sceneCamera = camera;
	var vert = haxe_Resource.getString("dof.vert");
	var frag = haxe_Resource.getString("dof.frag");
	this.uniforms.tDepth.value = depth;
	this.uniforms.textureWidth.value = wl_core_Config.RESOLUTION[0];
	this.uniforms.textureHeight.value = wl_core_Config.RESOLUTION[1];
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : vert, fragmentShader : frag});
	this.enabled = true;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_dof_DoF.__name__ = ["wl","post","dof","DoF"];
wl_post_dof_DoF.prototype = {
	set_focalDepth: function(value) {
		this.focalDepth = value;
		this.uniforms.focalDepth.value = value;
		return value;
	}
	,set_focalLength: function(value) {
		this.focalLength = value;
		this.uniforms.focalLength.value = value;
		return value;
	}
	,set_fstop: function(value) {
		this.fstop = value;
		this.uniforms.fstop.value = value;
		return value;
	}
	,set_maxblur: function(value) {
		this.maxblur = value;
		this.uniforms.maxblur.value = value;
		return value;
	}
	,set_depthblur: function(value) {
		this.depthblur = value;
		this.uniforms.depthblur.value = value;
		return value;
	}
	,set_threshold: function(value) {
		this.threshold = value;
		this.uniforms.threshold.value = value;
		return value;
	}
	,set_gain: function(value) {
		this.gain = value;
		this.uniforms.gain.value = value;
		return value;
	}
	,set_bias: function(value) {
		this.bias = value;
		this.uniforms.bias.value = value;
		return value;
	}
	,set_fringe: function(value) {
		this.fringe = value;
		this.uniforms.fringe.value = value;
		return value;
	}
	,set_noise: function(value) {
		this.noise = value;
		this.uniforms.noise.value = value;
		return value;
	}
	,set_dithering: function(value) {
		this.dithering = value;
		this.uniforms.dithering.value = value;
		return value;
	}
	,set_pentagon: function(value) {
		this.pentagon = value;
		this.uniforms.pentagon.value = value;
		return value;
	}
	,set_shaderFocus: function(value) {
		this.shaderFocus = value;
		this.uniforms.shaderFocus.value = value;
		return value;
	}
	,set_focusCoords: function(value) {
		this.focusCoords = value;
		this.uniforms.focusCoords.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("DoF");
		f.add(this,"focalDepth").step(0.01).onChange(function(value) {
			_gthis.set_focalDepth(value);
		});
		f.add(this,"focalLength").step(0.01).onChange(function(value1) {
			_gthis.set_focalLength(value1);
		});
		f.add(this,"fstop").step(0.01).onChange(function(value2) {
			_gthis.set_fstop(value2);
		});
		f.add(this,"maxblur").step(0.01).onChange(function(value3) {
			_gthis.set_maxblur(value3);
		});
		f.add(this,"depthblur").onChange(function(value4) {
			_gthis.set_depthblur(value4);
		});
		f.add(this,"threshold").step(0.01).onChange(function(value5) {
			_gthis.set_threshold(value5);
		});
		f.add(this,"gain").step(0.01).onChange(function(value6) {
			_gthis.set_gain(value6);
		});
		f.add(this,"bias").step(0.01).onChange(function(value7) {
			_gthis.set_bias(value7);
		});
		f.add(this,"fringe").step(0.01).onChange(function(value8) {
			_gthis.set_fringe(value8);
		});
		f.add(this,"noise").onChange(function(value9) {
			_gthis.set_noise(value9);
		});
		f.add(this,"dithering").step(0.01).onChange(function(value10) {
			_gthis.set_dithering(value10);
		});
		f.add(this,"pentagon").onChange(function(value11) {
			_gthis.set_pentagon(value11);
		});
		f.add(this,"shaderFocus").onChange(function(value12) {
			_gthis.set_shaderFocus(value12);
		});
		f.add(this.focusCoords,"x").step(0.01).onChange(function(value13) {
			_gthis.uniforms.focusCoords.value[0] = value13;
		});
		f.add(this.focusCoords,"y").step(0.01).onChange(function(value14) {
			_gthis.uniforms.focusCoords.value[1] = value14;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.zfar.value = this.sceneCamera.far;
		this.uniforms.znear.value = this.sceneCamera.near;
		this.uniforms.tColor.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_dof_DoF
};
var wl_post_gray_Gray = function(gray) {
	this.gray = 0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { tDiffuse : { type : "t"}, gray : { type : "f"}};
	if(gray != null) {
		this.set_gray(gray);
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("gray.vert"), fragmentShader : haxe_Resource.getString("gray.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_gray_Gray.__name__ = ["wl","post","gray","Gray"];
wl_post_gray_Gray.prototype = {
	set_gray: function(value) {
		this.gray = value;
		this.uniforms.gray.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		folder.addFolder("Gray").add(this,"gray").step(0.01).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.gray.value = _gthis.gray;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_gray_Gray
};
var wl_post_pixelate_Pixelate = function(pixelamount) {
	this.pixelamount = new THREE.Vector2(128,72);
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, pixelamount : { type : "v2", value : new THREE.Vector2(128,72)}};
	if(pixelamount != null) {
		this.uniforms.pixelamount.value = pixelamount;
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("pixelate.vert"), fragmentShader : haxe_Resource.getString("pixelate.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_pixelate_Pixelate.__name__ = ["wl","post","pixelate","Pixelate"];
wl_post_pixelate_Pixelate.prototype = {
	set_pixelamount: function(value) {
		this.pixelamount = value;
		this.uniforms.pixelamount.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Pixelate");
		f.add(this.pixelamount,"x").step(1).min(1).max(wl_core_Config.RESOLUTION[0]).onChange(function(val) {
			_gthis.uniforms.pixelamount.value = _gthis.pixelamount;
		});
		f.add(this.pixelamount,"y").step(1).min(1).max(wl_core_Config.RESOLUTION[1]).onChange(function(val1) {
			_gthis.uniforms.pixelamount.value = _gthis.pixelamount;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_pixelate_Pixelate
};
var wl_post_rgbshift_RGBShift = function(rshift,gshift,bshift) {
	this.bshift = 0.0;
	this.rshift = 0.0;
	this.gshift = 0.0;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.uniforms = { gshift : { type : "f", value : 0.04}, rshift : { type : "f", value : 0.04}, bshift : { type : "f", value : 0.0}, tDiffuse : { type : "t"}};
	if(rshift != null) {
		this.set_rshift(rshift);
	} else {
		this.set_rshift(this.rshift);
	}
	if(gshift != null) {
		this.set_gshift(gshift);
	} else {
		this.set_gshift(this.gshift);
	}
	if(bshift != null) {
		this.set_bshift(bshift);
	} else {
		this.set_bshift(this.bshift);
	}
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("rgbshift.vert"), fragmentShader : haxe_Resource.getString("rgbshift.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_rgbshift_RGBShift.__name__ = ["wl","post","rgbshift","RGBShift"];
wl_post_rgbshift_RGBShift.prototype = {
	set_gshift: function(value) {
		this.gshift = value;
		this.uniforms.gshift.value = value;
		return value;
	}
	,set_rshift: function(value) {
		this.rshift = value;
		this.uniforms.rshift.value = value;
		return value;
	}
	,set_bshift: function(value) {
		this.bshift = value;
		this.uniforms.bshift.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("RGB");
		f.add(this,"rshift").step(0.0001).min(-1).max(1).onChange(function(value) {
			_gthis.set_rshift(value);
		});
		f.add(this,"gshift").step(0.0001).min(-1).max(1).onChange(function(value1) {
			_gthis.set_gshift(value1);
		});
		f.add(this,"bshift").step(0.0001).min(-1).max(1).onChange(function(value2) {
			_gthis.set_bshift(value2);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_rgbshift_RGBShift
};
var wl_post_standard_StandardShader = function(gamma) {
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.gamma = 1;
	this.brightness = 0;
	this.uniforms = { brightness : { type : "f", value : 0.0}, gamma : { type : "f", value : 0.0}, tDiffuse : { type : "t"}};
	if(gamma == null) {
		gamma = 1;
	}
	this.set_gamma(gamma);
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("standard.vert"), fragmentShader : haxe_Resource.getString("standard.frag")});
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_standard_StandardShader.__name__ = ["wl","post","standard","StandardShader"];
wl_post_standard_StandardShader.prototype = {
	set_brightness: function(val) {
		return this.uniforms.brightness.value = val;
	}
	,set_gamma: function(val) {
		return this.uniforms.gamma.value = val;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("Standard");
		f.add(this,"brightness").onChange(function(val) {
			_gthis.uniforms.brightness.value = _gthis.gamma;
		});
		f.add(this,"gamma").onChange(function(val1) {
			_gthis.uniforms.gamma.value = _gthis.gamma;
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_standard_StandardShader
};
var wl_post_vhs_VHS = function() {
	this.colorNoise = 0.1;
	this.hold = false;
	this.size = 0.97;
	this.intensity = 1;
	this.jitter = 1;
	this.quad = new THREE.Mesh(new THREE.PlaneBufferGeometry(2,2),null);
	this.scene = new THREE.Scene();
	this.camera = new THREE.OrthographicCamera(-1,1,1,-1,0,1);
	this.holdTime = 0;
	this.uniforms = { resolution : { type : "v2", value : new THREE.Vector2(1280,720)}, tDiffuse : { type : "t"}, tNoise : { type : "t"}, intensity : { type : "f", value : 1}, jitter : { type : "f", value : 1}, time : { type : "f", value : 1}, size : { type : "f", value : 0.97}, holdTime : { type : "f", value : 0.0}, colorNoise : { type : "f", value : 0.0}};
	this.enabled = true;
	this.material = new THREE.ShaderMaterial({ uniforms : this.uniforms, vertexShader : haxe_Resource.getString("vhs.vert"), fragmentShader : haxe_Resource.getString("vhs.frag")});
	var t = wl_core_Assets.getTexture("noise.png");
	t.wrapS = THREE.RepeatWrapping;
	t.wrapT = THREE.RepeatWrapping;
	this.uniforms.tNoise.value = t;
	this.renderToScreen = false;
	this.needsSwap = true;
	this.quad.material = this.material;
	this.scene.add(this.quad);
};
wl_post_vhs_VHS.__name__ = ["wl","post","vhs","VHS"];
wl_post_vhs_VHS.prototype = {
	set_jitter: function(value) {
		this.jitter = value;
		this.uniforms.jitter.value = value;
		return value;
	}
	,set_intensity: function(value) {
		this.intensity = value;
		this.uniforms.intensity.value = value;
		return value;
	}
	,set_size: function(value) {
		this.size = value;
		this.uniforms.size.value = value;
		return value;
	}
	,set_hold: function(value) {
		this.hold = value;
		return value;
	}
	,set_colorNoise: function(value) {
		this.colorNoise = value;
		this.uniforms.colorNoise.value = value;
		return value;
	}
	,setupDatGui: function(folder) {
		var _gthis = this;
		var f = folder.addFolder("VHS");
		f.add(this,"intensity").step(0.01).min(0).max(1).onChange(function(val) {
			_gthis.uniforms.intensity.value = _gthis.intensity;
		});
		f.add(this,"jitter").step(0.01).min(0).max(1).onChange(function(val1) {
			_gthis.uniforms.jitter.value = _gthis.jitter;
		});
		f.add(this,"size").step(0.01).min(0).max(1).onChange(function(val2) {
			_gthis.uniforms.size.value = _gthis.size;
		});
		f.add(this,"colorNoise").step(0.01).min(0).max(10).onChange(function(val3) {
			_gthis.uniforms.colorNoise.value = _gthis.colorNoise;
		});
		f.add(this,"hold").onChange(function(val4) {
			_gthis.set_hold(val4);
		});
	}
	,render: function(renderer,writeBuffer,readBuffer,delta) {
		this.uniforms.tDiffuse.value = readBuffer.texture;
		this.uniforms.time.value = wl_core_Demo.instance.previousTS.toMilliseconds() / 1000;
		if(this.hold) {
			this.uniforms.holdTime.value = this.holdTime / 1000;
		} else {
			this.holdTime += isNaN(wl_core_Graphics.instance.delta)?0:wl_core_Graphics.instance.delta;
			this.uniforms.holdTime.value = this.holdTime / 1000;
		}
		if(this.renderToScreen) {
			renderer.render(this.scene,this.camera);
		} else {
			renderer.render(this.scene,this.camera,writeBuffer,false);
		}
	}
	,__class__: wl_post_vhs_VHS
};
var wl_setup_Setup = function() {
	throw new js__$Boot_HaxeError("Setup is static only.");
};
wl_setup_Setup.__name__ = ["wl","setup","Setup"];
wl_setup_Setup.init = function(demo) {
	wl_setup_Setup.setupDiv = $("#setup");
	wl_setup_Setup.demoDiv = $("#demo");
	wl_setup_Setup.resolution = wl_setup_Setup.setupDiv.find("#resolution");
	var fullscreen = wl_setup_Setup.setupDiv.find("#fullscreen");
	var start = wl_setup_Setup.setupDiv.find("#start");
	fullscreen.click(wl_setup_Setup.fullScreenClickHandler);
	start.click(wl_setup_Setup.startClickHandler);
	wl_setup_Setup.demo = demo;
	if(window.location.protocol.indexOf("file") >= 0) {
		$("#localWarning").css("display","");
	}
};
wl_setup_Setup.hideSetup = function() {
	wl_setup_Setup.setupDiv.remove();
};
wl_setup_Setup.startRun = function() {
	if(wl_setup_Setup.setupDiv.find("#muted").find("input")["is"](":checked")) {
		wl_core_Config.MUTED = true;
	}
	var debug = wl_setup_Setup.setupDiv.find("#debug").find("input")["is"](":checked");
	wl_core_Config.DEBUG = debug;
	if(debug) {
		$(".debug").css("display","block");
	} else {
		$(".debug").css("display","none");
	}
	wl_setup_Setup.demo.init(wl_setup_Setup.demoDiv[0],function() {
		wl_setup_Setup.loadImg.remove();
		wl_setup_Setup.demo.start();
	});
	wl_setup_Setup.demoDiv.append(wl_setup_Setup.demo.graphics.canvas);
	var img = wl_core_Assets.get("k80s.png");
	wl_setup_Setup.demoDiv.append(img);
	img.style.position = "absolute";
	img.style.left = "0px";
	img.style.right = "0px";
	img.style.top = "0px";
	img.style.bottom = "0px";
	img.style.width = "100%";
	img.style.height = "100%";
	wl_setup_Setup.loadImg = img;
	window.document.getElementById("demo").style.display = "block";
};
wl_setup_Setup.fullScreenClickHandler = function(e) {
	wl_setup_Setup.hideSetup();
	try {
		wl_setup_Setup.demoDiv[0].requestFullscreen();
	} catch( e1 ) {
		throw new js__$Boot_HaxeError("Full screen could not be initialized. Please reload and try again.");
	}
	var w = window.screen.width;
	var h = window.screen.height;
	var ratio = wl_core_Config.RATIO;
	var lockAspect = $("#aspectLock input").val() == "on";
	if(lockAspect && w / ratio < h) {
		h = w * 720 / 1280;
	} else if(lockAspect && h < w / ratio) {
		w = h * 1280 / 720;
	}
	wl_core_Config.RESOLUTION[0] = Math.floor(w);
	wl_core_Config.RESOLUTION[1] = Math.floor(h);
	wl_setup_Setup.demoDiv.css("background","black");
	haxe_Timer.delay(wl_setup_Setup.startRun,5000);
};
wl_setup_Setup.startClickHandler = function(e) {
	$("#demo").css("transform","").css("-webkit-transform","");
	var lockAspect = $("#aspectLock input").val() == "on";
	$("#muted input")["is"](":checked");
	var resolutionType = $("#resolution .active input[name='options']").val();
	wl_setup_Setup.hideSetup();
	var w = 1280;
	var h = 720;
	if(resolutionType == "b") {
		w = 1920;
		h = 1080;
	} else if(resolutionType == "c") {
		w = window.innerWidth;
		h = window.innerHeight;
		var ratio = wl_core_Config.RATIO;
		if(lockAspect && w / ratio < h) {
			h = w / ratio;
		} else if(lockAspect && h < w / ratio) {
			w = h * ratio;
		}
	}
	wl_core_Config.RESOLUTION[0] = w;
	wl_core_Config.RESOLUTION[1] = h;
	wl_setup_Setup.demoDiv.css("width",w + "px").css("height",h + "px");
	haxe_Timer.delay(wl_setup_Setup.startRun,50);
};
wl_setup_Setup.prototype = {
	__class__: wl_setup_Setup
};
var wl_sounds_Channels = { __ename__ : true, __constructs__ : ["left","right","both"] };
wl_sounds_Channels.left = ["left",0];
wl_sounds_Channels.left.toString = $estr;
wl_sounds_Channels.left.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.right = ["right",1];
wl_sounds_Channels.right.toString = $estr;
wl_sounds_Channels.right.__enum__ = wl_sounds_Channels;
wl_sounds_Channels.both = ["both",2];
wl_sounds_Channels.both.toString = $estr;
wl_sounds_Channels.both.__enum__ = wl_sounds_Channels;
var wl_util_ArrayUtil = function() {
};
wl_util_ArrayUtil.__name__ = ["wl","util","ArrayUtil"];
wl_util_ArrayUtil.shuffle = function(array) {
	var currentIndex = array.length;
	var temporaryValue;
	var randomIndex;
	while(0 != currentIndex) {
		randomIndex = Math.floor(wl_util_Random.nextFloat() * currentIndex);
		--currentIndex;
		temporaryValue = array[currentIndex];
		array[currentIndex] = array[randomIndex];
		array[randomIndex] = temporaryValue;
	}
	return array;
};
wl_util_ArrayUtil.prototype = {
	__class__: wl_util_ArrayUtil
};
var wl_util_DatGuiHelper = function() {
};
wl_util_DatGuiHelper.__name__ = ["wl","util","DatGuiHelper"];
wl_util_DatGuiHelper.addVector = function(folder,vector,step,callback) {
	if(step == null) {
		step = 0.1;
	}
	folder.add(vector,"x").step(step).onChange(callback);
	folder.add(vector,"y").step(step).onChange(callback);
	folder.add(vector,"z").step(step).onChange(callback);
};
wl_util_DatGuiHelper.prototype = {
	__class__: wl_util_DatGuiHelper
};
var wl_util_ExplodeGeometry = function() {
};
wl_util_ExplodeGeometry.__name__ = ["wl","util","ExplodeGeometry"];
wl_util_ExplodeGeometry.explode = function(geometry) {
	var vertices = [];
	var _g1 = 0;
	var _g = geometry.faces.length;
	while(_g1 < _g) {
		var i = _g1++;
		var n = vertices.length;
		var face = geometry.faces[i];
		var a = face.a;
		var b = face.b;
		var c = face.c;
		var va = geometry.vertices[a];
		var vb = geometry.vertices[b];
		var vc = geometry.vertices[c];
		vertices.push(va.clone());
		vertices.push(vb.clone());
		vertices.push(vc.clone());
		face.a = n;
		face.b = n + 1;
		face.c = n + 2;
	}
	geometry.vertices = vertices;
};
wl_util_ExplodeGeometry.prototype = {
	__class__: wl_util_ExplodeGeometry
};
var wl_util_LoadManager = $hx_exports["wl"]["util"]["LoadManafer"] = function() {
};
wl_util_LoadManager.__name__ = ["wl","util","LoadManager"];
wl_util_LoadManager.get_totalCount = function() {
	return wl_util_LoadManager._totalCount + wl_util_LoadManager.loadersWaiting.length;
};
wl_util_LoadManager.onload = function() {
	wl_util_LoadManager.managerDone = true;
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.checkAllDone = function() {
	if(wl_util_LoadManager.managerDone || wl_util_LoadManager._totalCount == 0 && wl_util_LoadManager.loadersWaiting.length == 0) {
		wl_util_LoadManager.onComplete();
	}
};
wl_util_LoadManager.onerror = function() {
};
wl_util_LoadManager.onprogress = function(s,p,t) {
	console.log(s + "," + p + "," + t);
};
wl_util_LoadManager.addLoader = function(loaderClass) {
	var ldr = Type.createInstance(loaderClass,[wl_util_LoadManager.loadingManager]);
	wl_util_LoadManager._totalCount++;
	return ldr;
};
wl_util_LoadManager.addManualLoader = function(loader) {
	wl_util_LoadManager.loadersWaiting.push(loader);
};
wl_util_LoadManager.manualLoaderComplete = function(loader) {
	HxOverrides.remove(wl_util_LoadManager.loadersWaiting,loader);
	wl_util_LoadManager.checkAllDone();
};
wl_util_LoadManager.prototype = {
	__class__: wl_util_LoadManager
};
var wl_util_MathUtil = function() {
};
wl_util_MathUtil.__name__ = ["wl","util","MathUtil"];
wl_util_MathUtil.clamp = function(low,high,val) {
	if(val < low) {
		return low;
	} else if(val > high) {
		return high;
	} else {
		return val;
	}
};
wl_util_MathUtil.FromVector3 = function(position,sphereRadius) {
	var lat = 90 - Math.acos(position.y / sphereRadius) * 180 / Math.PI;
	return [(270 + Math.atan2(position.x,position.z) * 180 / Math.PI) % 360 - 180,lat];
};
wl_util_MathUtil.componentLerp = function(v1,v2,phase,easex,easey,easez,setTo) {
	if(setTo == null) {
		setTo = new THREE.Vector3();
	} else {
		setTo = setTo;
	}
	setTo.set(easex(1 - phase) * v1.x + easex(phase) * v2.x,easey(1 - phase) * v1.y + easey(phase) * v2.y,easez(1 - phase) * v1.z + easez(phase) * v2.z);
	return setTo;
};
wl_util_MathUtil.prototype = {
	__class__: wl_util_MathUtil
};
var wl_util_Random = function(seed) {
	this.seed = 123;
	this.Init(seed);
};
wl_util_Random.__name__ = ["wl","util","Random"];
wl_util_Random.init = function(seed) {
	wl_util_Random.instance.Init(seed);
};
wl_util_Random.next = function() {
	return wl_util_Random.instance.Next();
};
wl_util_Random.nextFloat = function() {
	return wl_util_Random.instance.NextFloat();
};
wl_util_Random.range = function(low,high) {
	return wl_util_Random.instance.Range(low,high);
};
wl_util_Random.prototype = {
	Init: function(seed) {
		this.seed = seed;
	}
	,Next: function() {
		var hi = Math.floor(this.seed / 127773);
		var test = 16807 * Math.floor(this.seed % 127773) - 2836 * hi;
		if(test < 0) {
			test += 2147483647;
		}
		this.seed = test;
		return this.seed;
	}
	,NextFloat: function() {
		return this.Next() / 2147483647;
	}
	,Range: function(low,high) {
		return Math.floor(this.NextFloat() * (high - low) + low);
	}
	,__class__: wl_util_Random
};
var wl_util_ScreenUtil = function() {
};
wl_util_ScreenUtil.__name__ = ["wl","util","ScreenUtil"];
wl_util_ScreenUtil.projectToNormalizedScreenPosition = function(position,camera) {
	var widthHalf = wl_core_Config.RESOLUTION[0] * 0.5;
	var heightHalf = wl_core_Config.RESOLUTION[1] * 0.5;
	var vector = position.clone().project(camera);
	var r = new THREE.Vector2();
	r.x = vector.x * widthHalf + widthHalf;
	r.y = -(vector.y * heightHalf) + heightHalf;
	r.x = r.x / (widthHalf * 2);
	r.y = r.y / (heightHalf * 2);
	return r;
};
wl_util_ScreenUtil.prototype = {
	__class__: wl_util_ScreenUtil
};
var $_, $fid = 0;
function $bind(o,m) { if( m == null ) return null; if( m.__id__ == null ) m.__id__ = $fid++; var f; if( o.hx__closures__ == null ) o.hx__closures__ = {}; else f = o.hx__closures__[m.__id__]; if( f == null ) { f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; o.hx__closures__[m.__id__] = f; } return f; }
String.prototype.__class__ = String;
String.__name__ = ["String"];
Array.__name__ = ["Array"];
Date.prototype.__class__ = Date;
Date.__name__ = ["Date"];
var Int = { __name__ : ["Int"]};
var Dynamic = { __name__ : ["Dynamic"]};
var Float = Number;
Float.__name__ = ["Float"];
var Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = { __name__ : ["Class"]};
var Enum = { };
haxe_Resource.content = [{ name : "aspect.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "volumetric.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSB2ZWMyIGxpZ2h0UG9zaXRpb247DQp1bmlmb3JtIGZsb2F0IGV4cG9zdXJlOw0KdW5pZm9ybSBmbG9hdCBkZWNheTsNCnVuaWZvcm0gZmxvYXQgZGVuc2l0eTsNCnVuaWZvcm0gZmxvYXQgd2VpZ2h0Ow0KdW5pZm9ybSBpbnQgc2FtcGxlczsNCmNvbnN0IGludCBNQVhfU0FNUExFUyA9IDEwMDsNCg0Kdm9pZCBtYWluKCkNCnsNCgl2ZWMyIHRleENvb3JkID0gdlV2Ow0KICAgIHZlYzIgZGVsdGFUZXh0Q29vcmQgPSB0ZXhDb29yZCAtIGxpZ2h0UG9zaXRpb247DQogICAgZGVsdGFUZXh0Q29vcmQgKj0gMS4wIC8gZmxvYXQoc2FtcGxlcykgKiBkZW5zaXR5Ow0KICAgIHZlYzQgY29sb3IgPSB0ZXh0dXJlMkQodERpZmZ1c2UsIHRleENvb3JkKTsNCiAgICBmbG9hdCBpbGx1bWluYXRpb25EZWNheSA9IDEuMDsNCiAgICBmb3IoaW50IGk9MDsgaSA8IE1BWF9TQU1QTEVTOyBpKyspDQogICAgew0KICAgIGlmKGkgPT0gc2FtcGxlcyl7DQoJCWJyZWFrOw0KICAgICAgICB9DQoJCXRleENvb3JkIC09IGRlbHRhVGV4dENvb3JkOw0KICAgICAgICB2ZWM0IHNhbXBsZSA9IHRleHR1cmUyRCh0RGlmZnVzZSwgdGV4Q29vcmQpOw0KICAgICAgICBzYW1wbGUgKj0gaWxsdW1pbmF0aW9uRGVjYXkgKiB3ZWlnaHQ7DQogICAgICAgIGNvbG9yICs9IHNhbXBsZTsNCiAgICAgICAgaWxsdW1pbmF0aW9uRGVjYXkgKj0gZGVjYXk7DQogICAgfQ0KICAgIGdsX0ZyYWdDb2xvciA9IGNvbG9yICogZXhwb3N1cmU7DQp9DQo"},{ name : "LinePlane.frag", data : "dW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQoNCnVuaWZvcm0gZmxvYXQgc2l6ZVg7DQp1bmlmb3JtIGZsb2F0IHdhbGxYOw0KdW5pZm9ybSBmbG9hdCBzaXplWTsNCnVuaWZvcm0gZmxvYXQgd2FsbFk7DQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQoNCnZhcnlpbmcgdmVjMiB2VXY7DQoNCnVuaWZvcm0gdmVjMiBmZnQ7DQp1bmlmb3JtIGZsb2F0IHNwZWVkOw0KDQp2b2lkIG1haW4oIHZvaWQgKSB7DQoJDQoJdmVjMiB1diA9IHZVdjsNCgkNCglmbG9hdCBpbnRYID0gYWJzKG1vZCh1di54LCBzaXplWCktc2l6ZVgqLjUpOw0KCWludFgtPXdhbGxYOw0KCWlmIChpbnRYIDwgMC4pIGludFggPTAuOw0KCWludFggPSBpbnRYL3NpemVYKjEuOw0KCQ0KCWZsb2F0IGludFkgPSBhYnMobW9kKHV2LnkrdGltZSpzcGVlZCwgc2l6ZVkpLXNpemVZKi41KTsNCglpbnRZLT13YWxsWTsNCglpZiAoaW50WSA8IDAuKSBpbnRZID0wLjsNCglpbnRZID0gaW50WS9zaXplWSoxLjsNCgkNCglmbG9hdCBpbnRTID0gKG1heChpbnRYLCBpbnRZKSk7DQoJLy9pbnRTKj1pbnRTKmludFMqaW50UyppbnRTOw0KCXZlYzQgYmMgPSB2ZWM0KHV2LXZlYzIoMC4sc3BlZWQpLDAuNSswLjUqc2luKHRpbWUpLDEuMCk7DQoJLy9iYyA9IHZlYzQoMS4pOw0KCWludFM9c21vb3Roc3RlcCgwLiwwLjI1LGludFMpOw0KCWdsX0ZyYWdDb2xvciA9IGJjKihtaXgoZmZ0LngsZmZ0LnksdXYueCkrMC4yMCkqaW50UzsNCg0KfQ"},{ name : "moneyplane.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSBzYW1wbGVyMkQgZmZ0TWFwOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBmbG9hdCBtb3VudGFpbnM7DQoNCnZvaWQgbWFpbigpDQp7DQoJdlV2ID0gdXY7DQoJDQoJZmxvYXQgZGlzdCA9ICgwLjUtIHV2LngpOw0KCWZsb2F0IGFuZ2xlID0gc2luKHRpbWUqMS4rdXYueSowLjErY29zKHRpbWUqMS44K3V2LnkpKjAuNSkqNS41ICsgdXYueSoxLjsNCgkNCgl2ZWMzIG9mZnMgPXZlYzMoDQoJCXNpbihhbmdsZSoxLjQpKjEuMSwNCgkJY29zKGFuZ2xlKjEuOSkqMC43LA0KCQljb3MoYW5nbGUqMC43Ky40KSoxLjENCgkpOw0KCQ0KCXZlYzQgbXZQb3NpdGlvbiA9IG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHBvc2l0aW9uK29mZnMsIDEuMCApOw0KCQ0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG12UG9zaXRpb247DQp9"},{ name : "colorhilight.frag", data : "dW5pZm9ybSBmbG9hdCByYW5nZTsNCnVuaWZvcm0gZmxvYXQgdmFsdWUxOw0KdW5pZm9ybSBmbG9hdCB2YWx1ZTI7DQp1bmlmb3JtIGZsb2F0IG9yaWdpbmFsOw0KdW5pZm9ybSBmbG9hdCBhbW91bnQ7DQp1bmlmb3JtIHZlYzQgY29sb3IxOw0KdW5pZm9ybSB2ZWM0IGNvbG9yMjsNCnVuaWZvcm0gdmVjMiB0aWxlOw0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYqdGlsZSk7DQoJDQoJLy9NYWtlIGNvbnRpbnVvdXMgdHJpYW5nbGUgZnVuY3Rpb24NCglmbG9hdCB2YWwxID0gdmFsdWUxKjIuOw0KCXZhbDEgPSB2YWwxIDwgMS4gPyB2YWwxIDogMi4tdmFsMTsNCglmbG9hdCB2YWwyID0gdmFsdWUyKjIuOw0KCXZhbDEgPSB2YWwyIDwgMS4gPyB2YWwyIDogMi4tdmFsMjsNCgkNCglmbG9hdCB0aW1lb2ZmMSA9IG1vZCh2YWwxLCAxLiArIHJhbmdlKTsNCglmbG9hdCB0aW1lb2ZmMiA9IG1vZCh2YWwyLCAxLiArIHJhbmdlKTsNCgkNCglmbG9hdCBtcDEgPSAoYWJzKGMuciAtIHRpbWVvZmYxKSA+IHJhbmdlKSA/IDEuIDogMC47DQoJZmxvYXQgbXAyID0gKGFicyhjLmcgLSB0aW1lb2ZmMikgPiByYW5nZSkgPyAxLiA6IDAuOw0KCQ0KCWZsb2F0IGF2ZyA9IChjLnIrYy5nK2MuYikvMy47DQoJdmVjNCBhZHMxID0gY29sb3IxICogYWJzKGF2ZyAtIHRpbWVvZmYxKTsNCgl2ZWM0IGFkczIgPSBjb2xvcjIgKiBhYnMoYXZnIC0gdGltZW9mZjIpOw0KCQ0KCXZlYzQgY29sID0gKDEuLSBtcDEpICogYWRzMSArICgxLiAtIG1wMikqYWRzMjsNCgkNCglnbF9GcmFnQ29sb3IgPSBjKm9yaWdpbmFsICsgY29sKmFtb3VudDsNCn0NCg"},{ name : "RoundPlane.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSBzYW1wbGVyMkQgZmZ0TWFwOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBmbG9hdCBtb3VudGFpbnM7DQoNCnZvaWQgbWFpbigpDQp7DQoJdlV2ID0gdXY7DQoJZmxvYXQgb2ZmID0gdGV4dHVyZTJEKGZmdE1hcCwgdXYpLnIqMC47DQoJDQoJZmxvYXQgZGlzdCA9IHNtb290aHN0ZXAoMC4sMS4sdXYueSkqKHNtb290aHN0ZXAoMC4sMC41LGFicyh1di54LTAuNSktMC4wMjUpKSowLjU7DQoJZGlzdCA9IG1pbigwLjI1LCBkaXN0KTsNCglkaXN0ICs9IHNpbih0aW1lKjMuK3V2LngqMTcuK3V2LnkqMTIuKSpkaXN0KyBzaW4odGltZSoyLit1di54KjYwLit1di55KjIzLikgKiBkaXN0KjAuMisgY29zKHRpbWUqMS4yK3V2LngqNDAuK3V2LnkqMzMuKSAqIGRpc3QqMC4xOw0KCS8vZGlzdCAqPSAoc2luKHRpbWUqMy4rdXYueCo3Lit1di55KjUuKSowLjgrY29zKDEuMi10aW1lKjMuK3V2LngqMjAuK3V2LnkqMjguKSowLjQrY29zKDIuK3RpbWUqNC4rdXYueCo4My4rdXYueSo4OC4pKjAuMSkqZGlzdDsNCgkNCgl2ZWM0IG12UG9zaXRpb24gPSBtb2RlbFZpZXdNYXRyaXggKiB2ZWM0KCBwb3NpdGlvbit2ZWMzKDAuLDAuLG9mZipkaXN0K21heCgwLixkaXN0KjQwLikpKm1vdW50YWlucywgMS4wICk7DQoJDQoJZ2xfUG9zaXRpb24gPSBwcm9qZWN0aW9uTWF0cml4ICogbXZQb3NpdGlvbjsNCn0"},{ name : "bgQuad.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCnZvaWQgbWFpbigpDQp7DQoJdmVjMiB1diA9IHZVdjsNCiAgICANCiAgICB2ZWMzIGNvbHMgPSB2ZWMzKDEuLCAxLiwxLik7DQogICAgDQogICAgZmxvYXQgdiA9IDAuOw0KICAgIHZlYzMgYyA9IHZlYzMoMC4pOw0KICAgIGZvciggaW50IGkgPSAwOyBpIDwgMTA7IGkrKykNCiAgICB7DQogICAgIAlmbG9hdCB4cCA9IHNpbihmbG9hdChpKSozLit0aW1lKigwLjEyK2Zsb2F0KGkpKi4wMSkpKjIuOw0KICAgICAgICBmbG9hdCBkaXN0ID0gbWF4KDEwLjgsYWJzKHV2LngteHApKig0NS4rMTAuKnNpbih0aW1lKjAuMytmbG9hdChpKSkpKTsNCiAgICAgICAgDQogICAgICAgIGMrPW1heCh2ZWMzKDAuKSwxLi9kaXN0ICogY29scyooMS4wLXV2LnkqMC40NykqMC43KSoyLjsNCiAgICAgICAgDQogICAgICAgIHYrPXV2LngtMC41KnhwOw0KICAgICAgICANCiAgICB9DQogICAgDQogICAgZ2xfRnJhZ0NvbG9yID12ZWM0KHNtb290aHN0ZXAodmVjMygwLjQyKSwgdmVjMygwLjk5KSxjKSwxLikqdmVjNCgxLiwgMC40LDAuNCwwLjgpOw0KfQ"},{ name : "DollarMat.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBmbG9hdCBzaXplWDsNCnVuaWZvcm0gZmxvYXQgc2l6ZVk7DQp1bmlmb3JtIGZsb2F0IGJyaWdodG5lc3M7DQp1bmlmb3JtIHZlYzIgZmZ0Ow0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJDQoJZmxvYXQgZGlyZWN0aW9uID0gLTEuOw0KICAgIGlmKHN0ZXAobW9kKHV2Lngqc2l6ZVgsMi4pLDEuMCkgPT0gMS4wKXsNCiAgICAJZGlyZWN0aW9uID0gMS47DQogICAgfQ0KCQ0KCXV2LnggPSBtb2QodXYueCpzaXplWCwxLik7DQoJDQoJdXYueSA9IG1vZCh1di55KnNpemVZK3RpbWUqZGlyZWN0aW9uLDEuKTsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmYsdXYpOwkNCgkNCglmbG9hdCBiID0gYnJpZ2h0bmVzczsNCgliKj0gZmZ0Lng7DQoJZ2xfRnJhZ0NvbG9yID0gYypiOw0KCQ0KfQ0K"},{ name : "rgbshift.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "gray.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSBmbG9hdCBncmF5Ow0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodERpZmZ1c2UsdXYpOw0KCWZsb2F0IGdyID0gZG90KGMucmdiLCB2ZWMzKDAuMjk5LCAwLjU4NywgMC4xMTQpKTsNCiAgICB2ZWMzIGZjID0gbWl4KGMucmdiLCB2ZWMzKGdyKSwgZ3JheSk7DQoJZ2xfRnJhZ0NvbG9yID12ZWM0KGZjLDEuKTsNCn0NCg"},{ name : "vhs.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgaW50ZW5zaXR5Ow0KdW5pZm9ybSBmbG9hdCBqaXR0ZXI7DQp1bmlmb3JtIGZsb2F0IHNpemU7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHROb2lzZTsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCnVuaWZvcm0gZmxvYXQgaG9sZFRpbWU7DQp1bmlmb3JtIGZsb2F0IGNvbG9yTm9pc2U7DQoNCmZsb2F0IHJhbmQodmVjMiBjbyl7DQogICAgcmV0dXJuIGZyYWN0KHNpbihkb3QoY28ueHkgLHZlYzIoMTIuOTg5OCw3OC4yMzMpKSkgKiA0Mzc1OC41NDUzKTsNCn0NCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJDQoJdXYueCArPSAocmFuZCh2ZWMyKHRpbWUqMC4xLCB1di55KjE5MjAuKSktMC41KSowLjAwOCpqaXR0ZXI7DQoJdXYueSArPSAocmFuZCh2ZWMyKHRpbWUpKS0wLjUpKjAuMDEqaml0dGVyOw0KCQ0KCXZlYzQgYmFzZSA9ICh2ZWM0KC0wLjUpK3ZlYzQocmFuZCh2ZWMyKHV2LnkqMTA4MC4sdGltZSkpLHJhbmQodmVjMigxMDgwLix0aW1lKzEuMCkpLHJhbmQodmVjMigxMDgwLix0aW1lKzIuMCkpLDApKSowLjEqY29sb3JOb2lzZTsNCgliYXNlICs9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgbm9pc2UgPSB0ZXh0dXJlMkQodE5vaXNlLHV2K3ZlYzIodGltZSx0aW1lKjAuMSkpLnI7DQoJDQoJaWYoKG5vaXNlKm1vZCh1di55ICsgaG9sZFRpbWUqMC4yLCAxLikgPiBzaXplKSB8fCANCgkJKG5vaXNlKm1vZCh1di55ICsgKGhvbGRUaW1lKzEuNSkqMC4yLCAxLikgPiBzaXplKSB8fA0KCQkobm9pc2UqbW9kKHV2LnkgKyAoaG9sZFRpbWUrMy4pKjAuMiwgMS4pID4gc2l6ZSkpIGJhc2UrPXZlYzQoMS4pKmludGVuc2l0eTsNCgkNCgkNCglnbF9GcmFnQ29sb3IgPSBiYXNlOw0KfQ0K"},{ name : "cga.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgYW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIHZlYzIgcmVzb2x1dGlvbjsNCg0KdW5pZm9ybSB2ZWMzIGNvbG9yc1sxNl07DQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlV2Ow0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1dik7DQoJZmxvYXQgY2xvc2VzdCA9IDk5OTk5LjsNCiAgICB2ZWMzIHNlbGVjdGVkPXZlYzMoMC4pOw0KICAgIGZvcihpbnQgaSA9IDA7IGkgPCAxNjsgaSsrKQ0KICAgIHsNCiAgICAgICAgZmxvYXQgZCA9IGRpc3RhbmNlKGNvbG9yc1tpXSwgYy5yZ2IpOw0KICAgICAgICBpZihjbG9zZXN0ID4gZCkNCiAgICAgICAgew0KICAgICAgICAgCWNsb3Nlc3QgPSBkOw0KICAgICAgICAgICAgc2VsZWN0ZWQgPSBjb2xvcnNbaV07DQogICAgICAgIH0NCiAgICB9DQoJZ2xfRnJhZ0NvbG9yID0gbWl4KGMsdmVjNChzZWxlY3RlZCwxLiksIGFtb3VudCk7DQp9DQo"},{ name : "moneyplane.frag", data : "dW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQoNCnVuaWZvcm0gZmxvYXQgc2l6ZVg7DQp1bmlmb3JtIGZsb2F0IHdhbGxYOw0KdW5pZm9ybSBmbG9hdCBzaXplWTsNCnVuaWZvcm0gZmxvYXQgd2FsbFk7DQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQp1bmlmb3JtIHNhbXBsZXIyRCBiaWxsOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSB2ZWMyIGZmdDsNCnVuaWZvcm0gZmxvYXQgc3BlZWQ7DQp1bmlmb3JtIGZsb2F0IGludGVuc2l0eTsNCg0Kdm9pZCBtYWluKCB2b2lkICkgew0KCQ0KCXZlYzIgdXYgPSB2VXY7DQoJDQoJZmxvYXQgaW50WCA9IGFicyhtb2QodXYueCwgc2l6ZVgpLXNpemVYKi41KTsNCglpbnRYLT13YWxsWDsNCglpZiAoaW50WCA8IDAuKSBpbnRYID0wLjsNCglpbnRYID0gaW50WC9zaXplWCoxLjsNCgkNCglmbG9hdCBpbnRZID0gYWJzKG1vZCh1di55K3RpbWUqc3BlZWQsIHNpemVZKS1zaXplWSouNSk7DQoJaW50WS09d2FsbFk7DQoJaWYgKGludFkgPCAwLikgaW50WSA9MC47DQoJaW50WSA9IGludFkvc2l6ZVkqMS47DQoJDQoJZmxvYXQgaW50UyA9IChtYXgoaW50WCwgaW50WSkpOw0KCS8vaW50Uyo9aW50UyppbnRTKmludFMqaW50UzsNCgl2ZWM0IGJjID0gdmVjNCh1di12ZWMyKDAuLHNwZWVkKSwwLjUrMC41KnNpbih0aW1lKSwxLjApOw0KCS8vYmMgPSB2ZWM0KDEuKTsNCglpbnRTPXNtb290aHN0ZXAoMC4sMC4yNSxpbnRTKTsNCgl2ZWM0IGMgPSBpbnRlbnNpdHkqdGV4dHVyZTJEKGJpbGwsdXYpOy8vIGJjKihtaXgoZmZ0LngsZmZ0LnksdXYueCkrMC4yMCkqaW50UzsNCgljLmE9MS47DQoJZ2xfRnJhZ0NvbG9yID0gYzsNCg0KfQ"},{ name : "SoundPlane.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSBzYW1wbGVyMkQgZmZ0TWFwOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBmbG9hdCBtb3VudGFpbnM7DQoNCnZvaWQgbWFpbigpDQp7DQoJdlV2ID0gdXY7DQoJdmVjMiBzID0gdXY7DQoJaWYocy54PjAuNSkNCgkgcy54PTEuLXMueDsNCglmbG9hdCBvZmYgPSB0ZXh0dXJlMkQoZmZ0TWFwLCBzKS5yOw0KCWZsb2F0IG9mZjEgPSB0ZXh0dXJlMkQoZmZ0TWFwLCBzK3ZlYzIoMC4sMC4wMSkpLnI7DQoJZmxvYXQgb2ZmMiA9IHRleHR1cmUyRChmZnRNYXAsIHMrdmVjMigwLiwwLjAzKSkucjsNCglvZmYgPSAob2ZmK29mZjErb2ZmMikvMy4tMC41Ow0KCXZlYzQgbXZQb3NpdGlvbiA9IG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHBvc2l0aW9uLXZlYzMoMC4sMC4sb2ZmKSptb3VudGFpbnMqdXYueSwgMS4wICk7DQoJDQoJZ2xfUG9zaXRpb24gPSBwcm9qZWN0aW9uTWF0cml4ICogbXZQb3NpdGlvbjsNCn0"},{ name : "dof.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ0KICAgIA"},{ name : "gray.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "tunnelcylinder.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSBzYW1wbGVyMkQgZmZ0TWFwOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBmbG9hdCBtb3VudGFpbnM7DQp1bmlmb3JtIGZsb2F0IGRpc3BsYWNlbWVudDsNCg0Kdm9pZCBtYWluKCkNCnsNCgl2VXYgPSB1djsNCglmbG9hdCBvZmYgPSB0ZXh0dXJlMkQoZmZ0TWFwLCB1dikuciowLjsNCgkNCglmbG9hdCBkaXN0ID0gdXYueSooMC45LWFicyh1di54LTAuNSkpOy8vIG1heCgwLiwwLjUtbGVuZ3RoKHV2LXZlYzIoMC41LDAuNSkpKTsNCgkNCgkNCglkaXN0ICo9IChzaW4odGltZSozLit1di54KjcuK3V2LnkqNS4pKjAuOCtjb3MoMS4yLXRpbWUqMy4rdXYueCoyMC4rdXYueSoyOC4pKjAuNCtjb3MoMi4rdGltZSo0Lit1di54KjgzLit1di55Kjg4LikqMC4xKSpkaXN0Ow0KCQ0KCXZlYzMgb2ZmcyA9dmVjMyggc2luKHRpbWUqMi4rdXYueSoxNS4wKSwwLjAsIGNvcyh0aW1lKjEuMyt1di55KjE1LjApICkqMy4qc2luKHRpbWUpOw0KCXZlYzQgbXZQb3NpdGlvbiA9IG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHBvc2l0aW9uK29mZnMqZGlzcGxhY2VtZW50LCAxLjAgKTsNCglpZihtb3VudGFpbnM8MC4xKQ0KCXsNCgkJbXZQb3NpdGlvbiA9IG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHBvc2l0aW9uLCAxLjAgKTsNCgl9DQoJDQoJZ2xfUG9zaXRpb24gPSBwcm9qZWN0aW9uTWF0cml4ICogbXZQb3NpdGlvbjsNCn0"},{ name : "DollarMat.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "cga.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "volumetric.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "twistedplane.frag", data : "dW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQoNCnVuaWZvcm0gZmxvYXQgc2l6ZVg7DQp1bmlmb3JtIGZsb2F0IHdhbGxYOw0KdW5pZm9ybSBmbG9hdCBzaXplWTsNCnVuaWZvcm0gZmxvYXQgd2FsbFk7DQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQp1bmlmb3JtIHNhbXBsZXIyRCBiaWxsOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSB2ZWMyIGZmdDsNCnVuaWZvcm0gZmxvYXQgc3BlZWQ7DQoNCnZvaWQgbWFpbiggdm9pZCApIHsNCgkNCgl2ZWMyIHV2ID0gdlV2Ow0KCQ0KCWZsb2F0IGludFggPSBhYnMobW9kKHV2LngsIHNpemVYKS1zaXplWCouNSk7DQoJaW50WC09d2FsbFg7DQoJaWYgKGludFggPCAwLikgaW50WCA9MC47DQoJaW50WCA9IGludFgvc2l6ZVgqMS47DQoJDQoJZmxvYXQgaW50WSA9IGFicyhtb2QodXYueSt0aW1lKnNwZWVkLCBzaXplWSktc2l6ZVkqLjUpOw0KCWludFktPXdhbGxZOw0KCWlmIChpbnRZIDwgMC4pIGludFkgPTAuOw0KCWludFkgPSBpbnRZL3NpemVZKjEuOw0KCQ0KCWZsb2F0IGludFMgPSAobWF4KGludFgsIGludFkpKTsNCgkvL2ludFMqPWludFMqaW50UyppbnRTKmludFM7DQoJdmVjNCBiYyA9IHZlYzQodXYtdmVjMigwLixzcGVlZCksMC41KzAuNSpzaW4odGltZSksMS4wKTsNCgkvL2JjID0gdmVjNCgxLik7DQoJaW50Uz1zbW9vdGhzdGVwKDAuLDAuMjUsaW50Uyk7DQoJZ2xfRnJhZ0NvbG9yID0gYmMqKG1peChmZnQueCxmZnQueSx1di54KSswLjIwKSppbnRTOw0KDQp9"},{ name : "SoundPlane.frag", data : "dW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQoNCnVuaWZvcm0gZmxvYXQgc2l6ZVg7DQp1bmlmb3JtIGZsb2F0IHdhbGxYOw0KdW5pZm9ybSBmbG9hdCBzaXplWTsNCnVuaWZvcm0gZmxvYXQgd2FsbFk7DQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQoNCnZhcnlpbmcgdmVjMiB2VXY7DQoNCnVuaWZvcm0gdmVjMiBmZnQ7DQp1bmlmb3JtIGZsb2F0IHNwZWVkOw0KDQp2b2lkIG1haW4oIHZvaWQgKSB7DQoJDQoJdmVjMiB1diA9IHZVdjsNCgkNCglmbG9hdCBpbnRYID0gYWJzKG1vZCh1di54LCBzaXplWCktc2l6ZVgqLjUpOw0KCWludFgtPXdhbGxYOw0KCWlmIChpbnRYIDwgMC4pIGludFggPTAuOw0KCWludFggPSBpbnRYL3NpemVYKjEuOw0KCQ0KCWZsb2F0IGludFkgPSBhYnMobW9kKHV2LnkrdGltZSpzcGVlZCwgc2l6ZVkpLXNpemVZKi41KTsNCglpbnRZLT13YWxsWTsNCglpZiAoaW50WSA8IDAuKSBpbnRZID0wLjsNCglpbnRZID0gaW50WS9zaXplWSoxLjsNCgkNCglmbG9hdCBpbnRTID0gKG1heChpbnRYLCBpbnRZKSk7DQoJLy9pbnRTKj1pbnRTKmludFMqaW50UyppbnRTOw0KCXZlYzQgYmMgPSB2ZWM0KHV2LXZlYzIoMC4sc3BlZWQpLDAuNSswLjUqc2luKHRpbWUpLDEuMCk7DQoJLy9iYyA9IHZlYzQoMS4pOw0KCWludFM9c21vb3Roc3RlcCgwLiwwLjI1LGludFMpOw0KCWdsX0ZyYWdDb2xvciA9IGJjKihtaXgoZmZ0LngsZmZ0LnksdXYueCkrMC4yMCkqaW50Uyo1LjsNCgkvL2dsX0ZyYWdDb2xvciA9IHRleHR1cmUyRChmZnRNYXAsIHV2KTsNCgkNCg0KfQ"},{ name : "triangle.json", data : "ew0KICAgICJtZXRhZGF0YSI6ew0KICAgICAgICAidHlwZSI6Ikdlb21ldHJ5IiwNCiAgICAgICAgInZlcnNpb24iOjMsDQogICAgICAgICJ1dnMiOjAsDQogICAgICAgICJub3JtYWxzIjoxNiwNCiAgICAgICAgImdlbmVyYXRvciI6ImlvX3RocmVlIiwNCiAgICAgICAgImZhY2VzIjoxNiwNCiAgICAgICAgInZlcnRpY2VzIjoxMg0KICAgIH0sDQogICAgIm5vcm1hbHMiOlswLjg2NjAyNSwwLC0wLjUsLTguNjAzMTllLTA4LDAsMSwzLjU0OTk5ZS0xNSwxLC01LjAxOTllLTA4LC0wLjg2NjAyNSwwLC0wLjUsNC43NTkyNGUtMDksLTEsNC4xOTU1N2UtMDgsLTYuNzY4NDFlLTA5LC0xLDMuODQ3NThlLTA4LC0xLjM1MzY4ZS0wOCwtMSw1LjAxOTllLTA4LDkuNTE4NTFlLTA5LC0xLDUuMDE5OWUtMDgsMy42NzA1MmUtMDgsLTcuNDUwNThlLTA4LC0xLC0wLjg2NjAyNSwtMi40NDcwMWUtMDcsMC41LDQuNzU5MjZlLTA5LDEsLTQuMTk1NTdlLTA4LC02Ljc2ODM4ZS0wOSwxLC0zLjg0NzU4ZS0wOCwtMS4zNTM2OGUtMDgsMSwtNS4wMTk5ZS0wOCw5LjUxODVlLTA5LDEsLTUuMDE5OWUtMDgsLTMuMDQyODVlLTE1LC0xLDUuMDE5OWUtMDgsMC44NjYwMjUsLTEuMjIzNTFlLTA3LDAuNV0sDQogICAgInV2cyI6W10sDQogICAgImZhY2VzIjpbMzMsMCwxLDMsMiwwLDAsMCwwLDMzLDIsMyw1LDQsMSwxLDEsMSwzMywzLDgsMTAsNSwyLDIsMiwyLDMzLDEsMCw0LDUsMywzLDMsMywzMiwwLDIsOSw0LDQsNCwzMiw3LDExLDQsNSw1LDUsMzIsMCw5LDcsNiw2LDYsMzIsMCw3LDQsNyw3LDcsMzMsMTEsMTAsOCw5LDgsOCw4LDgsMzMsOSw4LDYsNyw5LDksOSw5LDMyLDEsNSwxMCwxMCwxMCwxMCwzMiw2LDgsMywxMSwxMSwxMSwzMiwxLDEwLDYsMTIsMTIsMTIsMzIsNiwzLDEsMTMsMTMsMTMsMzMsNCwxMSw5LDIsMTQsMTQsMTQsMTQsMzMsNyw2LDEwLDExLDE1LDE1LDE1LDE1XSwNCiAgICAidmVydGljZXMiOlswLC0wLjEsLTEsMCwwLjA5OTk5OTksLTEsMC44NjYwMjUsLTAuMSwwLjUsMC44NjYwMjUsMC4xLDAuNSwtMC44NjYwMjUsLTAuMSwwLjUsLTAuODY2MDI1LDAuMSwwLjUsLTUuODk3NzJlLTA5LDAuMDk5OTk5OSwtMC43MDMxNTgsLTUuODk3NzJlLTA5LC0wLjEsLTAuNzAzMTU4LDAuNjA4OTUzLDAuMSwwLjM1MTU3OSwwLjYwODk1MywtMC4xLDAuMzUxNTc5LC0wLjYwODk1MywwLjEsMC4zNTE1NzksLTAuNjA4OTUzLC0wLjEsMC4zNTE1NzldDQp9"},{ name : "twistedplane.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSBzYW1wbGVyMkQgZmZ0TWFwOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBmbG9hdCBtb3VudGFpbnM7DQoNCnZvaWQgbWFpbigpDQp7DQoJdlV2ID0gdXY7DQoJDQoJZmxvYXQgZGlzdCA9ICgwLjUtIHV2LngpOw0KCWZsb2F0IGFuZ2xlID0gc2luKHRpbWUqMS4rdXYueSoxLjArY29zKHRpbWUqMS44K3V2LnkpKjAuNSkqNS41ICsgdXYueSo2LjsNCgkNCgl2ZWMzIG9mZnMgPXZlYzMoDQoJCXNpbihhbmdsZSkqZGlzdCo3MC4sDQoJCTAuLA0KCQljb3MoYW5nbGUpKmRpc3QqNzAuDQoJKTsNCglmbG9hdCBtcCA9IHV2LnkgPCAwLjEgPyBzbW9vdGhzdGVwKDAuLCAwLjEsIHV2LnkpIDogMS4tc21vb3Roc3RlcCgwLjksIDEuLCB1di55KTsNCgl2ZWM0IG12UG9zaXRpb24gPSBtb2RlbFZpZXdNYXRyaXggKiB2ZWM0KCBvZmZzKm1wK3ZlYzMoMC4scG9zaXRpb24ueSwwLiksIDEuMCApOw0KCQ0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG12UG9zaXRpb247DQp9"},{ name : "CarMat.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnZhcnlpbmcgdmVjNCBwOw0KdmFyeWluZyB2ZWMzIGxwOw0KDQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQp1bmlmb3JtIGZsb2F0IHRpbWU7DQp1bmlmb3JtIGZsb2F0IG1vdW50YWluczsNCg0Kdm9pZCBtYWluKCkNCnsNCgl2VXYgPSB1djsNCglmbG9hdCBvZmYgPSB0ZXh0dXJlMkQoZmZ0TWFwLCB1dikuciowLjsNCgkNCglmbG9hdCBkaXN0ID0gc21vb3Roc3RlcCgwLiwxLix1di55KSooc21vb3Roc3RlcCgwLiwwLjUsYWJzKHV2LngtMC41KS0wLjAyNSkpKjAuNTsNCglkaXN0ID0gbWluKDAuMjUsIGRpc3QpOw0KCWRpc3QgKz0gc2luKHRpbWUqMy4rdXYueCoxNy4rdXYueSoxMi4pKmRpc3QrIHNpbih0aW1lKjIuK3V2LngqNjAuK3V2LnkqMjMuKSAqIGRpc3QqMC4yKyBjb3ModGltZSoxLjIrdXYueCo0MC4rdXYueSozMy4pICogZGlzdCowLjE7DQoJLy9kaXN0ICo9IChzaW4odGltZSozLit1di54KjcuK3V2LnkqNS4pKjAuOCtjb3MoMS4yLXRpbWUqMy4rdXYueCoyMC4rdXYueSoyOC4pKjAuNCtjb3MoMi4rdGltZSo0Lit1di54KjgzLit1di55Kjg4LikqMC4xKSpkaXN0Ow0KCWxwID0gcG9zaXRpb247DQoJdmVjNCBtdlBvc2l0aW9uID0gbW9kZWxWaWV3TWF0cml4ICogdmVjNCggcG9zaXRpb24rdmVjMygwLiwwLixvZmYqZGlzdCttYXgoMC4sZGlzdCo0MC4pKSptb3VudGFpbnMsIDEuMCApOw0KCQ0KCXZlYzQgZnAgPSBwcm9qZWN0aW9uTWF0cml4ICogbXZQb3NpdGlvbjsNCglwID0gZnA7DQoJZ2xfUG9zaXRpb24gPSBmcDsNCn0"},{ name : "displacement.frag", data : "dW5pZm9ybSBmbG9hdCBzY2FsZVg7DQp1bmlmb3JtIGZsb2F0IHNjYWxlWTsNCnVuaWZvcm0gZmxvYXQgem9vbTsNCnVuaWZvcm0gdmVjMiBvZmZzZXQ7DQp1bmlmb3JtIHNhbXBsZXIyRCB0RGlmZnVzZTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaXNwTWFwOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjZCA9IHRleHR1cmUyRCh0RGlzcE1hcCwodXYrb2Zmc2V0KSp6b29tKTsNCgkNCgkvL2NhbGN1bGF0ZSBvZmZzZXQNCgl2ZWMyIG9mZnNldCA9dmVjMiggY2QuciAqIHNjYWxlWCwgY2QuZypzY2FsZVkpIC0gdmVjMihzY2FsZVgqMC41LHNjYWxlWSowLjUpOw0KCQ0KCXZlYzQgYyA9IHRleHR1cmUyRCh0RGlmZnVzZSx1ditvZmZzZXQpOw0KCQ0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "LinePlane.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSBzYW1wbGVyMkQgZmZ0TWFwOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBmbG9hdCBtb3VudGFpbnM7DQoNCnZvaWQgbWFpbigpDQp7DQoJdlV2ID0gdXY7DQoJZmxvYXQgb2ZmID0gdGV4dHVyZTJEKGZmdE1hcCwgdXYpLnIqMC47DQoJDQoJZmxvYXQgZGlzdCA9IHNtb290aHN0ZXAoMC4sMS4sdXYueSkqKHNtb290aHN0ZXAoMC4sMC41LGFicyh1di54LTAuNSktMC4wMjUpKSowLjU7DQoJZGlzdCA9IG1pbigwLjI1LCBkaXN0KTsNCglkaXN0ICs9IHNpbih0aW1lKjMuK3V2LngqMTcuK3V2LnkqMTIuKSpkaXN0KyBzaW4odGltZSoyLit1di54KjYwLit1di55KjIzLikgKiBkaXN0KjAuMisgY29zKHRpbWUqMS4yK3V2LngqNDAuK3V2LnkqMzMuKSAqIGRpc3QqMC4xOw0KCS8vZGlzdCAqPSAoc2luKHRpbWUqMy4rdXYueCo3Lit1di55KjUuKSowLjgrY29zKDEuMi10aW1lKjMuK3V2LngqMjAuK3V2LnkqMjguKSowLjQrY29zKDIuK3RpbWUqNC4rdXYueCo4My4rdXYueSo4OC4pKjAuMSkqZGlzdDsNCgkNCgl2ZWM0IG12UG9zaXRpb24gPSBtb2RlbFZpZXdNYXRyaXggKiB2ZWM0KCBwb3NpdGlvbit2ZWMzKDAuLDAuLG9mZipkaXN0K21heCgwLixkaXN0KjQwLikpKm1vdW50YWlucywgMS4wICk7DQoJDQoJZ2xfUG9zaXRpb24gPSBwcm9qZWN0aW9uTWF0cml4ICogbXZQb3NpdGlvbjsNCn0"},{ name : "leatherShader.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gc2FtcGxlcjJEIHRkaWZmOw0KDQoNCnZvaWQgbWFpbigpIHsNCgl2ZWMyIHV2ID0gdlV2Ow0KCXV2LnggPSBtb2QodXYueCozLiwxLik7DQoJdXYueSA9IG1vZCh1di55KjMuLDEuKTsNCgl2ZWM0IGMgPSB0ZXh0dXJlMkQodGRpZmYsdXYpOw0KCQ0KCWdsX0ZyYWdDb2xvciA9IGM7DQoJDQp9DQo"},{ name : "CarMat.frag", data : "dW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQoNCnVuaWZvcm0gZmxvYXQgc2l6ZVg7DQp1bmlmb3JtIGZsb2F0IHdhbGxYOw0KdW5pZm9ybSBmbG9hdCBzaXplWTsNCnVuaWZvcm0gZmxvYXQgd2FsbFk7DQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQoNCnZhcnlpbmcgdmVjMiB2VXY7DQp2YXJ5aW5nIHZlYzQgcDsNCnZhcnlpbmcgdmVjMyBscDsNCg0KdW5pZm9ybSB2ZWMyIGZmdDsNCnVuaWZvcm0gZmxvYXQgc3BlZWQ7DQoNCnZvaWQgbWFpbiggdm9pZCApIHsNCgkNCgl2ZWMyIHV2ID0gdlV2Ow0KCXZlYzQgZiA9IHRleHR1cmUyRChmZnRNYXAsIHV2KTsNCgkNCglmbG9hdCBtcCA9IHNpbihzaW4obHAueSozLikrY29zKGxwLngqMy4pK2NvcyhscC56KjMuKSt0aW1lKTsNCgkNCgl2ZWMzIGMgPSB2ZWMzKDEuLDAuNiwwLjYpKnNtb290aHN0ZXAoMC45LDEuLG1wKTsNCglnbF9GcmFnQ29sb3IgPXZlYzQoYywxLik7DQoNCn0"},{ name : "colorhilight.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "pixelate.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gdmVjMiBwaXhlbGFtb3VudDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgl1di54ID0gZmxvb3IodXYueCpwaXhlbGFtb3VudC54KS9waXhlbGFtb3VudC54Ow0KCXV2LnkgPSBmbG9vcih1di55KnBpeGVsYW1vdW50LnkpL3BpeGVsYW1vdW50Lnk7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ0K"},{ name : "aspect.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gaW50IHR5cGU7DQp1bmlmb3JtIGZsb2F0IGFzcGVjdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQp1bmlmb3JtIHZlYzQgY29sb3I7DQoNCnZvaWQgbWFpbigpIHsNCglmbG9hdCBtcCA9IDAuMDsNCglmbG9hdCByZXNBc3BlY3QgPSByZXNvbHV0aW9uLngvcmVzb2x1dGlvbi55Ow0KCXZlYzIgdXYgPSB2VXY7DQoJCQ0KCS8vQmxhY2sgbGluZXMgbGVmdCBhbmQgcmlnaHQNCglpZihyZXNBc3BlY3QgPiBhc3BlY3QpDQoJew0KCQlmbG9hdCBkaWYgPSByZXNBc3BlY3QtYXNwZWN0Ow0KCQltcCA9IHV2LnggPiBkaWYvMi4gJiYgdXYueCA8IDEuLWRpZi8yLiA/IDAuIDogMS47DQoJfQ0KCWVsc2UNCgl7DQoJCS8vQmxhY2sgaW5lcyB0b3AgJiBib3R0b20NCgkJZmxvYXQgZGlmID0gYXNwZWN0LXJlc0FzcGVjdDsNCgkJbXAgPSB1di55ID4gZGlmLzIuICYmIHV2LnkgPCAxLi1kaWYvMi4gPyAwLiA6IDEuOw0KCQkNCgl9DQoJDQoJLy9UT0RPIC0gaW4gZmlsbCBjaGFuZ2UgdXYgYWxzby4gDQoJdmVjNCBjID0gbWl4KHRleHR1cmUyRCh0RGlmZnVzZSx1diksIGNvbG9yLG1wKTsNCg0KCWdsX0ZyYWdDb2xvciA9IGM7DQp9DQo"},{ name : "halfSpawner.json", data : "ew0KICAgICJ1dnMiOltdLA0KICAgICJtZXRhZGF0YSI6ew0KICAgICAgICAidHlwZSI6Ikdlb21ldHJ5IiwNCiAgICAgICAgImdlbmVyYXRvciI6ImlvX3RocmVlIiwNCiAgICAgICAgInV2cyI6MCwNCiAgICAgICAgIm5vcm1hbHMiOjE4LA0KICAgICAgICAidmVyc2lvbiI6MywNCiAgICAgICAgInZlcnRpY2VzIjoxNiwNCiAgICAgICAgImZhY2VzIjoxOA0KICAgIH0sDQogICAgIm5vcm1hbHMiOlswLC0xLDAsLTAsMSwwLDEuODczMDdlLTA3LDQuNDExOTJlLTA4LDEsOC45ODE0MWUtMDgsNS4xMTM4NmUtMDgsMSwyLjAyNjI0ZS0wNyw0LjI4NDA5ZS0wOCwxLDcuMDc4MDVlLTA4LDEuNzQ2ODRlLTA3LDEsMSwyLjE0Mjk0ZS0wNyw4LjQ4ODc1ZS0wNiw3LjA2ODY4ZS0xNCwxLDkuOTg2NzZlLTA3LDguMTA5MTVlLTA4LC01LjQ3ODk0ZS0wOSwxLC0xLC0xLjkzNzE1ZS0wNywtMS40OTgwMWUtMDYsLTEuODczMDdlLTA3LC00LjQxMTkyZS0wOCwtMSwtNy4wNzgwNWUtMDgsLTUuMTEzODRlLTA4LC0xLDkuMzk3NDRlLTA5LC02LjA1MzZlLTA4LC0xLC01Ljk4NzZlLTA4LDguNzM3NmUtMDksLTEsLTAsLTEsMCwtNi40ODczMmUtMDgsMS4xMDc1MWUtMDcsLTEsLTEsMS42MzY0M2UtMDcsLTMuNDk1MzZlLTA2LC0xLDEuNjM2NDNlLTA3LC03LjQ5MDA3ZS0wNl0sDQogICAgImZhY2VzIjpbMzMsMCwxMiwxNCwxLDAsMCwwLDAsMzMsMiwzLDExLDksMSwxLDEsMSwzMiw1LDAsMiwyLDIsMiwzMiwyLDksOCwzLDMsMywzMiw3LDUsMiw0LDQsNCwzMiwyLDgsNyw1LDUsNSwzMywyLDAsMSwzLDYsNiw2LDYsMzMsNSw0LDE1LDEzLDcsNyw3LDcsMzMsMTIsMCw1LDEzLDgsOCw4LDgsMzMsNyw2LDQsNSw5LDksOSw5LDMyLDMsMSw0LDEwLDEwLDEwLDMyLDYsMTAsMTEsMTEsMTEsMTEsMzIsMyw0LDYsMTIsMTIsMTIsMzIsNiwxMSwzLDEzLDEzLDEzLDMzLDgsMTAsNiw3LDE0LDE0LDE0LDE0LDMzLDE0LDE1LDQsMSwxNSwxNSwxNSwxNSwzMywxMywxNSwxNCwxMiwxNiwxNiwxNiwxNiwzMyw5LDExLDEwLDgsMTcsMTcsMTcsMTddLA0KICAgICJ2ZXJ0aWNlcyI6WzAuNjM2NTg4LC0xLjE4MjEyLDAuMDI5ODQxOCwwLjYzNjU4OSwtMS4xODIxMiwtMC4wMjk4NDE4LDAuNjM2NTg4LDEuMTgyMTIsMC4wMjk4NDE3LDAuNjM2NTg4LDEuMTgyMTIsLTAuMDI5ODQxOSwwLjQ1NDQ3MSwtMSwtMC4wMjk4NDE4LDAuNDU0NDcxLC0xLDAuMDI5ODQxOSwwLjQ1NDQ3LDEsLTAuMDI5ODQxOSwwLjQ1NDQ3LDEsMC4wMjk4NDE4LC0wLjU0NTUzLDEsMC4wMjk4NDE4LC0wLjU0NTUzLDEuMTgyMTIsMC4wMjk4NDE4LC0wLjU0NTUzLDEsLTAuMDI5ODQxOSwtMC41NDU1MjksMS4xODIxMiwtMC4wMjk4NDE5LC0wLjU0NTUyOSwtMS4xODIxMiwwLjAyOTg0MTksLTAuNTQ1NTI5LC0xLDAuMDI5ODQxOSwtMC41NDU1MjksLTEuMTgyMTIsLTAuMDI5ODQxOCwtMC41NDU1MjksLTEsLTAuMDI5ODQxN10NCn0"},{ name : "RoundPlane.frag", data : "dW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQoNCnVuaWZvcm0gZmxvYXQgc2l6ZVg7DQp1bmlmb3JtIGZsb2F0IHdhbGxYOw0KdW5pZm9ybSBmbG9hdCBzaXplWTsNCnVuaWZvcm0gZmxvYXQgd2FsbFk7DQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQoNCnZhcnlpbmcgdmVjMiB2VXY7DQoNCnVuaWZvcm0gdmVjMiBmZnQ7DQp1bmlmb3JtIGZsb2F0IHNwZWVkOw0KDQp2b2lkIG1haW4oIHZvaWQgKSB7DQoJDQoJdmVjMiB1diA9IHZVdjsNCgkNCglmbG9hdCBpbnRYID0gYWJzKG1vZCh1di54LCBzaXplWCktc2l6ZVgqLjUpOw0KCWludFgtPXdhbGxYOw0KCWlmIChpbnRYIDwgMC4pIGludFggPTAuOw0KCWludFggPSBpbnRYL3NpemVYKjEuOw0KCQ0KCWZsb2F0IGludFkgPSBhYnMobW9kKHV2LnkrdGltZSpzcGVlZCwgc2l6ZVkpLXNpemVZKi41KTsNCglpbnRZLT13YWxsWTsNCglpZiAoaW50WSA8IDAuKSBpbnRZID0wLjsNCglpbnRZID0gaW50WS9zaXplWSoxLjsNCgkNCglmbG9hdCBpbnRSID0gYWJzKDAuNC1sZW5ndGgodXYtdmVjMigwLjUpKSkgPCAwLjAxID8gMS4gOiAwLjsNCgkNCglmbG9hdCBpbnRTID0gKG1heChpbnRYLCBpbnRZKSkqKGxlbmd0aCh1di12ZWMyKDAuNSkpPDAuND8xLjowLik7DQoJaW50Uz1tYXgoaW50UixpbnRTKTsNCgkNCgkvL2ludFMqPWludFMqaW50UyppbnRTKmludFM7DQoJdmVjNCBiYyA9IHZlYzQodXYtdmVjMigwLixzcGVlZCksMC41KzAuNSpzaW4odGltZSksMS4wKTsNCgkvL2JjID0gdmVjNCgxLik7DQoJaW50Uz1zbW9vdGhzdGVwKDAuLDAuMjUsaW50Uyk7DQoJdmVjNCBvYyA9IGJjKihtaXgoZmZ0LngsZmZ0LnksdXYueCkrMC4yMCkqaW50UytpbnRSOw0KCW9jLmEgPSAobGVuZ3RoKHV2LXZlYzIoMC41KSk8MC40PzEuOjAuKTsNCglnbF9GcmFnQ29sb3IgPSBvYzsNCg0KfQ"},{ name : "pixelate.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "standard.frag", data : "dW5pZm9ybSBmbG9hdCBicmlnaHRuZXNzOw0KdW5pZm9ybSBmbG9hdCBnYW1tYTsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KdmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzIgdXYgPSB2VXY7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHV2KTsNCgljID0gcG93KGMsIHZlYzQoMS4wL2dhbW1hKSk7DQoJYys9YnJpZ2h0bmVzczsNCglnbF9GcmFnQ29sb3IgPSBjOw0KfQ"},{ name : "leatherShader.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "rgbshift.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgcnNoaWZ0Ow0KdW5pZm9ybSBmbG9hdCBnc2hpZnQ7DQp1bmlmb3JtIGZsb2F0IGJzaGlmdDsNCnVuaWZvcm0gc2FtcGxlcjJEIHREaWZmdXNlOw0KDQp2b2lkIG1haW4oKSB7DQoJdmVjNCBjID0gdGV4dHVyZTJEKHREaWZmdXNlLHZVdik7DQoJZmxvYXQgcm8gPSB0ZXh0dXJlMkQodERpZmZ1c2UsdmVjMih2VXYueC1yc2hpZnQsIHZVdi55KSkucjsNCglmbG9hdCBnbyA9IHRleHR1cmUyRCh0RGlmZnVzZSx2ZWMyKHZVdi54LWdzaGlmdCwgdlV2LnkpKS5nOw0KCWZsb2F0IGJvID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodlV2LngtYnNoaWZ0LCB2VXYueSkpLmI7DQoJZ2xfRnJhZ0NvbG9yID0gdmVjNChybywgZ28sIGJvLCBjLncpOw0KfQ"},{ name : "tunnelcylinder.frag", data : "dW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQoNCnVuaWZvcm0gZmxvYXQgc2l6ZVg7DQp1bmlmb3JtIGZsb2F0IHdhbGxYOw0KdW5pZm9ybSBmbG9hdCBzaXplWTsNCnVuaWZvcm0gZmxvYXQgd2FsbFk7DQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQoNCnZhcnlpbmcgdmVjMiB2VXY7DQoNCnVuaWZvcm0gdmVjMiBmZnQ7DQp1bmlmb3JtIGZsb2F0IHNwZWVkOw0KdW5pZm9ybSBmbG9hdCBhbmdsZTsNCnZvaWQgbWFpbiggdm9pZCApIHsNCgkNCgl2ZWMyIHV2ID0gdlV2Ow0KCXV2LnggKz0oc2luKHV2LnkqMzgzLjQrMzAuKnV2LngrMC4xKnRpbWUpKjAuMDMpICogYW5nbGU7DQoJZmxvYXQgaW50WCA9IGFicyhtb2QodXYueCwgc2l6ZVgpLXNpemVYKi41KTsNCglpbnRYLT13YWxsWDsNCglpZiAoaW50WCA8IDAuKSBpbnRYID0wLjsNCglpbnRYID0gaW50WC9zaXplWCoxLjsNCgkNCglmbG9hdCBpbnRZID0gYWJzKG1vZCh1di55K3RpbWUqc3BlZWQsIHNpemVZKS1zaXplWSouNSk7DQoJaW50WS09d2FsbFk7DQoJaWYgKGludFkgPCAwLikgaW50WSA9MC47DQoJaW50WSA9IGludFkvc2l6ZVkqMS47DQoJDQoJZmxvYXQgaW50UyA9IChtYXgoaW50WCwgaW50WSkpOw0KCS8vaW50Uyo9aW50UyppbnRTKmludFMqaW50UzsNCgl2ZWM0IGJjID0gdmVjNChzaW4odXYqMy4xNCkqMC4zLXZlYzIoMC4sc3BlZWQpLDAuNSswLjUqc2luKHRpbWUpLDEuMCk7DQoJLy9iYyA9IHZlYzQoMS4pOw0KCWludFM9c21vb3Roc3RlcCgwLiwwLjI1LGludFMpOw0KCQ0KCWdsX0ZyYWdDb2xvciA9IGJjKihtaXgoZmZ0LngsZmZ0LnksdXYueCkrMC4yMCkqaW50UzsNCg0KfQ"},{ name : "dof.frag", data : "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"},{ name : "colorEdgeShader.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "distortedTv.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "additiveblending.frag", data : "dW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIHNhbXBsZXIyRCB0QWRkOw0KdmFyeWluZyB2ZWMyIHZVdjsNCnZvaWQgbWFpbigpIHsNCgl2ZWM0IGNvbG9yID0gdGV4dHVyZTJEKCB0RGlmZnVzZSwgdlV2ICk7DQogICAgdmVjNCBhZGQgPSB0ZXh0dXJlMkQoIHRBZGQsIHZVdiApOw0KICAgIGdsX0ZyYWdDb2xvciA9IGNvbG9yICsgYWRkOw0KfQ0K"},{ name : "colorEdgeShader.frag", data : "dmFyeWluZyB2ZWMyIHZVdjsNCnVuaWZvcm0gZmxvYXQgdGltZTsNCg0KZmxvYXQgcmFuZCh2ZWMyIGNvKXsNCiAgICByZXR1cm4gZnJhY3Qoc2luKGRvdChjby54eSAsdmVjMigxMi45ODk4LDc4LjIzMykpKSAqIDQzNzU4LjU0NTMpOw0KfQ0KDQp2b2lkIG1haW4oKSB7DQoJdmVjMiB1diA9IHZVdjsNCgkNCgl2ZWM0IGNvbG9yID0gdmVjNCgwLjUsMC4yNSwxLjksMC4pKjQuOw0KICAgIGNvbG9yICo9ICgxLi1zbW9vdGhzdGVwKDAuLCAwLjAyLCB1di54KSkrKDEuLXNtb290aHN0ZXAoMC4sIDAuMDIsIHV2LnkpKStzbW9vdGhzdGVwKDAuOTgsIDEuMCwgdXYueCkrc21vb3Roc3RlcCgwLjk4LCAxLjAsIHV2LnkpOw0KCQ0KCXZlYzQgYmFzZSA9dmVjNCggbW9kKHV2LngqMzAuLCAwLjI1KSAtIG1vZCh1di55KjIwLiwwLjEpKTsNCiAgICBiYXNlKj0wLjA0Ow0KICAgIHV2LngrPTAuMDI1Ow0KCXV2LnkrPTAuMDI1Ow0KICAgIGZsb2F0IHdpbmRvd3ggPSBtb2QodXYueCo4MC4sNC4pOw0KICAgIGZsb2F0IHdpbmRvd3kgPSBtb2QodXYueSo4MC4sNS4pOw0KICAgIA0KICAgIGZsb2F0IHdpbmlkID0gZmxvb3IoKHV2LngqODAuKS80Lik7DQogICAgd2luaWQgKz0gODAuKmZsb29yKCh1di55KjgwLikvNS4pOw0KICAgIGZsb2F0IHdpbmMgPSByYW5kKHZlYzIod2luaWQpKTsNCgl3aW5jKj13aW5jOw0KICAgIHZlYzQgd2luZG93cyA9IHdpbmRvd3ggPCAxLjUgJiYgd2luZG93eSA8IDIuODUgPyB2ZWM0KDEuKSp3aW5jKihzaW4odGltZSkqc2luKHRpbWUpKy42KTogdmVjNCgwLik7DQoJDQoJaWYobW9kKHdpbmMqMTMuLDEuKSA+IDAuNSAmJiB3aW5kb3dzLnggPiAwLikNCgkJd2luZG93cyA9IHZlYzQoMC41LDAuNSwyLjAsMS4pKnJhbmQodmVjMih3aW5pZCoxNy4pKTsNCiAgICBjb2xvcio9MC47DQoJZ2xfRnJhZ0NvbG9yID0gYmFzZSt3aW5kb3dzKndpbmMrY29sb3IgKyBtaXgodmVjNCgwLjA1LDAuLDAuMDUsMS4pLHZlYzQoMC4pLHV2LnkpIDsNCgkNCn0NCg"},{ name : "standard.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "OutrunLinePlane.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0KdW5pZm9ybSBzYW1wbGVyMkQgZmZ0TWFwOw0KdW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSBmbG9hdCBtb3VudGFpbnM7DQoNCnZvaWQgbWFpbigpDQp7DQoJdlV2ID0gdXY7DQoJZmxvYXQgb2ZmID0gdGV4dHVyZTJEKGZmdE1hcCwgdXYpLnIqMC47DQoJDQoJZmxvYXQgZGlzdCA9IHV2LnkqKDAuOS1hYnModXYueC0wLjUpKTsvLyBtYXgoMC4sMC41LWxlbmd0aCh1di12ZWMyKDAuNSwwLjUpKSk7DQoJDQoJDQoJZGlzdCAqPSAoc2luKHRpbWUqMy4rdXYueCo3Lit1di55KjUuKSowLjgrY29zKDEuMi10aW1lKjMuK3V2LngqMjAuK3V2LnkqMjguKSowLjQrY29zKDIuK3RpbWUqNC4rdXYueCo4My4rdXYueSo4OC4pKjAuMSkqZGlzdDsNCgkNCgl2ZWM0IG12UG9zaXRpb24gPSBtb2RlbFZpZXdNYXRyaXggKiB2ZWM0KCBwb3NpdGlvbit2ZWMzKDAuLDAuLG9mZipkaXN0LW1pbigwLixkaXN0KjQwLikpKm1vdW50YWlucywgMS4wICk7DQoJDQoJZ2xfUG9zaXRpb24gPSBwcm9qZWN0aW9uTWF0cml4ICogbXZQb3NpdGlvbjsNCn0"},{ name : "bgQuad.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "OutrunLinePlane.frag", data : "dW5pZm9ybSBmbG9hdCB0aW1lOw0KdW5pZm9ybSB2ZWMyIHJlc29sdXRpb247DQoNCnVuaWZvcm0gZmxvYXQgc2l6ZVg7DQp1bmlmb3JtIGZsb2F0IHdhbGxYOw0KdW5pZm9ybSBmbG9hdCBzaXplWTsNCnVuaWZvcm0gZmxvYXQgd2FsbFk7DQp1bmlmb3JtIHNhbXBsZXIyRCBmZnRNYXA7DQoNCnZhcnlpbmcgdmVjMiB2VXY7DQoNCnVuaWZvcm0gdmVjMiBmZnQ7DQp1bmlmb3JtIGZsb2F0IHNwZWVkOw0KDQoNCnZvaWQgbWFpbiggdm9pZCApIHsNCgkNCgl2ZWMyIHV2ID0gdlV2Ow0KCQ0KCWZsb2F0IGludFggPSBhYnMobW9kKHV2LngsIHNpemVYKS1zaXplWCouNSk7DQoJaW50WC09d2FsbFg7DQoJaWYgKGludFggPCAwLikgaW50WCA9MC47DQoJaW50WCA9IGludFgvc2l6ZVgqMS47DQoJDQoJZmxvYXQgaW50WSA9IGFicyhtb2QodXYueSt0aW1lKnNwZWVkLCBzaXplWSktc2l6ZVkqLjUpOw0KCWludFktPXdhbGxZOw0KCWlmIChpbnRZIDwgMC4pIGludFkgPTAuOw0KCWludFkgPSBpbnRZL3NpemVZKjEuOw0KCQ0KCWZsb2F0IGludFMgPSAobWF4KGludFgsIGludFkpKTsNCgkvL2ludFMqPWludFMqaW50UyppbnRTKmludFM7DQoJdmVjNCBiYyA9IHZlYzQodXYtdmVjMigwLixzcGVlZCksMC41KzAuNSpzaW4odGltZSksMC4wKTsNCgkvL2JjID0gdmVjNCgxLik7DQoJaW50Uz1zbW9vdGhzdGVwKDAuLDAuMjUsaW50Uyk7DQoJDQoJdmVjNCBjb2xvciA9IGJjKihtaXgoZmZ0LngsZmZ0LnksdXYueCkrMC4yMCkqaW50UzsNCgkNCglmbG9hdCBhdmVyYWdlID0gKGNvbG9yLnIrY29sb3IuZytjb2xvci5iKS8zLjsNCgl2ZWM0IGF2cmcgPSB2ZWM0KGF2ZXJhZ2UsIGF2ZXJhZ2UsIGF2ZXJhZ2UsIDEuMCk7DQoJDQoJZ2xfRnJhZ0NvbG9yID0gYXZyZyp2ZWM0KDAuNSwwLjUsMS4wLDEuMCk7DQp9"},{ name : "distortedTv.frag", data : "dW5pZm9ybSBmbG9hdCBkaXN0b3J0QW1vdW50Ow0KdW5pZm9ybSBzYW1wbGVyMkQgdERpZmZ1c2U7DQp1bmlmb3JtIGZsb2F0IHRpbWU7DQp1bmlmb3JtIGZsb2F0IGdyZWVuYW1wbGlmeTsNCnVuaWZvcm0gZmxvYXQgYmx1ZWFtcGxpZnk7DQp1bmlmb3JtIGZsb2F0IHZpZ25BbW91bnQ7DQp1bmlmb3JtIGZsb2F0IG9mZnNldEFtb3VudDsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TXVsdGlwbGllcjsNCnVuaWZvcm0gZmxvYXQgYnJpZ2h0TGltaXQ7DQp2YXJ5aW5nIHZlYzIgdlV2Ow0KDQp2b2lkIG1haW4oKQ0Kew0KCXZlYzIgdXYgPSB2VXY7DQogICAgZmxvYXQgb2Zmc2V0ID0gbW9kKGNlaWwodXYueSpkaXN0b3J0QW1vdW50K3RpbWUpKnRpbWUsMC4wMTIpOw0KICAgIHZlYzQgdENvbG9yID0gdGV4dHVyZTJEKHREaWZmdXNlLHZlYzIodXYueCtvZmZzZXRBbW91bnQqb2Zmc2V0LHV2LnkpKTsNCiAgICB0Q29sb3IuZyAqPSBncmVlbmFtcGxpZnk7DQogICAgdENvbG9yLmIgKj0gYmx1ZWFtcGxpZnk7DQogICAgZmxvYXQgdmlnbiA9IDEuMC1sZW5ndGgodmVjMigwLjUsMC41KS11dikqdmlnbkFtb3VudDsNCiAgICANCgl2ZWMzIGJyaWdodG5lc3MgPSB0Q29sb3IucmdiOw0KCXZlYzMgbXAgPSB2ZWMzKDEuKS1zbW9vdGhzdGVwKHZlYzMoYnJpZ2h0TGltaXQpLCB2ZWMzKDEuKSwgYnJpZ2h0bmVzcykqYnJpZ2h0TXVsdGlwbGllcjsNCgl0Q29sb3IqPXZlYzQobXAsMS4pOw0KCQ0KICAgIHRDb2xvciAqPSB2aWduOw0KCWdsX0ZyYWdDb2xvciA9IHRDb2xvcjsNCn0"},{ name : "displacement.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "vhs.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"},{ name : "additiveblending.vert", data : "dmFyeWluZyB2ZWMyIHZVdjsNCg0Kdm9pZCBtYWluKCkgew0KCXZlYzMgcCA9IHBvc2l0aW9uOw0KCXZVdiA9IHV2Ow0KCWdsX1Bvc2l0aW9uID0gcHJvamVjdGlvbk1hdHJpeCAqIG1vZGVsVmlld01hdHJpeCAqIHZlYzQoIHAsIDEuMCApOw0KfQ"}];
var __map_reserved = {}
var ArrayBuffer = $global.ArrayBuffer || js_html_compat_ArrayBuffer;
if(ArrayBuffer.prototype.slice == null) {
	ArrayBuffer.prototype.slice = js_html_compat_ArrayBuffer.sliceImpl;
}
var Float32Array = $global.Float32Array || js_html_compat_Float32Array._new;
var Uint8Array = $global.Uint8Array || js_html_compat_Uint8Array._new;
DemoMain.DEMO_READY = new wl_core_Signal();
DemoMain.HILIGHT = new THREE.Color(15219237);
DemoMain.LIGHT = new THREE.Color(16771491);
DemoMain.GREEN = new THREE.Color(2503240);
DemoMain.BLUE = new THREE.Color(17763);
DemoMain.BLUE_DARK = new THREE.Color(1645352);
DemoMain.WHITE = new THREE.Color(16777215);
DemoMain.BLACK = new THREE.Color(0);
DemoMain.historyind = 0;
wl_core_TimeSig.ABSOLUTE = "absolute";
wl_core_TimeSig.RELATIVE = "relative";
wl_core_TimeSig.PATTERN = "pattern";
wl_sounds_SoundWL.FFT_PRECISION = 1024;
wl_sounds_SoundWL.onSoundLoaded = new wl_core_Signal();
wl_sounds_SoundWL.onSoundComplete = new wl_core_Signal();
wl_sounds_SoundWL.onSoundReady = new wl_core_Signal();
wl_sounds_SoundWL.time = new wl_core_TimeSig();
wl_sounds_SoundWL.volume = 1;
wl_sounds_SoundWL.startTime = 0;
wl_sounds_SoundWL.loaded = false;
wl_sounds_SoundWL.lastFFT = 0;
wl_sounds_SoundWL.FFT = { dbLeft : null, frequencyLeft : null, waveformLeft : null, dbRight : null, frequencyRight : null, waveformRight : null, fftsize : 1024, sampleRate : 44100};
dollarmat_DollarMat.analyzer = new wl_sounds_SoundAnalyzer();
dollarmat_DollarMat.filter = { isolate : true, lowLimit : 600, highLimit : 1300};
generic_Money.geometry = new THREE.PlaneGeometry(10,4.1438356164383565,50,50);
haxe_crypto_Base64.CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
haxe_crypto_Base64.BYTES = haxe_io_Bytes.ofString(haxe_crypto_Base64.CHARS);
haxe_ds_ObjectMap.count = 0;
js_Boot.__toStr = { }.toString;
js_html_compat_Float32Array.BYTES_PER_ELEMENT = 4;
js_html_compat_Uint8Array.BYTES_PER_ELEMENT = 1;
wl_core_Assets._assets = new haxe_ds_StringMap();
wl_core_Config.BEATS_PER_MINUTE = 104;
wl_core_Config.BEATS_PER_BAR = 4;
wl_core_Config.TICKS_PER_BEAT = 12;
wl_core_Config.MUSIC_BEGIN = 500;
wl_core_Config.SONG_PATH = "bg.ogg";
wl_core_Config.ENABLE_FFT = false;
wl_core_Config.MUTED = false;
wl_core_Config.FPS = 24;
wl_core_Config.RESOLUTION = [1280,720];
wl_core_Config.RATIO = 1.7777777777777777;
wl_core_Config.ANTIALIAS = true;
wl_core_Config.ENABLE_SHADOWS = false;
wl_core_Config.CLEAR_COLOR = 0;
wl_core_Config.SHADOW_MAP_SIZE = [512,512];
wl_core_Config.SEED = 123;
wl_core_Config.DEBUG = false;
wl_core_Config.TIMELINE = [];
wl_debug_Debug.paused = false;
wl_debug_Debug.usedFolderNames = [];
wl_debug_ManualControl.parts = [];
wl_debug_ManualControl.storedPoints = [];
wl_debug_ManualControl.fpsControls = [];
wl_demo_CameraController.STOPPED = false;
wl_demo_CameraController.STATIC = "static";
wl_demo_CameraController.LINEAR = "linear";
wl_demo_CameraController.BEZIER = "bezier";
wl_demo_CameraController.FOLLOW = "follow";
wl_post_aspect_Aspect.CROP = 0;
wl_post_aspect_Aspect.FILL = 1;
wl_post_bloom_Bloom.BlurDirectionX = new THREE.Vector2(1.0,0.0);
wl_post_bloom_Bloom.BlurDirectionY = new THREE.Vector2(0.0,1.0);
wl_util_LoadManager._totalCount = 0;
wl_util_LoadManager.loadingManager = new THREE.LoadingManager(wl_util_LoadManager.onload,wl_util_LoadManager.onprogress,wl_util_LoadManager.onerror);
wl_util_LoadManager.loadersWaiting = [];
wl_util_LoadManager.managerDone = false;
wl_util_Random.instance = new wl_util_Random(123);
Main.main();
})(typeof exports != "undefined" ? exports : typeof window != "undefined" ? window : typeof self != "undefined" ? self : this, typeof window != "undefined" ? window : typeof global != "undefined" ? global : typeof self != "undefined" ? self : this);
