//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID69e2f46c_0599_4ac2_a3f0_a3edca0e6ebd
{
    public class Class_Locator : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Input = 0
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            Output = 0,
            PositionX = 1,
            PositionY = 2,
            PositionZ = 3
        }
        //<<< _outputids

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Input = inputs[(int)InputId.Input];
            //<<< _params
           
            switch (outputIdx)
            {
                case (int)OutputId.Output:
                {
                    context.ObjectTWorld.Decompose(out _scale, out _rotation, out _position);
                    Input.Eval(context);

                    //because these outputs are dependent on this evaluation, we need to invalidate them here
                    OperatorPart.EmitChangedEventForOutput((int)OutputId.PositionX);
                    OperatorPart.EmitChangedEventForOutput((int)OutputId.PositionY);
                    OperatorPart.EmitChangedEventForOutput((int)OutputId.PositionZ);
                    break;
                }
                case (int)OutputId.PositionX: context.Value = _position.X; break;
                case (int)OutputId.PositionY: context.Value = _position.Y; break;
                case (int)OutputId.PositionZ: context.Value = _position.Z; break;
            }

            return context;
        }

        Vector3 _scale;
        Quaternion _rotation;
        Vector3 _position;
    }
}

