/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class pure
extends PApplet {
    int[] palette = new int[]{-9520708, -81525, -357752, -7221863, -8929646};
    int IMAGES = 19;
    PImage[] images = new PImage[this.IMAGES];
    PImage vignette;
    int FPS = 60;
    String tune = "ko0x_-_guiding_lights.mp3";
    float BPM = 173.0f;
    Moonlander _moon;
    float BPS = 60.0f / this.BPM;
    int LAST_ROW = 224;
    float tickTime = 0.0f;
    PGraphics back;
    PGraphics l1;
    PGraphics l2;
    PGraphics l3;
    int offset = 0;
    int previousOffset = 0;
    int refreshX = 0;
    int refreshY = 0;

    public void setup() {
        this.frameRate(this.FPS);
        this.back = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.l1 = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.l2 = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.l3 = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this._moon = Moonlander.initWithSoundtrack((PApplet)this, (String)this.tune, (int)PApplet.parseInt((float)this.BPM), (int)8);
        this.hint(-6);
        this.hint(-2);
        int i = 0;
        while (i < this.IMAGES) {
            String imageName = String.valueOf(i) + ".png";
            this.images[i] = this.loadImage(imageName);
            ++i;
        }
        this.vignette = this.loadImage("vignette.png");
        this._moon.start();
    }

    public void draw() {
        this._moon.update();
        float eyeX = (float)this._moon.getValue("eyeX");
        float eyeY = (float)this._moon.getValue("eyeY");
        float eyeZ = (float)this._moon.getValue("eyeZ");
        float centerX = (float)this._moon.getValue("centerX");
        float centerY = (float)this._moon.getValue("centerY");
        float centerZ = (float)this._moon.getValue("centerZ");
        float upX = (float)this._moon.getValue("upX");
        float upY = (float)this._moon.getValue("upY");
        float upZ = (float)this._moon.getValue("upZ");
        float FOV1 = (float)this._moon.getValue("FOV1");
        float FOV2 = (float)this._moon.getValue("FOV2");
        float FOV3 = (float)this._moon.getValue("FOV3");
        this.background(this.lerpColor(-8627, this.palette[0], (float)this._moon.getValue("colorFade")));
        this.l1.beginDraw();
        this.l1.clear();
        this.l1.camera((float)this.width / 2.2f + eyeX, (float)this.height / 1.5f + eyeY, (float)this.height / 2.0f / pure.tan((float)(94.24778f / FOV1)) - (float)(this.width / 4) - eyeZ, (float)this.width / 2.0f * centerX, (float)this.height / 2.0f * centerY, centerZ, 0.0f * upX, 1.0f * upY, 0.0f * upZ);
        this.switchBlendModes(this.l1, (int)this._moon.getValue("blendMode"));
        this.switchScenes(this.l1, (int)this._moon.getValue("sceneIndex"));
        this.l1.endDraw();
        float kaleido = (float)this._moon.getValue("kaleido");
        if (kaleido > 0.0f) {
            this.kaleido(this.l1);
            this.kaleido(this.l2);
        }
        this.l2.beginDraw();
        this.l2.clear();
        this.l2.camera((float)this.width / 2.2f + eyeX, (float)this.height / 1.5f + eyeY, (float)this.height / 2.0f / pure.tan((float)(94.24778f / FOV2)) - (float)(this.width / 4) - eyeZ, (float)this.width / 2.0f * centerX, (float)this.height / 2.0f * centerY, centerZ, 0.0f * upX, 1.0f * upY, 0.0f * upZ);
        this.switchBlendModes(this.l2, (int)this._moon.getValue("blendMode2"));
        this.switchScenes(this.l2, (int)this._moon.getValue("sceneIndex2"));
        this.l2.endDraw();
        int[] nArray = new int[9];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 16;
        nArray[4] = 8;
        nArray[5] = 64;
        nArray[6] = 128;
        nArray[7] = 256;
        int[] blendmodes = nArray;
        this.tint(255, 255.0f);
        this.blendMode(blendmodes[0]);
        this.image((PImage)this.l1, 0.0f, 0.0f);
        this.blendMode(blendmodes[pure.max((int)0, (int)((int)this._moon.getValue("blendCombine"))) % blendmodes.length]);
        this.tint(255, pure.round((float)(255.0f * (float)this._moon.getValue("alpha2"))));
        this.image((PImage)this.l2, 0.0f, 0.0f);
        this.l3.beginDraw();
        this.l3.clear();
        this.l3.camera((float)this.width / 2.2f + eyeX, (float)this.height / 1.5f + eyeY, (float)this.height / 2.0f / pure.tan((float)(94.24778f / FOV3)) - (float)(this.width / 4) - eyeZ, (float)this.width / 2.0f * centerX, (float)this.height / 2.0f * centerY, centerZ, 0.0f * upX, 1.0f * upY, 0.0f * upZ);
        this.switchBlendModes(this.l3, (int)this._moon.getValue("blendMode3"));
        this.switchScenes(this.l3, (int)this._moon.getValue("sceneIndex3"));
        this.l3.endDraw();
        this.blendMode(blendmodes[pure.max((int)0, (int)((int)this._moon.getValue("blendCombine2"))) % blendmodes.length]);
        this.tint(255, pure.round((float)(255.0f * (float)this._moon.getValue("alpha3"))));
        this.image((PImage)this.l3, 0.0f, 0.0f);
        if ((int)this._moon.getValue("imgIdx") > -1) {
            this.tint(255, pure.round((float)(255.0f * (float)this._moon.getValue("imgAlpha"))));
            this.blendMode(blendmodes[pure.max((int)0, (int)((int)this._moon.getValue("blendImg"))) % blendmodes.length]);
            PImage img = this.images[pure.max((int)0, (int)((int)this._moon.getValue("imgIdx"))) % this.IMAGES];
            this.image(img, 0.0f, 0.0f, this.width, this.height);
        }
        this.blendMode(128);
        this.image(this.vignette, 0.0f, 0.0f, this.width, this.height);
        this.glow();
    }

    public void switchBlendModes(PGraphics l, int blendMode) {
        blendMode = pure.max((int)0, (int)pure.min((int)blendMode, (int)9));
        switch (blendMode) {
            case 0: {
                l.blendMode(1);
                break;
            }
            case 1: {
                l.blendMode(2);
                break;
            }
            case 2: {
                l.blendMode(4);
                break;
            }
            case 3: {
                l.blendMode(16);
                break;
            }
            case 4: {
                l.blendMode(8);
                break;
            }
            case 5: {
                l.blendMode(64);
                break;
            }
            case 6: {
                l.blendMode(128);
                break;
            }
            case 7: {
                l.blendMode(256);
                break;
            }
            case 8: {
                l.blendMode(0);
            }
        }
    }

    public void switchScenes(PGraphics l, int sceneIndex) {
        sceneIndex = pure.max((int)0, (int)pure.min((int)sceneIndex, (int)9));
        this.tickTime = (float)this._moon.getCurrentRow() / (float)this.LAST_ROW;
        switch (sceneIndex) {
            case 0: {
                break;
            }
            case 1: {
                this.scene_3D_gundamface(l);
                break;
            }
            case 2: {
                this.scene_diamond(l);
                break;
            }
            case 3: {
                this.scene_torus_tunnel(l);
                break;
            }
            case 4: {
                this.scene_cube_with_vignette(l);
                break;
            }
            case 5: {
                this.scene_torus_tunnel_side(l);
                break;
            }
            case 6: {
                this.background_circle(l);
            }
        }
    }

    public void glow() {
        int glow = (int)this._moon.getValue("glow");
        if (glow > 0) {
            float offset = 1.0f;
            this.blendMode(8);
            this.tint(255, 10.0f);
            int i = 0;
            while (i < glow) {
                this.copy(0, 0, this.width, this.height, PApplet.parseInt((float)(((float)this.width - (float)this.width * (offset += 0.01f)) / 2.0f)), PApplet.parseInt((float)(((float)this.height - (float)this.height * offset) / 2.0f)), PApplet.parseInt((float)((float)this.width * offset)), PApplet.parseInt((float)((float)this.height * offset)));
                ++i;
            }
            this.blendMode(1);
        }
    }

    public void scene_3D_gundamface(PGraphics l) {
        l.background(this.lerpColor(-8627, this.palette[0], (float)this._moon.getValue("colorFade")));
        l.strokeWeight(1.0f);
        float cameraZ = (float)this.height / 2.0f / pure.tan((float)0.5235988f);
        l.perspective(1.8479956f, (float)(this.width / this.height), cameraZ / 90.0f, cameraZ * 90.0f);
        this.randomSeed((long)this._moon.getValue("seed"));
        l.rotateZ(pure.radians((float)7.0f));
        int i = 0;
        while (i < 30) {
            int colorIndex = PApplet.parseInt((float)this.random(this.palette.length));
            int colorIndex2 = PApplet.parseInt((float)this.random(this.palette.length));
            float offsetX = this.random(this.width / 5);
            float offsetY = this.random(this.height / 3);
            float offsetZ = this.random(this.width / 3);
            float rotX = this.random(1.0f) > 0.5f ? -1 : 1;
            float rotY = this.random(1.0f) > 0.5f ? -1 : 1;
            float rotZ = this.random(1.0f) > 0.5f ? -1 : 1;
            int idx = PApplet.parseInt((float)this.random(7.0f));
            float diameter = (this.random(1.0f) * (float)this.width / 5.0f + (float)(this.width / 20)) / 2.0f;
            l.fill(this.palette[colorIndex2]);
            l.stroke(this.palette[colorIndex]);
            l.pushMatrix();
            l.translate((float)(this.width / 2) - offsetX, (float)this.height / 1.5f - offsetY, offsetZ);
            l.rotateZ(pure.radians((float)(this.tickTime * 360.0f * rotZ + (float)(i / 10))) + pure.radians((float)((float)this._moon.getValue("rotZ"))));
            l.rotateY(pure.radians((float)(this.tickTime * 360.0f * rotY + (float)(i / 10))) + pure.radians((float)((float)this._moon.getValue("rotY"))));
            l.rotateX(pure.radians((float)(this.tickTime * 360.0f * rotX + (float)(i / 10))) + pure.radians((float)((float)this._moon.getValue("rotX"))));
            switch (idx) {
                case 0: {
                    this.torus(diameter, diameter / 3.0f, l);
                    break;
                }
                case 1: {
                    l.box(diameter);
                    break;
                }
                case 2: {
                    this.cylinder(5, 0.0f, diameter, diameter * 2.0f, l);
                    break;
                }
                case 3: {
                    l.sphereDetail(8);
                    l.sphere(diameter / 2.0f);
                    break;
                }
                case 4: {
                    l.box(diameter, diameter / 3.0f, diameter * 3.0f);
                    break;
                }
                case 5: {
                    int c = 1;
                    while (c < 8) {
                        float w = diameter / 15.0f;
                        l.translate(0.0f, (float)c * w);
                        l.box(w, w, diameter * 3.0f);
                        ++c;
                    }
                    break;
                }
                case 6: {
                    int x = 0;
                    while (x < 20) {
                        int y = 0;
                        while (y < 10) {
                            l.pushMatrix();
                            float w = this.width / 50;
                            l.translate((float)x * w, (float)y * w);
                            this.cylinder(6, w / 2.0f, w / 2.0f, w / 4.0f, l);
                            l.popMatrix();
                            ++y;
                        }
                        ++x;
                    }
                    break;
                }
            }
            l.popMatrix();
            ++i;
        }
        l.blendMode(1);
        l.copy(0, 0, this.width / 2, this.height, this.width, 0, -this.width / 2, this.height);
    }

    public void scene_diamond(PGraphics l) {
        l.noStroke();
        l.pushMatrix();
        l.fill(-65536);
        l.sphere(10.0f);
        l.popMatrix();
        l.pushMatrix();
        l.fill(this.palette[0]);
        l.stroke(this.palette[0]);
        l.translate((float)(this.width / 2), (float)(this.height / 2), (float)(this.width / 3));
        l.rotateX(pure.radians((float)180.0f));
        l.rotateZ(pure.radians((float)(360.0f * this.tickTime)));
        this.cylinder(30, this.width * 2, 0.0f, this.width * 2, l);
        l.popMatrix();
        l.pushMatrix();
        l.translate((float)(this.width / 2), (float)this.width / 3.9f);
        l.rotateX(pure.radians((float)90.0f));
        l.rotateZ(pure.radians((float)(720.0f * this.tickTime)));
        l.fill(this.palette[2]);
        l.stroke(this.palette[2]);
        this.cylinder(5, this.width / 4, 0.0f, this.width / 4, l);
        l.popMatrix();
        l.pushMatrix();
        l.translate((float)(this.width / 2), (float)(this.width / 2) - (float)this.width / 17.99f);
        l.rotateX(pure.radians((float)90.0f));
        l.rotateZ(pure.radians((float)(540.0f * this.tickTime)));
        l.fill(this.palette[1]);
        l.stroke(this.palette[1]);
        this.cylinder(6, this.width / 9, 0.0f, this.width / 9, l);
        l.popMatrix();
        l.pushMatrix();
        l.translate((float)(this.width / 2), (float)(this.width / 2) + (float)this.width / 17.99f);
        l.rotateX(pure.radians((float)-90.0f));
        l.rotateZ(-pure.radians((float)(540.0f * this.tickTime)));
        l.fill(this.palette[1]);
        l.stroke(this.palette[1]);
        this.cylinder(6, this.width / 9, 0.0f, this.width / 9, l);
        l.popMatrix();
        l.pushMatrix();
        l.translate((float)(this.width / 2), (float)(this.width / 5) * 3.7f);
        l.rotateX(pure.radians((float)-90.0f));
        l.rotateZ(-pure.radians((float)(720.0f * this.tickTime)));
        l.fill(this.palette[2]);
        l.stroke(this.palette[2]);
        this.cylinder(5, this.width / 4, 0.0f, this.width / 4, l);
        l.popMatrix();
    }

    public void scene_torus_tunnel(PGraphics l) {
        l.noStroke();
        l.background(this.palette[0]);
        l.fill(this.palette[4]);
        l.stroke(this.palette[4]);
        l.pushMatrix();
        l.fill(this.palette[2]);
        l.stroke(this.palette[2]);
        l.translate((float)(this.width / 2), (float)(this.height / 2), (float)(this.width / 3));
        l.rotateX(pure.radians((float)90.0f));
        l.rotateY(pure.radians((float)90.0f));
        l.rotateZ(pure.radians((float)(720.0f * this.tickTime)));
        this.torus(this.width / 3, this.width / 10, l);
        this.torus(this.width / 20, this.width / 3, l);
        l.popMatrix();
    }

    public void scene_cube_with_vignette(PGraphics l) {
        float FOV = (float)this._moon.getValue("FOV");
        l.camera((float)this.width / 2.0f, (float)this.height / 2.0f, (float)this.height / 2.0f / pure.tan((float)(94.24778f / FOV)), (float)this.width / 2.0f, (float)this.height / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        if ((int)this._moon.getValue("scene_cube-offset") != this.offset) {
            this.previousOffset = this.offset;
            this.offset = (int)this._moon.getValue("scene_cube-offset");
            ++this.refreshX;
        }
        int min = 0;
        float max = this.palette.length - 1;
        int sides = 12;
        float angle = 360 / sides;
        int nX = this.offset;
        int nY = this.offset;
        float cube_radius = 0.078125f * (float)this.width;
        l.stroke(this.palette[this.palette.length - 1]);
        float SWITCH_EVERY = 8.0f;
        float switchTime = pure.min((float)1.0f, (float)(this.tickTime % SWITCH_EVERY / ((SWITCH_EVERY + 0.0f) / 2.0f)));
        int offsets = 0;
        while (offsets < 2) {
            float offset_rot = 15 * offsets;
            int amount_elements = 16;
            switch (offsets) {
                case 0: {
                    amount_elements = 16;
                    break;
                }
                case 1: {
                    amount_elements = 4;
                }
            }
            int elements = 0;
            while (elements < amount_elements) {
                int i = 0;
                while (i < sides) {
                    l.strokeWeight(1.0f);
                    float radius = cube_radius / 2.0f + this.noise(nX, nY + elements + offsets) * (float)this.width / 2.0f;
                    float x = pure.cos((float)(pure.radians((float)((float)i * angle)) + pure.radians((float)offset_rot))) * radius;
                    float y = pure.sin((float)(pure.radians((float)((float)i * angle)) + pure.radians((float)offset_rot))) * radius;
                    float radiusPrev = cube_radius / 2.0f + this.noise(this.previousOffset, this.previousOffset + elements + offsets) * (float)this.width / 2.0f;
                    float xPrev = pure.cos((float)(pure.radians((float)((float)i * angle)) + pure.radians((float)offset_rot))) * radiusPrev;
                    float yPrev = pure.sin((float)(pure.radians((float)((float)i * angle)) + pure.radians((float)offset_rot))) * radiusPrev;
                    x = pure.lerp((float)xPrev, (float)x, (float)switchTime);
                    y = pure.lerp((float)yPrev, (float)y, (float)switchTime);
                    l.pushMatrix();
                    l.translate((float)(this.width / 2) + x, (float)(this.height / 2) + y, 10.0f);
                    l.rotateX(pure.radians((float)-90.0f) + pure.radians((float)offset_rot));
                    l.rotateY(pure.radians((float)((float)i * angle)) + pure.radians((float)90.0f) + pure.radians((float)offset_rot));
                    l.rotateZ(pure.radians((float)((float)i * angle)) + pure.radians((float)360.0f) / this.tickTime);
                    min = 0;
                    max = 5.0f;
                    int ele = pure.floor((float)(this.noise(1.0f + (float)elements * 10.0f, 1 + elements + offsets) * (max - (float)min + 1.0f))) + min;
                    min = 1;
                    max = this.palette.length - 1;
                    int colIndexPrevious = pure.floor((float)(this.noise((float)this.previousOffset + (float)elements * 10.0f, this.previousOffset + elements + offsets) * (max - (float)min + 1.0f))) + min;
                    int colIndex = pure.floor((float)(this.noise((float)nX + (float)elements * 10.0f, nY + elements + offsets) * (max - (float)min + 1.0f))) + min;
                    this.fill(this.lerpColor(this.palette[colIndexPrevious], this.palette[colIndex], switchTime));
                    float diameter = this.noise(nX + elements * 100, nY + elements + offsets) * (0.046875f * (float)this.width);
                    float diameterPrev = this.noise(this.previousOffset + elements * 100, this.previousOffset + elements + offsets) * (0.046875f * (float)this.width);
                    float len = this.noise(nX + elements * 100, nY + elements + offsets) * (0.296875f * (float)this.width);
                    float lenPrev = this.noise(this.previousOffset + elements * 100, this.previousOffset + elements + offsets) * (0.296875f * (float)this.width);
                    switch (ele) {
                        case 0: {
                            this.cylinder(elements % 2 == 0 ? 3 : 8, pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime), pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime) / 3.0f, pure.lerp((float)lenPrev, (float)len, (float)switchTime), l);
                            break;
                        }
                        case 1: {
                            this.cylinder(elements % 2 == 0 ? 8 : 3, pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime) / 5.0f, pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime), pure.lerp((float)lenPrev, (float)len, (float)switchTime), l);
                            break;
                        }
                        case 2: {
                            l.sphereDetail(elements + 2);
                            l.rotateX(pure.radians((float)90.0f) + pure.radians((float)360.0f) / this.tickTime);
                            l.sphere(pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime));
                            break;
                        }
                        case 3: {
                            l.sphereDetail(pure.floor((float)((float)elements * 1.5f)) + 2);
                            l.rotateX(-pure.radians((float)90.0f) + pure.radians((float)360.0f) / this.tickTime);
                            l.sphere(pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime));
                            break;
                        }
                        case 4: {
                            l.box(pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime));
                            break;
                        }
                        case 5: {
                            l.box(pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime), pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime) * 3.0f, pure.lerp((float)diameterPrev, (float)diameter, (float)switchTime) * 3.0f);
                        }
                    }
                    l.popMatrix();
                    ++i;
                }
                ++elements;
            }
            ++offsets;
        }
        this.kaleido(l);
        l.noFill();
        l.pushMatrix();
        l.stroke(-857153);
        l.strokeWeight(15.0f);
        l.strokeJoin(8);
        l.strokeCap(4);
        l.translate((float)(this.width / 2), (float)(this.height / 2), 0.0625f * (float)this.width);
        l.rotateY(pure.radians((float)360.0f) / this.tickTime);
        l.rotateZ(pure.radians((float)360.0f) / this.tickTime);
        l.box(cube_radius / 0.7f);
        l.popMatrix();
        l.fill(this.palette[this.palette.length - 1]);
        l.pushMatrix();
        l.stroke(-857153);
        l.strokeWeight(1.0f);
        l.translate((float)(this.width / 2), (float)(this.height / 2), 0.140625f * (float)this.width);
        l.rotateY(pure.radians((float)360.0f) / this.tickTime);
        l.rotateZ(pure.radians((float)360.0f) / this.tickTime);
        l.box(cube_radius / 1.01f);
        l.popMatrix();
    }

    public void scene_torus_tunnel_side(PGraphics l) {
        l.fill(this.palette[this.palette.length - 1]);
        l.stroke(-857153);
        float FOV = (float)this._moon.getValue("FOV");
        l.camera(0.0f, (float)this.height / 2.0f - 100.0f, (float)this.height / 2.0f / pure.tan((float)(282.74335f / FOV)), (float)this.width / 2.0f, (float)this.height / 2.0f + 100.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        float radius = 0.3125f * (float)this.width;
        float girth = radius / 5.0f;
        int amount_x = 12;
        int amount_z = 12;
        float tOff = pure.radians((float)(this.tickTime * 360.0f));
        int z = 0;
        while (z < amount_z) {
            int x = 0;
            while (x < amount_x) {
                float offsetZ = pure.sin((float)((float)Math.PI * 2 / (float)amount_z * (float)z)) * girth;
                float offsetRadius = pure.cos((float)((float)Math.PI * 2 / (float)amount_z * (float)z)) * girth;
                float rotX = pure.sin((float)((float)Math.PI * 2 / (float)amount_x * (float)x + tOff));
                float rotY = pure.cos((float)((float)Math.PI * 2 / (float)amount_x * (float)x + tOff));
                float offsetX = rotX * (radius + offsetRadius);
                float offsetY = rotY * (radius + offsetRadius);
                l.pushMatrix();
                l.translate((float)(this.width / 2), (float)(this.height / 2), 0.0f);
                l.translate(offsetX, offsetY, offsetZ);
                this.torus(0.015625f * (float)this.width, 0.0078125f * (float)this.width, l);
                l.popMatrix();
                ++x;
            }
            ++z;
        }
        l.pushMatrix();
        l.rotateX(tOff);
        l.rotateY(tOff);
        l.translate((float)(this.width / 2), (float)(this.height / 2));
        l.popMatrix();
    }

    public void kaleido(PGraphics l) {
        l.copy(this.get(), 0, 0, this.width / 2, this.height / 2, this.width / 2, this.height / 2, -this.width / 2, -this.height / 2);
        l.copy(this.get(), this.width / 2, 0, this.width / 2, this.height / 2, this.width, this.height / 2, -this.width / 2, -this.height / 2);
        l.copy(this.get(), 0, this.height / 2, this.width / 2, this.height / 2, this.width / 2, this.height, -this.width / 2, -this.height / 2);
        l.copy(this.get(), this.width / 2, this.height / 2, this.width / 2, this.height / 2, this.width, this.height, -this.width / 2, -this.height / 2);
    }

    public void torus(float radius, float tube_radius, PGraphics l) {
        if (tube_radius == 0.0f) {
            tube_radius = radius / 2.0f;
        }
        int circle_parts = 8;
        float circle_angle = pure.radians((float)(360.0f / (float)circle_parts));
        int tube_segments = 22;
        float tube_angle = pure.radians((float)(360.0f / (float)tube_segments));
        int seg = 0;
        while (seg < tube_segments) {
            l.beginShape(18);
            int idx = 0;
            while (idx < circle_parts + 1) {
                float x1 = (radius + tube_radius * pure.cos((float)((float)idx * circle_angle + pure.radians((float)45.0f)))) * pure.cos((float)((float)seg * tube_angle + pure.radians((float)45.0f)));
                float y1 = (radius + tube_radius * pure.cos((float)((float)idx * circle_angle + pure.radians((float)45.0f)))) * pure.sin((float)((float)seg * tube_angle + pure.radians((float)45.0f)));
                float z1 = tube_radius * pure.sin((float)((float)idx * circle_angle + pure.radians((float)45.0f)));
                float x1Next = (radius + tube_radius * pure.cos((float)((float)idx * circle_angle + pure.radians((float)45.0f)))) * pure.cos((float)(((float)(seg + 1) + pure.radians((float)45.0f)) * tube_angle));
                float y1Next = (radius + tube_radius * pure.cos((float)((float)idx * circle_angle + pure.radians((float)45.0f)))) * pure.sin((float)(((float)(seg + 1) + pure.radians((float)45.0f)) * tube_angle));
                float z1Next = tube_radius * pure.sin((float)((float)idx * circle_angle + pure.radians((float)45.0f)));
                float xOff = 0.0f;
                float yOff = 0.0f;
                float zOff = 0.0f;
                l.vertex(x1 + xOff, y1 + yOff, z1 + zOff);
                l.vertex(x1Next + xOff, y1Next + yOff, z1Next + zOff);
                idx += 2;
            }
            l.endShape();
            ++seg;
        }
    }

    public void cylinder(int sides, float r1, float r2, float h, PGraphics l) {
        float y;
        float x;
        float angle = 360 / sides;
        float halfHeight = h / 2.0f;
        l.beginShape();
        int i = 0;
        while (i < sides) {
            x = pure.cos((float)pure.radians((float)((float)i * angle))) * r1;
            y = pure.sin((float)pure.radians((float)((float)i * angle))) * r1;
            l.vertex(x, y, -halfHeight);
            ++i;
        }
        l.endShape(2);
        l.beginShape();
        i = 0;
        while (i < sides) {
            x = pure.cos((float)pure.radians((float)((float)i * angle))) * r2;
            y = pure.sin((float)pure.radians((float)((float)i * angle))) * r2;
            l.vertex(x, y, halfHeight);
            ++i;
        }
        l.endShape(2);
        l.beginShape(10);
        i = 0;
        while (i < sides + 1) {
            float x1 = pure.cos((float)pure.radians((float)((float)i * angle))) * r1;
            float y1 = pure.sin((float)pure.radians((float)((float)i * angle))) * r1;
            float x2 = pure.cos((float)pure.radians((float)((float)i * angle))) * r2;
            float y2 = pure.sin((float)pure.radians((float)((float)i * angle))) * r2;
            l.vertex(x1, y1, -halfHeight);
            l.vertex(x2, y2, halfHeight);
            ++i;
        }
        l.endShape(2);
    }

    public void background_circle(PGraphics l) {
        l.beginDraw();
        l.clear();
        int amount = 20;
        float dist_x = this.width / amount;
        float dist_y = this.width / amount;
        l.stroke(90);
        float diameter = this.width / amount / 2;
        int x = -5;
        while (x < amount + 5) {
            int y = -5;
            while (y < amount + 5) {
                l.pushMatrix();
                l.translate((float)x * dist_x + (y % 2 == 0 ? dist_x / 2.0f : 0.0f), (float)y * dist_y);
                l.rotateX(pure.radians((float)(x * 15)) + pure.radians((float)(y * 15)) + pure.radians((float)(360.0f * this.tickTime)));
                l.rotateY(pure.radians((float)(720.0f * this.tickTime)) + pure.radians((float)(x * 3)) + pure.radians((float)(y * 3)));
                l.rotateZ(pure.radians((float)(720.0f * this.tickTime)) + pure.radians((float)(x * 3)) + pure.radians((float)(y * 3)));
                l.rotateX(-pure.radians((float)(720.0f * this.tickTime)) + pure.radians((float)(x * 3)) + pure.radians((float)(y * 3)));
                this.cylinder(3, 0.0f, diameter, diameter / 3.0f, l);
                l.popMatrix();
                ++y;
            }
            ++x;
        }
        l.endDraw();
    }

    public void settings() {
        this.size(1920, 1080, "processing.opengl.PGraphics3D");
        this.smooth(8);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#080808", "--hide-stop", "pure"};
        if (passedArgs != null) {
            PApplet.main((String[])pure.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

