//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID353a8afd_71ea_43b3_a831_05a2537bd204
{
    public class Class_Viewport : OperatorPart.Function
    {
        // >>> _inputids
        private enum InputId
        {
            SceneInput = 0,
            PositionX = 1,
            PositionY = 2,
            SizeX = 3,
            SizeY = 4,
            SetAspectRatio = 5,
            AspectRatio = 6
        }
        // <<< _inputids

        const String AspecRatioID = "AspectRatio";
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var SceneInput = inputs[(int)InputId.SceneInput];
            var PositionX = inputs[(int)InputId.PositionX].Eval(context).Value;
            var PositionY = inputs[(int)InputId.PositionY].Eval(context).Value;
            var Position = new Vector2(PositionX, PositionY);
            var SizeX = inputs[(int)InputId.SizeX].Eval(context).Value;
            var SizeY = inputs[(int)InputId.SizeY].Eval(context).Value;
            var Size = new Vector2(SizeX, SizeY);
            var SetAspectRatio = (int) inputs[(int)InputId.SetAspectRatio].Eval(context).Value;
            var AspectRatio = inputs[(int)InputId.AspectRatio].Eval(context).Value;
            //<<< _params
            
            using (new PropertyStasher<OperatorPartContext>(context, "Viewport"))
            {
                context.Viewport = new Viewport((int)PositionX, (int)PositionY, (int)SizeX, (int)SizeY);

                float previousAspectRatio = 0;
                bool aspectRatioWasSet = context.Variables.TryGetValue(AspecRatioID, out previousAspectRatio);
                if (SetAspectRatio < 0.5f) {
                    //
                }
                else if (SetAspectRatio < 1.5f){
                    context.Variables[AspecRatioID] = (float)SizeX / SizeY;
                }
                else {
                    context.Variables[AspecRatioID] = AspectRatio;                
                }

                SceneInput.Eval(context);

                if (SetAspectRatio > 0.5f)
                {
                    if (aspectRatioWasSet) 
                        context.Variables[AspecRatioID] = previousAspectRatio;                    
                    else
                        context.Variables.Remove(AspecRatioID);
                }
                
            }
            return context;
        }
        
    }
}
