//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.IDc2982a6b_aba2_485d_9912_5fc89f6230d5
{
    public class Class_UseImageBuffer : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            SizeWidth = 0,
            ImageBufferID = 1
        }
        //<<< _inputids
    
        private bool BuildRenderTarget(OperatorPartContext context, int width, int height) {
            var resourceChanged = ResourceManager.ValidateRenderTargetResource(ref _renderTargetResource, OperatorPart, context.D3DDevice,
                                                                               width, height);
            if (resourceChanged) {
                Utilities.DisposeObj(ref _renderTargetView);
                _renderTargetView = new RenderTargetView(context.D3DDevice, _renderTargetResource.Texture);
            }
            return resourceChanged;
        }

        public override void Dispose() {
            ResourceManager.Dispose(_renderTargetResource);
            Utilities.DisposeObj(ref _renderTargetView);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var SizeWidth = inputs[(int)InputId.SizeWidth].Eval(context).Value;
            var ImageBufferID = inputs[(int)InputId.ImageBufferID].Eval(context).Text;
            //<<< _params

            Changed = true;

            object imageResource;
            if (context.Objects.TryGetValue(ImageBufferID, out imageResource))
            {
                context.Image = ((Resource)imageResource).Texture;
                
                //Texture2D.ToFile(context.D3DDevice.ImmediateContext, context.Image, ImageFileFormat.Dds, "bufferFeedback.dds");
            }
            else
            {
                Logger.Warn(this, "Can't read image buffer with ID '{0}'. Did you forget to add the machting RenderToImage-Operator above?", ImageBufferID);
            }

            return context;
        }

        Resource _renderTargetResource;
        RenderTargetView _renderTargetView;
    }

}


