//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

using System.Collections;
using OSC;


namespace Framefield.Core.ID3c23f78f_f907_4e28_8c5a_69b6ebfcebf2
{
    public class Class_OSCMessageColor : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            OSCPath = 0,
            FrameMessages = 1
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            ValueR = 0,
            ValueG = 1,
            ValueB = 2,
            ValueA = 3
        }
        //<<< _outputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            if (Changed)
            {
                //>>> _params
                var OSCPath = inputs[(int)InputId.OSCPath].Eval(context).Text;
                var FrameMessages = inputs[(int)InputId.FrameMessages].Eval(context).Dynamic;  // Needs to be checked for null!
                //<<< _params
                
                if (FrameMessages != null)
                {
                    var dict = (IDictionary<string, OSCMessage>)FrameMessages;
                    OSCMessage msg;
                    
                    if (dict.TryGetValue(OSCPath, out msg))
                    {
                        if (msg.Values.Count != _numComponents)
                        {
                            Logger.Error(this, "Expected {0} params, got {1}",
                                              _numComponents, msg.Values.Count);
                            return context;
                        }
                       
                       // FIXME: use color OSC message instead of ffff
                       float[] components = new float[_numComponents];
                       for (int i = 0; i < _numComponents; ++i)
                       {
                           var val = msg.Values[i];
                           
                           try
                           {
                               components[i] = Convert.ToSingle(val);
                           }
                           catch (FormatException)
                           {
                              Logger.Error(this, "The {0} value {1} is not recognized as a valid Single value.",
                                                val.GetType().Name, val);
                           }                     
                           catch (OverflowException)
                           {
                              Logger.Error(this, "The {0} value {1} is outside the range of the Single type.",
                                                val.GetType().Name, val);
                           }
                           catch (InvalidCastException)
                           {
                              Logger.Error(this, "Conversion of the {0} value {1} to a Single is not supported.",
                                                val.GetType().Name, val);
                           }          
                       }
                       
                       _lastValue = new Color(components[0], components[1], components[2], components[3]);
                    }
                }
            
                Changed = false;
            }

            switch (outputIdx)
            {
                case (int)OutputId.ValueR:
                    context.Value = _lastValue.R;
                    break;
                case (int)OutputId.ValueG:
                    context.Value = _lastValue.G;
                    break;
                case (int)OutputId.ValueB:
                    context.Value = _lastValue.B;
                    break;
                case (int)OutputId.ValueA:
                    context.Value = _lastValue.A;
                    break;
            }
            
            return context;
        }

        const int _numComponents = 4;
		private string _path;
		private Color _lastValue; 
    }
}

